/*
 *  
 *  $Id: ivista.cpp 3763 2011-04-25 12:07:55Z carlos $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 */
//#define _GINKGO_TRACE
#include <iostream>
#include <api/globals.h>
#include <api/icontextoestudio.h>
#include <api/icontroladormodulo.h>
#include <api/ientorno.h>
#include "internacionalizacion.h"
#include <eventos/eventosginkgo.h>
#include <main/controllers/controladoreventos.h>

#include "ivista.h"

GNC::GCS::VistaException::VistaException(const std::string& msg, const std::string& componente, bool fatal) throw()
{
	this->cause = msg;
	this->component = componente;
	this->fatal = fatal;
}
GNC::GCS::VistaException::~VistaException() throw()
{
}

const std::string& GNC::GCS::VistaException::GetComponent() const
{
	return component;
}

const std::string& GNC::GCS::VistaException::GetCause() const {
	return cause;
}

std::string GNC::GCS::VistaException::GetFullCause() const {
	return *this;
}

bool GNC::GCS::VistaException::IsFatal()  const {
	return fatal;
}

GNC::GCS::VistaException::operator const std::string () const {
	return std::string("Excepcion en componente ") + GetComponent() + std::string(": ")  + GetCause();
}

std::ostream& operator << (std::ostream& out, const GNC::GCS::VistaException& ex)
{
	out << (const std::string&) ex;
	return out;
}

std::ostream& operator << (std::ostream& out, const GNC::GCS::VistaException* ex)
{
	if (ex != NULL) {
		out << ((const std::string)(*ex)).c_str();
	}
	else {
		out << "(NULL)";
	}
	return out;
}


/* Constructor */
GNC::GCS::IVista::IVista(const GnkPtr<GNC::GCS::IContextoEstudio>& estudio) : Estudio(new GnkPtr<GNC::GCS::IContextoEstudio>(estudio) )
{
	GTRACE(">> IVista::~IVista() " << this)
	(*Estudio)->Vista   = this;
	m_Activada       = false;
	m_Cargada        = false;
	GNC::GCS::ControladorEventos::Instance()->ProcesarEvento(new GNC::GCS::Eventos::EventView(this, GNC::GCS::Eventos::EventView::Creation));
	m_Titulo			  = _Std("Loading...");
	GTRACE("<< IVista::~IVista() " << this)
}

/* Destructor */
GNC::GCS::IVista::~IVista()
{
	if ((*Estudio)->Entorno->GetVentanaPrincipal() != NULL) {
		GNC::GCS::ControladorEventos::Instance()->ProcesarEvento(new GNC::GCS::Eventos::EventView(this, GNC::GCS::Eventos::EventView::Destruction));
	}
	GTRACE(">> IVista::~IVista() " << this)
	(*Estudio)->Vista = NULL;
	if (this->IsLocked()) {
		this->UnLock(GLOC());
	}
	// Estudio is a pointer to GnkPtr to avoid circular dependencies.
	delete Estudio;
	GTRACE("<< IVista::~IVista()" << this)
}

std::string& GNC::GCS::IVista::GetTitulo()
{
	return m_Titulo;
}

bool GNC::GCS::IVista::SoportaHerramienta(GNC::GCS::IHerramienta* )
{
	return true;
}

/* Notificacion de cambio en la configuracion */
void GNC::GCS::IVista::OnConfiguracionCambiada()
{

}

void GNC::GCS::IVista::Activar()
{
	m_Activada = true;
}

void GNC::GCS::IVista::Desactivar()
{
	m_Activada = false;
}

/* Obtiene el identificador unico del módulo al que pertenece */
const std::string& GNC::GCS::IVista::GetUIDModulo()
{
	return (*Estudio)->Modulo->GetUID();
}

/* Obtiene el modulo al que pertenece */
GNC::GCS::IControladorModulo* GNC::GCS::IVista::GetModulo()
{
	return (*Estudio)->Modulo;
}

GnkPtr<GNC::GCS::IContextoEstudio>& GNC::GCS::IVista::GetEstudio() {
	return (*Estudio);
}


bool GNC::GCS::IVista::EstaCargada()
{
	return m_Cargada;
}

bool GNC::GCS::IVista::EstaModificada()
{
	if (m_Cargada) {
		return (*Estudio)->EstaModificado();
	}
	else {
		return false;
	}
}

void GNC::GCS::IVista::SetCargada(bool cargada)
{
	m_Cargada = cargada;
}

bool GNC::GCS::IVista::Guardar()
{
	return true;
}

const std::vector<std::string> GNC::GCS::IVista::GetRutasImagenes() const
{
	if ((*Estudio)) {
		return (*Estudio)->GetRutasImagenes();
	}
	else {
		throw VistaException("Vista no inicializada");
	}
}

const std::vector<std::string> GNC::GCS::IVista::GetRutasDiagnosticos() const
{
	if ((*Estudio)) {
		return (*Estudio)->GetRutasDiagnosticos();
	}
	else {
		throw VistaException("Vista no inicializada");
	}
}

void GNC::GCS::IVista::ActivarRuta(const std::string&)
{
}
