/*
 *  
 *  $Id: ievento.h 3698 2011-04-14 12:38:49Z carlos $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 */
#pragma once

#include <ostream>
#include <string>
#include <list>
#include <limits>
#include <api/api.h>
#include <api/math/geometria.h>


#define ginkgoAmbitoGeneral  0

//----------------------------------------------------------------------------------------------------
//region "Forward Declarations"
class wxMouseEvent;
class wxKeyEvent;

namespace GNC {
	namespace GCS {
		class Contexto3D;
		class IVista;
	}
}
//endregion

namespace GNC {
	namespace GCS {

		namespace Eventos {

			//====================================================================================================
			//= Interfaz de evento
			//====================================================================================================
			class EXTAPI IEvento
			{
			public:
				//codigo de evento es obligatorio y unico para cada evento
				//el codigo ambito sirve para jerarquizar los eventos entre eventos de guardado, de widgets...
				//prioridad: 0 es la maxima prioridad, se procesaran antes los eventos cuya prioridad sea menor
				//sincronoInterfaz: el procesamiento del evento ha de ser sincrono con la interfaz?
				//vista: vista a la que esta asociado, NULL es la vista general
				IEvento(long codigoEvento, long codigoAmbito = ginkgoAmbitoGeneral, long prioridad = 100, GNC::GCS::IVista* pVista = NULL)
				{
					m_codigoEvento = codigoEvento;
					m_codigoAmbito = codigoAmbito;
					m_pVista = pVista;
					m_skip = true;
					m_prioridad=prioridad;
				}

				virtual ~IEvento()
				{
					m_pVista = NULL;
				}

				virtual bool IsEqual(IEvento evt) const
				{
					if(evt.GetCodigoEvento() == m_codigoEvento && evt.GetCodigoAmbito() == m_codigoAmbito && evt.GetVista() == m_pVista){
						return true;
					}
					else{
						return false;
					}
				}

				bool IsSkipped() const
				{
					return m_skip;
				}

				void Skip(bool skip = true)
				{
					m_skip=skip;
				}

				long GetCodigoEvento() const
				{
					return m_codigoEvento;
				}

				long GetCodigoAmbito() const
				{
					return m_codigoAmbito;
				}

				void SetAmbito(long codigoAmbito){
					m_codigoAmbito = codigoAmbito;
				}

				GNC::GCS::IVista* GetVista() const
				{
					return m_pVista;
				}

				void SetVista(GNC::GCS::IVista* pVista)
				{
					m_pVista = pVista;
				}

				long GetPrioridad() const
				{
					return m_prioridad;
				}

				void SetPrioridad(long prioridad)
				{
					m_prioridad = prioridad;
				}

				void SetNombre(const char* nombre)
				{
					m_Nombre = nombre;
				}

				void SetNombre(std::string& nombre)
				{
					m_Nombre = nombre;
				}

				const std::string& GetNombre() const
				{
					return m_Nombre;
				}

				friend std::ostream& operator<<(std::ostream& out, const IEvento& e) {
					out <<
					"[ nombre = " << e.m_Nombre.c_str() <<
					", codigo = " << e.m_codigoEvento <<
					", ambito = " << e.m_codigoAmbito <<
					", prio = "   << e.m_prioridad <<
					", vista =  " << e.m_pVista <<
					", [ ";
					e.pushInfo(out);
					out << " ] ]";
					return out;
				}

				friend std::ostream& operator<<(std::ostream& out, const IEvento* e) {
					if (e == NULL) {
						out << "[ NULL ]";
					}
					else {
						out << *e;
					}
					return out;
				}

				virtual void pushInfo(std::ostream& ) const {
				}

			protected:
				long              m_codigoEvento;
				long              m_codigoAmbito;
				long              m_prioridad;
				bool              m_skip;
				GNC::GCS::IVista* m_pVista;
				std::string       m_Nombre;
			};

			//====================================================================================================
			//= Interfaz de evento de raton
			//====================================================================================================
			class EXTAPI EventoRaton {

			public:

				typedef enum Boton {
					EB_CUALQUIERA,
					EB_IZQUIERDO,
					EB_DERECHO,
					EB_CENTRAL
				} Boton;

				typedef enum Tipo {
					ET_UNKNOWN,
					ET_ENTER,
					ET_LEAVE,
					ET_MOTION,
					ET_DOWN,
					ET_UP,
					ET_DCLICK
				} Tipo;

			public:

				inline EventoRaton(wxMouseEvent* evt, Contexto3D* pContexto)
				{
					c = pContexto;
					wX = wY = wZ = 0.0f;
					m_left = m_middle = m_right = m_any = false;
					m_leftDown = m_middleDown = m_rightDown = m_anyDown = false;
					m_tipo = ET_UNKNOWN;
					m_controlDown = m_shiftDown = m_altDown = m_metaDown = false;
					m_wheelRotation = m_wheelDelta = m_linesPerAction = 0;
					m_skip = true;
					sX = sY = 0;
					ParseWXEvent(evt);
				}

				inline ~EventoRaton()
				{

				}

				inline bool ButtonDown(Boton but = EB_CUALQUIERA) const
				{
					if (m_tipo == ET_DOWN) {
						switch (but) {
							case EB_CUALQUIERA:
								return m_any;
							case EB_IZQUIERDO:
								return m_left;
							case EB_DERECHO:
								return m_right;
							case EB_CENTRAL:
								return m_middle;
							default:
								return false;
						}
					}
					else {
						return false;
					}
				}

				inline bool ButtonDClick(Boton but = EB_CUALQUIERA) const
				{
					if (m_tipo == ET_DCLICK) {
						switch (but) {
							case EB_CUALQUIERA:
								return m_any;
							case EB_IZQUIERDO:
								return m_left;
							case EB_DERECHO:
								return m_right;
							case EB_CENTRAL:
								return m_middle;
							default:
								return false;
						}
					}
					else {
						return false;
					}
				}

				inline bool ButtonUp(Boton but = EB_CUALQUIERA) const
				{
					if (m_tipo == ET_UP) {
						switch (but) {
							case EB_CUALQUIERA:
								return m_any;
							case EB_IZQUIERDO:
								return m_left;
							case EB_DERECHO:
								return m_right;
							case EB_CENTRAL:
								return m_middle;
							default:
								return false;
						}
					}
					else {
						return false;
					}
				}

				inline bool Button(Boton but) const
				{
					switch (but) {
						case EB_CUALQUIERA:
							return m_any;
						case EB_IZQUIERDO:
							return m_left;
						case EB_DERECHO:
							return m_right;
						case EB_CENTRAL:
							return m_middle;
						default:
							return false;
					}
				}

				inline bool ButtonIsDown(Boton but) const
				{
					switch (but) {
						case EB_CUALQUIERA:
							return m_any;
						case EB_IZQUIERDO:
							return m_left;
						case EB_DERECHO:
							return m_right;
						case EB_CENTRAL:
							return m_middle;
						default:
							return false;
					}
				}

				inline bool ControlDown() const { return m_controlDown; }
				inline bool MetaDown() const { return m_metaDown; }
				inline bool AltDown() const { return m_altDown; }
				inline bool ShiftDown() const { return m_shiftDown; }

				inline bool LeftDown() const { return (m_tipo == ET_DOWN && m_left); }
				inline bool MiddleDown() const { return (m_tipo == ET_DOWN && m_middle); }
				inline bool RightDown() const { return (m_tipo == ET_DOWN && m_right); }

				inline bool LeftUp() const { return (m_tipo == ET_UP && m_left); }
				inline bool MiddleUp() const { return (m_tipo == ET_UP && m_middle); }
				inline bool RightUp() const { return (m_tipo == ET_UP && m_right); }

				inline bool LeftDClick() const { return (m_tipo == ET_DCLICK && m_left); }
				inline bool MiddleDClick() const { return (m_tipo == ET_DCLICK && m_middle); }
				inline bool RightDClick() const { return (m_tipo == ET_DCLICK && m_right); }

				inline bool LeftIsDown() const { return m_leftDown; }
				inline bool MiddleIsDown() const { return m_middleDown; }
				inline bool RightIsDown() const { return m_rightDown; }
				inline bool AnyIsDown() const { return m_anyDown; }


				inline bool Dragging() const
				{
					return (m_tipo == ET_MOTION) && ButtonIsDown(EB_CUALQUIERA);
				}

				inline bool Moving() const
				{
					return (m_tipo == ET_MOTION) && !ButtonIsDown(EB_CUALQUIERA);
				}

				inline bool Entering() const { return (m_tipo == ET_ENTER); }

				inline bool Leaving() const { return (m_tipo == ET_LEAVE); }

				inline int GetWheelRotation() const { return m_wheelRotation; }

				inline int GetWheelDelta() const { return m_wheelDelta; }

				inline int GetLinesPerAction() const { return m_linesPerAction; }

			#ifdef _WINDOWS
				inline bool IsPageScroll() const { return ((unsigned int)m_linesPerAction == UINT_MAX); }
			#else
				inline bool IsPageScroll() const { return ((unsigned int)m_linesPerAction == std::numeric_limits<unsigned int>::max()); }
			#endif

				inline void Skip(bool skip = true) { m_skip = skip;}

				inline bool GetSkipped() { return m_skip; }

				void ParseWXEvent(wxMouseEvent* evt);

			public:

				double wX;
				double wY;
				double wZ;

				GNC::GCS::Vector iP;

				int sX;
				int sY;

				Contexto3D* c;


				bool   m_left;
				bool   m_middle;
				bool   m_right;
				bool   m_any;

				bool   m_leftDown;
				bool   m_middleDown;
				bool   m_rightDown;
				bool   m_anyDown;

				Tipo   m_tipo;

				bool   m_controlDown;
				bool   m_shiftDown;
				bool   m_altDown;
				bool   m_metaDown;

				int    m_wheelRotation;
				int    m_wheelDelta;
				int    m_linesPerAction;
				bool   m_skip;
			};

			//====================================================================================================
			//= Interfaz de evento de teclado
			//====================================================================================================
			class EXTAPI EventoTeclado {

			public:
				Contexto3D* c;

			public:

				inline EventoTeclado(wxKeyEvent* evt, Contexto3D* pContexto)
				{
					c = pContexto;
					m_keyCode = 0;

					m_controlDown = false;
					m_shiftDown = false;
					m_altDown = false;
					m_metaDown = false;

					m_scanCode = false;

					m_uniChar = L'\0';

					m_rawCode = 0;
					m_rawFlags = 0;

					m_skip = true;

					ParseWXEvent(evt);
				}

				inline ~EventoTeclado()
				{

				}

				inline bool ControlDown() const { return m_controlDown; }
				inline bool ShiftDown() const { return m_shiftDown; }
				inline bool MetaDown() const { return m_metaDown; }
				inline bool AltDown() const { return m_altDown; }

				inline bool HasModifiers() const { return ControlDown() || AltDown(); }

				inline int GetKeyCode() const { return (int)m_keyCode; }

				inline wchar_t GetUnicodeKey() const { return m_uniChar; }

				inline unsigned int GetRawKeyCode() const { return m_rawCode; }

				inline unsigned int GetRawKeyFlags() const { return m_rawFlags; }

				inline void Skip(bool skip = true) { m_skip = skip;}

				inline bool GetSkipped() { return m_skip; }

				void ParseWXEvent(wxKeyEvent* evt);

			public:
				bool			  m_isKeyDown;

				long          m_keyCode;

				bool          m_controlDown;
				bool          m_shiftDown;
				bool          m_altDown;
				bool          m_metaDown;

				bool          m_scanCode;

				wchar_t       m_uniChar;

				unsigned int  m_rawCode;
				unsigned int  m_rawFlags;

				bool          m_skip;

			};

			//====================================================================================================
			//= Interfaz de subscriptor de ventos
			//====================================================================================================
			class EXTAPI ISubscriptorEventos {
			public:
				ISubscriptorEventos() { }
				~ISubscriptorEventos() { }

				// Propagacion de eventos de raton
				virtual void OnMouseEvents(GNC::GCS::Eventos::EventoRaton&) { }

				// Propagacion de eventos de teclado
				virtual void OnKeyEvents(GNC::GCS::Eventos::EventoTeclado&) { }
			};

			//====================================================================================================
			//= Interfaz de publicacion de eventos
			//====================================================================================================
			class EXTAPI IPublicadorEventos {
			public:
				typedef std::list<GNC::GCS::Eventos::ISubscriptorEventos*> ListaListeners;
				typedef ListaListeners::iterator IteradorListaListeners;

				IPublicadorEventos() { }

				~IPublicadorEventos() { }

				void InsertarListener(GNC::GCS::Eventos::ISubscriptorEventos* pListener)
				{
					IteradorListaListeners it;
					for (it = m_Listeners.begin(); it != m_Listeners.end() && (*it) != pListener; it++);
					if (it == m_Listeners.end()) {
						m_Listeners.push_back(pListener);
					}
				}

				void EliminarListener(GNC::GCS::Eventos::ISubscriptorEventos* pListener)
				{
					IteradorListaListeners it;
					for (it = m_Listeners.begin(); it != m_Listeners.end() && (*it) != pListener; it++);
					if (it != m_Listeners.end()) {
						m_Listeners.erase(it);
					}
				}
			protected:

				void PropagarEvento(GNC::GCS::Eventos::EventoRaton& evt)
				{
					for (IteradorListaListeners it = m_Listeners.begin(); it != m_Listeners.end(); it++) {
						(*it)->OnMouseEvents(evt);
					}
				}

				void PropagarEvento(GNC::GCS::Eventos::EventoTeclado& evt)
				{
					for (IteradorListaListeners it = m_Listeners.begin(); it != m_Listeners.end(); it++) {
						(*it)->OnKeyEvents(evt);
					}
				}

			protected:
				ListaListeners m_Listeners;
			};

		}
	}
}
