/*
 *  
 *  $Id: idicomizador.h 3066 2010-12-21 10:10:14Z carlos $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 */
#pragma once
#include "icontroladorimportacionpacs.h"

namespace GIL {
	namespace DICOM {
		
		typedef enum TDICOMOutputFormat {
			TDOF_VLP,
			TDOF_SC,
			TDOF_NSC,
			TDOF_SR
		} TDICOMOutputFormat;
		
		class IDICOMImg2DCM {
		public:


			/* Inicializa una conversin. IInspectCallback sirve para especificar un callback mediante el cual se pueden inspeccionar los atributos buscados.
			 *
			 * Formatos de entrada soportados:
			 *	  JPEG
			 * Formatos de salida soportados (DICOM SOP a generar):
			 *   VLP (Visible Light Photography)
			 *   SC (Secondary Capture)
			 *   NSC (New Secondary Capture)
			 */
			virtual void Inicializar(unsigned char* pixelData, const int ancho, const int alto, IInspectCallBack* pICallback = NULL, bool debug = false, TDICOMOutputFormat outputFormat = TDOF_VLP) = 0;
			virtual void Inicializar(std::string& inputFile, IInspectCallBack* pICallback = NULL, bool debug = false, TDICOMOutputFormat outputFormat = TDOF_VLP)=0;
			
			virtual int InsertarJerarquia(TipoJerarquia& base)=0;

			virtual int InsertarTagsPrivados(TipoPrivateTags& base) = 0;
			
			/* Actualiza los campos DICOM a sobreescribir */
			virtual void ActualizarCampos(IInspectCallBack* pICallback)=0;
			
			/* Realiza una conversin ya inicializada */
			virtual bool Convertir(std::string& outputFile)=0;

			virtual bool CrearSRDoc(std::string& outputFile, TipoJerarquia& base, std::list<GnkPtr<TipoPrivateTags> >& tagsPrivados) = 0;
			
			/* Resetea el estado interno */
			virtual void Reset()=0;
			
		};
	};
};
