/*
 *  
 *  $Id: icontroladormodulo.h 3648 2011-04-04 11:56:18Z tovar $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 */
#pragma once
#include <api/api.h>
#include <string>
#include <list>
#include <vector>
#include <map>
#include <exception>
#include <yasper/yasper.h>
#include "imodelointegracion.h"
#include "imodelointegracion.h"
#include "icontextoestudio.h"
#include "ivista.h"

class IPasoConfiguracion;
class IWizard;
class IPasoWizard;
class wxWindow;
class wxBitmap;

namespace GNC {
	namespace GCS {
		class IEntorno;
	}
}

class IControladorImportacionPACS;

#define GINKGO_PARAMS_SEPARATOR "="

namespace GNC {
	namespace GCS {


		/* Appender / formatter para reordenar y/o añadir tags DICOM necesarios por el controlador o vista en la importacion */
		typedef struct TagsDICOM {
			typedef std::vector<std::string> ListaArbolesPersonalizados;
			typedef std::map<std::string, int> MapaTags;

			// Vector de nombres de raices de tags DICOM que el modo necesita
			ListaArbolesPersonalizados ArbolesPersonalizados;
			// Mapa de tags a insertar/sobreescribir con sus id de raices asociadas (donde se insertaran)
			MapaTags TagsAInsertar;

		} TagsDICOM;

		class EXTAPI ModoControlador {
			public:
			class EXTAPI TipoListaModalidades : public std::list<std::string> { };

			ModoControlador(int id, const std::string& descripcion, TipoListaModalidades listaModalidades, bool abreSeriesSueltas, wxBitmap * bitmap = NULL)
			{
				this->id = id;
				this->descripcion = descripcion;
				this->bitmap = bitmap;
				this->m_listaModalidades = listaModalidades;
				this->m_abreSeriesSueltas = abreSeriesSueltas;
			}

			~ModoControlador()
			{
				m_listaModalidades.clear();
			}

			const TipoListaModalidades GetModalidades(){
				return m_listaModalidades;
			}

			const std::string& GetDescripcion(){
				return descripcion;
			}

			wxBitmap* GetBitmap(){
				return bitmap;
			}

			const int GetId(){
				return id;
			}

			bool AbreSeriesSueltas()
			{
				return m_abreSeriesSueltas;
			}

			virtual bool SupportsModalityFile(const std::string &modalidad, const std::string& transferSyntax){
				for(TipoListaModalidades::iterator it = m_listaModalidades.begin(); it!= m_listaModalidades.end(); ++it){
					if((*it) == modalidad){
						if (transferSyntax != "1.2.840.10008.1.2.4.100" && transferSyntax != "1.2.840.10008.1.2.4.101") {
							return true;
						} else {
							return false;
						}
					}
				}
				return false;
			}

		protected:
			TipoListaModalidades  m_listaModalidades;
			int id;
			std::string descripcion;
			wxBitmap* bitmap;
			bool m_abreSeriesSueltas;
		};

		class EXTAPI Plantilla{
		public:
			Plantilla(const wxBitmap& plantilla, const std::string& nombre, const std::string& descripcion = "");

			~Plantilla();

			const wxBitmap* GetImagen() const {
				return m_plantilla;
			}

			const std::string& GetNombre() const {
				return m_nombre;
			}

			const std::string& GetDescripcion() const {
				return m_descripcion;
			}

		protected:
			wxBitmap*   m_plantilla;
			std::string m_nombre;
			std::string m_descripcion;
		};

		class EXTAPI IdHL7 {
		public:
			std::string etiqueta;        // Etiqueta que usa Ginkgo para localizar el código
			std::string codigo;          // Código formal para la etiqueta
			std::string namespaceid;     // NamespaceID de la entidad asignatoria
			std::string descripcion;     // Descripcion del codigo
			std::string tipoobservacion; // Tipo de observacion. Solo se usa para Ids transportados en OBX
			std::string tipodatos;
			std::string version;			  //version of the id

			inline IdHL7()
			{
			}

			inline IdHL7(const IdHL7& o)
			{
				*this = o;
			}

			inline IdHL7(const std::string& e, const std::string& c, const std::string& d, const std::string& n, const std::string& t, const std::string& td, const std::string& v = "")
			{
				etiqueta        = e;
				codigo          = c;
				descripcion     = d;
				namespaceid     = n;
				tipoobservacion = t;
				tipodatos       = td;
				version			 = v;
			}

			inline IdHL7& operator = (const IdHL7& o)
			{
				etiqueta        = o.etiqueta;
				codigo          = o.codigo;
				descripcion     = o.descripcion;
				namespaceid     = o.namespaceid;
				tipoobservacion = o.tipoobservacion;
				tipodatos       = o.tipodatos;
				version			 = o.version;
				return *this;
			}

			inline operator const std::string () const {
				return codigo + "^" + descripcion + "^" + namespaceid;
			}
		};

		/* Controlador de módulos. Responsable de proveer una factoría de controladores de estudios y registrarlos mediante el controlador de vistas. */
		class EXTAPI IControladorModulo {
		public:
			typedef struct TPrivateTagReemplazable
			{
				typedef enum {STD, XML} TType;
				TType type;
				unsigned char id;
				TPrivateTagReemplazable (unsigned char id, TType type)
				{
					this->id = id;
					this->type = type;
				}
			} TPrivateTagReemplazable;
			typedef std::list<TPrivateTagReemplazable> TListaIdsTagsPrivados;
			//first element uid provider, second list of tags
			typedef std::map<std::string, TListaIdsTagsPrivados> TMapaTagsPrivados;

			class DescriptorSerie {
			public:
				DescriptorSerie(const std::string& uidSerie, const std::string& modalidad, const std::string& transferSyntax, GnkPtr<GIL::IModeloIntegracion> pModeloIntegracion){
					m_uidSerie = uidSerie;
					m_modalidad = modalidad;
					m_uidTransferSyntax = transferSyntax;
					m_pModeloIntegracion = pModeloIntegracion;
				}

				std::string m_uidSerie;
				std::string m_modalidad;
				std::string m_uidTransferSyntax;
				GnkPtr<GIL::IModeloIntegracion> m_pModeloIntegracion;
			};

			typedef std::list<DescriptorSerie> ListaDescriptoresSerie;
			typedef std::list<Plantilla*> TipoListaPlantillas;
			typedef std::list<IdHL7> TipoListaIdsHL7;
			typedef std::map<std::string,IdHL7> TipoMapaIdsHL7;

			/* Constructor */
			IControladorModulo(GNC::GCS::IEntorno* pEntorno, const std::string& uid, int priority, const std::string& sid = "Common");

			/* Destructor */
			virtual ~IControladorModulo();

			/* Obtiene el UID único del módulo */
			const std::string& GetUID() const
			{
				return m_UID;
			}

			/* Obtiene el SID (String Id) único del módulo. Usado para transferencia de parámetros de línea de comandos. */
			const std::string& GetSID() const
			{
				return m_SID;
			}

			const wxBitmap* GetBitmap() {
				return m_Bitmap;
			}

			/* Obtiene el Nombre del módulo (que aparece en el menú)*/
			const std::string& GetNombre() const
			{
				return m_Nombre;
			}

			virtual bool SoportaImportacion() const
			{
				return false;
			}

			//si importa series true, si importa estudios false
			virtual bool ImportaSeries() const
			{
				return true;
			}

			virtual TipoListaPlantillas& GetPlantillas() {
				return m_listaPlantillas;
			}

			virtual void GetPasosImportacion(IWizard* , std::list<IPasoWizard*> &, wxWindow* , std::string &, GnkPtr<GIL::IModeloIntegracion> ){

			}

			virtual void GetPasosConfiguracion( std::list<IPasoConfiguracion*> &, wxWindow* ){

			}

			// Metodos de inicializacion de configuracion del modulo
			void RegistrarConfiguracion();

			//registra las vistas
			virtual void RegistrarVistas() = 0;

			const IdHL7 GetIdInforme(const std::string& key) const;

			const IdHL7 GetIdEstudioHL7(const std::string& key) const;

			const IdHL7 GetIdRegistroHL7(const std::string& key) const;

			/* Abre un estudio de manera no interactiva desde un directorio y devuelve su controlador específico */
			virtual GNC::GCS::IVista* AbrirVista(int modo, ListaDescriptoresSerie& series, const std::string& uidEstudioDiagnostico = "") = 0;


		//region "Manipulacion de paneles extra (Herramientas, etc.)"

			virtual void InsertarPaneles()
			{
			}

			virtual void EliminarPaneles()
			{
			}

			virtual void MostrarPaneles(bool  = true, bool  = true)
			{
			}

			virtual void OcultarPaneles(bool  = true, bool  = true)
			{
			}
		//endregion


			typedef std::vector<ModoControlador*> ListaModos;
			typedef std::vector<ModoControlador*>::iterator IteradorListaModos;

			virtual ModoControlador* GetModo(int id) {
				if (id >= (int)m_ListaModos.size()) {
					return NULL;
				}
				else {
					return m_ListaModos[id];
				}
			}

			virtual ListaModos& GetListaModos(){
				return m_ListaModos;
			}

			virtual int GetPriority()
			{
				return m_priority;
			}

			virtual void GetTagsPrivadosReplace(GNC::GCS::IControladorModulo::TMapaTagsPrivados& mapaTags);
			virtual GNC::GCS::IContextoEstudio::TModoFuncionamiento GetDiagnosticMode();

		protected:
			GNC::GCS::IEntorno*  m_pEntorno;
			ListaModos           m_ListaModos;
			TipoListaPlantillas  m_listaPlantillas;

			TipoListaIdsHL7      m_ListaInformes;
			TipoMapaIdsHL7       m_ListaEstudios;
			TipoMapaIdsHL7       m_ListaRegistros;

			std::string m_UID;
			std::string m_SID;
			std::string m_Nombre;
			std::string m_CopyRight;
			std::string m_Author;
			int         m_VersionMayor;
			int         m_VersionMinor;
			int         m_VersionRelease;
			std::string m_CodeName;
			std::string m_Version;
			int		    m_priority;

			wxBitmap*   m_Bitmap;
		};
	}
}
