/*
 *  
 *  $Id$
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 */
//#define _GINKGO_TRACE
#include <api/globals.h>
#include <wx/config.h>
#include "icontroladormodulo.h"
#include <wx/bitmap.h>
#define TAG_WIDGETS					    0xb
#define UID_TAGS_PRIVADOS_COMUNES	 "100"

GNC::GCS::Plantilla::Plantilla(const wxBitmap& plantilla, const std::string& nombre, const std::string& descripcion)
{
	m_nombre      = nombre;
	m_descripcion = descripcion;
	m_plantilla   = new wxBitmap(plantilla);
}

GNC::GCS::Plantilla::~Plantilla()
{
	delete m_plantilla;
}

GNC::GCS::IControladorModulo::IControladorModulo(GNC::GCS::IEntorno* pEntorno, const std::string& uid, int priority, const std::string& sid)
{
	m_pEntorno       = pEntorno;
	m_UID            = uid;
	m_SID            = sid;
	m_VersionMayor   = 0;
	m_VersionMinor   = 0;
	m_VersionRelease = 0;
	m_Bitmap         = NULL;
	m_priority = priority;
	GTRACE("IControladorModulo::IControladorModulo( " << m_UID << ", " << m_SID << " )");
}

/* Destructor */
GNC::GCS::IControladorModulo::~IControladorModulo()
{
	GTRACE(">>IControladorModulo::~IControladorModulo( " << m_UID << ", " << m_SID << " )");
	for(TipoListaPlantillas::iterator it = m_listaPlantillas.begin(); it!= m_listaPlantillas.end(); ++it){
		delete (*it);
	}
	GTRACE("<<IControladorModulo::~IControladorModulo( " << m_UID << ", " << m_SID << " )");
}

void GNC::GCS::IControladorModulo::RegistrarConfiguracion()
{
	bool written = false;

	wxString key;
	wxString val;

	wxConfigBase* config = wxConfigBase::Get();

	config->SetPath( wxString::FromUTF8("/GinkgoCore/HCE/Plantillas/") );

	for (TipoListaIdsHL7::iterator it = m_ListaInformes.begin(); it != m_ListaInformes.end(); it++)
	{
		const IdHL7& i = *it;

		key = wxString::FromUTF8(i.etiqueta.c_str());
		if ( !config->Read( key, &val ) ) {
			config->Write( key, wxString::FromUTF8( ( (const std::string)i).c_str() ) );
			written = true;
		}
	}

	for (TipoMapaIdsHL7::iterator it = m_ListaEstudios.begin(); it != m_ListaEstudios.end(); it++)
	{
		IdHL7& i = (*it).second;

		config->SetPath(wxString::FromUTF8("/GinkgoCore/HCE/") + wxString::FromUTF8(m_SID.c_str()) + wxString::FromUTF8(i.version.c_str()) + wxString::FromUTF8("/") + wxString::FromUTF8(i.etiqueta.c_str()));

		key = wxString::FromUTF8("Codigo");
		if ( !config->Read(key, &val) ) {
			val = wxString::FromUTF8(i.codigo.c_str());
			config->Write(key, val);
			written = true;
		}
		else {
			i.codigo = std::string(val.ToUTF8());
		}
		key = wxString::FromUTF8("Descripcion");
		if ( !config->Read(key, &val) ) {
			config->Write(key, wxString::FromUTF8(i.descripcion.c_str()));
			written = true;
		}
		else {
			i.descripcion = std::string(val.ToUTF8());
		}
		key = wxString::FromUTF8("NamespaceID");
		if ( !config->Read(key, &val) ) {
			config->Write(key, wxString::FromUTF8(i.namespaceid.c_str()));
			written = true;
		}
		else {
			i.namespaceid = std::string(val.ToUTF8());
		}
		key = wxString::FromUTF8("TipoOBX");
		if ( !config->Read(key, &val) ) {
			config->Write(key, wxString::FromUTF8(i.tipoobservacion.c_str()));
			written = true;
		}
		else {
			i.tipoobservacion = std::string(val.ToUTF8());
		}
	}

	for (TipoMapaIdsHL7::iterator it = m_ListaRegistros.begin(); it != m_ListaRegistros.end(); it++)
	{
		IdHL7& i = (*it).second;

		config->SetPath(wxString::FromUTF8("/GinkgoCore/HCE/") + wxString::FromUTF8(m_SID.c_str()) + wxString::FromUTF8(i.version.c_str()) + wxString::FromUTF8("/") + wxString::FromUTF8(i.etiqueta.c_str()));

		key = wxString::FromUTF8("Codigo");
		if ( !config->Read(key, &val) ) {
			config->Write(key, wxString::FromUTF8(i.codigo.c_str()));
			written = true;
		}
		else {
			i.codigo = std::string(val.ToUTF8());
		}
		key = wxString::FromUTF8("Descripcion");
		if ( !config->Read(key, &val) ) {
			config->Write(key, wxString::FromUTF8(i.descripcion.c_str()));
			written = true;
		}
		else {
			i.descripcion = std::string(val.ToUTF8());
		}
		key = wxString::FromUTF8("NamespaceID");
		if ( !config->Read(key, &val) ) {
			config->Write(key, wxString::FromUTF8(i.namespaceid.c_str()));
			written = true;
		}
		else {
			i.namespaceid = std::string(val.ToUTF8());
		}
		key = wxString::FromUTF8("TipoOBX");
		if ( !config->Read(key, &val) ) {
			config->Write(key, wxString::FromUTF8(i.tipoobservacion.c_str()));
			written = true;
		}
		else {
			i.tipoobservacion = std::string(val.ToUTF8());
		}
		key = wxString::FromUTF8("TipoDato");
		if ( !config->Read(key, &val) ) {
			config->Write(key, wxString::FromUTF8(i.tipodatos.c_str()));
			written = true;
		}
		else {
			i.tipodatos = std::string(val.ToUTF8());
		}
	}

	if (written) {
		config->Flush();
	}

}

const GNC::GCS::IdHL7 GNC::GCS::IControladorModulo::GetIdEstudioHL7(const std::string& key) const
{

	IdHL7 id;

	TipoMapaIdsHL7::const_iterator it = m_ListaEstudios.find(key);
	if (it != m_ListaEstudios.end()) {
		return (*it).second;
	}
	return id;
}

const GNC::GCS::IdHL7 GNC::GCS::IControladorModulo::GetIdRegistroHL7(const std::string& key) const
{
	IdHL7 id;
	TipoMapaIdsHL7::const_iterator it = m_ListaRegistros.find(key);
	if (it != m_ListaRegistros.end()) {
		return (*it).second;
	}
	return id;

}

void GNC::GCS::IControladorModulo::GetTagsPrivadosReplace(GNC::GCS::IControladorModulo::TMapaTagsPrivados& mapaTags)
{
	if (mapaTags.find(UID_TAGS_PRIVADOS_COMUNES) == mapaTags.end()) {
		mapaTags[UID_TAGS_PRIVADOS_COMUNES] = TListaIdsTagsPrivados();
	}

	mapaTags[UID_TAGS_PRIVADOS_COMUNES].push_back(GNC::GCS::IControladorModulo::TPrivateTagReemplazable(TAG_WIDGETS, GNC::GCS::IControladorModulo::TPrivateTagReemplazable::XML));
}

GNC::GCS::IContextoEstudio::TModoFuncionamiento GNC::GCS::IControladorModulo::GetDiagnosticMode()
{
	return GNC::GCS::IContextoEstudio::TMF_UNDiagnostico;
}
