/*
 *  
 *  $Id: icontroladorextensiones.h 3500 2011-03-14 19:41:29Z tovar $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 */
#pragma once
#include "api.h"
#include <list>
#include <map>
#include <string>

#include "icontroladormodulo.h"
#include "observers/iextensionsobserver.h"

#include <prvext/prvext.h>

class wxDynamicLibrary;

namespace GADVAPI {

	class EXTAPI PrivateExtensionManager : private std::map<std::string, PrivateExtension*>
	{
	public:
		
		typedef std::map<std::string, PrivateExtension*> Base;
		typedef Base::iterator iterator;

		PrivateExtensionManager();
		~PrivateExtensionManager();

		PrivateExtension* GetExtension(std::string nombre);

		void Load();
		void UnLoad();
		void Reload();

		iterator begin();
		iterator end();

	private:
		bool Registrar(PrivateExtension* ext);

		typedef std::list<wxDynamicLibrary*> ListaInstancias;
		ListaInstancias m_instancias;
		bool m_Loaded;
	};
}

namespace GNC {
	namespace GCS {

		class EXTAPI IControladorExtensiones {
		public:
			virtual GADVAPI::PrivateExtensionManager& GetPrivateExtensionsManager() = 0;

		protected:
			IControladorExtensiones();
			~IControladorExtensiones();
		};
	}
}

