
#############################################################################################

MACRO(PACKAGE_RULES TPROJECT ARCH DEST)
	CONFIGURE_FILE(${CMAKE_CURRENT_SOURCE_DIR}/ginkgo-launcher.in ${DEST}/ginkgo)
	ADD_CUSTOM_COMMAND(
		TARGET ${TPROJECT}
		POST_BUILD
		COMMAND echo "\\>\\>\\> Purging dist/"
		COMMAND rm -f \"${DEST}/ginkgo-${ARCH}\" "${DEST}/*.so*"
		COMMAND rm -rf \"${DEST}/Plugins\" \"${DEST}/lang\"
		COMMAND echo "\\>\\>\\> Making subdirs Plugins, lang, lang/es"
		COMMAND mkdir -p \"${DEST}/Plugins\"
		COMMAND mkdir -p \"${DEST}/lang/es\" \"${DEST}/lang/ja\"

		COMMAND echo "\\>\\>\\> Copying ginkgo binary to dist/"
		COMMAND cp "${CMAKE_CURRENT_BINARY_DIR}/ginkgo/ginkgo-${ARCH}" "${DEST}/ginkgo-${ARCH}"
		COMMAND echo "\\>\\>\\> changing RPATH of ginkgo"
		COMMAND chrpath "${DEST}/ginkgo-${ARCH}" -r "." ">/dev/null"
		COMMAND echo "\\>\\>\\> Stripping ginkgo"
		COMMAND strip -s "${DEST}/ginkgo-${ARCH}"
		COMMAND echo "\\>\\>\\> Applying perms"
		COMMAND chmod +x "${DEST}/ginkgo-${ARCH}" "${DEST}/ginkgo"

		COMMAND echo "\\>\\>\\> Copying dlls to dist \\(${ARCH}\\)/"
		COMMAND cp -a "${CMAKE_CURRENT_BINARY_DIR}/../../dll/${OS}-${ARCH}/*/lib/${DTYPE}/*.so*" \"${DEST}\"
		COMMAND echo "\\>\\>\\> Applying perms"
		COMMAND chmod -x "${DEST}/*so*"

		COMMAND echo "\\>\\>\\> Copying CADxCore dll to dist/"
		COMMAND cp -a ${CMAKE_CURRENT_BINARY_DIR}/cadxcore/libCADxCore.so* "${DEST}"
		COMMAND echo "\\>\\>\\> changing RPATH of libCADxCore.so"
		COMMAND chrpath "${DEST}/libCADxCore.so" -r "." ">/dev/null"
		COMMAND echo "\\>\\>\\> Stripping CADxCore"
		COMMAND strip -s "${DEST}/libCADxCore.so"
		COMMAND echo "\\>\\>\\> Installing translations"
		COMMAND cp "${CMAKE_CURRENT_SOURCE_DIR}/cadxcore/lang/es/ginkgocadxcore.mo" "${DEST}/lang/es"
		COMMAND cp "${CMAKE_CURRENT_SOURCE_DIR}/cadxcore/lang/es/wxstd.mo" "${DEST}/lang/es"
		COMMAND cp "${CMAKE_CURRENT_SOURCE_DIR}/cadxcore/lang/ja/ginkgocadxcore.mo" "${DEST}/lang/ja"
		COMMAND cp "${CMAKE_CURRENT_SOURCE_DIR}/cadxcore/lang/ja/wxstd.mo" "${DEST}/lang/ja"
	)

	IF(BUILD_VISUALIZATION_EXT)
		ADD_CUSTOM_COMMAND(
   	   TARGET ${TPROJECT}
      	POST_BUILD
			COMMAND echo "\\>\\>\\> Copying visualizator dll to dist/Plugins \\(${ARCH}\\)"
			COMMAND cp -a ${CMAKE_CURRENT_BINARY_DIR}/visualizator/libvisualizator.so* "${DEST}/Plugins"
			COMMAND echo "\\>\\>\\> changing RPATH of Plugins/libvisualizator.so"
			COMMAND chrpath "${DEST}/Plugins/libvisualizator.so" -d ">/dev/null"
			COMMAND echo "\\>\\>\\> Stripping visualizator dll"
			COMMAND strip -s "${DEST}/Plugins/libvisualizator.so"
			COMMAND echo "\\>\\>\\> Installing translations"
			COMMAND cp "${CMAKE_CURRENT_SOURCE_DIR}/visualizator/lang/es/visualizator.mo" "${DEST}/lang/es"
   	   COMMAND cp "${CMAKE_CURRENT_SOURCE_DIR}/visualizator/lang/ja/visualizator.mo" "${DEST}/lang/ja"
		)
	ENDIF()


	IF(BUILD_DERMATHOLOGY_EXT)
		ADD_CUSTOM_COMMAND(
         TARGET ${TPROJECT}
         POST_BUILD
			COMMAND echo "\\>\\>\\> Copying dermatologia dll to dist/Plugins \\(${ARCH}\\)"
			COMMAND cp -a ${CMAKE_CURRENT_BINARY_DIR}/dermatologia/libdermatologia.so* "${DEST}/Plugins"
			COMMAND echo "\\>\\>\\> changing RPATH of Plugins/libdermatologia.so"
			COMMAND chrpath "${DEST}/Plugins/libdermatologia.so" -d ">/dev/null"
			COMMAND echo "\\>\\>\\> Stripping dermatologia dll"
			COMMAND strip -s "${DEST}/Plugins/libdermatologia.so"
			COMMAND echo "\\>\\>\\> Installing translations"
			COMMAND cp "${CMAKE_CURRENT_SOURCE_DIR}/dermatologia/lang/es/derma.mo" "${DEST}/lang/es"	
		)
	ENDIF()

	IF(BUILD_OPHTALMOLOGY_EXT)
		ADD_CUSTOM_COMMAND(
         TARGET ${TPROJECT}
         POST_BUILD
			COMMAND echo "\\>\\>\\> Copying oftalmologia dll to dist/Plugins \\(${ARCH}\\)"
			COMMAND cp -a ${CMAKE_CURRENT_BINARY_DIR}/oftalmologia/liboftalmologia.so* "${DEST}/Plugins"
			COMMAND echo "\\>\\>\\> changing RPATH of Plugins/liboftalmologia.so"
			COMMAND chrpath "${DEST}/Plugins/liboftalmologia.so" -d ">/dev/null"
			COMMAND echo "\\>\\>\\> Stripping oftalmologia dll"
			COMMAND strip -s "${DEST}/Plugins/liboftalmologia.so"
	
			COMMAND echo "\\>\\>\\> Installing translations"
			COMMAND cp "${CMAKE_CURRENT_SOURCE_DIR}/oftalmologia/lang/es/oftal.mo" "${DEST}/lang/es"
		)
	ENDIF()

	IF(BUILD_DERMATHOLOGY_EXT OR BUILD_OPHTALMOLOGY_EXT)
		ADD_CUSTOM_COMMAND(
         TARGET ${TPROJECT}
         POST_BUILD
			COMMAND echo "\\>\\>\\> Installing translations"
			COMMAND cp "${CMAKE_CURRENT_SOURCE_DIR}/lib_activation/lang/es/lib_activation.mo" "${DEST}/lang/es"
		)
	ENDIF()

ENDMACRO(PACKAGE_RULES)

#############################################################################################

MACRO(ADD_GINKGO_DEFINITIONS)
	
	ADD_GLOBAL_GINKGO_DEFINITIONS()
	
	ADD_DEFINITIONS(-DLINUX)
	
ENDMACRO(ADD_GINKGO_DEFINITIONS)

#############################################################################################

MACRO(ADD_EXTENSION_DEFINITIONS)
	
	ADD_GLOBAL_EXTENSION_DEFINITIONS()
		
ENDMACRO(ADD_EXTENSION_DEFINITIONS)

#############################################################################################

MACRO(ADD_CORE_DEFINITIONS)
	
	ADD_GLOBAL_CORE_DEFINITIONS()
	
ENDMACRO(ADD_CORE_DEFINITIONS)

#############################################################################################

MACRO(SET_CUSTOM_wxWidgets_PACKAGE)
	SET(wxWidgets_FOUND TRUE)
	SET(wxWidgets_defines -D_FILE_OFFSET_BITS=64 -D_LARGE_FILES -D__WXGTK__ -DHAVE_CONFIG_H -D_REENTRANT)
	SET(wxWidgets_INCLUDE_DIR
		${CMAKE_CURRENT_SOURCE_DIR}/../dll/${OS}-${ARCH}/WX-2.8.11/gtk2-unicode-${DTYPE}-2.8
		${CMAKE_CURRENT_SOURCE_DIR}/../dll/${OS}-${ARCH}/WX-2.8.11/include
	)
	IF (DEBUG)
		SET(wxWidgets_LIBRARIES wx_gtk2ud-2.8 wx_gtk2ud_gl-2.8)
	ELSE()
		SET(wxWidgets_LIBRARIES wx_gtk2u-2.8 wx_gtk2u_gl-2.8)
	ENDIF()
	
	SET(wxWidgets_DIR ${CMAKE_CURRENT_SOURCE_DIR}/../dll/${OS}-${ARCH}/WX-2.8.11/lib/${DTYPE})
ENDMACRO()

MACRO(SET_CUSTOM_VTK_PACKAGE)
	SET(VTK_FOUND TRUE)
	SET(VTK_defines -DVTK_DEBUG_LEAKS)
	SET(VTK_INCLUDE_DIR ${CMAKE_CURRENT_SOURCE_DIR}/../dll/${OS}-${ARCH}/VTK-5.6.1/include)
	SET(VTK_LIBRARIES
		vtkCommon vtkGraphics vtkFiltering vtkHybrid vtkIO vtkRendering vtkImaging
		vtkGenericFiltering vtkWidgets vtkftgl vtkVolumeRendering vtkexoIIc vtkDICOMParser
		vtkjpeg vtktiff vtkpng vtkzlib vtkexpat vtksys vtkfreetype
	)
	SET(VTK_DIR ${CMAKE_CURRENT_SOURCE_DIR}/../dll/${OS}-${ARCH}/VTK-5.6.1/lib/${DTYPE})
ENDMACRO()

MACRO(SET_CUSTOM_ITK_PACKAGE)
	SET(ITK_FOUND TRUE)
	SET(ITK_defines)
	SET(ITK_INCLUDE_DIR
		${CMAKE_CURRENT_SOURCE_DIR}/../dll/${OS}-${ARCH}/ITK-3.20.0/include
		${CMAKE_CURRENT_SOURCE_DIR}/../dll/${OS}-${ARCH}/ITK-3.20.0/include/gdcm/src
		${CMAKE_CURRENT_SOURCE_DIR}/../dll/${OS}-${ARCH}/ITK-3.20.0/include
		${CMAKE_CURRENT_SOURCE_DIR}/../dll/${OS}-${ARCH}/ITK-3.20.0/include/Common
		${CMAKE_CURRENT_SOURCE_DIR}/../dll/${OS}-${ARCH}/ITK-3.20.0/include/IO
		${CMAKE_CURRENT_SOURCE_DIR}/../dll/${OS}-${ARCH}/ITK-3.20.0/include/BasicFilters
		${CMAKE_CURRENT_SOURCE_DIR}/../dll/${OS}-${ARCH}/ITK-3.20.0/include/Algorithms
		${CMAKE_CURRENT_SOURCE_DIR}/../dll/${OS}-${ARCH}/ITK-3.20.0/include/Numerics
		${CMAKE_CURRENT_SOURCE_DIR}/../dll/${OS}-${ARCH}/ITK-3.20.0/include/Numerics/Statistics
		${CMAKE_CURRENT_SOURCE_DIR}/../dll/${OS}-${ARCH}/ITK-3.20.0/include/Utilities
		${CMAKE_CURRENT_SOURCE_DIR}/../dll/${OS}-${ARCH}/ITK-3.20.0/include/Utilities/vxl/core
		${CMAKE_CURRENT_SOURCE_DIR}/../dll/${OS}-${ARCH}/ITK-3.20.0/include/Utilities/vxl/vcl
		${CMAKE_CURRENT_SOURCE_DIR}/../dll/${OS}-${ARCH}/ITK-3.20.0/include/gdcm/src
	)
	SET(ITK_LIBRARIES
		ITKCommon ITKIO ITKMetaIO ITKAlgorithms itkgdcm itksys itkgdcm
		itkjpeg8 itkjpeg12 itkjpeg16 itktiff itkpng itkzlib itkopenjpeg
		ITKDICOMParser itkv3p_netlib itkvcl itkvnl itkvnl_algo itkvnl_inst
		ITKniftiio ITKStatistics ITKBasicFilters ITKNrrdIO ITKMetaIO ITKznz
	)
	SET(ITK_DIR ${CMAKE_CURRENT_SOURCE_DIR}/../dll/${OS}-${ARCH}/ITK-3.20.0/lib/${DTYPE})
ENDMACRO()

MACRO(SET_CUSTOM_DCMTK_PACKAGE)
	SET(DCMTK_FOUND TRUE)
	SET(DCMTK_defines)
	SET(DCMTK_INCLUDE_DIR
		${CMAKE_CURRENT_SOURCE_DIR}/../dll/${OS}-${ARCH}/DCMTK-3.6.0/include
	)
	SET(DCMTK_LIB
		dcmdata dcmtls dcmnet ofstd oflog dcmjpeg dcmimage
		dcmimgle dcmsr ijg8 ijg12 ijg16
	)
	SET(DCMTK_DIR ${CMAKE_CURRENT_SOURCE_DIR}/../dll/${OS}-${ARCH}/DCMTK-3.6.0/lib/${DTYPE})
ENDMACRO()
