/*
 *  
 *  $Id: visualizator.cpp 4555 2012-01-17 10:03:03Z tovar $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
#include "visualizator.h"
#include <visualizator/license.h>
#include "visualizator/controllers/visualizatorcontroller.h"
#include <api/ientorno.h>
#include <iostream>
#include <wx/msgdlg.h>
#include <visualizator/resources/logo_visualizator.h>

#if defined(_WIN32) && defined(_GINKGO_DEBUG)
//#include <vld.h>
#endif

IMPLEMENT_PrivateExtension(GNKVisualizatorExtension)


GNKVisualizatorExtension::GNKVisualizatorExtension():PrivateExtension(EXT_SID, EXT_PROVIDER, EXT_DESCRIPTION, EXT_VERSION, EXT_SUBVERSION, EXT_RELEASE, EXT_BUILD, EXT_CODENAME, EXT_UPDATEURL, logo_visualizator, sizeof(logo_visualizator))
{
}

GNKVisualizatorExtension::~GNKVisualizatorExtension()
{
}
PrivateExtension::TListControllers GNKVisualizatorExtension::InitializeLibrary(GNC::GCS::IEntorno* pEntorno)
{
	PrivateExtension::TListControllers list;
	list.push_back(new GNKVisualizator::ControladorAtencionPrimaria(pEntorno));
	return list;
}
bool GNKVisualizatorExtension::IsActivated()
{
	return true;
}
void GNKVisualizatorExtension::ShowActivationDialog(wxWindow* pParent)
{
	wxMessageBox(_("Ginkgo CADx visualizator is Open Source"), _("Info"));
}

