/*
 *  
 *  $Id: wxwizardginkgobase.cpp 4711 2012-02-16 08:43:55Z tovar $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
#include "wxwizardginkgobase.h"
#include <resources/ginkgoresourcemanager.h>
#include <main/controllers/inactivitycontroller.h>

wxWizardGinkgoBase::wxWizardGinkgoBase( wxWindow* parent):
wxWizardGinkgoBaseWx(parent)
{
	//stops inactivity monitor
	GNC::GCS::InactivityController::Instance()->StopsMonitoring();
	//
}

wxWizardGinkgoBase::~wxWizardGinkgoBase()
{
	//starts inactivity monitor
	GNC::GCS::InactivityController::Instance()->RestartMonitoring();
	//
}

void wxWizardGinkgoBase::SiguientePaso(){
	wxCommandEvent evt;
	OnSiguienteClick(evt);
}

void wxWizardGinkgoBase::EnableSiguiente(bool enable){
	m_pBSiguiente->Enable(enable);
}

void wxWizardGinkgoBase::EnableAnterior(bool enable) {
	m_pBAnterior->Enable(enable);
}

void wxWizardGinkgoBase::EnableCancelar(bool enable) {
	m_pBCerrar->Enable(enable);
}

void wxWizardGinkgoBase::OnSize(wxSizeEvent& event)
{
	event.Skip(true);
}

