/*
 *  
 *  $Id: herramientareset.cpp 4478 2011-12-13 11:55:00Z carlos $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
//#define _GINKGO_TRACE
#include <wx/menu.h>
#include <api/globals.h>
#include "herramientareset.h"
#include <main/controllers/controladoreventos.h>
#include <eventos/eventosginkgo.h>


#ifdef __DEPRECATED
#undef __DEPRECATED
#endif

#include <vtkObject.h>
#include <vtkSmartPointer.h>
#include <vtkPointData.h>
#include <vtkImageData.h>
#include <vtkLookupTable.h>
#include <vtkImageActor.h>
#include <vtkRenderer.h>
#include <vtkRenderWindow.h>
#include <vtkRenderWindowInteractor.h>
#include <vtk/vtkginkgoimageviewer.h>
#include <resources/ginkgoresourcemanager.h>

//----------------------------------------------------------------------

namespace GNC {
	namespace GUI {
		class EventHandlerReset: public wxEvtHandler {
		public:
			EventHandlerReset(wxWindow* pParent, GNC::HerramientaReset* pHerramienta):wxEvtHandler()
			{
				m_pParent = pParent;
				m_pHerramienta=pHerramienta;
				m_pParent->Connect(pHerramienta->ID, wxEVT_COMMAND_MENU_SELECTED, wxCommandEventHandler( EventHandlerReset::OnActivarResetClick),NULL,this);
				m_pParent->Connect(pHerramienta->ID, wxEVT_UPDATE_UI, wxUpdateUIEventHandler(EventHandlerReset::OnUpdateResetUI),NULL,this);
			}

			~EventHandlerReset()
			{
				m_pParent->Disconnect(wxID_ANY, wxEVT_COMMAND_MENU_SELECTED, wxCommandEventHandler( EventHandlerReset::OnActivarResetClick),NULL,this);
				m_pParent->Disconnect(wxID_ANY, wxEVT_UPDATE_UI, wxUpdateUIEventHandler(EventHandlerReset::OnUpdateResetUI),NULL,this);
				m_pParent = NULL;
				m_pHerramienta = NULL;
			}

			void OnActivarResetClick( wxCommandEvent& event )
			{
				m_pHerramienta->SolicitarActivacion(GNC::GCS::TriggerButton().EnableLeft());
				event.Skip(false);
			}

			void OnUpdateResetUI(wxUpdateUIEvent& event) {
				event.Enable(m_pHerramienta->Habilitada());
			}

			GNC::HerramientaReset* m_pHerramienta;
			wxWindow* m_pParent;
		};


		class MenuHerramientaReset : public wxMenuItem {
		public:
			MenuHerramientaReset(wxWindow* pParent, const wxString& nombre, wxMenu* pMenuPadre, GNC::HerramientaReset* pHerramienta):wxMenuItem(pMenuPadre,pHerramienta->ID,nombre,nombre,wxITEM_NORMAL) {
				pEventHandler = new EventHandlerReset(pParent,pHerramienta);
#ifdef __WXMSW__
				SetBitmaps(GinkgoResourcesManager::IconosMenus::GetIcoReset());
				//#else
				//	SetBitmap(GinkgoResourcesManager::BarraRejilla::GetIcoVerRejilla());
#endif
			}

			~MenuHerramientaReset() {
				if(pEventHandler != NULL) {
					delete pEventHandler;
					pEventHandler = NULL;
				}
			}

			EventHandlerReset* pEventHandler;
		};
	}
}


GNC::HerramientaReset::HerramientaReset()
{
	m_Descripcion = _Std("Reset window level and zoom");
	m_IsMenu = true;
	m_Icono = GinkgoResourcesManager::IconosMenus::GetIcoReset();
}

GNC::HerramientaReset::~HerramientaReset()
{
}

bool GNC::HerramientaReset::AppendInMenu(wxWindow* pParent, wxMenu* pMenuParent)
{
	pMenuParent->Append(new GNC::GUI::MenuHerramientaReset(pParent,wxString::FromUTF8(m_Descripcion.c_str()),pMenuParent,this));
	return true;
}

//region "Realizacion de la interfaz IHerramienta"

void GNC::HerramientaReset::CrearPaneles( wxPanel* /*pParent*/ )
{
	m_pAbstractPanelHerramientaOpciones =  NULL;
}

void GNC::HerramientaReset::SolicitarActivacion(const GNC::GCS::TriggerButton&)
{
	//TODO ARREGLAR EL RESET EN FUNCION DE LOS CAMBIOS EN WIDGETS!!! lo normal es que lance un evento de visualización modificada
	GTRACE("GNC::HerramientaWindowLevel::Resetear()");
	for (TContratableWidgets::IteradorListaContratos it1 = TContratableWidgets::m_pListaActiva->begin(); it1 != TContratableWidgets::m_pListaActiva->end(); it1++) {
		GNC::GCS::Eventos::EventoModificacionImagen* pEvt = new GNC::GCS::Eventos::EventoModificacionImagen(TContratableWidgets::m_pVistaActiva,GNC::GCS::Eventos::EventoModificacionImagen::VisualizacionImagenModificada);
		pEvt->EnableResetWindowLevel();
		pEvt->EnableResetCurrentPoint();
		pEvt->EnableResetZoom();
		GNC::GCS::ControladorEventos::Instance()->ProcesarEvento(pEvt);
		GNC::GCS::ControladorEventos::Instance()->ProcesarEvento(new GNC::GCS::Eventos::EventoRender(TContratableWidgets::m_pVistaActiva));
	}
}

void GNC::HerramientaReset::ConectarContratoFalso(bool ) {
	if (TContratableWidgets::m_pListaActiva == NULL) {
		//std::cerr << "Error: Se trato de activar el modo deshabilitado de una vista sin haber asignado la vista activa. Error en la logica de activacion. Accion ignorada" << std::endl;
		return;
	}

}

void GNC::HerramientaReset::SetVistaActiva(GNC::GCS::IVista* pVista) {
	TContratableWidgets::EstablecerVistaActiva(pVista);
	GTRACE("GNC::HerramientaReset::EstablecerVistaActiva(pVista);::SetVistaActiva(" <<  pVista << ")");
}

// FIXME: Aviso!!!! para que funcione deben contratarse contratos pareados obligatorios y en el mismo orden
void GNC::HerramientaReset::ConectarContratos(bool )
{
	if (TContratableWidgets::m_pListaActiva == NULL) {
		std::cerr << "Error: Se trataron de conectar contratos sin haber asignado la vista activa. Error en la logica de activacion. Accion ignorada" << std::endl;
		return;
	}

}

//endregion


