/*
 *  
 *  $Id: herramientarejillametrica.cpp 4869 2012-04-19 11:47:15Z carlos $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
//#define _GINKGO_TRACE
#include <wx/aui/aui.h>
#include <wx/spinctrl.h>
#include <wx/dialog.h>
#include <wx/statbox.h>
#include <wx/stattext.h>
#include <wx/button.h>
#include <wx/menu.h>
#include <wx/choice.h>


#include <api/globals.h>
#include <api/observers/iwidgetsobserver.h>
#include "herramientarejillametrica.h"
#include <api/ievento.h>
#include <eventos/eventosginkgo.h>
#include <api/inotificadoresherramientas.h>
#include <resources/ginkgoresourcemanager.h>
#include <main/controllers/controladoreventos.h>

#ifdef __DEPRECATED
#undef __DEPRECATED
#endif
#include <vtk/vtkginkgoimageviewer.h>

#define ACTIVAR_REJILLA  1241
#define ESCALA_REJILLA 1242

namespace GNC {
	namespace GUI {
		class DialogoRejilla: public wxDialog {
		public:
			typedef enum TMetrica {
				TM_UM = 0,
				TM_MM,
				TM_CM,
				TM_M
			} TMetrica;

			DialogoRejilla(wxWindow* pParent, GNC::HerramientaRejillaMetrica* pHerramienta):
				wxDialog(pParent,wxID_ANY,_("Grid"),wxDefaultPosition,wxDefaultSize,wxDEFAULT_DIALOG_STYLE)
			{
				m_pHerramienta=pHerramienta;

				this->SetSizeHints( wxDefaultSize, wxDefaultSize );

				wxBoxSizer* bSizer5;
				bSizer5 = new wxBoxSizer( wxVERTICAL );

				wxStaticBoxSizer* sbSizer2;
				sbSizer2 = new wxStaticBoxSizer( new wxStaticBox( this, wxID_ANY, _("Grid Scale") ), wxVERTICAL );

				wxFlexGridSizer* fgSizer1;
				fgSizer1 = new wxFlexGridSizer( 2, 3, 0, 0 );
				fgSizer1->SetFlexibleDirection( wxBOTH );
				fgSizer1->SetNonFlexibleGrowMode( wxFLEX_GROWMODE_SPECIFIED );

				wxStaticText* m_staticText4 = new wxStaticText( this, wxID_ANY, _("Scale X"), wxDefaultPosition, wxDefaultSize, 0 );
				fgSizer1->Add(m_staticText4,0,wxALL|wxEXPAND|wxALIGN_CENTER_VERTICAL,5);

				m_pSpinEscalaX = new wxSpinCtrl( this, wxID_ANY, wxT("50"), wxDefaultPosition, wxSize(60,-1), wxSP_ARROW_KEYS, 1, 10000, 50 );
				m_pSpinEscalaX->SetToolTip(_("X axis scale"));
				fgSizer1->Add(m_pSpinEscalaX,0,wxALL|wxEXPAND|wxALIGN_CENTER_VERTICAL,5);

				std::string micrometros("µm.");
				wxString choices[] = {wxString::FromUTF8(micrometros.c_str()),wxT("mm."),wxT("cm."),wxT("m.")};
				int choice2NChoices = sizeof( choices ) / sizeof( wxString );
				m_pChoiceX = new wxChoice(this,wxID_ANY, wxDefaultPosition, wxDefaultSize, choice2NChoices, choices);
				fgSizer1->Add(m_pChoiceX,0,wxALL|wxALIGN_CENTER_VERTICAL,5);

				wxStaticText* m_staticText5 = new wxStaticText( this, wxID_ANY, _("Scale Y"), wxDefaultPosition, wxDefaultSize, 0 );
				fgSizer1->Add(m_staticText5,0,wxALL|wxEXPAND,5);

				m_pSpinEscalaY = new wxSpinCtrl( this, wxID_ANY, wxT("50"), wxDefaultPosition, wxSize(60,-1), wxSP_ARROW_KEYS, 1, 10000, 50 );
				m_pSpinEscalaY->SetToolTip(_("Y axis scale"));
				fgSizer1->Add(m_pSpinEscalaY,0,wxALL|wxEXPAND|wxALIGN_CENTER_VERTICAL,5);

				m_pChoiceY = new wxChoice(this,wxID_ANY, wxDefaultPosition, wxDefaultSize, choice2NChoices, choices);
				fgSizer1->Add(m_pChoiceY,0,wxALL|wxALIGN_CENTER_VERTICAL,5);

				sbSizer2->Add( fgSizer1, 1, wxEXPAND|wxALL, 5 );

				bSizer5->Add( sbSizer2, 1,wxALL|wxEXPAND, 5 );

				wxButton* m_button3 = new wxButton( this, wxID_OK, _("Ok"), wxDefaultPosition, wxDefaultSize, 0 );
				m_button3->SetDefault();
				bSizer5->Add( m_button3, 0, wxALL|wxALIGN_RIGHT, 5 );

				this->SetSizer( bSizer5 );
				this->Layout();
				bSizer5->Fit( this );

				this->Centre( wxBOTH );


				double escalaX = m_pHerramienta->GetEscalaX();
				m_pChoiceX->Select((int)AjustaAMetricaApropiada(escalaX));
				m_pSpinEscalaX->SetValue(escalaX);
				double escalaY = m_pHerramienta->GetEscalaY();
				m_pChoiceY->Select((int)AjustaAMetricaApropiada(escalaY));
				m_pSpinEscalaY->SetValue(escalaY);

				m_pSpinEscalaX->Connect( wxEVT_COMMAND_SPINCTRL_UPDATED, wxSpinEventHandler( DialogoRejilla::OnSpinCtrlX ), NULL, this );
				m_pSpinEscalaY->Connect( wxEVT_COMMAND_SPINCTRL_UPDATED, wxSpinEventHandler( DialogoRejilla::OnSpinCtrlY ), NULL, this );
				m_pChoiceX->Connect( wxEVT_COMMAND_CHOICE_SELECTED, wxCommandEventHandler( DialogoRejilla::OnEscalaX), NULL, this);
				m_pChoiceY->Connect( wxEVT_COMMAND_CHOICE_SELECTED, wxCommandEventHandler( DialogoRejilla::OnEscalaY), NULL, this);
			}

			~DialogoRejilla()
			{
				m_pSpinEscalaX->Disconnect( wxEVT_COMMAND_SPINCTRL_UPDATED, wxSpinEventHandler( DialogoRejilla::OnSpinCtrlX ), NULL, this );
				m_pSpinEscalaX->Disconnect( wxEVT_COMMAND_SPINCTRL_UPDATED, wxSpinEventHandler( DialogoRejilla::OnSpinCtrlY ), NULL, this );
				m_pChoiceX->Disconnect( wxEVT_COMMAND_CHOICE_SELECTED, wxCommandEventHandler( DialogoRejilla::OnEscalaX), NULL, this);
				m_pChoiceY->Disconnect( wxEVT_COMMAND_CHOICE_SELECTED, wxCommandEventHandler( DialogoRejilla::OnEscalaY), NULL, this);
				m_pHerramienta = NULL;
			}

			TMetrica AjustaAMetricaApropiada(double &escala)
			{
				if (escala > 10000.0f) {
					escala = (int)(escala / 1000.0f);
					return TM_M;
				}
				else if (escala > 100.0f) {
					escala = (int)(escala / 10.0f);
					return TM_CM;
				}
				else if (escala < 10.0f) {
					escala = (int)(escala * 1000.0f);
					return TM_UM;
				}
				else {
					escala = (int)(escala);
					return TM_MM;
				}
			}

			double TransformToMM(double valor, TMetrica escala)
			{
				switch (escala) {
					case TM_M:
						return valor * 1000.0;
					case TM_CM:
						return valor*10.0;
					case TM_UM:
						return valor / 1000.0;
					case TM_MM:
						return valor;
				}
				return valor;
			}

			void OnSpinCtrlX( wxSpinEvent&  )
			{
				const double valor = TransformToMM(m_pSpinEscalaX->GetValue(), (TMetrica)m_pChoiceX->GetSelection());
				m_pHerramienta->SetEscalaX(valor);
			}

			void OnEscalaX( wxCommandEvent &)
			{
				const double valor = TransformToMM(m_pSpinEscalaX->GetValue(), (TMetrica)m_pChoiceX->GetSelection());
				m_pHerramienta->SetEscalaX(valor);
			}

			void OnSpinCtrlY( wxSpinEvent&  )
			{
				const double valor = TransformToMM(m_pSpinEscalaY->GetValue(), (TMetrica)m_pChoiceY->GetSelection());
				m_pHerramienta->SetEscalaY(valor);
			}

			void OnEscalaY( wxCommandEvent &)
			{
				const double valor = TransformToMM(m_pSpinEscalaY->GetValue(), (TMetrica)m_pChoiceY->GetSelection());
				m_pHerramienta->SetEscalaY(valor);
			}

			wxSpinCtrl* m_pSpinEscalaX;
			wxSpinCtrl* m_pSpinEscalaY;
			wxChoice* m_pChoiceX;
			wxChoice* m_pChoiceY;
			GNC::HerramientaRejillaMetrica* m_pHerramienta;
		};


		class MenuHerramientaRejilla : public wxMenu {
		public:
			MenuHerramientaRejilla(wxWindow* pParent, GNC::HerramientaRejillaMetrica* pHerramienta):wxMenu() {
				m_pParent = pParent;
				m_pHerramienta=pHerramienta;
				wxMenuItem* pItemVer = new wxMenuItem(this,ACTIVAR_REJILLA,_("Show grid"),_("Show grid"),wxITEM_NORMAL);
				wxMenuItem* pItemEscala = new wxMenuItem(this,ESCALA_REJILLA,_("Configure Grid ..."),_("Configure Grid"),wxITEM_NORMAL);
				#ifdef __WXMSW__
					pItemVer->SetBitmaps(GinkgoResourcesManager::BarraRejilla::GetIcoVerRejilla());
				#else
					pItemVer->SetBitmap(GinkgoResourcesManager::BarraRejilla::GetIcoVerRejilla());
				#endif
				m_pParent->Connect(pItemVer->GetId(), wxEVT_COMMAND_MENU_SELECTED, wxCommandEventHandler( MenuHerramientaRejilla::OnActivarRejillaClick),NULL,this);
				m_pParent->Connect(pItemVer->GetId(), wxEVT_UPDATE_UI, wxUpdateUIEventHandler(MenuHerramientaRejilla::OnUpdateUIMostrar),NULL,this);
				m_pParent->Connect(pItemEscala->GetId(), wxEVT_COMMAND_MENU_SELECTED, wxCommandEventHandler( MenuHerramientaRejilla::OnEscalaClick),NULL,this);
				m_pParent->Connect(pItemEscala->GetId(), wxEVT_UPDATE_UI, wxUpdateUIEventHandler(MenuHerramientaRejilla::OnUpdateUIHerramienta),NULL,this);
				Append(pItemVer);
				Append(pItemEscala);

				m_pParent->Connect(m_pHerramienta->ID, wxEVT_UPDATE_UI, wxUpdateUIEventHandler(MenuHerramientaRejilla::OnUpdateUIHerramienta),NULL,this);
			}

			~MenuHerramientaRejilla() {
				m_pParent->Disconnect(ACTIVAR_REJILLA, wxEVT_COMMAND_MENU_SELECTED, wxCommandEventHandler( MenuHerramientaRejilla::OnActivarRejillaClick),NULL,this);
				m_pParent->Disconnect(ESCALA_REJILLA, wxEVT_COMMAND_MENU_SELECTED, wxCommandEventHandler( MenuHerramientaRejilla::OnEscalaClick),NULL,this);
				m_pParent->Disconnect(ACTIVAR_REJILLA, wxEVT_UPDATE_UI, wxUpdateUIEventHandler(MenuHerramientaRejilla::OnUpdateUIMostrar),NULL,this);
				m_pParent->Disconnect(ESCALA_REJILLA, wxEVT_UPDATE_UI, wxUpdateUIEventHandler(MenuHerramientaRejilla::OnUpdateUIHerramienta),NULL,this);

				m_pParent->Disconnect(m_pHerramienta->ID, wxEVT_UPDATE_UI, wxUpdateUIEventHandler(MenuHerramientaRejilla::OnUpdateUIHerramienta),NULL,this);

				m_pParent = NULL;
				m_pHerramienta = NULL;
			}

			void OnActivarRejillaClick( wxCommandEvent& event )
			{
				m_pHerramienta->ToggleRejilla();
				event.Skip(false);
			}

			void OnEscalaClick( wxCommandEvent& event )
			{
				DialogoRejilla dlg(m_pParent,m_pHerramienta);
				dlg.ShowModal();
				event.Skip(false);
			}

			void OnUpdateUIMostrar(wxUpdateUIEvent& event) {
				if(m_pHerramienta->IsVisible()) {
					event.SetText(_("Hide Grid"));
				} else {
					event.SetText(_("Show Grid"));
				}
				event.Enable(m_pHerramienta->Habilitada());
			}

			void OnUpdateUIHerramienta(wxUpdateUIEvent& event) {
				event.Enable(m_pHerramienta->Habilitada());
			}

			GNC::HerramientaRejillaMetrica* m_pHerramienta;
			wxWindow* m_pParent;
		};
	}
}

//----------------------------------------------------------------------

GNC::HerramientaRejillaMetrica::HerramientaRejillaMetrica()
{
	m_Descripcion = _Std("Metric grid");
	m_Icono = GinkgoResourcesManager::IconosHerramientas::GetIcoRejilla();
	m_IsMenu = true;
	m_RejillaVisible = false;
}

GNC::HerramientaRejillaMetrica::~HerramientaRejillaMetrica()
{
	if (m_pAbstractPanelHerramientaOpciones != NULL) {
		m_pAbstractPanelHerramientaOpciones->Destroy();
		m_pAbstractPanelHerramientaOpciones = NULL;
	}
}

bool GNC::HerramientaRejillaMetrica::AppendInMenu(wxWindow* pParent, wxMenu* pMenuParent)
{
	wxMenu* pMenu = new GNC::GUI::MenuHerramientaRejilla(pParent,this);
	pMenuParent->Append(ID,wxString::FromUTF8(m_Descripcion.c_str()),pMenu);
	return true;
}

bool GNC::HerramientaRejillaMetrica::IsVisible()
{
	return m_RejillaVisible;
}

// Eventos refinados desde los paneles
void GNC::HerramientaRejillaMetrica::ToggleRejilla()
{
	ActivarRejilla(!m_RejillaVisible);
}

void GNC::HerramientaRejillaMetrica::ActivarRejilla(bool activar, bool force)
{
	if(m_RejillaVisible != activar || force){
		m_RejillaVisible = activar;
		if(TContratableWidgets::m_pVistaActiva != NULL && TContratableWidgets::m_pListaActiva != NULL) {
			for (TContratableWidgets::IteradorListaContratos it1 = TContratableWidgets::m_pListaActiva->begin(); it1 != TContratableWidgets::m_pListaActiva->end(); it1++) {
				TContratoWidgets* pCW = (*it1);
				double spacing[3] = {1.0,1.0,1.0};
				int dimensions[3] = {0.0,0.0,0.0};
				pCW->GetViewerActivo()->GetSpacing(spacing);
				pCW->GetViewerActivo()->GetDimensions(dimensions);


				double escalaXDefecto = spacing[0] * dimensions [0] / 10;
				double escalaYDefecto = spacing[1] * dimensions [1] / 10;

				GNC::GCS::Widgets::WRejillaBuilder* pRejillaBuilder = new GNC::GCS::Widgets::WRejillaBuilder(pCW->GetManager(), GetTriggerButton(), (unsigned long)this, escalaXDefecto, escalaYDefecto);
				pRejillaBuilder->ActivarRejilla(activar);
				delete pRejillaBuilder;
				GNC::GCS::ControladorEventos::Instance()->ProcesarEvento(new GNC::GCS::Eventos::EventoRender(TContratableWidgets::m_pVistaActiva));
			}
		}
	}
}

void GNC::HerramientaRejillaMetrica::SetEscalaX(double escala)
{
	if(TContratableWidgets::m_pVistaActiva != NULL && TContratableWidgets::m_pListaActiva != NULL) {
		for (TContratableWidgets::IteradorListaContratos it1 = TContratableWidgets::m_pListaActiva->begin(); it1 != TContratableWidgets::m_pListaActiva->end(); it1++) {
			TContratoWidgets* pCW = (*it1);
			GNC::GCS::Widgets::WRejillaBuilder* pRejillaBuilder = new GNC::GCS::Widgets::WRejillaBuilder(pCW->GetManager(), GetTriggerButton(), (unsigned long)this);
			if(!m_RejillaVisible) {
				m_RejillaVisible = true;
				pRejillaBuilder->ActivarRejilla(m_RejillaVisible);
			}
			pRejillaBuilder->SetEscalaX(escala);
			delete pRejillaBuilder;
			GNC::GCS::ControladorEventos::Instance()->ProcesarEvento(new GNC::GCS::Eventos::EventoRender(TContratableWidgets::m_pVistaActiva));
		}
	}
}

void GNC::HerramientaRejillaMetrica::SetEscalaY(double escala)
{
	if(TContratableWidgets::m_pVistaActiva != NULL && TContratableWidgets::m_pListaActiva != NULL) {
		for (TContratableWidgets::IteradorListaContratos it1 = TContratableWidgets::m_pListaActiva->begin(); it1 != TContratableWidgets::m_pListaActiva->end(); it1++) {
			TContratoWidgets* pCW = (*it1);
			GNC::GCS::Widgets::WRejillaBuilder* pRejillaBuilder = new GNC::GCS::Widgets::WRejillaBuilder(pCW->GetManager(), GetTriggerButton(), (unsigned long)this);
			if(!m_RejillaVisible) {
				m_RejillaVisible = true;
				pRejillaBuilder->ActivarRejilla(m_RejillaVisible);
			}
			pRejillaBuilder->SetEscalaY(escala);
			delete pRejillaBuilder;
			GNC::GCS::ControladorEventos::Instance()->ProcesarEvento(new GNC::GCS::Eventos::EventoRender(TContratableWidgets::m_pVistaActiva));
		}
	}
}

double GNC::HerramientaRejillaMetrica::GetEscalaX()
{
	if(TContratableWidgets::m_pVistaActiva != NULL && TContratableWidgets::m_pListaActiva != NULL) {
		TContratableWidgets::IteradorListaContratos it1 = TContratableWidgets::m_pListaActiva->begin();
		if (it1 != TContratableWidgets::m_pListaActiva->end()) {
			double escala;
			TContratoWidgets* pCW = (*it1);
			GNC::GCS::Widgets::WRejillaBuilder* pRejillaBuilder = new GNC::GCS::Widgets::WRejillaBuilder(pCW->GetManager(), GetTriggerButton(), (unsigned long)this);
			escala = pRejillaBuilder->GetEscalaX();
			delete pRejillaBuilder;
			return escala;
		}
	}
	return 50;
}

double GNC::HerramientaRejillaMetrica::GetEscalaY()
{
	if(TContratableWidgets::m_pVistaActiva != NULL && TContratableWidgets::m_pListaActiva != NULL) {
		TContratableWidgets::IteradorListaContratos it1 = TContratableWidgets::m_pListaActiva->begin();
		if (it1 != TContratableWidgets::m_pListaActiva->end()) {
			double escala;
			TContratoWidgets* pCW = (*it1);
			GNC::GCS::Widgets::WRejillaBuilder* pRejillaBuilder = new GNC::GCS::Widgets::WRejillaBuilder(pCW->GetManager(), GetTriggerButton(), (unsigned long)this);
			escala = pRejillaBuilder->GetEscalaY();
			delete pRejillaBuilder;
			return escala;
		}
	}
	return 50;
}



//region "Realizacion de la interfaz IHerramienta"

void GNC::HerramientaRejillaMetrica::CrearPaneles( wxPanel*  )
{
	m_pAbstractPanelHerramientaOpciones = NULL;
}

void GNC::HerramientaRejillaMetrica::ConectarContratoFalso(bool ) {
	if (TContratableWidgets::m_pListaActiva == NULL) {
		//std::cerr << "Error: Se trato de activar el modo deshabilitado de una vista sin haber asignado la vista activa. Error en la logica de activacion. Accion ignorada" << std::endl;
		return;
	}
}

void GNC::HerramientaRejillaMetrica::SetVistaActiva(GNC::GCS::IVista* pVista) {

	TContratableWidgets::EstablecerVistaActiva(pVista);
	//se comprueba si la rejilla es visible
	if(TContratableWidgets::m_pVistaActiva != NULL && TContratableWidgets::m_pListaActiva != NULL) {
		for (TContratableWidgets::IteradorListaContratos it1 = TContratableWidgets::m_pListaActiva->begin(); it1 != TContratableWidgets::m_pListaActiva->end(); it1++) {
			TContratoWidgets* pCW = (*it1);
			GNC::GCS::Widgets::WRejillaBuilder* pRejillaBuilder = new GNC::GCS::Widgets::WRejillaBuilder(pCW->GetManager(), GetTriggerButton(), (unsigned long)this);
			m_RejillaVisible = pRejillaBuilder->IsRejillaVisible();
			delete pRejillaBuilder;
		}
	}
	GTRACE("GNC::TContratableLupa::EstablecerVistaActiva(pVista);::SetVistaActiva(" <<  pVista << ")");
}

// FIXME: Aviso!!!! para que funcione deben contratarse contratos pareados obligatorios y en el mismo orden
void GNC::HerramientaRejillaMetrica::ConectarContratos(bool )
{
	if (TContratableWidgets::m_pListaActiva == NULL) {
		std::cerr << "Error: Se trataron de conectar contratos sin haber asignado la vista activa. Error en la logica de activacion. Accion ignorada" << std::endl;
		return;
	}
}

//endregion

//region Interfaz de eventos ginkgo

//endregion

