/*
 *  $Id: startupview.cpp 4436 2011-11-21 08:07:30Z tovar $
 *  Proyecto Ginkgo
 *
 *  Copyright 2008 MetaEmotion S.L. All rights reserved.
 *
 */
//#define _GINKGO_TRACE

#include <wx/wx.h>
#include <wx/dir.h>
#include <wx/filename.h>
#include <wx/file.h>
#include <wx/busyinfo.h>
#include <wx/msgdlg.h>
#include <wx/thread.h>
#include <wx/wxhttpengine/httpbuilder.h>
#include <wx/wxhttpengine/httpbuilderthread.h>

#include <wx/tarstrm.h>
#include <wx/zstream.h>
#include <wx/wfstream.h>

#include <api/globals.h>
#include <main/entorno.h>
#include <main/controllers/controladorlog.h>
#include <main/controllers/configurationcontroller.h>
#include <main/controllers/controladorinternacionalizacion.h>

#include "startupview.h"
#include "startupform.h"

#include <api/ientorno.h>

#undef __DEPRECATED
#include <ios>
#include <sstream>
#include <ostream>


#define LOGGER "STARTUP"
#define DEFAULT_RSS "http://twitter.com/statuses/user_timeline/247267254.rss"
#define DEFAULT_WELCOME_URL "http://ginkgo-cadx.com/[lan]/ginkgocadxwelcomescreen/"

namespace GNC {
	namespace GUI {
		class StartUpViewTimer: public wxTimer
		{
			public:
			StartUpViewTimer(StartUpView* pView){
				m_pView = pView;
				welcomeLoaded = false;
				twitterLoaded = false;
			}

			~StartUpViewTimer()
			{
				m_pView=NULL;
			}

			virtual void Notify()
			{
				if (!welcomeLoaded) {
					welcomeLoaded = m_pView->LoadWelcome();
				}
				if (!twitterLoaded) {
					twitterLoaded = m_pView->LoadTwitter();
				}
				if (!twitterLoaded || !welcomeLoaded) {
					this->Start(500, true);
				}
			}

			StartUpView* m_pView;
			bool welcomeLoaded;
			bool twitterLoaded;
		};

		StartUpView ::StartUpView (const GnkPtr<GNC::GUI::StartUpStudy>& study) : GNC::GCS::IVista((GnkPtr<GNC::GCS::IContextoEstudio>)study)
		{
			FooStudy = study;
			m_Cargada = false;

			FooStudy->Ventana = m_pWindow = new StartUpForm (this);

			m_pTimer = NULL;
		}

		StartUpView ::~StartUpView ()
		{
			if (m_pTimer != NULL) {
				delete m_pTimer;
				m_pTimer = NULL;
			}
		}

		//----------------------------------------------------------------------------------------------------
	//region Loading interface

		// Starts loading. Synchronous with interface.
		void StartUpView::OnCargaIniciada()
		{
			m_twiterFile = "";
			//download file..
			wxString newTmpDir;
			do {
				newTmpDir = FROMPATH(FooStudy->Entorno->GetGinkgoTempDir()) + wxFileName::GetPathSeparator(wxPATH_NATIVE) + wxT("_gnktmp_") + wxString::Format(wxT("%d"), rand());
			} while(wxDir::Exists(newTmpDir));

	#ifdef _WIN32
			wxFileName::Mkdir(newTmpDir);
	#else
			wxFileName::Mkdir(newTmpDir.c_str(), 0777);
	#endif

			//rss
			std::string rssURL = GetRSSUrl();
			wxString pathOfFileWx = newTmpDir + wxFileName::GetPathSeparator() + wxT("file.xml");
			if (DownloadFile(rssURL, pathOfFileWx)) {			
				m_twiterFile = TOPATH(pathOfFileWx);
			} else {
				m_pWindow->ShowError(true);
			}
			//welcome
			std::string welcomeURL = GetWelcomeUrl();
			pathOfFileWx = newTmpDir + wxFileName::GetPathSeparator() + wxT("welcome.html");
			//parse url and path...
			if (DownloadFile(welcomeURL, pathOfFileWx)) {			
				m_welcomeFile = TOPATH(pathOfFileWx);
			} else {
				m_pWindow->ShowError(false);
			}
			m_pTimer = new StartUpViewTimer(this);
			m_pTimer->Start(500, true);
		}

		// Step1: LoadStudy not synchronized with interface thread
		void StartUpView::CargarEstudio(GNC::GCS::IComando* /*pCmdInvocador*/)
		{				
		}

		//Ends loading. Synchronous with interface
		void StartUpView::OnCargaFinalizada()
		{
		}

		bool StartUpView::LoadTwitter()
		{
			wxString wxPageFile = FROMPATH(m_twiterFile);
	      if (wxFileExists(wxPageFile)) {
				m_pWindow->LoadTwitterFile(wxPageFile);
				wxRemoveFile(wxPageFile);
				return true;
	      } else {
				return false;
	      }
		}

		bool StartUpView::LoadWelcome()
		{
			wxString wxPageFile = FROMPATH(m_welcomeFile);
			if (wxFileExists(wxPageFile)) {
				m_pWindow->LoadWelcomeFile(wxPageFile);
				wxRemoveFile(wxPageFile);
	      } else {
				return false;
	      }
			return true;
		}

		// Step2: init pipeline synchronous with interface
		void StartUpView::IniciarPipeline()
		{
			//build view title
			BuildTitle();
		}


		// stops pipeline, it's called if there has been an error loading study
		void StartUpView::DetenerPipeline()
		{
		}

	//endregion

		bool StartUpView::SoportaGuardar()
		{
			return false;
		}

		bool StartUpView::SoportaExportar()
		{
			return false;
		}

		void StartUpView::Activar() {
			GNC::GCS::IVista::Activar();
			m_pWindow->SetFocus();
		}

		wxWindow * StartUpView::GetWindow()
		{
			return m_pWindow;
		}

		void StartUpView::OnFocus()
		{
			if (!m_Activada) {
				FooStudy->Entorno->GetControladorVistas()->SolicitarActivarVista(this);
			}
		}

		void StartUpView::BuildTitle()
		{
			m_Titulo = _Std("Start page");
		}

		bool StartUpView::DownloadFile(const std::string& fullUrl, const wxString& pathOfFileWx)
		{
			wxHTTPBuilder* phttp = new wxHTTPBuilder();
			wxProxySettings settings;
			settings.ProxySettingsLoadGeneral();
			phttp->SetProxySettings(settings);
			phttp->InitContentTypes();
			
			wxHTTPBuilderThread* pThread = new wxHTTPBuilderThread(wxID_ANY, phttp, wxString::FromUTF8(fullUrl.c_str()));
			pThread->SaveToFile(pathOfFileWx);
			if (pThread->Create() != wxTHREAD_NO_ERROR) {
				delete pThread;
				pThread = NULL;
				return false;
			} else {
				pThread->Run();
				return true;
			}			
			return true;
		}

		std::string StartUpView::GetRSSUrl() 
		{
			std::string url;
			GNC::GCS::ConfigurationController::Instance()->readStringGeneral("GinkgoCore/News", "DefaultRSSUrl", url, DEFAULT_RSS);
			
			int language = GNC::GCS::ControladorInternacionalizacion::Instance()->GetIdiomaInterfaz();
			wxString wxDirPath = FROMPATH(GNC::Entorno::Instance()->GetGinkgoLanguageDir());
			wxDir dir;
			if (dir.Open(wxDirPath)) {
				wxString wxPathLang;
				bool cont = dir.GetFirst(&wxPathLang,wxEmptyString, wxDIR_DIRS);
				while (cont) {
					const wxLanguageInfo* pInfo = wxLocale::FindLanguageInfo(wxPathLang);
					if (pInfo != NULL) {
						if (pInfo->Language == language) {
							wxString rssKey = wxT("RSSUrl_") + pInfo->CanonicalName;
							GNC::GCS::ConfigurationController::Instance()->readStringGeneral("GinkgoCore/News", std::string(rssKey.ToUTF8()), url, url);
							break;
						}
					}
					cont = dir.GetNext(&wxPathLang);
				}
			}

			return url;
		}

		std::string StartUpView::GetWelcomeUrl() 
		{
			int language = GNC::GCS::ControladorInternacionalizacion::Instance()->GetIdiomaInterfaz();

			std::string url;
			GNC::GCS::ConfigurationController::Instance()->readStringGeneral("GinkgoCore/News", "WelcomeUrl",url,DEFAULT_WELCOME_URL);
		
			std::string strReplace;
			if (language >= wxLANGUAGE_SPANISH && language <= wxLANGUAGE_SPANISH_VENEZUELA) {
				strReplace = "es";
			} else {
				strReplace = "en";
			}
			std::string::size_type it0;
			it0 = url.find("[lan]");
			if (it0 != std::string::npos) {
				url = url.replace(it0, 5, strReplace );
			}
			return url;
		}

	}
}
