
#include <wx/filename.h>
#include <wx/file.h>
#include <wx/imaglist.h>
#include <main/controllers/configurationcontroller.h>
#include <wx/msgdlg.h>
#include <wx/treelistctrl/treelistctrl.h>
#include "opendialogsbase.h"

#include "opendialogs.h"


#include <vector>
#include <sstream>

#include <main/entorno.h>
#include <main/controllers/controladorcomandos.h>
#include <main/controllers/pacscontroller.h>
#include <main/gui/dicombrowsercomponent.h>
#include <commands/comandoincluirhistorial.h>
#include <api/dicom/imodelodicom.h>
#include <resources/ginkgoresourcemanager.h>
#include <api/icontextoestudio.h>
#include <wx/ginkgostyle/ginkgostyle.h>


#define ICONO_ESTUDIO 0
#define ICONO_SERIE 1
#define ICONO_HOMBRE 2
#define ICONO_MUJER 3
#define ICONO_OTRO 4
#define SIZE_ICONOS 16

#define COLUMNA_DCMDIR_FECHA 2
#define COLUMNA_DCMDIR_MODALIDAD 1
#define COLUMNA_DCMDIR_MEDICO 3
#define COLUMNA_DCMDIR_ACCNUMBER 4
#define COLUMNA_DCMDIR_UID 5
namespace GNC {
	namespace GUI {
		////////////////////////////////////////////////////
		////////////DIALOGO DICOMDIR////////////////////////
		////////////////////////////////////////////////////
		DialogoDicomDir::DialogoDicomDir(wxWindow* pParent, const std::string& pathDicomDir): DialogoDicomDirBase(pParent)
		{
			wxString pathWx = FROMPATH(pathDicomDir);
			if (wxFile::Exists(pathWx)){
				wxFileName file(pathWx);
				IModeloDicom modelo;

				if(GIL::DICOM::PACSController::Instance()->LeerDicomDir(pathDicomDir,&modelo) && modelo.ListaPacientes().size()!=0) {
					m_pDICOMDIRResultPanel->SetModel(modelo);
				}
			} else {
				wxMessageBox(_("Select a valid DICOMDIR file"), _("Info"),
								 wxOK | wxICON_INFORMATION, this);
			}
		}

		DialogoDicomDir::~DialogoDicomDir()
		{
		}

		void DialogoDicomDir::OnEndClick(wxCommandEvent &)
		{
			//adquirimos desde dicomdir
			std::list<std::string> listaPaths = m_pDICOMDIRResultPanel->GetSelectedPaths();

			if(listaPaths.size() == 0) {
				wxMessageBox(_("Select dicom dir files you want to acquire"), _("Info"),
								 wxOK | wxICON_INFORMATION, this);
				return;
			} else {
				//se lanza el comando de incluir en el historial
				GADAPI::ComandoIncluirHistorial::ComandoIncluirHistorialParams* pParams = new GADAPI::ComandoIncluirHistorial::ComandoIncluirHistorialParams(listaPaths);
				GADAPI::ComandoIncluirHistorial::ComandoIncluirHistorial* pCmd = new GADAPI::ComandoIncluirHistorial::ComandoIncluirHistorial(pParams);
				GNC::Entorno::Instance()->GetControladorComandos()->ProcessAsync(_Std("Storing in the history..."),pCmd, NULL);

				Close();
			}
		}
		///////////////////////////////////////END OF DIALOGODICOMDIR
		SelectDrive::SelectDrive(wxWindow* pParent, const TListOfDrives& drives) : SelectDriveBase(pParent)
		{
			m_drives = drives;
			for (TListOfDrives::iterator it = m_drives.begin(); it != m_drives.end(); it++) {
				m_pUnits->Append(wxString::FromUTF8((*it).label.c_str()));
			}
			if (m_pUnits->GetCount() > 0) {
				m_pUnits->Select(0);
			}
		}
		SelectDrive::~SelectDrive()
		{
		}

		void SelectDrive::SetMessage(const wxString& label)
		{
			m_pLabel->SetLabel(label);
			m_pPanelMessage->Layout();
			m_pBody->Layout();
		}

		std::string SelectDrive::GetSelectedDrive()
		{
			TListOfDrives::iterator it = m_drives.begin();
			for (int i = 0; i < m_pUnits->GetSelection(); ++i, ++it);
			return (*it).id;
		}
	}
}
