/*
 *
 *  $Id: ventanaprincipal.cpp 4811 2012-04-02 12:24:41Z carlos $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
//#define _GINKGO_TRACE

#include <iostream>
#include <sstream>

#include <wx/wx.h>
#include <wx/zstream.h>
#include <wx/wfstream.h>
#include <wx/aui/aui.h>
#include <wx/app.h>
#include <wx/propgrid/propgrid.h>
#include <wx/dir.h>
#include <wx/filename.h>
#include <wx/file.h>
#include <wx/mstream.h>
#include <wx/textfile.h>

#include <wx/filedlg.h>
#include <wx/dirdlg.h>
#include <wx/msgdlg.h>
#include <wx/msgout.h>
#include <wx/xml/xml.h>
#include <wx/sstream.h>
#include <wx/html/htmlwin.h>
#include <wx/html/htmprint.h>
#include <wx/gbsizer.h>
#include <wx/dnd.h>
#include <wx/txtstrm.h>
#include <wx/display.h>
#include <wx/cmdline.h>

#include <main/gui/mainwindow/ventanaprincipal.h>
#include <main/panelgrid.h>
#include <main/gui/login/dialogologin.h>
#include <main/gui/open/abrir.h>
#include <main/gui/print/printmanager.h>
#include <main/gui/license/aboutdialog.h>
#include <main/gui/license/acceptlicensedialog.h>
#include <main/gui/import/wxwizardimportacionginkgo.h>
#include <main/gui/acquisition/dialogoadquisicion.h>
#include <main/gui/export/wxwizardexportacionginkgo.h>
#include <main/gui/history/panelhistorial2.h>
#include <main/gui/progress/statusbarprogreso.h>
#include <main/gui/configuration/dialogoconfiguracion.h>
#include <main/gui/pacsupload/wxwizarduploadpacs.h>
#include <main/gui/dicomdirexport/wxwizarddicomdirexport.h>
#include <main/gui/hl7controlwindow/ventanacontrolhl7.h>
#include <main/gui/logcontrolwindow/ventanacontrollogs.h>
#include <main/gui/startup/startupview.h>

#include <api/globals.h>
#include <api/ivista.h>
#include <api/icontextoestudio.h>
#include <api/icontroladormodulo.h>
#include <api/controllers/ipacscontroller.h>

#include <main/entorno.h>

#include <main/controllers/controladorextensiones.h>
#include <main/controllers/integrationcontroller.h>
#include <main/controllers/controladorvistas.h>
#include <main/controllers/controladorherramientas.h>
#include <main/controllers/controladorcomandos.h>
#include <main/controllers/controladorpermisos.h>
#include <main/controllers/controladorhl7.h>
#include <main/controllers/controladorenviohl7.h>
#include <main/controllers/controladorautenticacion.h>
#include <main/controllers/controladorlog.h>
#include <main/controllers/dcmtk/dicomservers.h>
#include <main/controllers/xmlrpccontroller.h>
#include <main/controllers/configurationcontroller.h>

#include <commands/comandoactualizaciones.h>
#include <commands/comandoincluirhistorial.h>
#include <commands/openremovableunit.h>

#include <eventos/eventosginkgo.h>

#include <resources/ginkgoresourcemanager.h>

#define ID_PACS_ACQUIRE 1052
#define ID_IMPORTAR 1053
#define ID_CERRAR 1054
#define ID_CERRAR_TODAS 1055
#define ID_GUARDAR 1056
#define ID_DESENCAJAR 1057
#define ID_EXPORTAR 1058
#define ID_SALIR 1059
#define ID_ONLINE_SUPPORT 1060
#define ID_EDITOR_DICOM 1061
#define ID_ACERCA_DE 1062
#define ID_CONFIGURACION 1063
#define ID_LICENCIA  1064
#define ID_SUBIR_PACS  1065
#define ID_ASISTENTE_PEGADO 1066
#define ID_IMPRIMIR 1067
#define ID_ABRIR_FICHERO 1068
#define ID_ABRIR_DIRECTORIO 1069
#define ID_PANTALLA_COMPLETA 1070
#define ID_MOSAICO_VERTICAL 1071
#define ID_MOSAICO_HORIZONTAL 1072
#define ID_GRID_2_COLUMNAS 1073
#define ID_GRID_3_COLUMNAS 1074
#define ID_MOSAICO_RESTAURAR 1075
#define ID_CONTROLHL7 1076
#define ID_CONTROLLOGS 1077
#define ID_CHECK_UPDATES 1078
#define ID_ONLINE_MANUAL 1079
#define ID_EXTENSIONS_SUPPORT 1081
#define ID_START_PAGE 1082
#define ID_DICOMDIR_EXPORT 1083
#define ID_OPEN_REMOVABLE 1084


EventoProgreso::EventoProgreso(TipoProgreso tipo, long threadId)
{
	SetEventType(wxEVT_PROGRESO);
	m_Tipo = tipo;
	m_ThreadId = threadId;
}

EventoProgreso::EventoProgreso(const EventoProgreso& event) : wxEvent(event), m_Tipo(event.m_Tipo), m_ThreadId(event.m_ThreadId)
{
}

EventoProgreso::~EventoProgreso()
{
}

wxEvent* EventoProgreso::Clone() const
{
	return new EventoProgreso(*this);
}

IMPLEMENT_DYNAMIC_CLASS(EventoProgreso, wxEvent)



//para el mosaico
class wxImagenMosaico: public wxStaticBitmap{
public:
	wxImagenMosaico(wxWindow* pWindow, wxImage& img) : wxStaticBitmap(pWindow, wxID_ANY, wxNullBitmap, wxDefaultPosition, wxDefaultSize, wxCLIP_CHILDREN)
	{
		m_img=img;
		this->SetBitmap(img);
		//Reescalar();
		this->Connect( wxEVT_SIZE, wxSizeEventHandler( wxImagenMosaico::OnSize ) );
		this->Connect( wxEVT_ERASE_BACKGROUND, wxEraseEventHandler( wxImagenMosaico::OnEraseBackground ) );
		this->Connect( wxEVT_PAINT, wxPaintEventHandler( wxImagenMosaico::OnPaint) );
	}

	~wxImagenMosaico()
	{
		this->Disconnect( wxEVT_SIZE, wxSizeEventHandler( wxImagenMosaico::OnSize ) );
		this->Disconnect( wxEVT_ERASE_BACKGROUND, wxEraseEventHandler( wxImagenMosaico::OnEraseBackground ) );
		this->Disconnect( wxEVT_PAINT, wxPaintEventHandler( wxImagenMosaico::OnPaint) );
	}

	void OnSize(wxSizeEvent& )
	{
		//Reescalar();
	}

	void OnPaint(wxPaintEvent& event)
	{
		//wxStaticBitmap::OnPaint(event);
		event.Skip();
	}

	void OnEraseBackground(wxEraseEvent& event)
	{
		event.Skip(false);
	}

	void Reescalar(){
		/*
		if(m_img.IsOk()){
			if((this->GetSize().x >0 && this->GetSize().y>0) &&
			   (this->GetSize().x < m_img.GetWidth() && this->GetSize().y< m_img.GetHeight()) ){
				wxImage temp=m_img.Scale(this->GetSize().x,this->GetSize().y);
				wxBitmap bmp(temp);
				this->SetBitmap(bmp);
				this->Refresh();
			}
		}
		*/
	}
	wxImage m_img;

};
//para drag and drop
class DropTargetVentanaPrincipal: public wxFileDropTarget
{
public:
	DropTargetVentanaPrincipal():wxFileDropTarget()
	{
	}
	~DropTargetVentanaPrincipal()
	{
	}
	bool OnDropFiles(wxCoord /*x*/, wxCoord /*y*/, const wxArrayString& filenames)
	{
		std::list<std::string> listaPaths;
		for(wxArrayString::const_iterator it = filenames.begin(); it!= filenames.end(); it++)
		{
			if(wxDirExists((*it))) {
				//se leen los ficheros dicom del directorio
				wxDir dir;
				if (dir.Open((*it))) {
					wxString wxPathFich;
					bool cont = dir.GetFirst(&wxPathFich);
					while (cont) {
						wxPathFich=dir.GetName()+ wxFileName::GetPathSeparator(wxPATH_NATIVE) +wxPathFich;
						wxFileName filename(wxPathFich);
						if(filename.GetExt().Lower() == wxT("dcm")) {
							std::string pathStd(TOPATH(wxPathFich));
							listaPaths.push_back(pathStd);
						}
						cont = dir.GetNext(&wxPathFich);
					}
				}
			} else if(wxFileExists((*it))){
				std::string stdPath(TOPATH((*it)));
				listaPaths.push_back(stdPath);
			}
		}

		if(listaPaths.size() > 0) {
			//se lanza el comando de incluir en el historial
			GADAPI::ComandoIncluirHistorial::ComandoIncluirHistorialParams* pParams = new GADAPI::ComandoIncluirHistorial::ComandoIncluirHistorialParams(listaPaths,true);
			GADAPI::ComandoIncluirHistorial::ComandoIncluirHistorial* pCmd = new GADAPI::ComandoIncluirHistorial::ComandoIncluirHistorial(pParams);
			GNC::Entorno::Instance()->GetControladorComandos()->ProcessAsync(_Std("Included in the history ..."),pCmd, NULL);
		}
		return true;
	}
};

// Mapeo de eventos

BEGIN_EVENT_TABLE(VentanaPrincipal, VentanaPrincipalBase)
EVT_CLOSE(VentanaPrincipal::OnWindowClose)
EVT_MENU(ID_Inicio_Aplicacion, VentanaPrincipal::OnInicioAplicacion)
END_EVENT_TABLE()

VentanaPrincipal::VentanaPrincipal(const wxString& title) : VentanaPrincipalBase(NULL, wxID_ANY, title), m_mgr(m_pPanelCentral, AUI_NAMESPACE wxAUI_MGR_ALLOW_FLOATING | AUI_NAMESPACE  wxAUI_MGR_TRANSPARENT_DRAG |AUI_NAMESPACE  wxAUI_MGR_VENETIAN_BLINDS_HINT )

{
    //SetDoubleBuffered(true);
	m_Iniciada = false;
	m_VersionChecked = false;
	wxIcon icono;
	m_pPrintData = new wxPrintData();
	icono.CopyFromBitmap(GinkgoResourcesManager::Logos::GetLogoGinkgo32x32());
	this->SetIcon(icono);

	m_TratandoDeCerrar = false;
	m_SuperFreezeCount = 0;

	disabler = NULL;

	GNC::Entorno* pEntorno = GNC::Entorno::Instance();

	pEntorno->SetVentanaPrincipal(this);
	pEntorno->SetVentanaRaiz(m_pPanelCentral);

	SetAutoLayout(true);

	// Subscripción a la notificación de carga y descarga de extensiones
	pEntorno->ObservadoresExtensiones.push_back(this);

	// Subscripción a la notificación de activación y desactivación de vistas/estudios
	pEntorno->ObservadoresVistas.push_back(this);
	pEntorno->SetPanelHerramientasSuperior(m_pPanelHerramientasSuperior);
	pEntorno->SetSizerHerramientas(m_pSizerHerramientas);
	pEntorno->SetSizerHerramientasOpciones(m_pSizerHerramientasOpciones);

	m_mgr.SetDockSizeConstraint(0.5f, 0.5f);

	//menu and tool bar
	GNC::ControladorHerramientas::Instance();
	m_pBarraComun = new AUI_NAMESPACE wxAuiToolBar(m_pPanelHerramientasSuperior, wxID_ANY, wxDefaultPosition, wxDefaultSize,
																			AUI_NAMESPACE wxAUI_TB_DEFAULT_STYLE );
	m_pBarraComun->SetToolBitmapSize(wxSize(16,16));
	m_pSizerPanelHerramientasSuperior->Insert(0, m_pBarraComun, 0, wxEXPAND, 0);
	m_pBarraComun->Show();
	this->Connect(ID_ABRIR_FICHERO,wxEVT_COMMAND_AUITOOLBAR_TOOL_DROPDOWN, wxAuiToolBarEventHandler(VentanaPrincipal::OnDropDownAcquire) );
	this->Connect(ID_PACS_ACQUIRE,wxEVT_COMMAND_AUITOOLBAR_TOOL_DROPDOWN, wxAuiToolBarEventHandler(VentanaPrincipal::OnDropDownPacs) );
	m_pMenuBar = new wxMenuBar( wxMB_DOCKABLE );
	//

	GNC::GUI::StatusBarProgreso* pStatusBar = new GNC::GUI::StatusBarProgreso(this, m_pPanelCentral, true);
	SetStatusBar(pStatusBar);

	{
		wxString wxCaption = _("Tasks");
		AUI_NAMESPACE wxAuiPaneInfo pi(AUI_NAMESPACE wxAuiPaneInfo().Caption(wxCaption).Float().BestSize(400,170).MinSize(200,100).Resizable(true).CloseButton(true).Show(false));
		pi.DestroyOnClose(false);
		m_mgr.AddPane(pStatusBar->m_pPanelTareas, pi);
	}

	GNC::GCS::ControladorComandos::Instance()->RegistrarProgreso(pStatusBar);
	GNC::GCS::ControladorComandos::Instance()->RegistrarVentana(this);
	Connect(wxEVT_PROGRESO, EventoProgresoFunctionHandler(VentanaPrincipal::OnComando), NULL, this);

	m_pNoteBook = new AUI_NAMESPACE wxAuiNotebook(m_pPanelCentral, wxID_ANY,wxDefaultPosition,
												  wxDefaultSize,
												  AUI_NAMESPACE wxAUI_NB_TAB_SPLIT |  AUI_NAMESPACE wxAUI_NB_TAB_MOVE | AUI_NAMESPACE wxAUI_NB_SCROLL_BUTTONS | AUI_NAMESPACE wxAUI_NB_WINDOWLIST_BUTTON | AUI_NAMESPACE wxAUI_NB_CLOSE_ON_ALL_TABS | wxEXPAND );
	m_pNoteBook->SetBackgroundColour(wxColour(180, 180, 180));
	m_pNoteBook->Connect( wxEVT_CHILD_FOCUS, wxChildFocusEventHandler( VentanaPrincipal::OnNotebookFocus ) );
	m_pNoteBook->Connect( wxEVT_ERASE_BACKGROUND, wxEraseEventHandler( VentanaPrincipal::OnNoteBookEraseBackground ) );

	m_mgr.AddPane(m_pNoteBook, AUI_NAMESPACE wxAuiPaneInfo().Name(wxT("vistas")).CenterPane().Layer(0).PaneBorder(true).Movable(false).Floatable(false).Dockable(false).LeftDockable(false).RightDockable(false).TopDockable(false).BottomDockable(false).CloseButton(false).Hide());

	{
		m_pGridPanel = new wxScrolledWindow(m_pPanelCentral);
		m_pGridPanel->SetBackgroundColour(wxColour(64, 64, 64));
		wxGridSizer* sizer = new wxGridSizer(3,3,1,1);
		m_pGridPanel->SetSizer(sizer);
		m_mgr.AddPane(m_pGridPanel, wxAuiPaneInfo().Name(wxT("Grid")).CenterPane().Layer(0).PaneBorder(true).Movable(true).Floatable(true).Dockable(true).LeftDockable(true).RightDockable(true).TopDockable(true).BottomDockable(true).Hide());
		m_pGridPanel->SetScrollRate(5,5);
	}

	{

		m_pMosaicPanel = new wxPanel(m_pPanelCentral);
		m_pMosaicPanel->SetBackgroundColour(wxColour(64,64,64));

		wxGridBagSizer* sizer = new wxGridBagSizer(0,0);
		m_pMosaicPanel->SetSizer(sizer);

		wxImage imagen = GinkgoResourcesManager::Logos::GetLogoBackground().ConvertToImage();
		wxImagenMosaico* pTmpBmp = new wxImagenMosaico(m_pMosaicPanel,imagen);

		sizer->AddGrowableCol( 0 );
		sizer->AddGrowableRow( 0 );
		sizer->SetFlexibleDirection( wxBOTH );
		sizer->SetNonFlexibleGrowMode( wxFLEX_GROWMODE_SPECIFIED );

		sizer->Add( pTmpBmp, wxGBPosition( 1, 1 ), wxGBSpan( 1, 1 ), wxEXPAND | wxALL | wxALIGN_RIGHT, 2 );

		m_mgr.AddPane(m_pMosaicPanel, AUI_NAMESPACE wxAuiPaneInfo().Name(_("Mosaic")).CenterPane().Layer(0).PaneBorder(true).Movable(false).Floatable(false).Dockable(false).LeftDockable(false).RightDockable(false).TopDockable(false).BottomDockable(false).CloseButton(false));
	}
	//



	wxString wxCaption;

	wxCaption = _("Medical History");

	GNC::GUI::PanelHistorial2* panelHistorial = new GNC::GUI::PanelHistorial2(this);
	panelHistorial->Connect(wxEVT_KEY_DOWN, wxKeyEventHandler(VentanaPrincipal::OnKeyDown), NULL, this);
	/*AUI_NAMESPACE wxAuiPaneInfo pi(AUI_NAMESPACE wxAuiPaneInfo().Name(wxCaption).Caption(wxCaption).Left().Position(0).Layer(1).PaneBorder(true).Floatable(true).LeftDockable(true).Dockable(true).FloatingSize(300, -1).MaxSize(300,100).BestSize(230,100).MinSize(230,100).RightDockable(true).TopDockable(true).BottomDockable(true).CloseButton(false));
	pi.dock_proportion = 3;
	m_mgr.AddPane(panelHistorial, pi);*/

	m_pSizerCentral->Insert(0, panelHistorial,0,wxEXPAND,0);

	m_pHistorial = panelHistorial;

	m_mgr.Update();


	//hay que conectarlo al auimanager, porque el notebook delega el procesado de eventos al auimanager
	{
		AUI_USE_NAMESPACE()

		m_mgr.Connect(wxEVT_COMMAND_AUINOTEBOOK_PAGE_CLOSE, wxAuiNotebookEventHandler(VentanaPrincipal::OnNotebookPageClose),NULL,this);
		m_mgr.Connect(wxEVT_COMMAND_AUINOTEBOOK_PAGE_CHANGING, wxAuiNotebookEventHandler(VentanaPrincipal::OnNotebookPageChanging), NULL, this);
		m_mgr.Connect(wxEVT_COMMAND_AUINOTEBOOK_PAGE_CHANGED, wxAuiNotebookEventHandler(VentanaPrincipal::OnNotebookPageChanged),NULL,this);
		m_mgr.Connect(wxEVT_COMMAND_AUINOTEBOOK_TAB_RIGHT_UP, wxAuiNotebookEventHandler(VentanaPrincipal::OnNotebookMenuTab),NULL,this);
		m_mgr.Connect(wxEVT_COMMAND_AUINOTEBOOK_TAB_RIGHT_DOWN, wxAuiNotebookEventHandler(VentanaPrincipal::OnNotebookCambiarTab),NULL,this);

		m_mgr.Connect(wxEVT_AUI_PANE_CLOSE, wxAuiManagerEventHandler(VentanaPrincipal::OnPanelClose),NULL,this);
	}

	SetDropTarget(new DropTargetVentanaPrincipal());

	m_pPanelHerramientasSuperior->Layout();
	Layout();

}

VentanaPrincipal::~VentanaPrincipal()
{
	m_pNoteBook->Disconnect( wxEVT_CHILD_FOCUS, wxChildFocusEventHandler( VentanaPrincipal::OnNotebookFocus ) );

	Disconnect(wxEVT_PROGRESO, EventoProgresoFunctionHandler(VentanaPrincipal::OnComando), NULL, this);
	GNC::GCS::ControladorComandos::Instance()->RegistrarVentana(NULL);
	GNC::GCS::ControladorComandos::Instance()->RegistrarProgreso(NULL);
	GNC::GUI::DialogoAdquisicion::FreeInstance();
	GNC::GCS::ControladorComandos::Instance()->AbortarComandosDeOwner(NULL);
	delete m_pPrintData;
	//cierra la ventana si esta abierta
	GNC::GUI::VentanaControlHL7::CerrarSiAbierta();
	GNC::GUI::VentanaControlLogs::CerrarSiAbierta();

	{
		AUI_USE_NAMESPACE()
		m_mgr.Disconnect(wxEVT_COMMAND_AUINOTEBOOK_PAGE_CLOSE, AUI_NAMESPACE wxAuiNotebookEventHandler(VentanaPrincipal::OnNotebookPageClose),NULL,this);
		m_mgr.Disconnect(m_pNoteBook->GetId(), wxEVT_COMMAND_AUINOTEBOOK_PAGE_CHANGED, AUI_NAMESPACE wxAuiNotebookEventHandler(VentanaPrincipal::OnNotebookPageChanged),NULL,this);
	}

	//menus
	this->Disconnect( wxID_ANY, wxEVT_COMMAND_MENU_SELECTED, wxCommandEventHandler( VentanaPrincipal::OnPACSAcquisition ) );
	this->Disconnect( wxID_ANY, wxEVT_COMMAND_MENU_SELECTED, wxCommandEventHandler( VentanaPrincipal::OnAbrirFichero ) );
	this->Disconnect( wxID_ANY, wxEVT_COMMAND_MENU_SELECTED, wxCommandEventHandler( VentanaPrincipal::OnAbrirDirectorio ) );
	this->Disconnect( wxID_ANY, wxEVT_COMMAND_MENU_SELECTED, wxCommandEventHandler( VentanaPrincipal::OnImportar ) );
	this->Disconnect( wxID_ANY, wxEVT_COMMAND_MENU_SELECTED, wxCommandEventHandler( VentanaPrincipal::OnMenuCerrarTabClick ) );
	this->Disconnect( wxID_ANY, wxEVT_UPDATE_UI, wxUpdateUIEventHandler( VentanaPrincipal::OnMenuCerrarTabUpdateUI ) );
	this->Disconnect( wxID_ANY, wxEVT_COMMAND_MENU_SELECTED, wxCommandEventHandler( VentanaPrincipal::OnMenuCerrarTodosTabsClick ) );
	this->Disconnect( wxID_ANY, wxEVT_UPDATE_UI, wxUpdateUIEventHandler( VentanaPrincipal::OnMenuCerrarTodosTabsUpdateUI ) );
	this->Disconnect( wxID_ANY, wxEVT_COMMAND_MENU_SELECTED, wxCommandEventHandler( VentanaPrincipal::OnGuardar ) );
	this->Disconnect( wxID_ANY, wxEVT_UPDATE_UI, wxUpdateUIEventHandler( VentanaPrincipal::OnUpdateGuardar ) );
	this->Disconnect( wxID_ANY, wxEVT_COMMAND_MENU_SELECTED, wxCommandEventHandler( VentanaPrincipal::OnSubirPACS ) );
	this->Disconnect( wxID_ANY, wxEVT_UPDATE_UI, wxUpdateUIEventHandler( VentanaPrincipal::OnUpdateSubirPACS ) );
	this->Disconnect( wxID_ANY, wxEVT_COMMAND_MENU_SELECTED, wxCommandEventHandler( VentanaPrincipal::OnExportar ) );
	this->Disconnect( wxID_ANY, wxEVT_UPDATE_UI, wxUpdateUIEventHandler( VentanaPrincipal::OnUpdateExportar ) );
	this->Disconnect( wxID_ANY, wxEVT_COMMAND_MENU_SELECTED, wxCommandEventHandler( VentanaPrincipal::OnSalir ) );
	this->Disconnect( wxID_ANY, wxEVT_COMMAND_MENU_SELECTED, wxCommandEventHandler( VentanaPrincipal::OnConfiguracion ) );
	this->Disconnect( wxID_ANY, wxEVT_COMMAND_MENU_SELECTED, wxCommandEventHandler( VentanaPrincipal::OnMensajesHL7 ) );
	this->Disconnect( wxID_ANY, wxEVT_COMMAND_MENU_SELECTED, wxCommandEventHandler( VentanaPrincipal::OnControlLogs ) );
	this->Disconnect( wxID_ANY, wxEVT_COMMAND_MENU_SELECTED, wxCommandEventHandler( VentanaPrincipal::OnAcercaDe ) );
	this->Disconnect( wxID_ANY, wxEVT_COMMAND_MENU_SELECTED, wxCommandEventHandler( VentanaPrincipal::OnMenuImprimir ) );
	this->Disconnect( wxID_ANY, wxEVT_UPDATE_UI, wxUpdateUIEventHandler( VentanaPrincipal::OnMenuImprimirUpdateUI ) );
	this->Disconnect( wxID_ANY, wxEVT_COMMAND_MENU_SELECTED, wxCommandEventHandler( VentanaPrincipal::OnPantallaCompleta ) );
	this->Disconnect( wxID_ANY, wxEVT_COMMAND_MENU_SELECTED, wxCommandEventHandler( VentanaPrincipal::OnMosaicoHorizontal ) );
	this->Disconnect( wxID_ANY, wxEVT_COMMAND_MENU_SELECTED, wxCommandEventHandler( VentanaPrincipal::OnMosaicoVertical ) );
	this->Disconnect( wxID_ANY, wxEVT_COMMAND_MENU_SELECTED, wxCommandEventHandler( VentanaPrincipal::OnMosaicoRestaurar ) );
	this->Disconnect( wxID_ANY, wxEVT_COMMAND_MENU_SELECTED, wxCommandEventHandler( VentanaPrincipal::OnMosaicoGrid2Col ) );
	this->Disconnect( wxID_ANY, wxEVT_COMMAND_MENU_SELECTED, wxCommandEventHandler( VentanaPrincipal::OnMosaicoGrid3Col ) );
	this->Disconnect(wxID_ANY,wxEVT_COMMAND_AUITOOLBAR_TOOL_DROPDOWN, wxAuiToolBarEventHandler(VentanaPrincipal::OnDropDownAcquire) );
	this->Disconnect(wxID_ANY,wxEVT_COMMAND_AUITOOLBAR_TOOL_DROPDOWN, wxAuiToolBarEventHandler(VentanaPrincipal::OnDropDownPacs) );

	//
	GNC::Entorno* pEntorno = GNC::Entorno::Instance();

	GNC::ControladorExtensiones::Instance()->DesRegistrarModulos();
	GNC::GCS::ControladorVistas::FreeInstance();
	m_mgr.UnInit();
	pEntorno->ObservadoresExtensiones.remove(this);
	pEntorno->ObservadoresVistas.remove(this);
	pEntorno->SetVentanaPrincipal(NULL);
	pEntorno->SetVentanaRaiz(NULL);
}

//region "Eventos de comprobacion de actualizaciones"
void VentanaPrincipal::ComprobarActualizaciones()
{
	bool check;
	GNC::GCS::ConfigurationController::Instance()->readBoolGeneral("/GinkgoCore/Estacion", "CheckForUpdates", check, true);
	if (check) {
		m_VersionChecked = false;
		//this is the profile
		GNC::GCS::Permisos::EstadoPermiso updates = GNC::GCS::ControladorPermisos::Instance()->Get("core.update","check_updates");
		if (updates) {
			bool tryCheck = false;
			std::string lastDateStr;
			if (GNC::GCS::ConfigurationController::Instance()->readStringGeneral("/GinkgoCore/LastUpdateDateTime", "LastDate", lastDateStr)) 
			{
				GNC::GCS::Permisos::EstadoPermiso period = GNC::GCS::ControladorPermisos::Instance()->Get("core.update","update_period");
				std::string periodStr = period.ObtenerValor<std::string>();
				long iPeriod;
				if (!wxString::FromUTF8(periodStr.c_str()).ToLong(&iPeriod)) {
					iPeriod = 2;
				}

				wxDateTime lastDate;

				lastDate.ParseFormat(wxString::FromUTF8(lastDateStr.c_str()), wxT("%d/%m/%Y %H:%M:%S"));
				if (!lastDate.IsValid()) {
					lastDate = wxDateTime::Now();
					lastDate.Subtract( wxDateSpan(0, 0, 0, iPeriod + 1 ) );
				}

				if (wxDateTime::Now().Subtract(lastDate).GetDays() > iPeriod) {
					tryCheck = true;
					GNC::GCS::ControladorComandos::Instance()->ProcessAsync(_Std("Check Updates"),
						new GNC::ComandoComprobarActualizaciones(new GNC::ComandoComprobarActualizacionesParams(updates.ObtenerValor<std::string>(), false) ), this);
				}

			} else {
				//if there is no date in the ini file update will be checked
				GNC::GCS::ControladorComandos::Instance()->ProcessAsync(_Std("Check Updates"),
					new GNC::ComandoComprobarActualizaciones(new GNC::ComandoComprobarActualizacionesParams(updates.ObtenerValor<std::string>(), false) ), this);
				tryCheck = true;
			}

			if (tryCheck) {
				//writes date
				GNC::GCS::ConfigurationController::Instance()->writeStringGeneral("/GinkgoCore/LastUpdateDateTime", "LastDate", std::string(wxDateTime::Now().Format(wxT("%d/%m/%Y %H:%M:%S")).ToUTF8()));
			}
		}
	}

}

void VentanaPrincipal::OnDoNotWarnAgainClicked( wxCommandEvent& /*event*/ )
{
	if (m_VersionChecked) {
		wxString valor;
		if (m_pDoNotWarnAgain->GetValue()) {
			GNC::GCS::ConfigurationController::Instance()->writeStringGeneral("/GinkgoCore/SkipUpdate", m_VersionCheck, "1");
		}
		else{
			GNC::GCS::ConfigurationController::Instance()->writeStringGeneral("/GinkgoCore/SkipUpdate", m_VersionCheck, "0");
		}
		GNC::GCS::ConfigurationController::Instance()->Flush();
	}

}

void VentanaPrincipal::OnVersionNotifierClose( wxCommandEvent& /*event*/ )
{
	wxWindowDisabler dis;
	SuperFreeze();
	m_pPanelActualizacion->Hide();
	//m_pPanelCentral->Layout();
	Layout();
	Refresh(true);
	SuperThaw();

}
//endregion



void VentanaPrincipal::ForzarCambioVista(GNC::GCS::IVista* pVistaCambiar)
{
	//se cambia la pestaña
	//bool cerrar = true;

	GNC::GCS::ControladorVistas* pcv = GNC::GCS::ControladorVistas::Instance();
	if (pcv == NULL) {
		std::cerr << "Error: No se pudo obtener el controlador de vistas" << std::endl;
		return ;
	}

	if (pcv->GetVistaActiva() != pVistaCambiar) {
		pcv->SolicitarActivarVista(pVistaCambiar);
	}

	for (GNC::GCS::ControladorVistas::MapaVentanas::iterator it = pcv->m_MapaVentanas.begin(); it != pcv->m_MapaVentanas.end(); it++) {
		wxWindow* pVentana = (*it).first;
		GNC::GCS::IVista*   pVista = (*it).second;
		if (pVentana != NULL && pVista != NULL) {
			if (pVistaCambiar == pVista) {
				//Tenemos la ventana, la vista y el estudio
				//primero cambiamos de pestaña
				int selection = m_pNoteBook->GetPageIndex(pVentana);
				if (m_pNoteBook->IsShown() && selection >= 0) {
					if(selection >= 0 && selection != m_pNoteBook->GetSelection()){
						wxWindowDisabler dis;
						SuperFreeze();
						m_pNoteBook->SetSelection(selection);
						SuperThaw();
						return;
					}
				} else {
					//desencajado
					GNC::GUI::DialogoDesencajado* pDialogo = dynamic_cast<GNC::GUI::DialogoDesencajado*> (pVentana->GetParent());
					if(pDialogo != NULL) {
						pDialogo->Raise();
					} else {
						//panel grid
						GNC::GUI::PanelGrid* pGrid = dynamic_cast<GNC::GUI::PanelGrid*> (pVentana->GetParent());
						if (pGrid != NULL) {
							//TODO se debería hacer scroll a la posición del panel grid
						}
					}
				}
			}
		}
	}
}

void VentanaPrincipal::OnSalir(wxCommandEvent& WXUNUSED(event))
{
	SuperFreeze();
	Close(true);
	SuperThaw();
}

void VentanaPrincipal::OnDropDownAcquire(wxAuiToolBarEvent& event)
{
	if (event.IsDropDownClicked())
	{
		wxAuiToolBar* tb = static_cast<wxAuiToolBar*>(event.GetEventObject());

		tb->SetToolSticky(event.GetId(), true);

		// create the popup menu
		wxMenu menuPopup;

		wxMenuItem* pMenuAbrirFichero = new wxMenuItem( &menuPopup, ID_ABRIR_FICHERO, wxString( _("Open file")) + wxT("\tAlt+f"), _("Open a DICOM file"), wxITEM_NORMAL );
		wxMenuItem* pMenuAbrirDirectorio = new wxMenuItem( &menuPopup, ID_ABRIR_DIRECTORIO, wxString( _("Open folder")) + wxT("\tAlt+d"), _("Acquire from a local folder"), wxITEM_NORMAL );
		wxMenuItem* pMenuRemovableUnit = new wxMenuItem ( &menuPopup, ID_OPEN_REMOVABLE, wxString(_("Open removable unit")), _("Acquire from a removable unit"), wxITEM_NORMAL );
		#ifdef __WXMSW__
		pMenuAbrirFichero->SetBitmaps(GinkgoResourcesManager::IconosMenus::GetIcoOpenFile());
		pMenuAbrirDirectorio->SetBitmaps(GinkgoResourcesManager::IconosMenus::GetIcoOpenDir());
		pMenuRemovableUnit->SetBitmaps(GinkgoResourcesManager::IconosMenus::GetIcoRemovableUnit());
		#else
		pMenuAbrirFichero->SetBitmap(GinkgoResourcesManager::IconosMenus::GetIcoOpenFile());
		pMenuAbrirDirectorio->SetBitmap(GinkgoResourcesManager::IconosMenus::GetIcoOpenDir());
		pMenuRemovableUnit->SetBitmap(GinkgoResourcesManager::IconosMenus::GetIcoOpenDir());
		#endif

		menuPopup.Append( pMenuAbrirFichero );
		menuPopup.Append( pMenuAbrirDirectorio );
		#ifdef _WIN32
		menuPopup.Append( pMenuRemovableUnit );
		#else
		delete pMenuRemovableUnit;
		#endif


		// line up our menu with the button
		wxRect rect = tb->GetToolRect(event.GetId());
		wxPoint pt = tb->ClientToScreen(rect.GetBottomLeft());
		pt = ScreenToClient(pt);


		PopupMenu(&menuPopup, pt);


		// make sure the button is "un-stuck"
		tb->SetToolSticky(event.GetId(), false);
	}
}

void VentanaPrincipal::OnDropDownPacs(wxAuiToolBarEvent& event)
{
	if (event.IsDropDownClicked())
	{
		wxAuiToolBar* tb = static_cast<wxAuiToolBar*>(event.GetEventObject());

		tb->SetToolSticky(event.GetId(), true);

		// create the popup menu
		wxMenu menuPopup;
		wxMenuItem* m_pMenuAdquirir = new wxMenuItem( &menuPopup, ID_PACS_ACQUIRE, wxString( _("Acquire a DICOM study from PACS") ) + wxT("\tAlt+a"), _("Acquire a DICOM study from PACS"), wxITEM_NORMAL );
		#ifdef __WXMSW__
		m_pMenuAdquirir->SetBitmaps(GinkgoResourcesManager::IconosMenus::GetIcoAbrir());
		#else
		m_pMenuAdquirir->SetBitmap(GinkgoResourcesManager::IconosMenus::GetIcoAbrir());
		#endif
		menuPopup.Append( m_pMenuAdquirir );

		InsertToolsFromFamily(&menuPopup, GNC::GCS::IHerramienta::TMenuPACSAcquisition);	

		// line up our menu with the button
		wxRect rect = tb->GetToolRect(event.GetId());
		wxPoint pt = tb->ClientToScreen(rect.GetBottomLeft());
		pt = ScreenToClient(pt);

		PopupMenu(&menuPopup, pt);

		// make sure the button is "un-stuck"
		tb->SetToolSticky(event.GetId(), false);
	}
}

void VentanaPrincipal::OnAcercaDe(wxCommandEvent& WXUNUSED(event))
{
	AboutDialog* dlg = new AboutDialog(this);
	dlg->ShowModal();
}

void VentanaPrincipal::OnOnlineHelp(wxCommandEvent& /*event*/)
{
	GNC::GCS::Permisos::EstadoPermiso updates = GNC::GCS::ControladorPermisos::Instance()->Get("core.help","url_manual");
	wxString urlManual = wxString::FromUTF8(updates.ObtenerValor<std::string>().c_str());
	if (urlManual != wxEmptyString) {
		wxLaunchDefaultBrowser(urlManual);
	}
}

void VentanaPrincipal::OnOnlineSupport(wxCommandEvent& /*event*/)
{
	GNC::GCS::Permisos::EstadoPermiso updates = GNC::GCS::ControladorPermisos::Instance()->Get("core.help","url_support");
	wxString urlSupport = wxString::FromUTF8(updates.ObtenerValor<std::string>().c_str());
	if (urlSupport != wxEmptyString) {
		wxLaunchDefaultBrowser(urlSupport);
	}
}

void VentanaPrincipal::OnExtensionsSupport(wxCommandEvent& /*event*/)
{
	GNC::GCS::Permisos::EstadoPermiso updates = GNC::GCS::ControladorPermisos::Instance()->Get("core.help","extensions_support_1");
	wxString urlSupport = wxString::FromUTF8(updates.ObtenerValor<std::string>().c_str());
	if (urlSupport != wxEmptyString) {
		wxLaunchDefaultBrowser(urlSupport);
	}
}

/* Evento de lanzamiento de la comprobacion de actualizaciones */
void VentanaPrincipal::OnCheckForUpdates(wxCommandEvent& /*event*/)
{
	m_VersionChecked = false;
	GNC::GCS::Permisos::EstadoPermiso updates = GNC::GCS::ControladorPermisos::Instance()->Get("core.update","check_updates");
	if (updates.ObtenerValor<std::string>().empty()) {
		wxMessageBox(_("There is no URL to check updates on the current configuration."), _("Check update error"),wxICON_ERROR);
	}
	else {
		GNC::GCS::ControladorComandos::Instance()->ProcessAsync(_Std("Check Updates"),
			new GNC::ComandoComprobarActualizaciones(new GNC::ComandoComprobarActualizacionesParams(updates.ObtenerValor<std::string>(), true) ), this);

		GNC::GCS::ConfigurationController::Instance()->writeStringGeneral("/GinkgoCore/LastUpdateDateTime", "LastDate", std::string(wxDateTime::Now().Format().ToUTF8()));
	}
}

/*startup page*/
void VentanaPrincipal::OnShowStartupPage(wxCommandEvent& /*event*/)
{
	ShowStartupPage();
}

void VentanaPrincipal::ShowStartupPage()
{
	GNC::GCS::IControladorVistas* pCtrlVistas = GNC::GCS::ControladorVistas::Instance();
	SuperFreeze();
	GnkPtr<GNC::GUI::StartUpStudy> study(new GNC::GUI::StartUpStudy());
	study->Entorno = GNC::Entorno::Instance();
	study->Modulo = NULL;
	study->VentanaPadre = pCtrlVistas->GetRootWindow();
	GNC::GCS::IVista* pView = new GNC::GUI::StartUpView(study);
	pCtrlVistas->Registrar(pView);
	
	GnkPtr<GIL::IModeloIntegracion> ptr;
	GNC::Entorno::Instance()->GetControladorCarga()->CargaAsincrona(pView, ptr, "", false);
	SuperThaw();
}

void VentanaPrincipal::OnPACSAcquisition(wxCommandEvent& WXUNUSED(event))
{
	GNC::GUI::DialogoAdquisicion::Instance()->Show();
}

void VentanaPrincipal::OnAbrirFichero(wxCommandEvent& )
{
	GNC::GUI::Abrir::AbrirFichero(this);
}

void VentanaPrincipal::OnOpenRemovableUnit(wxCommandEvent& )
{
	GADAPI::OpenRemovableUnitCommandParams* pParams = new GADAPI::OpenRemovableUnitCommandParams(this);
	GADAPI::OpenRemovableUnitCommand* pCmd = new GADAPI::OpenRemovableUnitCommand(pParams);
	GNC::GCS::ControladorComandos::Instance()->ProcessAsync("Listing units...", pCmd, NULL);
}

void VentanaPrincipal::OnAbrirDirectorio(wxCommandEvent& )
{
	GNC::GUI::Abrir::AbrirDirectorio(this);
}

class DialogoComandosEnEjecucion: public DialogoComandosEnEjecucionBase
{
public:
	DialogoComandosEnEjecucion(wxWindow* pParent, std::list<std::string>& listaNombres) : DialogoComandosEnEjecucionBase(pParent)
	{
		for (std::list<std::string>::iterator it = listaNombres.begin(); it!= listaNombres.end(); it++) {
			m_pListacomandos->Append(wxString::FromUTF8((*it).c_str()));
		}
		Layout();
	}

	~DialogoComandosEnEjecucion()
	{
	}
};

void VentanaPrincipal::OnWindowClose(wxCloseEvent& event) {
#if defined (_WINDOWS)
	wxWindowDisabler* dis = new wxWindowDisabler();
#endif
	SuperFreeze();

	GNC::GCS::ControladorComandos::ListaNombreComandos comandos =  GNC::GCS::ControladorComandos::Instance()->GetComandosActivos();
	if(comandos.size()>0) {
		DialogoComandosEnEjecucion dlg(this,comandos);
#if defined (_WINDOWS)
		delete dis;
		dis = NULL;
#endif
		this->SuperThaw();
		int answer = dlg.ShowModal();
#if defined (_WINDOWS)
		dis = new wxWindowDisabler();
#endif
		this->SuperFreeze();
		if(answer != wxID_OK) {
			event.Veto(true);
#if defined (_WINDOWS)
			delete dis;
#endif
			this->SuperThaw();
			return;
		}
	}

	GNC::GCS::ControladorComandos::Instance()->AbortarComandosDeOwner(this);

	if(CerrarTodosLosTabsYPanelGrids()) {
		//cerramos todos las ventanas flotantes que podamos haber abierto...
		int numeroVistas = GNC::GCS::ControladorVistas::Instance()->GetVistas().size();
		while (numeroVistas == (int)GNC::GCS::ControladorVistas::Instance()->GetVistas().size() && GNC::GCS::ControladorVistas::Instance()->GetVistas().size()>0) {
			wxWindow* ventana = GNC::GCS::ControladorVistas::Instance()->GetVistas().front()->GetWindow();
			GNC::GUI::DialogoDesencajado* pDialogo = dynamic_cast<GNC::GUI::DialogoDesencajado*> (ventana->GetParent());
			if(pDialogo != NULL) {
				if(!pDialogo->Close()){
					event.Veto(true);
					break;
				}
			}
			numeroVistas --;
		}
		if(GNC::GCS::ControladorVistas::Instance()->GetVistas().size() == 0) {
			this->Destroy();
		} else {
			event.Veto(true);
		}
	} else {
		//si quedan tabs o panelgrids
		event.Veto(true);
	}
	SuperThaw();
	if (!event.GetVeto()) {
		GNC::Entorno::Instance()->SetVentanaPrincipal(NULL);
		GNC::Entorno::Instance()->SetVentanaRaiz(NULL);
		GNC::Entorno::Instance()->SetPanelHerramientasSuperior(NULL);
		GNC::Entorno::Instance()->SetSizerHerramientas(NULL);
		GNC::Entorno::Instance()->SetSizerHerramientasOpciones(NULL);
	}
#if defined(_WINDOWS)
	delete dis;
#endif
}

void VentanaPrincipal::OnImportar(wxCommandEvent& WXUNUSED(event))
{
	try{
		GNC::GUI::wxWizardImportacionGinkgo ib(this,NULL);

		ib.ShowModal();
	}
	catch(GIL::DICOM::I2DException i){

	}
}

#ifdef __WXMAC__
void VentanaPrincipal::MacOpenFile(const wxString &fileName) {
	try{
		std::vector<std::string> ruta;
		ruta.push_back(std::string(fileName.ToUTF8()));
		//m_pHistorial->CargarDICOM(ruta,true);
	}
	catch(GIL::DICOM::I2DException i){
		LOG_ERROR("Principal", "Error al cargar fichero: " << i);
	}
}
#endif

void VentanaPrincipal::OnGuardar(wxCommandEvent& WXUNUSED(event)) {
	GNC::GCS::IVista* pVistaActiva = GNC::GCS::ControladorVistas::Instance()->GetVistaActiva();
	if (pVistaActiva != NULL) {
		pVistaActiva->Guardar();
	}
}


void VentanaPrincipal::OnExportar(wxCommandEvent& WXUNUSED(event))
{
	GNC::GCS::IVista* pVistaActiva = GNC::GCS::ControladorVistas::Instance()->GetVistaActiva();
	if (pVistaActiva == NULL) {
		return;
	}
	if(pVistaActiva->EstaModificada()){
		int answer = wxMessageBox(_("The study you want to export is modified.\nWould you like to save it?"), _("Data modified"), wxYES_NO | wxCANCEL, this);
		if (answer == wxCANCEL) {
			return;
		} else if (answer == wxYES) {
			//guardar
			pVistaActiva->Guardar();
		}
	}
	
	GNC::GUI::wxWidzardExportacionGinkgo adWiz(this,pVistaActiva);
	adWiz.ShowModal();
}

void VentanaPrincipal::OnDicomDirExport( wxCommandEvent& WXUNUSED(event))
{
	GNC::GUI::wxWizardDicomDirExport adWiz(this);
	adWiz.ShowModal();
}

/* Evento de exportado de un subir al pacs */
void VentanaPrincipal::OnSubirPACS(wxCommandEvent& )
{
	GNC::GUI::wxWizardUploadPACSGinkgo dlg(this);
	dlg.ShowModal();
}

/* Evento de actualizacion de elemento de menu de guardar */
void VentanaPrincipal::OnUpdateGuardar(wxUpdateUIEvent& event) {
	GNC::GCS::IVista* pVistaActiva = GNC::GCS::ControladorVistas::Instance()->GetVistaActiva();
	if (pVistaActiva != NULL && pVistaActiva->SoportaGuardar()) {
		if ( pVistaActiva->EstaModificada()) {
			event.Enable(true);
		}
		else {
			event.Enable(false);
		}
	}
	else {
		event.Enable(false);
	}
}

/* Evento de actualizacion de elemento de menu de exportar */
void VentanaPrincipal::OnUpdateExportar(wxUpdateUIEvent& event) {
	GNC::GCS::IVista* pVistaActiva = GNC::GCS::ControladorVistas::Instance()->GetVistaActiva();
	if (pVistaActiva != NULL) {
		event.Enable(!pVistaActiva->GetRutasImagenes().empty());
	}else{
		event.Enable(false);
	}
}

/* Evento de actualizacion de elemento de menu de subir al pacs */
void VentanaPrincipal::OnUpdateSubirPACS(wxUpdateUIEvent& event)
{
	event.Enable(true);
}

/* Evento de configuracion */
void VentanaPrincipal::OnConfiguracion(wxCommandEvent& /*event*/){

	GNC::GUI::DialogoConfiguracion config(this);
	config.ShowModal();
}

/*Evento de ventana de control de envio HL7*/
void VentanaPrincipal::OnMensajesHL7(wxCommandEvent& /*event*/)
{
	GNC::GUI::VentanaControlHL7* ventana = GNC::GUI::VentanaControlHL7::Instance();
	if(!ventana->IsActive()) {
		ventana->RequestUserAttention();
	}
}

/*Evento de ventana de control de registros (Logs)*/
void VentanaPrincipal::OnControlLogs(wxCommandEvent& /*event*/)
{
	GNC::GUI::VentanaControlLogs* ventana = GNC::GUI::VentanaControlLogs::Instance();
	if(!ventana->IsActive()) {
		ventana->RequestUserAttention();
	}
}

/* Evento de aplicacion de herramienta*/
void VentanaPrincipal::OnAplicarHerramienta(wxCommandEvent& event){
	GNC::GCS::IControladorHerramientas* cH = GNC::Entorno::Instance()->GetControladorHerramientas();
	GNC::GCS::IHerramienta* herr = NULL;
	try {
		// Subscribimos la vista al contrato de herr
		herr= cH->ObtenerHerramienta(event.GetId());
		if(herr!=NULL){
			herr->SolicitarActivacion(GNC::GCS::TriggerButton().EnableLeft());
		}
	}
	catch (GNC::GCS::ControladorHerramientasException& ex) {
		std::cerr << "Error al obtener la herramienta puntero: No se pudo subscribir la herramienta: " << ex.GetCause() << std::endl;
	}
	event.Skip(false);
}

void VentanaPrincipal::OnUpdateUIHerramienta(wxUpdateUIEvent& event)
{
	GNC::GCS::IControladorHerramientas* cH = GNC::Entorno::Instance()->GetControladorHerramientas();
	GNC::GCS::IHerramienta* herr = NULL;
	try {
		// Subscribimos la vista al contrato de herr
		herr = cH->ObtenerHerramienta(event.GetId());
		if(herr!=NULL){
			event.Enable(herr->Habilitada());
			event.Show(herr->Habilitada());
		}
		else{
			event.Enable(false);
			event.Show(false);
		}
	}
	catch (GNC::GCS::ControladorHerramientasException& ex) {
		std::cerr << "Error al obtener la herramienta puntero: No se pudo subscribir la herramienta: " << ex << std::endl;
	}
	event.Skip(true);
}

/* Eventos de teclado */
void VentanaPrincipal::OnKeyDown(wxKeyEvent& event)
{
	GNC::GCS::IVista* pVista = GNC::GCS::ControladorVistas::Instance()->GetVistaActiva();
	if(pVista != NULL)
	{
		wxKeyEvent evt = event;
		wxWindow* win = pVista->GetWindow();
		if (win) {
			win->AddPendingEvent(evt);
		}
		event.Skip(false);
	}
	else {
		event.Skip(true);
	}
}

void VentanaPrincipal::OnMenuCerrarTabClick(wxCommandEvent& )
{
	GNC::GCS::IVista* pVista = GNC::GCS::ControladorVistas::Instance()->GetVistaActiva();
	if(pVista != NULL)
	{
		wxWindow* pVentana = pVista->GetWindow();
		if(pVentana != NULL) {
			if(m_pNoteBook->GetPageIndex(pVentana) >= 0 && m_pNoteBook->GetSelection()!=-1)
			{
				#if defined(USE_PATCHED_LIBS)
				AUI_NAMESPACE wxAuiNotebookEvent evt(wxEVT_COMMAND_AUINOTEBOOK_BUTTON, m_pNoteBook->GetSelection());
				evt.SetInt(wxAUI_BUTTON_CLOSE);
				evt.SetId(5380+500);
				evt.SetEventObject(m_pNoteBook->GetActiveTabCtrl());
				m_pNoteBook->GetEventHandler()->ProcessEvent(evt);
				#endif
			}
			else
			{
				//miramos a ver si esta metida en un panel grid
				GNC::GUI::PanelGrid* pPanel = dynamic_cast<GNC::GUI::PanelGrid*> (pVentana->GetParent());
				if(pPanel != NULL) {
					pPanel->Cerrar();
				}
			}
		}
	}
}

void VentanaPrincipal::OnMenuCerrarTodoExceptoActiva(wxCommandEvent& )
{
	/*NO ESTA CORRECTO
	 unsigned int pestanias = m_pNoteBook->GetPageCount();
	 //la segunda condicion es para que si das a cancelar pues pare
	 unsigned int tabActual = pestanias - 1;
	 while(m_pNoteBook->GetPageCount() > 1 && pestanias == m_pNoteBook->GetPageCount()){
	 if(m_pNoteBook->GetPage(tabActual) == m_pNoteBook->GetActiveTabCtrl()){

	 } else {
	 wxAuiNotebookEvent evt(wxEVT_COMMAND_AUINOTEBOOK_BUTTON, m_pNoteBook->GetPage(tabActual)->GetId());
	 evt.SetInt(wxAUI_BUTTON_CLOSE);
	 evt.SetEventObject(m_pNoteBook->GetPage(tabActual));
	 m_pNoteBook->GetEventHandler()->ProcessEvent(evt);
	 pestanias --;
	 }
	 }	*/

}

void VentanaPrincipal::OnMenuCerrarTodosTabsClick(wxCommandEvent& )
{
	CerrarTodosLosTabsYPanelGrids();
}

//devuelve bool si ha cerrado todos
bool VentanaPrincipal::CerrarTodosLosTabsYPanelGrids() {
	bool todosCerrados = false;
	#if defined(USE_PATCHED_LIBS)
	unsigned int pestanias = m_pNoteBook->GetPageCount();
	//la segunda condicion es para que si das a cancelar pues pare	
	while(m_pNoteBook->GetPageCount() > 0 && pestanias == m_pNoteBook->GetPageCount()){
		AUI_NAMESPACE wxAuiNotebookEvent evt(wxEVT_COMMAND_AUINOTEBOOK_BUTTON, m_pNoteBook->GetSelection());
		evt.SetInt(wxAUI_BUTTON_CLOSE);
		evt.SetId(5380+500);
		evt.SetEventObject(m_pNoteBook->GetActiveTabCtrl());
		m_pNoteBook->GetEventHandler()->ProcessEvent(evt);
		pestanias --;
	}
	#endif

	if(m_pNoteBook->GetPageCount() == 0) {
		//se cierran los paneles tabs...
		while(m_pGridPanel->GetSizer()->GetChildren().size() > 0){
			GNC::GUI::PanelGrid* pPanel = (GNC::GUI::PanelGrid*)m_pGridPanel->GetSizer()->GetItem((size_t)0)->GetWindow();
			if (pPanel != NULL) {
				if(!pPanel->Cerrar()){
					break;
				}
			}
			else {
				break;
			}
		}
		todosCerrados = true;
	}

	if (m_pNoteBook->GetPageCount() == 0 && m_pGridPanel->GetSizer()->GetChildren().size() == 0) { // Se han eliminado todas las paginas
		//se muestra el mosaico
		if(!m_pMosaicPanel->IsShown()){
			m_mgr.GetPane(m_pNoteBook).Hide();
			m_mgr.GetPane(m_pMosaicPanel).Show(true);
			m_mgr.Update();
		}
	}

	return todosCerrados;
}

bool VentanaPrincipal::ClosesAllUndocked()
{
	std::list<GNC::GUI::DialogoDesencajado*> listaDesencajados;
	GNC::GCS::ControladorVistas::TipoListaVistas viewsList = GNC::GCS::ControladorVistas::Instance()->GetVistas();
	for (GNC::GCS::ControladorVistas::TipoListaVistas::iterator it = viewsList.begin(); it != viewsList.end(); ++it) {
		GNC::GUI::DialogoDesencajado* pPanel = dynamic_cast<GNC::GUI::DialogoDesencajado*> ((*it)->GetWindow()->GetParent());
		if(pPanel!=NULL) {
			listaDesencajados.push_back(pPanel);
		}
	}

	for (std::list<GNC::GUI::DialogoDesencajado*>::iterator it = listaDesencajados.begin(); it != listaDesencajados.end(); ++it)
	{
		if (!(*it)->Close())
		{
			return false;
		}
	}
	return true;
}

void VentanaPrincipal::OnMenuPrimerPlanoPestaniaActiva(wxCommandEvent& )
{
	if(m_pNoteBook->GetPageCount() > 0) {
		PasarAPrimerPlano(m_pNoteBook->GetPage(m_pNoteBook->GetSelection()));
	}
}

void VentanaPrincipal::OnMenuCerrarTabUpdateUI(wxUpdateUIEvent& event)
{
	event.Enable(m_pNoteBook->GetPageCount() > 0 || m_pGridPanel->GetSizer()->GetChildren().size() > 0);
}

void VentanaPrincipal::OnMenuCerrarTodosTabsUpdateUI(wxUpdateUIEvent& event)
{
	event.Enable(m_pNoteBook->GetPageCount() > 0 || m_pGridPanel->GetSizer()->GetChildren().size() > 0);
}


/*Eventos de impresion*/
void VentanaPrincipal::OnMenuImprimir(wxCommandEvent& /*event*/)
{
	#if defined(USE_PATCHED_LIBS)
	GNC::GCS::IVista* pVista = GNC::GCS::ControladorVistas::Instance()->GetVistaActiva();
	if (pVista != NULL) {
		wxString titulo = wxString::FromUTF8(pVista->GetTitulo().c_str());
		GNC::GCS::Printing::DialogoImpresion* frame = new GNC::GCS::Printing::DialogoImpresion(this,pVista,titulo,m_pPrintData);
		frame->Centre(wxBOTH);
		frame->Show(true);
	}
	#endif
}

void VentanaPrincipal::OnMenuImprimirUpdateUI(wxUpdateUIEvent& event)
{
	GNC::GCS::IVista* pVista = GNC::GCS::ControladorVistas::Instance()->GetVistaActiva();
	if (pVista != NULL && pVista->SoportaExportar()) {
		event.Enable(true);
	}else{
		event.Enable(false);
	}
}


void VentanaPrincipal::OnPantallaCompleta(wxCommandEvent& )
{
	this->ShowFullScreen(!this->IsFullScreen(),wxFULLSCREEN_NOBORDER|wxFULLSCREEN_NOCAPTION);
}


void VentanaPrincipal::EncajarDesencajar(GNC::GCS::IVista* pVista) {
	if(pVista != NULL)
	{
		wxWindow* pVentana = pVista->GetWindow();
		if(pVentana != NULL) {
			GNC::GCS::ControladorVistas::Instance()->SolicitarActivarVista(NULL);
			//la buscamos en el notebook
			if(m_pNoteBook->GetPageIndex(pVentana) >= 0){
				GNC::GUI::DialogoDesencajado* pDlg;
				{
#if defined (_WINDOWS)
					wxWindowDisabler dis;
#endif

					SuperFreeze();
					wxString caption = m_pNoteBook->GetPageText(m_pNoteBook->GetPageIndex(pVentana));
					wxString titulo = m_pNoteBook->GetPageText(m_pNoteBook->GetPageIndex(pVentana));

					m_pNoteBook->RemovePage(m_pNoteBook->GetPageIndex(pVentana));

					if (m_pNoteBook->GetPageCount() == 0) {
						if(!m_pMosaicPanel->IsShown()){
							m_mgr.GetPane(m_pMosaicPanel).Show(true);
							m_mgr.GetPane(m_pNoteBook).Hide();
							m_pMosaicPanel->Refresh(false);
						}
					}

					pDlg = new GNC::GUI::DialogoDesencajado(this, this);
					pDlg->AddPanel(pVentana, titulo);

					m_mgr.Update();
					pDlg->Show(true);
					SuperThaw();

				}
			} else {
				//miramos a ver si esta metida en un panel grid
				GNC::GUI::PanelGrid* pPanel = dynamic_cast<GNC::GUI::PanelGrid*> (pVentana->GetParent());
				if(pPanel!=NULL) {
					GNC::GUI::DialogoDesencajado* pDlg;
					{
#if defined (_WINDOWS)
						wxWindowDisabler dis;
#endif
						SuperFreeze();
						m_pGridPanel->GetSizer()->Detach(pPanel);
						pDlg = new GNC::GUI::DialogoDesencajado(this, this);
						pDlg->AddPanel(pVentana, pPanel->GetTitulo());
						pPanel->Destroy();
						m_pGridPanel->FitInside();
						m_pGridPanel->Layout();
						pDlg->Show(true);
						m_mgr.Update();
						SuperThaw();
					}
				} else { //esta desencajada => la encajamos
					GNC::GUI::DialogoDesencajado* pDlg = dynamic_cast<GNC::GUI::DialogoDesencajado*>(pVentana->GetParent());
					if(pDlg != NULL)
					{
#if defined (_WINDOWS)
						wxWindowDisabler dis;
#endif
						pDlg->Show(false);
						pDlg->GetSizer()->Detach(pVentana);
						SuperFreeze();
						//encajar!
						if(m_pGridPanel->IsShown()) { //encajar en el grid
							GNC::GUI::PanelGrid* pNew = new GNC::GUI::PanelGrid(m_pGridPanel, this);
							pNew->AddPanel(pVentana, pDlg->GetTitulo());
							pDlg->Destroy();
							pNew->Show(true);
							m_pGridPanel->GetSizer()->Add(pNew,1, wxALL|wxEXPAND, 0 );
							m_pGridPanel->FitInside();
							m_pGridPanel->Layout();
						} else { //encajar en el notebook
							if(!m_pNoteBook->IsShown()){
								m_mgr.GetPane(m_pMosaicPanel).Hide();
								m_mgr.GetPane(m_pNoteBook).Show(true);
								m_pNoteBook->Refresh(false);
							}
							pVentana->Reparent(m_pNoteBook);
							m_pNoteBook->AddPage(pVentana, pDlg->GetTitulo());
							pDlg->Destroy();
							m_pNoteBook->Refresh();
							m_mgr.GetPane(m_pNoteBook).Show(true);
							m_mgr.GetPane(m_pGridPanel).Hide();
						}
						m_mgr.Update();
						SuperThaw();
					}
				}
			}
			GNC::GCS::ControladorVistas::Instance()->SolicitarActivarVista(pVista);
		}
	}
}


void VentanaPrincipal::OnMosaicoHorizontal(wxCommandEvent& )
{
#if defined (_WINDOWS)
	wxWindowDisabler dis;
#endif
	SuperFreeze();
	ReplegarPestanias();
	#if defined(USE_PATCHED_LIBS)
	if(m_pNoteBook->GetPageCount() > 1 ){
		int posicionCorte = m_pNoteBook->GetSize().y/m_pNoteBook->GetPageCount();		
		for( unsigned int idx = 0; idx < m_pNoteBook->GetPageCount(); idx++){
			m_pNoteBook->CustomSplit(idx,wxTOP,posicionCorte);
		}
	}
	#endif
	m_mgr.Update();
	SuperThaw();
}

void VentanaPrincipal::OnMosaicoVertical(wxCommandEvent& )
{
	#if defined (_WINDOWS)
	wxWindowDisabler dis;
	#endif
	SuperFreeze();
	ReplegarPestanias();
	#if defined(USE_PATCHED_LIBS)
	if(m_pNoteBook->GetPageCount() > 1 ){
		//la posicion de corte sera el tamanio x del notebook entre el numero de tabs
		int posicionCorte = m_pNoteBook->GetSize().x/m_pNoteBook->GetPageCount();
		for( unsigned int idx = 0; idx < m_pNoteBook->GetPageCount(); idx++){
			m_pNoteBook->CustomSplit(idx,wxLEFT,posicionCorte);
		}
	}
	#endif
	m_mgr.Update();
	SuperThaw();
}

void VentanaPrincipal::OnMosaicoRestaurar(wxCommandEvent& )
{
	wxWindowDisabler disabler;
	SuperFreeze();
	ReplegarPestanias();
	m_mgr.Update();
	SuperThaw();
}

void VentanaPrincipal::OnMosaicoGrid2Col(wxCommandEvent& )
{
	wxWindowDisabler disabler;
	SuperFreeze();
	AddToGrid(2);
	m_mgr.Update();
	SuperThaw();
}

void VentanaPrincipal::OnMosaicoGrid3Col(wxCommandEvent& )
{
	wxWindowDisabler dis;
	SuperFreeze();
	AddToGrid(3);
	m_mgr.Update();
	SuperThaw();
}

void VentanaPrincipal::ReplegarPestanias()
{
	//se oculta el grid panel
	if(m_pGridPanel->IsShown()) {
		while(m_pGridPanel->GetSizer()->GetChildren().size()>0){
			GNC::GUI::PanelGrid* pPanel = (GNC::GUI::PanelGrid*)m_pGridPanel->GetSizer()->GetItem((size_t)0)->GetWindow();
			m_pGridPanel->GetSizer()->Detach(pPanel);
			wxWindow* pWin = pPanel->GetWindow();
			pWin->Reparent(m_pNoteBook);
			m_pNoteBook->AddPage(pWin, pPanel->GetTitulo());
			pPanel->Destroy();
		}
		//m_pNoteBook->Refresh(false);
		m_mgr.GetPane(m_pNoteBook).Show(true);
		m_mgr.GetPane(m_pGridPanel).Hide();
	}
	//remember the tab now selected
	int nowSelected = m_pNoteBook->GetSelection();
	//select first tab as destination
	m_pNoteBook->SetSelection(0);
	//iterate all other tabs
	for( unsigned int idx = 0; idx < m_pNoteBook->GetPageCount(); idx++){
		//get win reference
		wxWindow* win = m_pNoteBook->GetPage(idx);
		//get tab title
		wxString title = m_pNoteBook->GetPageText(idx);
		//remove from notebook
		m_pNoteBook->RemovePage(idx);
		//re-add in the same position so it will tab
		m_pNoteBook->InsertPage(idx, win, title);
	}
	//restore orignial selected tab
	m_pNoteBook->SetSelection(nowSelected);
}

void VentanaPrincipal::AddToGrid(int numColumnas)
{
	((wxGridSizer*)(m_pGridPanel->GetSizer()))->SetCols(numColumnas);
	if(!m_pGridPanel->IsShown() && m_pNoteBook->GetPageCount() > 0){
		while(m_pNoteBook->GetPageCount()>0){
			wxWindow* win = m_pNoteBook->GetPage(0);
			wxString titulo = m_pNoteBook->GetPageText(0);
			m_pNoteBook->RemovePage(0);
			GNC::GUI::PanelGrid* pNew = new GNC::GUI::PanelGrid(m_pGridPanel,this);
			pNew->AddPanel(win, titulo);
			m_pGridPanel->GetSizer()->Add(pNew,1, wxALL|wxEXPAND, 0 );
		}
		m_mgr.GetPane(m_pNoteBook).Hide();
		m_mgr.GetPane(m_pGridPanel).Show(true);
	}
	m_pGridPanel->FitInside();
	m_pGridPanel->Layout();
}


/* Añade una nueva pestaña al panel de estudios */
void VentanaPrincipal::InsertarVentana(wxWindow* pVentana)
{
	wxWindowDisabler disabler;
	SuperFreeze();
	if(m_pMosaicPanel->IsShown()){
		m_mgr.GetPane(m_pMosaicPanel).Hide();
	}

	if(m_pGridPanel->IsShown()) {
		GNC::GUI::PanelGrid* pPanelGrid = new GNC::GUI::PanelGrid(m_pGridPanel, this);
		pPanelGrid->AddPanel(pVentana, wxEmptyString);
		m_pGridPanel->GetSizer()->Add(pPanelGrid,1, wxALL|wxEXPAND, 2 );
		m_pGridPanel->FitInside();
		m_pGridPanel->Layout();
	} else {
		m_pNoteBook->AddPage(pVentana, wxEmptyString, false);
	}
	m_mgr.Update();
	SuperThaw();
}

/* Elimina un tab del panel de estudios */
void VentanaPrincipal::EliminarVentana(wxWindow *WXUNUSED(pVentana))
{
	std::cerr << "Error: Metodo no implementado VentanaPrincipal::EstudioRemoveTab(Tab* t)" << std::endl;
	throw new std::exception();
}

void VentanaPrincipal::OnInicioAplicacion(wxCommandEvent &) 
{	
	//parameters parsing...
	bool aceptedLicense = false;
	bool versionParameter = false;
	wxString pathOfFile = wxEmptyString;

	int argc = GNC::Entorno::Instance()->GetApp()->argc;
	wxChar** argv = GNC::Entorno::Instance()->GetApp()->argv;
	if (argc > 1) {
		for (int i = 1; i < argc; i++) {
			wxString param(argv[i]);

			if ( param.CmpNoCase(wxT("-version")) == 0 || param.CmpNoCase(wxT("--version")) == 0 || param.CmpNoCase(wxT("-v")) == 0 ) {
				versionParameter = true;
				continue;
			}
			if (param.CmpNoCase(wxT("--accepted")) == 0 || param.CmpNoCase(wxT("-a")) == 0) {
				aceptedLicense = true;
				continue;
			}
			pathOfFile = param;
		}
	}

	if (versionParameter) {
		int version = 0;
		int subversion = 0;
		int release = 0;
		int build = 0;
		std::string codename;

		GNC::Entorno::Instance()->GetGinkgoVersionAsTuple(&version, &subversion, &release, &build, &codename);
		GNC::Entorno::FreeInstance();
		std::cout << version << "." << subversion << "." << release << "." << build << " " << codename.c_str() << std::endl;
		Close();
	}

	if (!aceptedLicense) 
	{
		//aceptacion de la licencia
		bool aceptada;
		GNC::GCS::ConfigurationController::Instance()->readBoolGeneral("/GinkgoCore/Licencia", "Aceptada", aceptada, false);
		if(!aceptada) {
			GNC::GUI::AcceptLicenseDialog dlgLicencia(NULL);
			wxYield();
			int answer = dlgLicencia.ShowModal();
			if(answer == wxID_OK) {
				GNC::GCS::ConfigurationController::Instance()->writeBoolGeneral("/GinkgoCore/Licencia", "Aceptada", true);
				GNC::GCS::ConfigurationController::Instance()->Flush();
			} else {
				GNC::GCS::ConfigurationController::Instance()->writeBoolGeneral("/GinkgoCore/Licencia", "Aceptada", false);
				GNC::GCS::ConfigurationController::Instance()->Flush();
				Close();
				return;
			}
		}
	}

	//start page...
	bool defaultValue = GNC::GCS::ControladorPermisos::Instance()->Get("core.startup","startupdefaultvalue");
	bool showOnStartup;
	GNC::GCS::ConfigurationController::Instance()->readBoolUser("/GinkgoCore/News", "ShowOnStartUp", showOnStartup, defaultValue);
	if (showOnStartup) {
		ShowStartupPage();
	}

	//si viene un parametro y es un directorio... abrir directamente
	if(!pathOfFile.empty())
	{
		Login();
		EjecutarParametro(pathOfFile, true);
	} else {
		Login();
	}
}

void VentanaPrincipal::EjecutarParametro(const wxString cadena, bool doLogin)
{
	std::string xmlString("");
	
	wxFileName path = cadena;
	bool error = false;
	
	if (path.IsOk()) {
		LOG_DEBUG("Core", "Interpretando " << std::string(TOPATH(path.GetFullPath())).c_str());
		if (path.IsRelative()) {
			LOG_DEBUG("Core", "Convirtiendo ruta en absoluta");
			#if defined(__WXGTK__)
			
			char* invocation_dir = getenv("INVOCATION_DIR");					
			if (invocation_dir != NULL) {
				wxString invocationDir = wxString::FromUTF8(invocation_dir);
				if (!invocationDir.IsEmpty()) {
					path = invocationDir + wxFileName::GetPathSeparator() + path.GetFullPath();
				}
			}
			#else
			path.MakeAbsolute();
			#endif
			LOG_DEBUG("Core", "Ruta absoluta: " << std::string(TOPATH(path.GetFullPath())).c_str());
		}

		if(wxDirExists(path.GetFullPath()) && path.IsDirReadable()){
			if(doLogin) {
				Login();
			}
			std::list<std::string> rutas;
			rutas.push_back(std::string(TOPATH( path.GetFullPath() )));
			GNC::GCS::Eventos::EventoAddFicheroHistorial* pEvt = new GNC::GCS::Eventos::EventoAddFicheroHistorial(rutas,true);
			GNC::GCS::ControladorEventos::Instance()->ProcesarEvento(pEvt);
			return ;
		} else if(path.FileExists() && path.IsFileReadable()){

			//estamos ante un fichero
			//se mira a ver si a partir del byte 128 pone DICM
			wxFile fichero(path.GetFullPath(), wxFile::read);

			bool esGzip = false;
			bool esDicom = false;
			if(fichero.IsOpened()){
				char buffer[128];
				if(fichero.Read(buffer,128) == 128){
					esGzip = ((unsigned char)buffer[0]==0x1f) && ((unsigned char)buffer[1]==0x8b);
					char numeroMagico[4];
					if(fichero.Read(numeroMagico,4) == 4){
						std::string str(numeroMagico,4);
						if(str == "DICM") {
							esDicom = true;
						}
					}
				}
			}
			if(esDicom) {
				if (doLogin) {
					Login();
				}
				//si no es un xml pues sera un dicom...
				std::list<std::string> rutas;
				rutas.push_back(std::string(TOPATH(path.GetFullPath()) ));
				bool esDicomDir = false;
				if (GIL::DICOM::PACSController::Instance()->EsDICOM(rutas.front(),true,false)) {
					esDicomDir = true;
				}
				if (esDicomDir) {
					GNC::GUI::Abrir::AbrirFichero(this, &rutas);
				}
				else {
					GNC::GCS::Eventos::EventoAddFicheroHistorial* pEvt = new GNC::GCS::Eventos::EventoAddFicheroHistorial(rutas,true);
					GNC::GCS::ControladorEventos::Instance()->ProcesarEvento(pEvt);
				}				
			} else {				
				//se lee el modelo
				bool loaded = false;
				wxXmlDocument documento;
				if (esGzip) {
					wxFileInputStream* fileIn = new wxFileInputStream(path.GetFullPath());
					wxZlibInputStream zInput(fileIn);
					loaded = documento.Load(zInput);
				} else {
					loaded = documento.Load(path.GetFullPath());
				}
				if(loaded) {
					wxStringOutputStream out;
					documento.Save(out);
					xmlString=out.GetString().ToUTF8();
				} else {
					//dcmurl file...
					LOG_DEBUG("GIL/WF", "Try reading dcmurl file...");
					wxTextFile dcmURLFile;
					if (!dcmURLFile.Open(path.GetFullPath(), wxMBConvUTF8())) {
						for (wxString line = dcmURLFile.GetFirstLine(); !dcmURLFile.Eof(); line = dcmURLFile.GetNextLine()) {
							wxFileName fileName(line);
							if (fileName.IsRelative()) {
								fileName.MakeAbsolute(path.GetPath());
							}
							if (wxFileExists(fileName.GetFullPath())) {
								EjecutarParametro(fileName.GetFullPath());
							} else {
								LOG_ERROR("GIL/WF", "File doesn't exists");
								break;
							}
						}
					}
					LOG_ERROR("GIL/WF", "Error al interpretar el fichero de entrada: XML mal formado");
					wxMessageBox(_("Malformed XML"),_("Error"),wxICON_INFORMATION);
					if (doLogin) {
						Login();
					}
				}
			}
		}
		else {
			error = true;
		}
	}
	else {
		error = true;
	}
	if (error) {
		LOG_ERROR("GIL/WF", "Error al interpretar los parámetros de la línea de comandos. No existe el fichero o directorio (" << path.GetFullPath().ToUTF8() << ")" );
			wxMessageBox(
				_("Error in interpreting the parameters of the command line. The file or directory doesn't exist (")
				+ path.GetFullPath()
				+ wxString::FromUTF8(")")
				,_("Error"), wxICON_INFORMATION);
			if (doLogin) {
				Login();
			}
			return;
	}


	if(xmlString != "") {
		try {
			GIL::IntegrationModelList listaModelos;	
			GIL::IntegrationController::Instance()->ParsearModeloIntegracion(listaModelos,xmlString, path.GetPath());
			GIL::IntegrationController::Instance()->Process(listaModelos);
		}
		catch (GIL::IntegrationException& ex) {
			LOG_ERROR("GIL/WF", "Semantic/Sintactic error parsing integration XML: " << ex.GetFullCause());
			wxMessageBox(_("Semantic/Sintactic error parsing integration XML (see log for details):\n") + wxString::FromUTF8(ex.GetCause().c_str()),_("Error"),wxICON_INFORMATION);
		}
		catch (GIL::HL7::HL7XMLException& ex) {
			LOG_ERROR("GIL/WF", "Semantic/Sintactic error parsing integration XML: " << ex.GetFullCause());
			wxMessageBox(_("Semantic/Sintactic error parsing integration XML (see log for details):\n") + wxString::FromUTF8(ex.GetCause().c_str()),_("Error"),wxICON_INFORMATION);
		}
		catch (GIL::HL7::HL7Exception& ex1) {
			LOG_ERROR("GIL/WF", "Error parsing integration XML: " << ex1.GetCause());
			wxMessageBox(_("Error parsing integration XML:\n") + wxString::FromUTF8(ex1.GetCause().c_str()),_("Error"),wxICON_INFORMATION);
		}
		catch (GIL::DICOM::PACSException& ex3) {
			LOG_ERROR("GIL/WF", "PACS error: " << ex3.GetCause());
			wxMessageBox(_("PACS error:\n") + wxString::FromUTF8(ex3.GetCause().c_str()),_("Error"),wxICON_INFORMATION);
		}
		catch (std::exception& ex4) {
			LOG_ERROR("GIL/WF", "Error executing WorkFlow: " << ex4.what());
			wxMessageBox(_("Error executing WorkFlow\n") + wxString::FromUTF8(ex4.what()),_("Error"),wxICON_INFORMATION);
		}
		catch (...) {
			LOG_ERROR("GIL/WF", "Error executing WorkFlow: Internal error.");
			wxMessageBox(_("Error executing WorkFlow\nInternal Error"), _("Error"),wxICON_INFORMATION);
		}

		if (!m_Iniciada) {
			if (doLogin) {
				Login();
			}
		}
	}
	else {
		if (doLogin) {
			Login();
		}
	}
}

void VentanaPrincipal::OnSize(wxSizeEvent& WXUNUSED(event))
{
	Layout();
}


void VentanaPrincipal::RefrescarMenus()
{

	//se vacía la barra y se borran los menus que se crearon en la anterior pasada
    wxWindowDisabler dis;
    SuperFreeze();
	while (m_pMenuBar->GetMenuCount() > 0)
		delete m_pMenuBar->Remove(0);
	while (m_pBarraComun->GetToolCount() > 0) {
		m_pBarraComun->DeleteByIndex(0);
	}
	{
		if(GNC::GCS::ControladorPermisos::Instance()->Get("core.restrictions","acquire")) {
			m_pBarraComun->AddTool(ID_ABRIR_FICHERO,_("Open File"),GinkgoResourcesManager::IconosMenus::GetIcoOpenFile(),_("Open File"));
			m_pBarraComun->SetToolDropDown(ID_ABRIR_FICHERO, true);
			if(GNC::GCS::ControladorPermisos::Instance()->Get("core.pacs.limits","pacs_acquisition")) {
				m_pBarraComun->AddTool(ID_PACS_ACQUIRE,_("Acquire a DICOM study from PACS"),GinkgoResourcesManager::IconosMenus::GetIcoAbrir(), _("Acquire a DICOM study from PACS"));
				//dropdown??
				wxMenu dummy;
				if (InsertToolsFromFamily(&dummy, GNC::GCS::IHerramienta::TMenuPACSAcquisition) > 0) {
					m_pBarraComun->SetToolDropDown(ID_PACS_ACQUIRE, true);
				}
			}		
		}
		if(GNC::GCS::ControladorPermisos::Instance()->Get("core.restrictions","import")) {
			m_pBarraComun->AddTool(ID_IMPORTAR,_("Import Images"),GinkgoResourcesManager::IconosMenus::GetIcoImportar(),_("Import Images"));
		}
		m_pBarraComun->AddTool(ID_GUARDAR,_("Save"),GinkgoResourcesManager::IconosMenus::GetIcoGuardar(),_("Save"));
		m_pBarraComun->Realize();
	}

	wxMenu* pMenuArchivo = new wxMenu();
	wxMenu* pMenuEdicion = new wxMenu();
	wxMenu* pMenuVer = new wxMenu();
	wxMenu* pMenuImagen = new wxMenu();
	wxMenu* pMenu3D = new wxMenu();
	wxMenu* pMenuHerramientas = new wxMenu();
	wxMenu* pMenuAyuda = new wxMenu();
	wxMenu* m_pExportMenu = new wxMenu( );

	{
		//menu archivo
		wxMenuItem* m_pMenuAdquirir = new wxMenuItem( pMenuArchivo, ID_PACS_ACQUIRE, wxString( _("DICOM &acquisition from PACS") ) + wxT("\tAlt+a"), _("Acquire a DICOM study from PACS"), wxITEM_NORMAL );
		wxMenuItem* pMenuAbrirFichero = new wxMenuItem( pMenuArchivo, ID_ABRIR_FICHERO, wxString( _("Open file")) + wxT("\tAlt+f"), _("Open a DICOM file"), wxITEM_NORMAL );
		wxMenuItem* pMenuAbrirDirectorio = new wxMenuItem( pMenuArchivo, ID_ABRIR_DIRECTORIO, wxString( _("Open folder")) + wxT("\tAlt+d"), _("Acquire from a local folder"), wxITEM_NORMAL );
		wxMenuItem* pMenuRemovableUnit = new wxMenuItem( pMenuArchivo, ID_OPEN_REMOVABLE, wxString( _("Open removable unit")), _("Acquire from a removable unit"), wxITEM_NORMAL );
		wxMenuItem* m_pMenuImportar = new wxMenuItem( pMenuArchivo, ID_IMPORTAR, wxString( _("&Import images...") ) + wxT("\tAlt+i"), _("Import images"), wxITEM_NORMAL );
		wxMenuItem* m_pCerrar = new wxMenuItem( pMenuArchivo, ID_CERRAR, wxString( _("Close") ) + wxT("\tAlt+w"), _("Close current view"), wxITEM_NORMAL );
		wxMenuItem* m_pCerrarTodas = new wxMenuItem( pMenuArchivo, ID_CERRAR_TODAS, wxString( _("Close all") ) , _("Close all views"), wxITEM_NORMAL );
		wxMenuItem* m_pMenuGuardar = new wxMenuItem( pMenuArchivo, ID_GUARDAR, wxString(_("&Save")) + wxT("\tAlt+g"), _("Save the active study."), wxITEM_NORMAL );
		wxMenuItem* m_pExportAsImage = new wxMenuItem( m_pExportMenu, ID_EXPORTAR, wxString( _("Export current series...") ) + wxT("\tAlt+e"), _("Export the active study to other formats"), wxITEM_NORMAL );
		wxMenuItem* m_pDicomDirExport = new wxMenuItem( m_pExportMenu, ID_DICOMDIR_EXPORT, _("Export to DICOM Dir"), _("Export to DICOM Dir"), wxITEM_NORMAL );
		wxMenuItem* m_pMenuSubirPacs = new wxMenuItem( pMenuArchivo, ID_SUBIR_PACS, wxString( _("Send to PACS...") ) , wxEmptyString, wxITEM_NORMAL );
		wxMenuItem* m_pMenuImprimir = new wxMenuItem( pMenuArchivo, ID_IMPRIMIR, wxString( _("Print...") ) + wxT("\tAlt+p"), wxEmptyString, wxITEM_NORMAL );
		wxMenuItem* m_pMenuSalir = new wxMenuItem( pMenuArchivo, ID_SALIR, wxString( _("&Exit") ) + wxT("\tAlt+s"), _("Exit application"), wxITEM_NORMAL );
#ifdef __WXMSW__
		m_pMenuGuardar->SetBitmaps( GinkgoResourcesManager::IconosMenus::GetIcoGuardar());
		m_pMenuAdquirir->SetBitmaps(GinkgoResourcesManager::IconosMenus::GetIcoAbrir());
		pMenuAbrirFichero->SetBitmaps(GinkgoResourcesManager::IconosMenus::GetIcoOpenFile());
		pMenuRemovableUnit->SetBitmaps(GinkgoResourcesManager::IconosMenus::GetIcoRemovableUnit());
		pMenuAbrirDirectorio->SetBitmaps(GinkgoResourcesManager::IconosMenus::GetIcoOpenDir());
		m_pMenuImportar->SetBitmaps(GinkgoResourcesManager::IconosMenus::GetIcoImportar());
		m_pCerrar->SetBitmaps(GinkgoResourcesManager::IconosMenus::GetIcoCerrarTab());
		m_pMenuSalir->SetBitmaps(GinkgoResourcesManager::IconosMenus::GetIcoSalir());
		m_pExportAsImage->SetBitmaps(GinkgoResourcesManager::IconosMenus::GetIcoExportar());
		m_pDicomDirExport->SetBitmaps(GinkgoResourcesManager::IconosMenus::GetIcoDicomDir());
		m_pMenuImprimir->SetBitmaps(GinkgoResourcesManager::IconosMenus::GetIcoImpresora());
		m_pMenuSubirPacs->SetBitmaps(GinkgoResourcesManager::IconosMenus::GetIcoSendToPACS());
#else
		m_pMenuGuardar->SetBitmap(GinkgoResourcesManager::IconosMenus::GetIcoGuardar());
		m_pMenuAdquirir->SetBitmap(GinkgoResourcesManager::IconosMenus::GetIcoAbrir());
		pMenuAbrirFichero->SetBitmap(GinkgoResourcesManager::IconosMenus::GetIcoOpenFile());
		pMenuRemovableUnit->SetBitmap(GinkgoResourcesManager::IconosMenus::GetIcoRemovableUnit());
		pMenuAbrirDirectorio->SetBitmap(GinkgoResourcesManager::IconosMenus::GetIcoOpenDir());
		m_pMenuImportar->SetBitmap(GinkgoResourcesManager::IconosMenus::GetIcoImportar());
		m_pCerrar->SetBitmap(GinkgoResourcesManager::IconosMenus::GetIcoCerrarTab());
		m_pMenuSalir->SetBitmap(GinkgoResourcesManager::IconosMenus::GetIcoSalir());
		m_pExportAsImage->SetBitmap(GinkgoResourcesManager::IconosMenus::GetIcoExportar());
		m_pDicomDirExport->SetBitmap(GinkgoResourcesManager::IconosMenus::GetIcoDicomDir());
		m_pMenuImprimir->SetBitmap(GinkgoResourcesManager::IconosMenus::GetIcoImpresora());
		m_pMenuSubirPacs->SetBitmap(GinkgoResourcesManager::IconosMenus::GetIcoSendToPACS());
#endif
		if(GNC::GCS::ControladorPermisos::Instance()->Get("core.restrictions","acquire")) {
			pMenuArchivo->Append( pMenuAbrirFichero );
			this->Connect( pMenuAbrirFichero->GetId(), wxEVT_COMMAND_MENU_SELECTED, wxCommandEventHandler( VentanaPrincipal::OnAbrirFichero ) );
			pMenuArchivo->Append( pMenuAbrirDirectorio );
			this->Connect( pMenuAbrirDirectorio->GetId(), wxEVT_COMMAND_MENU_SELECTED, wxCommandEventHandler( VentanaPrincipal::OnAbrirDirectorio ) );
			#ifdef _WIN32
			pMenuArchivo->Append(pMenuRemovableUnit);
			this->Connect(pMenuRemovableUnit->GetId(), wxEVT_COMMAND_MENU_SELECTED, wxCommandEventHandler ( VentanaPrincipal::OnOpenRemovableUnit ) );
			#endif
			pMenuArchivo->AppendSeparator();
			if(GNC::GCS::ControladorPermisos::Instance()->Get("core.pacs.limits","pacs_acquisition")) {
				pMenuArchivo->Append( m_pMenuAdquirir );
				pMenuArchivo->AppendSeparator();
				this->Connect( m_pMenuAdquirir->GetId(), wxEVT_COMMAND_MENU_SELECTED, wxCommandEventHandler( VentanaPrincipal::OnPACSAcquisition ) );
				InsertToolsFromFamily(pMenuArchivo, GNC::GCS::IHerramienta::TMenuPACSAcquisition);
			} else {
				delete m_pMenuAdquirir;
			}
		} else {
			delete pMenuAbrirFichero;
			delete pMenuAbrirDirectorio;
#ifdef _WIN32
			delete pMenuRemovableUnit;
#endif
			delete m_pMenuAdquirir;
		}
		if(GNC::GCS::ControladorPermisos::Instance()->Get("core.restrictions","import")) {	
			pMenuArchivo->Append( m_pMenuImportar );
			pMenuArchivo->AppendSeparator();
			this->Connect( m_pMenuImportar->GetId(), wxEVT_COMMAND_MENU_SELECTED, wxCommandEventHandler( VentanaPrincipal::OnImportar ) );
		} else {
			delete m_pMenuImportar;
		}
		pMenuArchivo->Append( m_pCerrar );
		pMenuArchivo->Append( m_pCerrarTodas );
		pMenuArchivo->AppendSeparator();
		pMenuArchivo->Append( m_pMenuGuardar );
		pMenuArchivo->AppendSeparator();
		if(GNC::GCS::ControladorPermisos::Instance()->Get("core.pacs.limits","pacs_upload")) {
			pMenuArchivo->Append(m_pMenuSubirPacs);
		} else { 
			delete m_pMenuSubirPacs;
		}
		
		if(GNC::GCS::ControladorPermisos::Instance()->Get("core.restrictions","export")) {
			pMenuArchivo->AppendSubMenu( m_pExportMenu, _("Export ...")  );
			m_pExportMenu->Append(m_pExportAsImage);
			m_pExportMenu->Append( m_pDicomDirExport );
			InsertToolsFromFamily(m_pExportMenu, GNC::GCS::IHerramienta::TMenuExport);
			pMenuArchivo->AppendSeparator();
		} else {
			delete m_pExportMenu;
			m_pExportMenu = NULL;
		}
		
		InsertToolsFromFamily(pMenuArchivo, GNC::GCS::IHerramienta::TMenuArchivo);
		pMenuArchivo->Append( m_pMenuImprimir );
		pMenuArchivo->AppendSeparator();
		pMenuArchivo->Append( m_pMenuSalir );
		this->Connect( m_pCerrar->GetId(), wxEVT_COMMAND_MENU_SELECTED, wxCommandEventHandler( VentanaPrincipal::OnMenuCerrarTabClick ) );
		this->Connect( m_pCerrar->GetId(), wxEVT_UPDATE_UI, wxUpdateUIEventHandler( VentanaPrincipal::OnMenuCerrarTabUpdateUI ) );
		this->Connect( m_pCerrarTodas->GetId(), wxEVT_COMMAND_MENU_SELECTED, wxCommandEventHandler( VentanaPrincipal::OnMenuCerrarTodosTabsClick ) );
		this->Connect( m_pCerrarTodas->GetId(), wxEVT_UPDATE_UI, wxUpdateUIEventHandler( VentanaPrincipal::OnMenuCerrarTodosTabsUpdateUI ) );
		this->Connect( m_pMenuGuardar->GetId(), wxEVT_COMMAND_MENU_SELECTED, wxCommandEventHandler( VentanaPrincipal::OnGuardar ) );
		this->Connect( m_pMenuGuardar->GetId(), wxEVT_UPDATE_UI, wxUpdateUIEventHandler( VentanaPrincipal::OnUpdateGuardar ) );
		this->Connect( m_pMenuSubirPacs->GetId(), wxEVT_COMMAND_MENU_SELECTED, wxCommandEventHandler( VentanaPrincipal::OnSubirPACS ) );
		this->Connect( m_pMenuSubirPacs->GetId(), wxEVT_UPDATE_UI, wxUpdateUIEventHandler( VentanaPrincipal::OnUpdateSubirPACS ) );
		this->Connect( m_pExportAsImage->GetId(), wxEVT_COMMAND_MENU_SELECTED, wxCommandEventHandler( VentanaPrincipal::OnExportar ) );
		this->Connect( m_pExportAsImage->GetId(), wxEVT_UPDATE_UI, wxUpdateUIEventHandler( VentanaPrincipal::OnUpdateExportar ) );
		this->Connect( m_pDicomDirExport->GetId(), wxEVT_COMMAND_MENU_SELECTED, wxCommandEventHandler( VentanaPrincipal::OnDicomDirExport ) );

		this->Connect( m_pMenuImprimir->GetId(), wxEVT_COMMAND_MENU_SELECTED, wxCommandEventHandler( VentanaPrincipal::OnMenuImprimir ) );
		this->Connect( m_pMenuImprimir->GetId(), wxEVT_UPDATE_UI, wxUpdateUIEventHandler( VentanaPrincipal::OnMenuImprimirUpdateUI ) );
		
		this->Connect( m_pMenuSalir->GetId(), wxEVT_COMMAND_MENU_SELECTED, wxCommandEventHandler( VentanaPrincipal::OnSalir ) );

		//edit
		InsertToolsFromFamily(pMenuEdicion, GNC::GCS::IHerramienta::TMenuEdicion);

		//view
		{
			wxMenuItem*  pPantallaCompleta = new wxMenuItem( pMenuVer, ID_PANTALLA_COMPLETA, wxString(_("Full screen"))+ wxT("\tF11"), _("Show full screen"), wxITEM_NORMAL );
			wxMenu* subMenuPestanias = new wxMenu();
			wxMenuItem* pMosaicoRestaurar = new wxMenuItem(subMenuPestanias, ID_MOSAICO_RESTAURAR, wxString( _("Tab grouping") ), _("Tab grouping"), wxITEM_NORMAL );
			wxMenuItem*  pMosaicoHorizontal = new wxMenuItem( subMenuPestanias, ID_MOSAICO_HORIZONTAL, _("Horizontal mosaic"), _("Horizontal mosaic"), wxITEM_NORMAL );
			wxMenuItem*  pMosaicoVertical = new wxMenuItem( subMenuPestanias, ID_MOSAICO_VERTICAL, _("Vertical mosaic"), _("Vertical mosaic"), wxITEM_NORMAL );

			wxMenu* subMenuGrid = new wxMenu();
			wxMenuItem*  pGrid2Col = new wxMenuItem( subMenuGrid, ID_GRID_2_COLUMNAS, _("Grid (two columns)"), _("Grid (two columns)"), wxITEM_NORMAL );
			wxMenuItem*  pGrid3Col = new wxMenuItem( subMenuGrid, ID_GRID_3_COLUMNAS, _("Grid (three columns)"), _("Grid (three columns)"), wxITEM_NORMAL );

			#ifdef __WXMSW__
			pMosaicoRestaurar->SetBitmaps(GinkgoResourcesManager::MenusTabs::GetIcoReagrupar());
			pGrid2Col->SetBitmaps(GinkgoResourcesManager::MenusTabs::GetIcoGrid2Col());
			pGrid3Col->SetBitmaps(GinkgoResourcesManager::MenusTabs::GetIcoGrid3Col());
			#else
			pMosaicoRestaurar->SetBitmap(GinkgoResourcesManager::MenusTabs::GetIcoReagrupar());
			pGrid2Col->SetBitmap(GinkgoResourcesManager::MenusTabs::GetIcoGrid2Col());
			pGrid3Col->SetBitmap(GinkgoResourcesManager::MenusTabs::GetIcoGrid3Col());
			#endif

			subMenuPestanias->Append(pMosaicoRestaurar);
			subMenuPestanias->AppendSeparator();
			subMenuPestanias->Append(pMosaicoHorizontal);
			subMenuPestanias->Append(pMosaicoVertical);

			subMenuGrid->Append(pGrid2Col);
			subMenuGrid->Append(pGrid3Col);

			#ifdef __WXMSW__
			pPantallaCompleta->SetBitmaps(GinkgoResourcesManager::IconosMenus::GetIcoPantallaCompleta());
			#else
			pPantallaCompleta->SetBitmap(GinkgoResourcesManager::IconosMenus::GetIcoPantallaCompleta());
			#endif
			pMenuVer->Append( pPantallaCompleta );
			pMenuVer->AppendSeparator();

			pMenuVer->AppendSubMenu(subMenuPestanias,_("Tabbed organization"));
			pMenuVer->AppendSubMenu(subMenuGrid,_("Grid organization"));
			InsertToolsFromFamily(pMenuVer, GNC::GCS::IHerramienta::TMenuVer);

			this->Connect( pPantallaCompleta->GetId(), wxEVT_COMMAND_MENU_SELECTED, wxCommandEventHandler( VentanaPrincipal::OnPantallaCompleta ) );
			this->Connect( pMosaicoHorizontal->GetId(), wxEVT_COMMAND_MENU_SELECTED, wxCommandEventHandler( VentanaPrincipal::OnMosaicoHorizontal ) );
			this->Connect( pMosaicoVertical->GetId(), wxEVT_COMMAND_MENU_SELECTED, wxCommandEventHandler( VentanaPrincipal::OnMosaicoVertical ) );
			this->Connect( pMosaicoRestaurar->GetId(), wxEVT_COMMAND_MENU_SELECTED, wxCommandEventHandler( VentanaPrincipal::OnMosaicoRestaurar ) );
			this->Connect( pGrid2Col->GetId(), wxEVT_COMMAND_MENU_SELECTED, wxCommandEventHandler( VentanaPrincipal::OnMosaicoGrid2Col ) );
			this->Connect( pGrid3Col->GetId(), wxEVT_COMMAND_MENU_SELECTED, wxCommandEventHandler( VentanaPrincipal::OnMosaicoGrid3Col ) );
		}

		//image
		InsertToolsFromFamily(pMenuImagen, GNC::GCS::IHerramienta::TMenuImagen);

		//3D tools
		InsertToolsFromFamily(pMenu3D, GNC::GCS::IHerramienta::TMenu3D);

		//tools
		InsertToolsFromFamily(pMenuHerramientas, GNC::GCS::IHerramienta::TMenuHerramientas);

		//ayuda
		wxMenuItem*  pMenuOnlineHelp = new wxMenuItem( pMenuAyuda, ID_ONLINE_MANUAL, wxString( _("Ginkgo CADx online manual ...") ), _("Ginkgo CADx online manual ..."), wxITEM_NORMAL );
		wxMenuItem*  m_pMenuCheckUpdates = new wxMenuItem( pMenuAyuda, ID_CHECK_UPDATES, wxString( _("Check for updates") ), _("Check for newest versions"), wxITEM_NORMAL );
		wxMenuItem*  pMenuOnlineSupport = new wxMenuItem( pMenuAyuda, ID_ONLINE_SUPPORT, wxString( _("Need support ...") ), _("Need support ..."), wxITEM_NORMAL );
		wxMenuItem*  pMenuExtSupport = new wxMenuItem( pMenuAyuda, ID_EXTENSIONS_SUPPORT, wxString( _("Get extensions ...") ), _("Get extensions ..."), wxITEM_NORMAL );
		wxMenuItem*  pMenuStartPage = new wxMenuItem( pMenuAyuda, ID_START_PAGE, wxString( _("Start page ...") ), _("Ginkgo CADx start page ..."), wxITEM_NORMAL );
		wxMenuItem*  m_pMenuAcercaDe = new wxMenuItem( pMenuAyuda, ID_ACERCA_DE, wxString( _("About &Ginkgo CADx ...") ), _("About Ginkgo CADx ..."), wxITEM_NORMAL );

		#ifdef __WXMSW__
		pMenuOnlineHelp->SetBitmaps(GinkgoResourcesManager::IconosMenus::GetIcoHelp());
		pMenuOnlineSupport->SetBitmaps(GinkgoResourcesManager::IconosMenus::GetIcoSupport());
		pMenuExtSupport->SetBitmaps(GinkgoResourcesManager::IconosMenus::GetIcoObtainExtensions());
		#else
		pMenuOnlineHelp->SetBitmap(GinkgoResourcesManager::IconosMenus::GetIcoHelp());
		pMenuOnlineSupport->SetBitmap(GinkgoResourcesManager::IconosMenus::GetIcoSupport());
		pMenuExtSupport->SetBitmap(GinkgoResourcesManager::IconosMenus::GetIcoObtainExtensions());
		#endif

		pMenuAyuda->Append( pMenuOnlineHelp );
		pMenuAyuda->AppendSeparator();
		pMenuAyuda->Append( pMenuOnlineSupport );
		pMenuAyuda->Append( pMenuExtSupport );
		pMenuAyuda->AppendSeparator();		
		pMenuAyuda->Append( m_pMenuCheckUpdates );
		pMenuAyuda->Append( pMenuStartPage);
		pMenuAyuda->AppendSeparator();
		pMenuAyuda->Append( m_pMenuAcercaDe );
		InsertToolsFromFamily(pMenuHerramientas, GNC::GCS::IHerramienta::TMenuHelp);

		this->Connect( pMenuOnlineHelp->GetId(), wxEVT_COMMAND_MENU_SELECTED, wxCommandEventHandler( VentanaPrincipal::OnOnlineHelp ) );
		this->Connect( pMenuStartPage->GetId(), wxEVT_COMMAND_MENU_SELECTED, wxCommandEventHandler( VentanaPrincipal::OnShowStartupPage ) );
		this->Connect( m_pMenuCheckUpdates->GetId(), wxEVT_COMMAND_MENU_SELECTED, wxCommandEventHandler( VentanaPrincipal::OnCheckForUpdates ) );
		this->Connect( m_pMenuAcercaDe->GetId(), wxEVT_COMMAND_MENU_SELECTED, wxCommandEventHandler( VentanaPrincipal::OnAcercaDe ) );
		this->Connect( pMenuOnlineSupport->GetId(), wxEVT_COMMAND_MENU_SELECTED, wxCommandEventHandler( VentanaPrincipal::OnOnlineSupport ) );
		this->Connect( pMenuExtSupport->GetId(), wxEVT_COMMAND_MENU_SELECTED, wxCommandEventHandler( VentanaPrincipal::OnExtensionsSupport ) );
	}

	//herramientas -> configuracion, envio hl7 y logs
	if(GNC::GCS::ControladorPermisos::Instance()->Get("core.menu","configuracion")) {
		if(pMenuHerramientas->GetMenuItemCount() >0)
			pMenuHerramientas->AppendSeparator();
		wxMenuItem*  pMenuConfiguracion = NULL;
		wxMenuItem*  pMenuHL7 = NULL;
		wxMenuItem*  pMenuLogs = NULL;
		//herramientas
		pMenuConfiguracion = new wxMenuItem( pMenuHerramientas, ID_CONFIGURACION, wxString(_("Settings")) + wxT("\tAlt+c"), _("Ginkgo CADx settings"), wxITEM_NORMAL );
		pMenuHL7 = new wxMenuItem( pMenuHerramientas, ID_CONTROLHL7, wxString(_("HL7 monitor")) + wxT(""), _("HL7 message control"), wxITEM_NORMAL );
		pMenuLogs = new wxMenuItem( pMenuHerramientas, ID_CONTROLLOGS, wxString(_("Log monitor")) + wxT("\tAlt+r"), _("Log monitored"), wxITEM_NORMAL );

#ifdef __WXMSW__
		pMenuConfiguracion->SetBitmaps(GinkgoResourcesManager::IconosMenus::GetIcoConfiguracion());
#else
		pMenuConfiguracion->SetBitmap(GinkgoResourcesManager::IconosMenus::GetIcoConfiguracion());
#endif
		pMenuHerramientas->Append( pMenuLogs );
		pMenuHerramientas->Append( pMenuHL7 );
		pMenuHerramientas->AppendSeparator();
		pMenuHerramientas->Append( pMenuConfiguracion );
		
		this->Connect( pMenuConfiguracion->GetId(), wxEVT_COMMAND_MENU_SELECTED, wxCommandEventHandler( VentanaPrincipal::OnConfiguracion ) );
		this->Connect( pMenuHL7->GetId(), wxEVT_COMMAND_MENU_SELECTED, wxCommandEventHandler( VentanaPrincipal::OnMensajesHL7 ) );
		this->Connect( pMenuLogs->GetId(), wxEVT_COMMAND_MENU_SELECTED, wxCommandEventHandler( VentanaPrincipal::OnControlLogs ) );
	}

	if (pMenuArchivo->GetMenuItemCount() >0) {
		m_pMenuBar->Append( pMenuArchivo, _("&File") );
	} else {
		delete pMenuArchivo;
	}

	if (pMenuEdicion->GetMenuItemCount() >0) {
		m_pMenuBar->Append( pMenuEdicion, _("&Edit") );
	} else {
		delete pMenuEdicion;
	}

	if (pMenuVer->GetMenuItemCount() >0) {
		m_pMenuBar->Append( pMenuVer, _("View") );
	} else {
		delete pMenuVer;
	}

	if (pMenuImagen->GetMenuItemCount() >0) {
		m_pMenuBar->Append( pMenuImagen, _("Image") );
	} else {
		delete pMenuImagen;
	}

	if (pMenu3D->GetMenuItemCount() >0) {
		m_pMenuBar->Append( pMenu3D, _("3D tools") );
	} else {
		delete pMenu3D;
	}

	if (pMenuHerramientas->GetMenuItemCount() >0) {
		m_pMenuBar->Append( pMenuHerramientas, _("Tools") );
	} else {
		delete pMenuHerramientas;
	}

	if (pMenuAyuda->GetMenuItemCount() >0) {
		m_pMenuBar->Append( pMenuAyuda, _("&Help") );
	} else {
		delete pMenuAyuda;
	}

	this->SetMenuBar(m_pMenuBar);

#ifdef __WXMAC__
	wxMenuBar::MacSetCommonMenuBar(m_pMenuBar);
#endif
	SuperThaw();
}

/*


	//herramientas
	for(GNC::ControladorHerramientas::TMapaHerramientasOrdenadas::iterator itFamilias = mapa.begin(); itFamilias != mapa.end(); itFamilias++) {
		wxMenu* pPadre = NULL;
		switch((*itFamilias).first) {
			case GNC::GCS::IHerramienta::TMenuEdicion:
				pPadre = pMenuEdicion;
				break;
			case GNC::GCS::IHerramienta::TMenuImagen:
				pPadre = pMenuImagen;
				break;
			case GNC::GCS::IHerramienta::TMenu3D:
				pPadre = pMenu3D;
				break;
			case GNC::GCS::IHerramienta::TMenuHerramientas:
				pPadre = pMenuHerramientas;
				break;
			default:
				continue;
		}*/

int VentanaPrincipal::InsertToolsFromFamily(wxMenu* pParent, GNC::GCS::IHerramienta::TFamiliasHerramientas family)
{
	GNC::ControladorHerramientas::TMapaHerramientasOrdenadas mapa = GNC::ControladorHerramientas::Instance()->GetHerramientasOrdenadas();
	if (mapa.find(family) == mapa.end()) {
		//there arent tools
		return 0;
	}
	int submenu = 0;
	GNC::ControladorHerramientas::TMapaSubConjuntosHerramientas mapSub = mapa[family];
	for(GNC::ControladorHerramientas::TMapaSubConjuntosHerramientas::iterator itSubConjuntos = mapSub.begin(); itSubConjuntos!= mapSub.end(); itSubConjuntos++){
		for(GNC::ControladorHerramientas::ListaHerramientas::iterator itLista = (*itSubConjuntos).second.begin(); itLista!= (*itSubConjuntos).second.end(); itLista++){
			GNC::GCS::IHerramienta* pHerramienta = (*itLista);
			if(pHerramienta->IsMenu()){
				if(pHerramienta->IDSubFamilia != submenu)
				{
					if (pParent->GetMenuItemCount() > 0 && !pParent->GetMenuItems().back()->IsSeparator()) {
						pParent->AppendSeparator();
					}
				}
				submenu = pHerramienta->IDSubFamilia;

				if(!pHerramienta->AppendInMenu(this,pParent)) {
					wxMenuItem* pItemHerramienta = new wxMenuItem( pParent, pHerramienta->ID, wxString::FromUTF8(pHerramienta->Nombre.c_str()) , wxString::FromUTF8(pHerramienta->GetDescripcion().c_str()), wxITEM_NORMAL );
					if(pHerramienta->GetIcono().IsOk()){
		#ifdef __WXMSW__
						pItemHerramienta->SetBitmaps(pHerramienta->GetIcono());
		#else
						pItemHerramienta->SetBitmap(pHerramienta->GetIcono());
		#endif
					}
					Connect(pItemHerramienta->GetId(), wxEVT_COMMAND_MENU_SELECTED, wxCommandEventHandler( VentanaPrincipal::OnAplicarHerramienta ));
					pParent->Append(pItemHerramienta);
				}
				Connect(pHerramienta->ID, wxEVT_UPDATE_UI, wxUpdateUIEventHandler( VentanaPrincipal::OnUpdateUIHerramienta ));
			}
		}
	}	
	return mapSub.size();
}

void VentanaPrincipal::CargarHistorial()
{
	SuperFreeze();
	m_pHistorial->RecargarCombos(true);
	m_pHistorial->RecargarBusqueda(true);
	wxCommandEvent event;
	SuperThaw();
}

void VentanaPrincipal::OnComando(EventoProgreso& evento)
{
	switch (evento.GetTipo()) {
		case EventoProgreso::ComandoIniciado:
			GNC::GCS::ControladorComandos::Instance()->OnComandoLanzado(evento.GetThreadId());
			break;
		case EventoProgreso::ComandoEjecutando:
			GNC::GCS::ControladorComandos::Instance()->OnComandoProgreso(evento.GetThreadId());
			break;
		case EventoProgreso::ComandoFinalizado:
			GNC::GCS::ControladorComandos::Instance()->OnComandoFinalizado(evento.GetThreadId());
			break;
		default:
			std::cerr << "Error, Tipo de notificacion de comando desconocida." << std::endl;
			break;
	}

}

void VentanaPrincipal::OnNotebookPageChanging(wxAuiNotebookEvent& /*event*/)
{
	/*
	int old_idx = event.GetOldSelection();
	int new_idx = event.GetSelection();

	if (old_idx != new_idx && old_idx != -1 && new_idx != -1) {

		wxWindowDisabler dis;
		SuperFreeze();

		m_pNoteBook->SetSelection(new_idx);

		SuperThaw();
	}

	event.Skip(false);
	*/
}


void VentanaPrincipal::OnNotebookPageChanged(AUI_NAMESPACE wxAuiNotebookEvent& event)
{
	SuperFreeze();
	if (m_pNoteBook->GetPageCount() == 0) { // Se han eliminado todas las paginas
		//se muestra el mosaico
		if(!m_pMosaicPanel->IsShown()){
			m_mgr.GetPane(m_pMosaicPanel).Show(true);
			m_mgr.GetPane(m_pNoteBook).Hide();
			m_pMosaicPanel->Refresh(false);
		}
	}
	else
	{ // Se ha cambiado de pagina
		//se oculta el mosaico
		if(!m_pNoteBook->IsShown()){
			m_mgr.GetPane(m_pNoteBook).Show(true);
			m_mgr.GetPane(m_pMosaicPanel).Hide();
			m_pNoteBook->Refresh(false);
		}
		GNC::GCS::IVista* v  = GNC::GCS::ControladorVistas::Instance()->ObtenerVistaRegistrada(m_pNoteBook->GetPage(event.selection));
		if (v != NULL) {
			GNC::GCS::ControladorVistas::Instance()->SolicitarActivarVista(v);
		}
	}
	SuperThaw();

}

void VentanaPrincipal::OnPanelClose(AUI_NAMESPACE wxAuiManagerEvent& event)
{
	wxWindowDisabler disabler;
	SuperFreeze();
	if(CerrarVista(event.GetPane()->window)) {
		GNC::GCS::ControladorVistas::Instance()->Destruir(event.GetPane()->window);
	}
	SuperThaw();
}


void VentanaPrincipal::OnNotebookPageClose(AUI_NAMESPACE wxAuiNotebookEvent& event)
{
	wxWindowDisabler disabler;
	SuperFreeze();
	if(CerrarVista(m_pNoteBook->GetPage(event.selection))) {
		GNC::GCS::ControladorVistas::Instance()->Destruir(m_pNoteBook->GetPage(event.selection));
		if (GNC::GCS::ControladorVistas::Instance()->GetVistas().size() == 0) { // Se han eliminado todas las paginas
			//se muestra el mosaico
			if(!m_pMosaicPanel->IsShown()){
				m_mgr.GetPane(m_pNoteBook).Hide();
				m_mgr.GetPane(m_pMosaicPanel).Show(true);
				m_mgr.Update();
			}
		}
	} else {
		event.Veto();
	}
	SuperThaw();
}

void VentanaPrincipal::DestruirPanelGrid(GNC::GUI::PanelGrid* pPanelGrid)
{
	wxWindowDisabler disabler;
	SuperFreeze();
	if(m_pGridPanel->GetSizer()->Detach(pPanelGrid))
	{
		pPanelGrid->Destroy();
		if(GNC::GCS::ControladorVistas::Instance()->GetVistas().size() == 0)
		{
			//se muestra el mosaico
			if(!m_pMosaicPanel->IsShown()){
				m_mgr.GetPane(m_pGridPanel).Hide();
				m_mgr.GetPane(m_pMosaicPanel).Show(true);
				m_mgr.Update();
			}
		} else {
			//si hay mas paneles grid se ha de solicitar activar el que queda
			if(m_pGridPanel->GetSizer()->GetChildren().size() > 0){
				GNC::GUI::PanelGrid* pPanel = (GNC::GUI::PanelGrid*)m_pGridPanel->GetSizer()->GetItem((size_t)0)->GetWindow();
				GNC::GCS::IVista* v = GNC::GCS::ControladorVistas::Instance()->ObtenerVistaRegistrada(pPanel->GetWindow());

				if (v != NULL) {
					GNC::GCS::ControladorVistas::Instance()->SolicitarActivarVista(v);
				}
				else {
					//std::cout << "Error: Vista no encontrada" << std::endl;
					LOG_ERROR("Core", "Error: Vista no encontrada");
				}
			}
			m_pGridPanel->Layout();
		}
	}
	SuperThaw();
}

void VentanaPrincipal::PasarAPrimerPlano(wxWindow* window)
{
	wxWindowDisabler disabler;
	SuperFreeze();
	ReplegarPestanias();
	int index = m_pNoteBook->GetPageIndex(window);
	if(index>0) {
		m_pNoteBook->SetSelection(index);
	}
	//este update es necesario porque pasar a primer plano viene cuando estan en pestanias y cuando estan en grid
	m_mgr.Update();
	SuperThaw();
}

void VentanaPrincipal::DestruirPanelVista(wxWindow* panel)
{
	GNC::GUI::PanelGrid* padre = dynamic_cast<GNC::GUI::PanelGrid*> (panel->GetParent());
	if(padre != NULL) {
		padre->Cerrar();
	} else {
		wxAuiNotebook* padreNotebook = dynamic_cast<wxAuiNotebook*> (panel->GetParent());
		if(padreNotebook != NULL)
		{
			CerrarNotebookPage(panel);
		} else {
			GNC::GUI::DialogoDesencajado* pDialogo = dynamic_cast<GNC::GUI::DialogoDesencajado*> (panel->GetParent());
			if(pDialogo != NULL)
			{
				pDialogo->Close();
			}
		}
	}
}

void VentanaPrincipal::CerrarNotebookPage(wxWindow* panel)
{
	int index = m_pNoteBook->GetPageIndex(panel);
	if (index < 0 ) {
		return;
	}

	SuperFreeze();
	if(CerrarVista(panel)) {
		m_pNoteBook->DeletePage(index);
		if (m_pNoteBook->GetPageCount() == 0) { // Se han eliminado todas las paginas
			//se muestra el mosaico
			if(!m_pMosaicPanel->IsShown()){
				m_mgr.GetPane(m_pNoteBook).Hide();
				m_mgr.GetPane(m_pMosaicPanel).Show(true);
				m_mgr.Update();
			}
		}
		m_mgr.Update();
	}
	SuperThaw();
}

bool VentanaPrincipal::CerrarVista(GNC::GCS::IVista* pVista)
{
	if (pVista == NULL)
		return true;

	//it's important to avoid focus errors
	this->Raise();
	if (this->IsIconized()) {
		this->Restore();
	}

	wxWindow* pWindow = pVista->GetWindow();
	//if it's a tab...
	int idx = m_pNoteBook->GetPageIndex(pWindow);
	if(idx >= 0){
		unsigned int tabCount = m_pNoteBook->GetPageCount();
		//selects the page
		if (idx >= 0) {
			if(idx != m_pNoteBook->GetSelection()){
				wxWindowDisabler dis;
				SuperFreeze();
				m_pNoteBook->SetSelection(idx);
				SuperThaw();
			}
		}
		#if defined(USE_PATCHED_LIBS)
		AUI_NAMESPACE wxAuiNotebookEvent evt(wxEVT_COMMAND_AUINOTEBOOK_BUTTON, m_pNoteBook->GetSelection());
		evt.SetInt(wxAUI_BUTTON_CLOSE);
		evt.SetId(5380+500);
		evt.SetEventObject(m_pNoteBook->GetActiveTabCtrl());
		m_pNoteBook->GetEventHandler()->ProcessEvent(evt);
		#endif
		return ( tabCount > m_pNoteBook->GetPageCount() );
	} else {
		GNC::GUI::PanelGrid* pPanel = dynamic_cast<GNC::GUI::PanelGrid*> (pWindow->GetParent());
		if(pPanel!=NULL) {
			return pPanel->Cerrar();
		} else {
			GNC::GUI::DialogoDesencajado* pDlg = dynamic_cast<GNC::GUI::DialogoDesencajado*>(pWindow->GetParent());
			if(pDlg != NULL)
			{
				bool closed = pDlg->Close();
				return closed;;
			} else {
				return false;
			}
		}
	}

}

bool VentanaPrincipal::CerrarVista(wxWindow* window) {
	bool permitido = true;
	SuperFreeze();

	GNC::GCS::ControladorVistas* pcv = GNC::GCS::ControladorVistas::Instance();
	if (pcv == NULL) {
		std::cerr << "Error: No se pudo obtener el controlador de vistas" << std::endl;
		SuperThaw();
		return false;
	}
	GNC::GCS::IVista* v  = pcv->ObtenerVistaRegistrada(window);

	if (v != NULL) {
		if (v->SoportaGuardar() && v->EstaModificada()) {
			std::string titulo = GNC::GCS::ControladorVistas::Instance()->GetTitulo(v);
			wxString descr;
			std::ostringstream os;
			os << _Std("Would you like to save the changes in the study:") << titulo.c_str() << "?";
			PauseSuperFreeze();
			int answer = wxMessageBox(wxString::FromUTF8(os.str().c_str()), _("Unsaved data"), wxYES_NO | wxCANCEL, this);
			ContSuperFreeze();
			if (answer == wxCANCEL) {
				permitido = false;
			}
			else if (answer == wxYES) {
				if (!v->Guardar()) {

					wxMessageDialog dialog(NULL,_("Errors have occurred when saving the series.\nWould you like to continue closing? "),_("Error saving"),wxYES_NO|wxICON_WARNING);
					PauseSuperFreeze();
					permitido = dialog.ShowModal() == wxID_YES;
					ContSuperFreeze();
				}
			}
		}
	}

	SuperThaw();

	return permitido;
}

void VentanaPrincipal::OnNotebookCambiarTab(AUI_NAMESPACE wxAuiNotebookEvent& event)
{
	wxWindowDisabler disabler;
	SuperFreeze();
	if(m_pNoteBook->GetSelection()!=-1){
		GNC::GCS::IVista* v  = GNC::GCS::ControladorVistas::Instance()->ObtenerVistaRegistrada(m_pNoteBook->GetPage(event.selection));
		GNC::GCS::ControladorVistas* pcv = GNC::GCS::ControladorVistas::Instance();
		if(v!=NULL && pcv != NULL){
			pcv->SolicitarActivarVista(v);
		}
	}
	SuperThaw();
	event.Skip(true);
}

void VentanaPrincipal::OnNotebookMenuTab(AUI_NAMESPACE wxAuiNotebookEvent& )
{
	wxMenu*  menu = new wxMenu();
	//cerrar pestania activa
	wxMenuItem*  pPantallaCompleta = new wxMenuItem( menu, ID_PANTALLA_COMPLETA, wxString(_("Full Screen")) + wxT("\tF11"), _("View Full Screen"), wxITEM_NORMAL );

	wxMenu* subMenuPestanias = new wxMenu();
	wxMenuItem* pMenuMostrarPrimerPlano = new wxMenuItem(subMenuPestanias, wxID_ANY, _("Tab Regroup"), _("Tab Regroup"), wxITEM_NORMAL );
	wxMenuItem*  pMosaicoHorizontal = new wxMenuItem( subMenuPestanias, ID_MOSAICO_HORIZONTAL, _("Tile Horizontally"), _("Tile Horizontally"), wxITEM_NORMAL );
	wxMenuItem*  pMosaicoVertical = new wxMenuItem( subMenuPestanias, ID_MOSAICO_VERTICAL, _("Tile Vertically"), _("Tile Vertically"), wxITEM_NORMAL );

	wxMenu* subMenuGrid = new wxMenu();
	wxMenuItem*  pGrid2Col = new wxMenuItem( subMenuGrid, ID_GRID_2_COLUMNAS, _("Grid (two columns)"), _("Grid (two columns)"), wxITEM_NORMAL );
	wxMenuItem*  pGrid3Col = new wxMenuItem( subMenuGrid, ID_GRID_3_COLUMNAS, _("Grid (three columns)"), _("Grid (three columns)"), wxITEM_NORMAL );

	wxMenuItem* pMenuCerrarActiva = new wxMenuItem(menu, ID_CERRAR, _("&Close"), _("Close"), wxITEM_NORMAL );
	wxMenuItem* pMenuCerrarTodas = new wxMenuItem(menu, ID_CERRAR_TODAS, _("&Close all") , _("Close all windows"), wxITEM_NORMAL );

	menu->Connect(pMenuMostrarPrimerPlano->GetId(),wxEVT_COMMAND_MENU_SELECTED,wxCommandEventHandler( VentanaPrincipal::OnMenuPrimerPlanoPestaniaActiva),NULL,this);

#ifdef __WXMSW__
	pMenuCerrarActiva->SetBitmaps(GinkgoResourcesManager::IconosMenus::GetIcoCerrarTab());
	pMenuMostrarPrimerPlano->SetBitmaps(GinkgoResourcesManager::MenusTabs::GetIcoReagrupar());
	pPantallaCompleta->SetBitmaps(GinkgoResourcesManager::IconosMenus::GetIcoPantallaCompleta());
	pGrid2Col->SetBitmaps(GinkgoResourcesManager::MenusTabs::GetIcoGrid2Col());
	pGrid3Col->SetBitmaps(GinkgoResourcesManager::MenusTabs::GetIcoGrid3Col());
#else
	pMenuCerrarActiva->SetBitmap(GinkgoResourcesManager::IconosMenus::GetIcoCerrarTab());
	pMenuMostrarPrimerPlano->SetBitmap(GinkgoResourcesManager::MenusTabs::GetIcoReagrupar());
	pPantallaCompleta->SetBitmap(GinkgoResourcesManager::IconosMenus::GetIcoPantallaCompleta());
	pGrid2Col->SetBitmap(GinkgoResourcesManager::MenusTabs::GetIcoGrid2Col());
	pGrid3Col->SetBitmap(GinkgoResourcesManager::MenusTabs::GetIcoGrid3Col());
#endif

	menu->Append( pPantallaCompleta );
	menu->AppendSeparator();
	subMenuPestanias->Append(pMenuMostrarPrimerPlano);
	subMenuPestanias->AppendSeparator();
	subMenuPestanias->Append(pMosaicoHorizontal);
	subMenuPestanias->Append(pMosaicoVertical);
	menu->AppendSubMenu(subMenuPestanias,_("Tabbed organization"));
	subMenuGrid->Append(pGrid2Col);
	subMenuGrid->Append(pGrid3Col);
	menu->AppendSubMenu(subMenuGrid,_("Grid organization"));
	menu->AppendSeparator();
	menu->Append(pMenuCerrarActiva);
	menu->Append(pMenuCerrarTodas);
	m_pNoteBook->PopupMenu(menu);
	delete menu;
}

void VentanaPrincipal::OnNotebookFocus(wxChildFocusEvent&)
{

/*	if(m_pNoteBook->GetPageCount() > 0){
		GNC::GCS::IVista* v  = GNC::GCS::ControladorVistas::Instance()->ObtenerPrimeraVista(m_pNoteBook->GetPage(m_pNoteBook->GetSelection()));
		v->GetWindow()->SetFocus();
	}
	*/
}

//region "eventos ginkgo"
void VentanaPrincipal::ProcesarEvento(GNC::GCS::Eventos::IEvento *pEvt)
{
	switch (pEvt->GetCodigoEvento()) {
		case ginkgoEVT_Core_UpdateAvailable:
			{
				GNC::GCS::Eventos::EventoUpdateAvailable* pE = dynamic_cast<GNC::GCS::Eventos::EventoUpdateAvailable*>(pEvt);
				if (pE != NULL) {

					int curVersion    = 0;
					int curSubVersion = 0;
					int curRelease    = 0;
					int curBuild      = 0;

					GNC::Entorno::Instance()->GetGinkgoVersionAsTuple(&curVersion, &curSubVersion, &curRelease, &curBuild, NULL);

					bool superior = false;

					if ( pE->GetVersion() > curVersion ) {
						superior = true;
					}
					else if (pE->GetVersion() == curVersion) {
						if ( pE->GetSubVersion() > curSubVersion ) {
							superior = true;
						}
						else if (pE->GetSubVersion() == curSubVersion)
						{
							if ( pE->GetRelease() > curRelease ) {
								superior = true;
							}
							else if (pE->GetRelease() == curRelease)
							{
								if ( pE->GetBuild() > curBuild ) {
									superior = true;
								}
							}
						}
					}

					m_VersionChecked = true;
					m_VersionNueva = pE->GetVersionString();
					m_VersionCheck = pE->GetVersionCheck();

					if (!superior) {
						if (pE->Informar()) {
							wxMessageBox(_("There is not newest Ginkgo CADx versions at this moment."), _("Ginkgo CADx updated"), wxICON_INFORMATION);
						}
						return;
					}

					std::string valor;
					GNC::GCS::ConfigurationController::Instance()->readStringGeneral("/GinkgoCore/SkipUpdate", m_VersionCheck, valor, "0");
					if (valor == "1" && !pE->Informar()) {
						return;
					}

					//wxWindowDisabler dis;
					//SuperFreeze();

					m_pHipervinculoActualizacion->SetLabel(wxString(_("New version available (")) + wxString::FromUTF8(m_VersionNueva.c_str()) + _T(")") );
					m_pHipervinculoActualizacion->SetURL(wxString::FromUTF8(pE->GetURL().c_str()));
					m_pHipervinculoActualizacion->SetToolTip(wxString::FromUTF8(pE->GetDescription().c_str()));

					if (valor == "1") {
						m_pDoNotWarnAgain->SetValue(true);
					}
					else {
						m_pDoNotWarnAgain->SetValue(false);
					}

					m_pPanelActualizacion->Show();
					//m_pPanelCentral->Layout();
					Layout();
					Refresh(true);

					//SuperThaw();
				}
			}
			break;
		default:
			break;
	}
}
//endregion

//region "Realización de la interfaz INotificacionExtensiones"
void VentanaPrincipal::OnModuloCargado(GNC::GCS::IControladorModulo* )
{
	//GTRACE("VentanaPrincipal::OnModuloCargado(" << pCM->GetNombre().c_str() << ")");
	RefrescarMenus();
}

void VentanaPrincipal::OnModuloDescargado(GNC::GCS::IControladorModulo* )
{
	//GTRACE("VentanaPrincipal::OnModuloDescargado(" << pCM->GetNombre().c_str() << ")");
}

void VentanaPrincipal::OnModuloActivado(GNC::GCS::IControladorModulo* pCM)
{
	if (pCM != NULL) {
		GTRACE("VentanaPrincipal::OnModuloActivado(" << pCM->GetNombre().c_str() << ")");
	}
	else {
		GTRACE("VentanaPrincipal::OnModuloActivado(" << pCM->GetNombre().c_str() << ")");
	}
}

void VentanaPrincipal::OnModuloDesactivado(GNC::GCS::IControladorModulo* )
{
	//GTRACE("VentanaPrincipal::OnModuloDeactivado(" << pCM->GetNombre().c_str() << ")");
}
//endregion

//region "Realización de la interfaz INotificacionVistas"

void VentanaPrincipal::OnVistaActivada(GNC::GCS::IVista* pVista) {
	#if defined (_WINDOWS)
	wxWindowDisabler dis;
	#endif
	if (pVista == NULL) {
		return;
	}
	//Se comprueba si la pestaña activa es la correcta
	ForzarCambioVista(pVista);
	//
}

//endregion

//region "helpers"
void VentanaPrincipal::SuperFreeze()
{
	if (m_SuperFreezeCount <= 0) {
		GTRACE("SuperFreeze Locked");
		if (m_SuperFreezeCount < 0) {
			m_SuperFreezeCount = 0;
			std::cerr << "Error: Estado de bloqueo inconsistente." << std::endl;
		}
		Freeze();
		m_pPanelActualizacion->Freeze();
		m_pPanelCentral->Freeze();
		m_pHistorial->Freeze();
		m_pGridPanel->Freeze();
		m_pMosaicPanel->Freeze();
		m_pNoteBook->Freeze();
		m_pGridPanel->Freeze();
		m_pPanelHerramientasSuperior->Freeze();
		m_pMenuBar->Freeze();

	}
	m_SuperFreezeCount++;
}

void VentanaPrincipal::SuperThaw()
{
	m_SuperFreezeCount--;

	if (m_SuperFreezeCount <= 0) {
		GTRACE("SuperFreeze Released");
		if (m_SuperFreezeCount < 0) {
			m_SuperFreezeCount = 0;
			std::cerr << "Error: Estado de bloqueo inconsistente." << std::endl;
		}

		m_pMenuBar->Thaw();
		m_pPanelHerramientasSuperior->Thaw();
		m_pGridPanel->Thaw();
		m_pNoteBook->Thaw();
		m_pMosaicPanel->Thaw();
		m_pHistorial->Thaw();
		m_pGridPanel->Thaw();
		m_pPanelCentral->Thaw();
		m_pPanelActualizacion->Thaw();
		Thaw();
	}
}

void VentanaPrincipal::PauseSuperFreeze()
{
	if (m_SuperFreezeCount > 0) {
		GTRACE("SuperFreeze Paused");

		m_pMenuBar->Thaw();
		m_pPanelHerramientasSuperior->Thaw();
		m_pNoteBook->Thaw();
		m_pMosaicPanel->Thaw();
		m_pHistorial->Thaw();
		m_pGridPanel->Thaw();
		m_pPanelCentral->Thaw();
		m_pPanelActualizacion->Thaw();
		Thaw();
	}
}

void VentanaPrincipal::ContSuperFreeze()
{
	if (m_SuperFreezeCount > 0) {
		GTRACE("SuperFreeze Resumed");
		Freeze();
		m_pPanelCentral->Freeze();
		m_pPanelActualizacion->Freeze();
		m_pHistorial->Freeze();
		m_pGridPanel->Freeze();
		m_pMosaicPanel->Freeze();
		m_pNoteBook->Freeze();
		m_pPanelHerramientasSuperior->Freeze();
		m_pMenuBar->Freeze();
	}
}
//endregion

//region "login e inicializacion"
void VentanaPrincipal::Login()
{
	if (GSEC::Auth::ControladorAutenticacion::Instance()->GetTipoAutenticacion() != GSEC::Auth::TA_NO_LOGIN)
	{
		try {

			GNC::GUI::DialogoLogin dlg(NULL);
			if (dlg.ShowModal() == wxID_OK) {
				MostrarVentana();
			}
			else {
				Close();
			}
		}
		catch (...)
		{
			LOG_ERROR("Core/Auth", "Error interno al autenticar");
			wxMessageBox(_("Internal error during auth process"), _("Internal error"), wxICON_ERROR);
			Close();
		}
	}
	else {
		MostrarVentana();
	}
}

void VentanaPrincipal::MostrarVentana()
{
	if (m_Iniciada) {
		Show(true);
		return;
	}
	m_Iniciada = true;
	try {
		//arrancamos el hilo de envio hl7
		if (GNC::GCS::ControladorPermisos::Instance()->Get("core.hl7", "autostart")) {
			GIL::HL7::ControladorEnvioHl7::Arrancar();
		}
		GIL::XMLRPC::XMLRPCController::StartServer();
	}
	catch(...)
	{
		LOG_ERROR("Core/Init", "Error al arrancar el controlador de envio");
	}
	wxWindowDisabler dis;

	GNC::GCS::ControladorEventos::Instance()->Registrar(this, GNC::GCS::Eventos::EventoUpdateAvailable() );

	std::ostringstream os;
	os << "Ginkgo CADx " << GNC::Entorno::Instance()->GetGinkgoCopyRight() << " " << "MetaEmotion Healthcare";
	SetStatusText(wxString::FromUTF8(os.str().c_str()));
#if !defined(_GINKGO_DEBUG)
	SetSize(wxDisplay().GetClientArea().GetSize());
#endif
	Center();
#if !defined(_GINKGO_DEBUG)
/////////////////ATENCION!!!! esto es porque sino en windows no va bien, se desvincula la status bar
	#ifdef _WIN32
			Show(true);
			Maximize(true);
	#else
			Maximize(true);
			Show(true);
	#endif
#else
	Show(true);
#endif
	SetFocus();
	ComprobarActualizaciones();

}

//endregion

//region "Getters y Setters de elementos de la interfaz"

AUI_NAMESPACE wxAuiNotebook* VentanaPrincipal::GetAUINoteBook()
{
	return m_pNoteBook;
}

GNC::GUI::PanelHistorial2* VentanaPrincipal::GetPanelHistorial()
{
	return m_pHistorial;
}


//endregion
