/*
 *  
 *  $Id: controladorenviohl7.h 4670 2012-02-08 07:11:51Z tovar $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
#pragma once
#include <api/api.h>
#include <api/icontroladoreventos.h>
#include <wx/thread.h>

class wxSQLite3Database;
class wxCriticalSection;

namespace GIL {
	namespace HL7 {
		class EXTAPI ControladorEnvioHl7:  protected wxThread, public GNC::GCS::IObservador
		{
		public:
			static void FreeInstance();
			static void Arrancar();
			static bool EstaArrancado();
			void Abortar();
			bool EstaAbortado();

		protected:
			static ControladorEnvioHl7* m_pInstance;
			static wxCriticalSection m_criticalSection;

			ControladorEnvioHl7();
			~ControladorEnvioHl7();

			virtual void* Entry();

			virtual void ProcesarEvento(GNC::GCS::Eventos::IEvento *evt) ;
			wxSemaphore		m_semaphore;
			bool m_Abortado;
		};
	}
}
