/*
 *  
 *  $Id: icontroladorvistas.h 3518 2011-03-16 13:53:24Z carlos $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 */
#pragma once

#include <string>
#include <list>
#include "api.h"
#include "observers/iviewsobserver.h"

class wxWindow;

namespace GNC {
	namespace GCS {

		class IControladorVistas {
		public:
			typedef std::list<IVista*> TipoListaVistas;

			virtual ~IControladorVistas() {}

			virtual wxWindow* GetRootWindow() = 0;

			virtual void Freeze() = 0;
			virtual void Thaw() = 0;

			virtual void SetTitulo(GNC::GCS::IVista* pVista, const std::string& titulo) = 0;
			virtual std::string GetTitulo(GNC::GCS::IVista* pVista) = 0;

			virtual void Registrar(GNC::GCS::IVista*  pVista) = 0;
			virtual void Destruir(GNC::GCS::IVista*   pVista) = 0;
			virtual void Destruir(wxWindow* pVentana) = 0;

//region "Getters de vistas activas"

			virtual GNC::GCS::IVista* GetVistaActiva() = 0;

//endregion

//region "Propagacion de eventos de cambios de configuracion
			virtual void PropagarConfiguracionCambiada() = 0;
//endregion

//region "Gestion de carga y descarga de vistas"
			virtual void SolicitarActivarVista(GNC::GCS::IVista* pVista) = 0;
//endregion

//region "Gestion de paneles extra"

			virtual void InsertarPanelIzquierdo(wxWindow* win, const char* caption) = 0;

			virtual void InsertarPanelDerecho(wxWindow* win, const char* caption) = 0;

			virtual void EliminarPanel(wxWindow* win) = 0;

			virtual void MostrarPanel(wxWindow* win) = 0;

			virtual void OcultarPanel(wxWindow* win) = 0;

//endregion

			virtual TipoListaVistas GetVistas() = 0;

			//sirve para generar colores inteligentemente
			typedef struct TColorRGB {
				unsigned char r;
				unsigned char g;
				unsigned char b;
				TColorRGB ()
				{}
				TColorRGB (unsigned char r, unsigned char g, unsigned char b)
				{
					this->r = r;
					this->g = g;
					this->b = b;
				}
			}TColorRGB;

			//recibe un color base y un nivel de oscuridad de 0 a 4 siendo 0 el mas oscuro
			virtual TColorRGB GetColor(TColorRGB colorBase, unsigned char level) = 0;

		protected:

			IControladorVistas()
			{
			}

		};
	}
}
