/*
 *  
 *  $Id: icontroladorcomandos.h 4687 2012-02-10 13:35:07Z carlos $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 */
#pragma once

#include <string>
#include <iostream>
#include <exception>
#include "icomando.h"

namespace GNC {
	namespace GCS {

		class ControladorComandosException : public GNC::GCS::IException {
		public:
			ControladorComandosException(const std::string& msg, const std::string& componente="Modelo", bool fatal = true) throw() : GNC::GCS::IException(msg, componente, fatal) {}			
		};


		class IControladorComandos {
		public:

			~IControladorComandos()
			{
			}

			virtual void Process(IComando*) = 0;
			virtual void ProcessAsync(std::string descr, IComando*, void* owner) = 0;
			virtual void AbortarComando(long threadId, bool sincrono = true) = 0;
			virtual void AbortarComandosDeOwner(void* owner) = 0;
			virtual void AbortarComandosDeOwnerAsincrono(void* owner) = 0;
			virtual void AbortarComando(IComando* pComando, bool sincrono = true) = 0;

		protected:

			IControladorComandos()
			{
			}

		};
	}
}
