/* -----------------------------------------------------------------------------
 *
 * (c) The GHC Team, 1998-2009
 *
 * General utility functions used in the RTS.
 *
 * ---------------------------------------------------------------------------*/

#ifndef RTSUTILS_H
#define RTSUTILS_H

BEGIN_RTS_PRIVATE

/* -----------------------------------------------------------------------------
 * (Checked) dynamic allocation
 * -------------------------------------------------------------------------- */

void initAllocator(void);
void shutdownAllocator(void);

void *stgMallocBytes(int n, char *msg)
    GNUC3_ATTRIBUTE(__malloc__);

void *stgReallocBytes(void *p, int n, char *msg);

void *stgCallocBytes(int n, int m, char *msg)
     GNUC3_ATTRIBUTE(__malloc__);

void stgFree(void* p);

/* -----------------------------------------------------------------------------
 * Misc other utilities
 * -------------------------------------------------------------------------- */

void heapOverflow(void);

char *time_str(void);
char *ullong_format_string(ullong, char *, rtsBool);

#ifdef DEBUG
void heapCheckFail( void );
#endif

void printRtsInfo(void);

/* Alternate to raise(3) for threaded rts, for OpenBSD */
int genericRaise(int sig);

int rts_isProfiled(void);

END_RTS_PRIVATE

#endif /* RTSUTILS_H */
