/*
** Copyright (c) 2018-2023 Valve Corporation
** Copyright (c) 2018-2023 LunarG, Inc.
** Copyright (c) 2023 Advanced Micro Devices, Inc.
**
** Permission is hereby granted, free of charge, to any person obtaining a
** copy of this software and associated documentation files (the "Software"),
** to deal in the Software without restriction, including without limitation
** the rights to use, copy, modify, merge, publish, distribute, sublicense,
** and/or sell copies of the Software, and to permit persons to whom the
** Software is furnished to do so, subject to the following conditions:
**
** The above copyright notice and this permission notice shall be included in
** all copies or substantial portions of the Software.
**
** THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
** IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
** FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
** AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
** LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
** FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
** DEALINGS IN THE SOFTWARE.
*/

/*
** This file is generated from the Khronos Vulkan XML API Registry.
**
*/

#include "encode/handle_unwrap_memory.h"
#include "format/platform_types.h"
#include "util/defines.h"

#include "vulkan/vulkan.h"
#include "vk_video/vulkan_video_codec_h264std.h"
#include "vk_video/vulkan_video_codec_h264std_decode.h"
#include "vk_video/vulkan_video_codec_h264std_encode.h"
#include "vk_video/vulkan_video_codec_h265std.h"
#include "vk_video/vulkan_video_codec_h265std_decode.h"
#include "vk_video/vulkan_video_codec_h265std_encode.h"
#include "vk_video/vulkan_video_codecs_common.h"

GFXRECON_BEGIN_NAMESPACE(gfxrecon)
GFXRECON_BEGIN_NAMESPACE(encode)

template <typename T>
T* MakeUnwrapStructs(const T* values, size_t len, HandleUnwrapMemory* unwrap_memory)
{
    assert((values != nullptr) && (len > 0) && (unwrap_memory != nullptr));

    const uint8_t* bytes     = reinterpret_cast<const uint8_t*>(values);
    size_t         num_bytes = len * sizeof(T);

    return reinterpret_cast<T*>(unwrap_memory->GetFilledBuffer(bytes, num_bytes));
}

VkBufferMemoryBarrier* TrackStruct(const VkBufferMemoryBarrier* value, HandleUnwrapMemory* unwrap_memory);
VkImageMemoryBarrier* TrackStruct(const VkImageMemoryBarrier* value, HandleUnwrapMemory* unwrap_memory);
VkMemoryBarrier* TrackStruct(const VkMemoryBarrier* value, HandleUnwrapMemory* unwrap_memory);
VkApplicationInfo* TrackStruct(const VkApplicationInfo* value, HandleUnwrapMemory* unwrap_memory);
VkInstanceCreateInfo* TrackStruct(const VkInstanceCreateInfo* value, HandleUnwrapMemory* unwrap_memory);
VkDeviceQueueCreateInfo* TrackStruct(const VkDeviceQueueCreateInfo* value, HandleUnwrapMemory* unwrap_memory);
VkDeviceCreateInfo* TrackStruct(const VkDeviceCreateInfo* value, HandleUnwrapMemory* unwrap_memory);
VkSubmitInfo* TrackStruct(const VkSubmitInfo* value, HandleUnwrapMemory* unwrap_memory);
VkMappedMemoryRange* TrackStruct(const VkMappedMemoryRange* value, HandleUnwrapMemory* unwrap_memory);
VkMemoryAllocateInfo* TrackStruct(const VkMemoryAllocateInfo* value, HandleUnwrapMemory* unwrap_memory);
VkBindSparseInfo* TrackStruct(const VkBindSparseInfo* value, HandleUnwrapMemory* unwrap_memory);
VkFenceCreateInfo* TrackStruct(const VkFenceCreateInfo* value, HandleUnwrapMemory* unwrap_memory);
VkSemaphoreCreateInfo* TrackStruct(const VkSemaphoreCreateInfo* value, HandleUnwrapMemory* unwrap_memory);
VkEventCreateInfo* TrackStruct(const VkEventCreateInfo* value, HandleUnwrapMemory* unwrap_memory);
VkQueryPoolCreateInfo* TrackStruct(const VkQueryPoolCreateInfo* value, HandleUnwrapMemory* unwrap_memory);
VkBufferCreateInfo* TrackStruct(const VkBufferCreateInfo* value, HandleUnwrapMemory* unwrap_memory);
VkBufferViewCreateInfo* TrackStruct(const VkBufferViewCreateInfo* value, HandleUnwrapMemory* unwrap_memory);
VkImageCreateInfo* TrackStruct(const VkImageCreateInfo* value, HandleUnwrapMemory* unwrap_memory);
VkImageViewCreateInfo* TrackStruct(const VkImageViewCreateInfo* value, HandleUnwrapMemory* unwrap_memory);
VkShaderModuleCreateInfo* TrackStruct(const VkShaderModuleCreateInfo* value, HandleUnwrapMemory* unwrap_memory);
VkPipelineCacheCreateInfo* TrackStruct(const VkPipelineCacheCreateInfo* value, HandleUnwrapMemory* unwrap_memory);
VkPipelineShaderStageCreateInfo* TrackStruct(const VkPipelineShaderStageCreateInfo* value, HandleUnwrapMemory* unwrap_memory);
VkComputePipelineCreateInfo* TrackStruct(const VkComputePipelineCreateInfo* value, HandleUnwrapMemory* unwrap_memory);
VkPipelineVertexInputStateCreateInfo* TrackStruct(const VkPipelineVertexInputStateCreateInfo* value, HandleUnwrapMemory* unwrap_memory);
VkPipelineInputAssemblyStateCreateInfo* TrackStruct(const VkPipelineInputAssemblyStateCreateInfo* value, HandleUnwrapMemory* unwrap_memory);
VkPipelineTessellationStateCreateInfo* TrackStruct(const VkPipelineTessellationStateCreateInfo* value, HandleUnwrapMemory* unwrap_memory);
VkPipelineViewportStateCreateInfo* TrackStruct(const VkPipelineViewportStateCreateInfo* value, HandleUnwrapMemory* unwrap_memory);
VkPipelineRasterizationStateCreateInfo* TrackStruct(const VkPipelineRasterizationStateCreateInfo* value, HandleUnwrapMemory* unwrap_memory);
VkPipelineMultisampleStateCreateInfo* TrackStruct(const VkPipelineMultisampleStateCreateInfo* value, HandleUnwrapMemory* unwrap_memory);
VkPipelineDepthStencilStateCreateInfo* TrackStruct(const VkPipelineDepthStencilStateCreateInfo* value, HandleUnwrapMemory* unwrap_memory);
VkPipelineColorBlendStateCreateInfo* TrackStruct(const VkPipelineColorBlendStateCreateInfo* value, HandleUnwrapMemory* unwrap_memory);
VkPipelineDynamicStateCreateInfo* TrackStruct(const VkPipelineDynamicStateCreateInfo* value, HandleUnwrapMemory* unwrap_memory);
VkGraphicsPipelineCreateInfo* TrackStruct(const VkGraphicsPipelineCreateInfo* value, HandleUnwrapMemory* unwrap_memory);
VkPipelineLayoutCreateInfo* TrackStruct(const VkPipelineLayoutCreateInfo* value, HandleUnwrapMemory* unwrap_memory);
VkSamplerCreateInfo* TrackStruct(const VkSamplerCreateInfo* value, HandleUnwrapMemory* unwrap_memory);
VkCopyDescriptorSet* TrackStruct(const VkCopyDescriptorSet* value, HandleUnwrapMemory* unwrap_memory);
VkDescriptorPoolCreateInfo* TrackStruct(const VkDescriptorPoolCreateInfo* value, HandleUnwrapMemory* unwrap_memory);
VkDescriptorSetAllocateInfo* TrackStruct(const VkDescriptorSetAllocateInfo* value, HandleUnwrapMemory* unwrap_memory);
VkDescriptorSetLayoutCreateInfo* TrackStruct(const VkDescriptorSetLayoutCreateInfo* value, HandleUnwrapMemory* unwrap_memory);
VkWriteDescriptorSet* TrackStruct(const VkWriteDescriptorSet* value, HandleUnwrapMemory* unwrap_memory);
VkFramebufferCreateInfo* TrackStruct(const VkFramebufferCreateInfo* value, HandleUnwrapMemory* unwrap_memory);
VkRenderPassCreateInfo* TrackStruct(const VkRenderPassCreateInfo* value, HandleUnwrapMemory* unwrap_memory);
VkCommandPoolCreateInfo* TrackStruct(const VkCommandPoolCreateInfo* value, HandleUnwrapMemory* unwrap_memory);
VkCommandBufferAllocateInfo* TrackStruct(const VkCommandBufferAllocateInfo* value, HandleUnwrapMemory* unwrap_memory);
VkCommandBufferInheritanceInfo* TrackStruct(const VkCommandBufferInheritanceInfo* value, HandleUnwrapMemory* unwrap_memory);
VkCommandBufferBeginInfo* TrackStruct(const VkCommandBufferBeginInfo* value, HandleUnwrapMemory* unwrap_memory);
VkRenderPassBeginInfo* TrackStruct(const VkRenderPassBeginInfo* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceSubgroupProperties* TrackStruct(const VkPhysicalDeviceSubgroupProperties* value, HandleUnwrapMemory* unwrap_memory);
VkBindBufferMemoryInfo* TrackStruct(const VkBindBufferMemoryInfo* value, HandleUnwrapMemory* unwrap_memory);
VkBindImageMemoryInfo* TrackStruct(const VkBindImageMemoryInfo* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDevice16BitStorageFeatures* TrackStruct(const VkPhysicalDevice16BitStorageFeatures* value, HandleUnwrapMemory* unwrap_memory);
VkMemoryDedicatedRequirements* TrackStruct(const VkMemoryDedicatedRequirements* value, HandleUnwrapMemory* unwrap_memory);
VkMemoryDedicatedAllocateInfo* TrackStruct(const VkMemoryDedicatedAllocateInfo* value, HandleUnwrapMemory* unwrap_memory);
VkMemoryAllocateFlagsInfo* TrackStruct(const VkMemoryAllocateFlagsInfo* value, HandleUnwrapMemory* unwrap_memory);
VkDeviceGroupRenderPassBeginInfo* TrackStruct(const VkDeviceGroupRenderPassBeginInfo* value, HandleUnwrapMemory* unwrap_memory);
VkDeviceGroupCommandBufferBeginInfo* TrackStruct(const VkDeviceGroupCommandBufferBeginInfo* value, HandleUnwrapMemory* unwrap_memory);
VkDeviceGroupSubmitInfo* TrackStruct(const VkDeviceGroupSubmitInfo* value, HandleUnwrapMemory* unwrap_memory);
VkDeviceGroupBindSparseInfo* TrackStruct(const VkDeviceGroupBindSparseInfo* value, HandleUnwrapMemory* unwrap_memory);
VkBindBufferMemoryDeviceGroupInfo* TrackStruct(const VkBindBufferMemoryDeviceGroupInfo* value, HandleUnwrapMemory* unwrap_memory);
VkBindImageMemoryDeviceGroupInfo* TrackStruct(const VkBindImageMemoryDeviceGroupInfo* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceGroupProperties* TrackStruct(const VkPhysicalDeviceGroupProperties* value, HandleUnwrapMemory* unwrap_memory);
VkDeviceGroupDeviceCreateInfo* TrackStruct(const VkDeviceGroupDeviceCreateInfo* value, HandleUnwrapMemory* unwrap_memory);
VkBufferMemoryRequirementsInfo2* TrackStruct(const VkBufferMemoryRequirementsInfo2* value, HandleUnwrapMemory* unwrap_memory);
VkImageMemoryRequirementsInfo2* TrackStruct(const VkImageMemoryRequirementsInfo2* value, HandleUnwrapMemory* unwrap_memory);
VkImageSparseMemoryRequirementsInfo2* TrackStruct(const VkImageSparseMemoryRequirementsInfo2* value, HandleUnwrapMemory* unwrap_memory);
VkMemoryRequirements2* TrackStruct(const VkMemoryRequirements2* value, HandleUnwrapMemory* unwrap_memory);
VkSparseImageMemoryRequirements2* TrackStruct(const VkSparseImageMemoryRequirements2* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceFeatures2* TrackStruct(const VkPhysicalDeviceFeatures2* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceProperties2* TrackStruct(const VkPhysicalDeviceProperties2* value, HandleUnwrapMemory* unwrap_memory);
VkFormatProperties2* TrackStruct(const VkFormatProperties2* value, HandleUnwrapMemory* unwrap_memory);
VkImageFormatProperties2* TrackStruct(const VkImageFormatProperties2* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceImageFormatInfo2* TrackStruct(const VkPhysicalDeviceImageFormatInfo2* value, HandleUnwrapMemory* unwrap_memory);
VkQueueFamilyProperties2* TrackStruct(const VkQueueFamilyProperties2* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceMemoryProperties2* TrackStruct(const VkPhysicalDeviceMemoryProperties2* value, HandleUnwrapMemory* unwrap_memory);
VkSparseImageFormatProperties2* TrackStruct(const VkSparseImageFormatProperties2* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceSparseImageFormatInfo2* TrackStruct(const VkPhysicalDeviceSparseImageFormatInfo2* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDevicePointClippingProperties* TrackStruct(const VkPhysicalDevicePointClippingProperties* value, HandleUnwrapMemory* unwrap_memory);
VkRenderPassInputAttachmentAspectCreateInfo* TrackStruct(const VkRenderPassInputAttachmentAspectCreateInfo* value, HandleUnwrapMemory* unwrap_memory);
VkImageViewUsageCreateInfo* TrackStruct(const VkImageViewUsageCreateInfo* value, HandleUnwrapMemory* unwrap_memory);
VkPipelineTessellationDomainOriginStateCreateInfo* TrackStruct(const VkPipelineTessellationDomainOriginStateCreateInfo* value, HandleUnwrapMemory* unwrap_memory);
VkRenderPassMultiviewCreateInfo* TrackStruct(const VkRenderPassMultiviewCreateInfo* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceMultiviewFeatures* TrackStruct(const VkPhysicalDeviceMultiviewFeatures* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceMultiviewProperties* TrackStruct(const VkPhysicalDeviceMultiviewProperties* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceVariablePointersFeatures* TrackStruct(const VkPhysicalDeviceVariablePointersFeatures* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceProtectedMemoryFeatures* TrackStruct(const VkPhysicalDeviceProtectedMemoryFeatures* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceProtectedMemoryProperties* TrackStruct(const VkPhysicalDeviceProtectedMemoryProperties* value, HandleUnwrapMemory* unwrap_memory);
VkDeviceQueueInfo2* TrackStruct(const VkDeviceQueueInfo2* value, HandleUnwrapMemory* unwrap_memory);
VkProtectedSubmitInfo* TrackStruct(const VkProtectedSubmitInfo* value, HandleUnwrapMemory* unwrap_memory);
VkSamplerYcbcrConversionCreateInfo* TrackStruct(const VkSamplerYcbcrConversionCreateInfo* value, HandleUnwrapMemory* unwrap_memory);
VkSamplerYcbcrConversionInfo* TrackStruct(const VkSamplerYcbcrConversionInfo* value, HandleUnwrapMemory* unwrap_memory);
VkBindImagePlaneMemoryInfo* TrackStruct(const VkBindImagePlaneMemoryInfo* value, HandleUnwrapMemory* unwrap_memory);
VkImagePlaneMemoryRequirementsInfo* TrackStruct(const VkImagePlaneMemoryRequirementsInfo* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceSamplerYcbcrConversionFeatures* TrackStruct(const VkPhysicalDeviceSamplerYcbcrConversionFeatures* value, HandleUnwrapMemory* unwrap_memory);
VkSamplerYcbcrConversionImageFormatProperties* TrackStruct(const VkSamplerYcbcrConversionImageFormatProperties* value, HandleUnwrapMemory* unwrap_memory);
VkDescriptorUpdateTemplateCreateInfo* TrackStruct(const VkDescriptorUpdateTemplateCreateInfo* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceExternalImageFormatInfo* TrackStruct(const VkPhysicalDeviceExternalImageFormatInfo* value, HandleUnwrapMemory* unwrap_memory);
VkExternalImageFormatProperties* TrackStruct(const VkExternalImageFormatProperties* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceExternalBufferInfo* TrackStruct(const VkPhysicalDeviceExternalBufferInfo* value, HandleUnwrapMemory* unwrap_memory);
VkExternalBufferProperties* TrackStruct(const VkExternalBufferProperties* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceIDProperties* TrackStruct(const VkPhysicalDeviceIDProperties* value, HandleUnwrapMemory* unwrap_memory);
VkExternalMemoryImageCreateInfo* TrackStruct(const VkExternalMemoryImageCreateInfo* value, HandleUnwrapMemory* unwrap_memory);
VkExternalMemoryBufferCreateInfo* TrackStruct(const VkExternalMemoryBufferCreateInfo* value, HandleUnwrapMemory* unwrap_memory);
VkExportMemoryAllocateInfo* TrackStruct(const VkExportMemoryAllocateInfo* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceExternalFenceInfo* TrackStruct(const VkPhysicalDeviceExternalFenceInfo* value, HandleUnwrapMemory* unwrap_memory);
VkExternalFenceProperties* TrackStruct(const VkExternalFenceProperties* value, HandleUnwrapMemory* unwrap_memory);
VkExportFenceCreateInfo* TrackStruct(const VkExportFenceCreateInfo* value, HandleUnwrapMemory* unwrap_memory);
VkExportSemaphoreCreateInfo* TrackStruct(const VkExportSemaphoreCreateInfo* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceExternalSemaphoreInfo* TrackStruct(const VkPhysicalDeviceExternalSemaphoreInfo* value, HandleUnwrapMemory* unwrap_memory);
VkExternalSemaphoreProperties* TrackStruct(const VkExternalSemaphoreProperties* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceMaintenance3Properties* TrackStruct(const VkPhysicalDeviceMaintenance3Properties* value, HandleUnwrapMemory* unwrap_memory);
VkDescriptorSetLayoutSupport* TrackStruct(const VkDescriptorSetLayoutSupport* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceShaderDrawParametersFeatures* TrackStruct(const VkPhysicalDeviceShaderDrawParametersFeatures* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceVulkan11Features* TrackStruct(const VkPhysicalDeviceVulkan11Features* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceVulkan11Properties* TrackStruct(const VkPhysicalDeviceVulkan11Properties* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceVulkan12Features* TrackStruct(const VkPhysicalDeviceVulkan12Features* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceVulkan12Properties* TrackStruct(const VkPhysicalDeviceVulkan12Properties* value, HandleUnwrapMemory* unwrap_memory);
VkImageFormatListCreateInfo* TrackStruct(const VkImageFormatListCreateInfo* value, HandleUnwrapMemory* unwrap_memory);
VkAttachmentDescription2* TrackStruct(const VkAttachmentDescription2* value, HandleUnwrapMemory* unwrap_memory);
VkAttachmentReference2* TrackStruct(const VkAttachmentReference2* value, HandleUnwrapMemory* unwrap_memory);
VkSubpassDescription2* TrackStruct(const VkSubpassDescription2* value, HandleUnwrapMemory* unwrap_memory);
VkSubpassDependency2* TrackStruct(const VkSubpassDependency2* value, HandleUnwrapMemory* unwrap_memory);
VkRenderPassCreateInfo2* TrackStruct(const VkRenderPassCreateInfo2* value, HandleUnwrapMemory* unwrap_memory);
VkSubpassBeginInfo* TrackStruct(const VkSubpassBeginInfo* value, HandleUnwrapMemory* unwrap_memory);
VkSubpassEndInfo* TrackStruct(const VkSubpassEndInfo* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDevice8BitStorageFeatures* TrackStruct(const VkPhysicalDevice8BitStorageFeatures* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceDriverProperties* TrackStruct(const VkPhysicalDeviceDriverProperties* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceShaderAtomicInt64Features* TrackStruct(const VkPhysicalDeviceShaderAtomicInt64Features* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceShaderFloat16Int8Features* TrackStruct(const VkPhysicalDeviceShaderFloat16Int8Features* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceFloatControlsProperties* TrackStruct(const VkPhysicalDeviceFloatControlsProperties* value, HandleUnwrapMemory* unwrap_memory);
VkDescriptorSetLayoutBindingFlagsCreateInfo* TrackStruct(const VkDescriptorSetLayoutBindingFlagsCreateInfo* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceDescriptorIndexingFeatures* TrackStruct(const VkPhysicalDeviceDescriptorIndexingFeatures* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceDescriptorIndexingProperties* TrackStruct(const VkPhysicalDeviceDescriptorIndexingProperties* value, HandleUnwrapMemory* unwrap_memory);
VkDescriptorSetVariableDescriptorCountAllocateInfo* TrackStruct(const VkDescriptorSetVariableDescriptorCountAllocateInfo* value, HandleUnwrapMemory* unwrap_memory);
VkDescriptorSetVariableDescriptorCountLayoutSupport* TrackStruct(const VkDescriptorSetVariableDescriptorCountLayoutSupport* value, HandleUnwrapMemory* unwrap_memory);
VkSubpassDescriptionDepthStencilResolve* TrackStruct(const VkSubpassDescriptionDepthStencilResolve* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceDepthStencilResolveProperties* TrackStruct(const VkPhysicalDeviceDepthStencilResolveProperties* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceScalarBlockLayoutFeatures* TrackStruct(const VkPhysicalDeviceScalarBlockLayoutFeatures* value, HandleUnwrapMemory* unwrap_memory);
VkImageStencilUsageCreateInfo* TrackStruct(const VkImageStencilUsageCreateInfo* value, HandleUnwrapMemory* unwrap_memory);
VkSamplerReductionModeCreateInfo* TrackStruct(const VkSamplerReductionModeCreateInfo* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceSamplerFilterMinmaxProperties* TrackStruct(const VkPhysicalDeviceSamplerFilterMinmaxProperties* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceVulkanMemoryModelFeatures* TrackStruct(const VkPhysicalDeviceVulkanMemoryModelFeatures* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceImagelessFramebufferFeatures* TrackStruct(const VkPhysicalDeviceImagelessFramebufferFeatures* value, HandleUnwrapMemory* unwrap_memory);
VkFramebufferAttachmentImageInfo* TrackStruct(const VkFramebufferAttachmentImageInfo* value, HandleUnwrapMemory* unwrap_memory);
VkFramebufferAttachmentsCreateInfo* TrackStruct(const VkFramebufferAttachmentsCreateInfo* value, HandleUnwrapMemory* unwrap_memory);
VkRenderPassAttachmentBeginInfo* TrackStruct(const VkRenderPassAttachmentBeginInfo* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceUniformBufferStandardLayoutFeatures* TrackStruct(const VkPhysicalDeviceUniformBufferStandardLayoutFeatures* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures* TrackStruct(const VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures* TrackStruct(const VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures* value, HandleUnwrapMemory* unwrap_memory);
VkAttachmentReferenceStencilLayout* TrackStruct(const VkAttachmentReferenceStencilLayout* value, HandleUnwrapMemory* unwrap_memory);
VkAttachmentDescriptionStencilLayout* TrackStruct(const VkAttachmentDescriptionStencilLayout* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceHostQueryResetFeatures* TrackStruct(const VkPhysicalDeviceHostQueryResetFeatures* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceTimelineSemaphoreFeatures* TrackStruct(const VkPhysicalDeviceTimelineSemaphoreFeatures* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceTimelineSemaphoreProperties* TrackStruct(const VkPhysicalDeviceTimelineSemaphoreProperties* value, HandleUnwrapMemory* unwrap_memory);
VkSemaphoreTypeCreateInfo* TrackStruct(const VkSemaphoreTypeCreateInfo* value, HandleUnwrapMemory* unwrap_memory);
VkTimelineSemaphoreSubmitInfo* TrackStruct(const VkTimelineSemaphoreSubmitInfo* value, HandleUnwrapMemory* unwrap_memory);
VkSemaphoreWaitInfo* TrackStruct(const VkSemaphoreWaitInfo* value, HandleUnwrapMemory* unwrap_memory);
VkSemaphoreSignalInfo* TrackStruct(const VkSemaphoreSignalInfo* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceBufferDeviceAddressFeatures* TrackStruct(const VkPhysicalDeviceBufferDeviceAddressFeatures* value, HandleUnwrapMemory* unwrap_memory);
VkBufferDeviceAddressInfo* TrackStruct(const VkBufferDeviceAddressInfo* value, HandleUnwrapMemory* unwrap_memory);
VkBufferOpaqueCaptureAddressCreateInfo* TrackStruct(const VkBufferOpaqueCaptureAddressCreateInfo* value, HandleUnwrapMemory* unwrap_memory);
VkMemoryOpaqueCaptureAddressAllocateInfo* TrackStruct(const VkMemoryOpaqueCaptureAddressAllocateInfo* value, HandleUnwrapMemory* unwrap_memory);
VkDeviceMemoryOpaqueCaptureAddressInfo* TrackStruct(const VkDeviceMemoryOpaqueCaptureAddressInfo* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceVulkan13Features* TrackStruct(const VkPhysicalDeviceVulkan13Features* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceVulkan13Properties* TrackStruct(const VkPhysicalDeviceVulkan13Properties* value, HandleUnwrapMemory* unwrap_memory);
VkPipelineCreationFeedbackCreateInfo* TrackStruct(const VkPipelineCreationFeedbackCreateInfo* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceShaderTerminateInvocationFeatures* TrackStruct(const VkPhysicalDeviceShaderTerminateInvocationFeatures* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceToolProperties* TrackStruct(const VkPhysicalDeviceToolProperties* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures* TrackStruct(const VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDevicePrivateDataFeatures* TrackStruct(const VkPhysicalDevicePrivateDataFeatures* value, HandleUnwrapMemory* unwrap_memory);
VkDevicePrivateDataCreateInfo* TrackStruct(const VkDevicePrivateDataCreateInfo* value, HandleUnwrapMemory* unwrap_memory);
VkPrivateDataSlotCreateInfo* TrackStruct(const VkPrivateDataSlotCreateInfo* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDevicePipelineCreationCacheControlFeatures* TrackStruct(const VkPhysicalDevicePipelineCreationCacheControlFeatures* value, HandleUnwrapMemory* unwrap_memory);
VkMemoryBarrier2* TrackStruct(const VkMemoryBarrier2* value, HandleUnwrapMemory* unwrap_memory);
VkBufferMemoryBarrier2* TrackStruct(const VkBufferMemoryBarrier2* value, HandleUnwrapMemory* unwrap_memory);
VkImageMemoryBarrier2* TrackStruct(const VkImageMemoryBarrier2* value, HandleUnwrapMemory* unwrap_memory);
VkDependencyInfo* TrackStruct(const VkDependencyInfo* value, HandleUnwrapMemory* unwrap_memory);
VkSemaphoreSubmitInfo* TrackStruct(const VkSemaphoreSubmitInfo* value, HandleUnwrapMemory* unwrap_memory);
VkCommandBufferSubmitInfo* TrackStruct(const VkCommandBufferSubmitInfo* value, HandleUnwrapMemory* unwrap_memory);
VkSubmitInfo2* TrackStruct(const VkSubmitInfo2* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceSynchronization2Features* TrackStruct(const VkPhysicalDeviceSynchronization2Features* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures* TrackStruct(const VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceImageRobustnessFeatures* TrackStruct(const VkPhysicalDeviceImageRobustnessFeatures* value, HandleUnwrapMemory* unwrap_memory);
VkBufferCopy2* TrackStruct(const VkBufferCopy2* value, HandleUnwrapMemory* unwrap_memory);
VkCopyBufferInfo2* TrackStruct(const VkCopyBufferInfo2* value, HandleUnwrapMemory* unwrap_memory);
VkImageCopy2* TrackStruct(const VkImageCopy2* value, HandleUnwrapMemory* unwrap_memory);
VkCopyImageInfo2* TrackStruct(const VkCopyImageInfo2* value, HandleUnwrapMemory* unwrap_memory);
VkBufferImageCopy2* TrackStruct(const VkBufferImageCopy2* value, HandleUnwrapMemory* unwrap_memory);
VkCopyBufferToImageInfo2* TrackStruct(const VkCopyBufferToImageInfo2* value, HandleUnwrapMemory* unwrap_memory);
VkCopyImageToBufferInfo2* TrackStruct(const VkCopyImageToBufferInfo2* value, HandleUnwrapMemory* unwrap_memory);
VkImageBlit2* TrackStruct(const VkImageBlit2* value, HandleUnwrapMemory* unwrap_memory);
VkBlitImageInfo2* TrackStruct(const VkBlitImageInfo2* value, HandleUnwrapMemory* unwrap_memory);
VkImageResolve2* TrackStruct(const VkImageResolve2* value, HandleUnwrapMemory* unwrap_memory);
VkResolveImageInfo2* TrackStruct(const VkResolveImageInfo2* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceSubgroupSizeControlFeatures* TrackStruct(const VkPhysicalDeviceSubgroupSizeControlFeatures* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceSubgroupSizeControlProperties* TrackStruct(const VkPhysicalDeviceSubgroupSizeControlProperties* value, HandleUnwrapMemory* unwrap_memory);
VkPipelineShaderStageRequiredSubgroupSizeCreateInfo* TrackStruct(const VkPipelineShaderStageRequiredSubgroupSizeCreateInfo* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceInlineUniformBlockFeatures* TrackStruct(const VkPhysicalDeviceInlineUniformBlockFeatures* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceInlineUniformBlockProperties* TrackStruct(const VkPhysicalDeviceInlineUniformBlockProperties* value, HandleUnwrapMemory* unwrap_memory);
VkWriteDescriptorSetInlineUniformBlock* TrackStruct(const VkWriteDescriptorSetInlineUniformBlock* value, HandleUnwrapMemory* unwrap_memory);
VkDescriptorPoolInlineUniformBlockCreateInfo* TrackStruct(const VkDescriptorPoolInlineUniformBlockCreateInfo* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceTextureCompressionASTCHDRFeatures* TrackStruct(const VkPhysicalDeviceTextureCompressionASTCHDRFeatures* value, HandleUnwrapMemory* unwrap_memory);
VkRenderingAttachmentInfo* TrackStruct(const VkRenderingAttachmentInfo* value, HandleUnwrapMemory* unwrap_memory);
VkRenderingInfo* TrackStruct(const VkRenderingInfo* value, HandleUnwrapMemory* unwrap_memory);
VkPipelineRenderingCreateInfo* TrackStruct(const VkPipelineRenderingCreateInfo* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceDynamicRenderingFeatures* TrackStruct(const VkPhysicalDeviceDynamicRenderingFeatures* value, HandleUnwrapMemory* unwrap_memory);
VkCommandBufferInheritanceRenderingInfo* TrackStruct(const VkCommandBufferInheritanceRenderingInfo* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceShaderIntegerDotProductFeatures* TrackStruct(const VkPhysicalDeviceShaderIntegerDotProductFeatures* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceShaderIntegerDotProductProperties* TrackStruct(const VkPhysicalDeviceShaderIntegerDotProductProperties* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceTexelBufferAlignmentProperties* TrackStruct(const VkPhysicalDeviceTexelBufferAlignmentProperties* value, HandleUnwrapMemory* unwrap_memory);
VkFormatProperties3* TrackStruct(const VkFormatProperties3* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceMaintenance4Features* TrackStruct(const VkPhysicalDeviceMaintenance4Features* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceMaintenance4Properties* TrackStruct(const VkPhysicalDeviceMaintenance4Properties* value, HandleUnwrapMemory* unwrap_memory);
VkDeviceBufferMemoryRequirements* TrackStruct(const VkDeviceBufferMemoryRequirements* value, HandleUnwrapMemory* unwrap_memory);
VkDeviceImageMemoryRequirements* TrackStruct(const VkDeviceImageMemoryRequirements* value, HandleUnwrapMemory* unwrap_memory);
VkSwapchainCreateInfoKHR* TrackStruct(const VkSwapchainCreateInfoKHR* value, HandleUnwrapMemory* unwrap_memory);
VkPresentInfoKHR* TrackStruct(const VkPresentInfoKHR* value, HandleUnwrapMemory* unwrap_memory);
VkImageSwapchainCreateInfoKHR* TrackStruct(const VkImageSwapchainCreateInfoKHR* value, HandleUnwrapMemory* unwrap_memory);
VkBindImageMemorySwapchainInfoKHR* TrackStruct(const VkBindImageMemorySwapchainInfoKHR* value, HandleUnwrapMemory* unwrap_memory);
VkAcquireNextImageInfoKHR* TrackStruct(const VkAcquireNextImageInfoKHR* value, HandleUnwrapMemory* unwrap_memory);
VkDeviceGroupPresentCapabilitiesKHR* TrackStruct(const VkDeviceGroupPresentCapabilitiesKHR* value, HandleUnwrapMemory* unwrap_memory);
VkDeviceGroupPresentInfoKHR* TrackStruct(const VkDeviceGroupPresentInfoKHR* value, HandleUnwrapMemory* unwrap_memory);
VkDeviceGroupSwapchainCreateInfoKHR* TrackStruct(const VkDeviceGroupSwapchainCreateInfoKHR* value, HandleUnwrapMemory* unwrap_memory);
VkDisplayModeCreateInfoKHR* TrackStruct(const VkDisplayModeCreateInfoKHR* value, HandleUnwrapMemory* unwrap_memory);
VkDisplaySurfaceCreateInfoKHR* TrackStruct(const VkDisplaySurfaceCreateInfoKHR* value, HandleUnwrapMemory* unwrap_memory);
VkDisplayPresentInfoKHR* TrackStruct(const VkDisplayPresentInfoKHR* value, HandleUnwrapMemory* unwrap_memory);
VkXlibSurfaceCreateInfoKHR* TrackStruct(const VkXlibSurfaceCreateInfoKHR* value, HandleUnwrapMemory* unwrap_memory);
VkXcbSurfaceCreateInfoKHR* TrackStruct(const VkXcbSurfaceCreateInfoKHR* value, HandleUnwrapMemory* unwrap_memory);
VkWaylandSurfaceCreateInfoKHR* TrackStruct(const VkWaylandSurfaceCreateInfoKHR* value, HandleUnwrapMemory* unwrap_memory);
VkAndroidSurfaceCreateInfoKHR* TrackStruct(const VkAndroidSurfaceCreateInfoKHR* value, HandleUnwrapMemory* unwrap_memory);
VkWin32SurfaceCreateInfoKHR* TrackStruct(const VkWin32SurfaceCreateInfoKHR* value, HandleUnwrapMemory* unwrap_memory);
VkQueueFamilyQueryResultStatusPropertiesKHR* TrackStruct(const VkQueueFamilyQueryResultStatusPropertiesKHR* value, HandleUnwrapMemory* unwrap_memory);
VkQueueFamilyVideoPropertiesKHR* TrackStruct(const VkQueueFamilyVideoPropertiesKHR* value, HandleUnwrapMemory* unwrap_memory);
VkVideoProfileInfoKHR* TrackStruct(const VkVideoProfileInfoKHR* value, HandleUnwrapMemory* unwrap_memory);
VkVideoProfileListInfoKHR* TrackStruct(const VkVideoProfileListInfoKHR* value, HandleUnwrapMemory* unwrap_memory);
VkVideoCapabilitiesKHR* TrackStruct(const VkVideoCapabilitiesKHR* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceVideoFormatInfoKHR* TrackStruct(const VkPhysicalDeviceVideoFormatInfoKHR* value, HandleUnwrapMemory* unwrap_memory);
VkVideoFormatPropertiesKHR* TrackStruct(const VkVideoFormatPropertiesKHR* value, HandleUnwrapMemory* unwrap_memory);
VkVideoPictureResourceInfoKHR* TrackStruct(const VkVideoPictureResourceInfoKHR* value, HandleUnwrapMemory* unwrap_memory);
VkVideoReferenceSlotInfoKHR* TrackStruct(const VkVideoReferenceSlotInfoKHR* value, HandleUnwrapMemory* unwrap_memory);
VkVideoSessionMemoryRequirementsKHR* TrackStruct(const VkVideoSessionMemoryRequirementsKHR* value, HandleUnwrapMemory* unwrap_memory);
VkBindVideoSessionMemoryInfoKHR* TrackStruct(const VkBindVideoSessionMemoryInfoKHR* value, HandleUnwrapMemory* unwrap_memory);
VkVideoSessionCreateInfoKHR* TrackStruct(const VkVideoSessionCreateInfoKHR* value, HandleUnwrapMemory* unwrap_memory);
VkVideoSessionParametersCreateInfoKHR* TrackStruct(const VkVideoSessionParametersCreateInfoKHR* value, HandleUnwrapMemory* unwrap_memory);
VkVideoSessionParametersUpdateInfoKHR* TrackStruct(const VkVideoSessionParametersUpdateInfoKHR* value, HandleUnwrapMemory* unwrap_memory);
VkVideoBeginCodingInfoKHR* TrackStruct(const VkVideoBeginCodingInfoKHR* value, HandleUnwrapMemory* unwrap_memory);
VkVideoEndCodingInfoKHR* TrackStruct(const VkVideoEndCodingInfoKHR* value, HandleUnwrapMemory* unwrap_memory);
VkVideoCodingControlInfoKHR* TrackStruct(const VkVideoCodingControlInfoKHR* value, HandleUnwrapMemory* unwrap_memory);
VkVideoDecodeCapabilitiesKHR* TrackStruct(const VkVideoDecodeCapabilitiesKHR* value, HandleUnwrapMemory* unwrap_memory);
VkVideoDecodeUsageInfoKHR* TrackStruct(const VkVideoDecodeUsageInfoKHR* value, HandleUnwrapMemory* unwrap_memory);
VkVideoDecodeInfoKHR* TrackStruct(const VkVideoDecodeInfoKHR* value, HandleUnwrapMemory* unwrap_memory);
VkVideoEncodeH264CapabilitiesKHR* TrackStruct(const VkVideoEncodeH264CapabilitiesKHR* value, HandleUnwrapMemory* unwrap_memory);
VkVideoEncodeH264QualityLevelPropertiesKHR* TrackStruct(const VkVideoEncodeH264QualityLevelPropertiesKHR* value, HandleUnwrapMemory* unwrap_memory);
VkVideoEncodeH264SessionCreateInfoKHR* TrackStruct(const VkVideoEncodeH264SessionCreateInfoKHR* value, HandleUnwrapMemory* unwrap_memory);
VkVideoEncodeH264SessionParametersAddInfoKHR* TrackStruct(const VkVideoEncodeH264SessionParametersAddInfoKHR* value, HandleUnwrapMemory* unwrap_memory);
VkVideoEncodeH264SessionParametersCreateInfoKHR* TrackStruct(const VkVideoEncodeH264SessionParametersCreateInfoKHR* value, HandleUnwrapMemory* unwrap_memory);
VkVideoEncodeH264SessionParametersGetInfoKHR* TrackStruct(const VkVideoEncodeH264SessionParametersGetInfoKHR* value, HandleUnwrapMemory* unwrap_memory);
VkVideoEncodeH264SessionParametersFeedbackInfoKHR* TrackStruct(const VkVideoEncodeH264SessionParametersFeedbackInfoKHR* value, HandleUnwrapMemory* unwrap_memory);
VkVideoEncodeH264NaluSliceInfoKHR* TrackStruct(const VkVideoEncodeH264NaluSliceInfoKHR* value, HandleUnwrapMemory* unwrap_memory);
VkVideoEncodeH264PictureInfoKHR* TrackStruct(const VkVideoEncodeH264PictureInfoKHR* value, HandleUnwrapMemory* unwrap_memory);
VkVideoEncodeH264DpbSlotInfoKHR* TrackStruct(const VkVideoEncodeH264DpbSlotInfoKHR* value, HandleUnwrapMemory* unwrap_memory);
VkVideoEncodeH264ProfileInfoKHR* TrackStruct(const VkVideoEncodeH264ProfileInfoKHR* value, HandleUnwrapMemory* unwrap_memory);
VkVideoEncodeH264RateControlInfoKHR* TrackStruct(const VkVideoEncodeH264RateControlInfoKHR* value, HandleUnwrapMemory* unwrap_memory);
VkVideoEncodeH264RateControlLayerInfoKHR* TrackStruct(const VkVideoEncodeH264RateControlLayerInfoKHR* value, HandleUnwrapMemory* unwrap_memory);
VkVideoEncodeH264GopRemainingFrameInfoKHR* TrackStruct(const VkVideoEncodeH264GopRemainingFrameInfoKHR* value, HandleUnwrapMemory* unwrap_memory);
VkVideoEncodeH265CapabilitiesKHR* TrackStruct(const VkVideoEncodeH265CapabilitiesKHR* value, HandleUnwrapMemory* unwrap_memory);
VkVideoEncodeH265SessionCreateInfoKHR* TrackStruct(const VkVideoEncodeH265SessionCreateInfoKHR* value, HandleUnwrapMemory* unwrap_memory);
VkVideoEncodeH265QualityLevelPropertiesKHR* TrackStruct(const VkVideoEncodeH265QualityLevelPropertiesKHR* value, HandleUnwrapMemory* unwrap_memory);
VkVideoEncodeH265SessionParametersAddInfoKHR* TrackStruct(const VkVideoEncodeH265SessionParametersAddInfoKHR* value, HandleUnwrapMemory* unwrap_memory);
VkVideoEncodeH265SessionParametersCreateInfoKHR* TrackStruct(const VkVideoEncodeH265SessionParametersCreateInfoKHR* value, HandleUnwrapMemory* unwrap_memory);
VkVideoEncodeH265SessionParametersGetInfoKHR* TrackStruct(const VkVideoEncodeH265SessionParametersGetInfoKHR* value, HandleUnwrapMemory* unwrap_memory);
VkVideoEncodeH265SessionParametersFeedbackInfoKHR* TrackStruct(const VkVideoEncodeH265SessionParametersFeedbackInfoKHR* value, HandleUnwrapMemory* unwrap_memory);
VkVideoEncodeH265NaluSliceSegmentInfoKHR* TrackStruct(const VkVideoEncodeH265NaluSliceSegmentInfoKHR* value, HandleUnwrapMemory* unwrap_memory);
VkVideoEncodeH265PictureInfoKHR* TrackStruct(const VkVideoEncodeH265PictureInfoKHR* value, HandleUnwrapMemory* unwrap_memory);
VkVideoEncodeH265DpbSlotInfoKHR* TrackStruct(const VkVideoEncodeH265DpbSlotInfoKHR* value, HandleUnwrapMemory* unwrap_memory);
VkVideoEncodeH265ProfileInfoKHR* TrackStruct(const VkVideoEncodeH265ProfileInfoKHR* value, HandleUnwrapMemory* unwrap_memory);
VkVideoEncodeH265RateControlInfoKHR* TrackStruct(const VkVideoEncodeH265RateControlInfoKHR* value, HandleUnwrapMemory* unwrap_memory);
VkVideoEncodeH265RateControlLayerInfoKHR* TrackStruct(const VkVideoEncodeH265RateControlLayerInfoKHR* value, HandleUnwrapMemory* unwrap_memory);
VkVideoEncodeH265GopRemainingFrameInfoKHR* TrackStruct(const VkVideoEncodeH265GopRemainingFrameInfoKHR* value, HandleUnwrapMemory* unwrap_memory);
VkVideoDecodeH264ProfileInfoKHR* TrackStruct(const VkVideoDecodeH264ProfileInfoKHR* value, HandleUnwrapMemory* unwrap_memory);
VkVideoDecodeH264CapabilitiesKHR* TrackStruct(const VkVideoDecodeH264CapabilitiesKHR* value, HandleUnwrapMemory* unwrap_memory);
VkVideoDecodeH264SessionParametersAddInfoKHR* TrackStruct(const VkVideoDecodeH264SessionParametersAddInfoKHR* value, HandleUnwrapMemory* unwrap_memory);
VkVideoDecodeH264SessionParametersCreateInfoKHR* TrackStruct(const VkVideoDecodeH264SessionParametersCreateInfoKHR* value, HandleUnwrapMemory* unwrap_memory);
VkVideoDecodeH264PictureInfoKHR* TrackStruct(const VkVideoDecodeH264PictureInfoKHR* value, HandleUnwrapMemory* unwrap_memory);
VkVideoDecodeH264DpbSlotInfoKHR* TrackStruct(const VkVideoDecodeH264DpbSlotInfoKHR* value, HandleUnwrapMemory* unwrap_memory);
VkRenderingFragmentShadingRateAttachmentInfoKHR* TrackStruct(const VkRenderingFragmentShadingRateAttachmentInfoKHR* value, HandleUnwrapMemory* unwrap_memory);
VkRenderingFragmentDensityMapAttachmentInfoEXT* TrackStruct(const VkRenderingFragmentDensityMapAttachmentInfoEXT* value, HandleUnwrapMemory* unwrap_memory);
VkAttachmentSampleCountInfoAMD* TrackStruct(const VkAttachmentSampleCountInfoAMD* value, HandleUnwrapMemory* unwrap_memory);
VkMultiviewPerViewAttributesInfoNVX* TrackStruct(const VkMultiviewPerViewAttributesInfoNVX* value, HandleUnwrapMemory* unwrap_memory);
VkImportMemoryWin32HandleInfoKHR* TrackStruct(const VkImportMemoryWin32HandleInfoKHR* value, HandleUnwrapMemory* unwrap_memory);
VkExportMemoryWin32HandleInfoKHR* TrackStruct(const VkExportMemoryWin32HandleInfoKHR* value, HandleUnwrapMemory* unwrap_memory);
VkMemoryWin32HandlePropertiesKHR* TrackStruct(const VkMemoryWin32HandlePropertiesKHR* value, HandleUnwrapMemory* unwrap_memory);
VkMemoryGetWin32HandleInfoKHR* TrackStruct(const VkMemoryGetWin32HandleInfoKHR* value, HandleUnwrapMemory* unwrap_memory);
VkImportMemoryFdInfoKHR* TrackStruct(const VkImportMemoryFdInfoKHR* value, HandleUnwrapMemory* unwrap_memory);
VkMemoryFdPropertiesKHR* TrackStruct(const VkMemoryFdPropertiesKHR* value, HandleUnwrapMemory* unwrap_memory);
VkMemoryGetFdInfoKHR* TrackStruct(const VkMemoryGetFdInfoKHR* value, HandleUnwrapMemory* unwrap_memory);
VkWin32KeyedMutexAcquireReleaseInfoKHR* TrackStruct(const VkWin32KeyedMutexAcquireReleaseInfoKHR* value, HandleUnwrapMemory* unwrap_memory);
VkImportSemaphoreWin32HandleInfoKHR* TrackStruct(const VkImportSemaphoreWin32HandleInfoKHR* value, HandleUnwrapMemory* unwrap_memory);
VkExportSemaphoreWin32HandleInfoKHR* TrackStruct(const VkExportSemaphoreWin32HandleInfoKHR* value, HandleUnwrapMemory* unwrap_memory);
VkD3D12FenceSubmitInfoKHR* TrackStruct(const VkD3D12FenceSubmitInfoKHR* value, HandleUnwrapMemory* unwrap_memory);
VkSemaphoreGetWin32HandleInfoKHR* TrackStruct(const VkSemaphoreGetWin32HandleInfoKHR* value, HandleUnwrapMemory* unwrap_memory);
VkImportSemaphoreFdInfoKHR* TrackStruct(const VkImportSemaphoreFdInfoKHR* value, HandleUnwrapMemory* unwrap_memory);
VkSemaphoreGetFdInfoKHR* TrackStruct(const VkSemaphoreGetFdInfoKHR* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDevicePushDescriptorPropertiesKHR* TrackStruct(const VkPhysicalDevicePushDescriptorPropertiesKHR* value, HandleUnwrapMemory* unwrap_memory);
VkPresentRegionsKHR* TrackStruct(const VkPresentRegionsKHR* value, HandleUnwrapMemory* unwrap_memory);
VkSharedPresentSurfaceCapabilitiesKHR* TrackStruct(const VkSharedPresentSurfaceCapabilitiesKHR* value, HandleUnwrapMemory* unwrap_memory);
VkImportFenceWin32HandleInfoKHR* TrackStruct(const VkImportFenceWin32HandleInfoKHR* value, HandleUnwrapMemory* unwrap_memory);
VkExportFenceWin32HandleInfoKHR* TrackStruct(const VkExportFenceWin32HandleInfoKHR* value, HandleUnwrapMemory* unwrap_memory);
VkFenceGetWin32HandleInfoKHR* TrackStruct(const VkFenceGetWin32HandleInfoKHR* value, HandleUnwrapMemory* unwrap_memory);
VkImportFenceFdInfoKHR* TrackStruct(const VkImportFenceFdInfoKHR* value, HandleUnwrapMemory* unwrap_memory);
VkFenceGetFdInfoKHR* TrackStruct(const VkFenceGetFdInfoKHR* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDevicePerformanceQueryFeaturesKHR* TrackStruct(const VkPhysicalDevicePerformanceQueryFeaturesKHR* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDevicePerformanceQueryPropertiesKHR* TrackStruct(const VkPhysicalDevicePerformanceQueryPropertiesKHR* value, HandleUnwrapMemory* unwrap_memory);
VkPerformanceCounterKHR* TrackStruct(const VkPerformanceCounterKHR* value, HandleUnwrapMemory* unwrap_memory);
VkPerformanceCounterDescriptionKHR* TrackStruct(const VkPerformanceCounterDescriptionKHR* value, HandleUnwrapMemory* unwrap_memory);
VkQueryPoolPerformanceCreateInfoKHR* TrackStruct(const VkQueryPoolPerformanceCreateInfoKHR* value, HandleUnwrapMemory* unwrap_memory);
VkAcquireProfilingLockInfoKHR* TrackStruct(const VkAcquireProfilingLockInfoKHR* value, HandleUnwrapMemory* unwrap_memory);
VkPerformanceQuerySubmitInfoKHR* TrackStruct(const VkPerformanceQuerySubmitInfoKHR* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceSurfaceInfo2KHR* TrackStruct(const VkPhysicalDeviceSurfaceInfo2KHR* value, HandleUnwrapMemory* unwrap_memory);
VkSurfaceCapabilities2KHR* TrackStruct(const VkSurfaceCapabilities2KHR* value, HandleUnwrapMemory* unwrap_memory);
VkSurfaceFormat2KHR* TrackStruct(const VkSurfaceFormat2KHR* value, HandleUnwrapMemory* unwrap_memory);
VkDisplayProperties2KHR* TrackStruct(const VkDisplayProperties2KHR* value, HandleUnwrapMemory* unwrap_memory);
VkDisplayPlaneProperties2KHR* TrackStruct(const VkDisplayPlaneProperties2KHR* value, HandleUnwrapMemory* unwrap_memory);
VkDisplayModeProperties2KHR* TrackStruct(const VkDisplayModeProperties2KHR* value, HandleUnwrapMemory* unwrap_memory);
VkDisplayPlaneInfo2KHR* TrackStruct(const VkDisplayPlaneInfo2KHR* value, HandleUnwrapMemory* unwrap_memory);
VkDisplayPlaneCapabilities2KHR* TrackStruct(const VkDisplayPlaneCapabilities2KHR* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDevicePortabilitySubsetFeaturesKHR* TrackStruct(const VkPhysicalDevicePortabilitySubsetFeaturesKHR* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDevicePortabilitySubsetPropertiesKHR* TrackStruct(const VkPhysicalDevicePortabilitySubsetPropertiesKHR* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceShaderClockFeaturesKHR* TrackStruct(const VkPhysicalDeviceShaderClockFeaturesKHR* value, HandleUnwrapMemory* unwrap_memory);
VkVideoDecodeH265ProfileInfoKHR* TrackStruct(const VkVideoDecodeH265ProfileInfoKHR* value, HandleUnwrapMemory* unwrap_memory);
VkVideoDecodeH265CapabilitiesKHR* TrackStruct(const VkVideoDecodeH265CapabilitiesKHR* value, HandleUnwrapMemory* unwrap_memory);
VkVideoDecodeH265SessionParametersAddInfoKHR* TrackStruct(const VkVideoDecodeH265SessionParametersAddInfoKHR* value, HandleUnwrapMemory* unwrap_memory);
VkVideoDecodeH265SessionParametersCreateInfoKHR* TrackStruct(const VkVideoDecodeH265SessionParametersCreateInfoKHR* value, HandleUnwrapMemory* unwrap_memory);
VkVideoDecodeH265PictureInfoKHR* TrackStruct(const VkVideoDecodeH265PictureInfoKHR* value, HandleUnwrapMemory* unwrap_memory);
VkVideoDecodeH265DpbSlotInfoKHR* TrackStruct(const VkVideoDecodeH265DpbSlotInfoKHR* value, HandleUnwrapMemory* unwrap_memory);
VkDeviceQueueGlobalPriorityCreateInfoKHR* TrackStruct(const VkDeviceQueueGlobalPriorityCreateInfoKHR* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceGlobalPriorityQueryFeaturesKHR* TrackStruct(const VkPhysicalDeviceGlobalPriorityQueryFeaturesKHR* value, HandleUnwrapMemory* unwrap_memory);
VkQueueFamilyGlobalPriorityPropertiesKHR* TrackStruct(const VkQueueFamilyGlobalPriorityPropertiesKHR* value, HandleUnwrapMemory* unwrap_memory);
VkFragmentShadingRateAttachmentInfoKHR* TrackStruct(const VkFragmentShadingRateAttachmentInfoKHR* value, HandleUnwrapMemory* unwrap_memory);
VkPipelineFragmentShadingRateStateCreateInfoKHR* TrackStruct(const VkPipelineFragmentShadingRateStateCreateInfoKHR* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceFragmentShadingRateFeaturesKHR* TrackStruct(const VkPhysicalDeviceFragmentShadingRateFeaturesKHR* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceFragmentShadingRatePropertiesKHR* TrackStruct(const VkPhysicalDeviceFragmentShadingRatePropertiesKHR* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceFragmentShadingRateKHR* TrackStruct(const VkPhysicalDeviceFragmentShadingRateKHR* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceDynamicRenderingLocalReadFeaturesKHR* TrackStruct(const VkPhysicalDeviceDynamicRenderingLocalReadFeaturesKHR* value, HandleUnwrapMemory* unwrap_memory);
VkRenderingAttachmentLocationInfoKHR* TrackStruct(const VkRenderingAttachmentLocationInfoKHR* value, HandleUnwrapMemory* unwrap_memory);
VkRenderingInputAttachmentIndexInfoKHR* TrackStruct(const VkRenderingInputAttachmentIndexInfoKHR* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceShaderQuadControlFeaturesKHR* TrackStruct(const VkPhysicalDeviceShaderQuadControlFeaturesKHR* value, HandleUnwrapMemory* unwrap_memory);
VkSurfaceProtectedCapabilitiesKHR* TrackStruct(const VkSurfaceProtectedCapabilitiesKHR* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDevicePresentWaitFeaturesKHR* TrackStruct(const VkPhysicalDevicePresentWaitFeaturesKHR* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDevicePipelineExecutablePropertiesFeaturesKHR* TrackStruct(const VkPhysicalDevicePipelineExecutablePropertiesFeaturesKHR* value, HandleUnwrapMemory* unwrap_memory);
VkPipelineInfoKHR* TrackStruct(const VkPipelineInfoKHR* value, HandleUnwrapMemory* unwrap_memory);
VkPipelineExecutablePropertiesKHR* TrackStruct(const VkPipelineExecutablePropertiesKHR* value, HandleUnwrapMemory* unwrap_memory);
VkPipelineExecutableInfoKHR* TrackStruct(const VkPipelineExecutableInfoKHR* value, HandleUnwrapMemory* unwrap_memory);
VkPipelineExecutableStatisticKHR* TrackStruct(const VkPipelineExecutableStatisticKHR* value, HandleUnwrapMemory* unwrap_memory);
VkPipelineExecutableInternalRepresentationKHR* TrackStruct(const VkPipelineExecutableInternalRepresentationKHR* value, HandleUnwrapMemory* unwrap_memory);
VkMemoryMapInfoKHR* TrackStruct(const VkMemoryMapInfoKHR* value, HandleUnwrapMemory* unwrap_memory);
VkMemoryUnmapInfoKHR* TrackStruct(const VkMemoryUnmapInfoKHR* value, HandleUnwrapMemory* unwrap_memory);
VkPipelineLibraryCreateInfoKHR* TrackStruct(const VkPipelineLibraryCreateInfoKHR* value, HandleUnwrapMemory* unwrap_memory);
VkPresentIdKHR* TrackStruct(const VkPresentIdKHR* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDevicePresentIdFeaturesKHR* TrackStruct(const VkPhysicalDevicePresentIdFeaturesKHR* value, HandleUnwrapMemory* unwrap_memory);
VkVideoEncodeInfoKHR* TrackStruct(const VkVideoEncodeInfoKHR* value, HandleUnwrapMemory* unwrap_memory);
VkVideoEncodeCapabilitiesKHR* TrackStruct(const VkVideoEncodeCapabilitiesKHR* value, HandleUnwrapMemory* unwrap_memory);
VkQueryPoolVideoEncodeFeedbackCreateInfoKHR* TrackStruct(const VkQueryPoolVideoEncodeFeedbackCreateInfoKHR* value, HandleUnwrapMemory* unwrap_memory);
VkVideoEncodeUsageInfoKHR* TrackStruct(const VkVideoEncodeUsageInfoKHR* value, HandleUnwrapMemory* unwrap_memory);
VkVideoEncodeRateControlLayerInfoKHR* TrackStruct(const VkVideoEncodeRateControlLayerInfoKHR* value, HandleUnwrapMemory* unwrap_memory);
VkVideoEncodeRateControlInfoKHR* TrackStruct(const VkVideoEncodeRateControlInfoKHR* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceVideoEncodeQualityLevelInfoKHR* TrackStruct(const VkPhysicalDeviceVideoEncodeQualityLevelInfoKHR* value, HandleUnwrapMemory* unwrap_memory);
VkVideoEncodeQualityLevelPropertiesKHR* TrackStruct(const VkVideoEncodeQualityLevelPropertiesKHR* value, HandleUnwrapMemory* unwrap_memory);
VkVideoEncodeQualityLevelInfoKHR* TrackStruct(const VkVideoEncodeQualityLevelInfoKHR* value, HandleUnwrapMemory* unwrap_memory);
VkVideoEncodeSessionParametersGetInfoKHR* TrackStruct(const VkVideoEncodeSessionParametersGetInfoKHR* value, HandleUnwrapMemory* unwrap_memory);
VkVideoEncodeSessionParametersFeedbackInfoKHR* TrackStruct(const VkVideoEncodeSessionParametersFeedbackInfoKHR* value, HandleUnwrapMemory* unwrap_memory);
VkQueueFamilyCheckpointProperties2NV* TrackStruct(const VkQueueFamilyCheckpointProperties2NV* value, HandleUnwrapMemory* unwrap_memory);
VkCheckpointData2NV* TrackStruct(const VkCheckpointData2NV* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceFragmentShaderBarycentricFeaturesKHR* TrackStruct(const VkPhysicalDeviceFragmentShaderBarycentricFeaturesKHR* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceFragmentShaderBarycentricPropertiesKHR* TrackStruct(const VkPhysicalDeviceFragmentShaderBarycentricPropertiesKHR* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceShaderSubgroupUniformControlFlowFeaturesKHR* TrackStruct(const VkPhysicalDeviceShaderSubgroupUniformControlFlowFeaturesKHR* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceWorkgroupMemoryExplicitLayoutFeaturesKHR* TrackStruct(const VkPhysicalDeviceWorkgroupMemoryExplicitLayoutFeaturesKHR* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceRayTracingMaintenance1FeaturesKHR* TrackStruct(const VkPhysicalDeviceRayTracingMaintenance1FeaturesKHR* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceShaderSubgroupRotateFeaturesKHR* TrackStruct(const VkPhysicalDeviceShaderSubgroupRotateFeaturesKHR* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceShaderMaximalReconvergenceFeaturesKHR* TrackStruct(const VkPhysicalDeviceShaderMaximalReconvergenceFeaturesKHR* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceMaintenance5FeaturesKHR* TrackStruct(const VkPhysicalDeviceMaintenance5FeaturesKHR* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceMaintenance5PropertiesKHR* TrackStruct(const VkPhysicalDeviceMaintenance5PropertiesKHR* value, HandleUnwrapMemory* unwrap_memory);
VkRenderingAreaInfoKHR* TrackStruct(const VkRenderingAreaInfoKHR* value, HandleUnwrapMemory* unwrap_memory);
VkImageSubresource2KHR* TrackStruct(const VkImageSubresource2KHR* value, HandleUnwrapMemory* unwrap_memory);
VkDeviceImageSubresourceInfoKHR* TrackStruct(const VkDeviceImageSubresourceInfoKHR* value, HandleUnwrapMemory* unwrap_memory);
VkSubresourceLayout2KHR* TrackStruct(const VkSubresourceLayout2KHR* value, HandleUnwrapMemory* unwrap_memory);
VkPipelineCreateFlags2CreateInfoKHR* TrackStruct(const VkPipelineCreateFlags2CreateInfoKHR* value, HandleUnwrapMemory* unwrap_memory);
VkBufferUsageFlags2CreateInfoKHR* TrackStruct(const VkBufferUsageFlags2CreateInfoKHR* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceRayTracingPositionFetchFeaturesKHR* TrackStruct(const VkPhysicalDeviceRayTracingPositionFetchFeaturesKHR* value, HandleUnwrapMemory* unwrap_memory);
VkCooperativeMatrixPropertiesKHR* TrackStruct(const VkCooperativeMatrixPropertiesKHR* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceCooperativeMatrixFeaturesKHR* TrackStruct(const VkPhysicalDeviceCooperativeMatrixFeaturesKHR* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceCooperativeMatrixPropertiesKHR* TrackStruct(const VkPhysicalDeviceCooperativeMatrixPropertiesKHR* value, HandleUnwrapMemory* unwrap_memory);
VkVideoDecodeAV1ProfileInfoKHR* TrackStruct(const VkVideoDecodeAV1ProfileInfoKHR* value, HandleUnwrapMemory* unwrap_memory);
VkVideoDecodeAV1CapabilitiesKHR* TrackStruct(const VkVideoDecodeAV1CapabilitiesKHR* value, HandleUnwrapMemory* unwrap_memory);
VkVideoDecodeAV1SessionParametersCreateInfoKHR* TrackStruct(const VkVideoDecodeAV1SessionParametersCreateInfoKHR* value, HandleUnwrapMemory* unwrap_memory);
VkVideoDecodeAV1PictureInfoKHR* TrackStruct(const VkVideoDecodeAV1PictureInfoKHR* value, HandleUnwrapMemory* unwrap_memory);
VkVideoDecodeAV1DpbSlotInfoKHR* TrackStruct(const VkVideoDecodeAV1DpbSlotInfoKHR* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceVideoMaintenance1FeaturesKHR* TrackStruct(const VkPhysicalDeviceVideoMaintenance1FeaturesKHR* value, HandleUnwrapMemory* unwrap_memory);
VkVideoInlineQueryInfoKHR* TrackStruct(const VkVideoInlineQueryInfoKHR* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceVertexAttributeDivisorPropertiesKHR* TrackStruct(const VkPhysicalDeviceVertexAttributeDivisorPropertiesKHR* value, HandleUnwrapMemory* unwrap_memory);
VkPipelineVertexInputDivisorStateCreateInfoKHR* TrackStruct(const VkPipelineVertexInputDivisorStateCreateInfoKHR* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceVertexAttributeDivisorFeaturesKHR* TrackStruct(const VkPhysicalDeviceVertexAttributeDivisorFeaturesKHR* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceShaderFloatControls2FeaturesKHR* TrackStruct(const VkPhysicalDeviceShaderFloatControls2FeaturesKHR* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceIndexTypeUint8FeaturesKHR* TrackStruct(const VkPhysicalDeviceIndexTypeUint8FeaturesKHR* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceLineRasterizationFeaturesKHR* TrackStruct(const VkPhysicalDeviceLineRasterizationFeaturesKHR* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceLineRasterizationPropertiesKHR* TrackStruct(const VkPhysicalDeviceLineRasterizationPropertiesKHR* value, HandleUnwrapMemory* unwrap_memory);
VkPipelineRasterizationLineStateCreateInfoKHR* TrackStruct(const VkPipelineRasterizationLineStateCreateInfoKHR* value, HandleUnwrapMemory* unwrap_memory);
VkCalibratedTimestampInfoKHR* TrackStruct(const VkCalibratedTimestampInfoKHR* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceShaderExpectAssumeFeaturesKHR* TrackStruct(const VkPhysicalDeviceShaderExpectAssumeFeaturesKHR* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceMaintenance6FeaturesKHR* TrackStruct(const VkPhysicalDeviceMaintenance6FeaturesKHR* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceMaintenance6PropertiesKHR* TrackStruct(const VkPhysicalDeviceMaintenance6PropertiesKHR* value, HandleUnwrapMemory* unwrap_memory);
VkBindMemoryStatusKHR* TrackStruct(const VkBindMemoryStatusKHR* value, HandleUnwrapMemory* unwrap_memory);
VkBindDescriptorSetsInfoKHR* TrackStruct(const VkBindDescriptorSetsInfoKHR* value, HandleUnwrapMemory* unwrap_memory);
VkPushConstantsInfoKHR* TrackStruct(const VkPushConstantsInfoKHR* value, HandleUnwrapMemory* unwrap_memory);
VkPushDescriptorSetInfoKHR* TrackStruct(const VkPushDescriptorSetInfoKHR* value, HandleUnwrapMemory* unwrap_memory);
VkPushDescriptorSetWithTemplateInfoKHR* TrackStruct(const VkPushDescriptorSetWithTemplateInfoKHR* value, HandleUnwrapMemory* unwrap_memory);
VkSetDescriptorBufferOffsetsInfoEXT* TrackStruct(const VkSetDescriptorBufferOffsetsInfoEXT* value, HandleUnwrapMemory* unwrap_memory);
VkBindDescriptorBufferEmbeddedSamplersInfoEXT* TrackStruct(const VkBindDescriptorBufferEmbeddedSamplersInfoEXT* value, HandleUnwrapMemory* unwrap_memory);
VkDebugReportCallbackCreateInfoEXT* TrackStruct(const VkDebugReportCallbackCreateInfoEXT* value, HandleUnwrapMemory* unwrap_memory);
VkPipelineRasterizationStateRasterizationOrderAMD* TrackStruct(const VkPipelineRasterizationStateRasterizationOrderAMD* value, HandleUnwrapMemory* unwrap_memory);
VkDebugMarkerObjectNameInfoEXT* TrackStruct(const VkDebugMarkerObjectNameInfoEXT* value, HandleUnwrapMemory* unwrap_memory);
VkDebugMarkerObjectTagInfoEXT* TrackStruct(const VkDebugMarkerObjectTagInfoEXT* value, HandleUnwrapMemory* unwrap_memory);
VkDebugMarkerMarkerInfoEXT* TrackStruct(const VkDebugMarkerMarkerInfoEXT* value, HandleUnwrapMemory* unwrap_memory);
VkDedicatedAllocationImageCreateInfoNV* TrackStruct(const VkDedicatedAllocationImageCreateInfoNV* value, HandleUnwrapMemory* unwrap_memory);
VkDedicatedAllocationBufferCreateInfoNV* TrackStruct(const VkDedicatedAllocationBufferCreateInfoNV* value, HandleUnwrapMemory* unwrap_memory);
VkDedicatedAllocationMemoryAllocateInfoNV* TrackStruct(const VkDedicatedAllocationMemoryAllocateInfoNV* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceTransformFeedbackFeaturesEXT* TrackStruct(const VkPhysicalDeviceTransformFeedbackFeaturesEXT* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceTransformFeedbackPropertiesEXT* TrackStruct(const VkPhysicalDeviceTransformFeedbackPropertiesEXT* value, HandleUnwrapMemory* unwrap_memory);
VkPipelineRasterizationStateStreamCreateInfoEXT* TrackStruct(const VkPipelineRasterizationStateStreamCreateInfoEXT* value, HandleUnwrapMemory* unwrap_memory);
VkImageViewHandleInfoNVX* TrackStruct(const VkImageViewHandleInfoNVX* value, HandleUnwrapMemory* unwrap_memory);
VkImageViewAddressPropertiesNVX* TrackStruct(const VkImageViewAddressPropertiesNVX* value, HandleUnwrapMemory* unwrap_memory);
VkTextureLODGatherFormatPropertiesAMD* TrackStruct(const VkTextureLODGatherFormatPropertiesAMD* value, HandleUnwrapMemory* unwrap_memory);
VkStreamDescriptorSurfaceCreateInfoGGP* TrackStruct(const VkStreamDescriptorSurfaceCreateInfoGGP* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceCornerSampledImageFeaturesNV* TrackStruct(const VkPhysicalDeviceCornerSampledImageFeaturesNV* value, HandleUnwrapMemory* unwrap_memory);
VkExternalMemoryImageCreateInfoNV* TrackStruct(const VkExternalMemoryImageCreateInfoNV* value, HandleUnwrapMemory* unwrap_memory);
VkExportMemoryAllocateInfoNV* TrackStruct(const VkExportMemoryAllocateInfoNV* value, HandleUnwrapMemory* unwrap_memory);
VkImportMemoryWin32HandleInfoNV* TrackStruct(const VkImportMemoryWin32HandleInfoNV* value, HandleUnwrapMemory* unwrap_memory);
VkExportMemoryWin32HandleInfoNV* TrackStruct(const VkExportMemoryWin32HandleInfoNV* value, HandleUnwrapMemory* unwrap_memory);
VkWin32KeyedMutexAcquireReleaseInfoNV* TrackStruct(const VkWin32KeyedMutexAcquireReleaseInfoNV* value, HandleUnwrapMemory* unwrap_memory);
VkValidationFlagsEXT* TrackStruct(const VkValidationFlagsEXT* value, HandleUnwrapMemory* unwrap_memory);
VkViSurfaceCreateInfoNN* TrackStruct(const VkViSurfaceCreateInfoNN* value, HandleUnwrapMemory* unwrap_memory);
VkImageViewASTCDecodeModeEXT* TrackStruct(const VkImageViewASTCDecodeModeEXT* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceASTCDecodeFeaturesEXT* TrackStruct(const VkPhysicalDeviceASTCDecodeFeaturesEXT* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDevicePipelineRobustnessFeaturesEXT* TrackStruct(const VkPhysicalDevicePipelineRobustnessFeaturesEXT* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDevicePipelineRobustnessPropertiesEXT* TrackStruct(const VkPhysicalDevicePipelineRobustnessPropertiesEXT* value, HandleUnwrapMemory* unwrap_memory);
VkPipelineRobustnessCreateInfoEXT* TrackStruct(const VkPipelineRobustnessCreateInfoEXT* value, HandleUnwrapMemory* unwrap_memory);
VkConditionalRenderingBeginInfoEXT* TrackStruct(const VkConditionalRenderingBeginInfoEXT* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceConditionalRenderingFeaturesEXT* TrackStruct(const VkPhysicalDeviceConditionalRenderingFeaturesEXT* value, HandleUnwrapMemory* unwrap_memory);
VkCommandBufferInheritanceConditionalRenderingInfoEXT* TrackStruct(const VkCommandBufferInheritanceConditionalRenderingInfoEXT* value, HandleUnwrapMemory* unwrap_memory);
VkPipelineViewportWScalingStateCreateInfoNV* TrackStruct(const VkPipelineViewportWScalingStateCreateInfoNV* value, HandleUnwrapMemory* unwrap_memory);
VkSurfaceCapabilities2EXT* TrackStruct(const VkSurfaceCapabilities2EXT* value, HandleUnwrapMemory* unwrap_memory);
VkDisplayPowerInfoEXT* TrackStruct(const VkDisplayPowerInfoEXT* value, HandleUnwrapMemory* unwrap_memory);
VkDeviceEventInfoEXT* TrackStruct(const VkDeviceEventInfoEXT* value, HandleUnwrapMemory* unwrap_memory);
VkDisplayEventInfoEXT* TrackStruct(const VkDisplayEventInfoEXT* value, HandleUnwrapMemory* unwrap_memory);
VkSwapchainCounterCreateInfoEXT* TrackStruct(const VkSwapchainCounterCreateInfoEXT* value, HandleUnwrapMemory* unwrap_memory);
VkPresentTimesInfoGOOGLE* TrackStruct(const VkPresentTimesInfoGOOGLE* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceMultiviewPerViewAttributesPropertiesNVX* TrackStruct(const VkPhysicalDeviceMultiviewPerViewAttributesPropertiesNVX* value, HandleUnwrapMemory* unwrap_memory);
VkPipelineViewportSwizzleStateCreateInfoNV* TrackStruct(const VkPipelineViewportSwizzleStateCreateInfoNV* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceDiscardRectanglePropertiesEXT* TrackStruct(const VkPhysicalDeviceDiscardRectanglePropertiesEXT* value, HandleUnwrapMemory* unwrap_memory);
VkPipelineDiscardRectangleStateCreateInfoEXT* TrackStruct(const VkPipelineDiscardRectangleStateCreateInfoEXT* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceConservativeRasterizationPropertiesEXT* TrackStruct(const VkPhysicalDeviceConservativeRasterizationPropertiesEXT* value, HandleUnwrapMemory* unwrap_memory);
VkPipelineRasterizationConservativeStateCreateInfoEXT* TrackStruct(const VkPipelineRasterizationConservativeStateCreateInfoEXT* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceDepthClipEnableFeaturesEXT* TrackStruct(const VkPhysicalDeviceDepthClipEnableFeaturesEXT* value, HandleUnwrapMemory* unwrap_memory);
VkPipelineRasterizationDepthClipStateCreateInfoEXT* TrackStruct(const VkPipelineRasterizationDepthClipStateCreateInfoEXT* value, HandleUnwrapMemory* unwrap_memory);
VkHdrMetadataEXT* TrackStruct(const VkHdrMetadataEXT* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceRelaxedLineRasterizationFeaturesIMG* TrackStruct(const VkPhysicalDeviceRelaxedLineRasterizationFeaturesIMG* value, HandleUnwrapMemory* unwrap_memory);
VkIOSSurfaceCreateInfoMVK* TrackStruct(const VkIOSSurfaceCreateInfoMVK* value, HandleUnwrapMemory* unwrap_memory);
VkMacOSSurfaceCreateInfoMVK* TrackStruct(const VkMacOSSurfaceCreateInfoMVK* value, HandleUnwrapMemory* unwrap_memory);
VkDebugUtilsLabelEXT* TrackStruct(const VkDebugUtilsLabelEXT* value, HandleUnwrapMemory* unwrap_memory);
VkDebugUtilsObjectNameInfoEXT* TrackStruct(const VkDebugUtilsObjectNameInfoEXT* value, HandleUnwrapMemory* unwrap_memory);
VkDebugUtilsMessengerCallbackDataEXT* TrackStruct(const VkDebugUtilsMessengerCallbackDataEXT* value, HandleUnwrapMemory* unwrap_memory);
VkDebugUtilsMessengerCreateInfoEXT* TrackStruct(const VkDebugUtilsMessengerCreateInfoEXT* value, HandleUnwrapMemory* unwrap_memory);
VkDebugUtilsObjectTagInfoEXT* TrackStruct(const VkDebugUtilsObjectTagInfoEXT* value, HandleUnwrapMemory* unwrap_memory);
VkAndroidHardwareBufferUsageANDROID* TrackStruct(const VkAndroidHardwareBufferUsageANDROID* value, HandleUnwrapMemory* unwrap_memory);
VkAndroidHardwareBufferPropertiesANDROID* TrackStruct(const VkAndroidHardwareBufferPropertiesANDROID* value, HandleUnwrapMemory* unwrap_memory);
VkAndroidHardwareBufferFormatPropertiesANDROID* TrackStruct(const VkAndroidHardwareBufferFormatPropertiesANDROID* value, HandleUnwrapMemory* unwrap_memory);
VkImportAndroidHardwareBufferInfoANDROID* TrackStruct(const VkImportAndroidHardwareBufferInfoANDROID* value, HandleUnwrapMemory* unwrap_memory);
VkMemoryGetAndroidHardwareBufferInfoANDROID* TrackStruct(const VkMemoryGetAndroidHardwareBufferInfoANDROID* value, HandleUnwrapMemory* unwrap_memory);
VkExternalFormatANDROID* TrackStruct(const VkExternalFormatANDROID* value, HandleUnwrapMemory* unwrap_memory);
VkAndroidHardwareBufferFormatProperties2ANDROID* TrackStruct(const VkAndroidHardwareBufferFormatProperties2ANDROID* value, HandleUnwrapMemory* unwrap_memory);
VkSampleLocationsInfoEXT* TrackStruct(const VkSampleLocationsInfoEXT* value, HandleUnwrapMemory* unwrap_memory);
VkRenderPassSampleLocationsBeginInfoEXT* TrackStruct(const VkRenderPassSampleLocationsBeginInfoEXT* value, HandleUnwrapMemory* unwrap_memory);
VkPipelineSampleLocationsStateCreateInfoEXT* TrackStruct(const VkPipelineSampleLocationsStateCreateInfoEXT* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceSampleLocationsPropertiesEXT* TrackStruct(const VkPhysicalDeviceSampleLocationsPropertiesEXT* value, HandleUnwrapMemory* unwrap_memory);
VkMultisamplePropertiesEXT* TrackStruct(const VkMultisamplePropertiesEXT* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceBlendOperationAdvancedFeaturesEXT* TrackStruct(const VkPhysicalDeviceBlendOperationAdvancedFeaturesEXT* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT* TrackStruct(const VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT* value, HandleUnwrapMemory* unwrap_memory);
VkPipelineColorBlendAdvancedStateCreateInfoEXT* TrackStruct(const VkPipelineColorBlendAdvancedStateCreateInfoEXT* value, HandleUnwrapMemory* unwrap_memory);
VkPipelineCoverageToColorStateCreateInfoNV* TrackStruct(const VkPipelineCoverageToColorStateCreateInfoNV* value, HandleUnwrapMemory* unwrap_memory);
VkPipelineCoverageModulationStateCreateInfoNV* TrackStruct(const VkPipelineCoverageModulationStateCreateInfoNV* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceShaderSMBuiltinsPropertiesNV* TrackStruct(const VkPhysicalDeviceShaderSMBuiltinsPropertiesNV* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceShaderSMBuiltinsFeaturesNV* TrackStruct(const VkPhysicalDeviceShaderSMBuiltinsFeaturesNV* value, HandleUnwrapMemory* unwrap_memory);
VkDrmFormatModifierPropertiesListEXT* TrackStruct(const VkDrmFormatModifierPropertiesListEXT* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceImageDrmFormatModifierInfoEXT* TrackStruct(const VkPhysicalDeviceImageDrmFormatModifierInfoEXT* value, HandleUnwrapMemory* unwrap_memory);
VkImageDrmFormatModifierListCreateInfoEXT* TrackStruct(const VkImageDrmFormatModifierListCreateInfoEXT* value, HandleUnwrapMemory* unwrap_memory);
VkImageDrmFormatModifierExplicitCreateInfoEXT* TrackStruct(const VkImageDrmFormatModifierExplicitCreateInfoEXT* value, HandleUnwrapMemory* unwrap_memory);
VkImageDrmFormatModifierPropertiesEXT* TrackStruct(const VkImageDrmFormatModifierPropertiesEXT* value, HandleUnwrapMemory* unwrap_memory);
VkDrmFormatModifierPropertiesList2EXT* TrackStruct(const VkDrmFormatModifierPropertiesList2EXT* value, HandleUnwrapMemory* unwrap_memory);
VkValidationCacheCreateInfoEXT* TrackStruct(const VkValidationCacheCreateInfoEXT* value, HandleUnwrapMemory* unwrap_memory);
VkShaderModuleValidationCacheCreateInfoEXT* TrackStruct(const VkShaderModuleValidationCacheCreateInfoEXT* value, HandleUnwrapMemory* unwrap_memory);
VkPipelineViewportShadingRateImageStateCreateInfoNV* TrackStruct(const VkPipelineViewportShadingRateImageStateCreateInfoNV* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceShadingRateImageFeaturesNV* TrackStruct(const VkPhysicalDeviceShadingRateImageFeaturesNV* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceShadingRateImagePropertiesNV* TrackStruct(const VkPhysicalDeviceShadingRateImagePropertiesNV* value, HandleUnwrapMemory* unwrap_memory);
VkPipelineViewportCoarseSampleOrderStateCreateInfoNV* TrackStruct(const VkPipelineViewportCoarseSampleOrderStateCreateInfoNV* value, HandleUnwrapMemory* unwrap_memory);
VkRayTracingShaderGroupCreateInfoNV* TrackStruct(const VkRayTracingShaderGroupCreateInfoNV* value, HandleUnwrapMemory* unwrap_memory);
VkRayTracingPipelineCreateInfoNV* TrackStruct(const VkRayTracingPipelineCreateInfoNV* value, HandleUnwrapMemory* unwrap_memory);
VkGeometryTrianglesNV* TrackStruct(const VkGeometryTrianglesNV* value, HandleUnwrapMemory* unwrap_memory);
VkGeometryAABBNV* TrackStruct(const VkGeometryAABBNV* value, HandleUnwrapMemory* unwrap_memory);
VkGeometryNV* TrackStruct(const VkGeometryNV* value, HandleUnwrapMemory* unwrap_memory);
VkAccelerationStructureInfoNV* TrackStruct(const VkAccelerationStructureInfoNV* value, HandleUnwrapMemory* unwrap_memory);
VkAccelerationStructureCreateInfoNV* TrackStruct(const VkAccelerationStructureCreateInfoNV* value, HandleUnwrapMemory* unwrap_memory);
VkBindAccelerationStructureMemoryInfoNV* TrackStruct(const VkBindAccelerationStructureMemoryInfoNV* value, HandleUnwrapMemory* unwrap_memory);
VkWriteDescriptorSetAccelerationStructureNV* TrackStruct(const VkWriteDescriptorSetAccelerationStructureNV* value, HandleUnwrapMemory* unwrap_memory);
VkAccelerationStructureMemoryRequirementsInfoNV* TrackStruct(const VkAccelerationStructureMemoryRequirementsInfoNV* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceRayTracingPropertiesNV* TrackStruct(const VkPhysicalDeviceRayTracingPropertiesNV* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceRepresentativeFragmentTestFeaturesNV* TrackStruct(const VkPhysicalDeviceRepresentativeFragmentTestFeaturesNV* value, HandleUnwrapMemory* unwrap_memory);
VkPipelineRepresentativeFragmentTestStateCreateInfoNV* TrackStruct(const VkPipelineRepresentativeFragmentTestStateCreateInfoNV* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceImageViewImageFormatInfoEXT* TrackStruct(const VkPhysicalDeviceImageViewImageFormatInfoEXT* value, HandleUnwrapMemory* unwrap_memory);
VkFilterCubicImageViewImageFormatPropertiesEXT* TrackStruct(const VkFilterCubicImageViewImageFormatPropertiesEXT* value, HandleUnwrapMemory* unwrap_memory);
VkImportMemoryHostPointerInfoEXT* TrackStruct(const VkImportMemoryHostPointerInfoEXT* value, HandleUnwrapMemory* unwrap_memory);
VkMemoryHostPointerPropertiesEXT* TrackStruct(const VkMemoryHostPointerPropertiesEXT* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceExternalMemoryHostPropertiesEXT* TrackStruct(const VkPhysicalDeviceExternalMemoryHostPropertiesEXT* value, HandleUnwrapMemory* unwrap_memory);
VkPipelineCompilerControlCreateInfoAMD* TrackStruct(const VkPipelineCompilerControlCreateInfoAMD* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceShaderCorePropertiesAMD* TrackStruct(const VkPhysicalDeviceShaderCorePropertiesAMD* value, HandleUnwrapMemory* unwrap_memory);
VkDeviceMemoryOverallocationCreateInfoAMD* TrackStruct(const VkDeviceMemoryOverallocationCreateInfoAMD* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceVertexAttributeDivisorPropertiesEXT* TrackStruct(const VkPhysicalDeviceVertexAttributeDivisorPropertiesEXT* value, HandleUnwrapMemory* unwrap_memory);
VkPresentFrameTokenGGP* TrackStruct(const VkPresentFrameTokenGGP* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceComputeShaderDerivativesFeaturesNV* TrackStruct(const VkPhysicalDeviceComputeShaderDerivativesFeaturesNV* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceMeshShaderFeaturesNV* TrackStruct(const VkPhysicalDeviceMeshShaderFeaturesNV* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceMeshShaderPropertiesNV* TrackStruct(const VkPhysicalDeviceMeshShaderPropertiesNV* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceShaderImageFootprintFeaturesNV* TrackStruct(const VkPhysicalDeviceShaderImageFootprintFeaturesNV* value, HandleUnwrapMemory* unwrap_memory);
VkPipelineViewportExclusiveScissorStateCreateInfoNV* TrackStruct(const VkPipelineViewportExclusiveScissorStateCreateInfoNV* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceExclusiveScissorFeaturesNV* TrackStruct(const VkPhysicalDeviceExclusiveScissorFeaturesNV* value, HandleUnwrapMemory* unwrap_memory);
VkQueueFamilyCheckpointPropertiesNV* TrackStruct(const VkQueueFamilyCheckpointPropertiesNV* value, HandleUnwrapMemory* unwrap_memory);
VkCheckpointDataNV* TrackStruct(const VkCheckpointDataNV* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceShaderIntegerFunctions2FeaturesINTEL* TrackStruct(const VkPhysicalDeviceShaderIntegerFunctions2FeaturesINTEL* value, HandleUnwrapMemory* unwrap_memory);
VkInitializePerformanceApiInfoINTEL* TrackStruct(const VkInitializePerformanceApiInfoINTEL* value, HandleUnwrapMemory* unwrap_memory);
VkQueryPoolPerformanceQueryCreateInfoINTEL* TrackStruct(const VkQueryPoolPerformanceQueryCreateInfoINTEL* value, HandleUnwrapMemory* unwrap_memory);
VkPerformanceMarkerInfoINTEL* TrackStruct(const VkPerformanceMarkerInfoINTEL* value, HandleUnwrapMemory* unwrap_memory);
VkPerformanceStreamMarkerInfoINTEL* TrackStruct(const VkPerformanceStreamMarkerInfoINTEL* value, HandleUnwrapMemory* unwrap_memory);
VkPerformanceOverrideInfoINTEL* TrackStruct(const VkPerformanceOverrideInfoINTEL* value, HandleUnwrapMemory* unwrap_memory);
VkPerformanceConfigurationAcquireInfoINTEL* TrackStruct(const VkPerformanceConfigurationAcquireInfoINTEL* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDevicePCIBusInfoPropertiesEXT* TrackStruct(const VkPhysicalDevicePCIBusInfoPropertiesEXT* value, HandleUnwrapMemory* unwrap_memory);
VkDisplayNativeHdrSurfaceCapabilitiesAMD* TrackStruct(const VkDisplayNativeHdrSurfaceCapabilitiesAMD* value, HandleUnwrapMemory* unwrap_memory);
VkSwapchainDisplayNativeHdrCreateInfoAMD* TrackStruct(const VkSwapchainDisplayNativeHdrCreateInfoAMD* value, HandleUnwrapMemory* unwrap_memory);
VkImagePipeSurfaceCreateInfoFUCHSIA* TrackStruct(const VkImagePipeSurfaceCreateInfoFUCHSIA* value, HandleUnwrapMemory* unwrap_memory);
VkMetalSurfaceCreateInfoEXT* TrackStruct(const VkMetalSurfaceCreateInfoEXT* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceFragmentDensityMapFeaturesEXT* TrackStruct(const VkPhysicalDeviceFragmentDensityMapFeaturesEXT* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceFragmentDensityMapPropertiesEXT* TrackStruct(const VkPhysicalDeviceFragmentDensityMapPropertiesEXT* value, HandleUnwrapMemory* unwrap_memory);
VkRenderPassFragmentDensityMapCreateInfoEXT* TrackStruct(const VkRenderPassFragmentDensityMapCreateInfoEXT* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceShaderCoreProperties2AMD* TrackStruct(const VkPhysicalDeviceShaderCoreProperties2AMD* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceCoherentMemoryFeaturesAMD* TrackStruct(const VkPhysicalDeviceCoherentMemoryFeaturesAMD* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceShaderImageAtomicInt64FeaturesEXT* TrackStruct(const VkPhysicalDeviceShaderImageAtomicInt64FeaturesEXT* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceMemoryBudgetPropertiesEXT* TrackStruct(const VkPhysicalDeviceMemoryBudgetPropertiesEXT* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceMemoryPriorityFeaturesEXT* TrackStruct(const VkPhysicalDeviceMemoryPriorityFeaturesEXT* value, HandleUnwrapMemory* unwrap_memory);
VkMemoryPriorityAllocateInfoEXT* TrackStruct(const VkMemoryPriorityAllocateInfoEXT* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceDedicatedAllocationImageAliasingFeaturesNV* TrackStruct(const VkPhysicalDeviceDedicatedAllocationImageAliasingFeaturesNV* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceBufferDeviceAddressFeaturesEXT* TrackStruct(const VkPhysicalDeviceBufferDeviceAddressFeaturesEXT* value, HandleUnwrapMemory* unwrap_memory);
VkBufferDeviceAddressCreateInfoEXT* TrackStruct(const VkBufferDeviceAddressCreateInfoEXT* value, HandleUnwrapMemory* unwrap_memory);
VkValidationFeaturesEXT* TrackStruct(const VkValidationFeaturesEXT* value, HandleUnwrapMemory* unwrap_memory);
VkCooperativeMatrixPropertiesNV* TrackStruct(const VkCooperativeMatrixPropertiesNV* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceCooperativeMatrixFeaturesNV* TrackStruct(const VkPhysicalDeviceCooperativeMatrixFeaturesNV* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceCooperativeMatrixPropertiesNV* TrackStruct(const VkPhysicalDeviceCooperativeMatrixPropertiesNV* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceCoverageReductionModeFeaturesNV* TrackStruct(const VkPhysicalDeviceCoverageReductionModeFeaturesNV* value, HandleUnwrapMemory* unwrap_memory);
VkPipelineCoverageReductionStateCreateInfoNV* TrackStruct(const VkPipelineCoverageReductionStateCreateInfoNV* value, HandleUnwrapMemory* unwrap_memory);
VkFramebufferMixedSamplesCombinationNV* TrackStruct(const VkFramebufferMixedSamplesCombinationNV* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT* TrackStruct(const VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceYcbcrImageArraysFeaturesEXT* TrackStruct(const VkPhysicalDeviceYcbcrImageArraysFeaturesEXT* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceProvokingVertexFeaturesEXT* TrackStruct(const VkPhysicalDeviceProvokingVertexFeaturesEXT* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceProvokingVertexPropertiesEXT* TrackStruct(const VkPhysicalDeviceProvokingVertexPropertiesEXT* value, HandleUnwrapMemory* unwrap_memory);
VkPipelineRasterizationProvokingVertexStateCreateInfoEXT* TrackStruct(const VkPipelineRasterizationProvokingVertexStateCreateInfoEXT* value, HandleUnwrapMemory* unwrap_memory);
VkSurfaceFullScreenExclusiveInfoEXT* TrackStruct(const VkSurfaceFullScreenExclusiveInfoEXT* value, HandleUnwrapMemory* unwrap_memory);
VkSurfaceCapabilitiesFullScreenExclusiveEXT* TrackStruct(const VkSurfaceCapabilitiesFullScreenExclusiveEXT* value, HandleUnwrapMemory* unwrap_memory);
VkSurfaceFullScreenExclusiveWin32InfoEXT* TrackStruct(const VkSurfaceFullScreenExclusiveWin32InfoEXT* value, HandleUnwrapMemory* unwrap_memory);
VkHeadlessSurfaceCreateInfoEXT* TrackStruct(const VkHeadlessSurfaceCreateInfoEXT* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceShaderAtomicFloatFeaturesEXT* TrackStruct(const VkPhysicalDeviceShaderAtomicFloatFeaturesEXT* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceExtendedDynamicStateFeaturesEXT* TrackStruct(const VkPhysicalDeviceExtendedDynamicStateFeaturesEXT* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceHostImageCopyFeaturesEXT* TrackStruct(const VkPhysicalDeviceHostImageCopyFeaturesEXT* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceHostImageCopyPropertiesEXT* TrackStruct(const VkPhysicalDeviceHostImageCopyPropertiesEXT* value, HandleUnwrapMemory* unwrap_memory);
VkMemoryToImageCopyEXT* TrackStruct(const VkMemoryToImageCopyEXT* value, HandleUnwrapMemory* unwrap_memory);
VkImageToMemoryCopyEXT* TrackStruct(const VkImageToMemoryCopyEXT* value, HandleUnwrapMemory* unwrap_memory);
VkCopyMemoryToImageInfoEXT* TrackStruct(const VkCopyMemoryToImageInfoEXT* value, HandleUnwrapMemory* unwrap_memory);
VkCopyImageToMemoryInfoEXT* TrackStruct(const VkCopyImageToMemoryInfoEXT* value, HandleUnwrapMemory* unwrap_memory);
VkCopyImageToImageInfoEXT* TrackStruct(const VkCopyImageToImageInfoEXT* value, HandleUnwrapMemory* unwrap_memory);
VkHostImageLayoutTransitionInfoEXT* TrackStruct(const VkHostImageLayoutTransitionInfoEXT* value, HandleUnwrapMemory* unwrap_memory);
VkSubresourceHostMemcpySizeEXT* TrackStruct(const VkSubresourceHostMemcpySizeEXT* value, HandleUnwrapMemory* unwrap_memory);
VkHostImageCopyDevicePerformanceQueryEXT* TrackStruct(const VkHostImageCopyDevicePerformanceQueryEXT* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceMapMemoryPlacedFeaturesEXT* TrackStruct(const VkPhysicalDeviceMapMemoryPlacedFeaturesEXT* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceMapMemoryPlacedPropertiesEXT* TrackStruct(const VkPhysicalDeviceMapMemoryPlacedPropertiesEXT* value, HandleUnwrapMemory* unwrap_memory);
VkMemoryMapPlacedInfoEXT* TrackStruct(const VkMemoryMapPlacedInfoEXT* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceShaderAtomicFloat2FeaturesEXT* TrackStruct(const VkPhysicalDeviceShaderAtomicFloat2FeaturesEXT* value, HandleUnwrapMemory* unwrap_memory);
VkSurfacePresentModeEXT* TrackStruct(const VkSurfacePresentModeEXT* value, HandleUnwrapMemory* unwrap_memory);
VkSurfacePresentScalingCapabilitiesEXT* TrackStruct(const VkSurfacePresentScalingCapabilitiesEXT* value, HandleUnwrapMemory* unwrap_memory);
VkSurfacePresentModeCompatibilityEXT* TrackStruct(const VkSurfacePresentModeCompatibilityEXT* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceSwapchainMaintenance1FeaturesEXT* TrackStruct(const VkPhysicalDeviceSwapchainMaintenance1FeaturesEXT* value, HandleUnwrapMemory* unwrap_memory);
VkSwapchainPresentFenceInfoEXT* TrackStruct(const VkSwapchainPresentFenceInfoEXT* value, HandleUnwrapMemory* unwrap_memory);
VkSwapchainPresentModesCreateInfoEXT* TrackStruct(const VkSwapchainPresentModesCreateInfoEXT* value, HandleUnwrapMemory* unwrap_memory);
VkSwapchainPresentModeInfoEXT* TrackStruct(const VkSwapchainPresentModeInfoEXT* value, HandleUnwrapMemory* unwrap_memory);
VkSwapchainPresentScalingCreateInfoEXT* TrackStruct(const VkSwapchainPresentScalingCreateInfoEXT* value, HandleUnwrapMemory* unwrap_memory);
VkReleaseSwapchainImagesInfoEXT* TrackStruct(const VkReleaseSwapchainImagesInfoEXT* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceDeviceGeneratedCommandsPropertiesNV* TrackStruct(const VkPhysicalDeviceDeviceGeneratedCommandsPropertiesNV* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceDeviceGeneratedCommandsFeaturesNV* TrackStruct(const VkPhysicalDeviceDeviceGeneratedCommandsFeaturesNV* value, HandleUnwrapMemory* unwrap_memory);
VkGraphicsShaderGroupCreateInfoNV* TrackStruct(const VkGraphicsShaderGroupCreateInfoNV* value, HandleUnwrapMemory* unwrap_memory);
VkGraphicsPipelineShaderGroupsCreateInfoNV* TrackStruct(const VkGraphicsPipelineShaderGroupsCreateInfoNV* value, HandleUnwrapMemory* unwrap_memory);
VkIndirectCommandsLayoutTokenNV* TrackStruct(const VkIndirectCommandsLayoutTokenNV* value, HandleUnwrapMemory* unwrap_memory);
VkIndirectCommandsLayoutCreateInfoNV* TrackStruct(const VkIndirectCommandsLayoutCreateInfoNV* value, HandleUnwrapMemory* unwrap_memory);
VkGeneratedCommandsInfoNV* TrackStruct(const VkGeneratedCommandsInfoNV* value, HandleUnwrapMemory* unwrap_memory);
VkGeneratedCommandsMemoryRequirementsInfoNV* TrackStruct(const VkGeneratedCommandsMemoryRequirementsInfoNV* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceInheritedViewportScissorFeaturesNV* TrackStruct(const VkPhysicalDeviceInheritedViewportScissorFeaturesNV* value, HandleUnwrapMemory* unwrap_memory);
VkCommandBufferInheritanceViewportScissorInfoNV* TrackStruct(const VkCommandBufferInheritanceViewportScissorInfoNV* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT* TrackStruct(const VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT* value, HandleUnwrapMemory* unwrap_memory);
VkRenderPassTransformBeginInfoQCOM* TrackStruct(const VkRenderPassTransformBeginInfoQCOM* value, HandleUnwrapMemory* unwrap_memory);
VkCommandBufferInheritanceRenderPassTransformInfoQCOM* TrackStruct(const VkCommandBufferInheritanceRenderPassTransformInfoQCOM* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceDepthBiasControlFeaturesEXT* TrackStruct(const VkPhysicalDeviceDepthBiasControlFeaturesEXT* value, HandleUnwrapMemory* unwrap_memory);
VkDepthBiasInfoEXT* TrackStruct(const VkDepthBiasInfoEXT* value, HandleUnwrapMemory* unwrap_memory);
VkDepthBiasRepresentationInfoEXT* TrackStruct(const VkDepthBiasRepresentationInfoEXT* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceDeviceMemoryReportFeaturesEXT* TrackStruct(const VkPhysicalDeviceDeviceMemoryReportFeaturesEXT* value, HandleUnwrapMemory* unwrap_memory);
VkDeviceMemoryReportCallbackDataEXT* TrackStruct(const VkDeviceMemoryReportCallbackDataEXT* value, HandleUnwrapMemory* unwrap_memory);
VkDeviceDeviceMemoryReportCreateInfoEXT* TrackStruct(const VkDeviceDeviceMemoryReportCreateInfoEXT* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceRobustness2FeaturesEXT* TrackStruct(const VkPhysicalDeviceRobustness2FeaturesEXT* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceRobustness2PropertiesEXT* TrackStruct(const VkPhysicalDeviceRobustness2PropertiesEXT* value, HandleUnwrapMemory* unwrap_memory);
VkSamplerCustomBorderColorCreateInfoEXT* TrackStruct(const VkSamplerCustomBorderColorCreateInfoEXT* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceCustomBorderColorPropertiesEXT* TrackStruct(const VkPhysicalDeviceCustomBorderColorPropertiesEXT* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceCustomBorderColorFeaturesEXT* TrackStruct(const VkPhysicalDeviceCustomBorderColorFeaturesEXT* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDevicePresentBarrierFeaturesNV* TrackStruct(const VkPhysicalDevicePresentBarrierFeaturesNV* value, HandleUnwrapMemory* unwrap_memory);
VkSurfaceCapabilitiesPresentBarrierNV* TrackStruct(const VkSurfaceCapabilitiesPresentBarrierNV* value, HandleUnwrapMemory* unwrap_memory);
VkSwapchainPresentBarrierCreateInfoNV* TrackStruct(const VkSwapchainPresentBarrierCreateInfoNV* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceDiagnosticsConfigFeaturesNV* TrackStruct(const VkPhysicalDeviceDiagnosticsConfigFeaturesNV* value, HandleUnwrapMemory* unwrap_memory);
VkDeviceDiagnosticsConfigCreateInfoNV* TrackStruct(const VkDeviceDiagnosticsConfigCreateInfoNV* value, HandleUnwrapMemory* unwrap_memory);
VkQueryLowLatencySupportNV* TrackStruct(const VkQueryLowLatencySupportNV* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceGraphicsPipelineLibraryFeaturesEXT* TrackStruct(const VkPhysicalDeviceGraphicsPipelineLibraryFeaturesEXT* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceGraphicsPipelineLibraryPropertiesEXT* TrackStruct(const VkPhysicalDeviceGraphicsPipelineLibraryPropertiesEXT* value, HandleUnwrapMemory* unwrap_memory);
VkGraphicsPipelineLibraryCreateInfoEXT* TrackStruct(const VkGraphicsPipelineLibraryCreateInfoEXT* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceShaderEarlyAndLateFragmentTestsFeaturesAMD* TrackStruct(const VkPhysicalDeviceShaderEarlyAndLateFragmentTestsFeaturesAMD* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceFragmentShadingRateEnumsFeaturesNV* TrackStruct(const VkPhysicalDeviceFragmentShadingRateEnumsFeaturesNV* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceFragmentShadingRateEnumsPropertiesNV* TrackStruct(const VkPhysicalDeviceFragmentShadingRateEnumsPropertiesNV* value, HandleUnwrapMemory* unwrap_memory);
VkPipelineFragmentShadingRateEnumStateCreateInfoNV* TrackStruct(const VkPipelineFragmentShadingRateEnumStateCreateInfoNV* value, HandleUnwrapMemory* unwrap_memory);
VkAccelerationStructureGeometryMotionTrianglesDataNV* TrackStruct(const VkAccelerationStructureGeometryMotionTrianglesDataNV* value, HandleUnwrapMemory* unwrap_memory);
VkAccelerationStructureMotionInfoNV* TrackStruct(const VkAccelerationStructureMotionInfoNV* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceRayTracingMotionBlurFeaturesNV* TrackStruct(const VkPhysicalDeviceRayTracingMotionBlurFeaturesNV* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT* TrackStruct(const VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceFragmentDensityMap2FeaturesEXT* TrackStruct(const VkPhysicalDeviceFragmentDensityMap2FeaturesEXT* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceFragmentDensityMap2PropertiesEXT* TrackStruct(const VkPhysicalDeviceFragmentDensityMap2PropertiesEXT* value, HandleUnwrapMemory* unwrap_memory);
VkCopyCommandTransformInfoQCOM* TrackStruct(const VkCopyCommandTransformInfoQCOM* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceImageCompressionControlFeaturesEXT* TrackStruct(const VkPhysicalDeviceImageCompressionControlFeaturesEXT* value, HandleUnwrapMemory* unwrap_memory);
VkImageCompressionControlEXT* TrackStruct(const VkImageCompressionControlEXT* value, HandleUnwrapMemory* unwrap_memory);
VkImageCompressionPropertiesEXT* TrackStruct(const VkImageCompressionPropertiesEXT* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceAttachmentFeedbackLoopLayoutFeaturesEXT* TrackStruct(const VkPhysicalDeviceAttachmentFeedbackLoopLayoutFeaturesEXT* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDevice4444FormatsFeaturesEXT* TrackStruct(const VkPhysicalDevice4444FormatsFeaturesEXT* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceFaultFeaturesEXT* TrackStruct(const VkPhysicalDeviceFaultFeaturesEXT* value, HandleUnwrapMemory* unwrap_memory);
VkDeviceFaultCountsEXT* TrackStruct(const VkDeviceFaultCountsEXT* value, HandleUnwrapMemory* unwrap_memory);
VkDeviceFaultInfoEXT* TrackStruct(const VkDeviceFaultInfoEXT* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceRasterizationOrderAttachmentAccessFeaturesEXT* TrackStruct(const VkPhysicalDeviceRasterizationOrderAttachmentAccessFeaturesEXT* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceRGBA10X6FormatsFeaturesEXT* TrackStruct(const VkPhysicalDeviceRGBA10X6FormatsFeaturesEXT* value, HandleUnwrapMemory* unwrap_memory);
VkDirectFBSurfaceCreateInfoEXT* TrackStruct(const VkDirectFBSurfaceCreateInfoEXT* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceMutableDescriptorTypeFeaturesEXT* TrackStruct(const VkPhysicalDeviceMutableDescriptorTypeFeaturesEXT* value, HandleUnwrapMemory* unwrap_memory);
VkMutableDescriptorTypeCreateInfoEXT* TrackStruct(const VkMutableDescriptorTypeCreateInfoEXT* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceVertexInputDynamicStateFeaturesEXT* TrackStruct(const VkPhysicalDeviceVertexInputDynamicStateFeaturesEXT* value, HandleUnwrapMemory* unwrap_memory);
VkVertexInputBindingDescription2EXT* TrackStruct(const VkVertexInputBindingDescription2EXT* value, HandleUnwrapMemory* unwrap_memory);
VkVertexInputAttributeDescription2EXT* TrackStruct(const VkVertexInputAttributeDescription2EXT* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceDrmPropertiesEXT* TrackStruct(const VkPhysicalDeviceDrmPropertiesEXT* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceAddressBindingReportFeaturesEXT* TrackStruct(const VkPhysicalDeviceAddressBindingReportFeaturesEXT* value, HandleUnwrapMemory* unwrap_memory);
VkDeviceAddressBindingCallbackDataEXT* TrackStruct(const VkDeviceAddressBindingCallbackDataEXT* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceDepthClipControlFeaturesEXT* TrackStruct(const VkPhysicalDeviceDepthClipControlFeaturesEXT* value, HandleUnwrapMemory* unwrap_memory);
VkPipelineViewportDepthClipControlCreateInfoEXT* TrackStruct(const VkPipelineViewportDepthClipControlCreateInfoEXT* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT* TrackStruct(const VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT* value, HandleUnwrapMemory* unwrap_memory);
VkImportMemoryZirconHandleInfoFUCHSIA* TrackStruct(const VkImportMemoryZirconHandleInfoFUCHSIA* value, HandleUnwrapMemory* unwrap_memory);
VkMemoryZirconHandlePropertiesFUCHSIA* TrackStruct(const VkMemoryZirconHandlePropertiesFUCHSIA* value, HandleUnwrapMemory* unwrap_memory);
VkMemoryGetZirconHandleInfoFUCHSIA* TrackStruct(const VkMemoryGetZirconHandleInfoFUCHSIA* value, HandleUnwrapMemory* unwrap_memory);
VkImportSemaphoreZirconHandleInfoFUCHSIA* TrackStruct(const VkImportSemaphoreZirconHandleInfoFUCHSIA* value, HandleUnwrapMemory* unwrap_memory);
VkSemaphoreGetZirconHandleInfoFUCHSIA* TrackStruct(const VkSemaphoreGetZirconHandleInfoFUCHSIA* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceInvocationMaskFeaturesHUAWEI* TrackStruct(const VkPhysicalDeviceInvocationMaskFeaturesHUAWEI* value, HandleUnwrapMemory* unwrap_memory);
VkMemoryGetRemoteAddressInfoNV* TrackStruct(const VkMemoryGetRemoteAddressInfoNV* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceExternalMemoryRDMAFeaturesNV* TrackStruct(const VkPhysicalDeviceExternalMemoryRDMAFeaturesNV* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceFrameBoundaryFeaturesEXT* TrackStruct(const VkPhysicalDeviceFrameBoundaryFeaturesEXT* value, HandleUnwrapMemory* unwrap_memory);
VkFrameBoundaryEXT* TrackStruct(const VkFrameBoundaryEXT* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceMultisampledRenderToSingleSampledFeaturesEXT* TrackStruct(const VkPhysicalDeviceMultisampledRenderToSingleSampledFeaturesEXT* value, HandleUnwrapMemory* unwrap_memory);
VkSubpassResolvePerformanceQueryEXT* TrackStruct(const VkSubpassResolvePerformanceQueryEXT* value, HandleUnwrapMemory* unwrap_memory);
VkMultisampledRenderToSingleSampledInfoEXT* TrackStruct(const VkMultisampledRenderToSingleSampledInfoEXT* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceExtendedDynamicState2FeaturesEXT* TrackStruct(const VkPhysicalDeviceExtendedDynamicState2FeaturesEXT* value, HandleUnwrapMemory* unwrap_memory);
VkScreenSurfaceCreateInfoQNX* TrackStruct(const VkScreenSurfaceCreateInfoQNX* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceColorWriteEnableFeaturesEXT* TrackStruct(const VkPhysicalDeviceColorWriteEnableFeaturesEXT* value, HandleUnwrapMemory* unwrap_memory);
VkPipelineColorWriteCreateInfoEXT* TrackStruct(const VkPipelineColorWriteCreateInfoEXT* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDevicePrimitivesGeneratedQueryFeaturesEXT* TrackStruct(const VkPhysicalDevicePrimitivesGeneratedQueryFeaturesEXT* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceImageViewMinLodFeaturesEXT* TrackStruct(const VkPhysicalDeviceImageViewMinLodFeaturesEXT* value, HandleUnwrapMemory* unwrap_memory);
VkImageViewMinLodCreateInfoEXT* TrackStruct(const VkImageViewMinLodCreateInfoEXT* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceMultiDrawFeaturesEXT* TrackStruct(const VkPhysicalDeviceMultiDrawFeaturesEXT* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceMultiDrawPropertiesEXT* TrackStruct(const VkPhysicalDeviceMultiDrawPropertiesEXT* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceImage2DViewOf3DFeaturesEXT* TrackStruct(const VkPhysicalDeviceImage2DViewOf3DFeaturesEXT* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceShaderTileImageFeaturesEXT* TrackStruct(const VkPhysicalDeviceShaderTileImageFeaturesEXT* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceShaderTileImagePropertiesEXT* TrackStruct(const VkPhysicalDeviceShaderTileImagePropertiesEXT* value, HandleUnwrapMemory* unwrap_memory);
VkMicromapBuildInfoEXT* TrackStruct(const VkMicromapBuildInfoEXT* value, HandleUnwrapMemory* unwrap_memory);
VkMicromapCreateInfoEXT* TrackStruct(const VkMicromapCreateInfoEXT* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceOpacityMicromapFeaturesEXT* TrackStruct(const VkPhysicalDeviceOpacityMicromapFeaturesEXT* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceOpacityMicromapPropertiesEXT* TrackStruct(const VkPhysicalDeviceOpacityMicromapPropertiesEXT* value, HandleUnwrapMemory* unwrap_memory);
VkMicromapVersionInfoEXT* TrackStruct(const VkMicromapVersionInfoEXT* value, HandleUnwrapMemory* unwrap_memory);
VkCopyMicromapToMemoryInfoEXT* TrackStruct(const VkCopyMicromapToMemoryInfoEXT* value, HandleUnwrapMemory* unwrap_memory);
VkCopyMemoryToMicromapInfoEXT* TrackStruct(const VkCopyMemoryToMicromapInfoEXT* value, HandleUnwrapMemory* unwrap_memory);
VkCopyMicromapInfoEXT* TrackStruct(const VkCopyMicromapInfoEXT* value, HandleUnwrapMemory* unwrap_memory);
VkMicromapBuildSizesInfoEXT* TrackStruct(const VkMicromapBuildSizesInfoEXT* value, HandleUnwrapMemory* unwrap_memory);
VkAccelerationStructureTrianglesOpacityMicromapEXT* TrackStruct(const VkAccelerationStructureTrianglesOpacityMicromapEXT* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceDisplacementMicromapFeaturesNV* TrackStruct(const VkPhysicalDeviceDisplacementMicromapFeaturesNV* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceDisplacementMicromapPropertiesNV* TrackStruct(const VkPhysicalDeviceDisplacementMicromapPropertiesNV* value, HandleUnwrapMemory* unwrap_memory);
VkAccelerationStructureTrianglesDisplacementMicromapNV* TrackStruct(const VkAccelerationStructureTrianglesDisplacementMicromapNV* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceClusterCullingShaderFeaturesHUAWEI* TrackStruct(const VkPhysicalDeviceClusterCullingShaderFeaturesHUAWEI* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceClusterCullingShaderPropertiesHUAWEI* TrackStruct(const VkPhysicalDeviceClusterCullingShaderPropertiesHUAWEI* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceClusterCullingShaderVrsFeaturesHUAWEI* TrackStruct(const VkPhysicalDeviceClusterCullingShaderVrsFeaturesHUAWEI* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceBorderColorSwizzleFeaturesEXT* TrackStruct(const VkPhysicalDeviceBorderColorSwizzleFeaturesEXT* value, HandleUnwrapMemory* unwrap_memory);
VkSamplerBorderColorComponentMappingCreateInfoEXT* TrackStruct(const VkSamplerBorderColorComponentMappingCreateInfoEXT* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDevicePageableDeviceLocalMemoryFeaturesEXT* TrackStruct(const VkPhysicalDevicePageableDeviceLocalMemoryFeaturesEXT* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceShaderCorePropertiesARM* TrackStruct(const VkPhysicalDeviceShaderCorePropertiesARM* value, HandleUnwrapMemory* unwrap_memory);
VkDeviceQueueShaderCoreControlCreateInfoARM* TrackStruct(const VkDeviceQueueShaderCoreControlCreateInfoARM* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceSchedulingControlsFeaturesARM* TrackStruct(const VkPhysicalDeviceSchedulingControlsFeaturesARM* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceSchedulingControlsPropertiesARM* TrackStruct(const VkPhysicalDeviceSchedulingControlsPropertiesARM* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceImageSlicedViewOf3DFeaturesEXT* TrackStruct(const VkPhysicalDeviceImageSlicedViewOf3DFeaturesEXT* value, HandleUnwrapMemory* unwrap_memory);
VkImageViewSlicedCreateInfoEXT* TrackStruct(const VkImageViewSlicedCreateInfoEXT* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceDescriptorSetHostMappingFeaturesVALVE* TrackStruct(const VkPhysicalDeviceDescriptorSetHostMappingFeaturesVALVE* value, HandleUnwrapMemory* unwrap_memory);
VkDescriptorSetBindingReferenceVALVE* TrackStruct(const VkDescriptorSetBindingReferenceVALVE* value, HandleUnwrapMemory* unwrap_memory);
VkDescriptorSetLayoutHostMappingInfoVALVE* TrackStruct(const VkDescriptorSetLayoutHostMappingInfoVALVE* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceDepthClampZeroOneFeaturesEXT* TrackStruct(const VkPhysicalDeviceDepthClampZeroOneFeaturesEXT* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceNonSeamlessCubeMapFeaturesEXT* TrackStruct(const VkPhysicalDeviceNonSeamlessCubeMapFeaturesEXT* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceRenderPassStripedFeaturesARM* TrackStruct(const VkPhysicalDeviceRenderPassStripedFeaturesARM* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceRenderPassStripedPropertiesARM* TrackStruct(const VkPhysicalDeviceRenderPassStripedPropertiesARM* value, HandleUnwrapMemory* unwrap_memory);
VkRenderPassStripeInfoARM* TrackStruct(const VkRenderPassStripeInfoARM* value, HandleUnwrapMemory* unwrap_memory);
VkRenderPassStripeBeginInfoARM* TrackStruct(const VkRenderPassStripeBeginInfoARM* value, HandleUnwrapMemory* unwrap_memory);
VkRenderPassStripeSubmitInfoARM* TrackStruct(const VkRenderPassStripeSubmitInfoARM* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceFragmentDensityMapOffsetFeaturesQCOM* TrackStruct(const VkPhysicalDeviceFragmentDensityMapOffsetFeaturesQCOM* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceFragmentDensityMapOffsetPropertiesQCOM* TrackStruct(const VkPhysicalDeviceFragmentDensityMapOffsetPropertiesQCOM* value, HandleUnwrapMemory* unwrap_memory);
VkSubpassFragmentDensityMapOffsetEndInfoQCOM* TrackStruct(const VkSubpassFragmentDensityMapOffsetEndInfoQCOM* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceDeviceGeneratedCommandsComputeFeaturesNV* TrackStruct(const VkPhysicalDeviceDeviceGeneratedCommandsComputeFeaturesNV* value, HandleUnwrapMemory* unwrap_memory);
VkComputePipelineIndirectBufferInfoNV* TrackStruct(const VkComputePipelineIndirectBufferInfoNV* value, HandleUnwrapMemory* unwrap_memory);
VkPipelineIndirectDeviceAddressInfoNV* TrackStruct(const VkPipelineIndirectDeviceAddressInfoNV* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceLinearColorAttachmentFeaturesNV* TrackStruct(const VkPhysicalDeviceLinearColorAttachmentFeaturesNV* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceImageCompressionControlSwapchainFeaturesEXT* TrackStruct(const VkPhysicalDeviceImageCompressionControlSwapchainFeaturesEXT* value, HandleUnwrapMemory* unwrap_memory);
VkImageViewSampleWeightCreateInfoQCOM* TrackStruct(const VkImageViewSampleWeightCreateInfoQCOM* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceImageProcessingFeaturesQCOM* TrackStruct(const VkPhysicalDeviceImageProcessingFeaturesQCOM* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceImageProcessingPropertiesQCOM* TrackStruct(const VkPhysicalDeviceImageProcessingPropertiesQCOM* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceNestedCommandBufferFeaturesEXT* TrackStruct(const VkPhysicalDeviceNestedCommandBufferFeaturesEXT* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceNestedCommandBufferPropertiesEXT* TrackStruct(const VkPhysicalDeviceNestedCommandBufferPropertiesEXT* value, HandleUnwrapMemory* unwrap_memory);
VkExternalMemoryAcquireUnmodifiedEXT* TrackStruct(const VkExternalMemoryAcquireUnmodifiedEXT* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceExtendedDynamicState3FeaturesEXT* TrackStruct(const VkPhysicalDeviceExtendedDynamicState3FeaturesEXT* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceExtendedDynamicState3PropertiesEXT* TrackStruct(const VkPhysicalDeviceExtendedDynamicState3PropertiesEXT* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceSubpassMergeFeedbackFeaturesEXT* TrackStruct(const VkPhysicalDeviceSubpassMergeFeedbackFeaturesEXT* value, HandleUnwrapMemory* unwrap_memory);
VkRenderPassCreationControlEXT* TrackStruct(const VkRenderPassCreationControlEXT* value, HandleUnwrapMemory* unwrap_memory);
VkRenderPassCreationFeedbackCreateInfoEXT* TrackStruct(const VkRenderPassCreationFeedbackCreateInfoEXT* value, HandleUnwrapMemory* unwrap_memory);
VkRenderPassSubpassFeedbackCreateInfoEXT* TrackStruct(const VkRenderPassSubpassFeedbackCreateInfoEXT* value, HandleUnwrapMemory* unwrap_memory);
VkDirectDriverLoadingInfoLUNARG* TrackStruct(const VkDirectDriverLoadingInfoLUNARG* value, HandleUnwrapMemory* unwrap_memory);
VkDirectDriverLoadingListLUNARG* TrackStruct(const VkDirectDriverLoadingListLUNARG* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceShaderModuleIdentifierFeaturesEXT* TrackStruct(const VkPhysicalDeviceShaderModuleIdentifierFeaturesEXT* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceShaderModuleIdentifierPropertiesEXT* TrackStruct(const VkPhysicalDeviceShaderModuleIdentifierPropertiesEXT* value, HandleUnwrapMemory* unwrap_memory);
VkPipelineShaderStageModuleIdentifierCreateInfoEXT* TrackStruct(const VkPipelineShaderStageModuleIdentifierCreateInfoEXT* value, HandleUnwrapMemory* unwrap_memory);
VkShaderModuleIdentifierEXT* TrackStruct(const VkShaderModuleIdentifierEXT* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceOpticalFlowFeaturesNV* TrackStruct(const VkPhysicalDeviceOpticalFlowFeaturesNV* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceOpticalFlowPropertiesNV* TrackStruct(const VkPhysicalDeviceOpticalFlowPropertiesNV* value, HandleUnwrapMemory* unwrap_memory);
VkOpticalFlowImageFormatInfoNV* TrackStruct(const VkOpticalFlowImageFormatInfoNV* value, HandleUnwrapMemory* unwrap_memory);
VkOpticalFlowImageFormatPropertiesNV* TrackStruct(const VkOpticalFlowImageFormatPropertiesNV* value, HandleUnwrapMemory* unwrap_memory);
VkOpticalFlowSessionCreateInfoNV* TrackStruct(const VkOpticalFlowSessionCreateInfoNV* value, HandleUnwrapMemory* unwrap_memory);
VkOpticalFlowSessionCreatePrivateDataInfoNV* TrackStruct(const VkOpticalFlowSessionCreatePrivateDataInfoNV* value, HandleUnwrapMemory* unwrap_memory);
VkOpticalFlowExecuteInfoNV* TrackStruct(const VkOpticalFlowExecuteInfoNV* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceLegacyDitheringFeaturesEXT* TrackStruct(const VkPhysicalDeviceLegacyDitheringFeaturesEXT* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDevicePipelineProtectedAccessFeaturesEXT* TrackStruct(const VkPhysicalDevicePipelineProtectedAccessFeaturesEXT* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceExternalFormatResolveFeaturesANDROID* TrackStruct(const VkPhysicalDeviceExternalFormatResolveFeaturesANDROID* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceExternalFormatResolvePropertiesANDROID* TrackStruct(const VkPhysicalDeviceExternalFormatResolvePropertiesANDROID* value, HandleUnwrapMemory* unwrap_memory);
VkAndroidHardwareBufferFormatResolvePropertiesANDROID* TrackStruct(const VkAndroidHardwareBufferFormatResolvePropertiesANDROID* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceShaderObjectFeaturesEXT* TrackStruct(const VkPhysicalDeviceShaderObjectFeaturesEXT* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceShaderObjectPropertiesEXT* TrackStruct(const VkPhysicalDeviceShaderObjectPropertiesEXT* value, HandleUnwrapMemory* unwrap_memory);
VkShaderCreateInfoEXT* TrackStruct(const VkShaderCreateInfoEXT* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceTilePropertiesFeaturesQCOM* TrackStruct(const VkPhysicalDeviceTilePropertiesFeaturesQCOM* value, HandleUnwrapMemory* unwrap_memory);
VkTilePropertiesQCOM* TrackStruct(const VkTilePropertiesQCOM* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceAmigoProfilingFeaturesSEC* TrackStruct(const VkPhysicalDeviceAmigoProfilingFeaturesSEC* value, HandleUnwrapMemory* unwrap_memory);
VkAmigoProfilingSubmitInfoSEC* TrackStruct(const VkAmigoProfilingSubmitInfoSEC* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceMultiviewPerViewViewportsFeaturesQCOM* TrackStruct(const VkPhysicalDeviceMultiviewPerViewViewportsFeaturesQCOM* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceRayTracingInvocationReorderPropertiesNV* TrackStruct(const VkPhysicalDeviceRayTracingInvocationReorderPropertiesNV* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceRayTracingInvocationReorderFeaturesNV* TrackStruct(const VkPhysicalDeviceRayTracingInvocationReorderFeaturesNV* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceExtendedSparseAddressSpaceFeaturesNV* TrackStruct(const VkPhysicalDeviceExtendedSparseAddressSpaceFeaturesNV* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceExtendedSparseAddressSpacePropertiesNV* TrackStruct(const VkPhysicalDeviceExtendedSparseAddressSpacePropertiesNV* value, HandleUnwrapMemory* unwrap_memory);
VkLayerSettingsCreateInfoEXT* TrackStruct(const VkLayerSettingsCreateInfoEXT* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceShaderCoreBuiltinsFeaturesARM* TrackStruct(const VkPhysicalDeviceShaderCoreBuiltinsFeaturesARM* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceShaderCoreBuiltinsPropertiesARM* TrackStruct(const VkPhysicalDeviceShaderCoreBuiltinsPropertiesARM* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDevicePipelineLibraryGroupHandlesFeaturesEXT* TrackStruct(const VkPhysicalDevicePipelineLibraryGroupHandlesFeaturesEXT* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceDynamicRenderingUnusedAttachmentsFeaturesEXT* TrackStruct(const VkPhysicalDeviceDynamicRenderingUnusedAttachmentsFeaturesEXT* value, HandleUnwrapMemory* unwrap_memory);
VkLatencySleepModeInfoNV* TrackStruct(const VkLatencySleepModeInfoNV* value, HandleUnwrapMemory* unwrap_memory);
VkLatencySleepInfoNV* TrackStruct(const VkLatencySleepInfoNV* value, HandleUnwrapMemory* unwrap_memory);
VkSetLatencyMarkerInfoNV* TrackStruct(const VkSetLatencyMarkerInfoNV* value, HandleUnwrapMemory* unwrap_memory);
VkLatencyTimingsFrameReportNV* TrackStruct(const VkLatencyTimingsFrameReportNV* value, HandleUnwrapMemory* unwrap_memory);
VkGetLatencyMarkerInfoNV* TrackStruct(const VkGetLatencyMarkerInfoNV* value, HandleUnwrapMemory* unwrap_memory);
VkLatencySubmissionPresentIdNV* TrackStruct(const VkLatencySubmissionPresentIdNV* value, HandleUnwrapMemory* unwrap_memory);
VkSwapchainLatencyCreateInfoNV* TrackStruct(const VkSwapchainLatencyCreateInfoNV* value, HandleUnwrapMemory* unwrap_memory);
VkOutOfBandQueueTypeInfoNV* TrackStruct(const VkOutOfBandQueueTypeInfoNV* value, HandleUnwrapMemory* unwrap_memory);
VkLatencySurfaceCapabilitiesNV* TrackStruct(const VkLatencySurfaceCapabilitiesNV* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceMultiviewPerViewRenderAreasFeaturesQCOM* TrackStruct(const VkPhysicalDeviceMultiviewPerViewRenderAreasFeaturesQCOM* value, HandleUnwrapMemory* unwrap_memory);
VkMultiviewPerViewRenderAreasRenderPassBeginInfoQCOM* TrackStruct(const VkMultiviewPerViewRenderAreasRenderPassBeginInfoQCOM* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDevicePerStageDescriptorSetFeaturesNV* TrackStruct(const VkPhysicalDevicePerStageDescriptorSetFeaturesNV* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceImageProcessing2FeaturesQCOM* TrackStruct(const VkPhysicalDeviceImageProcessing2FeaturesQCOM* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceImageProcessing2PropertiesQCOM* TrackStruct(const VkPhysicalDeviceImageProcessing2PropertiesQCOM* value, HandleUnwrapMemory* unwrap_memory);
VkSamplerBlockMatchWindowCreateInfoQCOM* TrackStruct(const VkSamplerBlockMatchWindowCreateInfoQCOM* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceCubicWeightsFeaturesQCOM* TrackStruct(const VkPhysicalDeviceCubicWeightsFeaturesQCOM* value, HandleUnwrapMemory* unwrap_memory);
VkSamplerCubicWeightsCreateInfoQCOM* TrackStruct(const VkSamplerCubicWeightsCreateInfoQCOM* value, HandleUnwrapMemory* unwrap_memory);
VkBlitImageCubicWeightsInfoQCOM* TrackStruct(const VkBlitImageCubicWeightsInfoQCOM* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceYcbcrDegammaFeaturesQCOM* TrackStruct(const VkPhysicalDeviceYcbcrDegammaFeaturesQCOM* value, HandleUnwrapMemory* unwrap_memory);
VkSamplerYcbcrConversionYcbcrDegammaCreateInfoQCOM* TrackStruct(const VkSamplerYcbcrConversionYcbcrDegammaCreateInfoQCOM* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceCubicClampFeaturesQCOM* TrackStruct(const VkPhysicalDeviceCubicClampFeaturesQCOM* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceAttachmentFeedbackLoopDynamicStateFeaturesEXT* TrackStruct(const VkPhysicalDeviceAttachmentFeedbackLoopDynamicStateFeaturesEXT* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceLayeredDriverPropertiesMSFT* TrackStruct(const VkPhysicalDeviceLayeredDriverPropertiesMSFT* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceDescriptorPoolOverallocationFeaturesNV* TrackStruct(const VkPhysicalDeviceDescriptorPoolOverallocationFeaturesNV* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceRawAccessChainsFeaturesNV* TrackStruct(const VkPhysicalDeviceRawAccessChainsFeaturesNV* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceShaderAtomicFloat16VectorFeaturesNV* TrackStruct(const VkPhysicalDeviceShaderAtomicFloat16VectorFeaturesNV* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceRayTracingValidationFeaturesNV* TrackStruct(const VkPhysicalDeviceRayTracingValidationFeaturesNV* value, HandleUnwrapMemory* unwrap_memory);
VkAccelerationStructureGeometryTrianglesDataKHR* TrackStruct(const VkAccelerationStructureGeometryTrianglesDataKHR* value, HandleUnwrapMemory* unwrap_memory);
VkAccelerationStructureGeometryAabbsDataKHR* TrackStruct(const VkAccelerationStructureGeometryAabbsDataKHR* value, HandleUnwrapMemory* unwrap_memory);
VkAccelerationStructureGeometryInstancesDataKHR* TrackStruct(const VkAccelerationStructureGeometryInstancesDataKHR* value, HandleUnwrapMemory* unwrap_memory);
VkAccelerationStructureGeometryKHR* TrackStruct(const VkAccelerationStructureGeometryKHR* value, HandleUnwrapMemory* unwrap_memory);
VkAccelerationStructureBuildGeometryInfoKHR* TrackStruct(const VkAccelerationStructureBuildGeometryInfoKHR* value, HandleUnwrapMemory* unwrap_memory);
VkAccelerationStructureCreateInfoKHR* TrackStruct(const VkAccelerationStructureCreateInfoKHR* value, HandleUnwrapMemory* unwrap_memory);
VkWriteDescriptorSetAccelerationStructureKHR* TrackStruct(const VkWriteDescriptorSetAccelerationStructureKHR* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceAccelerationStructureFeaturesKHR* TrackStruct(const VkPhysicalDeviceAccelerationStructureFeaturesKHR* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceAccelerationStructurePropertiesKHR* TrackStruct(const VkPhysicalDeviceAccelerationStructurePropertiesKHR* value, HandleUnwrapMemory* unwrap_memory);
VkAccelerationStructureDeviceAddressInfoKHR* TrackStruct(const VkAccelerationStructureDeviceAddressInfoKHR* value, HandleUnwrapMemory* unwrap_memory);
VkAccelerationStructureVersionInfoKHR* TrackStruct(const VkAccelerationStructureVersionInfoKHR* value, HandleUnwrapMemory* unwrap_memory);
VkCopyAccelerationStructureToMemoryInfoKHR* TrackStruct(const VkCopyAccelerationStructureToMemoryInfoKHR* value, HandleUnwrapMemory* unwrap_memory);
VkCopyMemoryToAccelerationStructureInfoKHR* TrackStruct(const VkCopyMemoryToAccelerationStructureInfoKHR* value, HandleUnwrapMemory* unwrap_memory);
VkCopyAccelerationStructureInfoKHR* TrackStruct(const VkCopyAccelerationStructureInfoKHR* value, HandleUnwrapMemory* unwrap_memory);
VkAccelerationStructureBuildSizesInfoKHR* TrackStruct(const VkAccelerationStructureBuildSizesInfoKHR* value, HandleUnwrapMemory* unwrap_memory);
VkRayTracingShaderGroupCreateInfoKHR* TrackStruct(const VkRayTracingShaderGroupCreateInfoKHR* value, HandleUnwrapMemory* unwrap_memory);
VkRayTracingPipelineInterfaceCreateInfoKHR* TrackStruct(const VkRayTracingPipelineInterfaceCreateInfoKHR* value, HandleUnwrapMemory* unwrap_memory);
VkRayTracingPipelineCreateInfoKHR* TrackStruct(const VkRayTracingPipelineCreateInfoKHR* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceRayTracingPipelineFeaturesKHR* TrackStruct(const VkPhysicalDeviceRayTracingPipelineFeaturesKHR* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceRayTracingPipelinePropertiesKHR* TrackStruct(const VkPhysicalDeviceRayTracingPipelinePropertiesKHR* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceRayQueryFeaturesKHR* TrackStruct(const VkPhysicalDeviceRayQueryFeaturesKHR* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceMeshShaderFeaturesEXT* TrackStruct(const VkPhysicalDeviceMeshShaderFeaturesEXT* value, HandleUnwrapMemory* unwrap_memory);
VkPhysicalDeviceMeshShaderPropertiesEXT* TrackStruct(const VkPhysicalDeviceMeshShaderPropertiesEXT* value, HandleUnwrapMemory* unwrap_memory);

void* TrackStruct(const void* value, HandleUnwrapMemory* unwrap_memory);

GFXRECON_END_NAMESPACE(encode)
GFXRECON_END_NAMESPACE(gfxrecon)
