/*
** Copyright (c) 2018-2021 Valve Corporation
** Copyright (c) 2018-2022 LunarG, Inc.
**
** Permission is hereby granted, free of charge, to any person obtaining a
** copy of this software and associated documentation files (the "Software"),
** to deal in the Software without restriction, including without limitation
** the rights to use, copy, modify, merge, publish, distribute, sublicense,
** and/or sell copies of the Software, and to permit persons to whom the
** Software is furnished to do so, subject to the following conditions:
**
** The above copyright notice and this permission notice shall be included in
** all copies or substantial portions of the Software.
**
** THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
** IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
** FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
** AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
** LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
** FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
** DEALINGS IN THE SOFTWARE.
*/

/*
** This file is generated from the Khronos Vulkan XML API Registry.
**
*/

#ifndef  GFXRECON_GENERATED_VULKAN_STRUCT_DECODERS_TO_STRING_H
#define  GFXRECON_GENERATED_VULKAN_STRUCT_DECODERS_TO_STRING_H

#include "format/platform_types.h"
#include "util/to_string.h"
#include "generated/generated_vulkan_struct_decoders.h"
#include "vulkan/vulkan.h"
GFXRECON_BEGIN_NAMESPACE(gfxrecon)
GFXRECON_BEGIN_NAMESPACE(util)
template <> std::string ToString<decode::Decoded_VkExtent2D>(const decode::Decoded_VkExtent2D& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkExtent3D>(const decode::Decoded_VkExtent3D& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkOffset2D>(const decode::Decoded_VkOffset2D& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkOffset3D>(const decode::Decoded_VkOffset3D& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkRect2D>(const decode::Decoded_VkRect2D& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkBufferMemoryBarrier>(const decode::Decoded_VkBufferMemoryBarrier& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkDispatchIndirectCommand>(const decode::Decoded_VkDispatchIndirectCommand& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkDrawIndexedIndirectCommand>(const decode::Decoded_VkDrawIndexedIndirectCommand& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkDrawIndirectCommand>(const decode::Decoded_VkDrawIndirectCommand& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkImageSubresourceRange>(const decode::Decoded_VkImageSubresourceRange& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkImageMemoryBarrier>(const decode::Decoded_VkImageMemoryBarrier& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkMemoryBarrier>(const decode::Decoded_VkMemoryBarrier& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPipelineCacheHeaderVersionOne>(const decode::Decoded_VkPipelineCacheHeaderVersionOne& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkAllocationCallbacks>(const decode::Decoded_VkAllocationCallbacks& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkApplicationInfo>(const decode::Decoded_VkApplicationInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkFormatProperties>(const decode::Decoded_VkFormatProperties& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkImageFormatProperties>(const decode::Decoded_VkImageFormatProperties& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkInstanceCreateInfo>(const decode::Decoded_VkInstanceCreateInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkMemoryHeap>(const decode::Decoded_VkMemoryHeap& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkMemoryType>(const decode::Decoded_VkMemoryType& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceFeatures>(const decode::Decoded_VkPhysicalDeviceFeatures& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceLimits>(const decode::Decoded_VkPhysicalDeviceLimits& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceMemoryProperties>(const decode::Decoded_VkPhysicalDeviceMemoryProperties& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceSparseProperties>(const decode::Decoded_VkPhysicalDeviceSparseProperties& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceProperties>(const decode::Decoded_VkPhysicalDeviceProperties& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkQueueFamilyProperties>(const decode::Decoded_VkQueueFamilyProperties& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkDeviceQueueCreateInfo>(const decode::Decoded_VkDeviceQueueCreateInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkDeviceCreateInfo>(const decode::Decoded_VkDeviceCreateInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkExtensionProperties>(const decode::Decoded_VkExtensionProperties& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkLayerProperties>(const decode::Decoded_VkLayerProperties& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkSubmitInfo>(const decode::Decoded_VkSubmitInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkMappedMemoryRange>(const decode::Decoded_VkMappedMemoryRange& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkMemoryAllocateInfo>(const decode::Decoded_VkMemoryAllocateInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkMemoryRequirements>(const decode::Decoded_VkMemoryRequirements& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkSparseMemoryBind>(const decode::Decoded_VkSparseMemoryBind& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkSparseBufferMemoryBindInfo>(const decode::Decoded_VkSparseBufferMemoryBindInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkSparseImageOpaqueMemoryBindInfo>(const decode::Decoded_VkSparseImageOpaqueMemoryBindInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkImageSubresource>(const decode::Decoded_VkImageSubresource& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkSparseImageMemoryBind>(const decode::Decoded_VkSparseImageMemoryBind& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkSparseImageMemoryBindInfo>(const decode::Decoded_VkSparseImageMemoryBindInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkBindSparseInfo>(const decode::Decoded_VkBindSparseInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkSparseImageFormatProperties>(const decode::Decoded_VkSparseImageFormatProperties& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkSparseImageMemoryRequirements>(const decode::Decoded_VkSparseImageMemoryRequirements& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkFenceCreateInfo>(const decode::Decoded_VkFenceCreateInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkSemaphoreCreateInfo>(const decode::Decoded_VkSemaphoreCreateInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkEventCreateInfo>(const decode::Decoded_VkEventCreateInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkQueryPoolCreateInfo>(const decode::Decoded_VkQueryPoolCreateInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkBufferCreateInfo>(const decode::Decoded_VkBufferCreateInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkBufferViewCreateInfo>(const decode::Decoded_VkBufferViewCreateInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkImageCreateInfo>(const decode::Decoded_VkImageCreateInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkSubresourceLayout>(const decode::Decoded_VkSubresourceLayout& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkComponentMapping>(const decode::Decoded_VkComponentMapping& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkImageViewCreateInfo>(const decode::Decoded_VkImageViewCreateInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkShaderModuleCreateInfo>(const decode::Decoded_VkShaderModuleCreateInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPipelineCacheCreateInfo>(const decode::Decoded_VkPipelineCacheCreateInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkSpecializationMapEntry>(const decode::Decoded_VkSpecializationMapEntry& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkSpecializationInfo>(const decode::Decoded_VkSpecializationInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPipelineShaderStageCreateInfo>(const decode::Decoded_VkPipelineShaderStageCreateInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkComputePipelineCreateInfo>(const decode::Decoded_VkComputePipelineCreateInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkVertexInputBindingDescription>(const decode::Decoded_VkVertexInputBindingDescription& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkVertexInputAttributeDescription>(const decode::Decoded_VkVertexInputAttributeDescription& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPipelineVertexInputStateCreateInfo>(const decode::Decoded_VkPipelineVertexInputStateCreateInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPipelineInputAssemblyStateCreateInfo>(const decode::Decoded_VkPipelineInputAssemblyStateCreateInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPipelineTessellationStateCreateInfo>(const decode::Decoded_VkPipelineTessellationStateCreateInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkViewport>(const decode::Decoded_VkViewport& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPipelineViewportStateCreateInfo>(const decode::Decoded_VkPipelineViewportStateCreateInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPipelineRasterizationStateCreateInfo>(const decode::Decoded_VkPipelineRasterizationStateCreateInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPipelineMultisampleStateCreateInfo>(const decode::Decoded_VkPipelineMultisampleStateCreateInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkStencilOpState>(const decode::Decoded_VkStencilOpState& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPipelineDepthStencilStateCreateInfo>(const decode::Decoded_VkPipelineDepthStencilStateCreateInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPipelineColorBlendAttachmentState>(const decode::Decoded_VkPipelineColorBlendAttachmentState& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPipelineColorBlendStateCreateInfo>(const decode::Decoded_VkPipelineColorBlendStateCreateInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPipelineDynamicStateCreateInfo>(const decode::Decoded_VkPipelineDynamicStateCreateInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkGraphicsPipelineCreateInfo>(const decode::Decoded_VkGraphicsPipelineCreateInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPushConstantRange>(const decode::Decoded_VkPushConstantRange& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPipelineLayoutCreateInfo>(const decode::Decoded_VkPipelineLayoutCreateInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkSamplerCreateInfo>(const decode::Decoded_VkSamplerCreateInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkCopyDescriptorSet>(const decode::Decoded_VkCopyDescriptorSet& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkDescriptorBufferInfo>(const decode::Decoded_VkDescriptorBufferInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkDescriptorPoolSize>(const decode::Decoded_VkDescriptorPoolSize& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkDescriptorPoolCreateInfo>(const decode::Decoded_VkDescriptorPoolCreateInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkDescriptorSetAllocateInfo>(const decode::Decoded_VkDescriptorSetAllocateInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkDescriptorSetLayoutBinding>(const decode::Decoded_VkDescriptorSetLayoutBinding& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkDescriptorSetLayoutCreateInfo>(const decode::Decoded_VkDescriptorSetLayoutCreateInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkAttachmentDescription>(const decode::Decoded_VkAttachmentDescription& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkAttachmentReference>(const decode::Decoded_VkAttachmentReference& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkFramebufferCreateInfo>(const decode::Decoded_VkFramebufferCreateInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkSubpassDescription>(const decode::Decoded_VkSubpassDescription& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkSubpassDependency>(const decode::Decoded_VkSubpassDependency& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkRenderPassCreateInfo>(const decode::Decoded_VkRenderPassCreateInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkCommandPoolCreateInfo>(const decode::Decoded_VkCommandPoolCreateInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkCommandBufferAllocateInfo>(const decode::Decoded_VkCommandBufferAllocateInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkCommandBufferInheritanceInfo>(const decode::Decoded_VkCommandBufferInheritanceInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkCommandBufferBeginInfo>(const decode::Decoded_VkCommandBufferBeginInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkBufferCopy>(const decode::Decoded_VkBufferCopy& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkImageSubresourceLayers>(const decode::Decoded_VkImageSubresourceLayers& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkBufferImageCopy>(const decode::Decoded_VkBufferImageCopy& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkClearDepthStencilValue>(const decode::Decoded_VkClearDepthStencilValue& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkClearAttachment>(const decode::Decoded_VkClearAttachment& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkClearRect>(const decode::Decoded_VkClearRect& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkImageBlit>(const decode::Decoded_VkImageBlit& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkImageCopy>(const decode::Decoded_VkImageCopy& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkImageResolve>(const decode::Decoded_VkImageResolve& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkRenderPassBeginInfo>(const decode::Decoded_VkRenderPassBeginInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceSubgroupProperties>(const decode::Decoded_VkPhysicalDeviceSubgroupProperties& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkBindBufferMemoryInfo>(const decode::Decoded_VkBindBufferMemoryInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkBindImageMemoryInfo>(const decode::Decoded_VkBindImageMemoryInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDevice16BitStorageFeatures>(const decode::Decoded_VkPhysicalDevice16BitStorageFeatures& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkMemoryDedicatedRequirements>(const decode::Decoded_VkMemoryDedicatedRequirements& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkMemoryDedicatedAllocateInfo>(const decode::Decoded_VkMemoryDedicatedAllocateInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkMemoryAllocateFlagsInfo>(const decode::Decoded_VkMemoryAllocateFlagsInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkDeviceGroupRenderPassBeginInfo>(const decode::Decoded_VkDeviceGroupRenderPassBeginInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkDeviceGroupCommandBufferBeginInfo>(const decode::Decoded_VkDeviceGroupCommandBufferBeginInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkDeviceGroupSubmitInfo>(const decode::Decoded_VkDeviceGroupSubmitInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkDeviceGroupBindSparseInfo>(const decode::Decoded_VkDeviceGroupBindSparseInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkBindBufferMemoryDeviceGroupInfo>(const decode::Decoded_VkBindBufferMemoryDeviceGroupInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkBindImageMemoryDeviceGroupInfo>(const decode::Decoded_VkBindImageMemoryDeviceGroupInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceGroupProperties>(const decode::Decoded_VkPhysicalDeviceGroupProperties& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkDeviceGroupDeviceCreateInfo>(const decode::Decoded_VkDeviceGroupDeviceCreateInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkBufferMemoryRequirementsInfo2>(const decode::Decoded_VkBufferMemoryRequirementsInfo2& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkImageMemoryRequirementsInfo2>(const decode::Decoded_VkImageMemoryRequirementsInfo2& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkImageSparseMemoryRequirementsInfo2>(const decode::Decoded_VkImageSparseMemoryRequirementsInfo2& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkMemoryRequirements2>(const decode::Decoded_VkMemoryRequirements2& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkSparseImageMemoryRequirements2>(const decode::Decoded_VkSparseImageMemoryRequirements2& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceFeatures2>(const decode::Decoded_VkPhysicalDeviceFeatures2& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceProperties2>(const decode::Decoded_VkPhysicalDeviceProperties2& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkFormatProperties2>(const decode::Decoded_VkFormatProperties2& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkImageFormatProperties2>(const decode::Decoded_VkImageFormatProperties2& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceImageFormatInfo2>(const decode::Decoded_VkPhysicalDeviceImageFormatInfo2& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkQueueFamilyProperties2>(const decode::Decoded_VkQueueFamilyProperties2& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceMemoryProperties2>(const decode::Decoded_VkPhysicalDeviceMemoryProperties2& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkSparseImageFormatProperties2>(const decode::Decoded_VkSparseImageFormatProperties2& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceSparseImageFormatInfo2>(const decode::Decoded_VkPhysicalDeviceSparseImageFormatInfo2& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDevicePointClippingProperties>(const decode::Decoded_VkPhysicalDevicePointClippingProperties& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkInputAttachmentAspectReference>(const decode::Decoded_VkInputAttachmentAspectReference& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkRenderPassInputAttachmentAspectCreateInfo>(const decode::Decoded_VkRenderPassInputAttachmentAspectCreateInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkImageViewUsageCreateInfo>(const decode::Decoded_VkImageViewUsageCreateInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPipelineTessellationDomainOriginStateCreateInfo>(const decode::Decoded_VkPipelineTessellationDomainOriginStateCreateInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkRenderPassMultiviewCreateInfo>(const decode::Decoded_VkRenderPassMultiviewCreateInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceMultiviewFeatures>(const decode::Decoded_VkPhysicalDeviceMultiviewFeatures& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceMultiviewProperties>(const decode::Decoded_VkPhysicalDeviceMultiviewProperties& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceVariablePointersFeatures>(const decode::Decoded_VkPhysicalDeviceVariablePointersFeatures& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceProtectedMemoryFeatures>(const decode::Decoded_VkPhysicalDeviceProtectedMemoryFeatures& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceProtectedMemoryProperties>(const decode::Decoded_VkPhysicalDeviceProtectedMemoryProperties& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkDeviceQueueInfo2>(const decode::Decoded_VkDeviceQueueInfo2& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkProtectedSubmitInfo>(const decode::Decoded_VkProtectedSubmitInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkSamplerYcbcrConversionCreateInfo>(const decode::Decoded_VkSamplerYcbcrConversionCreateInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkSamplerYcbcrConversionInfo>(const decode::Decoded_VkSamplerYcbcrConversionInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkBindImagePlaneMemoryInfo>(const decode::Decoded_VkBindImagePlaneMemoryInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkImagePlaneMemoryRequirementsInfo>(const decode::Decoded_VkImagePlaneMemoryRequirementsInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceSamplerYcbcrConversionFeatures>(const decode::Decoded_VkPhysicalDeviceSamplerYcbcrConversionFeatures& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkSamplerYcbcrConversionImageFormatProperties>(const decode::Decoded_VkSamplerYcbcrConversionImageFormatProperties& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkDescriptorUpdateTemplateEntry>(const decode::Decoded_VkDescriptorUpdateTemplateEntry& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkDescriptorUpdateTemplateCreateInfo>(const decode::Decoded_VkDescriptorUpdateTemplateCreateInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkExternalMemoryProperties>(const decode::Decoded_VkExternalMemoryProperties& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceExternalImageFormatInfo>(const decode::Decoded_VkPhysicalDeviceExternalImageFormatInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkExternalImageFormatProperties>(const decode::Decoded_VkExternalImageFormatProperties& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceExternalBufferInfo>(const decode::Decoded_VkPhysicalDeviceExternalBufferInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkExternalBufferProperties>(const decode::Decoded_VkExternalBufferProperties& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceIDProperties>(const decode::Decoded_VkPhysicalDeviceIDProperties& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkExternalMemoryImageCreateInfo>(const decode::Decoded_VkExternalMemoryImageCreateInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkExternalMemoryBufferCreateInfo>(const decode::Decoded_VkExternalMemoryBufferCreateInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkExportMemoryAllocateInfo>(const decode::Decoded_VkExportMemoryAllocateInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceExternalFenceInfo>(const decode::Decoded_VkPhysicalDeviceExternalFenceInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkExternalFenceProperties>(const decode::Decoded_VkExternalFenceProperties& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkExportFenceCreateInfo>(const decode::Decoded_VkExportFenceCreateInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkExportSemaphoreCreateInfo>(const decode::Decoded_VkExportSemaphoreCreateInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceExternalSemaphoreInfo>(const decode::Decoded_VkPhysicalDeviceExternalSemaphoreInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkExternalSemaphoreProperties>(const decode::Decoded_VkExternalSemaphoreProperties& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceMaintenance3Properties>(const decode::Decoded_VkPhysicalDeviceMaintenance3Properties& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkDescriptorSetLayoutSupport>(const decode::Decoded_VkDescriptorSetLayoutSupport& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceShaderDrawParametersFeatures>(const decode::Decoded_VkPhysicalDeviceShaderDrawParametersFeatures& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceVulkan11Features>(const decode::Decoded_VkPhysicalDeviceVulkan11Features& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceVulkan11Properties>(const decode::Decoded_VkPhysicalDeviceVulkan11Properties& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceVulkan12Features>(const decode::Decoded_VkPhysicalDeviceVulkan12Features& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkConformanceVersion>(const decode::Decoded_VkConformanceVersion& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceVulkan12Properties>(const decode::Decoded_VkPhysicalDeviceVulkan12Properties& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkImageFormatListCreateInfo>(const decode::Decoded_VkImageFormatListCreateInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkAttachmentDescription2>(const decode::Decoded_VkAttachmentDescription2& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkAttachmentReference2>(const decode::Decoded_VkAttachmentReference2& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkSubpassDescription2>(const decode::Decoded_VkSubpassDescription2& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkSubpassDependency2>(const decode::Decoded_VkSubpassDependency2& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkRenderPassCreateInfo2>(const decode::Decoded_VkRenderPassCreateInfo2& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkSubpassBeginInfo>(const decode::Decoded_VkSubpassBeginInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkSubpassEndInfo>(const decode::Decoded_VkSubpassEndInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDevice8BitStorageFeatures>(const decode::Decoded_VkPhysicalDevice8BitStorageFeatures& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceDriverProperties>(const decode::Decoded_VkPhysicalDeviceDriverProperties& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceShaderAtomicInt64Features>(const decode::Decoded_VkPhysicalDeviceShaderAtomicInt64Features& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceShaderFloat16Int8Features>(const decode::Decoded_VkPhysicalDeviceShaderFloat16Int8Features& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceFloatControlsProperties>(const decode::Decoded_VkPhysicalDeviceFloatControlsProperties& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkDescriptorSetLayoutBindingFlagsCreateInfo>(const decode::Decoded_VkDescriptorSetLayoutBindingFlagsCreateInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceDescriptorIndexingFeatures>(const decode::Decoded_VkPhysicalDeviceDescriptorIndexingFeatures& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceDescriptorIndexingProperties>(const decode::Decoded_VkPhysicalDeviceDescriptorIndexingProperties& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkDescriptorSetVariableDescriptorCountAllocateInfo>(const decode::Decoded_VkDescriptorSetVariableDescriptorCountAllocateInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkDescriptorSetVariableDescriptorCountLayoutSupport>(const decode::Decoded_VkDescriptorSetVariableDescriptorCountLayoutSupport& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkSubpassDescriptionDepthStencilResolve>(const decode::Decoded_VkSubpassDescriptionDepthStencilResolve& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceDepthStencilResolveProperties>(const decode::Decoded_VkPhysicalDeviceDepthStencilResolveProperties& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceScalarBlockLayoutFeatures>(const decode::Decoded_VkPhysicalDeviceScalarBlockLayoutFeatures& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkImageStencilUsageCreateInfo>(const decode::Decoded_VkImageStencilUsageCreateInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkSamplerReductionModeCreateInfo>(const decode::Decoded_VkSamplerReductionModeCreateInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceSamplerFilterMinmaxProperties>(const decode::Decoded_VkPhysicalDeviceSamplerFilterMinmaxProperties& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceVulkanMemoryModelFeatures>(const decode::Decoded_VkPhysicalDeviceVulkanMemoryModelFeatures& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceImagelessFramebufferFeatures>(const decode::Decoded_VkPhysicalDeviceImagelessFramebufferFeatures& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkFramebufferAttachmentImageInfo>(const decode::Decoded_VkFramebufferAttachmentImageInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkFramebufferAttachmentsCreateInfo>(const decode::Decoded_VkFramebufferAttachmentsCreateInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkRenderPassAttachmentBeginInfo>(const decode::Decoded_VkRenderPassAttachmentBeginInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceUniformBufferStandardLayoutFeatures>(const decode::Decoded_VkPhysicalDeviceUniformBufferStandardLayoutFeatures& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures>(const decode::Decoded_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures>(const decode::Decoded_VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkAttachmentReferenceStencilLayout>(const decode::Decoded_VkAttachmentReferenceStencilLayout& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkAttachmentDescriptionStencilLayout>(const decode::Decoded_VkAttachmentDescriptionStencilLayout& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceHostQueryResetFeatures>(const decode::Decoded_VkPhysicalDeviceHostQueryResetFeatures& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceTimelineSemaphoreFeatures>(const decode::Decoded_VkPhysicalDeviceTimelineSemaphoreFeatures& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceTimelineSemaphoreProperties>(const decode::Decoded_VkPhysicalDeviceTimelineSemaphoreProperties& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkSemaphoreTypeCreateInfo>(const decode::Decoded_VkSemaphoreTypeCreateInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkTimelineSemaphoreSubmitInfo>(const decode::Decoded_VkTimelineSemaphoreSubmitInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkSemaphoreWaitInfo>(const decode::Decoded_VkSemaphoreWaitInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkSemaphoreSignalInfo>(const decode::Decoded_VkSemaphoreSignalInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceBufferDeviceAddressFeatures>(const decode::Decoded_VkPhysicalDeviceBufferDeviceAddressFeatures& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkBufferDeviceAddressInfo>(const decode::Decoded_VkBufferDeviceAddressInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkBufferOpaqueCaptureAddressCreateInfo>(const decode::Decoded_VkBufferOpaqueCaptureAddressCreateInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkMemoryOpaqueCaptureAddressAllocateInfo>(const decode::Decoded_VkMemoryOpaqueCaptureAddressAllocateInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkDeviceMemoryOpaqueCaptureAddressInfo>(const decode::Decoded_VkDeviceMemoryOpaqueCaptureAddressInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceVulkan13Features>(const decode::Decoded_VkPhysicalDeviceVulkan13Features& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceVulkan13Properties>(const decode::Decoded_VkPhysicalDeviceVulkan13Properties& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPipelineCreationFeedback>(const decode::Decoded_VkPipelineCreationFeedback& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPipelineCreationFeedbackCreateInfo>(const decode::Decoded_VkPipelineCreationFeedbackCreateInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceShaderTerminateInvocationFeatures>(const decode::Decoded_VkPhysicalDeviceShaderTerminateInvocationFeatures& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceToolProperties>(const decode::Decoded_VkPhysicalDeviceToolProperties& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures>(const decode::Decoded_VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDevicePrivateDataFeatures>(const decode::Decoded_VkPhysicalDevicePrivateDataFeatures& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkDevicePrivateDataCreateInfo>(const decode::Decoded_VkDevicePrivateDataCreateInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPrivateDataSlotCreateInfo>(const decode::Decoded_VkPrivateDataSlotCreateInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDevicePipelineCreationCacheControlFeatures>(const decode::Decoded_VkPhysicalDevicePipelineCreationCacheControlFeatures& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkMemoryBarrier2>(const decode::Decoded_VkMemoryBarrier2& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkBufferMemoryBarrier2>(const decode::Decoded_VkBufferMemoryBarrier2& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkImageMemoryBarrier2>(const decode::Decoded_VkImageMemoryBarrier2& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkDependencyInfo>(const decode::Decoded_VkDependencyInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkSemaphoreSubmitInfo>(const decode::Decoded_VkSemaphoreSubmitInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkCommandBufferSubmitInfo>(const decode::Decoded_VkCommandBufferSubmitInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkSubmitInfo2>(const decode::Decoded_VkSubmitInfo2& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceSynchronization2Features>(const decode::Decoded_VkPhysicalDeviceSynchronization2Features& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures>(const decode::Decoded_VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceImageRobustnessFeatures>(const decode::Decoded_VkPhysicalDeviceImageRobustnessFeatures& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkBufferCopy2>(const decode::Decoded_VkBufferCopy2& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkCopyBufferInfo2>(const decode::Decoded_VkCopyBufferInfo2& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkImageCopy2>(const decode::Decoded_VkImageCopy2& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkCopyImageInfo2>(const decode::Decoded_VkCopyImageInfo2& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkBufferImageCopy2>(const decode::Decoded_VkBufferImageCopy2& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkCopyBufferToImageInfo2>(const decode::Decoded_VkCopyBufferToImageInfo2& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkCopyImageToBufferInfo2>(const decode::Decoded_VkCopyImageToBufferInfo2& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkImageBlit2>(const decode::Decoded_VkImageBlit2& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkBlitImageInfo2>(const decode::Decoded_VkBlitImageInfo2& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkImageResolve2>(const decode::Decoded_VkImageResolve2& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkResolveImageInfo2>(const decode::Decoded_VkResolveImageInfo2& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceSubgroupSizeControlFeatures>(const decode::Decoded_VkPhysicalDeviceSubgroupSizeControlFeatures& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceSubgroupSizeControlProperties>(const decode::Decoded_VkPhysicalDeviceSubgroupSizeControlProperties& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPipelineShaderStageRequiredSubgroupSizeCreateInfo>(const decode::Decoded_VkPipelineShaderStageRequiredSubgroupSizeCreateInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceInlineUniformBlockFeatures>(const decode::Decoded_VkPhysicalDeviceInlineUniformBlockFeatures& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceInlineUniformBlockProperties>(const decode::Decoded_VkPhysicalDeviceInlineUniformBlockProperties& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkWriteDescriptorSetInlineUniformBlock>(const decode::Decoded_VkWriteDescriptorSetInlineUniformBlock& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkDescriptorPoolInlineUniformBlockCreateInfo>(const decode::Decoded_VkDescriptorPoolInlineUniformBlockCreateInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceTextureCompressionASTCHDRFeatures>(const decode::Decoded_VkPhysicalDeviceTextureCompressionASTCHDRFeatures& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkRenderingAttachmentInfo>(const decode::Decoded_VkRenderingAttachmentInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkRenderingInfo>(const decode::Decoded_VkRenderingInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPipelineRenderingCreateInfo>(const decode::Decoded_VkPipelineRenderingCreateInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceDynamicRenderingFeatures>(const decode::Decoded_VkPhysicalDeviceDynamicRenderingFeatures& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkCommandBufferInheritanceRenderingInfo>(const decode::Decoded_VkCommandBufferInheritanceRenderingInfo& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceShaderIntegerDotProductFeatures>(const decode::Decoded_VkPhysicalDeviceShaderIntegerDotProductFeatures& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceShaderIntegerDotProductProperties>(const decode::Decoded_VkPhysicalDeviceShaderIntegerDotProductProperties& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceTexelBufferAlignmentProperties>(const decode::Decoded_VkPhysicalDeviceTexelBufferAlignmentProperties& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkFormatProperties3>(const decode::Decoded_VkFormatProperties3& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceMaintenance4Features>(const decode::Decoded_VkPhysicalDeviceMaintenance4Features& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceMaintenance4Properties>(const decode::Decoded_VkPhysicalDeviceMaintenance4Properties& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkDeviceBufferMemoryRequirements>(const decode::Decoded_VkDeviceBufferMemoryRequirements& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkDeviceImageMemoryRequirements>(const decode::Decoded_VkDeviceImageMemoryRequirements& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkSurfaceCapabilitiesKHR>(const decode::Decoded_VkSurfaceCapabilitiesKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkSurfaceFormatKHR>(const decode::Decoded_VkSurfaceFormatKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkSwapchainCreateInfoKHR>(const decode::Decoded_VkSwapchainCreateInfoKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPresentInfoKHR>(const decode::Decoded_VkPresentInfoKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkImageSwapchainCreateInfoKHR>(const decode::Decoded_VkImageSwapchainCreateInfoKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkBindImageMemorySwapchainInfoKHR>(const decode::Decoded_VkBindImageMemorySwapchainInfoKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkAcquireNextImageInfoKHR>(const decode::Decoded_VkAcquireNextImageInfoKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkDeviceGroupPresentCapabilitiesKHR>(const decode::Decoded_VkDeviceGroupPresentCapabilitiesKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkDeviceGroupPresentInfoKHR>(const decode::Decoded_VkDeviceGroupPresentInfoKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkDeviceGroupSwapchainCreateInfoKHR>(const decode::Decoded_VkDeviceGroupSwapchainCreateInfoKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkDisplayModeParametersKHR>(const decode::Decoded_VkDisplayModeParametersKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkDisplayModeCreateInfoKHR>(const decode::Decoded_VkDisplayModeCreateInfoKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkDisplayModePropertiesKHR>(const decode::Decoded_VkDisplayModePropertiesKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkDisplayPlaneCapabilitiesKHR>(const decode::Decoded_VkDisplayPlaneCapabilitiesKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkDisplayPlanePropertiesKHR>(const decode::Decoded_VkDisplayPlanePropertiesKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkDisplayPropertiesKHR>(const decode::Decoded_VkDisplayPropertiesKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkDisplaySurfaceCreateInfoKHR>(const decode::Decoded_VkDisplaySurfaceCreateInfoKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkDisplayPresentInfoKHR>(const decode::Decoded_VkDisplayPresentInfoKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkXlibSurfaceCreateInfoKHR>(const decode::Decoded_VkXlibSurfaceCreateInfoKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkXcbSurfaceCreateInfoKHR>(const decode::Decoded_VkXcbSurfaceCreateInfoKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkWaylandSurfaceCreateInfoKHR>(const decode::Decoded_VkWaylandSurfaceCreateInfoKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkAndroidSurfaceCreateInfoKHR>(const decode::Decoded_VkAndroidSurfaceCreateInfoKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkWin32SurfaceCreateInfoKHR>(const decode::Decoded_VkWin32SurfaceCreateInfoKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkRenderingFragmentShadingRateAttachmentInfoKHR>(const decode::Decoded_VkRenderingFragmentShadingRateAttachmentInfoKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkRenderingFragmentDensityMapAttachmentInfoEXT>(const decode::Decoded_VkRenderingFragmentDensityMapAttachmentInfoEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkAttachmentSampleCountInfoAMD>(const decode::Decoded_VkAttachmentSampleCountInfoAMD& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkMultiviewPerViewAttributesInfoNVX>(const decode::Decoded_VkMultiviewPerViewAttributesInfoNVX& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkImportMemoryWin32HandleInfoKHR>(const decode::Decoded_VkImportMemoryWin32HandleInfoKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkExportMemoryWin32HandleInfoKHR>(const decode::Decoded_VkExportMemoryWin32HandleInfoKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkMemoryWin32HandlePropertiesKHR>(const decode::Decoded_VkMemoryWin32HandlePropertiesKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkMemoryGetWin32HandleInfoKHR>(const decode::Decoded_VkMemoryGetWin32HandleInfoKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkImportMemoryFdInfoKHR>(const decode::Decoded_VkImportMemoryFdInfoKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkMemoryFdPropertiesKHR>(const decode::Decoded_VkMemoryFdPropertiesKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkMemoryGetFdInfoKHR>(const decode::Decoded_VkMemoryGetFdInfoKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkWin32KeyedMutexAcquireReleaseInfoKHR>(const decode::Decoded_VkWin32KeyedMutexAcquireReleaseInfoKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkImportSemaphoreWin32HandleInfoKHR>(const decode::Decoded_VkImportSemaphoreWin32HandleInfoKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkExportSemaphoreWin32HandleInfoKHR>(const decode::Decoded_VkExportSemaphoreWin32HandleInfoKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkD3D12FenceSubmitInfoKHR>(const decode::Decoded_VkD3D12FenceSubmitInfoKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkSemaphoreGetWin32HandleInfoKHR>(const decode::Decoded_VkSemaphoreGetWin32HandleInfoKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkImportSemaphoreFdInfoKHR>(const decode::Decoded_VkImportSemaphoreFdInfoKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkSemaphoreGetFdInfoKHR>(const decode::Decoded_VkSemaphoreGetFdInfoKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDevicePushDescriptorPropertiesKHR>(const decode::Decoded_VkPhysicalDevicePushDescriptorPropertiesKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkRectLayerKHR>(const decode::Decoded_VkRectLayerKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPresentRegionKHR>(const decode::Decoded_VkPresentRegionKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPresentRegionsKHR>(const decode::Decoded_VkPresentRegionsKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkSharedPresentSurfaceCapabilitiesKHR>(const decode::Decoded_VkSharedPresentSurfaceCapabilitiesKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkImportFenceWin32HandleInfoKHR>(const decode::Decoded_VkImportFenceWin32HandleInfoKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkExportFenceWin32HandleInfoKHR>(const decode::Decoded_VkExportFenceWin32HandleInfoKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkFenceGetWin32HandleInfoKHR>(const decode::Decoded_VkFenceGetWin32HandleInfoKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkImportFenceFdInfoKHR>(const decode::Decoded_VkImportFenceFdInfoKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkFenceGetFdInfoKHR>(const decode::Decoded_VkFenceGetFdInfoKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDevicePerformanceQueryFeaturesKHR>(const decode::Decoded_VkPhysicalDevicePerformanceQueryFeaturesKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDevicePerformanceQueryPropertiesKHR>(const decode::Decoded_VkPhysicalDevicePerformanceQueryPropertiesKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPerformanceCounterKHR>(const decode::Decoded_VkPerformanceCounterKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPerformanceCounterDescriptionKHR>(const decode::Decoded_VkPerformanceCounterDescriptionKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkQueryPoolPerformanceCreateInfoKHR>(const decode::Decoded_VkQueryPoolPerformanceCreateInfoKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkAcquireProfilingLockInfoKHR>(const decode::Decoded_VkAcquireProfilingLockInfoKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPerformanceQuerySubmitInfoKHR>(const decode::Decoded_VkPerformanceQuerySubmitInfoKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceSurfaceInfo2KHR>(const decode::Decoded_VkPhysicalDeviceSurfaceInfo2KHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkSurfaceCapabilities2KHR>(const decode::Decoded_VkSurfaceCapabilities2KHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkSurfaceFormat2KHR>(const decode::Decoded_VkSurfaceFormat2KHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkDisplayProperties2KHR>(const decode::Decoded_VkDisplayProperties2KHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkDisplayPlaneProperties2KHR>(const decode::Decoded_VkDisplayPlaneProperties2KHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkDisplayModeProperties2KHR>(const decode::Decoded_VkDisplayModeProperties2KHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkDisplayPlaneInfo2KHR>(const decode::Decoded_VkDisplayPlaneInfo2KHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkDisplayPlaneCapabilities2KHR>(const decode::Decoded_VkDisplayPlaneCapabilities2KHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDevicePortabilitySubsetFeaturesKHR>(const decode::Decoded_VkPhysicalDevicePortabilitySubsetFeaturesKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDevicePortabilitySubsetPropertiesKHR>(const decode::Decoded_VkPhysicalDevicePortabilitySubsetPropertiesKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceShaderClockFeaturesKHR>(const decode::Decoded_VkPhysicalDeviceShaderClockFeaturesKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkDeviceQueueGlobalPriorityCreateInfoKHR>(const decode::Decoded_VkDeviceQueueGlobalPriorityCreateInfoKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceGlobalPriorityQueryFeaturesKHR>(const decode::Decoded_VkPhysicalDeviceGlobalPriorityQueryFeaturesKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkQueueFamilyGlobalPriorityPropertiesKHR>(const decode::Decoded_VkQueueFamilyGlobalPriorityPropertiesKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkFragmentShadingRateAttachmentInfoKHR>(const decode::Decoded_VkFragmentShadingRateAttachmentInfoKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPipelineFragmentShadingRateStateCreateInfoKHR>(const decode::Decoded_VkPipelineFragmentShadingRateStateCreateInfoKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceFragmentShadingRateFeaturesKHR>(const decode::Decoded_VkPhysicalDeviceFragmentShadingRateFeaturesKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceFragmentShadingRatePropertiesKHR>(const decode::Decoded_VkPhysicalDeviceFragmentShadingRatePropertiesKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceFragmentShadingRateKHR>(const decode::Decoded_VkPhysicalDeviceFragmentShadingRateKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkSurfaceProtectedCapabilitiesKHR>(const decode::Decoded_VkSurfaceProtectedCapabilitiesKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDevicePresentWaitFeaturesKHR>(const decode::Decoded_VkPhysicalDevicePresentWaitFeaturesKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDevicePipelineExecutablePropertiesFeaturesKHR>(const decode::Decoded_VkPhysicalDevicePipelineExecutablePropertiesFeaturesKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPipelineInfoKHR>(const decode::Decoded_VkPipelineInfoKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPipelineExecutablePropertiesKHR>(const decode::Decoded_VkPipelineExecutablePropertiesKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPipelineExecutableInfoKHR>(const decode::Decoded_VkPipelineExecutableInfoKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPipelineExecutableStatisticKHR>(const decode::Decoded_VkPipelineExecutableStatisticKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPipelineExecutableInternalRepresentationKHR>(const decode::Decoded_VkPipelineExecutableInternalRepresentationKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPipelineLibraryCreateInfoKHR>(const decode::Decoded_VkPipelineLibraryCreateInfoKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPresentIdKHR>(const decode::Decoded_VkPresentIdKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDevicePresentIdFeaturesKHR>(const decode::Decoded_VkPhysicalDevicePresentIdFeaturesKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkQueueFamilyCheckpointProperties2NV>(const decode::Decoded_VkQueueFamilyCheckpointProperties2NV& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkCheckpointData2NV>(const decode::Decoded_VkCheckpointData2NV& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceFragmentShaderBarycentricFeaturesKHR>(const decode::Decoded_VkPhysicalDeviceFragmentShaderBarycentricFeaturesKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceFragmentShaderBarycentricPropertiesKHR>(const decode::Decoded_VkPhysicalDeviceFragmentShaderBarycentricPropertiesKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceShaderSubgroupUniformControlFlowFeaturesKHR>(const decode::Decoded_VkPhysicalDeviceShaderSubgroupUniformControlFlowFeaturesKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceWorkgroupMemoryExplicitLayoutFeaturesKHR>(const decode::Decoded_VkPhysicalDeviceWorkgroupMemoryExplicitLayoutFeaturesKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceRayTracingMaintenance1FeaturesKHR>(const decode::Decoded_VkPhysicalDeviceRayTracingMaintenance1FeaturesKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkTraceRaysIndirectCommand2KHR>(const decode::Decoded_VkTraceRaysIndirectCommand2KHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkDebugReportCallbackCreateInfoEXT>(const decode::Decoded_VkDebugReportCallbackCreateInfoEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPipelineRasterizationStateRasterizationOrderAMD>(const decode::Decoded_VkPipelineRasterizationStateRasterizationOrderAMD& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkDebugMarkerObjectNameInfoEXT>(const decode::Decoded_VkDebugMarkerObjectNameInfoEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkDebugMarkerObjectTagInfoEXT>(const decode::Decoded_VkDebugMarkerObjectTagInfoEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkDebugMarkerMarkerInfoEXT>(const decode::Decoded_VkDebugMarkerMarkerInfoEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkDedicatedAllocationImageCreateInfoNV>(const decode::Decoded_VkDedicatedAllocationImageCreateInfoNV& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkDedicatedAllocationBufferCreateInfoNV>(const decode::Decoded_VkDedicatedAllocationBufferCreateInfoNV& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkDedicatedAllocationMemoryAllocateInfoNV>(const decode::Decoded_VkDedicatedAllocationMemoryAllocateInfoNV& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceTransformFeedbackFeaturesEXT>(const decode::Decoded_VkPhysicalDeviceTransformFeedbackFeaturesEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceTransformFeedbackPropertiesEXT>(const decode::Decoded_VkPhysicalDeviceTransformFeedbackPropertiesEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPipelineRasterizationStateStreamCreateInfoEXT>(const decode::Decoded_VkPipelineRasterizationStateStreamCreateInfoEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkImageViewHandleInfoNVX>(const decode::Decoded_VkImageViewHandleInfoNVX& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkImageViewAddressPropertiesNVX>(const decode::Decoded_VkImageViewAddressPropertiesNVX& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkTextureLODGatherFormatPropertiesAMD>(const decode::Decoded_VkTextureLODGatherFormatPropertiesAMD& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkShaderResourceUsageAMD>(const decode::Decoded_VkShaderResourceUsageAMD& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkShaderStatisticsInfoAMD>(const decode::Decoded_VkShaderStatisticsInfoAMD& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkStreamDescriptorSurfaceCreateInfoGGP>(const decode::Decoded_VkStreamDescriptorSurfaceCreateInfoGGP& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceCornerSampledImageFeaturesNV>(const decode::Decoded_VkPhysicalDeviceCornerSampledImageFeaturesNV& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkExternalImageFormatPropertiesNV>(const decode::Decoded_VkExternalImageFormatPropertiesNV& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkExternalMemoryImageCreateInfoNV>(const decode::Decoded_VkExternalMemoryImageCreateInfoNV& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkExportMemoryAllocateInfoNV>(const decode::Decoded_VkExportMemoryAllocateInfoNV& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkImportMemoryWin32HandleInfoNV>(const decode::Decoded_VkImportMemoryWin32HandleInfoNV& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkExportMemoryWin32HandleInfoNV>(const decode::Decoded_VkExportMemoryWin32HandleInfoNV& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkWin32KeyedMutexAcquireReleaseInfoNV>(const decode::Decoded_VkWin32KeyedMutexAcquireReleaseInfoNV& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkValidationFlagsEXT>(const decode::Decoded_VkValidationFlagsEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkViSurfaceCreateInfoNN>(const decode::Decoded_VkViSurfaceCreateInfoNN& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkImageViewASTCDecodeModeEXT>(const decode::Decoded_VkImageViewASTCDecodeModeEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceASTCDecodeFeaturesEXT>(const decode::Decoded_VkPhysicalDeviceASTCDecodeFeaturesEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDevicePipelineRobustnessFeaturesEXT>(const decode::Decoded_VkPhysicalDevicePipelineRobustnessFeaturesEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDevicePipelineRobustnessPropertiesEXT>(const decode::Decoded_VkPhysicalDevicePipelineRobustnessPropertiesEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPipelineRobustnessCreateInfoEXT>(const decode::Decoded_VkPipelineRobustnessCreateInfoEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkConditionalRenderingBeginInfoEXT>(const decode::Decoded_VkConditionalRenderingBeginInfoEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceConditionalRenderingFeaturesEXT>(const decode::Decoded_VkPhysicalDeviceConditionalRenderingFeaturesEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkCommandBufferInheritanceConditionalRenderingInfoEXT>(const decode::Decoded_VkCommandBufferInheritanceConditionalRenderingInfoEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkViewportWScalingNV>(const decode::Decoded_VkViewportWScalingNV& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPipelineViewportWScalingStateCreateInfoNV>(const decode::Decoded_VkPipelineViewportWScalingStateCreateInfoNV& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkSurfaceCapabilities2EXT>(const decode::Decoded_VkSurfaceCapabilities2EXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkDisplayPowerInfoEXT>(const decode::Decoded_VkDisplayPowerInfoEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkDeviceEventInfoEXT>(const decode::Decoded_VkDeviceEventInfoEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkDisplayEventInfoEXT>(const decode::Decoded_VkDisplayEventInfoEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkSwapchainCounterCreateInfoEXT>(const decode::Decoded_VkSwapchainCounterCreateInfoEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkRefreshCycleDurationGOOGLE>(const decode::Decoded_VkRefreshCycleDurationGOOGLE& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPastPresentationTimingGOOGLE>(const decode::Decoded_VkPastPresentationTimingGOOGLE& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPresentTimeGOOGLE>(const decode::Decoded_VkPresentTimeGOOGLE& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPresentTimesInfoGOOGLE>(const decode::Decoded_VkPresentTimesInfoGOOGLE& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceMultiviewPerViewAttributesPropertiesNVX>(const decode::Decoded_VkPhysicalDeviceMultiviewPerViewAttributesPropertiesNVX& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkViewportSwizzleNV>(const decode::Decoded_VkViewportSwizzleNV& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPipelineViewportSwizzleStateCreateInfoNV>(const decode::Decoded_VkPipelineViewportSwizzleStateCreateInfoNV& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceDiscardRectanglePropertiesEXT>(const decode::Decoded_VkPhysicalDeviceDiscardRectanglePropertiesEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPipelineDiscardRectangleStateCreateInfoEXT>(const decode::Decoded_VkPipelineDiscardRectangleStateCreateInfoEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceConservativeRasterizationPropertiesEXT>(const decode::Decoded_VkPhysicalDeviceConservativeRasterizationPropertiesEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPipelineRasterizationConservativeStateCreateInfoEXT>(const decode::Decoded_VkPipelineRasterizationConservativeStateCreateInfoEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceDepthClipEnableFeaturesEXT>(const decode::Decoded_VkPhysicalDeviceDepthClipEnableFeaturesEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPipelineRasterizationDepthClipStateCreateInfoEXT>(const decode::Decoded_VkPipelineRasterizationDepthClipStateCreateInfoEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkXYColorEXT>(const decode::Decoded_VkXYColorEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkHdrMetadataEXT>(const decode::Decoded_VkHdrMetadataEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkIOSSurfaceCreateInfoMVK>(const decode::Decoded_VkIOSSurfaceCreateInfoMVK& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkMacOSSurfaceCreateInfoMVK>(const decode::Decoded_VkMacOSSurfaceCreateInfoMVK& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkDebugUtilsLabelEXT>(const decode::Decoded_VkDebugUtilsLabelEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkDebugUtilsObjectNameInfoEXT>(const decode::Decoded_VkDebugUtilsObjectNameInfoEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkDebugUtilsMessengerCallbackDataEXT>(const decode::Decoded_VkDebugUtilsMessengerCallbackDataEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkDebugUtilsMessengerCreateInfoEXT>(const decode::Decoded_VkDebugUtilsMessengerCreateInfoEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkDebugUtilsObjectTagInfoEXT>(const decode::Decoded_VkDebugUtilsObjectTagInfoEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkAndroidHardwareBufferUsageANDROID>(const decode::Decoded_VkAndroidHardwareBufferUsageANDROID& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkAndroidHardwareBufferPropertiesANDROID>(const decode::Decoded_VkAndroidHardwareBufferPropertiesANDROID& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkAndroidHardwareBufferFormatPropertiesANDROID>(const decode::Decoded_VkAndroidHardwareBufferFormatPropertiesANDROID& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkImportAndroidHardwareBufferInfoANDROID>(const decode::Decoded_VkImportAndroidHardwareBufferInfoANDROID& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkMemoryGetAndroidHardwareBufferInfoANDROID>(const decode::Decoded_VkMemoryGetAndroidHardwareBufferInfoANDROID& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkExternalFormatANDROID>(const decode::Decoded_VkExternalFormatANDROID& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkAndroidHardwareBufferFormatProperties2ANDROID>(const decode::Decoded_VkAndroidHardwareBufferFormatProperties2ANDROID& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkSampleLocationEXT>(const decode::Decoded_VkSampleLocationEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkSampleLocationsInfoEXT>(const decode::Decoded_VkSampleLocationsInfoEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkAttachmentSampleLocationsEXT>(const decode::Decoded_VkAttachmentSampleLocationsEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkSubpassSampleLocationsEXT>(const decode::Decoded_VkSubpassSampleLocationsEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkRenderPassSampleLocationsBeginInfoEXT>(const decode::Decoded_VkRenderPassSampleLocationsBeginInfoEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPipelineSampleLocationsStateCreateInfoEXT>(const decode::Decoded_VkPipelineSampleLocationsStateCreateInfoEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceSampleLocationsPropertiesEXT>(const decode::Decoded_VkPhysicalDeviceSampleLocationsPropertiesEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkMultisamplePropertiesEXT>(const decode::Decoded_VkMultisamplePropertiesEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceBlendOperationAdvancedFeaturesEXT>(const decode::Decoded_VkPhysicalDeviceBlendOperationAdvancedFeaturesEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT>(const decode::Decoded_VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPipelineColorBlendAdvancedStateCreateInfoEXT>(const decode::Decoded_VkPipelineColorBlendAdvancedStateCreateInfoEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPipelineCoverageToColorStateCreateInfoNV>(const decode::Decoded_VkPipelineCoverageToColorStateCreateInfoNV& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPipelineCoverageModulationStateCreateInfoNV>(const decode::Decoded_VkPipelineCoverageModulationStateCreateInfoNV& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceShaderSMBuiltinsPropertiesNV>(const decode::Decoded_VkPhysicalDeviceShaderSMBuiltinsPropertiesNV& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceShaderSMBuiltinsFeaturesNV>(const decode::Decoded_VkPhysicalDeviceShaderSMBuiltinsFeaturesNV& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkDrmFormatModifierPropertiesEXT>(const decode::Decoded_VkDrmFormatModifierPropertiesEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkDrmFormatModifierPropertiesListEXT>(const decode::Decoded_VkDrmFormatModifierPropertiesListEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceImageDrmFormatModifierInfoEXT>(const decode::Decoded_VkPhysicalDeviceImageDrmFormatModifierInfoEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkImageDrmFormatModifierListCreateInfoEXT>(const decode::Decoded_VkImageDrmFormatModifierListCreateInfoEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkImageDrmFormatModifierExplicitCreateInfoEXT>(const decode::Decoded_VkImageDrmFormatModifierExplicitCreateInfoEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkImageDrmFormatModifierPropertiesEXT>(const decode::Decoded_VkImageDrmFormatModifierPropertiesEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkDrmFormatModifierProperties2EXT>(const decode::Decoded_VkDrmFormatModifierProperties2EXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkDrmFormatModifierPropertiesList2EXT>(const decode::Decoded_VkDrmFormatModifierPropertiesList2EXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkValidationCacheCreateInfoEXT>(const decode::Decoded_VkValidationCacheCreateInfoEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkShaderModuleValidationCacheCreateInfoEXT>(const decode::Decoded_VkShaderModuleValidationCacheCreateInfoEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkShadingRatePaletteNV>(const decode::Decoded_VkShadingRatePaletteNV& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPipelineViewportShadingRateImageStateCreateInfoNV>(const decode::Decoded_VkPipelineViewportShadingRateImageStateCreateInfoNV& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceShadingRateImageFeaturesNV>(const decode::Decoded_VkPhysicalDeviceShadingRateImageFeaturesNV& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceShadingRateImagePropertiesNV>(const decode::Decoded_VkPhysicalDeviceShadingRateImagePropertiesNV& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkCoarseSampleLocationNV>(const decode::Decoded_VkCoarseSampleLocationNV& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkCoarseSampleOrderCustomNV>(const decode::Decoded_VkCoarseSampleOrderCustomNV& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPipelineViewportCoarseSampleOrderStateCreateInfoNV>(const decode::Decoded_VkPipelineViewportCoarseSampleOrderStateCreateInfoNV& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkRayTracingShaderGroupCreateInfoNV>(const decode::Decoded_VkRayTracingShaderGroupCreateInfoNV& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkRayTracingPipelineCreateInfoNV>(const decode::Decoded_VkRayTracingPipelineCreateInfoNV& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkGeometryTrianglesNV>(const decode::Decoded_VkGeometryTrianglesNV& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkGeometryAABBNV>(const decode::Decoded_VkGeometryAABBNV& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkGeometryDataNV>(const decode::Decoded_VkGeometryDataNV& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkGeometryNV>(const decode::Decoded_VkGeometryNV& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkAccelerationStructureInfoNV>(const decode::Decoded_VkAccelerationStructureInfoNV& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkAccelerationStructureCreateInfoNV>(const decode::Decoded_VkAccelerationStructureCreateInfoNV& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkBindAccelerationStructureMemoryInfoNV>(const decode::Decoded_VkBindAccelerationStructureMemoryInfoNV& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkWriteDescriptorSetAccelerationStructureNV>(const decode::Decoded_VkWriteDescriptorSetAccelerationStructureNV& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkAccelerationStructureMemoryRequirementsInfoNV>(const decode::Decoded_VkAccelerationStructureMemoryRequirementsInfoNV& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceRayTracingPropertiesNV>(const decode::Decoded_VkPhysicalDeviceRayTracingPropertiesNV& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkTransformMatrixKHR>(const decode::Decoded_VkTransformMatrixKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkAabbPositionsKHR>(const decode::Decoded_VkAabbPositionsKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkAccelerationStructureInstanceKHR>(const decode::Decoded_VkAccelerationStructureInstanceKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceRepresentativeFragmentTestFeaturesNV>(const decode::Decoded_VkPhysicalDeviceRepresentativeFragmentTestFeaturesNV& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPipelineRepresentativeFragmentTestStateCreateInfoNV>(const decode::Decoded_VkPipelineRepresentativeFragmentTestStateCreateInfoNV& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceImageViewImageFormatInfoEXT>(const decode::Decoded_VkPhysicalDeviceImageViewImageFormatInfoEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkFilterCubicImageViewImageFormatPropertiesEXT>(const decode::Decoded_VkFilterCubicImageViewImageFormatPropertiesEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkImportMemoryHostPointerInfoEXT>(const decode::Decoded_VkImportMemoryHostPointerInfoEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkMemoryHostPointerPropertiesEXT>(const decode::Decoded_VkMemoryHostPointerPropertiesEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceExternalMemoryHostPropertiesEXT>(const decode::Decoded_VkPhysicalDeviceExternalMemoryHostPropertiesEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPipelineCompilerControlCreateInfoAMD>(const decode::Decoded_VkPipelineCompilerControlCreateInfoAMD& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkCalibratedTimestampInfoEXT>(const decode::Decoded_VkCalibratedTimestampInfoEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceShaderCorePropertiesAMD>(const decode::Decoded_VkPhysicalDeviceShaderCorePropertiesAMD& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkDeviceMemoryOverallocationCreateInfoAMD>(const decode::Decoded_VkDeviceMemoryOverallocationCreateInfoAMD& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceVertexAttributeDivisorPropertiesEXT>(const decode::Decoded_VkPhysicalDeviceVertexAttributeDivisorPropertiesEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkVertexInputBindingDivisorDescriptionEXT>(const decode::Decoded_VkVertexInputBindingDivisorDescriptionEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPipelineVertexInputDivisorStateCreateInfoEXT>(const decode::Decoded_VkPipelineVertexInputDivisorStateCreateInfoEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceVertexAttributeDivisorFeaturesEXT>(const decode::Decoded_VkPhysicalDeviceVertexAttributeDivisorFeaturesEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPresentFrameTokenGGP>(const decode::Decoded_VkPresentFrameTokenGGP& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceComputeShaderDerivativesFeaturesNV>(const decode::Decoded_VkPhysicalDeviceComputeShaderDerivativesFeaturesNV& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceMeshShaderFeaturesNV>(const decode::Decoded_VkPhysicalDeviceMeshShaderFeaturesNV& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceMeshShaderPropertiesNV>(const decode::Decoded_VkPhysicalDeviceMeshShaderPropertiesNV& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkDrawMeshTasksIndirectCommandNV>(const decode::Decoded_VkDrawMeshTasksIndirectCommandNV& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceShaderImageFootprintFeaturesNV>(const decode::Decoded_VkPhysicalDeviceShaderImageFootprintFeaturesNV& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPipelineViewportExclusiveScissorStateCreateInfoNV>(const decode::Decoded_VkPipelineViewportExclusiveScissorStateCreateInfoNV& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceExclusiveScissorFeaturesNV>(const decode::Decoded_VkPhysicalDeviceExclusiveScissorFeaturesNV& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkQueueFamilyCheckpointPropertiesNV>(const decode::Decoded_VkQueueFamilyCheckpointPropertiesNV& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkCheckpointDataNV>(const decode::Decoded_VkCheckpointDataNV& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceShaderIntegerFunctions2FeaturesINTEL>(const decode::Decoded_VkPhysicalDeviceShaderIntegerFunctions2FeaturesINTEL& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkInitializePerformanceApiInfoINTEL>(const decode::Decoded_VkInitializePerformanceApiInfoINTEL& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkQueryPoolPerformanceQueryCreateInfoINTEL>(const decode::Decoded_VkQueryPoolPerformanceQueryCreateInfoINTEL& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPerformanceMarkerInfoINTEL>(const decode::Decoded_VkPerformanceMarkerInfoINTEL& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPerformanceStreamMarkerInfoINTEL>(const decode::Decoded_VkPerformanceStreamMarkerInfoINTEL& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPerformanceOverrideInfoINTEL>(const decode::Decoded_VkPerformanceOverrideInfoINTEL& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPerformanceConfigurationAcquireInfoINTEL>(const decode::Decoded_VkPerformanceConfigurationAcquireInfoINTEL& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDevicePCIBusInfoPropertiesEXT>(const decode::Decoded_VkPhysicalDevicePCIBusInfoPropertiesEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkDisplayNativeHdrSurfaceCapabilitiesAMD>(const decode::Decoded_VkDisplayNativeHdrSurfaceCapabilitiesAMD& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkSwapchainDisplayNativeHdrCreateInfoAMD>(const decode::Decoded_VkSwapchainDisplayNativeHdrCreateInfoAMD& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkImagePipeSurfaceCreateInfoFUCHSIA>(const decode::Decoded_VkImagePipeSurfaceCreateInfoFUCHSIA& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkMetalSurfaceCreateInfoEXT>(const decode::Decoded_VkMetalSurfaceCreateInfoEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceFragmentDensityMapFeaturesEXT>(const decode::Decoded_VkPhysicalDeviceFragmentDensityMapFeaturesEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceFragmentDensityMapPropertiesEXT>(const decode::Decoded_VkPhysicalDeviceFragmentDensityMapPropertiesEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkRenderPassFragmentDensityMapCreateInfoEXT>(const decode::Decoded_VkRenderPassFragmentDensityMapCreateInfoEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceShaderCoreProperties2AMD>(const decode::Decoded_VkPhysicalDeviceShaderCoreProperties2AMD& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceCoherentMemoryFeaturesAMD>(const decode::Decoded_VkPhysicalDeviceCoherentMemoryFeaturesAMD& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceShaderImageAtomicInt64FeaturesEXT>(const decode::Decoded_VkPhysicalDeviceShaderImageAtomicInt64FeaturesEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceMemoryBudgetPropertiesEXT>(const decode::Decoded_VkPhysicalDeviceMemoryBudgetPropertiesEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceMemoryPriorityFeaturesEXT>(const decode::Decoded_VkPhysicalDeviceMemoryPriorityFeaturesEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkMemoryPriorityAllocateInfoEXT>(const decode::Decoded_VkMemoryPriorityAllocateInfoEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceDedicatedAllocationImageAliasingFeaturesNV>(const decode::Decoded_VkPhysicalDeviceDedicatedAllocationImageAliasingFeaturesNV& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceBufferDeviceAddressFeaturesEXT>(const decode::Decoded_VkPhysicalDeviceBufferDeviceAddressFeaturesEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkBufferDeviceAddressCreateInfoEXT>(const decode::Decoded_VkBufferDeviceAddressCreateInfoEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkValidationFeaturesEXT>(const decode::Decoded_VkValidationFeaturesEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkCooperativeMatrixPropertiesNV>(const decode::Decoded_VkCooperativeMatrixPropertiesNV& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceCooperativeMatrixFeaturesNV>(const decode::Decoded_VkPhysicalDeviceCooperativeMatrixFeaturesNV& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceCooperativeMatrixPropertiesNV>(const decode::Decoded_VkPhysicalDeviceCooperativeMatrixPropertiesNV& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceCoverageReductionModeFeaturesNV>(const decode::Decoded_VkPhysicalDeviceCoverageReductionModeFeaturesNV& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPipelineCoverageReductionStateCreateInfoNV>(const decode::Decoded_VkPipelineCoverageReductionStateCreateInfoNV& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkFramebufferMixedSamplesCombinationNV>(const decode::Decoded_VkFramebufferMixedSamplesCombinationNV& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT>(const decode::Decoded_VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceYcbcrImageArraysFeaturesEXT>(const decode::Decoded_VkPhysicalDeviceYcbcrImageArraysFeaturesEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceProvokingVertexFeaturesEXT>(const decode::Decoded_VkPhysicalDeviceProvokingVertexFeaturesEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceProvokingVertexPropertiesEXT>(const decode::Decoded_VkPhysicalDeviceProvokingVertexPropertiesEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPipelineRasterizationProvokingVertexStateCreateInfoEXT>(const decode::Decoded_VkPipelineRasterizationProvokingVertexStateCreateInfoEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkSurfaceFullScreenExclusiveInfoEXT>(const decode::Decoded_VkSurfaceFullScreenExclusiveInfoEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkSurfaceCapabilitiesFullScreenExclusiveEXT>(const decode::Decoded_VkSurfaceCapabilitiesFullScreenExclusiveEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkSurfaceFullScreenExclusiveWin32InfoEXT>(const decode::Decoded_VkSurfaceFullScreenExclusiveWin32InfoEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkHeadlessSurfaceCreateInfoEXT>(const decode::Decoded_VkHeadlessSurfaceCreateInfoEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceLineRasterizationFeaturesEXT>(const decode::Decoded_VkPhysicalDeviceLineRasterizationFeaturesEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceLineRasterizationPropertiesEXT>(const decode::Decoded_VkPhysicalDeviceLineRasterizationPropertiesEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPipelineRasterizationLineStateCreateInfoEXT>(const decode::Decoded_VkPipelineRasterizationLineStateCreateInfoEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceShaderAtomicFloatFeaturesEXT>(const decode::Decoded_VkPhysicalDeviceShaderAtomicFloatFeaturesEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceIndexTypeUint8FeaturesEXT>(const decode::Decoded_VkPhysicalDeviceIndexTypeUint8FeaturesEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceExtendedDynamicStateFeaturesEXT>(const decode::Decoded_VkPhysicalDeviceExtendedDynamicStateFeaturesEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceShaderAtomicFloat2FeaturesEXT>(const decode::Decoded_VkPhysicalDeviceShaderAtomicFloat2FeaturesEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceDeviceGeneratedCommandsPropertiesNV>(const decode::Decoded_VkPhysicalDeviceDeviceGeneratedCommandsPropertiesNV& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceDeviceGeneratedCommandsFeaturesNV>(const decode::Decoded_VkPhysicalDeviceDeviceGeneratedCommandsFeaturesNV& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkGraphicsShaderGroupCreateInfoNV>(const decode::Decoded_VkGraphicsShaderGroupCreateInfoNV& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkGraphicsPipelineShaderGroupsCreateInfoNV>(const decode::Decoded_VkGraphicsPipelineShaderGroupsCreateInfoNV& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkBindShaderGroupIndirectCommandNV>(const decode::Decoded_VkBindShaderGroupIndirectCommandNV& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkBindIndexBufferIndirectCommandNV>(const decode::Decoded_VkBindIndexBufferIndirectCommandNV& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkBindVertexBufferIndirectCommandNV>(const decode::Decoded_VkBindVertexBufferIndirectCommandNV& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkSetStateFlagsIndirectCommandNV>(const decode::Decoded_VkSetStateFlagsIndirectCommandNV& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkIndirectCommandsStreamNV>(const decode::Decoded_VkIndirectCommandsStreamNV& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkIndirectCommandsLayoutTokenNV>(const decode::Decoded_VkIndirectCommandsLayoutTokenNV& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkIndirectCommandsLayoutCreateInfoNV>(const decode::Decoded_VkIndirectCommandsLayoutCreateInfoNV& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkGeneratedCommandsInfoNV>(const decode::Decoded_VkGeneratedCommandsInfoNV& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkGeneratedCommandsMemoryRequirementsInfoNV>(const decode::Decoded_VkGeneratedCommandsMemoryRequirementsInfoNV& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceInheritedViewportScissorFeaturesNV>(const decode::Decoded_VkPhysicalDeviceInheritedViewportScissorFeaturesNV& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkCommandBufferInheritanceViewportScissorInfoNV>(const decode::Decoded_VkCommandBufferInheritanceViewportScissorInfoNV& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT>(const decode::Decoded_VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkRenderPassTransformBeginInfoQCOM>(const decode::Decoded_VkRenderPassTransformBeginInfoQCOM& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkCommandBufferInheritanceRenderPassTransformInfoQCOM>(const decode::Decoded_VkCommandBufferInheritanceRenderPassTransformInfoQCOM& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceDeviceMemoryReportFeaturesEXT>(const decode::Decoded_VkPhysicalDeviceDeviceMemoryReportFeaturesEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkDeviceMemoryReportCallbackDataEXT>(const decode::Decoded_VkDeviceMemoryReportCallbackDataEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkDeviceDeviceMemoryReportCreateInfoEXT>(const decode::Decoded_VkDeviceDeviceMemoryReportCreateInfoEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceRobustness2FeaturesEXT>(const decode::Decoded_VkPhysicalDeviceRobustness2FeaturesEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceRobustness2PropertiesEXT>(const decode::Decoded_VkPhysicalDeviceRobustness2PropertiesEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkSamplerCustomBorderColorCreateInfoEXT>(const decode::Decoded_VkSamplerCustomBorderColorCreateInfoEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceCustomBorderColorPropertiesEXT>(const decode::Decoded_VkPhysicalDeviceCustomBorderColorPropertiesEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceCustomBorderColorFeaturesEXT>(const decode::Decoded_VkPhysicalDeviceCustomBorderColorFeaturesEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDevicePresentBarrierFeaturesNV>(const decode::Decoded_VkPhysicalDevicePresentBarrierFeaturesNV& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkSurfaceCapabilitiesPresentBarrierNV>(const decode::Decoded_VkSurfaceCapabilitiesPresentBarrierNV& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkSwapchainPresentBarrierCreateInfoNV>(const decode::Decoded_VkSwapchainPresentBarrierCreateInfoNV& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceDiagnosticsConfigFeaturesNV>(const decode::Decoded_VkPhysicalDeviceDiagnosticsConfigFeaturesNV& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkDeviceDiagnosticsConfigCreateInfoNV>(const decode::Decoded_VkDeviceDiagnosticsConfigCreateInfoNV& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceGraphicsPipelineLibraryFeaturesEXT>(const decode::Decoded_VkPhysicalDeviceGraphicsPipelineLibraryFeaturesEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceGraphicsPipelineLibraryPropertiesEXT>(const decode::Decoded_VkPhysicalDeviceGraphicsPipelineLibraryPropertiesEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkGraphicsPipelineLibraryCreateInfoEXT>(const decode::Decoded_VkGraphicsPipelineLibraryCreateInfoEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceShaderEarlyAndLateFragmentTestsFeaturesAMD>(const decode::Decoded_VkPhysicalDeviceShaderEarlyAndLateFragmentTestsFeaturesAMD& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceFragmentShadingRateEnumsFeaturesNV>(const decode::Decoded_VkPhysicalDeviceFragmentShadingRateEnumsFeaturesNV& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceFragmentShadingRateEnumsPropertiesNV>(const decode::Decoded_VkPhysicalDeviceFragmentShadingRateEnumsPropertiesNV& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPipelineFragmentShadingRateEnumStateCreateInfoNV>(const decode::Decoded_VkPipelineFragmentShadingRateEnumStateCreateInfoNV& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkAccelerationStructureGeometryMotionTrianglesDataNV>(const decode::Decoded_VkAccelerationStructureGeometryMotionTrianglesDataNV& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkAccelerationStructureMotionInfoNV>(const decode::Decoded_VkAccelerationStructureMotionInfoNV& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkAccelerationStructureMatrixMotionInstanceNV>(const decode::Decoded_VkAccelerationStructureMatrixMotionInstanceNV& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkSRTDataNV>(const decode::Decoded_VkSRTDataNV& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkAccelerationStructureSRTMotionInstanceNV>(const decode::Decoded_VkAccelerationStructureSRTMotionInstanceNV& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceRayTracingMotionBlurFeaturesNV>(const decode::Decoded_VkPhysicalDeviceRayTracingMotionBlurFeaturesNV& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT>(const decode::Decoded_VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceFragmentDensityMap2FeaturesEXT>(const decode::Decoded_VkPhysicalDeviceFragmentDensityMap2FeaturesEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceFragmentDensityMap2PropertiesEXT>(const decode::Decoded_VkPhysicalDeviceFragmentDensityMap2PropertiesEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkCopyCommandTransformInfoQCOM>(const decode::Decoded_VkCopyCommandTransformInfoQCOM& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceImageCompressionControlFeaturesEXT>(const decode::Decoded_VkPhysicalDeviceImageCompressionControlFeaturesEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkImageCompressionControlEXT>(const decode::Decoded_VkImageCompressionControlEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkSubresourceLayout2EXT>(const decode::Decoded_VkSubresourceLayout2EXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkImageSubresource2EXT>(const decode::Decoded_VkImageSubresource2EXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkImageCompressionPropertiesEXT>(const decode::Decoded_VkImageCompressionPropertiesEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceAttachmentFeedbackLoopLayoutFeaturesEXT>(const decode::Decoded_VkPhysicalDeviceAttachmentFeedbackLoopLayoutFeaturesEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDevice4444FormatsFeaturesEXT>(const decode::Decoded_VkPhysicalDevice4444FormatsFeaturesEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceFaultFeaturesEXT>(const decode::Decoded_VkPhysicalDeviceFaultFeaturesEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkDeviceFaultCountsEXT>(const decode::Decoded_VkDeviceFaultCountsEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkDeviceFaultAddressInfoEXT>(const decode::Decoded_VkDeviceFaultAddressInfoEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkDeviceFaultVendorInfoEXT>(const decode::Decoded_VkDeviceFaultVendorInfoEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkDeviceFaultInfoEXT>(const decode::Decoded_VkDeviceFaultInfoEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkDeviceFaultVendorBinaryHeaderVersionOneEXT>(const decode::Decoded_VkDeviceFaultVendorBinaryHeaderVersionOneEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceRasterizationOrderAttachmentAccessFeaturesEXT>(const decode::Decoded_VkPhysicalDeviceRasterizationOrderAttachmentAccessFeaturesEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceRGBA10X6FormatsFeaturesEXT>(const decode::Decoded_VkPhysicalDeviceRGBA10X6FormatsFeaturesEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkDirectFBSurfaceCreateInfoEXT>(const decode::Decoded_VkDirectFBSurfaceCreateInfoEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceMutableDescriptorTypeFeaturesEXT>(const decode::Decoded_VkPhysicalDeviceMutableDescriptorTypeFeaturesEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkMutableDescriptorTypeListEXT>(const decode::Decoded_VkMutableDescriptorTypeListEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkMutableDescriptorTypeCreateInfoEXT>(const decode::Decoded_VkMutableDescriptorTypeCreateInfoEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceVertexInputDynamicStateFeaturesEXT>(const decode::Decoded_VkPhysicalDeviceVertexInputDynamicStateFeaturesEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkVertexInputBindingDescription2EXT>(const decode::Decoded_VkVertexInputBindingDescription2EXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkVertexInputAttributeDescription2EXT>(const decode::Decoded_VkVertexInputAttributeDescription2EXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceDrmPropertiesEXT>(const decode::Decoded_VkPhysicalDeviceDrmPropertiesEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceAddressBindingReportFeaturesEXT>(const decode::Decoded_VkPhysicalDeviceAddressBindingReportFeaturesEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkDeviceAddressBindingCallbackDataEXT>(const decode::Decoded_VkDeviceAddressBindingCallbackDataEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceDepthClipControlFeaturesEXT>(const decode::Decoded_VkPhysicalDeviceDepthClipControlFeaturesEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPipelineViewportDepthClipControlCreateInfoEXT>(const decode::Decoded_VkPipelineViewportDepthClipControlCreateInfoEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT>(const decode::Decoded_VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkImportMemoryZirconHandleInfoFUCHSIA>(const decode::Decoded_VkImportMemoryZirconHandleInfoFUCHSIA& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkMemoryZirconHandlePropertiesFUCHSIA>(const decode::Decoded_VkMemoryZirconHandlePropertiesFUCHSIA& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkMemoryGetZirconHandleInfoFUCHSIA>(const decode::Decoded_VkMemoryGetZirconHandleInfoFUCHSIA& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkImportSemaphoreZirconHandleInfoFUCHSIA>(const decode::Decoded_VkImportSemaphoreZirconHandleInfoFUCHSIA& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkSemaphoreGetZirconHandleInfoFUCHSIA>(const decode::Decoded_VkSemaphoreGetZirconHandleInfoFUCHSIA& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceInvocationMaskFeaturesHUAWEI>(const decode::Decoded_VkPhysicalDeviceInvocationMaskFeaturesHUAWEI& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkMemoryGetRemoteAddressInfoNV>(const decode::Decoded_VkMemoryGetRemoteAddressInfoNV& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceExternalMemoryRDMAFeaturesNV>(const decode::Decoded_VkPhysicalDeviceExternalMemoryRDMAFeaturesNV& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceMultisampledRenderToSingleSampledFeaturesEXT>(const decode::Decoded_VkPhysicalDeviceMultisampledRenderToSingleSampledFeaturesEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkSubpassResolvePerformanceQueryEXT>(const decode::Decoded_VkSubpassResolvePerformanceQueryEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkMultisampledRenderToSingleSampledInfoEXT>(const decode::Decoded_VkMultisampledRenderToSingleSampledInfoEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceExtendedDynamicState2FeaturesEXT>(const decode::Decoded_VkPhysicalDeviceExtendedDynamicState2FeaturesEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkScreenSurfaceCreateInfoQNX>(const decode::Decoded_VkScreenSurfaceCreateInfoQNX& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceColorWriteEnableFeaturesEXT>(const decode::Decoded_VkPhysicalDeviceColorWriteEnableFeaturesEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPipelineColorWriteCreateInfoEXT>(const decode::Decoded_VkPipelineColorWriteCreateInfoEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDevicePrimitivesGeneratedQueryFeaturesEXT>(const decode::Decoded_VkPhysicalDevicePrimitivesGeneratedQueryFeaturesEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceImageViewMinLodFeaturesEXT>(const decode::Decoded_VkPhysicalDeviceImageViewMinLodFeaturesEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkImageViewMinLodCreateInfoEXT>(const decode::Decoded_VkImageViewMinLodCreateInfoEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceMultiDrawFeaturesEXT>(const decode::Decoded_VkPhysicalDeviceMultiDrawFeaturesEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceMultiDrawPropertiesEXT>(const decode::Decoded_VkPhysicalDeviceMultiDrawPropertiesEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkMultiDrawInfoEXT>(const decode::Decoded_VkMultiDrawInfoEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkMultiDrawIndexedInfoEXT>(const decode::Decoded_VkMultiDrawIndexedInfoEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceImage2DViewOf3DFeaturesEXT>(const decode::Decoded_VkPhysicalDeviceImage2DViewOf3DFeaturesEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkMicromapUsageEXT>(const decode::Decoded_VkMicromapUsageEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkMicromapBuildInfoEXT>(const decode::Decoded_VkMicromapBuildInfoEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkMicromapCreateInfoEXT>(const decode::Decoded_VkMicromapCreateInfoEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceOpacityMicromapFeaturesEXT>(const decode::Decoded_VkPhysicalDeviceOpacityMicromapFeaturesEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceOpacityMicromapPropertiesEXT>(const decode::Decoded_VkPhysicalDeviceOpacityMicromapPropertiesEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkMicromapVersionInfoEXT>(const decode::Decoded_VkMicromapVersionInfoEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkCopyMicromapToMemoryInfoEXT>(const decode::Decoded_VkCopyMicromapToMemoryInfoEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkCopyMemoryToMicromapInfoEXT>(const decode::Decoded_VkCopyMemoryToMicromapInfoEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkCopyMicromapInfoEXT>(const decode::Decoded_VkCopyMicromapInfoEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkMicromapBuildSizesInfoEXT>(const decode::Decoded_VkMicromapBuildSizesInfoEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkAccelerationStructureTrianglesOpacityMicromapEXT>(const decode::Decoded_VkAccelerationStructureTrianglesOpacityMicromapEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkMicromapTriangleEXT>(const decode::Decoded_VkMicromapTriangleEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceBorderColorSwizzleFeaturesEXT>(const decode::Decoded_VkPhysicalDeviceBorderColorSwizzleFeaturesEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkSamplerBorderColorComponentMappingCreateInfoEXT>(const decode::Decoded_VkSamplerBorderColorComponentMappingCreateInfoEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDevicePageableDeviceLocalMemoryFeaturesEXT>(const decode::Decoded_VkPhysicalDevicePageableDeviceLocalMemoryFeaturesEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceDescriptorSetHostMappingFeaturesVALVE>(const decode::Decoded_VkPhysicalDeviceDescriptorSetHostMappingFeaturesVALVE& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkDescriptorSetBindingReferenceVALVE>(const decode::Decoded_VkDescriptorSetBindingReferenceVALVE& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkDescriptorSetLayoutHostMappingInfoVALVE>(const decode::Decoded_VkDescriptorSetLayoutHostMappingInfoVALVE& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceDepthClampZeroOneFeaturesEXT>(const decode::Decoded_VkPhysicalDeviceDepthClampZeroOneFeaturesEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceNonSeamlessCubeMapFeaturesEXT>(const decode::Decoded_VkPhysicalDeviceNonSeamlessCubeMapFeaturesEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceFragmentDensityMapOffsetFeaturesQCOM>(const decode::Decoded_VkPhysicalDeviceFragmentDensityMapOffsetFeaturesQCOM& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceFragmentDensityMapOffsetPropertiesQCOM>(const decode::Decoded_VkPhysicalDeviceFragmentDensityMapOffsetPropertiesQCOM& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkSubpassFragmentDensityMapOffsetEndInfoQCOM>(const decode::Decoded_VkSubpassFragmentDensityMapOffsetEndInfoQCOM& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceLinearColorAttachmentFeaturesNV>(const decode::Decoded_VkPhysicalDeviceLinearColorAttachmentFeaturesNV& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceImageCompressionControlSwapchainFeaturesEXT>(const decode::Decoded_VkPhysicalDeviceImageCompressionControlSwapchainFeaturesEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkImageViewSampleWeightCreateInfoQCOM>(const decode::Decoded_VkImageViewSampleWeightCreateInfoQCOM& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceImageProcessingFeaturesQCOM>(const decode::Decoded_VkPhysicalDeviceImageProcessingFeaturesQCOM& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceImageProcessingPropertiesQCOM>(const decode::Decoded_VkPhysicalDeviceImageProcessingPropertiesQCOM& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceExtendedDynamicState3FeaturesEXT>(const decode::Decoded_VkPhysicalDeviceExtendedDynamicState3FeaturesEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceExtendedDynamicState3PropertiesEXT>(const decode::Decoded_VkPhysicalDeviceExtendedDynamicState3PropertiesEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkColorBlendEquationEXT>(const decode::Decoded_VkColorBlendEquationEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkColorBlendAdvancedEXT>(const decode::Decoded_VkColorBlendAdvancedEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceSubpassMergeFeedbackFeaturesEXT>(const decode::Decoded_VkPhysicalDeviceSubpassMergeFeedbackFeaturesEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkRenderPassCreationControlEXT>(const decode::Decoded_VkRenderPassCreationControlEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkRenderPassCreationFeedbackInfoEXT>(const decode::Decoded_VkRenderPassCreationFeedbackInfoEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkRenderPassCreationFeedbackCreateInfoEXT>(const decode::Decoded_VkRenderPassCreationFeedbackCreateInfoEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkRenderPassSubpassFeedbackInfoEXT>(const decode::Decoded_VkRenderPassSubpassFeedbackInfoEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkRenderPassSubpassFeedbackCreateInfoEXT>(const decode::Decoded_VkRenderPassSubpassFeedbackCreateInfoEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkDirectDriverLoadingInfoLUNARG>(const decode::Decoded_VkDirectDriverLoadingInfoLUNARG& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkDirectDriverLoadingListLUNARG>(const decode::Decoded_VkDirectDriverLoadingListLUNARG& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceShaderModuleIdentifierFeaturesEXT>(const decode::Decoded_VkPhysicalDeviceShaderModuleIdentifierFeaturesEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceShaderModuleIdentifierPropertiesEXT>(const decode::Decoded_VkPhysicalDeviceShaderModuleIdentifierPropertiesEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPipelineShaderStageModuleIdentifierCreateInfoEXT>(const decode::Decoded_VkPipelineShaderStageModuleIdentifierCreateInfoEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkShaderModuleIdentifierEXT>(const decode::Decoded_VkShaderModuleIdentifierEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceOpticalFlowFeaturesNV>(const decode::Decoded_VkPhysicalDeviceOpticalFlowFeaturesNV& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceOpticalFlowPropertiesNV>(const decode::Decoded_VkPhysicalDeviceOpticalFlowPropertiesNV& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkOpticalFlowImageFormatInfoNV>(const decode::Decoded_VkOpticalFlowImageFormatInfoNV& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkOpticalFlowImageFormatPropertiesNV>(const decode::Decoded_VkOpticalFlowImageFormatPropertiesNV& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkOpticalFlowSessionCreateInfoNV>(const decode::Decoded_VkOpticalFlowSessionCreateInfoNV& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkOpticalFlowSessionCreatePrivateDataInfoNV>(const decode::Decoded_VkOpticalFlowSessionCreatePrivateDataInfoNV& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkOpticalFlowExecuteInfoNV>(const decode::Decoded_VkOpticalFlowExecuteInfoNV& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceLegacyDitheringFeaturesEXT>(const decode::Decoded_VkPhysicalDeviceLegacyDitheringFeaturesEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDevicePipelineProtectedAccessFeaturesEXT>(const decode::Decoded_VkPhysicalDevicePipelineProtectedAccessFeaturesEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceTilePropertiesFeaturesQCOM>(const decode::Decoded_VkPhysicalDeviceTilePropertiesFeaturesQCOM& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkTilePropertiesQCOM>(const decode::Decoded_VkTilePropertiesQCOM& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceAmigoProfilingFeaturesSEC>(const decode::Decoded_VkPhysicalDeviceAmigoProfilingFeaturesSEC& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkAmigoProfilingSubmitInfoSEC>(const decode::Decoded_VkAmigoProfilingSubmitInfoSEC& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceMultiviewPerViewViewportsFeaturesQCOM>(const decode::Decoded_VkPhysicalDeviceMultiviewPerViewViewportsFeaturesQCOM& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceRayTracingInvocationReorderPropertiesNV>(const decode::Decoded_VkPhysicalDeviceRayTracingInvocationReorderPropertiesNV& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceRayTracingInvocationReorderFeaturesNV>(const decode::Decoded_VkPhysicalDeviceRayTracingInvocationReorderFeaturesNV& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceShaderCoreBuiltinsFeaturesARM>(const decode::Decoded_VkPhysicalDeviceShaderCoreBuiltinsFeaturesARM& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceShaderCoreBuiltinsPropertiesARM>(const decode::Decoded_VkPhysicalDeviceShaderCoreBuiltinsPropertiesARM& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkAccelerationStructureBuildRangeInfoKHR>(const decode::Decoded_VkAccelerationStructureBuildRangeInfoKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkAccelerationStructureGeometryTrianglesDataKHR>(const decode::Decoded_VkAccelerationStructureGeometryTrianglesDataKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkAccelerationStructureGeometryAabbsDataKHR>(const decode::Decoded_VkAccelerationStructureGeometryAabbsDataKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkAccelerationStructureGeometryInstancesDataKHR>(const decode::Decoded_VkAccelerationStructureGeometryInstancesDataKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkAccelerationStructureBuildGeometryInfoKHR>(const decode::Decoded_VkAccelerationStructureBuildGeometryInfoKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkAccelerationStructureCreateInfoKHR>(const decode::Decoded_VkAccelerationStructureCreateInfoKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkWriteDescriptorSetAccelerationStructureKHR>(const decode::Decoded_VkWriteDescriptorSetAccelerationStructureKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceAccelerationStructureFeaturesKHR>(const decode::Decoded_VkPhysicalDeviceAccelerationStructureFeaturesKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceAccelerationStructurePropertiesKHR>(const decode::Decoded_VkPhysicalDeviceAccelerationStructurePropertiesKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkAccelerationStructureDeviceAddressInfoKHR>(const decode::Decoded_VkAccelerationStructureDeviceAddressInfoKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkAccelerationStructureVersionInfoKHR>(const decode::Decoded_VkAccelerationStructureVersionInfoKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkCopyAccelerationStructureToMemoryInfoKHR>(const decode::Decoded_VkCopyAccelerationStructureToMemoryInfoKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkCopyMemoryToAccelerationStructureInfoKHR>(const decode::Decoded_VkCopyMemoryToAccelerationStructureInfoKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkCopyAccelerationStructureInfoKHR>(const decode::Decoded_VkCopyAccelerationStructureInfoKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkAccelerationStructureBuildSizesInfoKHR>(const decode::Decoded_VkAccelerationStructureBuildSizesInfoKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkRayTracingShaderGroupCreateInfoKHR>(const decode::Decoded_VkRayTracingShaderGroupCreateInfoKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkRayTracingPipelineInterfaceCreateInfoKHR>(const decode::Decoded_VkRayTracingPipelineInterfaceCreateInfoKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkRayTracingPipelineCreateInfoKHR>(const decode::Decoded_VkRayTracingPipelineCreateInfoKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceRayTracingPipelineFeaturesKHR>(const decode::Decoded_VkPhysicalDeviceRayTracingPipelineFeaturesKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceRayTracingPipelinePropertiesKHR>(const decode::Decoded_VkPhysicalDeviceRayTracingPipelinePropertiesKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkStridedDeviceAddressRegionKHR>(const decode::Decoded_VkStridedDeviceAddressRegionKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkTraceRaysIndirectCommandKHR>(const decode::Decoded_VkTraceRaysIndirectCommandKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceRayQueryFeaturesKHR>(const decode::Decoded_VkPhysicalDeviceRayQueryFeaturesKHR& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceMeshShaderFeaturesEXT>(const decode::Decoded_VkPhysicalDeviceMeshShaderFeaturesEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkPhysicalDeviceMeshShaderPropertiesEXT>(const decode::Decoded_VkPhysicalDeviceMeshShaderPropertiesEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
template <> std::string ToString<decode::Decoded_VkDrawMeshTasksIndirectCommandEXT>(const decode::Decoded_VkDrawMeshTasksIndirectCommandEXT& obj, ToStringFlags toStriingFlags, uint32_t tabCount, uint32_t tabSize);
GFXRECON_END_NAMESPACE(util)
GFXRECON_END_NAMESPACE(gfxrecon)

#endif
