/*
** Copyright (c) 2018-2021 Valve Corporation
** Copyright (c) 2018-2021 LunarG, Inc.
**
** Permission is hereby granted, free of charge, to any person obtaining a
** copy of this software and associated documentation files (the "Software"),
** to deal in the Software without restriction, including without limitation
** the rights to use, copy, modify, merge, publish, distribute, sublicense,
** and/or sell copies of the Software, and to permit persons to whom the
** Software is furnished to do so, subject to the following conditions:
**
** The above copyright notice and this permission notice shall be included in
** all copies or substantial portions of the Software.
**
** THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
** IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
** FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
** AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
** LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
** FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
** DEALINGS IN THE SOFTWARE.
*/

/*
** This file is generated from the Khronos Vulkan XML API Registry.
**
*/

#ifndef  GFXRECON_GENERATED_LAYER_FUNC_TABLE_H
#define  GFXRECON_GENERATED_LAYER_FUNC_TABLE_H

#include "encode/custom_vulkan_api_call_encoders.h"
#include "generated/generated_vulkan_api_call_encoders.h"
#include "layer/trace_layer.h"
#include "util/defines.h"

#include "vulkan/vulkan.h"

#include <unordered_map>

GFXRECON_BEGIN_NAMESPACE(gfxrecon)

const std::unordered_map<std::string, PFN_vkVoidFunction> func_table = {
    { "vkCreateInstance",                                                                                    reinterpret_cast<PFN_vkVoidFunction>(encode::CreateInstance) },
    { "vkDestroyInstance",                                                                                   reinterpret_cast<PFN_vkVoidFunction>(encode::DestroyInstance) },
    { "vkEnumeratePhysicalDevices",                                                                          reinterpret_cast<PFN_vkVoidFunction>(encode::EnumeratePhysicalDevices) },
    { "vkGetPhysicalDeviceFeatures",                                                                         reinterpret_cast<PFN_vkVoidFunction>(encode::GetPhysicalDeviceFeatures) },
    { "vkGetPhysicalDeviceFormatProperties",                                                                 reinterpret_cast<PFN_vkVoidFunction>(encode::GetPhysicalDeviceFormatProperties) },
    { "vkGetPhysicalDeviceImageFormatProperties",                                                            reinterpret_cast<PFN_vkVoidFunction>(encode::GetPhysicalDeviceImageFormatProperties) },
    { "vkGetPhysicalDeviceProperties",                                                                       reinterpret_cast<PFN_vkVoidFunction>(encode::GetPhysicalDeviceProperties) },
    { "vkGetPhysicalDeviceQueueFamilyProperties",                                                            reinterpret_cast<PFN_vkVoidFunction>(encode::GetPhysicalDeviceQueueFamilyProperties) },
    { "vkGetPhysicalDeviceMemoryProperties",                                                                 reinterpret_cast<PFN_vkVoidFunction>(encode::GetPhysicalDeviceMemoryProperties) },
    { "vkGetInstanceProcAddr",                                                                               reinterpret_cast<PFN_vkVoidFunction>(GetInstanceProcAddr) },
    { "vkGetDeviceProcAddr",                                                                                 reinterpret_cast<PFN_vkVoidFunction>(GetDeviceProcAddr) },
    { "vkCreateDevice",                                                                                      reinterpret_cast<PFN_vkVoidFunction>(encode::CreateDevice) },
    { "vkDestroyDevice",                                                                                     reinterpret_cast<PFN_vkVoidFunction>(encode::DestroyDevice) },
    { "vkEnumerateInstanceExtensionProperties",                                                              reinterpret_cast<PFN_vkVoidFunction>(EnumerateInstanceExtensionProperties) },
    { "vkEnumerateDeviceExtensionProperties",                                                                reinterpret_cast<PFN_vkVoidFunction>(EnumerateDeviceExtensionProperties) },
    { "vkEnumerateInstanceLayerProperties",                                                                  reinterpret_cast<PFN_vkVoidFunction>(EnumerateInstanceLayerProperties) },
    { "vkEnumerateDeviceLayerProperties",                                                                    reinterpret_cast<PFN_vkVoidFunction>(EnumerateDeviceLayerProperties) },
    { "vkGetDeviceQueue",                                                                                    reinterpret_cast<PFN_vkVoidFunction>(encode::GetDeviceQueue) },
    { "vkQueueSubmit",                                                                                       reinterpret_cast<PFN_vkVoidFunction>(encode::QueueSubmit) },
    { "vkQueueWaitIdle",                                                                                     reinterpret_cast<PFN_vkVoidFunction>(encode::QueueWaitIdle) },
    { "vkDeviceWaitIdle",                                                                                    reinterpret_cast<PFN_vkVoidFunction>(encode::DeviceWaitIdle) },
    { "vkAllocateMemory",                                                                                    reinterpret_cast<PFN_vkVoidFunction>(encode::AllocateMemory) },
    { "vkFreeMemory",                                                                                        reinterpret_cast<PFN_vkVoidFunction>(encode::FreeMemory) },
    { "vkMapMemory",                                                                                         reinterpret_cast<PFN_vkVoidFunction>(encode::MapMemory) },
    { "vkUnmapMemory",                                                                                       reinterpret_cast<PFN_vkVoidFunction>(encode::UnmapMemory) },
    { "vkFlushMappedMemoryRanges",                                                                           reinterpret_cast<PFN_vkVoidFunction>(encode::FlushMappedMemoryRanges) },
    { "vkInvalidateMappedMemoryRanges",                                                                      reinterpret_cast<PFN_vkVoidFunction>(encode::InvalidateMappedMemoryRanges) },
    { "vkGetDeviceMemoryCommitment",                                                                         reinterpret_cast<PFN_vkVoidFunction>(encode::GetDeviceMemoryCommitment) },
    { "vkBindBufferMemory",                                                                                  reinterpret_cast<PFN_vkVoidFunction>(encode::BindBufferMemory) },
    { "vkBindImageMemory",                                                                                   reinterpret_cast<PFN_vkVoidFunction>(encode::BindImageMemory) },
    { "vkGetBufferMemoryRequirements",                                                                       reinterpret_cast<PFN_vkVoidFunction>(encode::GetBufferMemoryRequirements) },
    { "vkGetImageMemoryRequirements",                                                                        reinterpret_cast<PFN_vkVoidFunction>(encode::GetImageMemoryRequirements) },
    { "vkGetImageSparseMemoryRequirements",                                                                  reinterpret_cast<PFN_vkVoidFunction>(encode::GetImageSparseMemoryRequirements) },
    { "vkGetPhysicalDeviceSparseImageFormatProperties",                                                      reinterpret_cast<PFN_vkVoidFunction>(encode::GetPhysicalDeviceSparseImageFormatProperties) },
    { "vkQueueBindSparse",                                                                                   reinterpret_cast<PFN_vkVoidFunction>(encode::QueueBindSparse) },
    { "vkCreateFence",                                                                                       reinterpret_cast<PFN_vkVoidFunction>(encode::CreateFence) },
    { "vkDestroyFence",                                                                                      reinterpret_cast<PFN_vkVoidFunction>(encode::DestroyFence) },
    { "vkResetFences",                                                                                       reinterpret_cast<PFN_vkVoidFunction>(encode::ResetFences) },
    { "vkGetFenceStatus",                                                                                    reinterpret_cast<PFN_vkVoidFunction>(encode::GetFenceStatus) },
    { "vkWaitForFences",                                                                                     reinterpret_cast<PFN_vkVoidFunction>(encode::WaitForFences) },
    { "vkCreateSemaphore",                                                                                   reinterpret_cast<PFN_vkVoidFunction>(encode::CreateSemaphore) },
    { "vkDestroySemaphore",                                                                                  reinterpret_cast<PFN_vkVoidFunction>(encode::DestroySemaphore) },
    { "vkCreateEvent",                                                                                       reinterpret_cast<PFN_vkVoidFunction>(encode::CreateEvent) },
    { "vkDestroyEvent",                                                                                      reinterpret_cast<PFN_vkVoidFunction>(encode::DestroyEvent) },
    { "vkGetEventStatus",                                                                                    reinterpret_cast<PFN_vkVoidFunction>(encode::GetEventStatus) },
    { "vkSetEvent",                                                                                          reinterpret_cast<PFN_vkVoidFunction>(encode::SetEvent) },
    { "vkResetEvent",                                                                                        reinterpret_cast<PFN_vkVoidFunction>(encode::ResetEvent) },
    { "vkCreateQueryPool",                                                                                   reinterpret_cast<PFN_vkVoidFunction>(encode::CreateQueryPool) },
    { "vkDestroyQueryPool",                                                                                  reinterpret_cast<PFN_vkVoidFunction>(encode::DestroyQueryPool) },
    { "vkGetQueryPoolResults",                                                                               reinterpret_cast<PFN_vkVoidFunction>(encode::GetQueryPoolResults) },
    { "vkCreateBuffer",                                                                                      reinterpret_cast<PFN_vkVoidFunction>(encode::CreateBuffer) },
    { "vkDestroyBuffer",                                                                                     reinterpret_cast<PFN_vkVoidFunction>(encode::DestroyBuffer) },
    { "vkCreateBufferView",                                                                                  reinterpret_cast<PFN_vkVoidFunction>(encode::CreateBufferView) },
    { "vkDestroyBufferView",                                                                                 reinterpret_cast<PFN_vkVoidFunction>(encode::DestroyBufferView) },
    { "vkCreateImage",                                                                                       reinterpret_cast<PFN_vkVoidFunction>(encode::CreateImage) },
    { "vkDestroyImage",                                                                                      reinterpret_cast<PFN_vkVoidFunction>(encode::DestroyImage) },
    { "vkGetImageSubresourceLayout",                                                                         reinterpret_cast<PFN_vkVoidFunction>(encode::GetImageSubresourceLayout) },
    { "vkCreateImageView",                                                                                   reinterpret_cast<PFN_vkVoidFunction>(encode::CreateImageView) },
    { "vkDestroyImageView",                                                                                  reinterpret_cast<PFN_vkVoidFunction>(encode::DestroyImageView) },
    { "vkCreateShaderModule",                                                                                reinterpret_cast<PFN_vkVoidFunction>(encode::CreateShaderModule) },
    { "vkDestroyShaderModule",                                                                               reinterpret_cast<PFN_vkVoidFunction>(encode::DestroyShaderModule) },
    { "vkCreatePipelineCache",                                                                               reinterpret_cast<PFN_vkVoidFunction>(encode::CreatePipelineCache) },
    { "vkDestroyPipelineCache",                                                                              reinterpret_cast<PFN_vkVoidFunction>(encode::DestroyPipelineCache) },
    { "vkGetPipelineCacheData",                                                                              reinterpret_cast<PFN_vkVoidFunction>(encode::GetPipelineCacheData) },
    { "vkMergePipelineCaches",                                                                               reinterpret_cast<PFN_vkVoidFunction>(encode::MergePipelineCaches) },
    { "vkCreateGraphicsPipelines",                                                                           reinterpret_cast<PFN_vkVoidFunction>(encode::CreateGraphicsPipelines) },
    { "vkCreateComputePipelines",                                                                            reinterpret_cast<PFN_vkVoidFunction>(encode::CreateComputePipelines) },
    { "vkDestroyPipeline",                                                                                   reinterpret_cast<PFN_vkVoidFunction>(encode::DestroyPipeline) },
    { "vkCreatePipelineLayout",                                                                              reinterpret_cast<PFN_vkVoidFunction>(encode::CreatePipelineLayout) },
    { "vkDestroyPipelineLayout",                                                                             reinterpret_cast<PFN_vkVoidFunction>(encode::DestroyPipelineLayout) },
    { "vkCreateSampler",                                                                                     reinterpret_cast<PFN_vkVoidFunction>(encode::CreateSampler) },
    { "vkDestroySampler",                                                                                    reinterpret_cast<PFN_vkVoidFunction>(encode::DestroySampler) },
    { "vkCreateDescriptorSetLayout",                                                                         reinterpret_cast<PFN_vkVoidFunction>(encode::CreateDescriptorSetLayout) },
    { "vkDestroyDescriptorSetLayout",                                                                        reinterpret_cast<PFN_vkVoidFunction>(encode::DestroyDescriptorSetLayout) },
    { "vkCreateDescriptorPool",                                                                              reinterpret_cast<PFN_vkVoidFunction>(encode::CreateDescriptorPool) },
    { "vkDestroyDescriptorPool",                                                                             reinterpret_cast<PFN_vkVoidFunction>(encode::DestroyDescriptorPool) },
    { "vkResetDescriptorPool",                                                                               reinterpret_cast<PFN_vkVoidFunction>(encode::ResetDescriptorPool) },
    { "vkAllocateDescriptorSets",                                                                            reinterpret_cast<PFN_vkVoidFunction>(encode::AllocateDescriptorSets) },
    { "vkFreeDescriptorSets",                                                                                reinterpret_cast<PFN_vkVoidFunction>(encode::FreeDescriptorSets) },
    { "vkUpdateDescriptorSets",                                                                              reinterpret_cast<PFN_vkVoidFunction>(encode::UpdateDescriptorSets) },
    { "vkCreateFramebuffer",                                                                                 reinterpret_cast<PFN_vkVoidFunction>(encode::CreateFramebuffer) },
    { "vkDestroyFramebuffer",                                                                                reinterpret_cast<PFN_vkVoidFunction>(encode::DestroyFramebuffer) },
    { "vkCreateRenderPass",                                                                                  reinterpret_cast<PFN_vkVoidFunction>(encode::CreateRenderPass) },
    { "vkDestroyRenderPass",                                                                                 reinterpret_cast<PFN_vkVoidFunction>(encode::DestroyRenderPass) },
    { "vkGetRenderAreaGranularity",                                                                          reinterpret_cast<PFN_vkVoidFunction>(encode::GetRenderAreaGranularity) },
    { "vkCreateCommandPool",                                                                                 reinterpret_cast<PFN_vkVoidFunction>(encode::CreateCommandPool) },
    { "vkDestroyCommandPool",                                                                                reinterpret_cast<PFN_vkVoidFunction>(encode::DestroyCommandPool) },
    { "vkResetCommandPool",                                                                                  reinterpret_cast<PFN_vkVoidFunction>(encode::ResetCommandPool) },
    { "vkAllocateCommandBuffers",                                                                            reinterpret_cast<PFN_vkVoidFunction>(encode::AllocateCommandBuffers) },
    { "vkFreeCommandBuffers",                                                                                reinterpret_cast<PFN_vkVoidFunction>(encode::FreeCommandBuffers) },
    { "vkBeginCommandBuffer",                                                                                reinterpret_cast<PFN_vkVoidFunction>(encode::BeginCommandBuffer) },
    { "vkEndCommandBuffer",                                                                                  reinterpret_cast<PFN_vkVoidFunction>(encode::EndCommandBuffer) },
    { "vkResetCommandBuffer",                                                                                reinterpret_cast<PFN_vkVoidFunction>(encode::ResetCommandBuffer) },
    { "vkCmdBindPipeline",                                                                                   reinterpret_cast<PFN_vkVoidFunction>(encode::CmdBindPipeline) },
    { "vkCmdSetViewport",                                                                                    reinterpret_cast<PFN_vkVoidFunction>(encode::CmdSetViewport) },
    { "vkCmdSetScissor",                                                                                     reinterpret_cast<PFN_vkVoidFunction>(encode::CmdSetScissor) },
    { "vkCmdSetLineWidth",                                                                                   reinterpret_cast<PFN_vkVoidFunction>(encode::CmdSetLineWidth) },
    { "vkCmdSetDepthBias",                                                                                   reinterpret_cast<PFN_vkVoidFunction>(encode::CmdSetDepthBias) },
    { "vkCmdSetBlendConstants",                                                                              reinterpret_cast<PFN_vkVoidFunction>(encode::CmdSetBlendConstants) },
    { "vkCmdSetDepthBounds",                                                                                 reinterpret_cast<PFN_vkVoidFunction>(encode::CmdSetDepthBounds) },
    { "vkCmdSetStencilCompareMask",                                                                          reinterpret_cast<PFN_vkVoidFunction>(encode::CmdSetStencilCompareMask) },
    { "vkCmdSetStencilWriteMask",                                                                            reinterpret_cast<PFN_vkVoidFunction>(encode::CmdSetStencilWriteMask) },
    { "vkCmdSetStencilReference",                                                                            reinterpret_cast<PFN_vkVoidFunction>(encode::CmdSetStencilReference) },
    { "vkCmdBindDescriptorSets",                                                                             reinterpret_cast<PFN_vkVoidFunction>(encode::CmdBindDescriptorSets) },
    { "vkCmdBindIndexBuffer",                                                                                reinterpret_cast<PFN_vkVoidFunction>(encode::CmdBindIndexBuffer) },
    { "vkCmdBindVertexBuffers",                                                                              reinterpret_cast<PFN_vkVoidFunction>(encode::CmdBindVertexBuffers) },
    { "vkCmdDraw",                                                                                           reinterpret_cast<PFN_vkVoidFunction>(encode::CmdDraw) },
    { "vkCmdDrawIndexed",                                                                                    reinterpret_cast<PFN_vkVoidFunction>(encode::CmdDrawIndexed) },
    { "vkCmdDrawIndirect",                                                                                   reinterpret_cast<PFN_vkVoidFunction>(encode::CmdDrawIndirect) },
    { "vkCmdDrawIndexedIndirect",                                                                            reinterpret_cast<PFN_vkVoidFunction>(encode::CmdDrawIndexedIndirect) },
    { "vkCmdDispatch",                                                                                       reinterpret_cast<PFN_vkVoidFunction>(encode::CmdDispatch) },
    { "vkCmdDispatchIndirect",                                                                               reinterpret_cast<PFN_vkVoidFunction>(encode::CmdDispatchIndirect) },
    { "vkCmdCopyBuffer",                                                                                     reinterpret_cast<PFN_vkVoidFunction>(encode::CmdCopyBuffer) },
    { "vkCmdCopyImage",                                                                                      reinterpret_cast<PFN_vkVoidFunction>(encode::CmdCopyImage) },
    { "vkCmdBlitImage",                                                                                      reinterpret_cast<PFN_vkVoidFunction>(encode::CmdBlitImage) },
    { "vkCmdCopyBufferToImage",                                                                              reinterpret_cast<PFN_vkVoidFunction>(encode::CmdCopyBufferToImage) },
    { "vkCmdCopyImageToBuffer",                                                                              reinterpret_cast<PFN_vkVoidFunction>(encode::CmdCopyImageToBuffer) },
    { "vkCmdUpdateBuffer",                                                                                   reinterpret_cast<PFN_vkVoidFunction>(encode::CmdUpdateBuffer) },
    { "vkCmdFillBuffer",                                                                                     reinterpret_cast<PFN_vkVoidFunction>(encode::CmdFillBuffer) },
    { "vkCmdClearColorImage",                                                                                reinterpret_cast<PFN_vkVoidFunction>(encode::CmdClearColorImage) },
    { "vkCmdClearDepthStencilImage",                                                                         reinterpret_cast<PFN_vkVoidFunction>(encode::CmdClearDepthStencilImage) },
    { "vkCmdClearAttachments",                                                                               reinterpret_cast<PFN_vkVoidFunction>(encode::CmdClearAttachments) },
    { "vkCmdResolveImage",                                                                                   reinterpret_cast<PFN_vkVoidFunction>(encode::CmdResolveImage) },
    { "vkCmdSetEvent",                                                                                       reinterpret_cast<PFN_vkVoidFunction>(encode::CmdSetEvent) },
    { "vkCmdResetEvent",                                                                                     reinterpret_cast<PFN_vkVoidFunction>(encode::CmdResetEvent) },
    { "vkCmdWaitEvents",                                                                                     reinterpret_cast<PFN_vkVoidFunction>(encode::CmdWaitEvents) },
    { "vkCmdPipelineBarrier",                                                                                reinterpret_cast<PFN_vkVoidFunction>(encode::CmdPipelineBarrier) },
    { "vkCmdBeginQuery",                                                                                     reinterpret_cast<PFN_vkVoidFunction>(encode::CmdBeginQuery) },
    { "vkCmdEndQuery",                                                                                       reinterpret_cast<PFN_vkVoidFunction>(encode::CmdEndQuery) },
    { "vkCmdResetQueryPool",                                                                                 reinterpret_cast<PFN_vkVoidFunction>(encode::CmdResetQueryPool) },
    { "vkCmdWriteTimestamp",                                                                                 reinterpret_cast<PFN_vkVoidFunction>(encode::CmdWriteTimestamp) },
    { "vkCmdCopyQueryPoolResults",                                                                           reinterpret_cast<PFN_vkVoidFunction>(encode::CmdCopyQueryPoolResults) },
    { "vkCmdPushConstants",                                                                                  reinterpret_cast<PFN_vkVoidFunction>(encode::CmdPushConstants) },
    { "vkCmdBeginRenderPass",                                                                                reinterpret_cast<PFN_vkVoidFunction>(encode::CmdBeginRenderPass) },
    { "vkCmdNextSubpass",                                                                                    reinterpret_cast<PFN_vkVoidFunction>(encode::CmdNextSubpass) },
    { "vkCmdEndRenderPass",                                                                                  reinterpret_cast<PFN_vkVoidFunction>(encode::CmdEndRenderPass) },
    { "vkCmdExecuteCommands",                                                                                reinterpret_cast<PFN_vkVoidFunction>(encode::CmdExecuteCommands) },
    { "vkBindBufferMemory2",                                                                                 reinterpret_cast<PFN_vkVoidFunction>(encode::BindBufferMemory2) },
    { "vkBindImageMemory2",                                                                                  reinterpret_cast<PFN_vkVoidFunction>(encode::BindImageMemory2) },
    { "vkGetDeviceGroupPeerMemoryFeatures",                                                                  reinterpret_cast<PFN_vkVoidFunction>(encode::GetDeviceGroupPeerMemoryFeatures) },
    { "vkCmdSetDeviceMask",                                                                                  reinterpret_cast<PFN_vkVoidFunction>(encode::CmdSetDeviceMask) },
    { "vkCmdDispatchBase",                                                                                   reinterpret_cast<PFN_vkVoidFunction>(encode::CmdDispatchBase) },
    { "vkEnumeratePhysicalDeviceGroups",                                                                     reinterpret_cast<PFN_vkVoidFunction>(encode::EnumeratePhysicalDeviceGroups) },
    { "vkGetImageMemoryRequirements2",                                                                       reinterpret_cast<PFN_vkVoidFunction>(encode::GetImageMemoryRequirements2) },
    { "vkGetBufferMemoryRequirements2",                                                                      reinterpret_cast<PFN_vkVoidFunction>(encode::GetBufferMemoryRequirements2) },
    { "vkGetImageSparseMemoryRequirements2",                                                                 reinterpret_cast<PFN_vkVoidFunction>(encode::GetImageSparseMemoryRequirements2) },
    { "vkGetPhysicalDeviceFeatures2",                                                                        reinterpret_cast<PFN_vkVoidFunction>(encode::GetPhysicalDeviceFeatures2) },
    { "vkGetPhysicalDeviceProperties2",                                                                      reinterpret_cast<PFN_vkVoidFunction>(encode::GetPhysicalDeviceProperties2) },
    { "vkGetPhysicalDeviceFormatProperties2",                                                                reinterpret_cast<PFN_vkVoidFunction>(encode::GetPhysicalDeviceFormatProperties2) },
    { "vkGetPhysicalDeviceImageFormatProperties2",                                                           reinterpret_cast<PFN_vkVoidFunction>(encode::GetPhysicalDeviceImageFormatProperties2) },
    { "vkGetPhysicalDeviceQueueFamilyProperties2",                                                           reinterpret_cast<PFN_vkVoidFunction>(encode::GetPhysicalDeviceQueueFamilyProperties2) },
    { "vkGetPhysicalDeviceMemoryProperties2",                                                                reinterpret_cast<PFN_vkVoidFunction>(encode::GetPhysicalDeviceMemoryProperties2) },
    { "vkGetPhysicalDeviceSparseImageFormatProperties2",                                                     reinterpret_cast<PFN_vkVoidFunction>(encode::GetPhysicalDeviceSparseImageFormatProperties2) },
    { "vkTrimCommandPool",                                                                                   reinterpret_cast<PFN_vkVoidFunction>(encode::TrimCommandPool) },
    { "vkGetDeviceQueue2",                                                                                   reinterpret_cast<PFN_vkVoidFunction>(encode::GetDeviceQueue2) },
    { "vkCreateSamplerYcbcrConversion",                                                                      reinterpret_cast<PFN_vkVoidFunction>(encode::CreateSamplerYcbcrConversion) },
    { "vkDestroySamplerYcbcrConversion",                                                                     reinterpret_cast<PFN_vkVoidFunction>(encode::DestroySamplerYcbcrConversion) },
    { "vkCreateDescriptorUpdateTemplate",                                                                    reinterpret_cast<PFN_vkVoidFunction>(encode::CreateDescriptorUpdateTemplate) },
    { "vkDestroyDescriptorUpdateTemplate",                                                                   reinterpret_cast<PFN_vkVoidFunction>(encode::DestroyDescriptorUpdateTemplate) },
    { "vkUpdateDescriptorSetWithTemplate",                                                                   reinterpret_cast<PFN_vkVoidFunction>(encode::UpdateDescriptorSetWithTemplate) },
    { "vkGetPhysicalDeviceExternalBufferProperties",                                                         reinterpret_cast<PFN_vkVoidFunction>(encode::GetPhysicalDeviceExternalBufferProperties) },
    { "vkGetPhysicalDeviceExternalFenceProperties",                                                          reinterpret_cast<PFN_vkVoidFunction>(encode::GetPhysicalDeviceExternalFenceProperties) },
    { "vkGetPhysicalDeviceExternalSemaphoreProperties",                                                      reinterpret_cast<PFN_vkVoidFunction>(encode::GetPhysicalDeviceExternalSemaphoreProperties) },
    { "vkGetDescriptorSetLayoutSupport",                                                                     reinterpret_cast<PFN_vkVoidFunction>(encode::GetDescriptorSetLayoutSupport) },
    { "vkCmdDrawIndirectCount",                                                                              reinterpret_cast<PFN_vkVoidFunction>(encode::CmdDrawIndirectCount) },
    { "vkCmdDrawIndexedIndirectCount",                                                                       reinterpret_cast<PFN_vkVoidFunction>(encode::CmdDrawIndexedIndirectCount) },
    { "vkCreateRenderPass2",                                                                                 reinterpret_cast<PFN_vkVoidFunction>(encode::CreateRenderPass2) },
    { "vkCmdBeginRenderPass2",                                                                               reinterpret_cast<PFN_vkVoidFunction>(encode::CmdBeginRenderPass2) },
    { "vkCmdNextSubpass2",                                                                                   reinterpret_cast<PFN_vkVoidFunction>(encode::CmdNextSubpass2) },
    { "vkCmdEndRenderPass2",                                                                                 reinterpret_cast<PFN_vkVoidFunction>(encode::CmdEndRenderPass2) },
    { "vkResetQueryPool",                                                                                    reinterpret_cast<PFN_vkVoidFunction>(encode::ResetQueryPool) },
    { "vkGetSemaphoreCounterValue",                                                                          reinterpret_cast<PFN_vkVoidFunction>(encode::GetSemaphoreCounterValue) },
    { "vkWaitSemaphores",                                                                                    reinterpret_cast<PFN_vkVoidFunction>(encode::WaitSemaphores) },
    { "vkSignalSemaphore",                                                                                   reinterpret_cast<PFN_vkVoidFunction>(encode::SignalSemaphore) },
    { "vkGetBufferDeviceAddress",                                                                            reinterpret_cast<PFN_vkVoidFunction>(encode::GetBufferDeviceAddress) },
    { "vkGetBufferOpaqueCaptureAddress",                                                                     reinterpret_cast<PFN_vkVoidFunction>(encode::GetBufferOpaqueCaptureAddress) },
    { "vkGetDeviceMemoryOpaqueCaptureAddress",                                                               reinterpret_cast<PFN_vkVoidFunction>(encode::GetDeviceMemoryOpaqueCaptureAddress) },
    { "vkGetPhysicalDeviceToolProperties",                                                                   reinterpret_cast<PFN_vkVoidFunction>(encode::GetPhysicalDeviceToolProperties) },
    { "vkCreatePrivateDataSlot",                                                                             reinterpret_cast<PFN_vkVoidFunction>(encode::CreatePrivateDataSlot) },
    { "vkDestroyPrivateDataSlot",                                                                            reinterpret_cast<PFN_vkVoidFunction>(encode::DestroyPrivateDataSlot) },
    { "vkSetPrivateData",                                                                                    reinterpret_cast<PFN_vkVoidFunction>(encode::SetPrivateData) },
    { "vkGetPrivateData",                                                                                    reinterpret_cast<PFN_vkVoidFunction>(encode::GetPrivateData) },
    { "vkCmdSetEvent2",                                                                                      reinterpret_cast<PFN_vkVoidFunction>(encode::CmdSetEvent2) },
    { "vkCmdResetEvent2",                                                                                    reinterpret_cast<PFN_vkVoidFunction>(encode::CmdResetEvent2) },
    { "vkCmdWaitEvents2",                                                                                    reinterpret_cast<PFN_vkVoidFunction>(encode::CmdWaitEvents2) },
    { "vkCmdPipelineBarrier2",                                                                               reinterpret_cast<PFN_vkVoidFunction>(encode::CmdPipelineBarrier2) },
    { "vkCmdWriteTimestamp2",                                                                                reinterpret_cast<PFN_vkVoidFunction>(encode::CmdWriteTimestamp2) },
    { "vkQueueSubmit2",                                                                                      reinterpret_cast<PFN_vkVoidFunction>(encode::QueueSubmit2) },
    { "vkCmdCopyBuffer2",                                                                                    reinterpret_cast<PFN_vkVoidFunction>(encode::CmdCopyBuffer2) },
    { "vkCmdCopyImage2",                                                                                     reinterpret_cast<PFN_vkVoidFunction>(encode::CmdCopyImage2) },
    { "vkCmdCopyBufferToImage2",                                                                             reinterpret_cast<PFN_vkVoidFunction>(encode::CmdCopyBufferToImage2) },
    { "vkCmdCopyImageToBuffer2",                                                                             reinterpret_cast<PFN_vkVoidFunction>(encode::CmdCopyImageToBuffer2) },
    { "vkCmdBlitImage2",                                                                                     reinterpret_cast<PFN_vkVoidFunction>(encode::CmdBlitImage2) },
    { "vkCmdResolveImage2",                                                                                  reinterpret_cast<PFN_vkVoidFunction>(encode::CmdResolveImage2) },
    { "vkCmdBeginRendering",                                                                                 reinterpret_cast<PFN_vkVoidFunction>(encode::CmdBeginRendering) },
    { "vkCmdEndRendering",                                                                                   reinterpret_cast<PFN_vkVoidFunction>(encode::CmdEndRendering) },
    { "vkCmdSetCullMode",                                                                                    reinterpret_cast<PFN_vkVoidFunction>(encode::CmdSetCullMode) },
    { "vkCmdSetFrontFace",                                                                                   reinterpret_cast<PFN_vkVoidFunction>(encode::CmdSetFrontFace) },
    { "vkCmdSetPrimitiveTopology",                                                                           reinterpret_cast<PFN_vkVoidFunction>(encode::CmdSetPrimitiveTopology) },
    { "vkCmdSetViewportWithCount",                                                                           reinterpret_cast<PFN_vkVoidFunction>(encode::CmdSetViewportWithCount) },
    { "vkCmdSetScissorWithCount",                                                                            reinterpret_cast<PFN_vkVoidFunction>(encode::CmdSetScissorWithCount) },
    { "vkCmdBindVertexBuffers2",                                                                             reinterpret_cast<PFN_vkVoidFunction>(encode::CmdBindVertexBuffers2) },
    { "vkCmdSetDepthTestEnable",                                                                             reinterpret_cast<PFN_vkVoidFunction>(encode::CmdSetDepthTestEnable) },
    { "vkCmdSetDepthWriteEnable",                                                                            reinterpret_cast<PFN_vkVoidFunction>(encode::CmdSetDepthWriteEnable) },
    { "vkCmdSetDepthCompareOp",                                                                              reinterpret_cast<PFN_vkVoidFunction>(encode::CmdSetDepthCompareOp) },
    { "vkCmdSetDepthBoundsTestEnable",                                                                       reinterpret_cast<PFN_vkVoidFunction>(encode::CmdSetDepthBoundsTestEnable) },
    { "vkCmdSetStencilTestEnable",                                                                           reinterpret_cast<PFN_vkVoidFunction>(encode::CmdSetStencilTestEnable) },
    { "vkCmdSetStencilOp",                                                                                   reinterpret_cast<PFN_vkVoidFunction>(encode::CmdSetStencilOp) },
    { "vkCmdSetRasterizerDiscardEnable",                                                                     reinterpret_cast<PFN_vkVoidFunction>(encode::CmdSetRasterizerDiscardEnable) },
    { "vkCmdSetDepthBiasEnable",                                                                             reinterpret_cast<PFN_vkVoidFunction>(encode::CmdSetDepthBiasEnable) },
    { "vkCmdSetPrimitiveRestartEnable",                                                                      reinterpret_cast<PFN_vkVoidFunction>(encode::CmdSetPrimitiveRestartEnable) },
    { "vkGetDeviceBufferMemoryRequirements",                                                                 reinterpret_cast<PFN_vkVoidFunction>(encode::GetDeviceBufferMemoryRequirements) },
    { "vkGetDeviceImageMemoryRequirements",                                                                  reinterpret_cast<PFN_vkVoidFunction>(encode::GetDeviceImageMemoryRequirements) },
    { "vkGetDeviceImageSparseMemoryRequirements",                                                            reinterpret_cast<PFN_vkVoidFunction>(encode::GetDeviceImageSparseMemoryRequirements) },
    { "vkDestroySurfaceKHR",                                                                                 reinterpret_cast<PFN_vkVoidFunction>(encode::DestroySurfaceKHR) },
    { "vkGetPhysicalDeviceSurfaceSupportKHR",                                                                reinterpret_cast<PFN_vkVoidFunction>(encode::GetPhysicalDeviceSurfaceSupportKHR) },
    { "vkGetPhysicalDeviceSurfaceCapabilitiesKHR",                                                           reinterpret_cast<PFN_vkVoidFunction>(encode::GetPhysicalDeviceSurfaceCapabilitiesKHR) },
    { "vkGetPhysicalDeviceSurfaceFormatsKHR",                                                                reinterpret_cast<PFN_vkVoidFunction>(encode::GetPhysicalDeviceSurfaceFormatsKHR) },
    { "vkGetPhysicalDeviceSurfacePresentModesKHR",                                                           reinterpret_cast<PFN_vkVoidFunction>(encode::GetPhysicalDeviceSurfacePresentModesKHR) },
    { "vkCreateSwapchainKHR",                                                                                reinterpret_cast<PFN_vkVoidFunction>(encode::CreateSwapchainKHR) },
    { "vkDestroySwapchainKHR",                                                                               reinterpret_cast<PFN_vkVoidFunction>(encode::DestroySwapchainKHR) },
    { "vkGetSwapchainImagesKHR",                                                                             reinterpret_cast<PFN_vkVoidFunction>(encode::GetSwapchainImagesKHR) },
    { "vkAcquireNextImageKHR",                                                                               reinterpret_cast<PFN_vkVoidFunction>(encode::AcquireNextImageKHR) },
    { "vkQueuePresentKHR",                                                                                   reinterpret_cast<PFN_vkVoidFunction>(encode::QueuePresentKHR) },
    { "vkGetDeviceGroupPresentCapabilitiesKHR",                                                              reinterpret_cast<PFN_vkVoidFunction>(encode::GetDeviceGroupPresentCapabilitiesKHR) },
    { "vkGetDeviceGroupSurfacePresentModesKHR",                                                              reinterpret_cast<PFN_vkVoidFunction>(encode::GetDeviceGroupSurfacePresentModesKHR) },
    { "vkGetPhysicalDevicePresentRectanglesKHR",                                                             reinterpret_cast<PFN_vkVoidFunction>(encode::GetPhysicalDevicePresentRectanglesKHR) },
    { "vkAcquireNextImage2KHR",                                                                              reinterpret_cast<PFN_vkVoidFunction>(encode::AcquireNextImage2KHR) },
    { "vkGetPhysicalDeviceDisplayPropertiesKHR",                                                             reinterpret_cast<PFN_vkVoidFunction>(encode::GetPhysicalDeviceDisplayPropertiesKHR) },
    { "vkGetPhysicalDeviceDisplayPlanePropertiesKHR",                                                        reinterpret_cast<PFN_vkVoidFunction>(encode::GetPhysicalDeviceDisplayPlanePropertiesKHR) },
    { "vkGetDisplayPlaneSupportedDisplaysKHR",                                                               reinterpret_cast<PFN_vkVoidFunction>(encode::GetDisplayPlaneSupportedDisplaysKHR) },
    { "vkGetDisplayModePropertiesKHR",                                                                       reinterpret_cast<PFN_vkVoidFunction>(encode::GetDisplayModePropertiesKHR) },
    { "vkCreateDisplayModeKHR",                                                                              reinterpret_cast<PFN_vkVoidFunction>(encode::CreateDisplayModeKHR) },
    { "vkGetDisplayPlaneCapabilitiesKHR",                                                                    reinterpret_cast<PFN_vkVoidFunction>(encode::GetDisplayPlaneCapabilitiesKHR) },
    { "vkCreateDisplayPlaneSurfaceKHR",                                                                      reinterpret_cast<PFN_vkVoidFunction>(encode::CreateDisplayPlaneSurfaceKHR) },
    { "vkCreateSharedSwapchainsKHR",                                                                         reinterpret_cast<PFN_vkVoidFunction>(encode::CreateSharedSwapchainsKHR) },
    { "vkCreateXlibSurfaceKHR",                                                                              reinterpret_cast<PFN_vkVoidFunction>(encode::CreateXlibSurfaceKHR) },
    { "vkGetPhysicalDeviceXlibPresentationSupportKHR",                                                       reinterpret_cast<PFN_vkVoidFunction>(encode::GetPhysicalDeviceXlibPresentationSupportKHR) },
    { "vkCreateXcbSurfaceKHR",                                                                               reinterpret_cast<PFN_vkVoidFunction>(encode::CreateXcbSurfaceKHR) },
    { "vkGetPhysicalDeviceXcbPresentationSupportKHR",                                                        reinterpret_cast<PFN_vkVoidFunction>(encode::GetPhysicalDeviceXcbPresentationSupportKHR) },
    { "vkCreateWaylandSurfaceKHR",                                                                           reinterpret_cast<PFN_vkVoidFunction>(encode::CreateWaylandSurfaceKHR) },
    { "vkGetPhysicalDeviceWaylandPresentationSupportKHR",                                                    reinterpret_cast<PFN_vkVoidFunction>(encode::GetPhysicalDeviceWaylandPresentationSupportKHR) },
    { "vkCreateAndroidSurfaceKHR",                                                                           reinterpret_cast<PFN_vkVoidFunction>(encode::CreateAndroidSurfaceKHR) },
    { "vkCreateWin32SurfaceKHR",                                                                             reinterpret_cast<PFN_vkVoidFunction>(encode::CreateWin32SurfaceKHR) },
    { "vkGetPhysicalDeviceWin32PresentationSupportKHR",                                                      reinterpret_cast<PFN_vkVoidFunction>(encode::GetPhysicalDeviceWin32PresentationSupportKHR) },
    { "vkCmdBeginRenderingKHR",                                                                              reinterpret_cast<PFN_vkVoidFunction>(encode::CmdBeginRenderingKHR) },
    { "vkCmdEndRenderingKHR",                                                                                reinterpret_cast<PFN_vkVoidFunction>(encode::CmdEndRenderingKHR) },
    { "vkGetPhysicalDeviceFeatures2KHR",                                                                     reinterpret_cast<PFN_vkVoidFunction>(encode::GetPhysicalDeviceFeatures2KHR) },
    { "vkGetPhysicalDeviceProperties2KHR",                                                                   reinterpret_cast<PFN_vkVoidFunction>(encode::GetPhysicalDeviceProperties2KHR) },
    { "vkGetPhysicalDeviceFormatProperties2KHR",                                                             reinterpret_cast<PFN_vkVoidFunction>(encode::GetPhysicalDeviceFormatProperties2KHR) },
    { "vkGetPhysicalDeviceImageFormatProperties2KHR",                                                        reinterpret_cast<PFN_vkVoidFunction>(encode::GetPhysicalDeviceImageFormatProperties2KHR) },
    { "vkGetPhysicalDeviceQueueFamilyProperties2KHR",                                                        reinterpret_cast<PFN_vkVoidFunction>(encode::GetPhysicalDeviceQueueFamilyProperties2KHR) },
    { "vkGetPhysicalDeviceMemoryProperties2KHR",                                                             reinterpret_cast<PFN_vkVoidFunction>(encode::GetPhysicalDeviceMemoryProperties2KHR) },
    { "vkGetPhysicalDeviceSparseImageFormatProperties2KHR",                                                  reinterpret_cast<PFN_vkVoidFunction>(encode::GetPhysicalDeviceSparseImageFormatProperties2KHR) },
    { "vkGetDeviceGroupPeerMemoryFeaturesKHR",                                                               reinterpret_cast<PFN_vkVoidFunction>(encode::GetDeviceGroupPeerMemoryFeaturesKHR) },
    { "vkCmdSetDeviceMaskKHR",                                                                               reinterpret_cast<PFN_vkVoidFunction>(encode::CmdSetDeviceMaskKHR) },
    { "vkCmdDispatchBaseKHR",                                                                                reinterpret_cast<PFN_vkVoidFunction>(encode::CmdDispatchBaseKHR) },
    { "vkTrimCommandPoolKHR",                                                                                reinterpret_cast<PFN_vkVoidFunction>(encode::TrimCommandPoolKHR) },
    { "vkEnumeratePhysicalDeviceGroupsKHR",                                                                  reinterpret_cast<PFN_vkVoidFunction>(encode::EnumeratePhysicalDeviceGroupsKHR) },
    { "vkGetPhysicalDeviceExternalBufferPropertiesKHR",                                                      reinterpret_cast<PFN_vkVoidFunction>(encode::GetPhysicalDeviceExternalBufferPropertiesKHR) },
    { "vkGetMemoryWin32HandleKHR",                                                                           reinterpret_cast<PFN_vkVoidFunction>(encode::GetMemoryWin32HandleKHR) },
    { "vkGetMemoryWin32HandlePropertiesKHR",                                                                 reinterpret_cast<PFN_vkVoidFunction>(encode::GetMemoryWin32HandlePropertiesKHR) },
    { "vkGetMemoryFdKHR",                                                                                    reinterpret_cast<PFN_vkVoidFunction>(encode::GetMemoryFdKHR) },
    { "vkGetMemoryFdPropertiesKHR",                                                                          reinterpret_cast<PFN_vkVoidFunction>(encode::GetMemoryFdPropertiesKHR) },
    { "vkGetPhysicalDeviceExternalSemaphorePropertiesKHR",                                                   reinterpret_cast<PFN_vkVoidFunction>(encode::GetPhysicalDeviceExternalSemaphorePropertiesKHR) },
    { "vkImportSemaphoreWin32HandleKHR",                                                                     reinterpret_cast<PFN_vkVoidFunction>(encode::ImportSemaphoreWin32HandleKHR) },
    { "vkGetSemaphoreWin32HandleKHR",                                                                        reinterpret_cast<PFN_vkVoidFunction>(encode::GetSemaphoreWin32HandleKHR) },
    { "vkImportSemaphoreFdKHR",                                                                              reinterpret_cast<PFN_vkVoidFunction>(encode::ImportSemaphoreFdKHR) },
    { "vkGetSemaphoreFdKHR",                                                                                 reinterpret_cast<PFN_vkVoidFunction>(encode::GetSemaphoreFdKHR) },
    { "vkCmdPushDescriptorSetKHR",                                                                           reinterpret_cast<PFN_vkVoidFunction>(encode::CmdPushDescriptorSetKHR) },
    { "vkCmdPushDescriptorSetWithTemplateKHR",                                                               reinterpret_cast<PFN_vkVoidFunction>(encode::CmdPushDescriptorSetWithTemplateKHR) },
    { "vkCreateDescriptorUpdateTemplateKHR",                                                                 reinterpret_cast<PFN_vkVoidFunction>(encode::CreateDescriptorUpdateTemplateKHR) },
    { "vkDestroyDescriptorUpdateTemplateKHR",                                                                reinterpret_cast<PFN_vkVoidFunction>(encode::DestroyDescriptorUpdateTemplateKHR) },
    { "vkUpdateDescriptorSetWithTemplateKHR",                                                                reinterpret_cast<PFN_vkVoidFunction>(encode::UpdateDescriptorSetWithTemplateKHR) },
    { "vkCreateRenderPass2KHR",                                                                              reinterpret_cast<PFN_vkVoidFunction>(encode::CreateRenderPass2KHR) },
    { "vkCmdBeginRenderPass2KHR",                                                                            reinterpret_cast<PFN_vkVoidFunction>(encode::CmdBeginRenderPass2KHR) },
    { "vkCmdNextSubpass2KHR",                                                                                reinterpret_cast<PFN_vkVoidFunction>(encode::CmdNextSubpass2KHR) },
    { "vkCmdEndRenderPass2KHR",                                                                              reinterpret_cast<PFN_vkVoidFunction>(encode::CmdEndRenderPass2KHR) },
    { "vkGetSwapchainStatusKHR",                                                                             reinterpret_cast<PFN_vkVoidFunction>(encode::GetSwapchainStatusKHR) },
    { "vkGetPhysicalDeviceExternalFencePropertiesKHR",                                                       reinterpret_cast<PFN_vkVoidFunction>(encode::GetPhysicalDeviceExternalFencePropertiesKHR) },
    { "vkImportFenceWin32HandleKHR",                                                                         reinterpret_cast<PFN_vkVoidFunction>(encode::ImportFenceWin32HandleKHR) },
    { "vkGetFenceWin32HandleKHR",                                                                            reinterpret_cast<PFN_vkVoidFunction>(encode::GetFenceWin32HandleKHR) },
    { "vkImportFenceFdKHR",                                                                                  reinterpret_cast<PFN_vkVoidFunction>(encode::ImportFenceFdKHR) },
    { "vkGetFenceFdKHR",                                                                                     reinterpret_cast<PFN_vkVoidFunction>(encode::GetFenceFdKHR) },
    { "vkEnumeratePhysicalDeviceQueueFamilyPerformanceQueryCountersKHR",                                     reinterpret_cast<PFN_vkVoidFunction>(encode::EnumeratePhysicalDeviceQueueFamilyPerformanceQueryCountersKHR) },
    { "vkGetPhysicalDeviceQueueFamilyPerformanceQueryPassesKHR",                                             reinterpret_cast<PFN_vkVoidFunction>(encode::GetPhysicalDeviceQueueFamilyPerformanceQueryPassesKHR) },
    { "vkAcquireProfilingLockKHR",                                                                           reinterpret_cast<PFN_vkVoidFunction>(encode::AcquireProfilingLockKHR) },
    { "vkReleaseProfilingLockKHR",                                                                           reinterpret_cast<PFN_vkVoidFunction>(encode::ReleaseProfilingLockKHR) },
    { "vkGetPhysicalDeviceSurfaceCapabilities2KHR",                                                          reinterpret_cast<PFN_vkVoidFunction>(encode::GetPhysicalDeviceSurfaceCapabilities2KHR) },
    { "vkGetPhysicalDeviceSurfaceFormats2KHR",                                                               reinterpret_cast<PFN_vkVoidFunction>(encode::GetPhysicalDeviceSurfaceFormats2KHR) },
    { "vkGetPhysicalDeviceDisplayProperties2KHR",                                                            reinterpret_cast<PFN_vkVoidFunction>(encode::GetPhysicalDeviceDisplayProperties2KHR) },
    { "vkGetPhysicalDeviceDisplayPlaneProperties2KHR",                                                       reinterpret_cast<PFN_vkVoidFunction>(encode::GetPhysicalDeviceDisplayPlaneProperties2KHR) },
    { "vkGetDisplayModeProperties2KHR",                                                                      reinterpret_cast<PFN_vkVoidFunction>(encode::GetDisplayModeProperties2KHR) },
    { "vkGetDisplayPlaneCapabilities2KHR",                                                                   reinterpret_cast<PFN_vkVoidFunction>(encode::GetDisplayPlaneCapabilities2KHR) },
    { "vkGetImageMemoryRequirements2KHR",                                                                    reinterpret_cast<PFN_vkVoidFunction>(encode::GetImageMemoryRequirements2KHR) },
    { "vkGetBufferMemoryRequirements2KHR",                                                                   reinterpret_cast<PFN_vkVoidFunction>(encode::GetBufferMemoryRequirements2KHR) },
    { "vkGetImageSparseMemoryRequirements2KHR",                                                              reinterpret_cast<PFN_vkVoidFunction>(encode::GetImageSparseMemoryRequirements2KHR) },
    { "vkCreateSamplerYcbcrConversionKHR",                                                                   reinterpret_cast<PFN_vkVoidFunction>(encode::CreateSamplerYcbcrConversionKHR) },
    { "vkDestroySamplerYcbcrConversionKHR",                                                                  reinterpret_cast<PFN_vkVoidFunction>(encode::DestroySamplerYcbcrConversionKHR) },
    { "vkBindBufferMemory2KHR",                                                                              reinterpret_cast<PFN_vkVoidFunction>(encode::BindBufferMemory2KHR) },
    { "vkBindImageMemory2KHR",                                                                               reinterpret_cast<PFN_vkVoidFunction>(encode::BindImageMemory2KHR) },
    { "vkGetDescriptorSetLayoutSupportKHR",                                                                  reinterpret_cast<PFN_vkVoidFunction>(encode::GetDescriptorSetLayoutSupportKHR) },
    { "vkCmdDrawIndirectCountKHR",                                                                           reinterpret_cast<PFN_vkVoidFunction>(encode::CmdDrawIndirectCountKHR) },
    { "vkCmdDrawIndexedIndirectCountKHR",                                                                    reinterpret_cast<PFN_vkVoidFunction>(encode::CmdDrawIndexedIndirectCountKHR) },
    { "vkGetSemaphoreCounterValueKHR",                                                                       reinterpret_cast<PFN_vkVoidFunction>(encode::GetSemaphoreCounterValueKHR) },
    { "vkWaitSemaphoresKHR",                                                                                 reinterpret_cast<PFN_vkVoidFunction>(encode::WaitSemaphoresKHR) },
    { "vkSignalSemaphoreKHR",                                                                                reinterpret_cast<PFN_vkVoidFunction>(encode::SignalSemaphoreKHR) },
    { "vkGetPhysicalDeviceFragmentShadingRatesKHR",                                                          reinterpret_cast<PFN_vkVoidFunction>(encode::GetPhysicalDeviceFragmentShadingRatesKHR) },
    { "vkCmdSetFragmentShadingRateKHR",                                                                      reinterpret_cast<PFN_vkVoidFunction>(encode::CmdSetFragmentShadingRateKHR) },
    { "vkWaitForPresentKHR",                                                                                 reinterpret_cast<PFN_vkVoidFunction>(encode::WaitForPresentKHR) },
    { "vkGetBufferDeviceAddressKHR",                                                                         reinterpret_cast<PFN_vkVoidFunction>(encode::GetBufferDeviceAddressKHR) },
    { "vkGetBufferOpaqueCaptureAddressKHR",                                                                  reinterpret_cast<PFN_vkVoidFunction>(encode::GetBufferOpaqueCaptureAddressKHR) },
    { "vkGetDeviceMemoryOpaqueCaptureAddressKHR",                                                            reinterpret_cast<PFN_vkVoidFunction>(encode::GetDeviceMemoryOpaqueCaptureAddressKHR) },
    { "vkCreateDeferredOperationKHR",                                                                        reinterpret_cast<PFN_vkVoidFunction>(encode::CreateDeferredOperationKHR) },
    { "vkDestroyDeferredOperationKHR",                                                                       reinterpret_cast<PFN_vkVoidFunction>(encode::DestroyDeferredOperationKHR) },
    { "vkGetDeferredOperationMaxConcurrencyKHR",                                                             reinterpret_cast<PFN_vkVoidFunction>(encode::GetDeferredOperationMaxConcurrencyKHR) },
    { "vkGetDeferredOperationResultKHR",                                                                     reinterpret_cast<PFN_vkVoidFunction>(encode::GetDeferredOperationResultKHR) },
    { "vkDeferredOperationJoinKHR",                                                                          reinterpret_cast<PFN_vkVoidFunction>(encode::DeferredOperationJoinKHR) },
    { "vkGetPipelineExecutablePropertiesKHR",                                                                reinterpret_cast<PFN_vkVoidFunction>(encode::GetPipelineExecutablePropertiesKHR) },
    { "vkGetPipelineExecutableStatisticsKHR",                                                                reinterpret_cast<PFN_vkVoidFunction>(encode::GetPipelineExecutableStatisticsKHR) },
    { "vkGetPipelineExecutableInternalRepresentationsKHR",                                                   reinterpret_cast<PFN_vkVoidFunction>(encode::GetPipelineExecutableInternalRepresentationsKHR) },
    { "vkCmdSetEvent2KHR",                                                                                   reinterpret_cast<PFN_vkVoidFunction>(encode::CmdSetEvent2KHR) },
    { "vkCmdResetEvent2KHR",                                                                                 reinterpret_cast<PFN_vkVoidFunction>(encode::CmdResetEvent2KHR) },
    { "vkCmdWaitEvents2KHR",                                                                                 reinterpret_cast<PFN_vkVoidFunction>(encode::CmdWaitEvents2KHR) },
    { "vkCmdPipelineBarrier2KHR",                                                                            reinterpret_cast<PFN_vkVoidFunction>(encode::CmdPipelineBarrier2KHR) },
    { "vkCmdWriteTimestamp2KHR",                                                                             reinterpret_cast<PFN_vkVoidFunction>(encode::CmdWriteTimestamp2KHR) },
    { "vkQueueSubmit2KHR",                                                                                   reinterpret_cast<PFN_vkVoidFunction>(encode::QueueSubmit2KHR) },
    { "vkCmdWriteBufferMarker2AMD",                                                                          reinterpret_cast<PFN_vkVoidFunction>(encode::CmdWriteBufferMarker2AMD) },
    { "vkGetQueueCheckpointData2NV",                                                                         reinterpret_cast<PFN_vkVoidFunction>(encode::GetQueueCheckpointData2NV) },
    { "vkCmdCopyBuffer2KHR",                                                                                 reinterpret_cast<PFN_vkVoidFunction>(encode::CmdCopyBuffer2KHR) },
    { "vkCmdCopyImage2KHR",                                                                                  reinterpret_cast<PFN_vkVoidFunction>(encode::CmdCopyImage2KHR) },
    { "vkCmdCopyBufferToImage2KHR",                                                                          reinterpret_cast<PFN_vkVoidFunction>(encode::CmdCopyBufferToImage2KHR) },
    { "vkCmdCopyImageToBuffer2KHR",                                                                          reinterpret_cast<PFN_vkVoidFunction>(encode::CmdCopyImageToBuffer2KHR) },
    { "vkCmdBlitImage2KHR",                                                                                  reinterpret_cast<PFN_vkVoidFunction>(encode::CmdBlitImage2KHR) },
    { "vkCmdResolveImage2KHR",                                                                               reinterpret_cast<PFN_vkVoidFunction>(encode::CmdResolveImage2KHR) },
    { "vkCmdTraceRaysIndirect2KHR",                                                                          reinterpret_cast<PFN_vkVoidFunction>(encode::CmdTraceRaysIndirect2KHR) },
    { "vkGetDeviceBufferMemoryRequirementsKHR",                                                              reinterpret_cast<PFN_vkVoidFunction>(encode::GetDeviceBufferMemoryRequirementsKHR) },
    { "vkGetDeviceImageMemoryRequirementsKHR",                                                               reinterpret_cast<PFN_vkVoidFunction>(encode::GetDeviceImageMemoryRequirementsKHR) },
    { "vkGetDeviceImageSparseMemoryRequirementsKHR",                                                         reinterpret_cast<PFN_vkVoidFunction>(encode::GetDeviceImageSparseMemoryRequirementsKHR) },
    { "vkCreateDebugReportCallbackEXT",                                                                      reinterpret_cast<PFN_vkVoidFunction>(encode::CreateDebugReportCallbackEXT) },
    { "vkDestroyDebugReportCallbackEXT",                                                                     reinterpret_cast<PFN_vkVoidFunction>(encode::DestroyDebugReportCallbackEXT) },
    { "vkDebugReportMessageEXT",                                                                             reinterpret_cast<PFN_vkVoidFunction>(encode::DebugReportMessageEXT) },
    { "vkDebugMarkerSetObjectTagEXT",                                                                        reinterpret_cast<PFN_vkVoidFunction>(encode::DebugMarkerSetObjectTagEXT) },
    { "vkDebugMarkerSetObjectNameEXT",                                                                       reinterpret_cast<PFN_vkVoidFunction>(encode::DebugMarkerSetObjectNameEXT) },
    { "vkCmdDebugMarkerBeginEXT",                                                                            reinterpret_cast<PFN_vkVoidFunction>(encode::CmdDebugMarkerBeginEXT) },
    { "vkCmdDebugMarkerEndEXT",                                                                              reinterpret_cast<PFN_vkVoidFunction>(encode::CmdDebugMarkerEndEXT) },
    { "vkCmdDebugMarkerInsertEXT",                                                                           reinterpret_cast<PFN_vkVoidFunction>(encode::CmdDebugMarkerInsertEXT) },
    { "vkCmdBindTransformFeedbackBuffersEXT",                                                                reinterpret_cast<PFN_vkVoidFunction>(encode::CmdBindTransformFeedbackBuffersEXT) },
    { "vkCmdBeginTransformFeedbackEXT",                                                                      reinterpret_cast<PFN_vkVoidFunction>(encode::CmdBeginTransformFeedbackEXT) },
    { "vkCmdEndTransformFeedbackEXT",                                                                        reinterpret_cast<PFN_vkVoidFunction>(encode::CmdEndTransformFeedbackEXT) },
    { "vkCmdBeginQueryIndexedEXT",                                                                           reinterpret_cast<PFN_vkVoidFunction>(encode::CmdBeginQueryIndexedEXT) },
    { "vkCmdEndQueryIndexedEXT",                                                                             reinterpret_cast<PFN_vkVoidFunction>(encode::CmdEndQueryIndexedEXT) },
    { "vkCmdDrawIndirectByteCountEXT",                                                                       reinterpret_cast<PFN_vkVoidFunction>(encode::CmdDrawIndirectByteCountEXT) },
    { "vkGetImageViewHandleNVX",                                                                             reinterpret_cast<PFN_vkVoidFunction>(encode::GetImageViewHandleNVX) },
    { "vkGetImageViewAddressNVX",                                                                            reinterpret_cast<PFN_vkVoidFunction>(encode::GetImageViewAddressNVX) },
    { "vkCmdDrawIndirectCountAMD",                                                                           reinterpret_cast<PFN_vkVoidFunction>(encode::CmdDrawIndirectCountAMD) },
    { "vkCmdDrawIndexedIndirectCountAMD",                                                                    reinterpret_cast<PFN_vkVoidFunction>(encode::CmdDrawIndexedIndirectCountAMD) },
    { "vkGetShaderInfoAMD",                                                                                  reinterpret_cast<PFN_vkVoidFunction>(encode::GetShaderInfoAMD) },
    { "vkCreateStreamDescriptorSurfaceGGP",                                                                  reinterpret_cast<PFN_vkVoidFunction>(encode::CreateStreamDescriptorSurfaceGGP) },
    { "vkGetPhysicalDeviceExternalImageFormatPropertiesNV",                                                  reinterpret_cast<PFN_vkVoidFunction>(encode::GetPhysicalDeviceExternalImageFormatPropertiesNV) },
    { "vkGetMemoryWin32HandleNV",                                                                            reinterpret_cast<PFN_vkVoidFunction>(encode::GetMemoryWin32HandleNV) },
    { "vkCreateViSurfaceNN",                                                                                 reinterpret_cast<PFN_vkVoidFunction>(encode::CreateViSurfaceNN) },
    { "vkCmdBeginConditionalRenderingEXT",                                                                   reinterpret_cast<PFN_vkVoidFunction>(encode::CmdBeginConditionalRenderingEXT) },
    { "vkCmdEndConditionalRenderingEXT",                                                                     reinterpret_cast<PFN_vkVoidFunction>(encode::CmdEndConditionalRenderingEXT) },
    { "vkCmdSetViewportWScalingNV",                                                                          reinterpret_cast<PFN_vkVoidFunction>(encode::CmdSetViewportWScalingNV) },
    { "vkReleaseDisplayEXT",                                                                                 reinterpret_cast<PFN_vkVoidFunction>(encode::ReleaseDisplayEXT) },
    { "vkAcquireXlibDisplayEXT",                                                                             reinterpret_cast<PFN_vkVoidFunction>(encode::AcquireXlibDisplayEXT) },
    { "vkGetRandROutputDisplayEXT",                                                                          reinterpret_cast<PFN_vkVoidFunction>(encode::GetRandROutputDisplayEXT) },
    { "vkGetPhysicalDeviceSurfaceCapabilities2EXT",                                                          reinterpret_cast<PFN_vkVoidFunction>(encode::GetPhysicalDeviceSurfaceCapabilities2EXT) },
    { "vkDisplayPowerControlEXT",                                                                            reinterpret_cast<PFN_vkVoidFunction>(encode::DisplayPowerControlEXT) },
    { "vkRegisterDeviceEventEXT",                                                                            reinterpret_cast<PFN_vkVoidFunction>(encode::RegisterDeviceEventEXT) },
    { "vkRegisterDisplayEventEXT",                                                                           reinterpret_cast<PFN_vkVoidFunction>(encode::RegisterDisplayEventEXT) },
    { "vkGetSwapchainCounterEXT",                                                                            reinterpret_cast<PFN_vkVoidFunction>(encode::GetSwapchainCounterEXT) },
    { "vkGetRefreshCycleDurationGOOGLE",                                                                     reinterpret_cast<PFN_vkVoidFunction>(encode::GetRefreshCycleDurationGOOGLE) },
    { "vkGetPastPresentationTimingGOOGLE",                                                                   reinterpret_cast<PFN_vkVoidFunction>(encode::GetPastPresentationTimingGOOGLE) },
    { "vkCmdSetDiscardRectangleEXT",                                                                         reinterpret_cast<PFN_vkVoidFunction>(encode::CmdSetDiscardRectangleEXT) },
    { "vkSetHdrMetadataEXT",                                                                                 reinterpret_cast<PFN_vkVoidFunction>(encode::SetHdrMetadataEXT) },
    { "vkCreateIOSSurfaceMVK",                                                                               reinterpret_cast<PFN_vkVoidFunction>(encode::CreateIOSSurfaceMVK) },
    { "vkCreateMacOSSurfaceMVK",                                                                             reinterpret_cast<PFN_vkVoidFunction>(encode::CreateMacOSSurfaceMVK) },
    { "vkSetDebugUtilsObjectNameEXT",                                                                        reinterpret_cast<PFN_vkVoidFunction>(encode::SetDebugUtilsObjectNameEXT) },
    { "vkSetDebugUtilsObjectTagEXT",                                                                         reinterpret_cast<PFN_vkVoidFunction>(encode::SetDebugUtilsObjectTagEXT) },
    { "vkQueueBeginDebugUtilsLabelEXT",                                                                      reinterpret_cast<PFN_vkVoidFunction>(encode::QueueBeginDebugUtilsLabelEXT) },
    { "vkQueueEndDebugUtilsLabelEXT",                                                                        reinterpret_cast<PFN_vkVoidFunction>(encode::QueueEndDebugUtilsLabelEXT) },
    { "vkQueueInsertDebugUtilsLabelEXT",                                                                     reinterpret_cast<PFN_vkVoidFunction>(encode::QueueInsertDebugUtilsLabelEXT) },
    { "vkCmdBeginDebugUtilsLabelEXT",                                                                        reinterpret_cast<PFN_vkVoidFunction>(encode::CmdBeginDebugUtilsLabelEXT) },
    { "vkCmdEndDebugUtilsLabelEXT",                                                                          reinterpret_cast<PFN_vkVoidFunction>(encode::CmdEndDebugUtilsLabelEXT) },
    { "vkCmdInsertDebugUtilsLabelEXT",                                                                       reinterpret_cast<PFN_vkVoidFunction>(encode::CmdInsertDebugUtilsLabelEXT) },
    { "vkCreateDebugUtilsMessengerEXT",                                                                      reinterpret_cast<PFN_vkVoidFunction>(encode::CreateDebugUtilsMessengerEXT) },
    { "vkDestroyDebugUtilsMessengerEXT",                                                                     reinterpret_cast<PFN_vkVoidFunction>(encode::DestroyDebugUtilsMessengerEXT) },
    { "vkSubmitDebugUtilsMessageEXT",                                                                        reinterpret_cast<PFN_vkVoidFunction>(encode::SubmitDebugUtilsMessageEXT) },
    { "vkGetAndroidHardwareBufferPropertiesANDROID",                                                         reinterpret_cast<PFN_vkVoidFunction>(encode::GetAndroidHardwareBufferPropertiesANDROID) },
    { "vkGetMemoryAndroidHardwareBufferANDROID",                                                             reinterpret_cast<PFN_vkVoidFunction>(encode::GetMemoryAndroidHardwareBufferANDROID) },
    { "vkCmdSetSampleLocationsEXT",                                                                          reinterpret_cast<PFN_vkVoidFunction>(encode::CmdSetSampleLocationsEXT) },
    { "vkGetPhysicalDeviceMultisamplePropertiesEXT",                                                         reinterpret_cast<PFN_vkVoidFunction>(encode::GetPhysicalDeviceMultisamplePropertiesEXT) },
    { "vkGetImageDrmFormatModifierPropertiesEXT",                                                            reinterpret_cast<PFN_vkVoidFunction>(encode::GetImageDrmFormatModifierPropertiesEXT) },
    { "vkCreateValidationCacheEXT",                                                                          reinterpret_cast<PFN_vkVoidFunction>(encode::CreateValidationCacheEXT) },
    { "vkDestroyValidationCacheEXT",                                                                         reinterpret_cast<PFN_vkVoidFunction>(encode::DestroyValidationCacheEXT) },
    { "vkMergeValidationCachesEXT",                                                                          reinterpret_cast<PFN_vkVoidFunction>(encode::MergeValidationCachesEXT) },
    { "vkGetValidationCacheDataEXT",                                                                         reinterpret_cast<PFN_vkVoidFunction>(encode::GetValidationCacheDataEXT) },
    { "vkCmdBindShadingRateImageNV",                                                                         reinterpret_cast<PFN_vkVoidFunction>(encode::CmdBindShadingRateImageNV) },
    { "vkCmdSetViewportShadingRatePaletteNV",                                                                reinterpret_cast<PFN_vkVoidFunction>(encode::CmdSetViewportShadingRatePaletteNV) },
    { "vkCmdSetCoarseSampleOrderNV",                                                                         reinterpret_cast<PFN_vkVoidFunction>(encode::CmdSetCoarseSampleOrderNV) },
    { "vkCreateAccelerationStructureNV",                                                                     reinterpret_cast<PFN_vkVoidFunction>(encode::CreateAccelerationStructureNV) },
    { "vkDestroyAccelerationStructureNV",                                                                    reinterpret_cast<PFN_vkVoidFunction>(encode::DestroyAccelerationStructureNV) },
    { "vkGetAccelerationStructureMemoryRequirementsNV",                                                      reinterpret_cast<PFN_vkVoidFunction>(encode::GetAccelerationStructureMemoryRequirementsNV) },
    { "vkBindAccelerationStructureMemoryNV",                                                                 reinterpret_cast<PFN_vkVoidFunction>(encode::BindAccelerationStructureMemoryNV) },
    { "vkCmdBuildAccelerationStructureNV",                                                                   reinterpret_cast<PFN_vkVoidFunction>(encode::CmdBuildAccelerationStructureNV) },
    { "vkCmdCopyAccelerationStructureNV",                                                                    reinterpret_cast<PFN_vkVoidFunction>(encode::CmdCopyAccelerationStructureNV) },
    { "vkCmdTraceRaysNV",                                                                                    reinterpret_cast<PFN_vkVoidFunction>(encode::CmdTraceRaysNV) },
    { "vkCreateRayTracingPipelinesNV",                                                                       reinterpret_cast<PFN_vkVoidFunction>(encode::CreateRayTracingPipelinesNV) },
    { "vkGetRayTracingShaderGroupHandlesKHR",                                                                reinterpret_cast<PFN_vkVoidFunction>(encode::GetRayTracingShaderGroupHandlesKHR) },
    { "vkGetRayTracingShaderGroupHandlesNV",                                                                 reinterpret_cast<PFN_vkVoidFunction>(encode::GetRayTracingShaderGroupHandlesNV) },
    { "vkGetAccelerationStructureHandleNV",                                                                  reinterpret_cast<PFN_vkVoidFunction>(encode::GetAccelerationStructureHandleNV) },
    { "vkCmdWriteAccelerationStructuresPropertiesNV",                                                        reinterpret_cast<PFN_vkVoidFunction>(encode::CmdWriteAccelerationStructuresPropertiesNV) },
    { "vkCompileDeferredNV",                                                                                 reinterpret_cast<PFN_vkVoidFunction>(encode::CompileDeferredNV) },
    { "vkGetMemoryHostPointerPropertiesEXT",                                                                 reinterpret_cast<PFN_vkVoidFunction>(encode::GetMemoryHostPointerPropertiesEXT) },
    { "vkCmdWriteBufferMarkerAMD",                                                                           reinterpret_cast<PFN_vkVoidFunction>(encode::CmdWriteBufferMarkerAMD) },
    { "vkGetPhysicalDeviceCalibrateableTimeDomainsEXT",                                                      reinterpret_cast<PFN_vkVoidFunction>(encode::GetPhysicalDeviceCalibrateableTimeDomainsEXT) },
    { "vkGetCalibratedTimestampsEXT",                                                                        reinterpret_cast<PFN_vkVoidFunction>(encode::GetCalibratedTimestampsEXT) },
    { "vkCmdDrawMeshTasksNV",                                                                                reinterpret_cast<PFN_vkVoidFunction>(encode::CmdDrawMeshTasksNV) },
    { "vkCmdDrawMeshTasksIndirectNV",                                                                        reinterpret_cast<PFN_vkVoidFunction>(encode::CmdDrawMeshTasksIndirectNV) },
    { "vkCmdDrawMeshTasksIndirectCountNV",                                                                   reinterpret_cast<PFN_vkVoidFunction>(encode::CmdDrawMeshTasksIndirectCountNV) },
    { "vkCmdSetExclusiveScissorNV",                                                                          reinterpret_cast<PFN_vkVoidFunction>(encode::CmdSetExclusiveScissorNV) },
    { "vkCmdSetCheckpointNV",                                                                                reinterpret_cast<PFN_vkVoidFunction>(encode::CmdSetCheckpointNV) },
    { "vkGetQueueCheckpointDataNV",                                                                          reinterpret_cast<PFN_vkVoidFunction>(encode::GetQueueCheckpointDataNV) },
    { "vkInitializePerformanceApiINTEL",                                                                     reinterpret_cast<PFN_vkVoidFunction>(encode::InitializePerformanceApiINTEL) },
    { "vkUninitializePerformanceApiINTEL",                                                                   reinterpret_cast<PFN_vkVoidFunction>(encode::UninitializePerformanceApiINTEL) },
    { "vkCmdSetPerformanceMarkerINTEL",                                                                      reinterpret_cast<PFN_vkVoidFunction>(encode::CmdSetPerformanceMarkerINTEL) },
    { "vkCmdSetPerformanceStreamMarkerINTEL",                                                                reinterpret_cast<PFN_vkVoidFunction>(encode::CmdSetPerformanceStreamMarkerINTEL) },
    { "vkCmdSetPerformanceOverrideINTEL",                                                                    reinterpret_cast<PFN_vkVoidFunction>(encode::CmdSetPerformanceOverrideINTEL) },
    { "vkAcquirePerformanceConfigurationINTEL",                                                              reinterpret_cast<PFN_vkVoidFunction>(encode::AcquirePerformanceConfigurationINTEL) },
    { "vkReleasePerformanceConfigurationINTEL",                                                              reinterpret_cast<PFN_vkVoidFunction>(encode::ReleasePerformanceConfigurationINTEL) },
    { "vkQueueSetPerformanceConfigurationINTEL",                                                             reinterpret_cast<PFN_vkVoidFunction>(encode::QueueSetPerformanceConfigurationINTEL) },
    { "vkGetPerformanceParameterINTEL",                                                                      reinterpret_cast<PFN_vkVoidFunction>(encode::GetPerformanceParameterINTEL) },
    { "vkSetLocalDimmingAMD",                                                                                reinterpret_cast<PFN_vkVoidFunction>(encode::SetLocalDimmingAMD) },
    { "vkCreateImagePipeSurfaceFUCHSIA",                                                                     reinterpret_cast<PFN_vkVoidFunction>(encode::CreateImagePipeSurfaceFUCHSIA) },
    { "vkCreateMetalSurfaceEXT",                                                                             reinterpret_cast<PFN_vkVoidFunction>(encode::CreateMetalSurfaceEXT) },
    { "vkGetBufferDeviceAddressEXT",                                                                         reinterpret_cast<PFN_vkVoidFunction>(encode::GetBufferDeviceAddressEXT) },
    { "vkGetPhysicalDeviceToolPropertiesEXT",                                                                reinterpret_cast<PFN_vkVoidFunction>(encode::GetPhysicalDeviceToolPropertiesEXT) },
    { "vkGetPhysicalDeviceCooperativeMatrixPropertiesNV",                                                    reinterpret_cast<PFN_vkVoidFunction>(encode::GetPhysicalDeviceCooperativeMatrixPropertiesNV) },
    { "vkGetPhysicalDeviceSupportedFramebufferMixedSamplesCombinationsNV",                                   reinterpret_cast<PFN_vkVoidFunction>(encode::GetPhysicalDeviceSupportedFramebufferMixedSamplesCombinationsNV) },
    { "vkGetPhysicalDeviceSurfacePresentModes2EXT",                                                          reinterpret_cast<PFN_vkVoidFunction>(encode::GetPhysicalDeviceSurfacePresentModes2EXT) },
    { "vkAcquireFullScreenExclusiveModeEXT",                                                                 reinterpret_cast<PFN_vkVoidFunction>(encode::AcquireFullScreenExclusiveModeEXT) },
    { "vkReleaseFullScreenExclusiveModeEXT",                                                                 reinterpret_cast<PFN_vkVoidFunction>(encode::ReleaseFullScreenExclusiveModeEXT) },
    { "vkGetDeviceGroupSurfacePresentModes2EXT",                                                             reinterpret_cast<PFN_vkVoidFunction>(encode::GetDeviceGroupSurfacePresentModes2EXT) },
    { "vkCreateHeadlessSurfaceEXT",                                                                          reinterpret_cast<PFN_vkVoidFunction>(encode::CreateHeadlessSurfaceEXT) },
    { "vkCmdSetLineStippleEXT",                                                                              reinterpret_cast<PFN_vkVoidFunction>(encode::CmdSetLineStippleEXT) },
    { "vkResetQueryPoolEXT",                                                                                 reinterpret_cast<PFN_vkVoidFunction>(encode::ResetQueryPoolEXT) },
    { "vkCmdSetCullModeEXT",                                                                                 reinterpret_cast<PFN_vkVoidFunction>(encode::CmdSetCullModeEXT) },
    { "vkCmdSetFrontFaceEXT",                                                                                reinterpret_cast<PFN_vkVoidFunction>(encode::CmdSetFrontFaceEXT) },
    { "vkCmdSetPrimitiveTopologyEXT",                                                                        reinterpret_cast<PFN_vkVoidFunction>(encode::CmdSetPrimitiveTopologyEXT) },
    { "vkCmdSetViewportWithCountEXT",                                                                        reinterpret_cast<PFN_vkVoidFunction>(encode::CmdSetViewportWithCountEXT) },
    { "vkCmdSetScissorWithCountEXT",                                                                         reinterpret_cast<PFN_vkVoidFunction>(encode::CmdSetScissorWithCountEXT) },
    { "vkCmdBindVertexBuffers2EXT",                                                                          reinterpret_cast<PFN_vkVoidFunction>(encode::CmdBindVertexBuffers2EXT) },
    { "vkCmdSetDepthTestEnableEXT",                                                                          reinterpret_cast<PFN_vkVoidFunction>(encode::CmdSetDepthTestEnableEXT) },
    { "vkCmdSetDepthWriteEnableEXT",                                                                         reinterpret_cast<PFN_vkVoidFunction>(encode::CmdSetDepthWriteEnableEXT) },
    { "vkCmdSetDepthCompareOpEXT",                                                                           reinterpret_cast<PFN_vkVoidFunction>(encode::CmdSetDepthCompareOpEXT) },
    { "vkCmdSetDepthBoundsTestEnableEXT",                                                                    reinterpret_cast<PFN_vkVoidFunction>(encode::CmdSetDepthBoundsTestEnableEXT) },
    { "vkCmdSetStencilTestEnableEXT",                                                                        reinterpret_cast<PFN_vkVoidFunction>(encode::CmdSetStencilTestEnableEXT) },
    { "vkCmdSetStencilOpEXT",                                                                                reinterpret_cast<PFN_vkVoidFunction>(encode::CmdSetStencilOpEXT) },
    { "vkGetGeneratedCommandsMemoryRequirementsNV",                                                          reinterpret_cast<PFN_vkVoidFunction>(encode::GetGeneratedCommandsMemoryRequirementsNV) },
    { "vkCmdPreprocessGeneratedCommandsNV",                                                                  reinterpret_cast<PFN_vkVoidFunction>(encode::CmdPreprocessGeneratedCommandsNV) },
    { "vkCmdExecuteGeneratedCommandsNV",                                                                     reinterpret_cast<PFN_vkVoidFunction>(encode::CmdExecuteGeneratedCommandsNV) },
    { "vkCmdBindPipelineShaderGroupNV",                                                                      reinterpret_cast<PFN_vkVoidFunction>(encode::CmdBindPipelineShaderGroupNV) },
    { "vkCreateIndirectCommandsLayoutNV",                                                                    reinterpret_cast<PFN_vkVoidFunction>(encode::CreateIndirectCommandsLayoutNV) },
    { "vkDestroyIndirectCommandsLayoutNV",                                                                   reinterpret_cast<PFN_vkVoidFunction>(encode::DestroyIndirectCommandsLayoutNV) },
    { "vkAcquireDrmDisplayEXT",                                                                              reinterpret_cast<PFN_vkVoidFunction>(encode::AcquireDrmDisplayEXT) },
    { "vkGetDrmDisplayEXT",                                                                                  reinterpret_cast<PFN_vkVoidFunction>(encode::GetDrmDisplayEXT) },
    { "vkCreatePrivateDataSlotEXT",                                                                          reinterpret_cast<PFN_vkVoidFunction>(encode::CreatePrivateDataSlotEXT) },
    { "vkDestroyPrivateDataSlotEXT",                                                                         reinterpret_cast<PFN_vkVoidFunction>(encode::DestroyPrivateDataSlotEXT) },
    { "vkSetPrivateDataEXT",                                                                                 reinterpret_cast<PFN_vkVoidFunction>(encode::SetPrivateDataEXT) },
    { "vkGetPrivateDataEXT",                                                                                 reinterpret_cast<PFN_vkVoidFunction>(encode::GetPrivateDataEXT) },
    { "vkCmdSetFragmentShadingRateEnumNV",                                                                   reinterpret_cast<PFN_vkVoidFunction>(encode::CmdSetFragmentShadingRateEnumNV) },
    { "vkGetImageSubresourceLayout2EXT",                                                                     reinterpret_cast<PFN_vkVoidFunction>(encode::GetImageSubresourceLayout2EXT) },
    { "vkAcquireWinrtDisplayNV",                                                                             reinterpret_cast<PFN_vkVoidFunction>(encode::AcquireWinrtDisplayNV) },
    { "vkGetWinrtDisplayNV",                                                                                 reinterpret_cast<PFN_vkVoidFunction>(encode::GetWinrtDisplayNV) },
    { "vkCreateDirectFBSurfaceEXT",                                                                          reinterpret_cast<PFN_vkVoidFunction>(encode::CreateDirectFBSurfaceEXT) },
    { "vkGetPhysicalDeviceDirectFBPresentationSupportEXT",                                                   reinterpret_cast<PFN_vkVoidFunction>(encode::GetPhysicalDeviceDirectFBPresentationSupportEXT) },
    { "vkCmdSetVertexInputEXT",                                                                              reinterpret_cast<PFN_vkVoidFunction>(encode::CmdSetVertexInputEXT) },
    { "vkGetMemoryZirconHandleFUCHSIA",                                                                      reinterpret_cast<PFN_vkVoidFunction>(encode::GetMemoryZirconHandleFUCHSIA) },
    { "vkGetMemoryZirconHandlePropertiesFUCHSIA",                                                            reinterpret_cast<PFN_vkVoidFunction>(encode::GetMemoryZirconHandlePropertiesFUCHSIA) },
    { "vkImportSemaphoreZirconHandleFUCHSIA",                                                                reinterpret_cast<PFN_vkVoidFunction>(encode::ImportSemaphoreZirconHandleFUCHSIA) },
    { "vkGetSemaphoreZirconHandleFUCHSIA",                                                                   reinterpret_cast<PFN_vkVoidFunction>(encode::GetSemaphoreZirconHandleFUCHSIA) },
    { "vkCmdBindInvocationMaskHUAWEI",                                                                       reinterpret_cast<PFN_vkVoidFunction>(encode::CmdBindInvocationMaskHUAWEI) },
    { "vkGetMemoryRemoteAddressNV",                                                                          reinterpret_cast<PFN_vkVoidFunction>(encode::GetMemoryRemoteAddressNV) },
    { "vkCmdSetPatchControlPointsEXT",                                                                       reinterpret_cast<PFN_vkVoidFunction>(encode::CmdSetPatchControlPointsEXT) },
    { "vkCmdSetRasterizerDiscardEnableEXT",                                                                  reinterpret_cast<PFN_vkVoidFunction>(encode::CmdSetRasterizerDiscardEnableEXT) },
    { "vkCmdSetDepthBiasEnableEXT",                                                                          reinterpret_cast<PFN_vkVoidFunction>(encode::CmdSetDepthBiasEnableEXT) },
    { "vkCmdSetLogicOpEXT",                                                                                  reinterpret_cast<PFN_vkVoidFunction>(encode::CmdSetLogicOpEXT) },
    { "vkCmdSetPrimitiveRestartEnableEXT",                                                                   reinterpret_cast<PFN_vkVoidFunction>(encode::CmdSetPrimitiveRestartEnableEXT) },
    { "vkCreateScreenSurfaceQNX",                                                                            reinterpret_cast<PFN_vkVoidFunction>(encode::CreateScreenSurfaceQNX) },
    { "vkGetPhysicalDeviceScreenPresentationSupportQNX",                                                     reinterpret_cast<PFN_vkVoidFunction>(encode::GetPhysicalDeviceScreenPresentationSupportQNX) },
    { "vkCmdSetColorWriteEnableEXT",                                                                         reinterpret_cast<PFN_vkVoidFunction>(encode::CmdSetColorWriteEnableEXT) },
    { "vkCmdDrawMultiEXT",                                                                                   reinterpret_cast<PFN_vkVoidFunction>(encode::CmdDrawMultiEXT) },
    { "vkCmdDrawMultiIndexedEXT",                                                                            reinterpret_cast<PFN_vkVoidFunction>(encode::CmdDrawMultiIndexedEXT) },
    { "vkSetDeviceMemoryPriorityEXT",                                                                        reinterpret_cast<PFN_vkVoidFunction>(encode::SetDeviceMemoryPriorityEXT) },
    { "vkGetDescriptorSetLayoutHostMappingInfoVALVE",                                                        reinterpret_cast<PFN_vkVoidFunction>(encode::GetDescriptorSetLayoutHostMappingInfoVALVE) },
    { "vkGetDescriptorSetHostMappingVALVE",                                                                  reinterpret_cast<PFN_vkVoidFunction>(encode::GetDescriptorSetHostMappingVALVE) },
    { "vkGetShaderModuleIdentifierEXT",                                                                      reinterpret_cast<PFN_vkVoidFunction>(encode::GetShaderModuleIdentifierEXT) },
    { "vkGetShaderModuleCreateInfoIdentifierEXT",                                                            reinterpret_cast<PFN_vkVoidFunction>(encode::GetShaderModuleCreateInfoIdentifierEXT) },
    { "vkGetFramebufferTilePropertiesQCOM",                                                                  reinterpret_cast<PFN_vkVoidFunction>(encode::GetFramebufferTilePropertiesQCOM) },
    { "vkGetDynamicRenderingTilePropertiesQCOM",                                                             reinterpret_cast<PFN_vkVoidFunction>(encode::GetDynamicRenderingTilePropertiesQCOM) },
    { "vkCreateAccelerationStructureKHR",                                                                    reinterpret_cast<PFN_vkVoidFunction>(encode::CreateAccelerationStructureKHR) },
    { "vkDestroyAccelerationStructureKHR",                                                                   reinterpret_cast<PFN_vkVoidFunction>(encode::DestroyAccelerationStructureKHR) },
    { "vkCmdBuildAccelerationStructuresKHR",                                                                 reinterpret_cast<PFN_vkVoidFunction>(encode::CmdBuildAccelerationStructuresKHR) },
    { "vkCmdBuildAccelerationStructuresIndirectKHR",                                                         reinterpret_cast<PFN_vkVoidFunction>(encode::CmdBuildAccelerationStructuresIndirectKHR) },
    { "vkBuildAccelerationStructuresKHR",                                                                    reinterpret_cast<PFN_vkVoidFunction>(encode::BuildAccelerationStructuresKHR) },
    { "vkCopyAccelerationStructureKHR",                                                                      reinterpret_cast<PFN_vkVoidFunction>(encode::CopyAccelerationStructureKHR) },
    { "vkCopyAccelerationStructureToMemoryKHR",                                                              reinterpret_cast<PFN_vkVoidFunction>(encode::CopyAccelerationStructureToMemoryKHR) },
    { "vkCopyMemoryToAccelerationStructureKHR",                                                              reinterpret_cast<PFN_vkVoidFunction>(encode::CopyMemoryToAccelerationStructureKHR) },
    { "vkWriteAccelerationStructuresPropertiesKHR",                                                          reinterpret_cast<PFN_vkVoidFunction>(encode::WriteAccelerationStructuresPropertiesKHR) },
    { "vkCmdCopyAccelerationStructureKHR",                                                                   reinterpret_cast<PFN_vkVoidFunction>(encode::CmdCopyAccelerationStructureKHR) },
    { "vkCmdCopyAccelerationStructureToMemoryKHR",                                                           reinterpret_cast<PFN_vkVoidFunction>(encode::CmdCopyAccelerationStructureToMemoryKHR) },
    { "vkCmdCopyMemoryToAccelerationStructureKHR",                                                           reinterpret_cast<PFN_vkVoidFunction>(encode::CmdCopyMemoryToAccelerationStructureKHR) },
    { "vkGetAccelerationStructureDeviceAddressKHR",                                                          reinterpret_cast<PFN_vkVoidFunction>(encode::GetAccelerationStructureDeviceAddressKHR) },
    { "vkCmdWriteAccelerationStructuresPropertiesKHR",                                                       reinterpret_cast<PFN_vkVoidFunction>(encode::CmdWriteAccelerationStructuresPropertiesKHR) },
    { "vkGetDeviceAccelerationStructureCompatibilityKHR",                                                    reinterpret_cast<PFN_vkVoidFunction>(encode::GetDeviceAccelerationStructureCompatibilityKHR) },
    { "vkGetAccelerationStructureBuildSizesKHR",                                                             reinterpret_cast<PFN_vkVoidFunction>(encode::GetAccelerationStructureBuildSizesKHR) },
    { "vkCmdTraceRaysKHR",                                                                                   reinterpret_cast<PFN_vkVoidFunction>(encode::CmdTraceRaysKHR) },
    { "vkCreateRayTracingPipelinesKHR",                                                                      reinterpret_cast<PFN_vkVoidFunction>(encode::CreateRayTracingPipelinesKHR) },
    { "vkGetRayTracingCaptureReplayShaderGroupHandlesKHR",                                                   reinterpret_cast<PFN_vkVoidFunction>(encode::GetRayTracingCaptureReplayShaderGroupHandlesKHR) },
    { "vkCmdTraceRaysIndirectKHR",                                                                           reinterpret_cast<PFN_vkVoidFunction>(encode::CmdTraceRaysIndirectKHR) },
    { "vkGetRayTracingShaderGroupStackSizeKHR",                                                              reinterpret_cast<PFN_vkVoidFunction>(encode::GetRayTracingShaderGroupStackSizeKHR) },
    { "vkCmdSetRayTracingPipelineStackSizeKHR",                                                              reinterpret_cast<PFN_vkVoidFunction>(encode::CmdSetRayTracingPipelineStackSizeKHR) },
    { "vk_layerGetPhysicalDeviceProcAddr",                                                                   reinterpret_cast<PFN_vkVoidFunction>(GetPhysicalDeviceProcAddr) },
};

GFXRECON_END_NAMESPACE(gfxrecon)

#endif
