#! /bin/bash

# Id$
# Copyright (c) 2003 Richard Offer. All rights reserved.

#
# Original Idea and Author: Richard Offer
#
#
#
# Proof of concept - use shell script to talk to a SOAP server. If this
# works then we're language independent... The only requirement being
# that the language must support reading and writing to arbitary file
# descriptors

# The file descriptor #3 has already been opened and *SOME* headers sent, 
# all this script needs to do is send the rest of the headers, the payload 
# and then read the reply


if [ $# != 1 ]
then
	echo "Usage: temp.sh <zip code>"
	exit 1
fi	

SOAPAction=""
URN="xmethods-Temperature"

body="<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n\
<SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" \n\
xmlns:xsi=\"http://www.w3.org/1999/XMLSchema-instance\" \n\
xmlns:xsd=\"http://www.w3.org/1999/XMLSchema\">\n\
<SOAP-ENV:Body>\n\
<ns1:getTemp xmlns:ns1=\"urn:xmethods-Temperature\" \n\
SOAP-ENV:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\">\n\
<zipcode xsi:type=\"xsd:string\">$1</zipcode>\n\
</ns1:getTemp>\n\
</SOAP-ENV:Body>\n\
</SOAP-ENV:Envelope>\n\
"

len=`echo -e $body | wc -c | awk '{print $1}'`

(
	echo -e "Content-type: text/xml; charset=\"UTF-8\""
	echo -e "Content-length: $len"
	echo -e "Connection: close"
	echo -e "SOAPAction: \"${SOAPAction}\""
	echo -e "\r" # end the end of headers
	echo -e "$body"
) > /dev/fd/3

while read result < /dev/fd/3
do
	echo $result
done
