/*
 * Decompiled with CFR 0.152.
 */
package gmonitor.logdata;

import gmonitor.logdata.BinaryBlock;
import gmonitor.logdata.HostDefElement;
import gmonitor.logdata.UTY;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;

public class HostDefBlock
extends BinaryBlock {
    protected ArrayList definition = new ArrayList();

    public static HostDefBlock newInstance(InputStream inputStream, int n) throws IOException {
        HostDefBlock hostDefBlock = new HostDefBlock();
        hostDefBlock.deserialize(inputStream, n);
        return hostDefBlock;
    }

    public int getCount() {
        return this.definition.size();
    }

    protected void parse_binary_block(InputStream inputStream) throws IOException {
        int n;
        byte[] byArray = new byte[STRLEN];
        for (int i = 0; i < this.size; i += n + 1) {
            HostDefElement hostDefElement = new HostDefElement();
            n = this.readBytesWithNull(inputStream, byArray);
            hostDefElement.setIpAddr(UTY.byte2String(byArray, 0, n));
            i += n + 1;
            n = this.readBytesWithNull(inputStream, byArray);
            hostDefElement.setHostname(UTY.byte2String(byArray, 0, n));
            i += n + 1;
            n = this.readBytesWithNull(inputStream, byArray);
            hostDefElement.setNickname(UTY.byte2String(byArray, 0, n));
            i += n + 1;
            n = this.readBytesWithNull(inputStream, byArray);
            hostDefElement.setCommunityString(UTY.byte2String(byArray, 0, n));
            this.definition.add(hostDefElement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("# HostDefBlock");
        ArrayList arrayList = this.definition;
        synchronized (arrayList) {
            int n = this.definition.size();
            for (int i = 0; i < n; ++i) {
                HostDefElement hostDefElement = (HostDefElement)this.definition.get(i);
                stringBuffer.append('\n');
                stringBuffer.append(hostDefElement.toString(i));
            }
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getHostIndex(String string) {
        int n = -1;
        ArrayList arrayList = this.definition;
        synchronized (arrayList) {
            for (int i = 0; i < this.definition.size(); ++i) {
                HostDefElement hostDefElement = (HostDefElement)this.definition.get(i);
                String string2 = hostDefElement.getNameAndNick();
                if (!string2.equals(string)) continue;
                n = i;
                break;
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HostDefElement getHostDefElement(int n) {
        HostDefElement hostDefElement = null;
        ArrayList arrayList = this.definition;
        synchronized (arrayList) {
            hostDefElement = (HostDefElement)this.definition.get(n);
        }
        return hostDefElement;
    }

    public boolean containsHost(String string) {
        int n = this.getHostIndex(string);
        return n >= 0;
    }
}

