#!/bin/sh 

set -e

# called by uscan with '--upstream-version' <version> <file>
echo "version $2"
package=`dpkg-parsechangelog | sed -n 's/^Source: //p'`
version=$2
tarball=$3
TAR=${package}_${version}.orig.tar.gz
DIR=${package}-${version}.orig
upstream_package="$(echo $package | sed 's/-2\.0-spec/_2.0_spec/')"
REPO="http://svn.apache.org/repos/asf/geronimo/specs/tags/${upstream_package}-${version}/"

# setting timezone to avoid varying times
TZ=Etc/UTC LC_ALL=C svn export $REPO $DIR
GZIP=--best tar --numeric --group 0 --owner 0 -c -v -z -f $TAR $DIR

rm -rf $tarball $DIR
