/*
 * Decompiled with CFR 0.152.
 */
package geotrans.gui;

import geotrans.gui.MasterPanel;
import geotrans.gui.jOptions;
import geotrans.jni.GeotransError;
import geotrans.jni.JNIException;
import geotrans.jni.JNIFiomeths;
import geotrans.jni.JNIStrtoval;
import geotrans.utility.Center;
import geotrans.utility.DATFileFilter;
import geotrans.utility.Directory;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.BevelBorder;
import javax.swing.border.LineBorder;

public class CreateFileHeaderDlg
extends JDialog {
    private Directory currentDir;
    private MasterPanel headerPanel;
    private JFrame parentFrame;
    private jOptions options;
    private JPanel createFileHeaderPanel;
    private JPanel buttonsPanel;
    private JButton createButton;
    private JButton cancelButton;

    public CreateFileHeaderDlg(JFrame parent, boolean modal, Directory dir, jOptions joptions) {
        super((Frame)parent, modal);
        this.currentDir = dir;
        this.options = joptions;
        this.parentFrame = parent;
        this.initComponents();
        this.headerPanel = new MasterPanel(2, 1, joptions);
        this.createFileHeaderPanel.add((Component)this.headerPanel, "Center");
        this.pack();
        new Center(parent, this);
    }

    private void initComponents() {
        this.createFileHeaderPanel = new JPanel();
        this.buttonsPanel = new JPanel();
        this.createButton = new JButton();
        this.cancelButton = new JButton();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Create File Header");
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                CreateFileHeaderDlg.this.closeDialog(evt);
            }
        });
        this.createFileHeaderPanel.setLayout(new BorderLayout());
        this.createFileHeaderPanel.setPreferredSize(new Dimension(467, 185));
        this.createFileHeaderPanel.setBorder(new LineBorder(Color.black));
        this.createFileHeaderPanel.setMinimumSize(new Dimension(467, 185));
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        this.getContentPane().add((Component)this.createFileHeaderPanel, gridBagConstraints1);
        this.buttonsPanel.setLayout(new GridBagLayout());
        this.buttonsPanel.setPreferredSize(new Dimension(330, 50));
        this.buttonsPanel.setMinimumSize(new Dimension(330, 50));
        this.createButton.setPreferredSize(new Dimension(80, 21));
        this.createButton.setBorder(new BevelBorder(0));
        this.createButton.setMnemonic(67);
        this.createButton.setMaximumSize(new Dimension(80, 21));
        this.createButton.setText("Create");
        this.createButton.setMinimumSize(new Dimension(80, 21));
        this.createButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CreateFileHeaderDlg.this.createButtonActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.insets = new Insets(0, 0, 12, 45);
        this.buttonsPanel.add((Component)this.createButton, gridBagConstraints2);
        this.cancelButton.setPreferredSize(new Dimension(80, 21));
        this.cancelButton.setBorder(new BevelBorder(0));
        this.cancelButton.setMnemonic(65);
        this.cancelButton.setMaximumSize(new Dimension(80, 21));
        this.cancelButton.setText("Cancel");
        this.cancelButton.setMinimumSize(new Dimension(80, 21));
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CreateFileHeaderDlg.this.cancelButtonActionPerformed(evt);
            }
        });
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.insets = new Insets(0, 0, 12, 0);
        this.buttonsPanel.add((Component)this.cancelButton, gridBagConstraints2);
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 4;
        this.getContentPane().add((Component)this.buttonsPanel, gridBagConstraints1);
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private void createButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        JFileChooser fileChooser = new JFileChooser(this.currentDir.getDirectory());
        fileChooser.setDialogTitle("Save As");
        fileChooser.addChoosableFileFilter(new DATFileFilter());
        fileChooser.setSelectedFile(new File("*.dat"));
        int state = fileChooser.showSaveDialog(this.parentFrame);
        if (state == 0) {
            this.headerPanel.setEngine();
            if (!this.headerPanel.JNIError()) {
                if (!this.headerPanel.engineError()) {
                    File file = fileChooser.getSelectedFile();
                    this.currentDir.setDirectory(file.getAbsolutePath());
                    if (file != null) {
                        JNIFiomeths jniFiomeths = new JNIFiomeths();
                        try {
                            jniFiomeths.JNIUseNSEW(this.options.getUseNSEW());
                            jniFiomeths.JNIUseMinutes(this.options.getUseMinutes());
                            jniFiomeths.JNIUseSeconds(this.options.getUseSeconds());
                            jniFiomeths.JNISetOutputFilename(file.getPath());
                            jniFiomeths.JNIWriteExampleCoord();
                            jniFiomeths.JNICloseOutputFile();
                            JOptionPane.showMessageDialog(this.parentFrame, "File header creation complete.", new JNIStrtoval().getTitle(), -1);
                            this.dispose();
                        }
                        catch (GeotransError e) {
                            new JNIStrtoval().displayErrorMsg(this, e.getMessage());
                            jniFiomeths.JNICloseOutputFile();
                        }
                        catch (JNIException e) {
                            new JNIStrtoval().displayErrorMsg(this, e.getMessage());
                            jniFiomeths.JNICloseOutputFile();
                        }
                    }
                } else {
                    this.headerPanel.showErrors(this);
                }
            } else {
                this.headerPanel.showErrors(this);
            }
        }
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }
}

