#!/bin/bash

# git bisect start
# git bisect good 6b153d67e24c36477faee2eb47e6f486b768cdc2
# git bisect bad df1fd770c96c1919f63e675f997157c1914d480e
# git bisect run ./bisect_script.sh
# 
#
# 3.8 release 6b153d67e24c36477faee2eb47e6f486b768cdc2
# 3.9 release df1fd770c96c1919f63e675f997157c1914d480e
#

ROOT=`pwd`
BLD=$ROOT/../geos-git-build
LIB=$BLD/lib
TST=$ROOT/../geos-performance/_build
PERF=$TST/geos_perf
NM="Australia buffer"
CUTOFF=200

echo "--------"
echo "Running in $ROOT"

echo "Building in $BLD"
pushd $BLD
cmake -DCMAKE_BUILD_TYPE=Release ../geos-git
make
popd

echo "Running $PERF"
export DYLD_LIBRARY_PATH=$LIB
pushd $TST
TIME=`$PERF | grep "$NM" | cut -f5 -d,`
echo "Run time = $TIME"
popd

#if [ $TIME -lt $CUTOFF ]; then
if [ $(echo "$TIME < $CUTOFF" | bc -l) -eq 1 ]; then
   # good
   exit 0
else
   # bad
   exit 1
fi
