function C4x = C4coeff(n)
%C4COEFF  Evaluate coefficients for C_4
%
%   C4x = C4COEFF(N) evaluates the coefficients of epsilon^l in expansion
%   of the area (Eq. (65) expressed in terms of n and epsi).  N is a
%   scalar.  C4x is a 1 x 21 array.

  nC4 = 6;
  nC4x = (nC4 * (nC4 + 1)) / 2;
  C4x = zeros(1, nC4x);
  C4x(0+1) = (n*(n*(n*(n*(100*n+208)+572)+3432)-12012)+30030)/45045;
  C4x(1+1) = (n*(n*(n*(64*n+624)-4576)+6864)-3003)/15015;
  C4x(2+1) = (n*((14144-10656*n)*n-4576)-858)/45045;
  C4x(3+1) = ((-224*n-4784)*n+1573)/45045;
  C4x(4+1) = (1088*n+156)/45045;
  C4x(5+1) = 97/15015;
  C4x(6+1) = (n*(n*((-64*n-624)*n+4576)-6864)+3003)/135135;
  C4x(7+1) = (n*(n*(5952*n-11648)+9152)-2574)/135135;
  C4x(8+1) = (n*(5792*n+1040)-1287)/135135;
  C4x(9+1) = (468-2944*n)/135135;
  C4x(10+1) = 1/9009;
  C4x(11+1) = (n*((4160-1440*n)*n-4576)+1716)/225225;
  C4x(12+1) = ((4992-8448*n)*n-1144)/225225;
  C4x(13+1) = (1856*n-936)/225225;
  C4x(14+1) = 8/10725;
  C4x(15+1) = (n*(3584*n-3328)+1144)/315315;
  C4x(16+1) = (1024*n-208)/105105;
  C4x(17+1) = -136/63063;
  C4x(18+1) = (832-2560*n)/405405;
  C4x(19+1) = -128/135135;
  C4x(20+1) = 128/99099;
end
