static const char* op_c_source =
"/* This file is an image processing operation for GEGL                        \n"
" *                                                                            \n"
" * GEGL is free software; you can redistribute it and/or                      \n"
" * modify it under the terms of the GNU Lesser General Public                 \n"
" * License as published by the Free Software Foundation; either               \n"
" * version 3 of the License, or (at your option) any later version.           \n"
" *                                                                            \n"
" * GEGL is distributed in the hope that it will be useful,                    \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          \n"
" * Lesser General Public License for more details.                            \n"
" *                                                                            \n"
" * You should have received a copy of the GNU Lesser General Public           \n"
" * License along with GEGL; if not, see <http://www.gnu.org/licenses/>.       \n"
" *                                                                            \n"
" * Copyright 2017 Red Hat, Inc.                                               \n"
" */                                                                           \n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"                                                                              \n"
"property_double (black, _(\"Black\"), 0.0)                                    \n"
"    description (_(\"Adjust the black level\"))                               \n"
"    value_range (-0.1, 0.1)                                                   \n"
"                                                                              \n"
"property_double (exposure, _(\"Exposure\"), 0.0)                              \n"
"    description (_(\"Adjust the exposure correction\"))                       \n"
"    value_range (-3.0, 3.0)                                                   \n"
"                                                                              \n"
"#else                                                                         \n"
"                                                                              \n"
"#define GEGL_OP_POINT_FILTER                                                  \n"
"#define GEGL_OP_NAME     dt_exposure                                          \n"
"#define GEGL_OP_C_SOURCE dt-exposure.c                                        \n"
"                                                                              \n"
"#include \"gegl-op.h\"                                                        \n"
"                                                                              \n"
"#include <math.h>                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"prepare (GeglOperation *operation)                                            \n"
"{                                                                             \n"
"  const Babl *format;                                                         \n"
"                                                                              \n"
"  format = babl_format (\"R'G'B'A float\");                                   \n"
"  gegl_operation_set_format (operation, \"input\", format);                   \n"
"  gegl_operation_set_format (operation, \"output\", format);                  \n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"process (GeglOperation       *operation,                                      \n"
"         void                *in_buf,                                         \n"
"         void                *out_buf,                                        \n"
"         glong                n_pixels,                                       \n"
"         const GeglRectangle *roi,                                            \n"
"         gint                 level)                                          \n"
"{                                                                             \n"
"  GeglProperties *o = GEGL_PROPERTIES (operation);                            \n"
"  gfloat *in = in_buf;                                                        \n"
"  gfloat *out = out_buf;                                                      \n"
"  gfloat black = (gfloat) o->black;                                           \n"
"  gfloat diff;                                                                \n"
"  gfloat exposure_negated = (gfloat) -o->exposure;                            \n"
"  gfloat scale;                                                               \n"
"  gfloat white;                                                               \n"
"  glong i;                                                                    \n"
"                                                                              \n"
"  white = exp2f (exposure_negated);                                           \n"
"  diff = MAX (white - black, 0.01);                                           \n"
"  scale = 1.0f / diff;                                                        \n"
"                                                                              \n"
"  for (i = 0; i < n_pixels; i++)                                              \n"
"    {                                                                         \n"
"      out[0] = (in[0] - black) * scale;                                       \n"
"      out[1] = (in[1] - black) * scale;                                       \n"
"      out[2] = (in[2] - black) * scale;                                       \n"
"      out[3] = in[3];                                                         \n"
"                                                                              \n"
"      in += 4;                                                                \n"
"      out += 4;                                                               \n"
"    }                                                                         \n"
"                                                                              \n"
"  return TRUE;                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  GeglOperationClass *operation_class = GEGL_OPERATION_CLASS (klass);         \n"
"  GeglOperationPointFilterClass *point_filter_class =                         \n"
"    GEGL_OPERATION_POINT_FILTER_CLASS (klass);                                \n"
"                                                                              \n"
"  operation_class->prepare = prepare;                                         \n"
"  operation_class->opencl_support = FALSE;                                    \n"
"                                                                              \n"
"  point_filter_class->process    = process;                                   \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"    \"name\",        \"dt:exposure\",                                         \n"
"    \"title\",       _(\"Exposure\"),                                         \n"
"    \"categories\",  \"color\",                                               \n"
"    \"description\", _(\"An implementation of Darktable's exposure filter.\"),\n"
"    NULL);                                                                    \n"
"}                                                                             \n"
"                                                                              \n"
"#endif                                                                        \n"
;
