#! /bin/sh

## @file
## @brief  This script will generate the timezone database file used to
## correct exif time and date for UTC offset and Daylight Saving Time.
##
## The Preferences/General tab of Geeqie gives the user the option to
## download the database from a defined location on geeqie.org.
##
## If the generated file differs from that on geeqie.org you should
## upload the new version. You will need write privileges to do this.
##
## Refer to https://github.com/BertoldVdb/ZoneDetect for the
## origin of files builder.cpp and zoneToAlpha.h
##

timezone_boundary_builder_default_release="2019a"

cd "$(dirname "$0")"
current_dir=$PWD

xdg-open https://github.com/evansiroky/timezone-boundary-builder/releases/

if [ -f timezone_boundary_builder_release.txt ]
then
	timezone_boundary_builder_release=$(cat timezone_boundary_builder_release.txt)
else
	timezone_boundary_builder_release=$timezone_boundary_builder_default_release
fi

timezone_boundary_builder_release=$(zenity --entry --entry-text="$timezone_boundary_builder_release" --title "Geeqie generate timezone database" --text="Which timezone boundary builder\nrelease should be used?\n" --width=350 --window-icon="$current_dir/../../geeqie.png")

if [ -n "$timezone_boundary_builder_release" ]
then
	echo "$timezone_boundary_builder_release" > "timezone_boundary_builder_release.txt"
else
	exit
fi

rm -rf naturalearth
rm -rf timezone
rm -rf geeqie_org
rm -f timezone21.bin

g++ builder.cpp -o builder -lshp

mkdir naturalearth
cd naturalearth
wget https://www.naturalearthdata.com/http//www.naturalearthdata.com/download/10m/cultural/ne_10m_admin_0_countries_lakes.zip
if [ "$?" -ne 0 ]
then
	zenity --error --text="Download of naturalearthdata failed" --title="Generate Geeqie timezone database" --width=300 --window-icon="$current_dir/../../geeqie.png"
	exit
fi

unzip ne_10m_admin_0_countries_lakes.zip
cd ..

mkdir timezone
cd timezone
wget "https://github.com/evansiroky/timezone-boundary-builder/releases/download/$timezone_boundary_builder_release/timezones.shapefile.zip"
if [ "$?" -ne 0 ]
then
	zenity --error --text="Download of timezone-boundary-builder failed" --title="Generate Geeqie timezone database" --width=300 --window-icon="$current_dir/../../geeqie.png"
	exit
fi

unzip timezones.shapefile.zip
cd ..


./builder T timezone/dist/combined-shapefile timezone21.bin 21 "Contains data from Natural Earth, placed in the Public Domain. Contains information from https://github.com/evansiroky/timezone-boundary-builder, which is made available here under the Open Database License (ODbL)."

mkdir geeqie_org
cd geeqie_org
wget http://www.geeqie.org/downloads/timezone21.bin
if [ "$?" -ne 0 ]
then
	zenity --error --text="Download of timezone database from geeqie.org failed" --title="Generate Geeqie timezone database" --width=300 --window-icon="$current_dir/../../geeqie.png"
	exit
fi
cd ..

diff ./geeqie_org/timezone21.bin timezone21.bin

if [ "$?" -ne 0 ]
then
	zenity --info --title="Generate Geeqie timezone database" --text="Generated file differs from that on geeqie.org\n\nUpload timezone21.bin to:\ngeeqie.org/downloads/" --width=300 --window-icon="$current_dir/../../geeqie.png"
else
	zenity --info --title="Generate Geeqie timezone database" --text="Generated file is the same as on geeqie.org" --width=300 --window-icon="$current_dir/../../geeqie.png"
	rm timezone21.bin
fi

rm -f builder
rm -rf naturalearth
rm -rf timezone
rm -rf geeqie_org
