/*
 * Copyright (C) 2004 John Ellis
 * Copyright (C) 2008 - 2016 The Geeqie Team
 *
 * Author: John Ellis
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef FULLSCREEN_H
#define FULLSCREEN_H

#define FULL_SCREEN_HIDE_MOUSE_DELAY 3000
#define FULL_SCREEN_BUSY_MOUSE_DELAY 200
#define HIDE_WINDOW_IN_FULLSCREEN

FullScreenData *fullscreen_start(GtkWidget *window, ImageWindow *imd,
				 void (*stop_func)(FullScreenData *, gpointer), gpointer stop_data);
void fullscreen_stop(FullScreenData *fs);


/* screen numbers for fullscreen_prefs are as follows:
 *   0  use default display size
 * 101  screen 0, monitor 0
 * 102  screen 0, monitor 1
 * 201  screen 1, monitor 0
 */


typedef struct _ScreenData ScreenData;
struct _ScreenData {
	gint number;
	gchar *description;
	gint x;
	gint y;
	gint width;
	gint height;
};


GList *fullscreen_prefs_list(void);
void fullscreen_prefs_list_free(GList *list);

ScreenData *fullscreen_prefs_list_find(GList *list, gint screen);

void fullscreen_prefs_get_geometry(gint screen, GtkWidget *widget, gint *x, gint *y, gint *width, gint *height,
				   GdkScreen **dest_screen, gboolean *same_region);

gint fullscreen_prefs_find_screen_for_widget(GtkWidget *widget);

GtkWidget *fullscreen_prefs_selection_new(const gchar *text, gint *screen_value, gboolean *above_value);


#endif
/* vim: set shiftwidth=8 softtabstop=0 cindent cinoptions={1s: */
