# Copyright (C) 2012 - Curtis Hovey <sinzui.is at verizon.net>
# This software is licensed under the MIT license (see the file COPYING).

__metaclass__ = type

from bzrlib.errors import (
    NotBranchError,
    )

from gdp.bzr import (
    BzrProject,
    )
from testing import GeditTestCase


class FakeBranch:

    def get_parent(self):
        raise NotBranchError('test')

    def get_push_location(self):
        raise NotBranchError('test')


class FakeTree:

    def __init__(self):
        self.branch = FakeBranch()


class BzrTestCase(GeditTestCase):

    def test_open_changed_files_from_parent_no_parent(self):
        text_file = self.make_file('hello')
        window, view, document = self.make_gedit(text_file.name)
        bzr_project = BzrProject(window)
        bzr_project.working_tree = FakeTree()
        bzr_project.open_changed_files_from_parent(None)
        self.assertEqual(
            'This branch does not have a parent location.',
            bzr_project._message)

    def test_open_changed_files_to_push_no_push(self):
        text_file = self.make_file('hello')
        window, view, document = self.make_gedit(text_file.name)
        bzr_project = BzrProject(window)
        bzr_project.working_tree = FakeTree()
        bzr_project.open_changed_files_to_push(None)
        self.assertEqual(
            'This branch does not have a push location.',
            bzr_project._message)
