/* -*- mode: C++; c-basic-offset: 2; indent-tabs-mode: nil -*- */
/*
 *  Main authors:
 *     Guido Tack <tack@gecode.org>
 *
 *  Copyright:
 *     Guido Tack, 2014
 *
 *  Last modified:
 *     $Date$ by $Author$
 *     $Revision$
 *
 *  This file is part of Gecode, the generic constraint
 *  development environment:
 *     http://www.gecode.org
 *
 *  Permission is hereby granted, free of charge, to any person obtaining
 *  a copy of this software and associated documentation files (the
 *  "Software"), to deal in the Software without restriction, including
 *  without limitation the rights to use, copy, modify, merge, publish,
 *  distribute, sublicense, and/or sell copies of the Software, and to
 *  permit persons to whom the Software is furnished to do so, subject to
 *  the following conditions:
 *
 *  The above copyright notice and this permission notice shall be
 *  included in all copies or substantial portions of the Software.
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 *  EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 *  MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 *  NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
 *  LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 *  OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 *  WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 */

#include "test/flatzinc.hh"

namespace Test { namespace FlatZinc {

  namespace {
    /// Helper class to create and register tests
    class Create {
    public:

      /// Perform creation and registration
      Create(void) {
        (void) new FlatZincTest("latin_squares_fd",
std::string("predicate bool_lin_ge(array [int] of int: a, array [int] of var bool: x, var int: c);\n\
predicate bool_lin_gt(array [int] of int: a, array [int] of var bool: x, var int: c);\n\
predicate bool_lin_lt(array [int] of int: a, array [int] of var bool: x, var int: c);\n\
predicate bool_lin_ne(array [int] of int: a, array [int] of var bool: x, var int: c);\n\
array [1..729] of var 0..1: x :: output_array([1..9, 1..9, 1..9]);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[1], x[2], x[3], x[4], x[5], x[6], x[7], x[8], x[9]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[1], x[10], x[19], x[28], x[37], x[46], x[55], x[64], x[73]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[1], x[82], x[163], x[244], x[325], x[406], x[487], x[568], x[649]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[2], x[11], x[20], x[29], x[38], x[47], x[56], x[65], x[74]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[2], x[83], x[164], x[245], x[326], x[407], x[488], x[569], x[650]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[3], x[12], x[21], x[30], x[39], x[48], x[57], x[66], x[75]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[3], x[84], x[165], x[246], x[327], x[408], x[489], x[570], x[651]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[4], x[13], x[22], x[31], x[40], x[49], x[58], x[67], x[76]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[4], x[85], x[166], x[247], x[328], x[409], x[490], x[571], x[652]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[5], x[14], x[23], x[32], x[41], x[50], x[59], x[68], x[77]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[5], x[86], x[167], x[248], x[329], x[410], x[491], x[572], x[653]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[6], x[15], x[24], x[33], x[42], x[51], x[60], x[69], x[78]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[6], x[87], x[168], x[249], x[330], x[411], x[492], x[573], x[654]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[7], x[16], x[25], x[34], x[43], x[52], x[61], x[70], x[79]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[7], x[88], x[169], x[250], x[331], x[412], x[493], x[574], x[655]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[8], x[17], x[26], x[35], x[44], x[53], x[62], x[71], x[80]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[8], x[89], x[170], x[251], x[332], x[413], x[494], x[575], x[656]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[9], x[18], x[27], x[36], x[45], x[54], x[63], x[72], x[81]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[9], x[90], x[171], x[252], x[333], x[414], x[495], x[576], x[657]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[10], x[11], x[12], x[13], x[14], x[15], x[16], x[17], x[18]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[10], x[91], x[172], x[253], x[334], x[415], x[496], x[577], x[658]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[11], x[92], x[173], x[254], x[335], x[416], x[497], x[578], x[659]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[12], x[93], x[174], x[255], x[336], x[417], x[498], x[579], x[660]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[13], x[94], x[175], x[256], x[337], x[418], x[499], x[580], x[661]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[14], x[95], x[176], x[257], x[338], x[419], x[500], x[581], x[662]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[15], x[96], x[177], x[258], x[339], x[420], x[501], x[582], x[663]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[16], x[97], x[178], x[259], x[340], x[421], x[502], x[583], x[664]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[17], x[98], x[179], x[260], x[341], x[422], x[503], x[584], x[665]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[18], x[99], x[180], x[261], x[342], x[423], x[504], x[585], x[666]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[19], x[20], x[21], x[22], x[23], x[24], x[25], x[26], x[27]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[19], x[100], x[181], x[262], x[343], x[424], x[505], x[586], x[667]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[20], x[101], x[182], x[263], x[344], x[425], x[506], x[587], x[668]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[21], x[102], x[183], x[264], x[345], x[426], x[507], x[588], x[669]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[22], x[103], x[184], x[265], x[346], x[427], x[508], x[589], x[670]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[23], x[104], x[185], x[266], x[347], x[428], x[509], x[590], x[671]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[24], x[105], x[186], x[267], x[348], x[429], x[510], x[591], x[672]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[25], x[106], x[187], x[268], x[349], x[430], x[511], x[592], x[673]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[26], x[107], x[188], x[269], x[350], x[431], x[512], x[593], x[674]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[27], x[108], x[189], x[270], x[351], x[432], x[513], x[594], x[675]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[28], x[29], x[30], x[31], x[32], x[33], x[34], x[35], x[36]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[28], x[109], x[190], x[271], x[352], x[433], x[514], x[595], x[676]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[29], x[110], x[191], x[272], x[353], x[434], x[515], x[596], x[677]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[30], x[111], x[192], x[273], x[354], x[435], x[516], x[597], x[678]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[31], x[112], x[193], x[274], x[355], x[436], x[517], x[598], x[679]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[32], x[113], x[194], x[275], x[356], x[437], x[518], x[599], x[680]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[33], x[114], x[195], x[276], x[357], x[438], x[519], x[600], x[681]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[34], x[115], x[196], x[277], x[358], x[439], x[520], x[601], x[682]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[35], x[116], x[197], x[278], x[359], x[440], x[521], x[602], x[683]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[36], x[117], x[198], x[279], x[360], x[441], x[522], x[603], x[684]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[37], x[38], x[39], x[40], x[41], x[42], x[43], x[44], x[45]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[37], x[118], x[199], x[280], x[361], x[442], x[523], x[604], x[685]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[38], x[119], x[200], x[281], x[362], x[443], x[524], x[605], x[686]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[39], x[120], x[201], x[282], x[363], x[444], x[525], x[606], x[687]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[40], x[121], x[202], x[283], x[364], x[445], x[526], x[607], x[688]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[41], x[122], x[203], x[284], x[365], x[446], x[527], x[608], x[689]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[42], x[123], x[204], x[285], x[366], x[447], x[528], x[609], x[690]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[43], x[124], x[205], x[286], x[367], x[448], x[529], x[610], x[691]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[44], x[125], x[206], x[287], x[368], x[449], x[530], x[611], x[692]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[45], x[126], x[207], x[288], x[369], x[450], x[531], x[612], x[693]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[46], x[47], x[48], x[49], x[50], x[51], x[52], x[53], x[54]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[46], x[127], x[208], x[289], x[370], x[451], x[532], x[613], x[694]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[47], x[128], x[209], x[290], x[371], x[452], x[533], x[614], x[695]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[48], x[129], x[210], x[291], x[372], x[453], x[534], x[615], x[696]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[49], x[130], x[211], x[292], x[373], x[454], x[535], x[616], x[697]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[50], x[131], x[212], x[293], x[374], x[455], x[536], x[617], x[698]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[51], x[132], x[213], x[294], x[375], x[456], x[537], x[618], x[699]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[52], x[133], x[214], x[295], x[376], x[457], x[538], x[619], x[700]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[53], x[134], x[215], x[296], x[377], x[458], x[539], x[620], x[701]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[54], x[135], x[216], x[297], x[378], x[459], x[540], x[621], x[702]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[55], x[56], x[57], x[58], x[59], x[60], x[61], x[62], x[63]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[55], x[136], x[217], x[298], x[379], x[460], x[541], x[622], x[703]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[56], x[137], x[218], x[299], x[380], x[461], x[542], x[623], x[704]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[57], x[138], x[219], x[300], x[381], x[462], x[543], x[624], x[705]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[58], x[139], x[220], x[301], x[382], x[463], x[544], x[625], x[706]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[59], x[140], x[221], x[302], x[383], x[464], x[545], x[626], x[707]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[60], x[141], x[222], x[303], x[384], x[465], x[546], x[627], x[708]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[61], x[142], x[223], x[304], x[385], x[466], x[547], x[628], x[709]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[62], x[143], x[224], x[305], x[386], x[467], x[548], x[629], x[710]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[63], x[144], x[225], x[306], x[387], x[468], x[549], x[630], x[711]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[64], x[65], x[66], x[67], x[68], x[69], x[70], x[71], x[72]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[64], x[145], x[226], x[307], x[388], x[469], x[550], x[631], x[712]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[65], x[146], x[227], x[308], x[389], x[470], x[551], x[632], x[713]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[66], x[147], x[228], x[309], x[390], x[471], x[552], x[633], x[714]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[67], x[148], x[229], x[310], x[391], x[472], x[553], x[634], x[715]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[68], x[149], x[230], x[311], x[392], x[473], x[554], x[635], x[716]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[69], x[150], x[231], x[312], x[393], x[474], x[555], x[636], x[717]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[70], x[151], x[232], x[313], x[394], x[475], x[556], x[637], x[718]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[71], x[152], x[233], x[314], x[395], x[476], x[557], x[638], x[719]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[72], x[153], x[234], x[315], x[396], x[477], x[558], x[639], x[720]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[73], x[74], x[75], x[76], x[77], x[78], x[79], x[80], x[81]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[73], x[154], x[235], x[316], x[397], x[478], x[559], x[640], x[721]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[74], x[155], x[236], x[317], x[398], x[479], x[560], x[641], x[722]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[75], x[156], x[237], x[318], x[399], x[480], x[561], x[642], x[723]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[76], x[157], x[238], x[319], x[400], x[481], x[562], x[643], x[724]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[77], x[158], x[239], x[320], x[401], x[482], x[563], x[644], x[725]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[78], x[159], x[240], x[321], x[402], x[483], x[564], x[645], x[726]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[79], x[160], x[241], x[322], x[403], x[484], x[565], x[646], x[727]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[80], x[161], x[242], x[323], x[404], x[485], x[566], x[647], x[728]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[81], x[162], x[243], x[324], x[405], x[486], x[567], x[648], x[729]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[82], x[83], x[84], x[85], x[86], x[87], x[88], x[89], x[90]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[82], x[91], x[100], x[109], x[118], x[127], x[136], x[145], x[154]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[83], x[92], x[101], x[110], x[119], x[128], x[137], x[146], x[155]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[84], x[93], x[102], x[111], x[120], x[129], x[138], x[147], x[156]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[85], x[94], x[103], x[112], x[121], x[130], x[139], x[148], x[157]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[86], x[95], x[104], x[113], x[122], x[131], x[140], x[149], x[158]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[87], x[96], x[105], x[114], x[123], x[132], x[141], x[150], x[159]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[88], x[97], x[106], x[115], x[124], x[133], x[142], x[151], x[160]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[89], x[98], x[107], x[116], x[125], x[134], x[143], x[152], x[161]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[90], x[99], x[108], x[117], x[126], x[135], x[144], x[153], x[162]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[91], x[92], x[93], x[94], x[95], x[96], x[97], x[98], x[99]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[100], x[101], x[102], x[103], x[104], x[105], x[106], x[107], x[108]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[109], x[110], x[111], x[112], x[113], x[114], x[115], x[116], x[117]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[118], x[119], x[120], x[121], x[122], x[123], x[124], x[125], x[126]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[127], x[128], x[129], x[130], x[131], x[132], x[133], x[134], x[135]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[136], x[137], x[138], x[139], x[140], x[141], x[142], x[143], x[144]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[145], x[146], x[147], x[148], x[149], x[150], x[151], x[152], x[153]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[154], x[155], x[156], x[157], x[158], x[159], x[160], x[161], x[162]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[163], x[164], x[165], x[166], x[167], x[168], x[169], x[170], x[171]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[163], x[172], x[181], x[190], x[199], x[208], x[217], x[226], x[235]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[164], x[173], x[182], x[191], x[200], x[209], x[218], x[227], x[236]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[165], x[174], x[183], x[192], x[201], x[210], x[219], x[228], x[237]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[166], x[175], x[184], x[193], x[202], x[211], x[220], x[229], x[238]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[167], x[176], x[185], x[194], x[203], x[212], x[221], x[230], x[239]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[168], x[177], x[186], x[195], x[204], x[213], x[222], x[231], x[240]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[169], x[178], x[187], x[196], x[205], x[214], x[223], x[232], x[241]], 1);\n")+
"constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[170], x[179], x[188], x[197], x[206], x[215], x[224], x[233], x[242]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[171], x[180], x[189], x[198], x[207], x[216], x[225], x[234], x[243]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[172], x[173], x[174], x[175], x[176], x[177], x[178], x[179], x[180]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[181], x[182], x[183], x[184], x[185], x[186], x[187], x[188], x[189]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[190], x[191], x[192], x[193], x[194], x[195], x[196], x[197], x[198]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[199], x[200], x[201], x[202], x[203], x[204], x[205], x[206], x[207]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[208], x[209], x[210], x[211], x[212], x[213], x[214], x[215], x[216]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[217], x[218], x[219], x[220], x[221], x[222], x[223], x[224], x[225]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[226], x[227], x[228], x[229], x[230], x[231], x[232], x[233], x[234]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[235], x[236], x[237], x[238], x[239], x[240], x[241], x[242], x[243]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[244], x[245], x[246], x[247], x[248], x[249], x[250], x[251], x[252]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[244], x[253], x[262], x[271], x[280], x[289], x[298], x[307], x[316]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[245], x[254], x[263], x[272], x[281], x[290], x[299], x[308], x[317]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[246], x[255], x[264], x[273], x[282], x[291], x[300], x[309], x[318]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[247], x[256], x[265], x[274], x[283], x[292], x[301], x[310], x[319]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[248], x[257], x[266], x[275], x[284], x[293], x[302], x[311], x[320]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[249], x[258], x[267], x[276], x[285], x[294], x[303], x[312], x[321]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[250], x[259], x[268], x[277], x[286], x[295], x[304], x[313], x[322]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[251], x[260], x[269], x[278], x[287], x[296], x[305], x[314], x[323]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[252], x[261], x[270], x[279], x[288], x[297], x[306], x[315], x[324]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[253], x[254], x[255], x[256], x[257], x[258], x[259], x[260], x[261]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[262], x[263], x[264], x[265], x[266], x[267], x[268], x[269], x[270]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[271], x[272], x[273], x[274], x[275], x[276], x[277], x[278], x[279]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[280], x[281], x[282], x[283], x[284], x[285], x[286], x[287], x[288]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[289], x[290], x[291], x[292], x[293], x[294], x[295], x[296], x[297]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[298], x[299], x[300], x[301], x[302], x[303], x[304], x[305], x[306]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[307], x[308], x[309], x[310], x[311], x[312], x[313], x[314], x[315]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[316], x[317], x[318], x[319], x[320], x[321], x[322], x[323], x[324]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[325], x[326], x[327], x[328], x[329], x[330], x[331], x[332], x[333]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[325], x[334], x[343], x[352], x[361], x[370], x[379], x[388], x[397]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[326], x[335], x[344], x[353], x[362], x[371], x[380], x[389], x[398]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[327], x[336], x[345], x[354], x[363], x[372], x[381], x[390], x[399]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[328], x[337], x[346], x[355], x[364], x[373], x[382], x[391], x[400]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[329], x[338], x[347], x[356], x[365], x[374], x[383], x[392], x[401]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[330], x[339], x[348], x[357], x[366], x[375], x[384], x[393], x[402]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[331], x[340], x[349], x[358], x[367], x[376], x[385], x[394], x[403]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[332], x[341], x[350], x[359], x[368], x[377], x[386], x[395], x[404]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[333], x[342], x[351], x[360], x[369], x[378], x[387], x[396], x[405]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[334], x[335], x[336], x[337], x[338], x[339], x[340], x[341], x[342]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[343], x[344], x[345], x[346], x[347], x[348], x[349], x[350], x[351]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[352], x[353], x[354], x[355], x[356], x[357], x[358], x[359], x[360]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[361], x[362], x[363], x[364], x[365], x[366], x[367], x[368], x[369]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[370], x[371], x[372], x[373], x[374], x[375], x[376], x[377], x[378]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[379], x[380], x[381], x[382], x[383], x[384], x[385], x[386], x[387]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[388], x[389], x[390], x[391], x[392], x[393], x[394], x[395], x[396]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[397], x[398], x[399], x[400], x[401], x[402], x[403], x[404], x[405]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[406], x[407], x[408], x[409], x[410], x[411], x[412], x[413], x[414]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[406], x[415], x[424], x[433], x[442], x[451], x[460], x[469], x[478]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[407], x[416], x[425], x[434], x[443], x[452], x[461], x[470], x[479]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[408], x[417], x[426], x[435], x[444], x[453], x[462], x[471], x[480]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[409], x[418], x[427], x[436], x[445], x[454], x[463], x[472], x[481]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[410], x[419], x[428], x[437], x[446], x[455], x[464], x[473], x[482]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[411], x[420], x[429], x[438], x[447], x[456], x[465], x[474], x[483]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[412], x[421], x[430], x[439], x[448], x[457], x[466], x[475], x[484]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[413], x[422], x[431], x[440], x[449], x[458], x[467], x[476], x[485]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[414], x[423], x[432], x[441], x[450], x[459], x[468], x[477], x[486]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[415], x[416], x[417], x[418], x[419], x[420], x[421], x[422], x[423]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[424], x[425], x[426], x[427], x[428], x[429], x[430], x[431], x[432]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[433], x[434], x[435], x[436], x[437], x[438], x[439], x[440], x[441]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[442], x[443], x[444], x[445], x[446], x[447], x[448], x[449], x[450]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[451], x[452], x[453], x[454], x[455], x[456], x[457], x[458], x[459]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[460], x[461], x[462], x[463], x[464], x[465], x[466], x[467], x[468]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[469], x[470], x[471], x[472], x[473], x[474], x[475], x[476], x[477]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[478], x[479], x[480], x[481], x[482], x[483], x[484], x[485], x[486]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[487], x[488], x[489], x[490], x[491], x[492], x[493], x[494], x[495]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[487], x[496], x[505], x[514], x[523], x[532], x[541], x[550], x[559]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[488], x[497], x[506], x[515], x[524], x[533], x[542], x[551], x[560]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[489], x[498], x[507], x[516], x[525], x[534], x[543], x[552], x[561]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[490], x[499], x[508], x[517], x[526], x[535], x[544], x[553], x[562]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[491], x[500], x[509], x[518], x[527], x[536], x[545], x[554], x[563]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[492], x[501], x[510], x[519], x[528], x[537], x[546], x[555], x[564]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[493], x[502], x[511], x[520], x[529], x[538], x[547], x[556], x[565]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[494], x[503], x[512], x[521], x[530], x[539], x[548], x[557], x[566]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[495], x[504], x[513], x[522], x[531], x[540], x[549], x[558], x[567]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[496], x[497], x[498], x[499], x[500], x[501], x[502], x[503], x[504]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[505], x[506], x[507], x[508], x[509], x[510], x[511], x[512], x[513]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[514], x[515], x[516], x[517], x[518], x[519], x[520], x[521], x[522]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[523], x[524], x[525], x[526], x[527], x[528], x[529], x[530], x[531]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[532], x[533], x[534], x[535], x[536], x[537], x[538], x[539], x[540]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[541], x[542], x[543], x[544], x[545], x[546], x[547], x[548], x[549]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[550], x[551], x[552], x[553], x[554], x[555], x[556], x[557], x[558]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[559], x[560], x[561], x[562], x[563], x[564], x[565], x[566], x[567]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[568], x[569], x[570], x[571], x[572], x[573], x[574], x[575], x[576]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[568], x[577], x[586], x[595], x[604], x[613], x[622], x[631], x[640]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[569], x[578], x[587], x[596], x[605], x[614], x[623], x[632], x[641]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[570], x[579], x[588], x[597], x[606], x[615], x[624], x[633], x[642]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[571], x[580], x[589], x[598], x[607], x[616], x[625], x[634], x[643]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[572], x[581], x[590], x[599], x[608], x[617], x[626], x[635], x[644]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[573], x[582], x[591], x[600], x[609], x[618], x[627], x[636], x[645]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[574], x[583], x[592], x[601], x[610], x[619], x[628], x[637], x[646]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[575], x[584], x[593], x[602], x[611], x[620], x[629], x[638], x[647]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[576], x[585], x[594], x[603], x[612], x[621], x[630], x[639], x[648]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[577], x[578], x[579], x[580], x[581], x[582], x[583], x[584], x[585]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[586], x[587], x[588], x[589], x[590], x[591], x[592], x[593], x[594]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[595], x[596], x[597], x[598], x[599], x[600], x[601], x[602], x[603]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[604], x[605], x[606], x[607], x[608], x[609], x[610], x[611], x[612]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[613], x[614], x[615], x[616], x[617], x[618], x[619], x[620], x[621]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[622], x[623], x[624], x[625], x[626], x[627], x[628], x[629], x[630]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[631], x[632], x[633], x[634], x[635], x[636], x[637], x[638], x[639]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[640], x[641], x[642], x[643], x[644], x[645], x[646], x[647], x[648]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[649], x[650], x[651], x[652], x[653], x[654], x[655], x[656], x[657]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[649], x[658], x[667], x[676], x[685], x[694], x[703], x[712], x[721]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[650], x[659], x[668], x[677], x[686], x[695], x[704], x[713], x[722]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[651], x[660], x[669], x[678], x[687], x[696], x[705], x[714], x[723]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[652], x[661], x[670], x[679], x[688], x[697], x[706], x[715], x[724]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[653], x[662], x[671], x[680], x[689], x[698], x[707], x[716], x[725]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[654], x[663], x[672], x[681], x[690], x[699], x[708], x[717], x[726]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[655], x[664], x[673], x[682], x[691], x[700], x[709], x[718], x[727]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[656], x[665], x[674], x[683], x[692], x[701], x[710], x[719], x[728]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[657], x[666], x[675], x[684], x[693], x[702], x[711], x[720], x[729]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[658], x[659], x[660], x[661], x[662], x[663], x[664], x[665], x[666]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[667], x[668], x[669], x[670], x[671], x[672], x[673], x[674], x[675]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[676], x[677], x[678], x[679], x[680], x[681], x[682], x[683], x[684]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[685], x[686], x[687], x[688], x[689], x[690], x[691], x[692], x[693]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[694], x[695], x[696], x[697], x[698], x[699], x[700], x[701], x[702]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[703], x[704], x[705], x[706], x[707], x[708], x[709], x[710], x[711]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[712], x[713], x[714], x[715], x[716], x[717], x[718], x[719], x[720]], 1);\n\
constraint int_lin_eq([1, 1, 1, 1, 1, 1, 1, 1, 1], [x[721], x[722], x[723], x[724], x[725], x[726], x[727], x[728], x[729]], 1);\n\
solve satisfy;\n\
", "x = array3d(1..9, 1..9, 1..9, [0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0]);\n\
----------\n\
");
      }
    };

    Create c;
  }

}}

// STATISTICS: test-flatzinc
