#
#  Main authors:
#     Christian Schulte <schulte@gecode.org>
#
#  Copyright:
#     Christian Schulte, 2008
#
#  Last modified:
#     $Date: 2008-01-23 09:51:06 +0100 (Wed, 23 Jan 2008) $ by $Author: tack $
#     $Revision: 5949 $
#
#  This file is part of Gecode, the generic constraint
#  development environment:
#     http://www.gecode.org
#
#  Permission is hereby granted, free of charge, to any person obtaining
#  a copy of this software and associated documentation files (the
#  "Software"), to deal in the Software without restriction, including
#  without limitation the rights to use, copy, modify, merge, publish,
#  distribute, sublicense, and/or sell copies of the Software, and to
#  permit persons to whom the Software is furnished to do so, subject to
#  the following conditions:
#
#  The above copyright notice and this permission notice shall be
#  included in all copies or substantial portions of the Software.
#
#  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
#  EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
#  MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
#  NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
#  LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
#  OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
#  WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
#

[Header]

[Footer]

// STATISTICS: set-branch

[General]
# Type of view
View:		SetView
# Type of variable argument
VarArgs:	SetVarArgs
# Type of variable branching selection
VarBranch:	SetVarBranch
# Type of value branch selection
ValBranch:	SetValBranch
# Exception to be thrown if variable branch selection unknown
Exception:	UnknownBranching("Set::branch")
# Header file to include
Include:	<gecode/set/branch.hh>
# Local namespace
LNS:		Gecode::Set::Branch
# Global namespace
GNS:		Gecode
[VarBranch]
# Value for branching selection, mark as special
Value:		SET_VAR_NONE = NONE
# Corresponding type
Type:		ViewSelNone<SetView>
[VarBranch]
Value:		SET_VAR_RND = COMPLETE
Type:		ViewSelRnd<SetView>
[VarBranch]
Value:		SET_VAR_DEGREE_MIN
Type:		ViewSelDegreeMin<SetView>
[VarBranch]
Value:		SET_VAR_DEGREE_MAX
Type:		ViewSelDegreeMin<SetView>
[VarBranch]
Value:		SET_VAR_MIN_MIN
Type:		ByMinMin
[VarBranch]
Value:		SET_VAR_MIN_MAX
Type:		ByMinMin
[VarBranch]
Value:		SET_VAR_MAX_MIN
Type:		ByMaxMin
[VarBranch]
Value:		SET_VAR_MAX_MAX
Type:		ByMaxMax
[VarBranch]
Value:		SET_VAR_SIZE_MIN
Type:		BySizeMin
[VarBranch]
Value:		SET_VAR_SIZE_MAX
Type:		BySizeMax
[VarBranch]
Value:		SET_VAR_SIZE_DEGREE_MIN
Type:		BySizeDegreeMin
[VarBranch]
Value:		SET_VAR_SIZE_DEGREE_MAX
Type:		BySizeDegreeMax
[End]
