/*
 *  Main authors:
 *     Guido Tack <tack@gecode.org>
 *     Christian Schulte <schulte@gecode.org>
 *
 *  Contributing authors:
 *     Gabor Szokoli <szokoli@gecode.org>
 *
 *  Copyright:
 *     Guido Tack, 2004
 *     Christian Schulte, 2004
 *     Gabor Szokoli, 2004
 *
 *  Last modified:
 *     $Date: 2005-11-24 18:03:01 +0100 (Thu, 24 Nov 2005) $ by $Author: tack $
 *     $Revision: 2639 $
 *
 *  This file is part of Gecode, the generic constraint
 *  development environment:
 *     http://www.gecode.org
 *
 *  See the file "LICENSE" for information on usage and
 *  redistribution of this file, and for a
 *     DISCLAIMER OF ALL WARRANTIES.
 *
 */



#include "set/int.hh"

#include "iter.hh"

#include "set/rel.hh"

namespace Gecode { namespace Set { namespace Int {

  Actor*
  Card::copy(Space* home, bool share) {
    return new (home) Card(home,share,*this);
  }

  ExecStatus
  Card::propagate(Space* home) {
    int x1min, x1max;
    do {
      x1min = x1.min();
      x1max = x1.max();
      GECODE_ME_CHECK(x0.cardMin(home,x1min));
      GECODE_ME_CHECK(x0.cardMax(home,x1max));
      GECODE_ME_CHECK(x1.gq(home,(int)x0.cardMin()));
      GECODE_ME_CHECK(x1.lq(home,(int)x0.cardMax()));
    } while (x1.min() > x1min || x1.max() < x1max);
    if (x1.assigned())
      return ES_SUBSUMED;
    return ES_FIX;
  }

}}}

// STATISTICS: set-prop
