(* This file is part of an ocaml binding of an XSLT engine working on Gdome
 * documents.
 * 
 * The code is largely based on the code of T.J. Mather's XML::GDOME::XSLT
 * Perl module (http://kobesearch.cpan.org/search?dist=XML-GDOME-XSLT)
 *
 * Copyright (C) 2002:
 * 	Claudio Sacerdoti Coen 	<sacerdot@cs.unibo.it>
 * 	Stefano Zacchiroli	<zack@cs.unibo.it>
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * For more information, please send an email to {sacerdot,zack}@cs.unibo.it
 *)

(** Main interface to GDome XSLT functionalities *)

(** processStylesheet stylesheet
 *
 * Process a stylesheet so that it can be subsequently used with
 * applyStylesheet. *)
val processStylesheet:
 Gdome.document ->
   I_gdome_xslt.processed_stylesheet

(** applyStylesheet source stylesheet params
 * Applies a processed stylesheet to a source document, using the given list of
 * parameters (couples name,value) *)
val applyStylesheet:
 source: Gdome.document ->
 stylesheet:I_gdome_xslt.processed_stylesheet ->
 params:(string * string) list ->
   Gdome.document

(** output the result of a previous XSLT transformation to an output channel *)
val saveResultToChannel:
  outchan: out_channel ->
  result: Gdome.document ->
  stylesheet: I_gdome_xslt.processed_stylesheet ->
    unit

(** set error callback, that is a function invoked each time an error message is
 * generated. If None is passed, libxslt default error callback is used *)
val setErrorCallback: (string -> unit) option -> unit

(** set debug callback, that is a function invoked each time a debugging message
 * is generated. If None is passed, libxslt default error callback is used *)
val setDebugCallback: (string -> unit) option -> unit

