/* GDHCPD, a GTK+ frontend for ISC DHCPD
 * Copyright C 2004, 2005 Magnus Loef <magnus-swe@telia.com> 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307, USA.
 *
*/


#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include "gettext.h"
#include "widgets.h"
#include "make_settings_entries.h"
 

void create_scope_set_entries(struct gdhcpd_widgets *widgets)
{
    GtkWidget *frame;
    GtkWidget *table;
    GtkTooltips *tooltips;

    tooltips = gtk_tooltips_new();
    frame = gtk_frame_new(_("Scope settings"));

    /* A table with 16 settings and 2 columns */
    table = gtk_table_new(16, 2, FALSE);

    gtk_box_pack_start(GTK_BOX(widgets->scope_set_scrolled_vbox), frame, TRUE, TRUE, 1);
    gtk_container_add(GTK_CONTAINER(frame), table);
							     /* Max length and input 350 chars */
    widgets->scope_set_entry[0] = make_entry_with_label(GTK_TABLE(table), _(" Network card: "),       0,1,0,1,350);
    gtk_tooltips_set_tip(tooltips, widgets->scope_set_entry[0], "eth0", NULL);

    widgets->scope_set_entry[1] = make_entry_with_label(GTK_TABLE(table), _(" Subnet address: "),     0,1,1,2,350);
    gtk_tooltips_set_tip(tooltips, widgets->scope_set_entry[1], "192.168.0.0", NULL);

    widgets->scope_set_entry[2] = make_entry_with_label(GTK_TABLE(table), _(" Netmask address: "),    0,1,2,3,350);
    gtk_tooltips_set_tip(tooltips, widgets->scope_set_entry[2], "255.255.255.0", NULL);

    widgets->scope_set_entry[3] = make_entry_with_label(GTK_TABLE(table), _(" Default lease time: "), 0,1,3,4,350);
    gtk_tooltips_set_tip(tooltips, widgets->scope_set_entry[3], _("600 (seconds)"), NULL);

    widgets->scope_set_entry[4] = make_entry_with_label(GTK_TABLE(table), _(" Max lease time: "),     0,1,4,5,350);
    gtk_tooltips_set_tip(tooltips, widgets->scope_set_entry[4], _("7200 (seconds)"), NULL);

    widgets->scope_set_entry[5] = make_entry_with_label(GTK_TABLE(table),_(" Domain name: "),         0,1,5,6,350);
    gtk_tooltips_set_tip(tooltips, widgets->scope_set_entry[5], _("some.domain.org"), NULL);

    widgets->scope_set_entry[6] = make_entry_with_label(GTK_TABLE(table),_(" Subnet mask: "),         0,1,6,7,350);
    gtk_tooltips_set_tip(tooltips, widgets->scope_set_entry[6], "255.255.255.0", NULL);

    widgets->scope_set_entry[7] = make_entry_with_label(GTK_TABLE(table),_(" Broadcast address: "),   0,1,7,8,350);
    gtk_tooltips_set_tip(tooltips, widgets->scope_set_entry[7], "192.168.0.255", NULL);

    widgets->scope_set_entry[8] = make_entry_with_label(GTK_TABLE(table),_(" Routers: "),             0,1,8,9,350);
    gtk_tooltips_set_tip(tooltips, widgets->scope_set_entry[8], "192.168.0.101 , 192.168.0.102 , 192.168.0.103", NULL);

    widgets->scope_set_entry[9] = make_entry_with_label(GTK_TABLE(table),_(" Domain name servers: "), 0,1,9,10,350);
    gtk_tooltips_set_tip(tooltips, widgets->scope_set_entry[9], _("10.0.0.1 , 10.0.0.2 , 10.0.0.3"), NULL);

    widgets->scope_set_entry[10] = make_entry_with_label(GTK_TABLE(table),_(" Nis Domain: "),         0,1,10,11,350);
    gtk_tooltips_set_tip(tooltips, widgets->scope_set_entry[10], _("my.nis.domain"), NULL);

    widgets->scope_set_entry[11] = make_entry_with_label(GTK_TABLE(table),_(" Time offset: "),        0,1,11,12,350);
    gtk_tooltips_set_tip(tooltips, widgets->scope_set_entry[11], _("Specifies the offset of the client's subnet in seconds from Coordinated Universal Time (UTC).\n-18000 is eastern standard time\n-3600 is central european standard time."), NULL);

    widgets->scope_set_entry[12] = make_entry_with_label(GTK_TABLE(table),_(" NTP servers: "),        0,1,12,13,350);
    gtk_tooltips_set_tip(tooltips, widgets->scope_set_entry[12], "192.168.0.43, 192.168.0.44 , 192.168.0.45", NULL);

    widgets->scope_set_entry[13] = make_entry_with_label(GTK_TABLE(table),_(" Netbios name servers: "), 0,1,13,14,350);
    gtk_tooltips_set_tip(tooltips, widgets->scope_set_entry[13], "192.168.0.46, 192.168.0.47 , 192.168.0.48", NULL);

    widgets->scope_set_entry[14] = make_entry_with_label(GTK_TABLE(table),_(" T150 (Netboot GRUB menu): "), 0,1,14,15,350);
    gtk_tooltips_set_tip(tooltips, widgets->scope_set_entry[14], _("(nd)/tftpboot/your_OS/menu.lst"), NULL);

    widgets->scope_set_entry[15] = make_entry_with_label(GTK_TABLE(table),_(" Filename (netboot file): "),  0,1,15,16,350);
    gtk_tooltips_set_tip(tooltips, widgets->scope_set_entry[15], _("/tftpboot/your_OS/netboot_file"), NULL);
}
