/* GDHCPD, a GTK+ frontend for ISC DHCPD
 * Copyright C 2004, 2005 Magnus Loef <magnus-swe@telia.com> 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307, USA.
 *
*/


#include <gtk/gtk.h>
#include <stdio.h>
#include <string.h>
#include "widgets.h"
#include "gettext.h"

extern char DHCPD_CONF_BUF[1024];

#include "show_info.h"
#include "list_scopes.h"
#include "reread_conf.h"


void add_scope(struct gdhcpd_widgets *widgets)
{
    FILE *fp;
    G_CONST_RETURN gchar *nic, *subnet, *netmask;
    gchar *scope, *info;

    nic = gtk_entry_get_text(GTK_ENTRY(widgets->scope_add_nic_entry));
    subnet = gtk_entry_get_text(GTK_ENTRY(widgets->scope_add_subnet_entry));
    netmask = gtk_entry_get_text(GTK_ENTRY(widgets->scope_add_netmask_entry));

    scope = g_strdup_printf("\nsubnet %s netmask %s {\n    interface %s;\n}\n", subnet, netmask, nic);

    if( strlen(nic) == 0 )
    {
	info = g_strdup_printf(_("The network card is too short, scope not added\n"));
	show_info(info);
	g_free(info);
	return;
    }
    if( strlen(subnet) < 7 )
    {
	info = g_strdup_printf(_("The subnet is too short, scope not added\n"));
	show_info(info);
	g_free(info);
	return;
    }
    if( strlen(netmask) < 7 )
    {
	info = g_strdup_printf(_("The netmask is too short, scope not added\n"));
	show_info(info);
	g_free(info);
	return;
    }

    if((fp=fopen(DHCPD_CONF_BUF, "a"))==NULL)
    {
        printf("Couldnt find: %s\n", DHCPD_CONF_BUF);
        return;
    }

    fputs(scope, fp);    
    fclose(fp);    

    /* FIXME set this as the selected scope (now we have the first scope as selected) */
    list_scopes(widgets);

    reread_conf();
}
