/*
** Copyright (C) 10 Feb 1999 Jonas Munsin <jmunsin@iki.fi>
**  
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
** 
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
** 
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software 
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#include <locale.h>

#include <gtk/gtk.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "cdlabel.h"
#include "common_gtk.h"
#include "config_files.h"
#include "mainwindow.h"
#include "globals.h"

void exit_program(void) {
	if (0 != cdlabel_tmp_out[0])
		if (0 != remove(cdlabel_tmp_out))
			g_warning("gcombust.c::exit_program: could not remove cdlabelgen ps temp-file %s",
					cdlabel_tmp_out);
	if (0 != cdlabel_tmp_items[0])
		if (0 != remove(cdlabel_tmp_items))
			g_warning("gcombust.c::exit_program: could not remove cdlabelgen items temp-file %s",
					cdlabel_tmp_items);
	g_free(mainptr);
	gtk_main_quit();
}

int main (int argc, char *argv[]) {
	gtk_set_locale(); /* gtk_set_locale calls setlocale last time I checked the
				 * gtk source */
	bindtextdomain(PACKAGE, LOCALEDIR);
	textdomain(PACKAGE);
	gtk_init(&argc, &argv);

	setup_everything();

	read_config_file();

	gtk_main();

	return 0;
}

