Description: <short summary of the patch>
 TODO: Put a short summary on the line above and replace this paragraph
 with a longer explanation of this change. Complete the meta-information
 with other relevant fields (see below for details). To make it easier, the
 information below has been extracted from the changelog. Adjust it or drop
 it.
 .
 gcl (2.6.10-35) unstable; urgency=medium
 .
   * find_sym_ptable typo fix
Author: Camm Maguire <camm@debian.org>

---
The information above should follow the Patch Tagging Guidelines, please
checkout http://dep.debian.net/deps/dep3/ to learn about the format. Here
are templates for supplementary fields that you might want to add:

Origin: <vendor|upstream|other>, <url of original patch>
Bug: <url in upstream bugtracker>
Bug-Debian: http://bugs.debian.org/<bugnumber>
Bug-Ubuntu: https://launchpad.net/bugs/<bugnumber>
Forwarded: <no|not-needed|url proving that it has been forwarded>
Reviewed-By: <name and email of someone who approved the patch>
Last-Update: <YYYY-MM-DD>

--- gcl-2.6.10.orig/cmpnew/gcl_cmpopt.lsp
+++ gcl-2.6.10/cmpnew/gcl_cmpopt.lsp
@@ -67,18 +67,18 @@
    (get 'long-float-p 'inline-always))
 
 ;;SFEOF
- (push '((object) boolean #.(flags set)"(feof((#0)->sm.sm_fp))")
+ (push '((object) boolean #.(flags set)"(gcl_feof((#0)->sm.sm_fp))")
    (get 'sfeof 'inline-unsafe))
 
 
 ;;SGETC1
- (push '((object) fixnum #.(flags set rfa) "getc((#0)->sm.sm_fp)")
+ (push '((object) fixnum #.(flags set rfa) "gcl_getc((#0)->sm.sm_fp)")
    (get 'sgetc1 'inline-unsafe))
 
 ;;SPUTC
- (push '((fixnum object) fixnum #.(flags set rfa)"(putc(#0,(#1)->sm.sm_fp))")
+ (push '((fixnum object) fixnum #.(flags set rfa)"(gcl_putc(#0,(#1)->sm.sm_fp))")
    (get 'sputc 'inline-unsafe))
-(push '((character object) fixnum #.(flags set rfa)"(putc(#0,(#1)->sm.sm_fp))")
+(push '((character object) fixnum #.(flags set rfa)"(gcl_putc(#0,(#1)->sm.sm_fp))")
    (get 'sputc 'inline-unsafe))
 
 ;;READ-BYTE1
--- gcl-2.6.10.orig/configure
+++ gcl-2.6.10/configure
@@ -4801,6 +4801,54 @@ fi
 esac
 
 
+for ac_header in setjmp.h
+do :
+  ac_fn_c_check_header_mongrel "$LINENO" "setjmp.h" "ac_cv_header_setjmp_h" "$ac_includes_default"
+if test "x$ac_cv_header_setjmp_h" = xyes; then :
+  cat >>confdefs.h <<_ACEOF
+#define HAVE_SETJMP_H 1
+_ACEOF
+ { $as_echo "$as_me:${as_lineno-$LINENO}: checking sizeof jmp_buf" >&5
+$as_echo_n "checking sizeof jmp_buf... " >&6; }
+	if test "$cross_compiling" = yes; then :
+  { { $as_echo "$as_me:${as_lineno-$LINENO}: error: in \`$ac_pwd':" >&5
+$as_echo "$as_me: error: in \`$ac_pwd':" >&2;}
+as_fn_error $? "cannot run test program while cross compiling
+See \`config.log' for more details" "$LINENO" 5; }
+else
+  cat confdefs.h - <<_ACEOF >conftest.$ac_ext
+/* end confdefs.h.  */
+
+
+			#include <stdio.h>
+			#include <setjmp.h>
+			int main() {
+			   FILE *fp=fopen("conftest1","w");
+			   fprintf(fp,"%lu\n",sizeof(jmp_buf));
+			   fclose(fp);
+			   return 0;
+			}
+_ACEOF
+if ac_fn_c_try_run "$LINENO"; then :
+  sizeof_jmp_buf=`cat conftest1`
+			 { $as_echo "$as_me:${as_lineno-$LINENO}: result: $sizeof_jmp_buf" >&5
+$as_echo "$sizeof_jmp_buf" >&6; }
+
+cat >>confdefs.h <<_ACEOF
+#define SIZEOF_JMP_BUF $sizeof_jmp_buf
+_ACEOF
+
+else
+  { $as_echo "$as_me:${as_lineno-$LINENO}: result: no" >&5
+$as_echo "no" >&6; }
+fi
+rm -f core *.core core.conftest.* gmon.out bb.out conftest$ac_exeext \
+  conftest.$ac_objext conftest.beam conftest.$ac_ext
+fi
+
+fi
+
+done
 
 
 # sysconf
--- gcl-2.6.10.orig/configure.in
+++ gcl-2.6.10/configure.in
@@ -719,7 +719,22 @@ case $use in
 esac
 
 
-	
+AC_CHECK_HEADERS(setjmp.h,
+	AC_MSG_CHECKING([sizeof jmp_buf])
+	AC_RUN_IFELSE([
+		AC_LANG_SOURCE([[
+			#include <stdio.h>
+			#include <setjmp.h>
+			int main() {
+			   FILE *fp=fopen("conftest1","w");
+			   fprintf(fp,"%lu\n",sizeof(jmp_buf));
+			   fclose(fp);
+			   return 0;
+			}]])],
+			[sizeof_jmp_buf=`cat conftest1`
+			 AC_MSG_RESULT($sizeof_jmp_buf)
+			 AC_DEFINE_UNQUOTED(SIZEOF_JMP_BUF,$sizeof_jmp_buf,[sizeof jmp_buf])],
+			 [AC_MSG_RESULT(no)]))
 
 # sysconf
 
--- gcl-2.6.10.orig/h/compbas.h
+++ gcl-2.6.10/h/compbas.h
@@ -1,4 +1,2 @@
 #include <stdarg.h>
 #define _VA_LIST_DEFINED
-
-#include <setjmp.h>
--- gcl-2.6.10.orig/h/compprotos.h
+++ gcl-2.6.10/h/compprotos.h
@@ -166,11 +166,12 @@ double cos(double);
 double sin(double);
 double sqrt(double);
 double tan(double);
+int gcl_feof(void *);
+int gcl_getc(void *);
+int gcl_putc(int,void *);
 #ifdef CMPINCLUDE
-void * alloca(unsigned long);
-int feof(void *);
-int getc(void *);
-int putc(int,void *);
+int setjmp();
+int _setjmp();
 #endif
 void vfun_wrong_number_of_args(object);
 void ihs_overflow (void);
--- gcl-2.6.10.orig/h/elf32_mips_reloc_special.h
+++ gcl-2.6.10/h/elf32_mips_reloc_special.h
@@ -73,14 +73,16 @@ label_got_symbols(void *v1,Shdr *sec1,Sh
   void *v,*ve;
   ul q;
 
-  for (q=0,sym=sym1;sym<syme;sym++)
-    if (!strcmp(st1+sym->st_name,"_gp_disp")) {
+  for (q=0,sym=sym1;sym<syme;sym++) {
+    if (!strcmp(st1+sym->st_name,"_gp_disp"))
       sym->st_other=1;
-      q++;
-    } else if (!strcmp(st1+sym->st_name,"__gnu_local_gp")) {
+    else if (!strcmp(st1+sym->st_name,"__gnu_local_gp"))
       sym->st_other=2;
+    if (sym->st_other) {
       q++;
+      sym->st_info=ELF_ST_INFO(STB_LOCAL,ELF_ST_TYPE(sym->st_info));
     }
+  }
   massert(q<=1);
   
   for (sym=sym1;sym<syme;sym++)
--- gcl-2.6.10.orig/h/frame.h
+++ gcl-2.6.10/h/frame.h
@@ -75,13 +75,13 @@ enum fr_class {
 
 EXTER int in_signal_handler;
 struct frame {
-	jmp_buf		frs_jmpbuf;
 	object		*frs_lex;
 	bds_ptr		frs_bds_top;
 	char 	frs_class;
 	char frs_in_signal_handler;
 	object		frs_val;
 	ihs_ptr		frs_ihs;
+	char		frs_jmpbuf[SIZEOF_JMP_BUF];
 };
 
 typedef struct frame *frame_ptr;
--- gcl-2.6.10.orig/h/gclincl.h.in
+++ gcl-2.6.10/h/gclincl.h.in
@@ -195,6 +195,9 @@
 /* have setenv call */
 #undef HAVE_SETENV
 
+/* Define to 1 if you have the <setjmp.h> header file. */
+#undef HAVE_SETJMP_H
+
 /* Define to 1 if you have the `sigaltstack' function. */
 #undef HAVE_SIGALTSTACK
 
@@ -348,6 +351,9 @@
 /* sizeof linked list for contiguous pages */
 #undef SIZEOF_CONTBLOCK
 
+/* sizeof jmp_buf */
+#undef SIZEOF_JMP_BUF
+
 /* The size of `long', as computed by sizeof. */
 #undef SIZEOF_LONG
 
--- gcl-2.6.10.orig/h/include.h
+++ gcl-2.6.10/h/include.h
@@ -97,6 +97,7 @@ Foundation, 675 Mass Ave, Cambridge, MA
 #include "../h/mp.h"
 #endif
 
+#include <setjmp.h>
 #include <stdio.h>
 #include <stdlib.h>
 #include <math.h>
--- gcl-2.6.10.orig/o/frame.c
+++ gcl-2.6.10/o/frame.c
@@ -54,7 +54,7 @@ unwind(frame_ptr fr, object tag)
 	bds_unwind(frs_top->frs_bds_top);
 	in_signal_handler = frs_top->frs_in_signal_handler;
 	signals_allowed=sig_normal;
-	longjmp(frs_top->frs_jmpbuf, 0);
+	longjmp(*(jmp_buf *)&frs_top->frs_jmpbuf, 0);
 	/* never reached */
 }
 
--- gcl-2.6.10.orig/o/sfaslelf.c
+++ gcl-2.6.10/o/sfaslelf.c
@@ -48,6 +48,7 @@ License for more details.
 #define  ELF_R_INFO(a,b)       Mjoin(ELF,_R_INFO)(a,b)
 #define ELF_ST_BIND(a)         Mjoin(ELF,_ST_BIND)(a)
 #define ELF_ST_TYPE(a)         Mjoin(ELF,_ST_TYPE)(a)
+#define ELF_ST_INFO(a,b)       Mjoin(ELF,_ST_INFO)(a,b)
 #define ELF_ST_VISIBILITY(a)   Mjoin(ELF,_ST_VISIBILITY)(a)
 
 
--- gcl-2.6.10.orig/o/unixfsys.c
+++ gcl-2.6.10/o/unixfsys.c
@@ -493,6 +493,12 @@ char *gcl_gets(char *s,int z) {return fg
 int gcl_puts(const char *s) {int i=fputs(s,stdout);fflush(stdout);return i;}
 
 
+int gcl_feof(void *v) {return feof(v);}
+int gcl_getc(void *v) {return getc(v);}
+int gcl_putc(int i,void *v) {return putc(i,v);}
+
+
+
 DEFUN_NEW("STAT",object,fSstat,SI,1,1,NONE,OO,OO,OO,OO,(object path),"") {
 
   char filename[4096];
