/* StandaloneAppletViewer.java -- a standalone viewer for Java applets
   Copyright (C) 2003  Thomas Fitzsimmons <fitzsim@redhat.com>

   This file is part of GCJ Applet Viewer.

   GCJ Applet Viewer is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   GCJ Applet Viewer is distributed in the hope that it will be
   useful, but WITHOUT ANY WARRANTY; without even the implied warranty
   of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with GCJ Applet Viewer; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/

package gnu.gcjwebplugin;

import gnu.getopt.Getopt;
import java.awt.Dimension;
import java.io.File;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;


/**
 * StandaloneAppletViewer displays an applet in its own Frame.  Most
 * of the context that is available to an applet within a webpage is
 * available to it in StandaloneAppletViewer.
 */
class StandaloneAppletViewer extends AppletViewer
{
  static List appletWindows = new ArrayList();

  StandaloneAppletViewer(String code, String codebase, String archives,
                         List parameters, Dimension dimensions,
                         boolean widthGiven, boolean heightGiven,
                         boolean codeGiven, String[] args, Getopt opts,
                         int firstNonOptIndex, String encoding)
    throws MalformedURLException, IOException
  {
    boolean classFileGiven = false;

    // The list of all applet tags generated from the files given on
    // the command line.
    List appletTags = new LinkedList();

    // firstNonOptIndex the index of the first non-option command line
    // argument.  If there is no such argument and the --code option
    // wasn't given, then we have nothing to work with.
    if (firstNonOptIndex == args.length && code.equals(""))
      {
	System.out.println("gcjappletviewer: no input files");
	printHelpMessage(1);
      }

    // Only handle .class files on the command line if --code was not
    // given.
    if (code.equals(""))
      {
	for (int i = firstNonOptIndex; i < args.length; i++)
	  {
	    if (args[i].endsWith(".class"))
	      {
		classFileGiven = true;

		appletTags.add(new AppletTag(args[i], archives, parameters,
		                             dimensions, encoding));
		// Process only the first .class file we encounter on the
		// command line.
		break;
	      }
	  }
      }

    System.err.println("raw arguments:");

    for (int i = 0; i < args.length; i++)
      System.err.println(" " + args[i]);

    // Handle each file specified on the command line.
    for (int i = opts.getOptind(); i < args.length; i++)
      appletTags.addAll(AppletTag.parseAppletTags(args[i], encoding));

    // Handle --code option, if it was given.
    if (! code.equals(""))
      {
	String tagString =
	  "<EMBED CODE=\"" + code + "\"" + " CODEBASE=\"" + codebase + "\""
	  + " ARCHIVE=\"" + archives + "\"";

	// Handle parameters.
	Iterator pairs = parameters.iterator();
	while (pairs.hasNext())
	  {
	    StringTokenizer paramTokenizer =
	      new StringTokenizer((String) pairs.next(), ",");
	    tagString += " " + paramTokenizer.nextToken().trim() + "=\""
	    + paramTokenizer.nextToken().trim() + "\"";
	  }

	tagString += " WIDTH=" + dimensions.width;
	tagString += " HEIGHT=" + dimensions.height;

	tagString += "></EMBED>";

	System.err.println("code option given:");
	System.err.println(tagString);

	StringReader reader = new StringReader(tagString);
	String path = System.getProperty("user.dir") + File.separator;
	appletTags.add(AppletTag.parseNextTag(new StreamTokenizer(reader),
	                                      new URL("file", "", path),
	                                      encoding));
      }

    System.err.println("parsed applet tags:");

    for (int i = 0; i < appletTags.size(); i++)
      {
	AppletTag tag = (AppletTag) appletTags.get(i);

	// If neither a class file nor the --code option were given on
	// the command line then the given width and height options
	// override the width and height elements of the applet tag.
	if (! classFileGiven && ! codeGiven)
	  {
	    if (widthGiven)
	      {
		tag.parameters.put("width", Integer.toString(dimensions.width));
	      }

	    if (heightGiven)
	      {
		tag.parameters.put("height",
		                   Integer.toString(dimensions.height));
	      }
	  }
	System.err.println(" tag " + i + ":");
	System.err.println(tag);
      }

    for (int i = 0; i < appletTags.size(); i++)
      {
	AppletTag tag = (AppletTag) appletTags.get(i);

	// Create a StandaloneAppletWindow and add it to the
	// appletWindows list.
	new StandaloneAppletWindow(tag, appletWindows);
      }
  }
}
