SET(CPACK_PACKAGE_DESCRIPTION_SUMMARY "gccxml Complete")
SET(CPACK_PACKAGE_VENDOR "Kitware")
SET(CPACK_PACKAGE_DESCRIPTION_FILE "${CMAKE_CURRENT_SOURCE_DIR}/GCC_XML/Copyright.txt")
SET(CPACK_RESOURCE_FILE_LICENSE "${CMAKE_CURRENT_SOURCE_DIR}/GCC_XML/Copyright.txt")

# Same as values down in GCC_XML/CMakeLists.txt and GCC_XML/Copyright.txt:
# (extract/share these in a better way, so we do not have to duplicate the information...)
SET(GCCXML_VERSION_MAJOR 0)
SET(GCCXML_VERSION_MINOR 7)
SET(GCCXML_VERSION_PATCH 0)

SET(CPACK_PACKAGE_VERSION_MAJOR "${GCCXML_VERSION_MAJOR}")
SET(CPACK_PACKAGE_VERSION_MINOR "${GCCXML_VERSION_MINOR}")
SET(CPACK_PACKAGE_VERSION_PATCH "${GCCXML_VERSION_PATCH}")
SET(CPACK_PACKAGE_INSTALL_DIRECTORY "gccxml ${CPACK_PACKAGE_VERSION_MAJOR}.${CPACK_PACKAGE_VERSION_MINOR}")

SET(CPACK_SOURCE_PACKAGE_FILE_NAME
  "gccxml-${CPACK_PACKAGE_VERSION_MAJOR}.${CPACK_PACKAGE_VERSION_MINOR}.${CPACK_PACKAGE_VERSION_PATCH}")

IF(NOT DEFINED CPACK_SYSTEM_NAME)
  SET(CPACK_SYSTEM_NAME ${CMAKE_SYSTEM_NAME}-${CMAKE_SYSTEM_PROCESSOR})
ENDIF(NOT DEFINED CPACK_SYSTEM_NAME)
IF(${CPACK_SYSTEM_NAME} MATCHES Windows)
  IF(CMAKE_CL_64)
    SET(CPACK_SYSTEM_NAME win64-${CMAKE_SYSTEM_PROCESSOR})
  ELSE(CMAKE_CL_64)
    SET(CPACK_SYSTEM_NAME win32-${CMAKE_SYSTEM_PROCESSOR})
  ENDIF(CMAKE_CL_64)
ENDIF(${CPACK_SYSTEM_NAME} MATCHES Windows)

IF(NOT DEFINED CPACK_PACKAGE_FILE_NAME)
  SET(CPACK_PACKAGE_FILE_NAME "${CPACK_SOURCE_PACKAGE_FILE_NAME}-${CPACK_SYSTEM_NAME}")
ENDIF(NOT DEFINED CPACK_PACKAGE_FILE_NAME)

IF(WIN32)
  # NSI does not handle unix paths properly. Use Windows style path separator:
#  SET(icon_file "${CMAKE_CURRENT_SOURCE_DIR}/Win32Installer.bmp")
#  STRING(REGEX REPLACE "/" "\\\\" icon_file "${icon_file}")
#  SET(CPACK_PACKAGE_ICON "${icon_file}")

  SET(CPACK_NSIS_DISPLAY_NAME "${CPACK_PACKAGE_INSTALL_DIRECTORY} - XML output for GCC")
  SET(CPACK_NSIS_HELP_LINK "http://www.gccxml.org")
  SET(CPACK_NSIS_URL_INFO_ABOUT "http://www.kitware.com")
  SET(CPACK_NSIS_CONTACT "kitware@kitware.com")

  SET(CPACK_NSIS_EXTRA_INSTALL_COMMANDS "
  CreateShortCut \\\"$SMPROGRAMS\\\\$STARTMENU_FOLDER\\\\How to Run GCC-XML.lnk\\\" \\\"$INSTDIR\\\\share\\\\doc\\\\gccxml-${CPACK_PACKAGE_VERSION_MAJOR}.${CPACK_PACKAGE_VERSION_MINOR}\\\\gccxml.html\\\"
  ExecWait '\\\"$INSTDIR\\\\bin\\\\gccxml_vcupdate.bat\\\"'
")

  SET(CPACK_NSIS_EXTRA_UNINSTALL_COMMANDS "
  !insertmacro MUI_STARTMENU_GETFOLDER Application $MUI_TEMP
  Delete \\\"$SMPROGRAMS\\\\$MUI_TEMP\\\\How to Run GCC-XML.lnk\\\"
")

  SET(CPACK_GENERATOR "NSIS")
  SET(CPACK_SOURCE_GENERATOR "${CPACK_GENERATOR}")
ENDIF(WIN32)

INCLUDE(CPack)
