#  Copyright (C) 2023-2024 Free Software Foundation, Inc.
#
# This program is free software; you can redistribute it and/or modify it
# under the terms of the GNU General Public License as published by the
# Free Software Foundation; either version 3, or (at your option) any
# later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; see the file COPYING3.  If not see
# <http://www.gnu.org/licenses/>.

# This Awk script reads in the option records generated from 
# opt-gather.awk, and generates a C++ file containing an array
# of URL suffixes (possibly NULL), one per option.

# This program uses functions from opt-functions.awk and code from
# opt-read.awk.
#
# Usage: awk -f opt-functions.awk -f opt-read.awk -f options-urls-cc-gen.awk \
#            [-v header_name=header.h] < inputfile > options-urls.cc

END {


print "/* This file is auto-generated by options-urls-cc-gen.awk.  */"
print ""
print "#define INCLUDE_MEMORY"
n_headers = split(header_name, headers, " ")
for (i = 1; i <= n_headers; i++)
	print "#include " quote headers[i] quote
print "#include " quote "opts.h" quote
print "#include " quote "intl.h" quote
print "#include " quote "insn-attr-common.h" quote
print ""

if (n_extra_c_includes > 0) {
	for (i = 0; i < n_extra_c_includes; i++) {
		print "#include " quote extra_c_includes[i] quote
	}
	print ""
}

print "const char *"
print "get_opt_url_suffix (int option_index, unsigned lang_mask)"
print "{"
print "  switch (option_index)"
print "    {"


optindex = 0
for (i = 0; i < n_opts; i++) {
	# Combine the flags of identical switches.  Switches
	# appear many times if they are handled by many front
	# ends, for example.
	while( i + 1 != n_opts && opts[i] == opts[i + 1] ) {
		flags[i + 1] = flags[i] " " flags[i + 1];
		i++;
	}

	len = length (opts[i]);
	enum = opt_enum(opts[i])

	# Aliases do not get enumeration names.
	if ((flag_set_p("Alias.*", flags[i]) \
	     && !flag_set_p("SeparateAlias", flags[i])) \
	    || flag_set_p("Ignore", flags[i])) {
	    show_case = 0;
	} else {
	    show_case = 1;
	}

	if (show_case) {
	    printf("     case %s:\n", opt_enum(opts[i]))

	    # Handle any lang-specific LangUrlSuffix directives:
	    for (lang_idx = 0; lang_idx < n_langs; lang_idx++) {
		lang_name = lang_sanitized_name(langs[lang_idx])
		u = lang_url_suffix(flags[i], lang_name)
		if (u != "") {
		    printf("       if (lang_mask & CL_%s)\n", lang_name)
		    printf("         return \"%s\";\n", u)
		}
	    }

	    # Use any language-independent UrlSuffix directive:
	    u = url_suffix(flags[i])
	    if (u != "") {
		printf("       return \"%s\";\n", u)
	    } else {
		printf("       break;\n")
	    }
	}

	# Bump up the informational option index.
	++optindex
 }

print "    }"
print "  return nullptr;"
print "}"
}
