;; Iterators for RISC-V 'V' Extension for GNU compiler.
;; Copyright (C) 2022-2023 Free Software Foundation, Inc.
;; Contributed by Juzhe Zhong (juzhe.zhong@rivai.ai), RiVAI Technologies Ltd.

;; This file is part of GCC.

;; GCC is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 3, or (at your option)
;; any later version.

;; GCC is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with GCC; see the file COPYING3.  If not see
;; <http://www.gnu.org/licenses/>.

(define_c_enum "unspec" [
  UNSPEC_VSETVL
  UNSPEC_VUNDEF
  UNSPEC_VPREDICATE
  UNSPEC_VLMAX
  UNSPEC_UNIT_STRIDED
  UNSPEC_STRIDED

  ;; It's used to specify ordered/unorderd operation.
  UNSPEC_ORDERED
  UNSPEC_UNORDERED

  ;; vmulh/vmulhu/vmulhsu
  UNSPEC_VMULHS
  UNSPEC_VMULHU
  UNSPEC_VMULHSU

  UNSPEC_VADC
  UNSPEC_VSBC
  UNSPEC_VMADC
  UNSPEC_VMSBC
  UNSPEC_OVERFLOW

  UNSPEC_VNCLIP
  UNSPEC_VNCLIPU
  UNSPEC_VSSRL
  UNSPEC_VSSRA
  UNSPEC_VAADDU
  UNSPEC_VAADD
  UNSPEC_VASUBU
  UNSPEC_VASUB
  UNSPEC_VSMUL

  UNSPEC_VMSBF
  UNSPEC_VMSIF
  UNSPEC_VMSOF
  UNSPEC_VIOTA

  UNSPEC_VFRSQRT7
  UNSPEC_VFREC7
  UNSPEC_VFCLASS

  UNSPEC_VCOPYSIGN
  UNSPEC_VXORSIGN

  UNSPEC_VFCVT
  UNSPEC_UNSIGNED_VFCVT
  UNSPEC_ROD

  UNSPEC_REDUC
  UNSPEC_WREDUC_SUM
  UNSPEC_WREDUC_USUM
  UNSPEC_VSLIDEUP
  UNSPEC_VSLIDEDOWN
  UNSPEC_VSLIDE1UP
  UNSPEC_VSLIDE1DOWN
  UNSPEC_VFSLIDE1UP
  UNSPEC_VFSLIDE1DOWN
  UNSPEC_VRGATHER
  UNSPEC_VRGATHEREI16
  UNSPEC_VCOMPRESS
  UNSPEC_VLEFF
  UNSPEC_MODIFY_VL

  UNSPEC_VFFMA
])

(define_c_enum "unspecv" [
  UNSPECV_FRM_RESTORE_EXIT
])

(define_mode_iterator V [
  RVVM8QI RVVM4QI RVVM2QI RVVM1QI RVVMF2QI RVVMF4QI (RVVMF8QI "TARGET_MIN_VLEN > 32")

  RVVM8HI RVVM4HI RVVM2HI RVVM1HI RVVMF2HI (RVVMF4HI "TARGET_MIN_VLEN > 32")

  (RVVM8HF "TARGET_VECTOR_ELEN_FP_16") (RVVM4HF "TARGET_VECTOR_ELEN_FP_16") (RVVM2HF "TARGET_VECTOR_ELEN_FP_16")
  (RVVM1HF "TARGET_VECTOR_ELEN_FP_16") (RVVMF2HF "TARGET_VECTOR_ELEN_FP_16")
  (RVVMF4HF "TARGET_VECTOR_ELEN_FP_16 && TARGET_MIN_VLEN > 32")

  RVVM8SI RVVM4SI RVVM2SI RVVM1SI (RVVMF2SI "TARGET_MIN_VLEN > 32")

  (RVVM8SF "TARGET_VECTOR_ELEN_FP_32") (RVVM4SF "TARGET_VECTOR_ELEN_FP_32") (RVVM2SF "TARGET_VECTOR_ELEN_FP_32")
  (RVVM1SF "TARGET_VECTOR_ELEN_FP_32") (RVVMF2SF "TARGET_VECTOR_ELEN_FP_32 && TARGET_MIN_VLEN > 32")

  (RVVM8DI "TARGET_VECTOR_ELEN_64") (RVVM4DI "TARGET_VECTOR_ELEN_64")
  (RVVM2DI "TARGET_VECTOR_ELEN_64") (RVVM1DI "TARGET_VECTOR_ELEN_64")

  (RVVM8DF "TARGET_VECTOR_ELEN_FP_64") (RVVM4DF "TARGET_VECTOR_ELEN_FP_64")
  (RVVM2DF "TARGET_VECTOR_ELEN_FP_64") (RVVM1DF "TARGET_VECTOR_ELEN_FP_64")
])

(define_mode_iterator V_VLS [
  RVVM8QI RVVM4QI RVVM2QI RVVM1QI RVVMF2QI RVVMF4QI (RVVMF8QI "TARGET_MIN_VLEN > 32")

  RVVM8HI RVVM4HI RVVM2HI RVVM1HI RVVMF2HI (RVVMF4HI "TARGET_MIN_VLEN > 32")

  (RVVM8HF "TARGET_VECTOR_ELEN_FP_16") (RVVM4HF "TARGET_VECTOR_ELEN_FP_16") (RVVM2HF "TARGET_VECTOR_ELEN_FP_16")
  (RVVM1HF "TARGET_VECTOR_ELEN_FP_16") (RVVMF2HF "TARGET_VECTOR_ELEN_FP_16")
  (RVVMF4HF "TARGET_VECTOR_ELEN_FP_16 && TARGET_MIN_VLEN > 32")

  RVVM8SI RVVM4SI RVVM2SI RVVM1SI (RVVMF2SI "TARGET_MIN_VLEN > 32")

  (RVVM8SF "TARGET_VECTOR_ELEN_FP_32") (RVVM4SF "TARGET_VECTOR_ELEN_FP_32") (RVVM2SF "TARGET_VECTOR_ELEN_FP_32")
  (RVVM1SF "TARGET_VECTOR_ELEN_FP_32") (RVVMF2SF "TARGET_VECTOR_ELEN_FP_32 && TARGET_MIN_VLEN > 32")

  (RVVM8DI "TARGET_VECTOR_ELEN_64") (RVVM4DI "TARGET_VECTOR_ELEN_64")
  (RVVM2DI "TARGET_VECTOR_ELEN_64") (RVVM1DI "TARGET_VECTOR_ELEN_64")

  (RVVM8DF "TARGET_VECTOR_ELEN_FP_64") (RVVM4DF "TARGET_VECTOR_ELEN_FP_64")
  (RVVM2DF "TARGET_VECTOR_ELEN_FP_64") (RVVM1DF "TARGET_VECTOR_ELEN_FP_64")

  ;; VLS modes.
  (V1QI "TARGET_VECTOR_VLS")
  (V2QI "TARGET_VECTOR_VLS")
  (V4QI "TARGET_VECTOR_VLS")
  (V8QI "TARGET_VECTOR_VLS")
  (V16QI "TARGET_VECTOR_VLS")
  (V32QI "TARGET_VECTOR_VLS")
  (V64QI "TARGET_VECTOR_VLS && TARGET_MIN_VLEN >= 64")
  (V128QI "TARGET_VECTOR_VLS && TARGET_MIN_VLEN >= 128")
  (V256QI "TARGET_VECTOR_VLS && TARGET_MIN_VLEN >= 256")
  (V512QI "TARGET_VECTOR_VLS && TARGET_MIN_VLEN >= 512")
  (V1024QI "TARGET_VECTOR_VLS && TARGET_MIN_VLEN >= 1024")
  (V2048QI "TARGET_VECTOR_VLS && TARGET_MIN_VLEN >= 2048")
  (V4096QI "TARGET_VECTOR_VLS && TARGET_MIN_VLEN >= 4096")
  (V1HI "TARGET_VECTOR_VLS")
  (V2HI "TARGET_VECTOR_VLS")
  (V4HI "TARGET_VECTOR_VLS")
  (V8HI "TARGET_VECTOR_VLS")
  (V16HI "TARGET_VECTOR_VLS")
  (V32HI "TARGET_VECTOR_VLS && TARGET_MIN_VLEN >= 64")
  (V64HI "TARGET_VECTOR_VLS && TARGET_MIN_VLEN >= 128")
  (V128HI "TARGET_VECTOR_VLS && TARGET_MIN_VLEN >= 256")
  (V256HI "TARGET_VECTOR_VLS && TARGET_MIN_VLEN >= 512")
  (V512HI "TARGET_VECTOR_VLS && TARGET_MIN_VLEN >= 1024")
  (V1024HI "TARGET_VECTOR_VLS && TARGET_MIN_VLEN >= 2048")
  (V2048HI "TARGET_VECTOR_VLS && TARGET_MIN_VLEN >= 4096")
  (V1SI "TARGET_VECTOR_VLS")
  (V2SI "TARGET_VECTOR_VLS")
  (V4SI "TARGET_VECTOR_VLS")
  (V8SI "TARGET_VECTOR_VLS")
  (V16SI "TARGET_VECTOR_VLS && TARGET_MIN_VLEN >= 64")
  (V32SI "TARGET_VECTOR_VLS && TARGET_MIN_VLEN >= 128")
  (V64SI "TARGET_VECTOR_VLS && TARGET_MIN_VLEN >= 256")
  (V128SI "TARGET_VECTOR_VLS && TARGET_MIN_VLEN >= 512")
  (V256SI "TARGET_VECTOR_VLS && TARGET_MIN_VLEN >= 1024")
  (V512SI "TARGET_VECTOR_VLS && TARGET_MIN_VLEN >= 2048")
  (V1024SI "TARGET_VECTOR_VLS && TARGET_MIN_VLEN >= 4096")
  (V1DI "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_64")
  (V2DI "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_64")
  (V4DI "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_64")
  (V8DI "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_64 && TARGET_MIN_VLEN >= 64")
  (V16DI "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_64 && TARGET_MIN_VLEN >= 128")
  (V32DI "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_64 && TARGET_MIN_VLEN >= 256")
  (V64DI "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_64 && TARGET_MIN_VLEN >= 512")
  (V128DI "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_64 && TARGET_MIN_VLEN >= 1024")
  (V256DI "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_64 && TARGET_MIN_VLEN >= 2048")
  (V512DI "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_64 && TARGET_MIN_VLEN >= 4096")
  (V1HF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_16")
  (V2HF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_16")
  (V4HF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_16")
  (V8HF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_16")
  (V16HF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_16")
  (V32HF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_16 && TARGET_MIN_VLEN >= 64")
  (V64HF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_16 && TARGET_MIN_VLEN >= 128")
  (V128HF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_16 && TARGET_MIN_VLEN >= 256")
  (V256HF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_16 && TARGET_MIN_VLEN >= 512")
  (V512HF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_16 && TARGET_MIN_VLEN >= 1024")
  (V1024HF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_16 && TARGET_MIN_VLEN >= 2048")
  (V2048HF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_16 && TARGET_MIN_VLEN >= 4096")
  (V1SF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_32")
  (V2SF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_32")
  (V4SF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_32")
  (V8SF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_32")
  (V16SF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_32 && TARGET_MIN_VLEN >= 64")
  (V32SF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_32 && TARGET_MIN_VLEN >= 128")
  (V64SF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_32 && TARGET_MIN_VLEN >= 256")
  (V128SF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_32 && TARGET_MIN_VLEN >= 512")
  (V256SF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_32 && TARGET_MIN_VLEN >= 1024")
  (V512SF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_32 && TARGET_MIN_VLEN >= 2048")
  (V1024SF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_32 && TARGET_MIN_VLEN >= 4096")
  (V1DF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_64")
  (V2DF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_64")
  (V4DF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_64")
  (V8DF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_64 && TARGET_MIN_VLEN >= 64")
  (V16DF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_64 && TARGET_MIN_VLEN >= 128")
  (V32DF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_64 && TARGET_MIN_VLEN >= 256")
  (V64DF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_64 && TARGET_MIN_VLEN >= 512")
  (V128DF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_64 && TARGET_MIN_VLEN >= 1024")
  (V256DF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_64 && TARGET_MIN_VLEN >= 2048")
  (V512DF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_64 && TARGET_MIN_VLEN >= 4096")
])

(define_mode_iterator VEEWEXT2 [
  RVVM8HI RVVM4HI RVVM2HI RVVM1HI RVVMF2HI (RVVMF4HI "TARGET_MIN_VLEN > 32")

  (RVVM8HF "TARGET_VECTOR_ELEN_FP_16") (RVVM4HF "TARGET_VECTOR_ELEN_FP_16") (RVVM2HF "TARGET_VECTOR_ELEN_FP_16")
  (RVVM1HF "TARGET_VECTOR_ELEN_FP_16") (RVVMF2HF "TARGET_VECTOR_ELEN_FP_16")
  (RVVMF4HF "TARGET_VECTOR_ELEN_FP_16 && TARGET_MIN_VLEN > 32")

  RVVM8SI RVVM4SI RVVM2SI RVVM1SI (RVVMF2SI "TARGET_MIN_VLEN > 32")

  (RVVM8SF "TARGET_VECTOR_ELEN_FP_32") (RVVM4SF "TARGET_VECTOR_ELEN_FP_32") (RVVM2SF "TARGET_VECTOR_ELEN_FP_32")
  (RVVM1SF "TARGET_VECTOR_ELEN_FP_32") (RVVMF2SF "TARGET_VECTOR_ELEN_FP_32 && TARGET_MIN_VLEN > 32")

  (RVVM8DI "TARGET_VECTOR_ELEN_64") (RVVM4DI "TARGET_VECTOR_ELEN_64")
  (RVVM2DI "TARGET_VECTOR_ELEN_64") (RVVM1DI "TARGET_VECTOR_ELEN_64")

  (RVVM8DF "TARGET_VECTOR_ELEN_FP_64") (RVVM4DF "TARGET_VECTOR_ELEN_FP_64")
  (RVVM2DF "TARGET_VECTOR_ELEN_FP_64") (RVVM1DF "TARGET_VECTOR_ELEN_FP_64")
])

(define_mode_iterator VEEWEXT4 [
  RVVM8SI RVVM4SI RVVM2SI RVVM1SI (RVVMF2SI "TARGET_MIN_VLEN > 32")

  (RVVM8SF "TARGET_VECTOR_ELEN_FP_32") (RVVM4SF "TARGET_VECTOR_ELEN_FP_32") (RVVM2SF "TARGET_VECTOR_ELEN_FP_32")
  (RVVM1SF "TARGET_VECTOR_ELEN_FP_32") (RVVMF2SF "TARGET_VECTOR_ELEN_FP_32 && TARGET_MIN_VLEN > 32")

  (RVVM8DI "TARGET_VECTOR_ELEN_64") (RVVM4DI "TARGET_VECTOR_ELEN_64")
  (RVVM2DI "TARGET_VECTOR_ELEN_64") (RVVM1DI "TARGET_VECTOR_ELEN_64")

  (RVVM8DF "TARGET_VECTOR_ELEN_FP_64") (RVVM4DF "TARGET_VECTOR_ELEN_FP_64")
  (RVVM2DF "TARGET_VECTOR_ELEN_FP_64") (RVVM1DF "TARGET_VECTOR_ELEN_FP_64")
])

(define_mode_iterator VEEWEXT8 [
  (RVVM8DI "TARGET_VECTOR_ELEN_64") (RVVM4DI "TARGET_VECTOR_ELEN_64")
  (RVVM2DI "TARGET_VECTOR_ELEN_64") (RVVM1DI "TARGET_VECTOR_ELEN_64")

  (RVVM8DF "TARGET_VECTOR_ELEN_FP_64") (RVVM4DF "TARGET_VECTOR_ELEN_FP_64")
  (RVVM2DF "TARGET_VECTOR_ELEN_FP_64") (RVVM1DF "TARGET_VECTOR_ELEN_FP_64")
])

(define_mode_iterator VEEWTRUNC2 [
  RVVM4QI RVVM2QI RVVM1QI RVVMF2QI RVVMF4QI (RVVMF8QI "TARGET_MIN_VLEN > 32")

  RVVM4HI RVVM2HI RVVM1HI RVVMF2HI (RVVMF4HI "TARGET_MIN_VLEN > 32")

  (RVVM4HF "TARGET_VECTOR_ELEN_FP_16") (RVVM2HF "TARGET_VECTOR_ELEN_FP_16")
  (RVVM1HF "TARGET_VECTOR_ELEN_FP_16") (RVVMF2HF "TARGET_VECTOR_ELEN_FP_16")
  (RVVMF4HF "TARGET_VECTOR_ELEN_FP_16 && TARGET_MIN_VLEN > 32")

  RVVM4SI RVVM2SI RVVM1SI (RVVMF2SI "TARGET_MIN_VLEN > 32")

  (RVVM4SF "TARGET_VECTOR_ELEN_FP_32") (RVVM2SF "TARGET_VECTOR_ELEN_FP_32")
  (RVVM1SF "TARGET_VECTOR_ELEN_FP_32") (RVVMF2SF "TARGET_VECTOR_ELEN_FP_32 && TARGET_MIN_VLEN > 32")
])

(define_mode_iterator VEEWTRUNC4 [
  RVVM2QI RVVM1QI RVVMF2QI RVVMF4QI (RVVMF8QI "TARGET_MIN_VLEN > 32")

  RVVM2HI RVVM1HI RVVMF2HI (RVVMF4HI "TARGET_MIN_VLEN > 32")

  (RVVM2HF "TARGET_VECTOR_ELEN_FP_16") (RVVM1HF "TARGET_VECTOR_ELEN_FP_16") (RVVMF2HF "TARGET_VECTOR_ELEN_FP_16")
  (RVVMF4HF "TARGET_VECTOR_ELEN_FP_16 && TARGET_MIN_VLEN > 32")
])

(define_mode_iterator VEEWTRUNC8 [
  RVVM1QI RVVMF2QI RVVMF4QI (RVVMF8QI "TARGET_MIN_VLEN > 32")
])

(define_mode_iterator VLMULEXT2 [
  RVVM4QI RVVM2QI RVVM1QI RVVMF2QI RVVMF4QI (RVVMF8QI "TARGET_MIN_VLEN > 32")

  RVVM4HI RVVM2HI RVVM1HI RVVMF2HI (RVVMF4HI "TARGET_MIN_VLEN > 32")

  (RVVM4HF "TARGET_VECTOR_ELEN_FP_16") (RVVM2HF "TARGET_VECTOR_ELEN_FP_16")
  (RVVM1HF "TARGET_VECTOR_ELEN_FP_16") (RVVMF2HF "TARGET_VECTOR_ELEN_FP_16")
  (RVVMF4HF "TARGET_VECTOR_ELEN_FP_16 && TARGET_MIN_VLEN > 32")

  RVVM4SI RVVM2SI RVVM1SI (RVVMF2SI "TARGET_MIN_VLEN > 32")

  (RVVM4SF "TARGET_VECTOR_ELEN_FP_32") (RVVM2SF "TARGET_VECTOR_ELEN_FP_32")
  (RVVM1SF "TARGET_VECTOR_ELEN_FP_32") (RVVMF2SF "TARGET_VECTOR_ELEN_FP_32 && TARGET_MIN_VLEN > 32")

  (RVVM4DI "TARGET_VECTOR_ELEN_64") (RVVM2DI "TARGET_VECTOR_ELEN_64") (RVVM1DI "TARGET_VECTOR_ELEN_64")

  (RVVM4DF "TARGET_VECTOR_ELEN_FP_64") (RVVM2DF "TARGET_VECTOR_ELEN_FP_64") (RVVM1DF "TARGET_VECTOR_ELEN_FP_64")
])

(define_mode_iterator VLMULEXT4 [
  RVVM2QI RVVM1QI RVVMF2QI RVVMF4QI (RVVMF8QI "TARGET_MIN_VLEN > 32")

  RVVM2HI RVVM1HI RVVMF2HI (RVVMF4HI "TARGET_MIN_VLEN > 32")

  (RVVM2HF "TARGET_VECTOR_ELEN_FP_16") (RVVM1HF "TARGET_VECTOR_ELEN_FP_16") (RVVMF2HF "TARGET_VECTOR_ELEN_FP_16")
  (RVVMF4HF "TARGET_VECTOR_ELEN_FP_16 && TARGET_MIN_VLEN > 32")

  RVVM2SI RVVM1SI (RVVMF2SI "TARGET_MIN_VLEN > 32")

  (RVVM2SF "TARGET_VECTOR_ELEN_FP_32") (RVVM1SF "TARGET_VECTOR_ELEN_FP_32") (RVVMF2SF "TARGET_VECTOR_ELEN_FP_32 && TARGET_MIN_VLEN > 32")

  (RVVM2DI "TARGET_VECTOR_ELEN_64") (RVVM1DI "TARGET_VECTOR_ELEN_64")

  (RVVM2DF "TARGET_VECTOR_ELEN_FP_64") (RVVM1DF "TARGET_VECTOR_ELEN_FP_64")
])

(define_mode_iterator VLMULEXT8 [
  RVVM1QI RVVMF2QI RVVMF4QI (RVVMF8QI "TARGET_MIN_VLEN > 32")

  RVVM1HI RVVMF2HI (RVVMF4HI "TARGET_MIN_VLEN > 32")

  (RVVM1HF "TARGET_VECTOR_ELEN_FP_16") (RVVMF2HF "TARGET_VECTOR_ELEN_FP_16")
  (RVVMF4HF "TARGET_VECTOR_ELEN_FP_16 && TARGET_MIN_VLEN > 32")

  RVVM1SI (RVVMF2SI "TARGET_MIN_VLEN > 32")

  (RVVM1SF "TARGET_VECTOR_ELEN_FP_32") (RVVMF2SF "TARGET_VECTOR_ELEN_FP_32 && TARGET_MIN_VLEN > 32")

  (RVVM1DI "TARGET_VECTOR_ELEN_64")

  (RVVM1DF "TARGET_VECTOR_ELEN_FP_64")
])

(define_mode_iterator VLMULEXT16 [
  RVVMF2QI RVVMF4QI (RVVMF8QI "TARGET_MIN_VLEN > 32")

  RVVMF2HI (RVVMF4HI "TARGET_MIN_VLEN > 32")

  (RVVMF2HF "TARGET_VECTOR_ELEN_FP_16") (RVVMF4HF "TARGET_VECTOR_ELEN_FP_16 && TARGET_MIN_VLEN > 32")

  (RVVMF2SI "TARGET_MIN_VLEN > 32")

  (RVVMF2SF "TARGET_VECTOR_ELEN_FP_32 && TARGET_MIN_VLEN > 32")
])

(define_mode_iterator VLMULEXT32 [
  RVVMF4QI (RVVMF8QI "TARGET_MIN_VLEN > 32")

  (RVVMF4HI "TARGET_MIN_VLEN > 32")

  (RVVMF4HF "TARGET_VECTOR_ELEN_FP_16 && TARGET_MIN_VLEN > 32")
])

(define_mode_iterator VLMULEXT64 [
  (RVVMF8QI "TARGET_MIN_VLEN > 32")
])

(define_mode_iterator VEI16 [
  RVVM4QI RVVM2QI RVVM1QI RVVMF2QI RVVMF4QI (RVVMF8QI "TARGET_MIN_VLEN > 32")

  RVVM8HI RVVM4HI RVVM2HI RVVM1HI RVVMF2HI (RVVMF4HI "TARGET_MIN_VLEN > 32")

  (RVVM8HF "TARGET_VECTOR_ELEN_FP_16") (RVVM4HF "TARGET_VECTOR_ELEN_FP_16") (RVVM2HF "TARGET_VECTOR_ELEN_FP_16")
  (RVVM1HF "TARGET_VECTOR_ELEN_FP_16") (RVVMF2HF "TARGET_VECTOR_ELEN_FP_16")
  (RVVMF4HF "TARGET_VECTOR_ELEN_FP_16 && TARGET_MIN_VLEN > 32")

  RVVM8SI RVVM4SI RVVM2SI RVVM1SI (RVVMF2SI "TARGET_MIN_VLEN > 32")

  (RVVM8SF "TARGET_VECTOR_ELEN_FP_32") (RVVM4SF "TARGET_VECTOR_ELEN_FP_32") (RVVM2SF "TARGET_VECTOR_ELEN_FP_32")
  (RVVM1SF "TARGET_VECTOR_ELEN_FP_32") (RVVMF2SF "TARGET_VECTOR_ELEN_FP_32 && TARGET_MIN_VLEN > 32")

  (RVVM8DI "TARGET_VECTOR_ELEN_64") (RVVM4DI "TARGET_VECTOR_ELEN_64")
  (RVVM2DI "TARGET_VECTOR_ELEN_64") (RVVM1DI "TARGET_VECTOR_ELEN_64")

  (RVVM8DF "TARGET_VECTOR_ELEN_FP_64") (RVVM4DF "TARGET_VECTOR_ELEN_FP_64")
  (RVVM2DF "TARGET_VECTOR_ELEN_FP_64") (RVVM1DF "TARGET_VECTOR_ELEN_FP_64")
])

(define_mode_iterator VI [
  RVVM8QI RVVM4QI RVVM2QI RVVM1QI RVVMF2QI RVVMF4QI (RVVMF8QI "TARGET_MIN_VLEN > 32")

  RVVM8HI RVVM4HI RVVM2HI RVVM1HI RVVMF2HI (RVVMF4HI "TARGET_MIN_VLEN > 32")

  RVVM8SI RVVM4SI RVVM2SI RVVM1SI (RVVMF2SI "TARGET_MIN_VLEN > 32")

  (RVVM8DI "TARGET_VECTOR_ELEN_64") (RVVM4DI "TARGET_VECTOR_ELEN_64")
  (RVVM2DI "TARGET_VECTOR_ELEN_64") (RVVM1DI "TARGET_VECTOR_ELEN_64")
])

(define_mode_iterator V_VLSI [
  RVVM8QI RVVM4QI RVVM2QI RVVM1QI RVVMF2QI RVVMF4QI (RVVMF8QI "TARGET_MIN_VLEN > 32")

  RVVM8HI RVVM4HI RVVM2HI RVVM1HI RVVMF2HI (RVVMF4HI "TARGET_MIN_VLEN > 32")

  RVVM8SI RVVM4SI RVVM2SI RVVM1SI (RVVMF2SI "TARGET_MIN_VLEN > 32")

  (RVVM8DI "TARGET_VECTOR_ELEN_64") (RVVM4DI "TARGET_VECTOR_ELEN_64")
  (RVVM2DI "TARGET_VECTOR_ELEN_64") (RVVM1DI "TARGET_VECTOR_ELEN_64")

  (V1QI "TARGET_VECTOR_VLS")
  (V2QI "TARGET_VECTOR_VLS")
  (V4QI "TARGET_VECTOR_VLS")
  (V8QI "TARGET_VECTOR_VLS")
  (V16QI "TARGET_VECTOR_VLS")
  (V32QI "TARGET_VECTOR_VLS")
  (V64QI "TARGET_VECTOR_VLS && TARGET_MIN_VLEN >= 64")
  (V128QI "TARGET_VECTOR_VLS && TARGET_MIN_VLEN >= 128")
  (V256QI "TARGET_VECTOR_VLS && TARGET_MIN_VLEN >= 256")
  (V512QI "TARGET_VECTOR_VLS && TARGET_MIN_VLEN >= 512")
  (V1024QI "TARGET_VECTOR_VLS && TARGET_MIN_VLEN >= 1024")
  (V2048QI "TARGET_VECTOR_VLS && TARGET_MIN_VLEN >= 2048")
  (V4096QI "TARGET_VECTOR_VLS && TARGET_MIN_VLEN >= 4096")
  (V1HI "TARGET_VECTOR_VLS")
  (V2HI "TARGET_VECTOR_VLS")
  (V4HI "TARGET_VECTOR_VLS")
  (V8HI "TARGET_VECTOR_VLS")
  (V16HI "TARGET_VECTOR_VLS")
  (V32HI "TARGET_VECTOR_VLS && TARGET_MIN_VLEN >= 64")
  (V64HI "TARGET_VECTOR_VLS && TARGET_MIN_VLEN >= 128")
  (V128HI "TARGET_VECTOR_VLS && TARGET_MIN_VLEN >= 256")
  (V256HI "TARGET_VECTOR_VLS && TARGET_MIN_VLEN >= 512")
  (V512HI "TARGET_VECTOR_VLS && TARGET_MIN_VLEN >= 1024")
  (V1024HI "TARGET_VECTOR_VLS && TARGET_MIN_VLEN >= 2048")
  (V2048HI "TARGET_VECTOR_VLS && TARGET_MIN_VLEN >= 4096")
  (V1SI "TARGET_VECTOR_VLS")
  (V2SI "TARGET_VECTOR_VLS")
  (V4SI "TARGET_VECTOR_VLS")
  (V8SI "TARGET_VECTOR_VLS")
  (V16SI "TARGET_VECTOR_VLS && TARGET_MIN_VLEN >= 64")
  (V32SI "TARGET_VECTOR_VLS && TARGET_MIN_VLEN >= 128")
  (V64SI "TARGET_VECTOR_VLS && TARGET_MIN_VLEN >= 256")
  (V128SI "TARGET_VECTOR_VLS && TARGET_MIN_VLEN >= 512")
  (V256SI "TARGET_VECTOR_VLS && TARGET_MIN_VLEN >= 1024")
  (V512SI "TARGET_VECTOR_VLS && TARGET_MIN_VLEN >= 2048")
  (V1024SI "TARGET_VECTOR_VLS && TARGET_MIN_VLEN >= 4096")
  (V1DI "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_64")
  (V2DI "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_64")
  (V4DI "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_64")
  (V8DI "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_64 && TARGET_MIN_VLEN >= 64")
  (V16DI "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_64 && TARGET_MIN_VLEN >= 128")
  (V32DI "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_64 && TARGET_MIN_VLEN >= 256")
  (V64DI "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_64 && TARGET_MIN_VLEN >= 512")
  (V128DI "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_64 && TARGET_MIN_VLEN >= 1024")
  (V256DI "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_64 && TARGET_MIN_VLEN >= 2048")
  (V512DI "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_64 && TARGET_MIN_VLEN >= 4096")
])

(define_mode_iterator V_VLSF [
  (RVVM8HF "TARGET_ZVFH") (RVVM4HF "TARGET_ZVFH") (RVVM2HF "TARGET_ZVFH")
  (RVVM1HF "TARGET_ZVFH") (RVVMF2HF "TARGET_ZVFH")
  (RVVMF4HF "TARGET_ZVFH && TARGET_MIN_VLEN > 32")
  (RVVM8SF "TARGET_VECTOR_ELEN_FP_32") (RVVM4SF "TARGET_VECTOR_ELEN_FP_32") (RVVM2SF "TARGET_VECTOR_ELEN_FP_32")
  (RVVM1SF "TARGET_VECTOR_ELEN_FP_32") (RVVMF2SF "TARGET_VECTOR_ELEN_FP_32 && TARGET_MIN_VLEN > 32")
  (RVVM8DF "TARGET_VECTOR_ELEN_FP_64") (RVVM4DF "TARGET_VECTOR_ELEN_FP_64")
  (RVVM2DF "TARGET_VECTOR_ELEN_FP_64") (RVVM1DF "TARGET_VECTOR_ELEN_FP_64")

  (V1HF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_16")
  (V2HF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_16")
  (V4HF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_16")
  (V8HF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_16")
  (V16HF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_16")
  (V32HF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_16 && TARGET_MIN_VLEN >= 64")
  (V64HF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_16 && TARGET_MIN_VLEN >= 128")
  (V128HF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_16 && TARGET_MIN_VLEN >= 256")
  (V256HF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_16 && TARGET_MIN_VLEN >= 512")
  (V512HF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_16 && TARGET_MIN_VLEN >= 1024")
  (V1024HF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_16 && TARGET_MIN_VLEN >= 2048")
  (V2048HF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_16 && TARGET_MIN_VLEN >= 4096")
  (V1SF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_32")
  (V2SF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_32")
  (V4SF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_32")
  (V8SF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_32")
  (V16SF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_32 && TARGET_MIN_VLEN >= 64")
  (V32SF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_32 && TARGET_MIN_VLEN >= 128")
  (V64SF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_32 && TARGET_MIN_VLEN >= 256")
  (V128SF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_32 && TARGET_MIN_VLEN >= 512")
  (V256SF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_32 && TARGET_MIN_VLEN >= 1024")
  (V512SF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_32 && TARGET_MIN_VLEN >= 2048")
  (V1024SF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_32 && TARGET_MIN_VLEN >= 4096")
  (V1DF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_64")
  (V2DF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_64")
  (V4DF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_64")
  (V8DF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_64 && TARGET_MIN_VLEN >= 64")
  (V16DF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_64 && TARGET_MIN_VLEN >= 128")
  (V32DF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_64 && TARGET_MIN_VLEN >= 256")
  (V64DF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_64 && TARGET_MIN_VLEN >= 512")
  (V128DF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_64 && TARGET_MIN_VLEN >= 1024")
  (V256DF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_64 && TARGET_MIN_VLEN >= 2048")
  (V512DF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_64 && TARGET_MIN_VLEN >= 4096")
])

(define_mode_iterator VF_ZVFHMIN [
  (RVVM8HF "TARGET_VECTOR_ELEN_FP_16") (RVVM4HF "TARGET_VECTOR_ELEN_FP_16") (RVVM2HF "TARGET_VECTOR_ELEN_FP_16")
  (RVVM1HF "TARGET_VECTOR_ELEN_FP_16") (RVVMF2HF "TARGET_VECTOR_ELEN_FP_16")
  (RVVMF4HF "TARGET_VECTOR_ELEN_FP_16 && TARGET_MIN_VLEN > 32")

  (RVVM8SF "TARGET_VECTOR_ELEN_FP_32") (RVVM4SF "TARGET_VECTOR_ELEN_FP_32") (RVVM2SF "TARGET_VECTOR_ELEN_FP_32")
  (RVVM1SF "TARGET_VECTOR_ELEN_FP_32") (RVVMF2SF "TARGET_VECTOR_ELEN_FP_32 && TARGET_MIN_VLEN > 32")

  (RVVM8DF "TARGET_VECTOR_ELEN_FP_64") (RVVM4DF "TARGET_VECTOR_ELEN_FP_64")
  (RVVM2DF "TARGET_VECTOR_ELEN_FP_64") (RVVM1DF "TARGET_VECTOR_ELEN_FP_64")
])

(define_mode_iterator V_VLSF_ZVFHMIN [
  (RVVM8HF "TARGET_VECTOR_ELEN_FP_16") (RVVM4HF "TARGET_VECTOR_ELEN_FP_16") (RVVM2HF "TARGET_VECTOR_ELEN_FP_16")
  (RVVM1HF "TARGET_VECTOR_ELEN_FP_16") (RVVMF2HF "TARGET_VECTOR_ELEN_FP_16")
  (RVVMF4HF "TARGET_VECTOR_ELEN_FP_16 && TARGET_MIN_VLEN > 32")

  (RVVM8SF "TARGET_VECTOR_ELEN_FP_32") (RVVM4SF "TARGET_VECTOR_ELEN_FP_32") (RVVM2SF "TARGET_VECTOR_ELEN_FP_32")
  (RVVM1SF "TARGET_VECTOR_ELEN_FP_32") (RVVMF2SF "TARGET_VECTOR_ELEN_FP_32 && TARGET_MIN_VLEN > 32")

  (RVVM8DF "TARGET_VECTOR_ELEN_FP_64") (RVVM4DF "TARGET_VECTOR_ELEN_FP_64")
  (RVVM2DF "TARGET_VECTOR_ELEN_FP_64") (RVVM1DF "TARGET_VECTOR_ELEN_FP_64")

  (V1HF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_16")
  (V2HF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_16")
  (V4HF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_16")
  (V8HF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_16")
  (V16HF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_16")
  (V32HF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_16 && TARGET_MIN_VLEN >= 64")
  (V64HF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_16 && TARGET_MIN_VLEN >= 128")
  (V128HF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_16 && TARGET_MIN_VLEN >= 256")
  (V256HF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_16 && TARGET_MIN_VLEN >= 512")
  (V512HF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_16 && TARGET_MIN_VLEN >= 1024")
  (V1024HF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_16 && TARGET_MIN_VLEN >= 2048")
  (V2048HF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_16 && TARGET_MIN_VLEN >= 4096")
  (V1SF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_32")
  (V2SF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_32")
  (V4SF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_32")
  (V8SF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_32")
  (V16SF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_32 && TARGET_MIN_VLEN >= 64")
  (V32SF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_32 && TARGET_MIN_VLEN >= 128")
  (V64SF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_32 && TARGET_MIN_VLEN >= 256")
  (V128SF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_32 && TARGET_MIN_VLEN >= 512")
  (V256SF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_32 && TARGET_MIN_VLEN >= 1024")
  (V512SF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_32 && TARGET_MIN_VLEN >= 2048")
  (V1024SF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_32 && TARGET_MIN_VLEN >= 4096")
  (V1DF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_64")
  (V2DF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_64")
  (V4DF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_64")
  (V8DF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_64 && TARGET_MIN_VLEN >= 64")
  (V16DF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_64 && TARGET_MIN_VLEN >= 128")
  (V32DF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_64 && TARGET_MIN_VLEN >= 256")
  (V64DF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_64 && TARGET_MIN_VLEN >= 512")
  (V128DF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_64 && TARGET_MIN_VLEN >= 1024")
  (V256DF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_64 && TARGET_MIN_VLEN >= 2048")
  (V512DF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_64 && TARGET_MIN_VLEN >= 4096")
])

;; This iterator is the same as above but with TARGET_VECTOR_ELEN_FP_16
;; changed to TARGET_ZVFH.  TARGET_VECTOR_ELEN_FP_16 is also true for
;; TARGET_ZVFHMIN while we actually want to disable all instructions apart
;; from load, store and convert for it.
;; It is not enough to set the "enabled" attribute to false
;; since this will only disable insn alternatives in reload but still
;; allow the instruction and mode to be matched during combine et al.
(define_mode_iterator VF [
  (RVVM8HF "TARGET_ZVFH") (RVVM4HF "TARGET_ZVFH") (RVVM2HF "TARGET_ZVFH")
  (RVVM1HF "TARGET_ZVFH") (RVVMF2HF "TARGET_ZVFH")
  (RVVMF4HF "TARGET_ZVFH && TARGET_MIN_VLEN > 32")

  (RVVM8SF "TARGET_VECTOR_ELEN_FP_32") (RVVM4SF "TARGET_VECTOR_ELEN_FP_32") (RVVM2SF "TARGET_VECTOR_ELEN_FP_32")
  (RVVM1SF "TARGET_VECTOR_ELEN_FP_32") (RVVMF2SF "TARGET_VECTOR_ELEN_FP_32 && TARGET_MIN_VLEN > 32")

  (RVVM8DF "TARGET_VECTOR_ELEN_FP_64") (RVVM4DF "TARGET_VECTOR_ELEN_FP_64")
  (RVVM2DF "TARGET_VECTOR_ELEN_FP_64") (RVVM1DF "TARGET_VECTOR_ELEN_FP_64")
])

(define_mode_iterator VFULLI [
  RVVM8QI RVVM4QI RVVM2QI RVVM1QI RVVMF2QI RVVMF4QI (RVVMF8QI "TARGET_MIN_VLEN > 32")

  RVVM8HI RVVM4HI RVVM2HI RVVM1HI RVVMF2HI (RVVMF4HI "TARGET_MIN_VLEN > 32")

  RVVM8SI RVVM4SI RVVM2SI RVVM1SI (RVVMF2SI "TARGET_MIN_VLEN > 32")

  (RVVM8DI "TARGET_FULL_V") (RVVM4DI "TARGET_FULL_V") (RVVM2DI "TARGET_FULL_V") (RVVM1DI "TARGET_FULL_V")
])

(define_mode_iterator VI_QH [
  RVVM8QI RVVM4QI RVVM2QI RVVM1QI RVVMF2QI RVVMF4QI (RVVMF8QI "TARGET_MIN_VLEN > 32")

  RVVM8HI RVVM4HI RVVM2HI RVVM1HI RVVMF2HI (RVVMF4HI "TARGET_MIN_VLEN > 32")
])

(define_mode_iterator VI_QHS [
  RVVM8QI RVVM4QI RVVM2QI RVVM1QI RVVMF2QI RVVMF4QI (RVVMF8QI "TARGET_MIN_VLEN > 32")

  RVVM8HI RVVM4HI RVVM2HI RVVM1HI RVVMF2HI (RVVMF4HI "TARGET_MIN_VLEN > 32")

  RVVM8SI RVVM4SI RVVM2SI RVVM1SI (RVVMF2SI "TARGET_MIN_VLEN > 32")
])

(define_mode_iterator V_VLSI_QHS [
  RVVM8QI RVVM4QI RVVM2QI RVVM1QI RVVMF2QI RVVMF4QI (RVVMF8QI "TARGET_MIN_VLEN > 32")

  RVVM8HI RVVM4HI RVVM2HI RVVM1HI RVVMF2HI (RVVMF4HI "TARGET_MIN_VLEN > 32")

  RVVM8SI RVVM4SI RVVM2SI RVVM1SI (RVVMF2SI "TARGET_MIN_VLEN > 32")

  (V1QI "TARGET_VECTOR_VLS")
  (V2QI "TARGET_VECTOR_VLS")
  (V4QI "TARGET_VECTOR_VLS")
  (V8QI "TARGET_VECTOR_VLS")
  (V16QI "TARGET_VECTOR_VLS")
  (V32QI "TARGET_VECTOR_VLS")
  (V64QI "TARGET_VECTOR_VLS && TARGET_MIN_VLEN >= 64")
  (V128QI "TARGET_VECTOR_VLS && TARGET_MIN_VLEN >= 128")
  (V256QI "TARGET_VECTOR_VLS && TARGET_MIN_VLEN >= 256")
  (V512QI "TARGET_VECTOR_VLS && TARGET_MIN_VLEN >= 512")
  (V1024QI "TARGET_VECTOR_VLS && TARGET_MIN_VLEN >= 1024")
  (V2048QI "TARGET_VECTOR_VLS && TARGET_MIN_VLEN >= 2048")
  (V4096QI "TARGET_VECTOR_VLS && TARGET_MIN_VLEN >= 4096")
  (V1HI "TARGET_VECTOR_VLS")
  (V2HI "TARGET_VECTOR_VLS")
  (V4HI "TARGET_VECTOR_VLS")
  (V8HI "TARGET_VECTOR_VLS")
  (V16HI "TARGET_VECTOR_VLS")
  (V32HI "TARGET_VECTOR_VLS && TARGET_MIN_VLEN >= 64")
  (V64HI "TARGET_VECTOR_VLS && TARGET_MIN_VLEN >= 128")
  (V128HI "TARGET_VECTOR_VLS && TARGET_MIN_VLEN >= 256")
  (V256HI "TARGET_VECTOR_VLS && TARGET_MIN_VLEN >= 512")
  (V512HI "TARGET_VECTOR_VLS && TARGET_MIN_VLEN >= 1024")
  (V1024HI "TARGET_VECTOR_VLS && TARGET_MIN_VLEN >= 2048")
  (V2048HI "TARGET_VECTOR_VLS && TARGET_MIN_VLEN >= 4096")
  (V1SI "TARGET_VECTOR_VLS")
  (V2SI "TARGET_VECTOR_VLS")
  (V4SI "TARGET_VECTOR_VLS")
  (V8SI "TARGET_VECTOR_VLS")
  (V16SI "TARGET_VECTOR_VLS && TARGET_MIN_VLEN >= 64")
  (V32SI "TARGET_VECTOR_VLS && TARGET_MIN_VLEN >= 128")
  (V64SI "TARGET_VECTOR_VLS && TARGET_MIN_VLEN >= 256")
  (V128SI "TARGET_VECTOR_VLS && TARGET_MIN_VLEN >= 512")
  (V256SI "TARGET_VECTOR_VLS && TARGET_MIN_VLEN >= 1024")
  (V512SI "TARGET_VECTOR_VLS && TARGET_MIN_VLEN >= 2048")
  (V1024SI "TARGET_VECTOR_VLS && TARGET_MIN_VLEN >= 4096")
])

(define_mode_iterator VI_D [
  (RVVM8DI "TARGET_VECTOR_ELEN_64") (RVVM4DI "TARGET_VECTOR_ELEN_64")
  (RVVM2DI "TARGET_VECTOR_ELEN_64") (RVVM1DI "TARGET_VECTOR_ELEN_64")
])

(define_mode_iterator V_VLSI_D [
  (RVVM8DI "TARGET_VECTOR_ELEN_64") (RVVM4DI "TARGET_VECTOR_ELEN_64")
  (RVVM2DI "TARGET_VECTOR_ELEN_64") (RVVM1DI "TARGET_VECTOR_ELEN_64")

  (V2DI "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_64")
  (V4DI "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_64")
  (V8DI "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_64 && TARGET_MIN_VLEN >= 64")
  (V16DI "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_64 && TARGET_MIN_VLEN >= 128")
  (V32DI "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_64 && TARGET_MIN_VLEN >= 256")
  (V64DI "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_64 && TARGET_MIN_VLEN >= 512")
  (V128DI "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_64 && TARGET_MIN_VLEN >= 1024")
  (V256DI "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_64 && TARGET_MIN_VLEN >= 2048")
  (V512DI "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_64 && TARGET_MIN_VLEN >= 4096")
])

(define_mode_iterator VFULLI_D [
  (RVVM8DI "TARGET_FULL_V") (RVVM4DI "TARGET_FULL_V")
  (RVVM2DI "TARGET_FULL_V") (RVVM1DI "TARGET_FULL_V")
])

(define_mode_iterator RATIO64 [
  (RVVMF8QI "TARGET_MIN_VLEN > 32")
  (RVVMF4HI "TARGET_MIN_VLEN > 32")
  (RVVMF2SI "TARGET_MIN_VLEN > 32")
  (RVVM1DI "TARGET_VECTOR_ELEN_64")
  (RVVMF4HF "TARGET_VECTOR_ELEN_FP_16 && TARGET_MIN_VLEN > 32")
  (RVVMF2SF "TARGET_VECTOR_ELEN_FP_32 && TARGET_MIN_VLEN > 32")
  (RVVM1DF "TARGET_VECTOR_ELEN_FP_64")
])

(define_mode_iterator RATIO32 [
  RVVMF4QI
  RVVMF2HI
  RVVM1SI
  (RVVM2DI "TARGET_VECTOR_ELEN_64")
  (RVVMF2HF "TARGET_VECTOR_ELEN_FP_16")
  (RVVM1SF "TARGET_VECTOR_ELEN_FP_32")
  (RVVM2DF "TARGET_VECTOR_ELEN_FP_64")
])

(define_mode_iterator RATIO16 [
  RVVMF2QI
  RVVM1HI
  RVVM2SI
  (RVVM4DI "TARGET_VECTOR_ELEN_64")
  (RVVM1HF "TARGET_VECTOR_ELEN_FP_16")
  (RVVM2SF "TARGET_VECTOR_ELEN_FP_32")
  (RVVM4DF "TARGET_VECTOR_ELEN_FP_64")
])

(define_mode_iterator RATIO8 [
  RVVM1QI
  RVVM2HI
  RVVM4SI
  (RVVM8DI "TARGET_VECTOR_ELEN_64")
  (RVVM2HF "TARGET_VECTOR_ELEN_FP_16")
  (RVVM4SF "TARGET_VECTOR_ELEN_FP_32")
  (RVVM8DF "TARGET_VECTOR_ELEN_FP_64")
])

(define_mode_iterator RATIO4 [
  RVVM2QI
  RVVM4HI
  RVVM8SI
  (RVVM4HF "TARGET_VECTOR_ELEN_FP_16")
  (RVVM8SF "TARGET_VECTOR_ELEN_FP_32")
])

(define_mode_iterator RATIO2 [
  RVVM4QI
  RVVM8HI
  (RVVM8HF "TARGET_VECTOR_ELEN_FP_16")
])

(define_mode_iterator RATIO1 [
  RVVM8QI
])

(define_mode_iterator RATIO64I [
  (RVVMF8QI "TARGET_MIN_VLEN > 32")
  (RVVMF4HI "TARGET_MIN_VLEN > 32")
  (RVVMF2SI "TARGET_MIN_VLEN > 32")
  (RVVM1DI "TARGET_VECTOR_ELEN_64")
])

(define_mode_iterator RATIO32I [
  RVVMF4QI
  RVVMF2HI
  RVVM1SI
  (RVVM2DI "TARGET_VECTOR_ELEN_64")
])

(define_mode_iterator RATIO16I [
  RVVMF2QI
  RVVM1HI
  RVVM2SI
  (RVVM4DI "TARGET_VECTOR_ELEN_64")
])

(define_mode_iterator RATIO8I [
  RVVM1QI
  RVVM2HI
  RVVM4SI
  (RVVM8DI "TARGET_VECTOR_ELEN_64")
])

(define_mode_iterator RATIO4I [
  RVVM2QI
  RVVM4HI
  RVVM8SI
])

(define_mode_iterator RATIO2I [
  RVVM4QI
  RVVM8HI
])

(define_mode_iterator V_WHOLE [
  RVVM8QI RVVM4QI RVVM2QI RVVM1QI

  RVVM8HI RVVM4HI RVVM2HI RVVM1HI

  (RVVM8HF "TARGET_VECTOR_ELEN_FP_16") (RVVM4HF "TARGET_VECTOR_ELEN_FP_16")
  (RVVM2HF "TARGET_VECTOR_ELEN_FP_16") (RVVM1HF "TARGET_VECTOR_ELEN_FP_16")

  RVVM8SI RVVM4SI RVVM2SI RVVM1SI

  (RVVM8SF "TARGET_VECTOR_ELEN_FP_32") (RVVM4SF "TARGET_VECTOR_ELEN_FP_32")
  (RVVM2SF "TARGET_VECTOR_ELEN_FP_32") (RVVM1SF "TARGET_VECTOR_ELEN_FP_32")

  (RVVM8DI "TARGET_VECTOR_ELEN_64") (RVVM4DI "TARGET_VECTOR_ELEN_64")
  (RVVM2DI "TARGET_VECTOR_ELEN_64") (RVVM1DI "TARGET_VECTOR_ELEN_64")

  (RVVM8DF "TARGET_VECTOR_ELEN_FP_64") (RVVM4DF "TARGET_VECTOR_ELEN_FP_64")
  (RVVM2DF "TARGET_VECTOR_ELEN_FP_64") (RVVM1DF "TARGET_VECTOR_ELEN_FP_64")
])

(define_mode_iterator V_FRACT [
  RVVMF2QI RVVMF4QI (RVVMF8QI "TARGET_MIN_VLEN > 32")

  RVVMF2HI (RVVMF4HI "TARGET_MIN_VLEN > 32")

  (RVVMF2HF "TARGET_VECTOR_ELEN_FP_16") (RVVMF4HF "TARGET_VECTOR_ELEN_FP_16 && TARGET_MIN_VLEN > 32")

  (RVVMF2SI "TARGET_MIN_VLEN > 32")

  (RVVMF2SF "TARGET_VECTOR_ELEN_FP_32 && TARGET_MIN_VLEN > 32")
])

(define_mode_iterator VB [
  (RVVMF64BI "TARGET_MIN_VLEN > 32") RVVMF32BI RVVMF16BI RVVMF8BI RVVMF4BI RVVMF2BI RVVM1BI
])

(define_mode_iterator VWEXTI [
  RVVM8HI RVVM4HI RVVM2HI RVVM1HI RVVMF2HI (RVVMF4HI "TARGET_MIN_VLEN > 32")

  RVVM8SI RVVM4SI RVVM2SI RVVM1SI (RVVMF2SI "TARGET_MIN_VLEN > 32")

  (RVVM8DI "TARGET_VECTOR_ELEN_64") (RVVM4DI "TARGET_VECTOR_ELEN_64")
  (RVVM2DI "TARGET_VECTOR_ELEN_64") (RVVM1DI "TARGET_VECTOR_ELEN_64")
])

;; Same iterator split reason as VF_ZVFHMIN and VF.
(define_mode_iterator VWEXTF_ZVFHMIN [
  (RVVM8SF "TARGET_VECTOR_ELEN_FP_16 && TARGET_VECTOR_ELEN_FP_32")
  (RVVM4SF "TARGET_VECTOR_ELEN_FP_16 && TARGET_VECTOR_ELEN_FP_32")
  (RVVM2SF "TARGET_VECTOR_ELEN_FP_16 && TARGET_VECTOR_ELEN_FP_32")
  (RVVM1SF "TARGET_VECTOR_ELEN_FP_16 && TARGET_VECTOR_ELEN_FP_32")
  (RVVMF2SF "TARGET_VECTOR_ELEN_FP_16 && TARGET_VECTOR_ELEN_FP_32 && TARGET_MIN_VLEN > 32")

  (RVVM8DF "TARGET_VECTOR_ELEN_FP_64") (RVVM4DF "TARGET_VECTOR_ELEN_FP_64")
  (RVVM2DF "TARGET_VECTOR_ELEN_FP_64") (RVVM1DF "TARGET_VECTOR_ELEN_FP_64")
])

(define_mode_iterator VWEXTF [
  (RVVM8SF "TARGET_ZVFH && TARGET_VECTOR_ELEN_FP_32")
  (RVVM4SF "TARGET_ZVFH && TARGET_VECTOR_ELEN_FP_32")
  (RVVM2SF "TARGET_ZVFH && TARGET_VECTOR_ELEN_FP_32")
  (RVVM1SF "TARGET_ZVFH && TARGET_VECTOR_ELEN_FP_32")
  (RVVMF2SF "TARGET_ZVFH && TARGET_VECTOR_ELEN_FP_32 && TARGET_MIN_VLEN > 32")

  (RVVM8DF "TARGET_VECTOR_ELEN_FP_64") (RVVM4DF "TARGET_VECTOR_ELEN_FP_64")
  (RVVM2DF "TARGET_VECTOR_ELEN_FP_64") (RVVM1DF "TARGET_VECTOR_ELEN_FP_64")
])

(define_mode_iterator VWCONVERTI [
  (RVVM8SI "TARGET_ZVFH") (RVVM4SI "TARGET_ZVFH") (RVVM2SI "TARGET_ZVFH") (RVVM1SI "TARGET_ZVFH")
  (RVVMF2SI "TARGET_ZVFH")

  (RVVM8DI "TARGET_VECTOR_ELEN_64 && TARGET_VECTOR_ELEN_FP_32")
  (RVVM4DI "TARGET_VECTOR_ELEN_64 && TARGET_VECTOR_ELEN_FP_32")
  (RVVM2DI "TARGET_VECTOR_ELEN_64 && TARGET_VECTOR_ELEN_FP_32")
  (RVVM1DI "TARGET_VECTOR_ELEN_64 && TARGET_VECTOR_ELEN_FP_32")
])

(define_mode_iterator VQEXTI [
  RVVM8SI RVVM4SI RVVM2SI RVVM1SI (RVVMF2SI "TARGET_MIN_VLEN > 32")

  (RVVM8DI "TARGET_VECTOR_ELEN_64") (RVVM4DI "TARGET_VECTOR_ELEN_64")
  (RVVM2DI "TARGET_VECTOR_ELEN_64") (RVVM1DI "TARGET_VECTOR_ELEN_64")
])

(define_mode_iterator VQEXTF [
  (RVVM8DF "TARGET_VECTOR_ELEN_FP_64") (RVVM4DF "TARGET_VECTOR_ELEN_FP_64")
  (RVVM2DF "TARGET_VECTOR_ELEN_FP_64") (RVVM1DF "TARGET_VECTOR_ELEN_FP_64")
])

(define_mode_iterator VOEXTI [
  (RVVM8DI "TARGET_VECTOR_ELEN_64") (RVVM4DI "TARGET_VECTOR_ELEN_64")
  (RVVM2DI "TARGET_VECTOR_ELEN_64") (RVVM1DI "TARGET_VECTOR_ELEN_64")
])

(define_mode_iterator VT [
  RVVM1x8QI RVVMF2x8QI RVVMF4x8QI (RVVMF8x8QI "TARGET_MIN_VLEN > 32")
  RVVM1x7QI RVVMF2x7QI RVVMF4x7QI (RVVMF8x7QI "TARGET_MIN_VLEN > 32")
  RVVM1x6QI RVVMF2x6QI RVVMF4x6QI (RVVMF8x6QI "TARGET_MIN_VLEN > 32")
  RVVM1x5QI RVVMF2x5QI RVVMF4x5QI (RVVMF8x5QI "TARGET_MIN_VLEN > 32")
  RVVM2x4QI RVVM1x4QI RVVMF2x4QI RVVMF4x4QI (RVVMF8x4QI "TARGET_MIN_VLEN > 32")
  RVVM2x3QI RVVM1x3QI RVVMF2x3QI RVVMF4x3QI (RVVMF8x3QI "TARGET_MIN_VLEN > 32")
  RVVM4x2QI RVVM2x2QI RVVM1x2QI RVVMF2x2QI RVVMF4x2QI (RVVMF8x2QI "TARGET_MIN_VLEN > 32")

  RVVM1x8HI RVVMF2x8HI (RVVMF4x8HI "TARGET_MIN_VLEN > 32")
  RVVM1x7HI RVVMF2x7HI (RVVMF4x7HI "TARGET_MIN_VLEN > 32")
  RVVM1x6HI RVVMF2x6HI (RVVMF4x6HI "TARGET_MIN_VLEN > 32")
  RVVM1x5HI RVVMF2x5HI (RVVMF4x5HI "TARGET_MIN_VLEN > 32")
  RVVM2x4HI RVVM1x4HI RVVMF2x4HI (RVVMF4x4HI "TARGET_MIN_VLEN > 32")
  RVVM2x3HI RVVM1x3HI RVVMF2x3HI (RVVMF4x3HI "TARGET_MIN_VLEN > 32")
  RVVM4x2HI RVVM2x2HI RVVM1x2HI RVVMF2x2HI (RVVMF4x2HI "TARGET_MIN_VLEN > 32")

  (RVVM1x8HF "TARGET_VECTOR_ELEN_FP_16")
  (RVVMF2x8HF "TARGET_VECTOR_ELEN_FP_16")
  (RVVMF4x8HF "TARGET_VECTOR_ELEN_FP_16 && TARGET_MIN_VLEN > 32")
  (RVVM1x7HF "TARGET_VECTOR_ELEN_FP_16")
  (RVVMF2x7HF "TARGET_VECTOR_ELEN_FP_16")
  (RVVMF4x7HF "TARGET_VECTOR_ELEN_FP_16 && TARGET_MIN_VLEN > 32")
  (RVVM1x6HF "TARGET_VECTOR_ELEN_FP_16")
  (RVVMF2x6HF "TARGET_VECTOR_ELEN_FP_16")
  (RVVMF4x6HF "TARGET_VECTOR_ELEN_FP_16 && TARGET_MIN_VLEN > 32")
  (RVVM1x5HF "TARGET_VECTOR_ELEN_FP_16")
  (RVVMF2x5HF "TARGET_VECTOR_ELEN_FP_16")
  (RVVMF4x5HF "TARGET_VECTOR_ELEN_FP_16 && TARGET_MIN_VLEN > 32")
  (RVVM2x4HF "TARGET_VECTOR_ELEN_FP_16")
  (RVVM1x4HF "TARGET_VECTOR_ELEN_FP_16")
  (RVVMF2x4HF "TARGET_VECTOR_ELEN_FP_16")
  (RVVMF4x4HF "TARGET_VECTOR_ELEN_FP_16 && TARGET_MIN_VLEN > 32")
  (RVVM2x3HF "TARGET_VECTOR_ELEN_FP_16")
  (RVVM1x3HF "TARGET_VECTOR_ELEN_FP_16")
  (RVVMF2x3HF "TARGET_VECTOR_ELEN_FP_16")
  (RVVMF4x3HF "TARGET_VECTOR_ELEN_FP_16 && TARGET_MIN_VLEN > 32")
  (RVVM4x2HF "TARGET_VECTOR_ELEN_FP_16")
  (RVVM2x2HF "TARGET_VECTOR_ELEN_FP_16")
  (RVVM1x2HF "TARGET_VECTOR_ELEN_FP_16")
  (RVVMF2x2HF "TARGET_VECTOR_ELEN_FP_16")
  (RVVMF4x2HF "TARGET_VECTOR_ELEN_FP_16 && TARGET_MIN_VLEN > 32")

  RVVM1x8SI (RVVMF2x8SI "TARGET_MIN_VLEN > 32")
  RVVM1x7SI (RVVMF2x7SI "TARGET_MIN_VLEN > 32")
  RVVM1x6SI (RVVMF2x6SI "TARGET_MIN_VLEN > 32")
  RVVM1x5SI (RVVMF2x5SI "TARGET_MIN_VLEN > 32")
  RVVM2x4SI RVVM1x4SI (RVVMF2x4SI "TARGET_MIN_VLEN > 32")
  RVVM2x3SI RVVM1x3SI (RVVMF2x3SI "TARGET_MIN_VLEN > 32")
  RVVM4x2SI RVVM2x2SI RVVM1x2SI (RVVMF2x2SI "TARGET_MIN_VLEN > 32")

  (RVVM1x8SF "TARGET_VECTOR_ELEN_FP_32")
  (RVVMF2x8SF "TARGET_VECTOR_ELEN_FP_32 && TARGET_MIN_VLEN > 32")
  (RVVM1x7SF "TARGET_VECTOR_ELEN_FP_32")
  (RVVMF2x7SF "TARGET_VECTOR_ELEN_FP_32 && TARGET_MIN_VLEN > 32")
  (RVVM1x6SF "TARGET_VECTOR_ELEN_FP_32")
  (RVVMF2x6SF "TARGET_VECTOR_ELEN_FP_32 && TARGET_MIN_VLEN > 32")
  (RVVM1x5SF "TARGET_VECTOR_ELEN_FP_32")
  (RVVMF2x5SF "TARGET_VECTOR_ELEN_FP_32 && TARGET_MIN_VLEN > 32")
  (RVVM2x4SF "TARGET_VECTOR_ELEN_FP_32")
  (RVVM1x4SF "TARGET_VECTOR_ELEN_FP_32")
  (RVVMF2x4SF "TARGET_VECTOR_ELEN_FP_32 && TARGET_MIN_VLEN > 32")
  (RVVM2x3SF "TARGET_VECTOR_ELEN_FP_32")
  (RVVM1x3SF "TARGET_VECTOR_ELEN_FP_32")
  (RVVMF2x3SF "TARGET_VECTOR_ELEN_FP_32 && TARGET_MIN_VLEN > 32")
  (RVVM4x2SF "TARGET_VECTOR_ELEN_FP_32")
  (RVVM2x2SF "TARGET_VECTOR_ELEN_FP_32")
  (RVVM1x2SF "TARGET_VECTOR_ELEN_FP_32")
  (RVVMF2x2SF "TARGET_VECTOR_ELEN_FP_32 && TARGET_MIN_VLEN > 32")

  (RVVM1x8DI "TARGET_VECTOR_ELEN_64")
  (RVVM1x7DI "TARGET_VECTOR_ELEN_64")
  (RVVM1x6DI "TARGET_VECTOR_ELEN_64")
  (RVVM1x5DI "TARGET_VECTOR_ELEN_64")
  (RVVM2x4DI "TARGET_VECTOR_ELEN_64")
  (RVVM1x4DI "TARGET_VECTOR_ELEN_64")
  (RVVM2x3DI "TARGET_VECTOR_ELEN_64")
  (RVVM1x3DI "TARGET_VECTOR_ELEN_64")
  (RVVM4x2DI "TARGET_VECTOR_ELEN_64")
  (RVVM2x2DI "TARGET_VECTOR_ELEN_64")
  (RVVM1x2DI "TARGET_VECTOR_ELEN_64")

  (RVVM1x8DF "TARGET_VECTOR_ELEN_FP_64")
  (RVVM1x7DF "TARGET_VECTOR_ELEN_FP_64")
  (RVVM1x6DF "TARGET_VECTOR_ELEN_FP_64")
  (RVVM1x5DF "TARGET_VECTOR_ELEN_FP_64")
  (RVVM2x4DF "TARGET_VECTOR_ELEN_FP_64")
  (RVVM1x4DF "TARGET_VECTOR_ELEN_FP_64")
  (RVVM2x3DF "TARGET_VECTOR_ELEN_FP_64")
  (RVVM1x3DF "TARGET_VECTOR_ELEN_FP_64")
  (RVVM4x2DF "TARGET_VECTOR_ELEN_FP_64")
  (RVVM2x2DF "TARGET_VECTOR_ELEN_FP_64")
  (RVVM1x2DF "TARGET_VECTOR_ELEN_FP_64")
])

(define_mode_iterator V1T [
  (RVVMF8x2QI "TARGET_MIN_VLEN > 32")
  (RVVMF8x3QI "TARGET_MIN_VLEN > 32")
  (RVVMF8x4QI "TARGET_MIN_VLEN > 32")
  (RVVMF8x5QI "TARGET_MIN_VLEN > 32")
  (RVVMF8x6QI "TARGET_MIN_VLEN > 32")
  (RVVMF8x7QI "TARGET_MIN_VLEN > 32")
  (RVVMF8x8QI "TARGET_MIN_VLEN > 32")
  (RVVMF4x2HI "TARGET_MIN_VLEN > 32")
  (RVVMF4x3HI "TARGET_MIN_VLEN > 32")
  (RVVMF4x4HI "TARGET_MIN_VLEN > 32")
  (RVVMF4x5HI "TARGET_MIN_VLEN > 32")
  (RVVMF4x6HI "TARGET_MIN_VLEN > 32")
  (RVVMF4x7HI "TARGET_MIN_VLEN > 32")
  (RVVMF4x8HI "TARGET_MIN_VLEN > 32")
  (RVVMF2x2SI "TARGET_MIN_VLEN > 32")
  (RVVMF2x3SI "TARGET_MIN_VLEN > 32")
  (RVVMF2x4SI "TARGET_MIN_VLEN > 32")
  (RVVMF2x5SI "TARGET_MIN_VLEN > 32")
  (RVVMF2x6SI "TARGET_MIN_VLEN > 32")
  (RVVMF2x7SI "TARGET_MIN_VLEN > 32")
  (RVVMF2x8SI "TARGET_MIN_VLEN > 32")
  (RVVM1x2DI "TARGET_VECTOR_ELEN_64")
  (RVVM1x3DI "TARGET_VECTOR_ELEN_64")
  (RVVM1x4DI "TARGET_VECTOR_ELEN_64")
  (RVVM1x5DI "TARGET_VECTOR_ELEN_64")
  (RVVM1x6DI "TARGET_VECTOR_ELEN_64")
  (RVVM1x7DI "TARGET_VECTOR_ELEN_64")
  (RVVM1x8DI "TARGET_VECTOR_ELEN_64")
  (RVVMF4x2HF "TARGET_MIN_VLEN > 32 && TARGET_VECTOR_ELEN_FP_16")
  (RVVMF4x3HF "TARGET_MIN_VLEN > 32 && TARGET_VECTOR_ELEN_FP_16")
  (RVVMF4x4HF "TARGET_MIN_VLEN > 32 && TARGET_VECTOR_ELEN_FP_16")
  (RVVMF4x5HF "TARGET_MIN_VLEN > 32 && TARGET_VECTOR_ELEN_FP_16")
  (RVVMF4x6HF "TARGET_MIN_VLEN > 32 && TARGET_VECTOR_ELEN_FP_16")
  (RVVMF4x7HF "TARGET_MIN_VLEN > 32 && TARGET_VECTOR_ELEN_FP_16")
  (RVVMF4x8HF "TARGET_MIN_VLEN > 32 && TARGET_VECTOR_ELEN_FP_16")
  (RVVMF2x2SF "TARGET_MIN_VLEN > 32 && TARGET_VECTOR_ELEN_FP_32")
  (RVVMF2x3SF "TARGET_MIN_VLEN > 32 && TARGET_VECTOR_ELEN_FP_32")
  (RVVMF2x4SF "TARGET_MIN_VLEN > 32 && TARGET_VECTOR_ELEN_FP_32")
  (RVVMF2x5SF "TARGET_MIN_VLEN > 32 && TARGET_VECTOR_ELEN_FP_32")
  (RVVMF2x6SF "TARGET_MIN_VLEN > 32 && TARGET_VECTOR_ELEN_FP_32")
  (RVVMF2x7SF "TARGET_MIN_VLEN > 32 && TARGET_VECTOR_ELEN_FP_32")
  (RVVMF2x8SF "TARGET_MIN_VLEN > 32 && TARGET_VECTOR_ELEN_FP_32")
  (RVVM1x2DF "TARGET_VECTOR_ELEN_FP_64")
  (RVVM1x3DF "TARGET_VECTOR_ELEN_FP_64")
  (RVVM1x4DF "TARGET_VECTOR_ELEN_FP_64")
  (RVVM1x5DF "TARGET_VECTOR_ELEN_FP_64")
  (RVVM1x6DF "TARGET_VECTOR_ELEN_FP_64")
  (RVVM1x7DF "TARGET_VECTOR_ELEN_FP_64")
  (RVVM1x8DF "TARGET_VECTOR_ELEN_FP_64")
])

(define_mode_iterator V2T [
  RVVMF4x2QI
  RVVMF4x3QI
  RVVMF4x4QI
  RVVMF4x5QI
  RVVMF4x6QI
  RVVMF4x7QI
  RVVMF4x8QI
  RVVMF2x2HI
  RVVMF2x3HI
  RVVMF2x4HI
  RVVMF2x5HI
  RVVMF2x6HI
  RVVMF2x7HI
  RVVMF2x8HI
  RVVM1x2SI
  RVVM1x3SI
  RVVM1x4SI
  RVVM1x5SI
  RVVM1x6SI
  RVVM1x7SI
  RVVM1x8SI
  (RVVM2x2DI "TARGET_VECTOR_ELEN_64")
  (RVVM2x3DI "TARGET_VECTOR_ELEN_64")
  (RVVM2x4DI "TARGET_VECTOR_ELEN_64")
  (RVVMF2x2HF "TARGET_VECTOR_ELEN_FP_16")
  (RVVMF2x3HF "TARGET_VECTOR_ELEN_FP_16")
  (RVVMF2x4HF "TARGET_VECTOR_ELEN_FP_16")
  (RVVMF2x5HF "TARGET_VECTOR_ELEN_FP_16")
  (RVVMF2x6HF "TARGET_VECTOR_ELEN_FP_16")
  (RVVMF2x7HF "TARGET_VECTOR_ELEN_FP_16")
  (RVVMF2x8HF "TARGET_VECTOR_ELEN_FP_16")
  (RVVM1x2SF "TARGET_VECTOR_ELEN_FP_32")
  (RVVM1x3SF "TARGET_VECTOR_ELEN_FP_32")
  (RVVM1x4SF "TARGET_VECTOR_ELEN_FP_32")
  (RVVM1x5SF "TARGET_VECTOR_ELEN_FP_32")
  (RVVM1x6SF "TARGET_VECTOR_ELEN_FP_32")
  (RVVM1x7SF "TARGET_VECTOR_ELEN_FP_32")
  (RVVM1x8SF "TARGET_VECTOR_ELEN_FP_32")
  (RVVM2x2DF "TARGET_VECTOR_ELEN_FP_64")
  (RVVM2x3DF "TARGET_VECTOR_ELEN_FP_64")
  (RVVM2x4DF "TARGET_VECTOR_ELEN_FP_64")
])

(define_mode_iterator V4T [
  RVVMF2x2QI
  RVVMF2x3QI
  RVVMF2x4QI
  RVVMF2x5QI
  RVVMF2x6QI
  RVVMF2x7QI
  RVVMF2x8QI
  RVVM1x2HI
  RVVM1x3HI
  RVVM1x4HI
  RVVM1x5HI
  RVVM1x6HI
  RVVM1x7HI
  RVVM1x8HI
  RVVM2x2SI
  RVVM2x3SI
  RVVM2x4SI
  (RVVM4x2DI "TARGET_VECTOR_ELEN_64")
  (RVVM1x2HF "TARGET_VECTOR_ELEN_FP_16")
  (RVVM1x3HF "TARGET_VECTOR_ELEN_FP_16")
  (RVVM1x4HF "TARGET_VECTOR_ELEN_FP_16")
  (RVVM1x5HF "TARGET_VECTOR_ELEN_FP_16")
  (RVVM1x6HF "TARGET_VECTOR_ELEN_FP_16")
  (RVVM1x7HF "TARGET_VECTOR_ELEN_FP_16")
  (RVVM1x8HF "TARGET_VECTOR_ELEN_FP_16")
  (RVVM2x2SF "TARGET_VECTOR_ELEN_FP_32")
  (RVVM2x3SF "TARGET_VECTOR_ELEN_FP_32")
  (RVVM2x4SF "TARGET_VECTOR_ELEN_FP_32")
  (RVVM4x2DF "TARGET_VECTOR_ELEN_FP_64")
])

(define_mode_iterator V8T [
  RVVM1x2QI
  RVVM1x3QI
  RVVM1x4QI
  RVVM1x5QI
  RVVM1x6QI
  RVVM1x7QI
  RVVM1x8QI
  RVVM2x2HI
  RVVM2x3HI
  RVVM2x4HI
  RVVM4x2SI
  (RVVM2x2HF "TARGET_VECTOR_ELEN_FP_16")
  (RVVM2x3HF "TARGET_VECTOR_ELEN_FP_16")
  (RVVM2x4HF "TARGET_VECTOR_ELEN_FP_16")
  (RVVM4x2SF "TARGET_VECTOR_ELEN_FP_32")
])

(define_mode_iterator V16T [
  RVVM2x2QI
  RVVM2x3QI
  RVVM2x4QI
  RVVM4x2HI
  (RVVM4x2HF "TARGET_VECTOR_ELEN_FP_16")
])

(define_mode_iterator V32T [
  RVVM4x2QI
])

(define_mode_iterator VQI [
  RVVM8QI RVVM4QI RVVM2QI RVVM1QI RVVMF2QI RVVMF4QI (RVVMF8QI "TARGET_MIN_VLEN > 32")
])

(define_mode_iterator VHI [
  RVVM8HI RVVM4HI RVVM2HI RVVM1HI RVVMF2HI (RVVMF4HI "TARGET_MIN_VLEN > 32")
])

(define_mode_iterator VSI [
  RVVM8SI RVVM4SI RVVM2SI RVVM1SI (RVVMF2SI "TARGET_MIN_VLEN > 32")
])

(define_mode_iterator VDI [
  (RVVM8DI "TARGET_VECTOR_ELEN_64") (RVVM4DI "TARGET_VECTOR_ELEN_64")
  (RVVM2DI "TARGET_VECTOR_ELEN_64") (RVVM1DI "TARGET_VECTOR_ELEN_64")
])

(define_mode_iterator VHF [
  (RVVM8HF "TARGET_ZVFH") (RVVM4HF "TARGET_ZVFH") (RVVM2HF "TARGET_ZVFH")
  (RVVM1HF "TARGET_ZVFH") (RVVMF2HF "TARGET_ZVFH")
  (RVVMF4HF "TARGET_ZVFH && TARGET_MIN_VLEN > 32")
])

(define_mode_iterator VSF [
  (RVVM8SF "TARGET_VECTOR_ELEN_FP_32") (RVVM4SF "TARGET_VECTOR_ELEN_FP_32") (RVVM2SF "TARGET_VECTOR_ELEN_FP_32")
  (RVVM1SF "TARGET_VECTOR_ELEN_FP_32") (RVVMF2SF "TARGET_VECTOR_ELEN_FP_32 && TARGET_MIN_VLEN > 32")
])

(define_mode_iterator VDF [
  (RVVM8DF "TARGET_VECTOR_ELEN_FP_64") (RVVM4DF "TARGET_VECTOR_ELEN_FP_64")
  (RVVM2DF "TARGET_VECTOR_ELEN_FP_64") (RVVM1DF "TARGET_VECTOR_ELEN_FP_64")
])

(define_mode_iterator VQI_LMUL1 [
  RVVM1QI
])

(define_mode_iterator VHI_LMUL1 [
  RVVM1HI
])

(define_mode_iterator VSI_LMUL1 [
  RVVM1SI
])

(define_mode_iterator VDI_LMUL1 [
  (RVVM1DI "TARGET_VECTOR_ELEN_64")
])

(define_mode_iterator VHF_LMUL1 [
  (RVVM1HF "TARGET_ZVFH")
])

(define_mode_iterator VSF_LMUL1 [
  (RVVM1SF "TARGET_VECTOR_ELEN_FP_32")
])

(define_mode_iterator VDF_LMUL1 [
  (RVVM1DF "TARGET_VECTOR_ELEN_FP_64")
])

(define_mode_attr VINDEX [
  (RVVM8QI "RVVM8QI") (RVVM4QI "RVVM4QI") (RVVM2QI "RVVM2QI") (RVVM1QI "RVVM1QI")
  (RVVMF2QI "RVVMF2QI") (RVVMF4QI "RVVMF4QI") (RVVMF8QI "RVVMF8QI")

  (RVVM8HI "RVVM8HI") (RVVM4HI "RVVM4HI") (RVVM2HI "RVVM2HI") (RVVM1HI "RVVM1HI") (RVVMF2HI "RVVMF2HI") (RVVMF4HI "RVVMF4HI")

  (RVVM8HF "RVVM8HI") (RVVM4HF "RVVM4HI") (RVVM2HF "RVVM2HI") (RVVM1HF "RVVM1HI") (RVVMF2HF "RVVMF2HI") (RVVMF4HF "RVVMF4HI")

  (RVVM8SI "RVVM8SI") (RVVM4SI "RVVM4SI") (RVVM2SI "RVVM2SI") (RVVM1SI "RVVM1SI") (RVVMF2SI "RVVMF2SI")

  (RVVM8SF "RVVM8SI") (RVVM4SF "RVVM4SI") (RVVM2SF "RVVM2SI") (RVVM1SF "RVVM1SI") (RVVMF2SF "RVVMF2SI")

  (RVVM8DI "RVVM8DI") (RVVM4DI "RVVM4DI") (RVVM2DI "RVVM2DI") (RVVM1DI "RVVM1DI")

  (RVVM8DF "RVVM8DI") (RVVM4DF "RVVM4DI") (RVVM2DF "RVVM2DI") (RVVM1DF "RVVM1DI")
])

(define_mode_attr VINDEXEI16 [
  (RVVM4QI "RVVM8HI") (RVVM2QI "RVVM4HI") (RVVM1QI "RVVM2HI") (RVVMF2QI "RVVM1HI") (RVVMF4QI "RVVMF2HI") (RVVMF8QI "RVVMF4HI")

  (RVVM8HI "RVVM8HI") (RVVM4HI "RVVM4HI") (RVVM2HI "RVVM2HI") (RVVM1HI "RVVM1HI") (RVVMF2HI "RVVMF2HI") (RVVMF4HI "RVVMF4HI")

  (RVVM8SI "RVVM4HI") (RVVM4SI "RVVM2HI") (RVVM2SI "RVVM1HI") (RVVM1SI "RVVMF2HI") (RVVMF2SI "RVVMF4HI")

  (RVVM8DI "RVVM2HI") (RVVM4DI "RVVM1HI") (RVVM2DI "RVVMF2HI") (RVVM1DI "RVVMF4HI")

  (RVVM8HF "RVVM8HI") (RVVM4HF "RVVM4HI") (RVVM2HF "RVVM2HI") (RVVM1HF "RVVM1HI") (RVVMF2HF "RVVMF2HI") (RVVMF4HF "RVVMF4HI")

  (RVVM8SF "RVVM4HI") (RVVM4SF "RVVM2HI") (RVVM2SF "RVVM1HI") (RVVM1SF "RVVMF2HI") (RVVMF2SF "RVVMF4HI")

  (RVVM8DF "RVVM2HI") (RVVM4DF "RVVM1HI") (RVVM2DF "RVVMF2HI") (RVVM1DF "RVVMF4HI")
])

(define_mode_attr VM [
  (RVVM8QI "RVVM1BI") (RVVM4QI "RVVMF2BI") (RVVM2QI "RVVMF4BI") (RVVM1QI "RVVMF8BI") (RVVMF2QI "RVVMF16BI") (RVVMF4QI "RVVMF32BI") (RVVMF8QI "RVVMF64BI")

  (RVVM8HI "RVVMF2BI") (RVVM4HI "RVVMF4BI") (RVVM2HI "RVVMF8BI") (RVVM1HI "RVVMF16BI") (RVVMF2HI "RVVMF32BI") (RVVMF4HI "RVVMF64BI")

  (RVVM8HF "RVVMF2BI") (RVVM4HF "RVVMF4BI") (RVVM2HF "RVVMF8BI") (RVVM1HF "RVVMF16BI") (RVVMF2HF "RVVMF32BI") (RVVMF4HF "RVVMF64BI")

  (RVVM8SI "RVVMF4BI") (RVVM4SI "RVVMF8BI") (RVVM2SI "RVVMF16BI") (RVVM1SI "RVVMF32BI") (RVVMF2SI "RVVMF64BI")

  (RVVM8SF "RVVMF4BI") (RVVM4SF "RVVMF8BI") (RVVM2SF "RVVMF16BI") (RVVM1SF "RVVMF32BI") (RVVMF2SF "RVVMF64BI")

  (RVVM8DI "RVVMF8BI") (RVVM4DI "RVVMF16BI") (RVVM2DI "RVVMF32BI") (RVVM1DI "RVVMF64BI")

  (RVVM8DF "RVVMF8BI") (RVVM4DF "RVVMF16BI") (RVVM2DF "RVVMF32BI") (RVVM1DF "RVVMF64BI")

  (RVVM1x8QI "RVVMF8BI") (RVVMF2x8QI "RVVMF16BI") (RVVMF4x8QI "RVVMF32BI") (RVVMF8x8QI "RVVMF64BI")
  (RVVM1x7QI "RVVMF8BI") (RVVMF2x7QI "RVVMF16BI") (RVVMF4x7QI "RVVMF32BI") (RVVMF8x7QI "RVVMF64BI")
  (RVVM1x6QI "RVVMF8BI") (RVVMF2x6QI "RVVMF16BI") (RVVMF4x6QI "RVVMF32BI") (RVVMF8x6QI "RVVMF64BI")
  (RVVM1x5QI "RVVMF8BI") (RVVMF2x5QI "RVVMF16BI") (RVVMF4x5QI "RVVMF32BI") (RVVMF8x5QI "RVVMF64BI")
  (RVVM2x4QI "RVVMF4BI") (RVVM1x4QI "RVVMF8BI") (RVVMF2x4QI "RVVMF16BI") (RVVMF4x4QI "RVVMF32BI") (RVVMF8x4QI "RVVMF64BI")
  (RVVM2x3QI "RVVMF4BI") (RVVM1x3QI "RVVMF8BI") (RVVMF2x3QI "RVVMF16BI") (RVVMF4x3QI "RVVMF32BI") (RVVMF8x3QI "RVVMF64BI")
  (RVVM4x2QI "RVVMF2BI") (RVVM2x2QI "RVVMF4BI") (RVVM1x2QI "RVVMF8BI") (RVVMF2x2QI "RVVMF16BI") (RVVMF4x2QI "RVVMF32BI") (RVVMF8x2QI "RVVMF64BI")

  (RVVM1x8HI "RVVMF16BI") (RVVMF2x8HI "RVVMF32BI") (RVVMF4x8HI "RVVMF64BI")
  (RVVM1x7HI "RVVMF16BI") (RVVMF2x7HI "RVVMF32BI") (RVVMF4x7HI "RVVMF64BI")
  (RVVM1x6HI "RVVMF16BI") (RVVMF2x6HI "RVVMF32BI") (RVVMF4x6HI "RVVMF64BI")
  (RVVM1x5HI "RVVMF16BI") (RVVMF2x5HI "RVVMF32BI") (RVVMF4x5HI "RVVMF64BI")
  (RVVM2x4HI "RVVMF8BI") (RVVM1x4HI "RVVMF16BI") (RVVMF2x4HI "RVVMF32BI") (RVVMF4x4HI "RVVMF64BI")
  (RVVM2x3HI "RVVMF8BI") (RVVM1x3HI "RVVMF16BI") (RVVMF2x3HI "RVVMF32BI") (RVVMF4x3HI "RVVMF64BI")
  (RVVM4x2HI "RVVMF4BI") (RVVM2x2HI "RVVMF8BI") (RVVM1x2HI "RVVMF16BI") (RVVMF2x2HI "RVVMF32BI") (RVVMF4x2HI "RVVMF64BI")

  (RVVM1x8HF "RVVMF16BI") (RVVMF2x8HF "RVVMF32BI") (RVVMF4x8HF "RVVMF64BI")
  (RVVM1x7HF "RVVMF16BI") (RVVMF2x7HF "RVVMF32BI") (RVVMF4x7HF "RVVMF64BI")
  (RVVM1x6HF "RVVMF16BI") (RVVMF2x6HF "RVVMF32BI") (RVVMF4x6HF "RVVMF64BI")
  (RVVM1x5HF "RVVMF16BI") (RVVMF2x5HF "RVVMF32BI") (RVVMF4x5HF "RVVMF64BI")
  (RVVM2x4HF "RVVMF8BI") (RVVM1x4HF "RVVMF16BI") (RVVMF2x4HF "RVVMF32BI") (RVVMF4x4HF "RVVMF64BI")
  (RVVM2x3HF "RVVMF8BI") (RVVM1x3HF "RVVMF16BI") (RVVMF2x3HF "RVVMF32BI") (RVVMF4x3HF "RVVMF64BI")
  (RVVM4x2HF "RVVMF4BI") (RVVM2x2HF "RVVMF8BI") (RVVM1x2HF "RVVMF16BI") (RVVMF2x2HF "RVVMF32BI") (RVVMF4x2HF "RVVMF64BI")

  (RVVM1x8SI "RVVMF32BI") (RVVMF2x8SI "RVVMF64BI")
  (RVVM1x7SI "RVVMF32BI") (RVVMF2x7SI "RVVMF64BI")
  (RVVM1x6SI "RVVMF32BI") (RVVMF2x6SI "RVVMF64BI")
  (RVVM1x5SI "RVVMF32BI") (RVVMF2x5SI "RVVMF64BI")
  (RVVM2x4SI "RVVMF16BI") (RVVM1x4SI "RVVMF32BI") (RVVMF2x4SI "RVVMF64BI")
  (RVVM2x3SI "RVVMF16BI") (RVVM1x3SI "RVVMF32BI") (RVVMF2x3SI "RVVMF64BI")
  (RVVM4x2SI "RVVMF8BI") (RVVM2x2SI "RVVMF16BI") (RVVM1x2SI "RVVMF32BI") (RVVMF2x2SI "RVVMF64BI")

  (RVVM1x8SF "RVVMF32BI") (RVVMF2x8SF "RVVMF64BI")
  (RVVM1x7SF "RVVMF32BI") (RVVMF2x7SF "RVVMF64BI")
  (RVVM1x6SF "RVVMF32BI") (RVVMF2x6SF "RVVMF64BI")
  (RVVM1x5SF "RVVMF32BI") (RVVMF2x5SF "RVVMF64BI")
  (RVVM2x4SF "RVVMF16BI") (RVVM1x4SF "RVVMF32BI") (RVVMF2x4SF "RVVMF64BI")
  (RVVM2x3SF "RVVMF16BI") (RVVM1x3SF "RVVMF32BI") (RVVMF2x3SF "RVVMF64BI")
  (RVVM4x2SF "RVVMF8BI") (RVVM2x2SF "RVVMF16BI") (RVVM1x2SF "RVVMF32BI") (RVVMF2x2SF "RVVMF64BI")

  (RVVM1x8DI "RVVMF64BI")
  (RVVM1x7DI "RVVMF64BI")
  (RVVM1x6DI "RVVMF64BI")
  (RVVM1x5DI "RVVMF64BI")
  (RVVM2x4DI "RVVMF32BI")
  (RVVM1x4DI "RVVMF64BI")
  (RVVM2x3DI "RVVMF32BI")
  (RVVM1x3DI "RVVMF64BI")
  (RVVM4x2DI "RVVMF16BI")
  (RVVM2x2DI "RVVMF32BI")
  (RVVM1x2DI "RVVMF64BI")

  (RVVM1x8DF "RVVMF64BI")
  (RVVM1x7DF "RVVMF64BI")
  (RVVM1x6DF "RVVMF64BI")
  (RVVM1x5DF "RVVMF64BI")
  (RVVM2x4DF "RVVMF32BI")
  (RVVM1x4DF "RVVMF64BI")
  (RVVM2x3DF "RVVMF32BI")
  (RVVM1x3DF "RVVMF64BI")
  (RVVM4x2DF "RVVMF16BI")
  (RVVM2x2DF "RVVMF32BI")
  (RVVM1x2DF "RVVMF64BI")

  ;; VLS modes.
  (V1QI "V1BI") (V2QI "V2BI") (V4QI "V4BI") (V8QI "V8BI") (V16QI "V16BI") (V32QI "V32BI")
  (V64QI "V64BI") (V128QI "V128BI") (V256QI "V256BI") (V512QI "V512BI")
  (V1024QI "V1024BI") (V2048QI "V2048BI") (V4096QI "V4096BI")
  (V1HI "V1BI") (V2HI "V2BI") (V4HI "V4BI") (V8HI "V8BI") (V16HI "V16BI")
  (V32HI "V32BI") (V64HI "V64BI") (V128HI "V128BI") (V256HI "V256BI")
  (V512HI "V512BI") (V1024HI "V1024BI") (V2048HI "V2048BI")
  (V1SI "V1BI") (V2SI "V2BI") (V4SI "V4BI") (V8SI "V8BI")
  (V16SI "V16BI") (V32SI "V32BI") (V64SI "V64BI")
  (V128SI "V128BI") (V256SI "V256BI") (V512SI "V512BI") (V1024SI "V1024BI")
  (V1DI "V1BI") (V2DI "V2BI") (V4DI "V4BI") (V8DI "V8BI") (V16DI "V16BI") (V32DI "V32BI")
  (V64DI "V64BI") (V128DI "V128BI") (V256DI "V256BI") (V512DI "V512BI")
  (V1HF "V1BI") (V2HF "V2BI") (V4HF "V4BI") (V8HF "V8BI") (V16HF "V16BI")
  (V32HF "V32BI") (V64HF "V64BI") (V128HF "V128BI") (V256HF "V256BI")
  (V512HF "V512BI") (V1024HF "V1024BI") (V2048HF "V2048BI")
  (V1SF "V1BI") (V2SF "V2BI") (V4SF "V4BI") (V8SF "V8BI")
  (V16SF "V16BI") (V32SF "V32BI") (V64SF "V64BI")
  (V128SF "V128BI") (V256SF "V256BI") (V512SF "V512BI") (V1024SF "V1024BI")
  (V1DF "V1BI") (V2DF "V2BI") (V4DF "V4BI") (V8DF "V8BI") (V16DF "V16BI") (V32DF "V32BI")
  (V64DF "V64BI") (V128DF "V128BI") (V256DF "V256BI") (V512DF "V512BI")
])

(define_mode_attr vm [
  (RVVM8QI "rvvm1bi") (RVVM4QI "rvvmf2bi") (RVVM2QI "rvvmf4bi") (RVVM1QI "rvvmf8bi") (RVVMF2QI "rvvmf16bi") (RVVMF4QI "rvvmf32bi") (RVVMF8QI "rvvmf64bi")

  (RVVM8HI "rvvmf2bi") (RVVM4HI "rvvmf4bi") (RVVM2HI "rvvmf8bi") (RVVM1HI "rvvmf16bi") (RVVMF2HI "rvvmf32bi") (RVVMF4HI "rvvmf64bi")

  (RVVM8HF "rvvmf2bi") (RVVM4HF "rvvmf4bi") (RVVM2HF "rvvmf8bi") (RVVM1HF "rvvmf16bi") (RVVMF2HF "rvvmf32bi") (RVVMF4HF "rvvmf64bi")

  (RVVM8SI "rvvmf4bi") (RVVM4SI "rvvmf8bi") (RVVM2SI "rvvmf16bi") (RVVM1SI "rvvmf32bi") (RVVMF2SI "rvvmf64bi")

  (RVVM8SF "rvvmf4bi") (RVVM4SF "rvvmf8bi") (RVVM2SF "rvvmf16bi") (RVVM1SF "rvvmf32bi") (RVVMF2SF "rvvmf64bi")

  (RVVM8DI "rvvmf8bi") (RVVM4DI "rvvmf16bi") (RVVM2DI "rvvmf32bi") (RVVM1DI "rvvmf64bi")

  (RVVM8DF "rvvmf8bi") (RVVM4DF "rvvmf16bi") (RVVM2DF "rvvmf32bi") (RVVM1DF "rvvmf64bi")

  (RVVM1x8QI "rvvmf8bi") (RVVMF2x8QI "rvvmf16bi") (RVVMF4x8QI "rvvmf32bi") (RVVMF8x8QI "rvvmf64bi")
  (RVVM1x7QI "rvvmf8bi") (RVVMF2x7QI "rvvmf16bi") (RVVMF4x7QI "rvvmf32bi") (RVVMF8x7QI "rvvmf64bi")
  (RVVM1x6QI "rvvmf8bi") (RVVMF2x6QI "rvvmf16bi") (RVVMF4x6QI "rvvmf32bi") (RVVMF8x6QI "rvvmf64bi")
  (RVVM1x5QI "rvvmf8bi") (RVVMF2x5QI "rvvmf16bi") (RVVMF4x5QI "rvvmf32bi") (RVVMF8x5QI "rvvmf64bi")
  (RVVM2x4QI "rvvmf4bi") (RVVM1x4QI "rvvmf8bi") (RVVMF2x4QI "rvvmf16bi") (RVVMF4x4QI "rvvmf32bi") (RVVMF8x4QI "rvvmf64bi")
  (RVVM2x3QI "rvvmf4bi") (RVVM1x3QI "rvvmf8bi") (RVVMF2x3QI "rvvmf16bi") (RVVMF4x3QI "rvvmf32bi") (RVVMF8x3QI "rvvmf64bi")
  (RVVM4x2QI "rvvmf2bi") (RVVM2x2QI "rvvmf4bi") (RVVM1x2QI "rvvmf8bi") (RVVMF2x2QI "rvvmf16bi") (RVVMF4x2QI "rvvmf32bi") (RVVMF8x2QI "rvvmf64bi")

  (RVVM1x8HI "rvvmf16bi") (RVVMF2x8HI "rvvmf32bi") (RVVMF4x8HI "rvvmf64bi")
  (RVVM1x7HI "rvvmf16bi") (RVVMF2x7HI "rvvmf32bi") (RVVMF4x7HI "rvvmf64bi")
  (RVVM1x6HI "rvvmf16bi") (RVVMF2x6HI "rvvmf32bi") (RVVMF4x6HI "rvvmf64bi")
  (RVVM1x5HI "rvvmf16bi") (RVVMF2x5HI "rvvmf32bi") (RVVMF4x5HI "rvvmf64bi")
  (RVVM2x4HI "rvvmf8bi") (RVVM1x4HI "rvvmf16bi") (RVVMF2x4HI "rvvmf32bi") (RVVMF4x4HI "rvvmf64bi")
  (RVVM2x3HI "rvvmf8bi") (RVVM1x3HI "rvvmf16bi") (RVVMF2x3HI "rvvmf32bi") (RVVMF4x3HI "rvvmf64bi")
  (RVVM4x2HI "rvvmf4bi") (RVVM2x2HI "rvvmf8bi") (RVVM1x2HI "rvvmf16bi") (RVVMF2x2HI "rvvmf32bi") (RVVMF4x2HI "rvvmf64bi")

  (RVVM1x8HF "rvvmf16bi") (RVVMF2x8HF "rvvmf32bi") (RVVMF4x8HF "rvvmf64bi")
  (RVVM1x7HF "rvvmf16bi") (RVVMF2x7HF "rvvmf32bi") (RVVMF4x7HF "rvvmf64bi")
  (RVVM1x6HF "rvvmf16bi") (RVVMF2x6HF "rvvmf32bi") (RVVMF4x6HF "rvvmf64bi")
  (RVVM1x5HF "rvvmf16bi") (RVVMF2x5HF "rvvmf32bi") (RVVMF4x5HF "rvvmf64bi")
  (RVVM2x4HF "rvvmf8bi") (RVVM1x4HF "rvvmf16bi") (RVVMF2x4HF "rvvmf32bi") (RVVMF4x4HF "rvvmf64bi")
  (RVVM2x3HF "rvvmf8bi") (RVVM1x3HF "rvvmf16bi") (RVVMF2x3HF "rvvmf32bi") (RVVMF4x3HF "rvvmf64bi")
  (RVVM4x2HF "rvvmf4bi") (RVVM2x2HF "rvvmf8bi") (RVVM1x2HF "rvvmf16bi") (RVVMF2x2HF "rvvmf32bi") (RVVMF4x2HF "rvvmf64bi")

  (RVVM1x8SI "rvvmf32bi") (RVVMF2x8SI "rvvmf64bi")
  (RVVM1x7SI "rvvmf32bi") (RVVMF2x7SI "rvvmf64bi")
  (RVVM1x6SI "rvvmf32bi") (RVVMF2x6SI "rvvmf64bi")
  (RVVM1x5SI "rvvmf32bi") (RVVMF2x5SI "rvvmf64bi")
  (RVVM2x4SI "rvvmf16bi") (RVVM1x4SI "rvvmf32bi") (RVVMF2x4SI "rvvmf64bi")
  (RVVM2x3SI "rvvmf16bi") (RVVM1x3SI "rvvmf32bi") (RVVMF2x3SI "rvvmf64bi")
  (RVVM4x2SI "rvvmf4bi") (RVVM2x2SI "rvvmf16bi") (RVVM1x2SI "rvvmf32bi") (RVVMF2x2SI "rvvmf64bi")

  (RVVM1x8SF "rvvmf32bi") (RVVMF2x8SF "rvvmf64bi")
  (RVVM1x7SF "rvvmf32bi") (RVVMF2x7SF "rvvmf64bi")
  (RVVM1x6SF "rvvmf32bi") (RVVMF2x6SF "rvvmf64bi")
  (RVVM1x5SF "rvvmf32bi") (RVVMF2x5SF "rvvmf64bi")
  (RVVM2x4SF "rvvmf16bi") (RVVM1x4SF "rvvmf32bi") (RVVMF2x4SF "rvvmf64bi")
  (RVVM2x3SF "rvvmf16bi") (RVVM1x3SF "rvvmf32bi") (RVVMF2x3SF "rvvmf64bi")
  (RVVM4x2SF "rvvmf4bi") (RVVM2x2SF "rvvmf16bi") (RVVM1x2SF "rvvmf32bi") (RVVMF2x2SF "rvvmf64bi")

  (RVVM1x8DI "rvvmf64bi")
  (RVVM1x7DI "rvvmf64bi")
  (RVVM1x6DI "rvvmf64bi")
  (RVVM1x5DI "rvvmf64bi")
  (RVVM2x4DI "rvvmf32bi")
  (RVVM1x4DI "rvvmf64bi")
  (RVVM2x3DI "rvvmf32bi")
  (RVVM1x3DI "rvvmf64bi")
  (RVVM4x2DI "rvvmf16bi")
  (RVVM2x2DI "rvvmf32bi")
  (RVVM1x2DI "rvvmf64bi")

  (RVVM1x8DF "rvvmf64bi")
  (RVVM1x7DF "rvvmf64bi")
  (RVVM1x6DF "rvvmf64bi")
  (RVVM1x5DF "rvvmf64bi")
  (RVVM2x4DF "rvvmf32bi")
  (RVVM1x4DF "rvvmf64bi")
  (RVVM2x3DF "rvvmf32bi")
  (RVVM1x3DF "rvvmf64bi")
  (RVVM4x2DF "rvvmf16bi")
  (RVVM2x2DF "rvvmf32bi")
  (RVVM1x2DF "rvvmf64bi")

  ;; VLS modes.
  (V1QI "v1bi") (V2QI "v2bi") (V4QI "v4bi") (V8QI "v8bi") (V16QI "v16bi") (V32QI "v32bi")
  (V64QI "v64bi") (V128QI "v128bi") (V256QI "v256bi") (V512QI "v512bi")
  (V1024QI "v1024bi") (V2048QI "v2048bi") (V4096QI "v4096bi")
  (V1HI "v1bi") (V2HI "v2bi") (V4HI "v4bi") (V8HI "v8bi") (V16HI "v16bi")
  (V32HI "v32bi") (V64HI "v64bi") (V128HI "v128bi") (V256HI "v256bi")
  (V512HI "v512bi") (V1024HI "v1024bi") (V2048HI "v2048bi")
  (V1SI "v1bi") (V2SI "v2bi") (V4SI "v4bi") (V8SI "v8bi")
  (V16SI "v16bi") (V32SI "v32bi") (V64SI "v64bi")
  (V128SI "v128bi") (V256SI "v256bi") (V512SI "v512bi") (V1024SI "v1024bi")
  (V1DI "v1bi") (V2DI "v2bi") (V4DI "v4bi") (V8DI "v8bi") (V16DI "v16bi") (V32DI "v32bi")
  (V64DI "v64bi") (V128DI "v128bi") (V256DI "v256bi") (V512DI "v512bi")
  (V1HF "v1bi") (V2HF "v2bi") (V4HF "v4bi") (V8HF "v8bi") (V16HF "v16bi")
  (V32HF "v32bi") (V64HF "v64bi") (V128HF "v128bi") (V256HF "v256bi")
  (V512HF "v512bi") (V1024HF "v1024bi") (V2048HF "v2048bi")
  (V1SF "v1bi") (V2SF "v2bi") (V4SF "v4bi") (V8SF "v8bi")
  (V16SF "v16bi") (V32SF "v32bi") (V64SF "v64bi")
  (V128SF "v128bi") (V256SF "v256bi") (V512SF "v512bi") (V1024SF "v1024bi")
  (V1DF "v1bi") (V2DF "v2bi") (V4DF "v4bi") (V8DF "v8bi") (V16DF "v16bi") (V32DF "v32bi")
  (V64DF "v64bi") (V128DF "v128bi") (V256DF "v256bi") (V512DF "v512bi")
])

(define_mode_attr VEL [
  (RVVM8QI "QI") (RVVM4QI "QI") (RVVM2QI "QI") (RVVM1QI "QI") (RVVMF2QI "QI") (RVVMF4QI "QI") (RVVMF8QI "QI")

  (RVVM8HI "HI") (RVVM4HI "HI") (RVVM2HI "HI") (RVVM1HI "HI") (RVVMF2HI "HI") (RVVMF4HI "HI")

  (RVVM8HF "HF") (RVVM4HF "HF") (RVVM2HF "HF") (RVVM1HF "HF") (RVVMF2HF "HF") (RVVMF4HF "HF")

  (RVVM8SI "SI") (RVVM4SI "SI") (RVVM2SI "SI") (RVVM1SI "SI") (RVVMF2SI "SI")

  (RVVM8SF "SF") (RVVM4SF "SF") (RVVM2SF "SF") (RVVM1SF "SF") (RVVMF2SF "SF")

  (RVVM8DI "DI") (RVVM4DI "DI") (RVVM2DI "DI") (RVVM1DI "DI")

  (RVVM8DF "DF") (RVVM4DF "DF") (RVVM2DF "DF") (RVVM1DF "DF")

  ;; VLS modes.
  (V1QI "QI") (V2QI "QI") (V4QI "QI") (V8QI "QI") (V16QI "QI") (V32QI "QI") (V64QI "QI") (V128QI "QI") (V256QI "QI") (V512QI "QI")
  (V1024QI "QI") (V2048QI "QI") (V4096QI "QI")
  (V1HI "HI") (V2HI "HI") (V4HI "HI") (V8HI "HI") (V16HI "HI") (V32HI "HI") (V64HI "HI") (V128HI "HI") (V256HI "HI")
  (V512HI "HI") (V1024HI "HI") (V2048HI "HI")
  (V1SI "SI") (V2SI "SI") (V4SI "SI") (V8SI "SI") (V16SI "SI") (V32SI "SI") (V64SI "SI") (V128SI "SI") (V256SI "SI")
  (V512SI "SI") (V1024SI "SI")
  (V1DI "DI") (V2DI "DI") (V4DI "DI") (V8DI "DI") (V16DI "DI") (V32DI "DI") (V64DI "DI") (V128DI "DI") (V256DI "DI") (V512DI "DI")
  (V1HF "HF") (V2HF "HF") (V4HF "HF") (V8HF "HF") (V16HF "HF") (V32HF "HF") (V64HF "HF") (V128HF "HF") (V256HF "HF")
  (V512HF "HF") (V1024HF "HF") (V2048HF "HF")
  (V1SF "SF") (V2SF "SF") (V4SF "SF") (V8SF "SF") (V16SF "SF") (V32SF "SF") (V64SF "SF") (V128SF "SF") (V256SF "SF")
  (V512SF "SF") (V1024SF "SF")
  (V1DF "DF") (V2DF "DF") (V4DF "DF") (V8DF "DF") (V16DF "DF") (V32DF "DF") (V64DF "DF") (V128DF "DF") (V256DF "DF") (V512DF "DF")
])

(define_mode_attr vel [
  (RVVM8QI "qi") (RVVM4QI "qi") (RVVM2QI "qi") (RVVM1QI "qi") (RVVMF2QI "qi") (RVVMF4QI "qi") (RVVMF8QI "qi")

  (RVVM8HI "hi") (RVVM4HI "hi") (RVVM2HI "hi") (RVVM1HI "hi") (RVVMF2HI "hi") (RVVMF4HI "hi")

  (RVVM8HF "hf") (RVVM4HF "hf") (RVVM2HF "hf") (RVVM1HF "hf") (RVVMF2HF "hf") (RVVMF4HF "hf")

  (RVVM8SI "si") (RVVM4SI "si") (RVVM2SI "si") (RVVM1SI "si") (RVVMF2SI "si")

  (RVVM8SF "sf") (RVVM4SF "sf") (RVVM2SF "sf") (RVVM1SF "sf") (RVVMF2SF "sf")

  (RVVM8DI "di") (RVVM4DI "di") (RVVM2DI "di") (RVVM1DI "di")

  (RVVM8DF "df") (RVVM4DF "df") (RVVM2DF "df") (RVVM1DF "df")

  ;; VLS modes.
  (V1QI "qi") (V2QI "qi") (V4QI "qi") (V8QI "qi") (V16QI "qi") (V32QI "qi") (V64QI "qi") (V128QI "qi") (V256QI "qi") (V512QI "qi")
  (V1024QI "qi") (V2048QI "qi") (V4096QI "qi")
  (V1HI "hi") (V2HI "hi") (V4HI "hi") (V8HI "hi") (V16HI "hi") (V32HI "hi") (V64HI "hi") (V128HI "hi") (V256HI "hi")
  (V512HI "hi") (V1024HI "hi") (V2048HI "hi")
  (V1SI "si") (V2SI "si") (V4SI "si") (V8SI "si") (V16SI "si") (V32SI "si") (V64SI "si") (V128SI "si") (V256SI "si")
  (V512SI "si") (V1024SI "si")
  (V1DI "di") (V2DI "di") (V4DI "di") (V8DI "di") (V16DI "di") (V32DI "di") (V64DI "di") (V128DI "di") (V256DI "di") (V512DI "di")
  (V1HF "hf") (V2HF "hf") (V4HF "hf") (V8HF "hf") (V16HF "hf") (V32HF "hf") (V64HF "hf") (V128HF "hf") (V256HF "hf")
  (V512HF "hf") (V1024HF "hf") (V2048HF "hf")
  (V1SF "sf") (V2SF "sf") (V4SF "sf") (V8SF "sf") (V16SF "sf") (V32SF "sf") (V64SF "sf") (V128SF "sf") (V256SF "sf")
  (V512SF "sf") (V1024SF "sf")
  (V1DF "df") (V2DF "df") (V4DF "df") (V8DF "df") (V16DF "df") (V32DF "df") (V64DF "df") (V128DF "df") (V256DF "df") (V512DF "df")
])

(define_mode_attr vsingle [
  (RVVM1x8QI "rvvm1qi") (RVVMF2x8QI "rvvmf2qi") (RVVMF4x8QI "rvvmf4qi") (RVVMF8x8QI "rvvmf8qi")
  (RVVM1x7QI "rvvm1qi") (RVVMF2x7QI "rvvmf2qi") (RVVMF4x7QI "rvvmf4qi") (RVVMF8x7QI "rvvmf8qi")
  (RVVM1x6QI "rvvm1qi") (RVVMF2x6QI "rvvmf2qi") (RVVMF4x6QI "rvvmf4qi") (RVVMF8x6QI "rvvmf8qi")
  (RVVM1x5QI "rvvm1qi") (RVVMF2x5QI "rvvmf2qi") (RVVMF4x5QI "rvvmf4qi") (RVVMF8x5QI "rvvmf8qi")
  (RVVM2x4QI "rvvm2qi") (RVVM1x4QI "rvvm1qi") (RVVMF2x4QI "rvvmf2qi") (RVVMF4x4QI "rvvmf4qi") (RVVMF8x4QI "rvvmf8qi")
  (RVVM2x3QI "rvvm2qi") (RVVM1x3QI "rvvm1qi") (RVVMF2x3QI "rvvmf2qi") (RVVMF4x3QI "rvvmf4qi") (RVVMF8x3QI "rvvmf8qi")
  (RVVM4x2QI "rvvm4qi") (RVVM2x2QI "rvvm1qi") (RVVM1x2QI "rvvm1qi") (RVVMF2x2QI "rvvmf2qi") (RVVMF4x2QI "rvvmf4qi") (RVVMF8x2QI "rvvmf8qi")

  (RVVM1x8HI "rvvm1hi") (RVVMF2x8HI "rvvmf2hi") (RVVMF4x8HI "rvvmf4hi")
  (RVVM1x7HI "rvvm1hi") (RVVMF2x7HI "rvvmf2hi") (RVVMF4x7HI "rvvmf4hi")
  (RVVM1x6HI "rvvm1hi") (RVVMF2x6HI "rvvmf2hi") (RVVMF4x6HI "rvvmf4hi")
  (RVVM1x5HI "rvvm1hi") (RVVMF2x5HI "rvvmf2hi") (RVVMF4x5HI "rvvmf4hi")
  (RVVM2x4HI "rvvm2hi") (RVVM1x4HI "rvvm1hi") (RVVMF2x4HI "rvvmf2hi") (RVVMF4x4HI "rvvmf4hi")
  (RVVM2x3HI "rvvm2hi") (RVVM1x3HI "rvvm1hi") (RVVMF2x3HI "rvvmf2hi") (RVVMF4x3HI "rvvmf4hi")
  (RVVM4x2HI "rvvm4hi") (RVVM2x2HI "rvvm2hi") (RVVM1x2HI "rvvm1hi") (RVVMF2x2HI "rvvmf2hi") (RVVMF4x2HI "rvvmf4hi")

  (RVVM1x8HF "rvvm1hf")
  (RVVMF2x8HF "rvvmf2hf")
  (RVVMF4x8HF "rvvmf4hf")
  (RVVM1x7HF "rvvm1hf")
  (RVVMF2x7HF "rvvmf2hf")
  (RVVMF4x7HF "rvvmf4hf")
  (RVVM1x6HF "rvvm1hf")
  (RVVMF2x6HF "rvvmf2hf")
  (RVVMF4x6HF "rvvmf4hf")
  (RVVM1x5HF "rvvm1hf")
  (RVVMF2x5HF "rvvmf2hf")
  (RVVMF4x5HF "rvvmf4hf")
  (RVVM2x4HF "rvvm2hf")
  (RVVM1x4HF "rvvm1hf")
  (RVVMF2x4HF "rvvmf2hf")
  (RVVMF4x4HF "rvvmf4hf")
  (RVVM2x3HF "rvvm2hf")
  (RVVM1x3HF "rvvm1hf")
  (RVVMF2x3HF "rvvmf2hf")
  (RVVMF4x3HF "rvvmf4hf")
  (RVVM4x2HF "rvvm4hf")
  (RVVM2x2HF "rvvm2hf")
  (RVVM1x2HF "rvvm1hf")
  (RVVMF2x2HF "rvvmf2hf")
  (RVVMF4x2HF "rvvmf4hf")

  (RVVM1x8SI "rvvm1si") (RVVMF2x8SI "rvvmf2si")
  (RVVM1x7SI "rvvm1si") (RVVMF2x7SI "rvvmf2si")
  (RVVM1x6SI "rvvm1si") (RVVMF2x6SI "rvvmf2si")
  (RVVM1x5SI "rvvm1si") (RVVMF2x5SI "rvvmf2si")
  (RVVM2x4SI "rvvm2si") (RVVM1x4SI "rvvm1si") (RVVMF2x4SI "rvvmf2si")
  (RVVM2x3SI "rvvm2si") (RVVM1x3SI "rvvm1si") (RVVMF2x3SI "rvvmf2si")
  (RVVM4x2SI "rvvm4si") (RVVM2x2SI "rvvm2si") (RVVM1x2SI "rvvm1si") (RVVMF2x2SI "rvvmf2si")

  (RVVM1x8SF "rvvm1sf")
  (RVVMF2x8SF "rvvmf2sf")
  (RVVM1x7SF "rvvm1sf")
  (RVVMF2x7SF "rvvmf2sf")
  (RVVM1x6SF "rvvm1sf")
  (RVVMF2x6SF "rvvmf2sf")
  (RVVM1x5SF "rvvm1sf")
  (RVVMF2x5SF "rvvmf2sf")
  (RVVM2x4SF "rvvm2sf")
  (RVVM1x4SF "rvvm1sf")
  (RVVMF2x4SF "rvvmf2sf")
  (RVVM2x3SF "rvvm2sf")
  (RVVM1x3SF "rvvm1sf")
  (RVVMF2x3SF "rvvmf2sf")
  (RVVM4x2SF "rvvm4sf")
  (RVVM2x2SF "rvvm2sf")
  (RVVM1x2SF "rvvm1sf")
  (RVVMF2x2SF "rvvmf2sf")

  (RVVM1x8DI "rvvm1di")
  (RVVM1x7DI "rvvm1di")
  (RVVM1x6DI "rvvm1di")
  (RVVM1x5DI "rvvm1di")
  (RVVM2x4DI "rvvm2di")
  (RVVM1x4DI "rvvm1di")
  (RVVM2x3DI "rvvm2di")
  (RVVM1x3DI "rvvm1di")
  (RVVM4x2DI "rvvm4di")
  (RVVM2x2DI "rvvm2di")
  (RVVM1x2DI "rvvm1di")

  (RVVM1x8DF "rvvm1df")
  (RVVM1x7DF "rvvm1df")
  (RVVM1x6DF "rvvm1df")
  (RVVM1x5DF "rvvm1df")
  (RVVM2x4DF "rvvm2df")
  (RVVM1x4DF "rvvm1df")
  (RVVM2x3DF "rvvm2df")
  (RVVM1x3DF "rvvm1df")
  (RVVM4x2DF "rvvm4df")
  (RVVM2x2DF "rvvm2df")
  (RVVM1x2DF "rvvm1df")
])

(define_mode_attr VSUBEL [
  (RVVM8HI "QI") (RVVM4HI "QI") (RVVM2HI "QI") (RVVM1HI "QI") (RVVMF2HI "QI") (RVVMF4HI "QI")

  (RVVM8SI "HI") (RVVM4SI "HI") (RVVM2SI "HI") (RVVM1SI "HI") (RVVMF2SI "HI")

  (RVVM8SF "HF") (RVVM4SF "HF") (RVVM2SF "HF") (RVVM1SF "HF") (RVVMF2SF "HF")

  (RVVM8DI "SI") (RVVM4DI "SI") (RVVM2DI "SI") (RVVM1DI "SI")

  (RVVM8DF "SF") (RVVM4DF "SF") (RVVM2DF "SF") (RVVM1DF "SF")

  ;; VLS modes.
  (V2HI "QI") (V4HI "QI") (V8HI "QI") (V16HI "QI") (V32HI "QI") (V64HI "QI") (V128HI "QI") (V256HI "QI")
  (V512HI "QI") (V1024HI "QI") (V2048HI "QI")
  (V2SI "HI") (V4SI "HI") (V8SI "HI") (V16SI "HI") (V32SI "HI") (V64SI "HI") (V128SI "HI") (V256SI "HI")
  (V512SI "HI") (V1024SI "HI")
  (V2DI "SI") (V4DI "SI") (V8DI "SI") (V16DI "SI") (V32DI "SI") (V64DI "SI") (V128DI "SI") (V256DI "SI") (V512DI "SI")
])

(define_mode_attr nf [
  (RVVM1x8QI "8") (RVVMF2x8QI "8") (RVVMF4x8QI "8") (RVVMF8x8QI "8")
  (RVVM1x7QI "7") (RVVMF2x7QI "7") (RVVMF4x7QI "7") (RVVMF8x7QI "7")
  (RVVM1x6QI "6") (RVVMF2x6QI "6") (RVVMF4x6QI "6") (RVVMF8x6QI "6")
  (RVVM1x5QI "5") (RVVMF2x5QI "5") (RVVMF4x5QI "5") (RVVMF8x5QI "5")
  (RVVM2x4QI "4") (RVVM1x4QI "4") (RVVMF2x4QI "4") (RVVMF4x4QI "4") (RVVMF8x4QI "4")
  (RVVM2x3QI "3") (RVVM1x3QI "3") (RVVMF2x3QI "3") (RVVMF4x3QI "3") (RVVMF8x3QI "3")
  (RVVM4x2QI "2") (RVVM2x2QI "2") (RVVM1x2QI "2") (RVVMF2x2QI "2") (RVVMF4x2QI "2") (RVVMF8x2QI "2")

  (RVVM1x8HI "8") (RVVMF2x8HI "8") (RVVMF4x8HI "8")
  (RVVM1x7HI "7") (RVVMF2x7HI "7") (RVVMF4x7HI "7")
  (RVVM1x6HI "6") (RVVMF2x6HI "6") (RVVMF4x6HI "6")
  (RVVM1x5HI "5") (RVVMF2x5HI "5") (RVVMF4x5HI "5")
  (RVVM2x4HI "4") (RVVM1x4HI "4") (RVVMF2x4HI "4") (RVVMF4x4HI "4")
  (RVVM2x3HI "3") (RVVM1x3HI "3") (RVVMF2x3HI "3") (RVVMF4x3HI "3")
  (RVVM4x2HI "2") (RVVM2x2HI "2") (RVVM1x2HI "2") (RVVMF2x2HI "2") (RVVMF4x2HI "2")

  (RVVM1x8HF "8") (RVVMF2x8HF "8") (RVVMF4x8HF "8")
  (RVVM1x7HF "7") (RVVMF2x7HF "7") (RVVMF4x7HF "7")
  (RVVM1x6HF "6") (RVVMF2x6HF "6") (RVVMF4x6HF "6")
  (RVVM1x5HF "5") (RVVMF2x5HF "5") (RVVMF4x5HF "5")
  (RVVM2x4HF "4") (RVVM1x4HF "4") (RVVMF2x4HF "4") (RVVMF4x4HF "4")
  (RVVM2x3HF "3") (RVVM1x3HF "3") (RVVMF2x3HF "3") (RVVMF4x3HF "3")
  (RVVM4x2HF "2") (RVVM2x2HF "2") (RVVM1x2HF "2") (RVVMF2x2HF "2") (RVVMF4x2HF "2")

  (RVVM1x8SI "8") (RVVMF2x8SI "8")
  (RVVM1x7SI "7") (RVVMF2x7SI "7")
  (RVVM1x6SI "6") (RVVMF2x6SI "6")
  (RVVM1x5SI "5") (RVVMF2x5SI "5")
  (RVVM2x4SI "4") (RVVM1x4SI "4") (RVVMF2x4SI "4")
  (RVVM2x3SI "3") (RVVM1x3SI "3") (RVVMF2x3SI "3")
  (RVVM4x2SI "2") (RVVM2x2SI "2") (RVVM1x2SI "2") (RVVMF2x2SI "2")

  (RVVM1x8SF "8") (RVVMF2x8SF "8")
  (RVVM1x7SF "7") (RVVMF2x7SF "7")
  (RVVM1x6SF "6") (RVVMF2x6SF "6")
  (RVVM1x5SF "5") (RVVMF2x5SF "5")
  (RVVM2x4SF "4") (RVVM1x4SF "4") (RVVMF2x4SF "4")
  (RVVM2x3SF "3") (RVVM1x3SF "3") (RVVMF2x3SF "3")
  (RVVM4x2SF "2") (RVVM2x2SF "2") (RVVM1x2SF "2") (RVVMF2x2SF "2")

  (RVVM1x8DI "8")
  (RVVM1x7DI "7")
  (RVVM1x6DI "6")
  (RVVM1x5DI "5")
  (RVVM2x4DI "4")
  (RVVM1x4DI "4")
  (RVVM2x3DI "3")
  (RVVM1x3DI "3")
  (RVVM4x2DI "2")
  (RVVM2x2DI "2")
  (RVVM1x2DI "2")

  (RVVM1x8DF "8")
  (RVVM1x7DF "7")
  (RVVM1x6DF "6")
  (RVVM1x5DF "5")
  (RVVM2x4DF "4")
  (RVVM1x4DF "4")
  (RVVM2x3DF "3")
  (RVVM1x3DF "3")
  (RVVM4x2DF "2")
  (RVVM2x2DF "2")
  (RVVM1x2DF "2")
])

(define_mode_attr sew [
  (RVVM8QI "8") (RVVM4QI "8") (RVVM2QI "8") (RVVM1QI "8") (RVVMF2QI "8") (RVVMF4QI "8") (RVVMF8QI "8")

  (RVVM8HI "16") (RVVM4HI "16") (RVVM2HI "16") (RVVM1HI "16") (RVVMF2HI "16") (RVVMF4HI "16")

  (RVVM8HF "16") (RVVM4HF "16") (RVVM2HF "16") (RVVM1HF "16") (RVVMF2HF "16") (RVVMF4HF "16")

  (RVVM8SI "32") (RVVM4SI "32") (RVVM2SI "32") (RVVM1SI "32") (RVVMF2SI "32")

  (RVVM8SF "32") (RVVM4SF "32") (RVVM2SF "32") (RVVM1SF "32") (RVVMF2SF "32")

  (RVVM8DI "64") (RVVM4DI "64") (RVVM2DI "64") (RVVM1DI "64")

  (RVVM8DF "64") (RVVM4DF "64") (RVVM2DF "64") (RVVM1DF "64")

  (RVVM1x8QI "8") (RVVMF2x8QI "8") (RVVMF4x8QI "8") (RVVMF8x8QI "8")
  (RVVM1x7QI "8") (RVVMF2x7QI "8") (RVVMF4x7QI "8") (RVVMF8x7QI "8")
  (RVVM1x6QI "8") (RVVMF2x6QI "8") (RVVMF4x6QI "8") (RVVMF8x6QI "8")
  (RVVM1x5QI "8") (RVVMF2x5QI "8") (RVVMF4x5QI "8") (RVVMF8x5QI "8")
  (RVVM2x4QI "8") (RVVM1x4QI "8") (RVVMF2x4QI "8") (RVVMF4x4QI "8") (RVVMF8x4QI "8")
  (RVVM2x3QI "8") (RVVM1x3QI "8") (RVVMF2x3QI "8") (RVVMF4x3QI "8") (RVVMF8x3QI "8")
  (RVVM4x2QI "8") (RVVM2x2QI "8") (RVVM1x2QI "8") (RVVMF2x2QI "8") (RVVMF4x2QI "8") (RVVMF8x2QI "8")

  (RVVM1x8HI "16") (RVVMF2x8HI "16") (RVVMF4x8HI "16")
  (RVVM1x7HI "16") (RVVMF2x7HI "16") (RVVMF4x7HI "16")
  (RVVM1x6HI "16") (RVVMF2x6HI "16") (RVVMF4x6HI "16")
  (RVVM1x5HI "16") (RVVMF2x5HI "16") (RVVMF4x5HI "16")
  (RVVM2x4HI "16") (RVVM1x4HI "16") (RVVMF2x4HI "16") (RVVMF4x4HI "16")
  (RVVM2x3HI "16") (RVVM1x3HI "16") (RVVMF2x3HI "16") (RVVMF4x3HI "16")
  (RVVM4x2HI "16") (RVVM2x2HI "16") (RVVM1x2HI "16") (RVVMF2x2HI "16") (RVVMF4x2HI "16")

  (RVVM1x8HF "16") (RVVMF2x8HF "16") (RVVMF4x8HF "16")
  (RVVM1x7HF "16") (RVVMF2x7HF "16") (RVVMF4x7HF "16")
  (RVVM1x6HF "16") (RVVMF2x6HF "16") (RVVMF4x6HF "16")
  (RVVM1x5HF "16") (RVVMF2x5HF "16") (RVVMF4x5HF "16")
  (RVVM2x4HF "16") (RVVM1x4HF "16") (RVVMF2x4HF "16") (RVVMF4x4HF "16")
  (RVVM2x3HF "16") (RVVM1x3HF "16") (RVVMF2x3HF "16") (RVVMF4x3HF "16")
  (RVVM4x2HF "16") (RVVM2x2HF "16") (RVVM1x2HF "16") (RVVMF2x2HF "16") (RVVMF4x2HF "16")

  (RVVM1x8SI "32") (RVVMF2x8SI "32")
  (RVVM1x7SI "32") (RVVMF2x7SI "32")
  (RVVM1x6SI "32") (RVVMF2x6SI "32")
  (RVVM1x5SI "32") (RVVMF2x5SI "32")
  (RVVM2x4SI "32") (RVVM1x4SI "32") (RVVMF2x4SI "32")
  (RVVM2x3SI "32") (RVVM1x3SI "32") (RVVMF2x3SI "32")
  (RVVM4x2SI "32") (RVVM2x2SI "32") (RVVM1x2SI "32") (RVVMF2x2SI "32")

  (RVVM1x8SF "32") (RVVMF2x8SF "32")
  (RVVM1x7SF "32") (RVVMF2x7SF "32")
  (RVVM1x6SF "32") (RVVMF2x6SF "32")
  (RVVM1x5SF "32") (RVVMF2x5SF "32")
  (RVVM2x4SF "32") (RVVM1x4SF "32") (RVVMF2x4SF "32")
  (RVVM2x3SF "32") (RVVM1x3SF "32") (RVVMF2x3SF "32")
  (RVVM4x2SF "32") (RVVM2x2SF "32") (RVVM1x2SF "32") (RVVMF2x2SF "32")

  (RVVM1x8DI "64")
  (RVVM1x7DI "64")
  (RVVM1x6DI "64")
  (RVVM1x5DI "64")
  (RVVM2x4DI "64")
  (RVVM1x4DI "64")
  (RVVM2x3DI "64")
  (RVVM1x3DI "64")
  (RVVM4x2DI "64")
  (RVVM2x2DI "64")
  (RVVM1x2DI "64")

  (RVVM1x8DF "64")
  (RVVM1x7DF "64")
  (RVVM1x6DF "64")
  (RVVM1x5DF "64")
  (RVVM2x4DF "64")
  (RVVM1x4DF "64")
  (RVVM2x3DF "64")
  (RVVM1x3DF "64")
  (RVVM4x2DF "64")
  (RVVM2x2DF "64")
  (RVVM1x2DF "64")

  ;; VLS modes.
  (V1QI "8") (V2QI "8") (V4QI "8") (V8QI "8") (V16QI "8") (V32QI "8") (V64QI "8") (V128QI "8") (V256QI "8") (V512QI "8")
  (V1024QI "8") (V2048QI "8") (V4096QI "8")
  (V1HI "16") (V2HI "16") (V4HI "16") (V8HI "16") (V16HI "16") (V32HI "16") (V64HI "16") (V128HI "16") (V256HI "16")
  (V512HI "16") (V1024HI "16") (V2048HI "16")
  (V1SI "32") (V2SI "32") (V4SI "32") (V8SI "32") (V16SI "32") (V32SI "32") (V64SI "32") (V128SI "32") (V256SI "32")
  (V512SI "32") (V1024SI "32")
  (V1DI "64") (V2DI "64") (V4DI "64") (V8DI "64") (V16DI "64") (V32DI "64") (V64DI "64") (V128DI "64") (V256DI "64") (V512DI "64")
  (V1HF "16") (V2HF "16") (V4HF "16") (V8HF "16") (V16HF "16") (V32HF "16") (V64HF "16") (V128HF "16") (V256HF "16")
  (V512HF "16") (V1024HF "16") (V2048HF "16")
  (V1SF "32") (V2SF "32") (V4SF "32") (V8SF "32") (V16SF "32") (V32SF "32") (V64SF "32") (V128SF "32") (V256SF "32")
  (V512SF "32") (V1024SF "32")
  (V1DF "64") (V2DF "64") (V4DF "64") (V8DF "64") (V16DF "64") (V32DF "64") (V64DF "64") (V128DF "64") (V256DF "64") (V512DF "64")
])

(define_mode_attr double_trunc_sew [
  (RVVM8HI "8") (RVVM4HI "8") (RVVM2HI "8") (RVVM1HI "8") (RVVMF2HI "8") (RVVMF4HI "8")

  (RVVM8HF "8") (RVVM4HF "8") (RVVM2HF "8") (RVVM1HF "8") (RVVMF2HF "8") (RVVMF4HF "8")

  (RVVM8SI "16") (RVVM4SI "16") (RVVM2SI "16") (RVVM1SI "16") (RVVMF2SI "16")

  (RVVM8SF "16") (RVVM4SF "16") (RVVM2SF "16") (RVVM1SF "16") (RVVMF2SF "16")

  (RVVM8DI "32") (RVVM4DI "32") (RVVM2DI "32") (RVVM1DI "32")

  (RVVM8DF "32") (RVVM4DF "32") (RVVM2DF "32") (RVVM1DF "32")
])

(define_mode_attr quad_trunc_sew [
  (RVVM8SI "8") (RVVM4SI "8") (RVVM2SI "8") (RVVM1SI "8") (RVVMF2SI "8")

  (RVVM8SF "8") (RVVM4SF "8") (RVVM2SF "8") (RVVM1SF "8") (RVVMF2SF "8")

  (RVVM8DI "16") (RVVM4DI "16") (RVVM2DI "16") (RVVM1DI "16")

  (RVVM8DF "16") (RVVM4DF "16") (RVVM2DF "16") (RVVM1DF "16")
])

(define_mode_attr oct_trunc_sew [
  (RVVM8DI "8") (RVVM4DI "8") (RVVM2DI "8") (RVVM1DI "8")

  (RVVM8DF "8") (RVVM4DF "8") (RVVM2DF "8") (RVVM1DF "8")
])

(define_mode_attr double_ext_sew [
  (RVVM4QI "16") (RVVM2QI "16") (RVVM1QI "16") (RVVMF2QI "16") (RVVMF4QI "16") (RVVMF8QI "16")

  (RVVM4HI "32") (RVVM2HI "32") (RVVM1HI "32") (RVVMF2HI "32") (RVVMF4HI "32")

  (RVVM4HF "32") (RVVM2HF "32") (RVVM1HF "32") (RVVMF2HF "32") (RVVMF4HF "32")

  (RVVM4SI "64") (RVVM2SI "64") (RVVM1SI "64") (RVVMF2SI "64")

  (RVVM4SF "64") (RVVM2SF "64") (RVVM1SF "64") (RVVMF2SF "64")
])

(define_mode_attr quad_ext_sew [
  (RVVM2QI "32") (RVVM1QI "32") (RVVMF2QI "32") (RVVMF4QI "32") (RVVMF8QI "32")

  (RVVM2HI "64") (RVVM1HI "64") (RVVMF2HI "64") (RVVMF4HI "64")

  (RVVM2HF "64") (RVVM1HF "64") (RVVMF2HF "64") (RVVMF4HF "64")
])

(define_mode_attr oct_ext_sew [
  (RVVM1QI "64") (RVVMF2QI "64") (RVVMF4QI "64") (RVVMF8QI "64")
])

(define_mode_attr V_DOUBLE_TRUNC [
  (RVVM8HI "RVVM4QI") (RVVM4HI "RVVM2QI") (RVVM2HI "RVVM1QI") (RVVM1HI "RVVMF2QI") (RVVMF2HI "RVVMF4QI") (RVVMF4HI "RVVMF8QI")

  (RVVM8SI "RVVM4HI") (RVVM4SI "RVVM2HI") (RVVM2SI "RVVM1HI") (RVVM1SI "RVVMF2HI") (RVVMF2SI "RVVMF4HI")

  (RVVM8SF "RVVM4HF") (RVVM4SF "RVVM2HF") (RVVM2SF "RVVM1HF") (RVVM1SF "RVVMF2HF") (RVVMF2SF "RVVMF4HF")

  (RVVM8DI "RVVM4SI") (RVVM4DI "RVVM2SI") (RVVM2DI "RVVM1SI") (RVVM1DI "RVVMF2SI")

  (RVVM8DF "RVVM4SF") (RVVM4DF "RVVM2SF") (RVVM2DF "RVVM1SF") (RVVM1DF "RVVMF2SF")
])

(define_mode_attr V_QUAD_TRUNC [
  (RVVM8SI "RVVM2QI") (RVVM4SI "RVVM1QI") (RVVM2SI "RVVMF2QI") (RVVM1SI "RVVMF4QI") (RVVMF2SI "RVVMF8QI")

  (RVVM8DI "RVVM2HI") (RVVM4DI "RVVM1HI") (RVVM2DI "RVVMF2HI") (RVVM1DI "RVVMF4HI")

  (RVVM8DF "RVVM2HF") (RVVM4DF "RVVM1HF") (RVVM2DF "RVVMF2HF") (RVVM1DF "RVVMF4HF")
])

(define_mode_attr V_OCT_TRUNC [
  (RVVM8DI "RVVM1QI") (RVVM4DI "RVVMF2QI") (RVVM2DI "RVVMF4QI") (RVVM1DI "RVVMF8QI")
])

; Again in lower case.
(define_mode_attr v_double_trunc [
  (RVVM8HI "rvvm4qi") (RVVM4HI "rvvm2qi") (RVVM2HI "rvvm1qi") (RVVM1HI "rvvmf2qi") (RVVMF2HI "rvvmf4qi") (RVVMF4HI "rvvmf8qi")

  (RVVM8SI "rvvm4hi") (RVVM4SI "rvvm2hi") (RVVM2SI "rvvm1hi") (RVVM1SI "rvvmf2hi") (RVVMF2SI "rvvmf4hi")

  (RVVM8SF "rvvm4hf") (RVVM4SF "rvvm2hf") (RVVM2SF "rvvm1hf") (RVVM1SF "rvvmf2hf") (RVVMF2SF "rvvmf4hf")

  (RVVM8DI "rvvm4si") (RVVM4DI "rvvm2si") (RVVM2DI "rvvm1si") (RVVM1DI "rvvmf2si")

  (RVVM8DF "rvvm4sf") (RVVM4DF "rvvm2sf") (RVVM2DF "rvvm1sf") (RVVM1DF "rvvmf2sf")
])

(define_mode_attr v_quad_trunc [
  (RVVM8SI "rvvm2qi") (RVVM4SI "rvvm1qi") (RVVM2SI "rvvmf2qi") (RVVM1SI "rvvmf4qi") (RVVMF2SI "rvvmf8qi")

  (RVVM8DI "rvvm2hi") (RVVM4DI "rvvm1hi") (RVVM2DI "rvvmf2hi") (RVVM1DI "rvvmf4hi")

  (RVVM8DF "rvvm2hf") (RVVM4DF "rvvm1hf") (RVVM2DF "rvvmf2hf") (RVVM1DF "rvvmf4hf")
])

(define_mode_attr v_oct_trunc [
  (RVVM8DI "rvvm1qi") (RVVM4DI "rvvmf2qi") (RVVM2DI "rvvmf4qi") (RVVM1DI "rvvmf8qi")
])

(define_mode_attr VINDEX_DOUBLE_TRUNC [
  (RVVM8HI "RVVM4QI") (RVVM4HI "RVVM2QI") (RVVM2HI "RVVM1QI") (RVVM1HI "RVVMF2QI") (RVVMF2HI "RVVMF4QI") (RVVMF4HI "RVVMF8QI")

  (RVVM8HF "RVVM4QI") (RVVM4HF "RVVM2QI") (RVVM2HF "RVVM1QI") (RVVM1HF "RVVMF2QI") (RVVMF2HF "RVVMF4QI") (RVVMF4HF "RVVMF8QI")

  (RVVM8SI "RVVM4HI") (RVVM4SI "RVVM2HI") (RVVM2SI "RVVM1HI") (RVVM1SI "RVVMF2HI") (RVVMF2SI "RVVMF4HI")

  (RVVM8SF "RVVM4HI") (RVVM4SF "RVVM2HI") (RVVM2SF "RVVM1HI") (RVVM1SF "RVVMF2HI") (RVVMF2SF "RVVMF4HI")

  (RVVM8DI "RVVM4SI") (RVVM4DI "RVVM2SI") (RVVM2DI "RVVM1SI") (RVVM1DI "RVVMF2SI")

  (RVVM8DF "RVVM4SI") (RVVM4DF "RVVM2SI") (RVVM2DF "RVVM1SI") (RVVM1DF "RVVMF2SI")
])

(define_mode_attr VINDEX_QUAD_TRUNC [
  (RVVM8SI "RVVM2QI") (RVVM4SI "RVVM1QI") (RVVM2SI "RVVMF2QI") (RVVM1SI "RVVMF4QI") (RVVMF2SI "RVVMF8QI")

  (RVVM8SF "RVVM2QI") (RVVM4SF "RVVM1QI") (RVVM2SF "RVVMF2QI") (RVVM1SF "RVVMF4QI") (RVVMF2SF "RVVMF8QI")

  (RVVM8DI "RVVM2HI") (RVVM4DI "RVVM1HI") (RVVM2DI "RVVMF2HI") (RVVM1DI "RVVMF4HI")

  (RVVM8DF "RVVM2HI") (RVVM4DF "RVVM1HI") (RVVM2DF "RVVMF2HI") (RVVM1DF "RVVMF4HI")
])

(define_mode_attr VINDEX_OCT_TRUNC [
  (RVVM8DI "RVVM1QI") (RVVM4DI "RVVMF2QI") (RVVM2DI "RVVMF4QI") (RVVM1DI "RVVMF8QI")

  (RVVM8DF "RVVM1QI") (RVVM4DF "RVVMF2QI") (RVVM2DF "RVVMF4QI") (RVVM1DF "RVVMF8QI")
])

(define_mode_attr VINDEX_DOUBLE_EXT [
  (RVVM4QI "RVVM8HI") (RVVM2QI "RVVM4HI") (RVVM1QI "RVVM2HI") (RVVMF2QI "RVVM1HI") (RVVMF4QI "RVVMF2HI") (RVVMF8QI "RVVMF4HI")

  (RVVM4HI "RVVM8SI") (RVVM2HI "RVVM4SI") (RVVM1HI "RVVM2SI") (RVVMF2HI "RVVM1SI") (RVVMF4HI "RVVMF2SI")

  (RVVM4HF "RVVM8SI") (RVVM2HF "RVVM4SI") (RVVM1HF "RVVM2SI") (RVVMF2HF "RVVM1SI") (RVVMF4HF "RVVMF2SI")

  (RVVM4SI "RVVM8DI") (RVVM2SI "RVVM4DI") (RVVM1SI "RVVM2DI") (RVVMF2SI "RVVM1DI")

  (RVVM4SF "RVVM8DI") (RVVM2SF "RVVM4DI") (RVVM1SF "RVVM2DI") (RVVMF2SF "RVVM1DI")
])

(define_mode_attr VINDEX_QUAD_EXT [
  (RVVM2QI "RVVM8SI") (RVVM1QI "RVVM4SI") (RVVMF2QI "RVVM2SI") (RVVMF4QI "RVVM1SI") (RVVMF8QI "RVVMF2SI")

  (RVVM2HI "RVVM8DI") (RVVM1HI "RVVM4DI") (RVVMF2HI "RVVM2DI") (RVVMF4HI "RVVM1DI")

  (RVVM2HF "RVVM8DI") (RVVM1HF "RVVM4DI") (RVVMF2HF "RVVM2DI") (RVVMF4HF "RVVM1DI")
])

(define_mode_attr VINDEX_OCT_EXT [
  (RVVM1QI "RVVM8DI") (RVVMF2QI "RVVM4DI") (RVVMF4QI "RVVM2DI") (RVVMF8QI "RVVM1DI")
])

(define_mode_attr VCONVERT [
  (RVVM8HF "RVVM8HI") (RVVM4HF "RVVM4HI") (RVVM2HF "RVVM2HI") (RVVM1HF "RVVM1HI") (RVVMF2HF "RVVMF2HI") (RVVMF4HF "RVVMF4HI")
  (RVVM8SF "RVVM8SI") (RVVM4SF "RVVM4SI") (RVVM2SF "RVVM2SI") (RVVM1SF "RVVM1SI") (RVVMF2SF "RVVMF2SI")
  (RVVM8DF "RVVM8DI") (RVVM4DF "RVVM4DI") (RVVM2DF "RVVM2DI") (RVVM1DF "RVVM1DI")
])

(define_mode_attr vconvert [
  (RVVM8HF "rvvm8hi") (RVVM4HF "rvvm4hi") (RVVM2HF "rvvm2hi") (RVVM1HF "rvvm1hi") (RVVMF2HF "rvvmf2hi") (RVVMF4HF "rvvmf4hi")
  (RVVM8SF "rvvm8si") (RVVM4SF "rvvm4si") (RVVM2SF "rvvm2si") (RVVM1SF "rvvm1si") (RVVMF2SF "rvvmf2si")
  (RVVM8DF "rvvm8di") (RVVM4DF "rvvm4di") (RVVM2DF "rvvm2di") (RVVM1DF "rvvm1di")
])

(define_mode_attr VNCONVERT [
  (RVVM8HF "RVVM4QI") (RVVM4HF "RVVM2QI") (RVVM2HF "RVVM1QI") (RVVM1HF "RVVMF2QI") (RVVMF2HF "RVVMF4QI") (RVVMF4HF "RVVMF8QI")

  (RVVM8SI "RVVM4HF") (RVVM4SI "RVVM2HF") (RVVM2SI "RVVM1HF") (RVVM1SI "RVVMF2HF") (RVVMF2SI "RVVMF4HF")
  (RVVM8SF "RVVM4HI") (RVVM4SF "RVVM2HI") (RVVM2SF "RVVM1HI") (RVVM1SF "RVVMF2HI") (RVVMF2SF "RVVMF4HI")

  (RVVM8DI "RVVM4SF") (RVVM4DI "RVVM2SF") (RVVM2DI "RVVM1SF") (RVVM1DI "RVVMF2SF")
  (RVVM8DF "RVVM4SI") (RVVM4DF "RVVM2SI") (RVVM2DF "RVVM1SI") (RVVM1DF "RVVMF2SI")
])

(define_mode_attr vnconvert [
  (RVVM8HF "rvvm4qi") (RVVM4HF "rvvm2qi") (RVVM2HF "rvvm1qi") (RVVM1HF "rvvmf2qi") (RVVMF2HF "rvvmf4qi") (RVVMF4HF "rvvmf8qi")

  (RVVM8SI "rvvm4hf") (RVVM4SI "rvvm2hf") (RVVM2SI "rvvm1hf") (RVVM1SI "rvvmf2hf") (RVVMF2SI "rvvmf4hf")
  (RVVM8SF "rvvm4hi") (RVVM4SF "rvvm2hi") (RVVM2SF "rvvm1hi") (RVVM1SF "rvvmf2hi") (RVVMF2SF "rvvmf4hi")

  (RVVM8DI "rvvm4sf") (RVVM4DI "rvvm2sf") (RVVM2DI "rvvm1sf") (RVVM1DI "rvvmf2sf")
  (RVVM8DF "rvvm4si") (RVVM4DF "rvvm2si") (RVVM2DF "rvvm1si") (RVVM1DF "rvvmf2si")
])

(define_mode_attr VDEMOTE [
  (RVVM8DI "RVVM8SI") (RVVM4DI "RVVM4SI") (RVVM2DI "RVVM2SI") (RVVM1DI "RVVM1SI")
])

(define_mode_attr VMDEMOTE [
  (RVVM8DI "RVVMF4BI") (RVVM4DI "RVVMF8BI") (RVVM2DI "RVVMF16BI") (RVVM1DI "RVVMF32BI")
])

(define_mode_attr gs_extension [
  (RVVM8QI "const_1_operand") (RVVM4QI "vector_gs_extension_operand")
  (RVVM2QI "immediate_operand") (RVVM1QI "immediate_operand") (RVVMF2QI "immediate_operand")
  (RVVMF4QI "immediate_operand") (RVVMF8QI "immediate_operand")

  (RVVM8HI "const_1_operand") (RVVM4HI "vector_gs_extension_operand")
  (RVVM2HI "immediate_operand") (RVVM1HI "immediate_operand")
  (RVVMF2HI "immediate_operand") (RVVMF4HI "immediate_operand")

  (RVVM8HF "const_1_operand") (RVVM4HF "vector_gs_extension_operand")
  (RVVM2HF "immediate_operand") (RVVM1HF "immediate_operand")
  (RVVMF2HF "immediate_operand") (RVVMF4HF "immediate_operand")

  (RVVM8SI "vector_gs_extension_operand") (RVVM4SI "immediate_operand") (RVVM2SI "immediate_operand")
  (RVVM1SI "immediate_operand") (RVVMF2SI "immediate_operand")

  (RVVM8SF "vector_gs_extension_operand") (RVVM4SF "immediate_operand") (RVVM2SF "immediate_operand")
  (RVVM1SF "immediate_operand") (RVVMF2SF "immediate_operand")

  (RVVM8DI "immediate_operand") (RVVM4DI "immediate_operand")
  (RVVM2DI "immediate_operand") (RVVM1DI "immediate_operand")

  (RVVM8DF "immediate_operand") (RVVM4DF "immediate_operand")
  (RVVM2DF "immediate_operand") (RVVM1DF "immediate_operand")
])

(define_mode_attr gs_scale [
  (RVVM8QI "const_1_operand") (RVVM4QI "const_1_operand")
  (RVVM2QI "const_1_operand") (RVVM1QI "const_1_operand") (RVVMF2QI "const_1_operand")
  (RVVMF4QI "const_1_operand") (RVVMF8QI "const_1_operand")

  (RVVM8HI "const_1_operand") (RVVM4HI "vector_gs_scale_operand_16_rv32")
  (RVVM2HI "vector_gs_scale_operand_16") (RVVM1HI "vector_gs_scale_operand_16")
  (RVVMF2HI "vector_gs_scale_operand_16") (RVVMF4HI "vector_gs_scale_operand_16")

  (RVVM8HF "const_1_operand") (RVVM4HF "vector_gs_scale_operand_16_rv32")
  (RVVM2HF "vector_gs_scale_operand_16") (RVVM1HF "vector_gs_scale_operand_16")
  (RVVMF2HF "vector_gs_scale_operand_16") (RVVMF4HF "vector_gs_scale_operand_16")

  (RVVM8SI "vector_gs_scale_operand_32_rv32") (RVVM4SI "vector_gs_scale_operand_32") (RVVM2SI "vector_gs_scale_operand_32")
  (RVVM1SI "vector_gs_scale_operand_32") (RVVMF2SI "vector_gs_scale_operand_32")

  (RVVM8SF "vector_gs_scale_operand_32_rv32") (RVVM4SF "vector_gs_scale_operand_32") (RVVM2SF "vector_gs_scale_operand_32")
  (RVVM1SF "vector_gs_scale_operand_32") (RVVMF2SF "vector_gs_scale_operand_32")

  (RVVM8DI "vector_gs_scale_operand_64") (RVVM4DI "vector_gs_scale_operand_64")
  (RVVM2DI "vector_gs_scale_operand_64") (RVVM1DI "vector_gs_scale_operand_64")

  (RVVM8DF "vector_gs_scale_operand_64") (RVVM4DF "vector_gs_scale_operand_64")
  (RVVM2DF "vector_gs_scale_operand_64") (RVVM1DF "vector_gs_scale_operand_64")
])

(define_int_iterator WREDUC [UNSPEC_WREDUC_SUM UNSPEC_WREDUC_USUM])

(define_int_iterator ORDER [UNSPEC_ORDERED UNSPEC_UNORDERED])

(define_int_iterator VMULH [UNSPEC_VMULHS UNSPEC_VMULHU UNSPEC_VMULHSU])

(define_int_iterator VNCLIP [UNSPEC_VNCLIP UNSPEC_VNCLIPU])

(define_int_iterator VSLIDES [UNSPEC_VSLIDEUP UNSPEC_VSLIDEDOWN])
(define_int_iterator VSLIDES1 [UNSPEC_VSLIDE1UP UNSPEC_VSLIDE1DOWN])
(define_int_iterator VFSLIDES1 [UNSPEC_VFSLIDE1UP UNSPEC_VFSLIDE1DOWN])

(define_int_iterator VSAT_OP [UNSPEC_VAADDU UNSPEC_VAADD
			      UNSPEC_VASUBU UNSPEC_VASUB UNSPEC_VSMUL
			      UNSPEC_VSSRL UNSPEC_VSSRA])

(define_int_iterator VSAT_ARITH_OP [UNSPEC_VAADDU UNSPEC_VAADD
			      	    UNSPEC_VASUBU UNSPEC_VASUB UNSPEC_VSMUL])
(define_int_iterator VSAT_SHIFT_OP [UNSPEC_VSSRL UNSPEC_VSSRA])

(define_int_iterator VMISC [UNSPEC_VMSBF UNSPEC_VMSIF UNSPEC_VMSOF])

(define_int_iterator VFMISC [UNSPEC_VFRSQRT7])

(define_int_iterator VFMISC_FRM [UNSPEC_VFREC7])

(define_int_iterator VFCVTS [UNSPEC_VFCVT UNSPEC_UNSIGNED_VFCVT])

(define_int_attr order [
  (UNSPEC_ORDERED "o") (UNSPEC_UNORDERED "u")
])

(define_int_attr v_su [(UNSPEC_VMULHS "") (UNSPEC_VMULHU "u") (UNSPEC_VMULHSU "su")
		       (UNSPEC_VNCLIP "") (UNSPEC_VNCLIPU "u")
		       (UNSPEC_VFCVT "") (UNSPEC_UNSIGNED_VFCVT "u")
		       (UNSPEC_WREDUC_SUM "") (UNSPEC_WREDUC_USUM "u")])
(define_int_attr sat_op [(UNSPEC_VAADDU "aaddu") (UNSPEC_VAADD "aadd")
			 (UNSPEC_VASUBU "asubu") (UNSPEC_VASUB "asub")
			 (UNSPEC_VSMUL "smul") (UNSPEC_VSSRL "ssrl")
			 (UNSPEC_VSSRA "ssra")])
(define_int_attr sat_insn_type [(UNSPEC_VAADDU "vaalu") (UNSPEC_VAADD "vaalu")
			 	(UNSPEC_VASUBU "vaalu") (UNSPEC_VASUB "vaalu")
			 	(UNSPEC_VSMUL "vsmul") (UNSPEC_VSSRL "vsshift")
			 	(UNSPEC_VSSRA "vsshift") (UNSPEC_VNCLIP "vnclip")
				(UNSPEC_VNCLIPU "vnclip")])

(define_int_attr misc_op [(UNSPEC_VMSBF "sbf") (UNSPEC_VMSIF "sif") (UNSPEC_VMSOF "sof")
			  (UNSPEC_VFRSQRT7 "rsqrt7")])

(define_int_attr misc_frm_op [(UNSPEC_VFREC7 "rec7")])

(define_int_attr float_insn_type [(UNSPEC_VFRSQRT7 "vfsqrt")])

(define_int_attr float_frm_insn_type [(UNSPEC_VFREC7 "vfrecp")])

(define_int_iterator VCOPYSIGNS [UNSPEC_VCOPYSIGN UNSPEC_VXORSIGN])

(define_int_attr copysign [(UNSPEC_VCOPYSIGN "copysign") (UNSPEC_VXORSIGN "xorsign")])

(define_int_attr nx [(UNSPEC_VCOPYSIGN "") (UNSPEC_VXORSIGN "x")])

(define_int_attr ud [(UNSPEC_VSLIDEUP "up") (UNSPEC_VSLIDEDOWN "down")
		     (UNSPEC_VSLIDE1UP "1up") (UNSPEC_VSLIDE1DOWN "1down")
		     (UNSPEC_VFSLIDE1UP "1up") (UNSPEC_VFSLIDE1DOWN "1down")])

(define_int_attr ud_constraint [(UNSPEC_VSLIDEUP "=&vr,&vr,&vr,&vr") (UNSPEC_VSLIDEDOWN "=vd,vd,vr,vr")
				(UNSPEC_VSLIDE1UP "=&vr,&vr,&vr,&vr") (UNSPEC_VSLIDE1DOWN "=vd,vd,vr,vr")
				(UNSPEC_VFSLIDE1UP "=&vr,&vr,&vr,&vr") (UNSPEC_VFSLIDE1DOWN "=vd,vd,vr,vr")])

(define_int_attr UNSPEC [(UNSPEC_VSLIDE1UP "UNSPEC_VSLIDE1UP")
			 (UNSPEC_VSLIDE1DOWN "UNSPEC_VSLIDE1DOWN")])

(define_code_iterator any_int_binop [plus minus and ior xor ashift ashiftrt lshiftrt
  smax umax smin umin mult div udiv mod umod
])

(define_code_iterator any_int_unop [neg not])

(define_code_iterator any_commutative_binop [plus and ior xor
  smax umax smin umin mult
])

(define_code_iterator any_non_commutative_binop [minus div udiv mod umod])

(define_code_iterator any_int_binop_no_shift
 [plus minus and ior xor smax umax smin umin mult div udiv mod umod
])

(define_code_iterator any_sat_int_binop [ss_plus ss_minus us_plus us_minus])
(define_code_iterator sat_int_plus_binop [ss_plus us_plus])
(define_code_iterator sat_int_minus_binop [ss_minus us_minus])

(define_code_iterator any_widen_binop [plus minus mult])
(define_code_iterator plus_minus [plus minus])

(define_code_attr madd_msub [(plus "madd") (minus "msub")])
(define_code_attr macc_msac [(plus "macc") (minus "msac")])
(define_code_attr nmsub_nmadd [(plus "nmsub") (minus "nmadd")])
(define_code_attr nmsac_nmacc [(plus "nmsac") (minus "nmacc")])

(define_code_attr ext_to_rshift [(sign_extend "ashiftrt")
                                 (zero_extend "lshiftrt")])
(define_code_attr EXT_TO_RSHIFT [(sign_extend "ASHIFTRT")
                                 (zero_extend "LSHIFTRT")])

(define_code_iterator and_ior [and ior])

(define_code_iterator any_float_binop [plus mult minus div])
(define_code_iterator any_float_binop_nofrm [smax smin])
(define_code_iterator commutative_float_binop [plus mult])
(define_code_iterator commutative_float_binop_nofrm [smax smin])
(define_code_iterator non_commutative_float_binop [minus div])
(define_code_iterator any_float_unop [sqrt])
(define_code_iterator any_float_unop_nofrm [neg abs])

(define_code_iterator any_fix [fix unsigned_fix])
(define_code_iterator any_float [float unsigned_float])
(define_code_iterator any_reduc [plus umax smax umin smin and ior xor])
(define_code_iterator any_freduc [smax smin])
(define_code_attr reduc [(plus "sum") (umax "maxu") (smax "max") (umin "minu")
			 (smin "min") (and "and") (ior "or") (xor "xor")])

(define_code_attr fix_cvt [(fix "fix_trunc") (unsigned_fix "fixuns_trunc")])
(define_code_attr float_cvt [(float "float") (unsigned_float "floatuns")])

(define_code_attr ninsn [(and "nand") (ior "nor") (xor "xnor")])

(define_code_attr binop_rhs1_predicate [
			(plus "register_operand")
			(minus "vector_arith_operand")
			(ior "register_operand")
			(xor "register_operand")
			(and "register_operand")
			(ashift "register_operand")
			(ashiftrt "register_operand")
			(lshiftrt "register_operand")
			(smin "register_operand")
			(smax "register_operand")
			(umin "register_operand")
			(umax "register_operand")
			(mult "register_operand")
			(div "register_operand")
			(mod "register_operand")
			(udiv "register_operand")
			(umod "register_operand")
			(ss_plus "register_operand")
			(us_plus "register_operand")
			(ss_minus "register_operand")
			(us_minus "register_operand")])

(define_code_attr binop_rhs2_predicate [
			(plus "vector_arith_operand")
			(minus "vector_neg_arith_operand")
			(ior "vector_arith_operand")
			(xor "vector_arith_operand")
			(and "vector_arith_operand")
			(ashift "vector_shift_operand")
			(ashiftrt "vector_shift_operand")
			(lshiftrt "vector_shift_operand")
			(smin "register_operand")
			(smax "register_operand")
			(umin "register_operand")
			(umax "register_operand")
			(mult "register_operand")
			(div "register_operand")
			(mod "register_operand")
			(udiv "register_operand")
			(umod "register_operand")
			(ss_plus "vector_arith_operand")
			(us_plus "vector_arith_operand")
			(ss_minus "vector_neg_arith_operand")
			(us_minus "register_operand")])

(define_code_attr binop_rhs1_constraint [
			(plus "vr,vr,vr,vr,vr,vr,vr,vr,vr,vr,vr,vr")
			(minus "vr,vr,vr,vr,vr,vr,vr,vr,vi,vi,vi,vi")
			(ior "vr,vr,vr,vr,vr,vr,vr,vr,vr,vr,vr,vr")
			(xor "vr,vr,vr,vr,vr,vr,vr,vr,vr,vr,vr,vr")
			(and "vr,vr,vr,vr,vr,vr,vr,vr,vr,vr,vr,vr")
			(ashift "vr,vr,vr,vr,vr,vr,vr,vr,vr,vr,vr,vr")
			(ashiftrt "vr,vr,vr,vr,vr,vr,vr,vr,vr,vr,vr,vr")
			(lshiftrt "vr,vr,vr,vr,vr,vr,vr,vr,vr,vr,vr,vr")
			(smin "vr,vr,vr,vr,vr,vr,vr,vr,vr,vr,vr,vr")
			(smax "vr,vr,vr,vr,vr,vr,vr,vr,vr,vr,vr,vr")
			(umin "vr,vr,vr,vr,vr,vr,vr,vr,vr,vr,vr,vr")
			(umax "vr,vr,vr,vr,vr,vr,vr,vr,vr,vr,vr,vr")
			(mult "vr,vr,vr,vr,vr,vr,vr,vr,vr,vr,vr,vr")
			(div "vr,vr,vr,vr,vr,vr,vr,vr,vr,vr,vr,vr")
			(mod "vr,vr,vr,vr,vr,vr,vr,vr,vr,vr,vr,vr")
			(udiv "vr,vr,vr,vr,vr,vr,vr,vr,vr,vr,vr,vr")
			(umod "vr,vr,vr,vr,vr,vr,vr,vr,vr,vr,vr,vr")])

(define_code_attr binop_rhs2_constraint [
			(plus "vr,vr,vr,vr,vi,vi,vi,vi,vr,vr,vr,vr")
			(minus "vr,vr,vr,vr,vj,vj,vj,vj,vr,vr,vr,vr")
			(ior "vr,vr,vr,vr,vi,vi,vi,vi,vr,vr,vr,vr")
			(xor "vr,vr,vr,vr,vi,vi,vi,vi,vr,vr,vr,vr")
			(and "vr,vr,vr,vr,vi,vi,vi,vi,vr,vr,vr,vr")
			(ashift "vr,vr,vr,vr,vk,vk,vk,vk,vr,vr,vr,vr")
			(ashiftrt "vr,vr,vr,vr,vk,vk,vk,vk,vr,vr,vr,vr")
			(lshiftrt "vr,vr,vr,vr,vk,vk,vk,vk,vr,vr,vr,vr")
			(smin "vr,vr,vr,vr,vr,vr,vr,vr,vr,vr,vr,vr")
			(smax "vr,vr,vr,vr,vr,vr,vr,vr,vr,vr,vr,vr")
			(umin "vr,vr,vr,vr,vr,vr,vr,vr,vr,vr,vr,vr")
			(umax "vr,vr,vr,vr,vr,vr,vr,vr,vr,vr,vr,vr")
			(mult "vr,vr,vr,vr,vr,vr,vr,vr,vr,vr,vr,vr")
			(div "vr,vr,vr,vr,vr,vr,vr,vr,vr,vr,vr,vr")
			(mod "vr,vr,vr,vr,vr,vr,vr,vr,vr,vr,vr,vr")
			(udiv "vr,vr,vr,vr,vr,vr,vr,vr,vr,vr,vr,vr")
			(umod "vr,vr,vr,vr,vr,vr,vr,vr,vr,vr,vr,vr")
			(ss_plus "vr,vr,vr,vr,vi,vi,vi,vi")
			(us_plus "vr,vr,vr,vr,vi,vi,vi,vi")
			(ss_minus "vr,vr,vr,vr,vj,vj,vj,vj")
			(us_minus "vr,vr,vr,vr,vr,vr,vr,vr")])

(define_code_attr int_binop_insn_type [
			(plus "vialu")
			(minus "vialu")
			(ior "vialu")
			(xor "vialu")
			(and "vialu")
			(ashift "vshift")
			(ashiftrt "vshift")
			(lshiftrt "vshift")
			(smin "viminmax")
			(smax "viminmax")
			(umin "viminmax")
			(umax "viminmax")
			(mult "vimul")
			(div "vidiv")
			(mod "vidiv")
			(udiv "vidiv")
			(umod "vidiv")
			(ss_plus "vsalu")
			(us_plus "vsalu")
			(ss_minus "vsalu")
			(us_minus "vsalu")])

(define_code_attr widen_binop_insn_type [
			(plus "walu")
			(minus "walu")
			(mult "wmul")])

(define_code_attr float_insn_type [
			(plus "vfalu")
			(mult "vfmul")
			(smax "vfminmax")
			(smin "vfminmax")
			(minus "vfalu")
			(div "vfdiv")
			(neg "vfsgnj")
			(abs "vfsgnj")
			(sqrt "vfsqrt")])

;; <binop_vi_variant_insn> expands to the insn name of binop matching constraint rhs1 is immediate.
;; minus is negated as vadd and ss_minus is negated as vsadd, others remain <insn>.
(define_code_attr binop_vi_variant_insn [(ashift "sll.vi")
			       (ashiftrt "sra.vi")
			       (lshiftrt "srl.vi")
			       (div "div.vv")
			       (mod "rem.vv")
			       (udiv "divu.vv")
			       (umod "remu.vv")
			       (ior "or.vi")
			       (xor "xor.vi")
			       (and "and.vi")
			       (plus "add.vi")
			       (minus "add.vi")
			       (smin "min.vv")
			       (smax "max.vv")
			       (umin "minu.vv")
			       (umax "maxu.vv")
			       (mult "mul.vv")
			       (ss_plus "sadd.vi")
			       (us_plus "saddu.vi")
			       (ss_minus "sadd.vi")
			       (us_minus "ssubu.vv")])

;; <binop_reverse_vi_variant_insn> expands to the insn name of binop matching constraint rhs2 is immediate.
;; minus is reversed as vrsub, others remain <insn>.
(define_code_attr binop_reverse_vi_variant_insn [(ashift "sll.vv")
			       (ashiftrt "sra.vv")
			       (lshiftrt "srl.vv")
			       (div "div.vv")
			       (mod "rem.vv")
			       (udiv "divu.vv")
			       (umod "remu.vv")
			       (ior "or.vv")
			       (xor "xor.vv")
			       (and "and.vv")
			       (plus "add.vv")
			       (minus "rsub.vi")
			       (smin "min.vv")
			       (smax "max.vv")
			       (umin "minu.vv")
			       (umax "maxu.vv")
			       (mult "mul.vv")])

(define_code_attr binop_vi_variant_op [(ashift "%3,%v4")
			     (ashiftrt "%3,%v4")
			     (lshiftrt "%3,%v4")
			     (div "%3,%4")
			     (mod "%3,%4")
			     (udiv "%3,%4")
			     (umod "%3,%4")
			     (ior "%3,%v4")
			     (xor "%3,%v4")
			     (and "%3,%v4")
			     (plus "%3,%v4")
			     (minus "%3,%V4")
			     (smin "%3,%4")
			     (smax "%3,%4")
			     (umin "%3,%4")
			     (umax "%3,%4")
			     (mult "%3,%4")
			     (ss_plus "%3,%v4")
			     (us_plus "%3,%v4")
			     (ss_minus "%3,%V4")
			     (us_minus "%3,%4")])

(define_code_attr binop_reverse_vi_variant_op [(ashift "%3,%4")
			      (ashiftrt "%3,%4")
			      (lshiftrt "%3,%4")
			      (div "%3,%4")
			      (mod "%3,%4")
			      (udiv "%3,%4")
			      (umod "%3,%4")
			      (ior "%3,%4")
			      (xor "%3,%4")
			      (and "%3,%4")
			      (plus "%3,%4")
			      (minus "%4,%v3")
			      (smin "%3,%4")
			      (smax "%3,%4")
			      (umin "%3,%4")
			      (umax "%3,%4")
			      (mult "%3,%4")])

(define_code_attr sz [(sign_extend "s") (zero_extend "z")])

;; VLS modes.
(define_mode_iterator VLS [
  (V1QI "TARGET_VECTOR_VLS")
  (V2QI "TARGET_VECTOR_VLS")
  (V4QI "TARGET_VECTOR_VLS")
  (V8QI "TARGET_VECTOR_VLS")
  (V16QI "TARGET_VECTOR_VLS")
  (V32QI "TARGET_VECTOR_VLS")
  (V64QI "TARGET_VECTOR_VLS && TARGET_MIN_VLEN >= 64")
  (V128QI "TARGET_VECTOR_VLS && TARGET_MIN_VLEN >= 128")
  (V256QI "TARGET_VECTOR_VLS && TARGET_MIN_VLEN >= 256")
  (V512QI "TARGET_VECTOR_VLS && TARGET_MIN_VLEN >= 512")
  (V1024QI "TARGET_VECTOR_VLS && TARGET_MIN_VLEN >= 1024")
  (V2048QI "TARGET_VECTOR_VLS && TARGET_MIN_VLEN >= 2048")
  (V4096QI "TARGET_VECTOR_VLS && TARGET_MIN_VLEN >= 4096")
  (V1HI "TARGET_VECTOR_VLS")
  (V2HI "TARGET_VECTOR_VLS")
  (V4HI "TARGET_VECTOR_VLS")
  (V8HI "TARGET_VECTOR_VLS")
  (V16HI "TARGET_VECTOR_VLS")
  (V32HI "TARGET_VECTOR_VLS && TARGET_MIN_VLEN >= 64")
  (V64HI "TARGET_VECTOR_VLS && TARGET_MIN_VLEN >= 128")
  (V128HI "TARGET_VECTOR_VLS && TARGET_MIN_VLEN >= 256")
  (V256HI "TARGET_VECTOR_VLS && TARGET_MIN_VLEN >= 512")
  (V512HI "TARGET_VECTOR_VLS && TARGET_MIN_VLEN >= 1024")
  (V1024HI "TARGET_VECTOR_VLS && TARGET_MIN_VLEN >= 2048")
  (V2048HI "TARGET_VECTOR_VLS && TARGET_MIN_VLEN >= 4096")
  (V1SI "TARGET_VECTOR_VLS")
  (V2SI "TARGET_VECTOR_VLS")
  (V4SI "TARGET_VECTOR_VLS")
  (V8SI "TARGET_VECTOR_VLS")
  (V16SI "TARGET_VECTOR_VLS && TARGET_MIN_VLEN >= 64")
  (V32SI "TARGET_VECTOR_VLS && TARGET_MIN_VLEN >= 128")
  (V64SI "TARGET_VECTOR_VLS && TARGET_MIN_VLEN >= 256")
  (V128SI "TARGET_VECTOR_VLS && TARGET_MIN_VLEN >= 512")
  (V256SI "TARGET_VECTOR_VLS && TARGET_MIN_VLEN >= 1024")
  (V512SI "TARGET_VECTOR_VLS && TARGET_MIN_VLEN >= 2048")
  (V1024SI "TARGET_VECTOR_VLS && TARGET_MIN_VLEN >= 4096")
  (V1DI "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_64")
  (V2DI "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_64")
  (V4DI "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_64")
  (V8DI "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_64 && TARGET_MIN_VLEN >= 64")
  (V16DI "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_64 && TARGET_MIN_VLEN >= 128")
  (V32DI "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_64 && TARGET_MIN_VLEN >= 256")
  (V64DI "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_64 && TARGET_MIN_VLEN >= 512")
  (V128DI "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_64 && TARGET_MIN_VLEN >= 1024")
  (V256DI "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_64 && TARGET_MIN_VLEN >= 2048")
  (V512DI "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_64 && TARGET_MIN_VLEN >= 4096")
  (V1HF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_16")
  (V2HF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_16")
  (V4HF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_16")
  (V8HF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_16")
  (V16HF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_16")
  (V32HF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_16 && TARGET_MIN_VLEN >= 64")
  (V64HF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_16 && TARGET_MIN_VLEN >= 128")
  (V128HF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_16 && TARGET_MIN_VLEN >= 256")
  (V256HF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_16 && TARGET_MIN_VLEN >= 512")
  (V512HF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_16 && TARGET_MIN_VLEN >= 1024")
  (V1024HF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_16 && TARGET_MIN_VLEN >= 2048")
  (V2048HF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_16 && TARGET_MIN_VLEN >= 4096")
  (V1SF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_32")
  (V2SF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_32")
  (V4SF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_32")
  (V8SF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_32")
  (V16SF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_32 && TARGET_MIN_VLEN >= 64")
  (V32SF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_32 && TARGET_MIN_VLEN >= 128")
  (V64SF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_32 && TARGET_MIN_VLEN >= 256")
  (V128SF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_32 && TARGET_MIN_VLEN >= 512")
  (V256SF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_32 && TARGET_MIN_VLEN >= 1024")
  (V512SF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_32 && TARGET_MIN_VLEN >= 2048")
  (V1024SF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_32 && TARGET_MIN_VLEN >= 4096")
  (V1DF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_64")
  (V2DF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_64")
  (V4DF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_64")
  (V8DF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_64 && TARGET_MIN_VLEN >= 64")
  (V16DF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_64 && TARGET_MIN_VLEN >= 128")
  (V32DF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_64 && TARGET_MIN_VLEN >= 256")
  (V64DF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_64 && TARGET_MIN_VLEN >= 512")
  (V128DF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_64 && TARGET_MIN_VLEN >= 1024")
  (V256DF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_64 && TARGET_MIN_VLEN >= 2048")
  (V512DF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_64 && TARGET_MIN_VLEN >= 4096")])

;; VLS modes that has NUNITS < 32.
(define_mode_iterator VLS_AVL_IMM [
  (V1QI "TARGET_VECTOR_VLS")
  (V2QI "TARGET_VECTOR_VLS")
  (V4QI "TARGET_VECTOR_VLS")
  (V8QI "TARGET_VECTOR_VLS")
  (V16QI "TARGET_VECTOR_VLS")
  (V1HI "TARGET_VECTOR_VLS")
  (V2HI "TARGET_VECTOR_VLS")
  (V4HI "TARGET_VECTOR_VLS")
  (V8HI "TARGET_VECTOR_VLS")
  (V16HI "TARGET_VECTOR_VLS")
  (V1SI "TARGET_VECTOR_VLS")
  (V2SI "TARGET_VECTOR_VLS")
  (V4SI "TARGET_VECTOR_VLS")
  (V8SI "TARGET_VECTOR_VLS")
  (V16SI "TARGET_VECTOR_VLS && TARGET_MIN_VLEN >= 64")
  (V1DI "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_64")
  (V2DI "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_64")
  (V4DI "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_64")
  (V8DI "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_64 && TARGET_MIN_VLEN >= 64")
  (V16DI "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_64 && TARGET_MIN_VLEN >= 128")
  (V1HF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_16")
  (V2HF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_16")
  (V4HF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_16")
  (V8HF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_16")
  (V16HF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_16")
  (V1SF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_32")
  (V2SF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_32")
  (V4SF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_32")
  (V8SF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_32")
  (V16SF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_32 && TARGET_MIN_VLEN >= 64")
  (V1DF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_64")
  (V2DF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_64")
  (V4DF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_64")
  (V8DF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_64 && TARGET_MIN_VLEN >= 64")
  (V16DF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_64 && TARGET_MIN_VLEN >= 128")])

;; VLS modes that has NUNITS >= 32.
(define_mode_iterator VLS_AVL_REG [
  (V32QI "TARGET_VECTOR_VLS")
  (V64QI "TARGET_VECTOR_VLS && TARGET_MIN_VLEN >= 64")
  (V128QI "TARGET_VECTOR_VLS && TARGET_MIN_VLEN >= 128")
  (V256QI "TARGET_VECTOR_VLS && TARGET_MIN_VLEN >= 256")
  (V512QI "TARGET_VECTOR_VLS && TARGET_MIN_VLEN >= 512")
  (V1024QI "TARGET_VECTOR_VLS && TARGET_MIN_VLEN >= 1024")
  (V2048QI "TARGET_VECTOR_VLS && TARGET_MIN_VLEN >= 2048")
  (V4096QI "TARGET_VECTOR_VLS && TARGET_MIN_VLEN >= 4096")
  (V32HI "TARGET_VECTOR_VLS && TARGET_MIN_VLEN >= 64")
  (V64HI "TARGET_VECTOR_VLS && TARGET_MIN_VLEN >= 128")
  (V128HI "TARGET_VECTOR_VLS && TARGET_MIN_VLEN >= 256")
  (V256HI "TARGET_VECTOR_VLS && TARGET_MIN_VLEN >= 512")
  (V512HI "TARGET_VECTOR_VLS && TARGET_MIN_VLEN >= 1024")
  (V1024HI "TARGET_VECTOR_VLS && TARGET_MIN_VLEN >= 2048")
  (V2048HI "TARGET_VECTOR_VLS && TARGET_MIN_VLEN >= 4096")
  (V32SI "TARGET_VECTOR_VLS && TARGET_MIN_VLEN >= 128")
  (V64SI "TARGET_VECTOR_VLS && TARGET_MIN_VLEN >= 256")
  (V128SI "TARGET_VECTOR_VLS && TARGET_MIN_VLEN >= 512")
  (V256SI "TARGET_VECTOR_VLS && TARGET_MIN_VLEN >= 1024")
  (V512SI "TARGET_VECTOR_VLS && TARGET_MIN_VLEN >= 2048")
  (V1024SI "TARGET_VECTOR_VLS && TARGET_MIN_VLEN >= 4096")
  (V32DI "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_64 && TARGET_MIN_VLEN >= 256")
  (V64DI "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_64 && TARGET_MIN_VLEN >= 512")
  (V128DI "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_64 && TARGET_MIN_VLEN >= 1024")
  (V256DI "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_64 && TARGET_MIN_VLEN >= 2048")
  (V512DI "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_64 && TARGET_MIN_VLEN >= 4096")
  (V32HF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_16 && TARGET_MIN_VLEN >= 64")
  (V64HF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_16 && TARGET_MIN_VLEN >= 128")
  (V128HF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_16 && TARGET_MIN_VLEN >= 256")
  (V256HF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_16 && TARGET_MIN_VLEN >= 512")
  (V512HF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_16 && TARGET_MIN_VLEN >= 1024")
  (V1024HF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_16 && TARGET_MIN_VLEN >= 2048")
  (V2048HF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_16 && TARGET_MIN_VLEN >= 4096")
  (V32SF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_32 && TARGET_MIN_VLEN >= 128")
  (V64SF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_32 && TARGET_MIN_VLEN >= 256")
  (V128SF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_32 && TARGET_MIN_VLEN >= 512")
  (V256SF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_32 && TARGET_MIN_VLEN >= 1024")
  (V512SF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_32 && TARGET_MIN_VLEN >= 2048")
  (V1024SF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_32 && TARGET_MIN_VLEN >= 4096")
  (V32DF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_64 && TARGET_MIN_VLEN >= 256")
  (V64DF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_64 && TARGET_MIN_VLEN >= 512")
  (V128DF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_64 && TARGET_MIN_VLEN >= 1024")
  (V256DF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_64 && TARGET_MIN_VLEN >= 2048")
  (V512DF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_64 && TARGET_MIN_VLEN >= 4096")])

(define_mode_iterator VLSI [
  (V1QI "TARGET_VECTOR_VLS")
  (V2QI "TARGET_VECTOR_VLS")
  (V4QI "TARGET_VECTOR_VLS")
  (V8QI "TARGET_VECTOR_VLS")
  (V16QI "TARGET_VECTOR_VLS")
  (V32QI "TARGET_VECTOR_VLS")
  (V64QI "TARGET_VECTOR_VLS && TARGET_MIN_VLEN >= 64")
  (V128QI "TARGET_VECTOR_VLS && TARGET_MIN_VLEN >= 128")
  (V256QI "TARGET_VECTOR_VLS && TARGET_MIN_VLEN >= 256")
  (V512QI "TARGET_VECTOR_VLS && TARGET_MIN_VLEN >= 512")
  (V1024QI "TARGET_VECTOR_VLS && TARGET_MIN_VLEN >= 1024")
  (V2048QI "TARGET_VECTOR_VLS && TARGET_MIN_VLEN >= 2048")
  (V4096QI "TARGET_VECTOR_VLS && TARGET_MIN_VLEN >= 4096")
  (V1HI "TARGET_VECTOR_VLS")
  (V2HI "TARGET_VECTOR_VLS")
  (V4HI "TARGET_VECTOR_VLS")
  (V8HI "TARGET_VECTOR_VLS")
  (V16HI "TARGET_VECTOR_VLS")
  (V32HI "TARGET_VECTOR_VLS && TARGET_MIN_VLEN >= 64")
  (V64HI "TARGET_VECTOR_VLS && TARGET_MIN_VLEN >= 128")
  (V128HI "TARGET_VECTOR_VLS && TARGET_MIN_VLEN >= 256")
  (V256HI "TARGET_VECTOR_VLS && TARGET_MIN_VLEN >= 512")
  (V512HI "TARGET_VECTOR_VLS && TARGET_MIN_VLEN >= 1024")
  (V1024HI "TARGET_VECTOR_VLS && TARGET_MIN_VLEN >= 2048")
  (V2048HI "TARGET_VECTOR_VLS && TARGET_MIN_VLEN >= 4096")
  (V1SI "TARGET_VECTOR_VLS")
  (V2SI "TARGET_VECTOR_VLS")
  (V4SI "TARGET_VECTOR_VLS")
  (V8SI "TARGET_VECTOR_VLS")
  (V16SI "TARGET_VECTOR_VLS && TARGET_MIN_VLEN >= 64")
  (V32SI "TARGET_VECTOR_VLS && TARGET_MIN_VLEN >= 128")
  (V64SI "TARGET_VECTOR_VLS && TARGET_MIN_VLEN >= 256")
  (V128SI "TARGET_VECTOR_VLS && TARGET_MIN_VLEN >= 512")
  (V256SI "TARGET_VECTOR_VLS && TARGET_MIN_VLEN >= 1024")
  (V512SI "TARGET_VECTOR_VLS && TARGET_MIN_VLEN >= 2048")
  (V1024SI "TARGET_VECTOR_VLS && TARGET_MIN_VLEN >= 4096")
  (V1DI "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_64")
  (V2DI "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_64")
  (V4DI "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_64")
  (V8DI "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_64 && TARGET_MIN_VLEN >= 64")
  (V16DI "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_64 && TARGET_MIN_VLEN >= 128")
  (V32DI "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_64 && TARGET_MIN_VLEN >= 256")
  (V64DI "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_64 && TARGET_MIN_VLEN >= 512")
  (V128DI "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_64 && TARGET_MIN_VLEN >= 1024")
  (V256DI "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_64 && TARGET_MIN_VLEN >= 2048")
  (V512DI "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_64 && TARGET_MIN_VLEN >= 4096")])

(define_mode_iterator VLSF [
  (V1HF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_16")
  (V2HF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_16")
  (V4HF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_16")
  (V8HF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_16")
  (V16HF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_16")
  (V32HF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_16 && TARGET_MIN_VLEN >= 64")
  (V64HF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_16 && TARGET_MIN_VLEN >= 128")
  (V128HF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_16 && TARGET_MIN_VLEN >= 256")
  (V256HF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_16 && TARGET_MIN_VLEN >= 512")
  (V512HF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_16 && TARGET_MIN_VLEN >= 1024")
  (V1024HF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_16 && TARGET_MIN_VLEN >= 2048")
  (V2048HF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_16 && TARGET_MIN_VLEN >= 4096")
  (V1SF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_32")
  (V2SF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_32")
  (V4SF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_32")
  (V8SF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_32")
  (V16SF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_32 && TARGET_MIN_VLEN >= 64")
  (V32SF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_32 && TARGET_MIN_VLEN >= 128")
  (V64SF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_32 && TARGET_MIN_VLEN >= 256")
  (V128SF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_32 && TARGET_MIN_VLEN >= 512")
  (V256SF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_32 && TARGET_MIN_VLEN >= 1024")
  (V512SF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_32 && TARGET_MIN_VLEN >= 2048")
  (V1024SF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_32 && TARGET_MIN_VLEN >= 4096")
  (V1DF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_64")
  (V2DF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_64")
  (V4DF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_64")
  (V8DF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_64 && TARGET_MIN_VLEN >= 64")
  (V16DF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_64 && TARGET_MIN_VLEN >= 128")
  (V32DF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_64 && TARGET_MIN_VLEN >= 256")
  (V64DF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_64 && TARGET_MIN_VLEN >= 512")
  (V128DF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_64 && TARGET_MIN_VLEN >= 1024")
  (V256DF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_64 && TARGET_MIN_VLEN >= 2048")
  (V512DF "TARGET_VECTOR_VLS && TARGET_VECTOR_ELEN_FP_64 && TARGET_MIN_VLEN >= 4096")
])
