/* do not edit automatically generated by mc from M2RTS.  */
/* M2RTS.mod Implements the run time system facilities of Modula-2.

Copyright (C) 2001-2021 Free Software Foundation, Inc.
Contributed by Gaius Mulley <gaius.mulley@southwales.ac.uk>.

This file is part of GNU Modula-2.

GNU Modula-2 is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3, or (at your option)
any later version.

GNU Modula-2 is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

Under Section 7 of GPL version 3, you are granted additional
permissions described in the GCC Runtime Library Exception, version
3.1, as published by the Free Software Foundation.

You should have received a copy of the GNU General Public License and
a copy of the GCC Runtime Library Exception along with this program;
see the files COPYING3 and COPYING.RUNTIME respectively.  If not, see
<http://www.gnu.org/licenses/>.  */

#include "config.h"
#include "system.h"
#   if !defined (PROC_D)
#      define PROC_D
       typedef void (*PROC_t) (void);
       typedef struct { PROC_t proc; } PROC;
#   endif

#   if !defined (TRUE)
#      define TRUE (1==1)
#   endif

#   if !defined (FALSE)
#      define FALSE (1==0)
#   endif

#   include "GStorage.h"
#if defined(__cplusplus)
#   undef NULL
#   define NULL 0
#endif
#define _M2RTS_H
#define _M2RTS_C

#   include "Glibc.h"
#   include "GNumberIO.h"
#   include "GStrLib.h"
#   include "GSYSTEM.h"
#   include "GASCII.h"
#   include "GStorage.h"
#   include "GRTExceptions.h"
#   include "GM2EXCEPTION.h"
#   include "GM2Dependent.h"

typedef struct M2RTS_ArgCVEnvP_p M2RTS_ArgCVEnvP;

typedef struct M2RTS_ProcedureList_r M2RTS_ProcedureList;

typedef char *M2RTS_PtrToChar;

typedef struct M2RTS__T1_r M2RTS__T1;

typedef M2RTS__T1 *M2RTS_ProcedureChain;

typedef void (*M2RTS_ArgCVEnvP_t) (int, void *, void *);
struct M2RTS_ArgCVEnvP_p { M2RTS_ArgCVEnvP_t proc; };

struct M2RTS_ProcedureList_r {
                               M2RTS_ProcedureChain head;
                               M2RTS_ProcedureChain tail;
                             };

struct M2RTS__T1_r {
                     PROC p;
                     M2RTS_ProcedureChain prev;
                     M2RTS_ProcedureChain next;
                   };

static M2RTS_ProcedureList InitialProc;
static M2RTS_ProcedureList TerminateProc;
static int ExitValue;
static unsigned int isHalting;
static unsigned int CallExit;
static unsigned int Initialized;

/*
   ConstructModules - resolve dependencies and then call each
                      module constructor in turn.
*/

extern "C" void M2RTS_ConstructModules (void * applicationmodule, int argc, void * argv, void * envp);

/*
   DeconstructModules - resolve dependencies and then call each
                        module constructor in turn.
*/

extern "C" void M2RTS_DeconstructModules (void * applicationmodule, int argc, void * argv, void * envp);

/*
   RegisterModule - adds module name to the list of outstanding
                    modules which need to have their dependencies
                    explored to determine initialization order.
*/

extern "C" void M2RTS_RegisterModule (void * name, M2RTS_ArgCVEnvP init, M2RTS_ArgCVEnvP fini, PROC dependencies);

/*
   RequestDependant - used to specify that modulename is dependant upon
                      module dependantmodule.
*/

extern "C" void M2RTS_RequestDependant (void * modulename, void * dependantmodule);

/*
   InstallTerminationProcedure - installs a procedure, p, which will
                                 be called when the procedure
                                 ExecuteTerminationProcedures
                                 is invoked.  It returns TRUE if the
                                 procedure is installed.
*/

extern "C" unsigned int M2RTS_InstallTerminationProcedure (PROC p);

/*
   ExecuteInitialProcedures - executes the initial procedures installed by
                              InstallInitialProcedure.
*/

extern "C" void M2RTS_ExecuteInitialProcedures (void);

/*
   InstallInitialProcedure - installs a procedure to be executed just
                             before the BEGIN code section of the
                             main program module.
*/

extern "C" unsigned int M2RTS_InstallInitialProcedure (PROC p);

/*
   ExecuteTerminationProcedures - calls each installed termination procedure
                                  in reverse order.
*/

extern "C" void M2RTS_ExecuteTerminationProcedures (void);

/*
   Terminate - provides compatibility for pim.  It calls exit with
               the exitcode provided in a prior call to ExitOnHalt
               (or zero if ExitOnHalt was never called).  It does
               not call ExecuteTerminationProcedures.
*/

extern "C" void M2RTS_Terminate (void) __attribute__ ((noreturn));

/*
   HALT - terminate the current program.  The procedure
          ExecuteTerminationProcedures
          is called before the program is stopped.  The parameter
          exitcode is optional.  If the parameter is not supplied
          HALT will call libc 'abort', otherwise it will exit with
          the code supplied.  Supplying a parameter to HALT has the
          same effect as calling ExitOnHalt with the same code and
          then calling HALT with no parameter.
*/

extern "C" void M2RTS_HALT (int exitcode) __attribute__ ((noreturn));

/*
   Halt - provides a more user friendly version of HALT, which takes
          four parameters to aid debugging.
*/

extern "C" void M2RTS_Halt (const char *file_, unsigned int _file_high, unsigned int line, const char *function_, unsigned int _function_high, const char *description_, unsigned int _description_high) __attribute__ ((noreturn));

/*
   ExitOnHalt - if HALT is executed then call exit with the exit code, e.
*/

extern "C" void M2RTS_ExitOnHalt (int e);

/*
   ErrorMessage - emits an error message to stderr and then calls exit (1).
*/

extern "C" void M2RTS_ErrorMessage (const char *message_, unsigned int _message_high, const char *file_, unsigned int _file_high, unsigned int line, const char *function_, unsigned int _function_high) __attribute__ ((noreturn));

/*
   Length - returns the length of a string, a. This is called whenever
            the user calls LENGTH and the parameter cannot be calculated
            at compile time.
*/

extern "C" unsigned int M2RTS_Length (const char *a_, unsigned int _a_high);
extern "C" void M2RTS_AssignmentException (void * filename, unsigned int line, unsigned int column, void * scope, void * message);
extern "C" void M2RTS_ReturnException (void * filename, unsigned int line, unsigned int column, void * scope, void * message);
extern "C" void M2RTS_IncException (void * filename, unsigned int line, unsigned int column, void * scope, void * message);
extern "C" void M2RTS_DecException (void * filename, unsigned int line, unsigned int column, void * scope, void * message);
extern "C" void M2RTS_InclException (void * filename, unsigned int line, unsigned int column, void * scope, void * message);
extern "C" void M2RTS_ExclException (void * filename, unsigned int line, unsigned int column, void * scope, void * message);
extern "C" void M2RTS_ShiftException (void * filename, unsigned int line, unsigned int column, void * scope, void * message);
extern "C" void M2RTS_RotateException (void * filename, unsigned int line, unsigned int column, void * scope, void * message);
extern "C" void M2RTS_StaticArraySubscriptException (void * filename, unsigned int line, unsigned int column, void * scope, void * message);
extern "C" void M2RTS_DynamicArraySubscriptException (void * filename, unsigned int line, unsigned int column, void * scope, void * message);
extern "C" void M2RTS_ForLoopBeginException (void * filename, unsigned int line, unsigned int column, void * scope, void * message);
extern "C" void M2RTS_ForLoopToException (void * filename, unsigned int line, unsigned int column, void * scope, void * message);
extern "C" void M2RTS_ForLoopEndException (void * filename, unsigned int line, unsigned int column, void * scope, void * message);
extern "C" void M2RTS_PointerNilException (void * filename, unsigned int line, unsigned int column, void * scope, void * message);
extern "C" void M2RTS_NoReturnException (void * filename, unsigned int line, unsigned int column, void * scope, void * message);
extern "C" void M2RTS_CaseException (void * filename, unsigned int line, unsigned int column, void * scope, void * message);
extern "C" void M2RTS_WholeNonPosDivException (void * filename, unsigned int line, unsigned int column, void * scope, void * message);
extern "C" void M2RTS_WholeNonPosModException (void * filename, unsigned int line, unsigned int column, void * scope, void * message);
extern "C" void M2RTS_WholeZeroDivException (void * filename, unsigned int line, unsigned int column, void * scope, void * message);
extern "C" void M2RTS_WholeZeroRemException (void * filename, unsigned int line, unsigned int column, void * scope, void * message);
extern "C" void M2RTS_WholeValueException (void * filename, unsigned int line, unsigned int column, void * scope, void * message);
extern "C" void M2RTS_RealValueException (void * filename, unsigned int line, unsigned int column, void * scope, void * message);
extern "C" void M2RTS_ParameterException (void * filename, unsigned int line, unsigned int column, void * scope, void * message);
extern "C" void M2RTS_NoException (void * filename, unsigned int line, unsigned int column, void * scope, void * message);

/*
   ExecuteReverse - execute the procedure associated with procptr
                    and then proceed to try and execute all previous
                    procedures in the chain.
*/

static void ExecuteReverse (M2RTS_ProcedureChain procptr);

/*
   AppendProc - append proc to the end of the procedure list
                defined by proclist.
*/

static unsigned int AppendProc (M2RTS_ProcedureList *proclist, PROC proc);

/*
   ErrorString - writes a string to stderr.
*/

static void ErrorString (const char *a_, unsigned int _a_high);

/*
   InitProcList - initialize the head and tail pointers to NIL.
*/

static void InitProcList (M2RTS_ProcedureList *p);

/*
   Init - initialize the initial, terminate procedure lists and booleans.
*/

static void Init (void);

/*
   CheckInitialized - checks to see if this module has been initialized
                      and if it has not it calls Init.  We need this
                      approach as this module is called by module ctors
                      before we reach main.
*/

static void CheckInitialized (void);


/*
   ExecuteReverse - execute the procedure associated with procptr
                    and then proceed to try and execute all previous
                    procedures in the chain.
*/

static void ExecuteReverse (M2RTS_ProcedureChain procptr)
{
  while (procptr != NULL)
    {
      (*procptr->p.proc) ();  /* Invoke the procedure.  */
      procptr = procptr->prev;  /* Invoke the procedure.  */
    }
}


/*
   AppendProc - append proc to the end of the procedure list
                defined by proclist.
*/

static unsigned int AppendProc (M2RTS_ProcedureList *proclist, PROC proc)
{
  M2RTS_ProcedureChain pdes;

  Storage_ALLOCATE ((void **) &pdes, sizeof (M2RTS__T1));
  pdes->p = proc;
  pdes->prev = (*proclist).tail;
  pdes->next = NULL;
  if ((*proclist).head == NULL)
    {
      (*proclist).head = pdes;
    }
  (*proclist).tail = pdes;
  return TRUE;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   ErrorString - writes a string to stderr.
*/

static void ErrorString (const char *a_, unsigned int _a_high)
{
  int n;
  char a[_a_high+1];

  /* make a local copy of each unbounded array.  */
  memcpy (a, a_, _a_high+1);

  n = static_cast<int> (libc_write (2, &a, static_cast<size_t> (StrLib_StrLen ((const char *) a, _a_high))));
}


/*
   InitProcList - initialize the head and tail pointers to NIL.
*/

static void InitProcList (M2RTS_ProcedureList *p)
{
  (*p).head = NULL;
  (*p).tail = NULL;
}


/*
   Init - initialize the initial, terminate procedure lists and booleans.
*/

static void Init (void)
{
  InitProcList (&InitialProc);
  InitProcList (&TerminateProc);
  ExitValue = 0;
  isHalting = FALSE;
  CallExit = FALSE;  /* default by calling abort  */
}


/*
   CheckInitialized - checks to see if this module has been initialized
                      and if it has not it calls Init.  We need this
                      approach as this module is called by module ctors
                      before we reach main.
*/

static void CheckInitialized (void)
{
  if (! Initialized)
    {
      Initialized = TRUE;
      Init ();
    }
}


/*
   ConstructModules - resolve dependencies and then call each
                      module constructor in turn.
*/

extern "C" void M2RTS_ConstructModules (void * applicationmodule, int argc, void * argv, void * envp)
{
  M2Dependent_ConstructModules (applicationmodule, argc, argv, envp);
}


/*
   DeconstructModules - resolve dependencies and then call each
                        module constructor in turn.
*/

extern "C" void M2RTS_DeconstructModules (void * applicationmodule, int argc, void * argv, void * envp)
{
  M2Dependent_DeconstructModules (applicationmodule, argc, argv, envp);
}


/*
   RegisterModule - adds module name to the list of outstanding
                    modules which need to have their dependencies
                    explored to determine initialization order.
*/

extern "C" void M2RTS_RegisterModule (void * name, M2RTS_ArgCVEnvP init, M2RTS_ArgCVEnvP fini, PROC dependencies)
{
  M2Dependent_RegisterModule (name, (M2Dependent_ArgCVEnvP) {(M2Dependent_ArgCVEnvP_t) init.proc}, (M2Dependent_ArgCVEnvP) {(M2Dependent_ArgCVEnvP_t) fini.proc}, dependencies);
}


/*
   RequestDependant - used to specify that modulename is dependant upon
                      module dependantmodule.
*/

extern "C" void M2RTS_RequestDependant (void * modulename, void * dependantmodule)
{
  M2Dependent_RequestDependant (modulename, dependantmodule);
}


/*
   InstallTerminationProcedure - installs a procedure, p, which will
                                 be called when the procedure
                                 ExecuteTerminationProcedures
                                 is invoked.  It returns TRUE if the
                                 procedure is installed.
*/

extern "C" unsigned int M2RTS_InstallTerminationProcedure (PROC p)
{
  return AppendProc (&TerminateProc, p);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   ExecuteInitialProcedures - executes the initial procedures installed by
                              InstallInitialProcedure.
*/

extern "C" void M2RTS_ExecuteInitialProcedures (void)
{
  ExecuteReverse (InitialProc.tail);
}


/*
   InstallInitialProcedure - installs a procedure to be executed just
                             before the BEGIN code section of the
                             main program module.
*/

extern "C" unsigned int M2RTS_InstallInitialProcedure (PROC p)
{
  return AppendProc (&InitialProc, p);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   ExecuteTerminationProcedures - calls each installed termination procedure
                                  in reverse order.
*/

extern "C" void M2RTS_ExecuteTerminationProcedures (void)
{
  ExecuteReverse (TerminateProc.tail);
}


/*
   Terminate - provides compatibility for pim.  It calls exit with
               the exitcode provided in a prior call to ExitOnHalt
               (or zero if ExitOnHalt was never called).  It does
               not call ExecuteTerminationProcedures.
*/

extern "C" void M2RTS_Terminate (void)
{
  libc_exit (ExitValue);
}


/*
   HALT - terminate the current program.  The procedure
          ExecuteTerminationProcedures
          is called before the program is stopped.  The parameter
          exitcode is optional.  If the parameter is not supplied
          HALT will call libc 'abort', otherwise it will exit with
          the code supplied.  Supplying a parameter to HALT has the
          same effect as calling ExitOnHalt with the same code and
          then calling HALT with no parameter.
*/

extern "C" void M2RTS_HALT (int exitcode)
{
  if (exitcode != -1)
    {
      CallExit = TRUE;
      ExitValue = exitcode;
    }
  if (isHalting)
    {
      /* double HALT found  */
      libc_exit (-1);
    }
  else
    {
      isHalting = TRUE;
      M2RTS_ExecuteTerminationProcedures ();
    }
  if (CallExit)
    {
      libc_exit (ExitValue);
    }
  else
    {
      libc_abort ();
    }
}


/*
   Halt - provides a more user friendly version of HALT, which takes
          four parameters to aid debugging.
*/

extern "C" void M2RTS_Halt (const char *file_, unsigned int _file_high, unsigned int line, const char *function_, unsigned int _function_high, const char *description_, unsigned int _description_high)
{
  char file[_file_high+1];
  char function[_function_high+1];
  char description[_description_high+1];

  /* make a local copy of each unbounded array.  */
  memcpy (file, file_, _file_high+1);
  memcpy (function, function_, _function_high+1);
  memcpy (description, description_, _description_high+1);

  M2RTS_ErrorMessage ((const char *) description, _description_high, (const char *) file, _file_high, line, (const char *) function, _function_high);
  M2RTS_HALT (-1);
  __builtin_unreachable ();
}


/*
   ExitOnHalt - if HALT is executed then call exit with the exit code, e.
*/

extern "C" void M2RTS_ExitOnHalt (int e)
{
  ExitValue = e;
  CallExit = TRUE;
}


/*
   ErrorMessage - emits an error message to stderr and then calls exit (1).
*/

extern "C" void M2RTS_ErrorMessage (const char *message_, unsigned int _message_high, const char *file_, unsigned int _file_high, unsigned int line, const char *function_, unsigned int _function_high)
{
  typedef struct ErrorMessage__T2_a ErrorMessage__T2;

  struct ErrorMessage__T2_a { char array[10+1]; };
  ErrorMessage__T2 LineNo;
  char message[_message_high+1];
  char file[_file_high+1];
  char function[_function_high+1];

  /* make a local copy of each unbounded array.  */
  memcpy (message, message_, _message_high+1);
  memcpy (file, file_, _file_high+1);
  memcpy (function, function_, _function_high+1);

  ErrorString ((const char *) file, _file_high);
  ErrorString ((const char *) ":", 1);
  NumberIO_CardToStr (line, 0, (char *) &LineNo.array[0], 10);
  ErrorString ((const char *) &LineNo.array[0], 10);
  ErrorString ((const char *) ":", 1);
  if (! (StrLib_StrEqual ((const char *) function, _function_high, (const char *) "", 0)))
    {
      ErrorString ((const char *) "in ", 3);
      ErrorString ((const char *) function, _function_high);
      ErrorString ((const char *) " has caused ", 12);
    }
  ErrorString ((const char *) message, _message_high);
  LineNo.array[0] = ASCII_nl;
  LineNo.array[1] = ASCII_nul;
  ErrorString ((const char *) &LineNo.array[0], 10);
  libc_exit (1);
}


/*
   Length - returns the length of a string, a. This is called whenever
            the user calls LENGTH and the parameter cannot be calculated
            at compile time.
*/

extern "C" unsigned int M2RTS_Length (const char *a_, unsigned int _a_high)
{
  unsigned int l;
  unsigned int h;
  char a[_a_high+1];

  /* make a local copy of each unbounded array.  */
  memcpy (a, a_, _a_high+1);

  l = 0;
  h = _a_high;
  while ((l <= h) && (a[l] != ASCII_nul))
    {
      l += 1;
    }
  return l;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}

extern "C" void M2RTS_AssignmentException (void * filename, unsigned int line, unsigned int column, void * scope, void * message)
{
  /* 
   The following are the runtime exception handler routines.
  */
  RTExceptions_Raise ( ((unsigned int) (M2EXCEPTION_rangeException)), filename, line, column, scope, message);
}

extern "C" void M2RTS_ReturnException (void * filename, unsigned int line, unsigned int column, void * scope, void * message)
{
  RTExceptions_Raise ( ((unsigned int) (M2EXCEPTION_rangeException)), filename, line, column, scope, message);
}

extern "C" void M2RTS_IncException (void * filename, unsigned int line, unsigned int column, void * scope, void * message)
{
  RTExceptions_Raise ( ((unsigned int) (M2EXCEPTION_rangeException)), filename, line, column, scope, message);
}

extern "C" void M2RTS_DecException (void * filename, unsigned int line, unsigned int column, void * scope, void * message)
{
  RTExceptions_Raise ( ((unsigned int) (M2EXCEPTION_rangeException)), filename, line, column, scope, message);
}

extern "C" void M2RTS_InclException (void * filename, unsigned int line, unsigned int column, void * scope, void * message)
{
  RTExceptions_Raise ( ((unsigned int) (M2EXCEPTION_rangeException)), filename, line, column, scope, message);
}

extern "C" void M2RTS_ExclException (void * filename, unsigned int line, unsigned int column, void * scope, void * message)
{
  RTExceptions_Raise ( ((unsigned int) (M2EXCEPTION_rangeException)), filename, line, column, scope, message);
}

extern "C" void M2RTS_ShiftException (void * filename, unsigned int line, unsigned int column, void * scope, void * message)
{
  RTExceptions_Raise ( ((unsigned int) (M2EXCEPTION_rangeException)), filename, line, column, scope, message);
}

extern "C" void M2RTS_RotateException (void * filename, unsigned int line, unsigned int column, void * scope, void * message)
{
  RTExceptions_Raise ( ((unsigned int) (M2EXCEPTION_rangeException)), filename, line, column, scope, message);
}

extern "C" void M2RTS_StaticArraySubscriptException (void * filename, unsigned int line, unsigned int column, void * scope, void * message)
{
  RTExceptions_Raise ( ((unsigned int) (M2EXCEPTION_indexException)), filename, line, column, scope, message);
}

extern "C" void M2RTS_DynamicArraySubscriptException (void * filename, unsigned int line, unsigned int column, void * scope, void * message)
{
  RTExceptions_Raise ( ((unsigned int) (M2EXCEPTION_indexException)), filename, line, column, scope, message);
}

extern "C" void M2RTS_ForLoopBeginException (void * filename, unsigned int line, unsigned int column, void * scope, void * message)
{
  RTExceptions_Raise ( ((unsigned int) (M2EXCEPTION_rangeException)), filename, line, column, scope, message);
}

extern "C" void M2RTS_ForLoopToException (void * filename, unsigned int line, unsigned int column, void * scope, void * message)
{
  RTExceptions_Raise ( ((unsigned int) (M2EXCEPTION_rangeException)), filename, line, column, scope, message);
}

extern "C" void M2RTS_ForLoopEndException (void * filename, unsigned int line, unsigned int column, void * scope, void * message)
{
  RTExceptions_Raise ( ((unsigned int) (M2EXCEPTION_rangeException)), filename, line, column, scope, message);
}

extern "C" void M2RTS_PointerNilException (void * filename, unsigned int line, unsigned int column, void * scope, void * message)
{
  RTExceptions_Raise ( ((unsigned int) (M2EXCEPTION_invalidLocation)), filename, line, column, scope, message);
}

extern "C" void M2RTS_NoReturnException (void * filename, unsigned int line, unsigned int column, void * scope, void * message)
{
  RTExceptions_Raise ( ((unsigned int) (M2EXCEPTION_functionException)), filename, line, column, scope, message);
}

extern "C" void M2RTS_CaseException (void * filename, unsigned int line, unsigned int column, void * scope, void * message)
{
  RTExceptions_Raise ( ((unsigned int) (M2EXCEPTION_caseSelectException)), filename, line, column, scope, message);
}

extern "C" void M2RTS_WholeNonPosDivException (void * filename, unsigned int line, unsigned int column, void * scope, void * message)
{
  RTExceptions_Raise ( ((unsigned int) (M2EXCEPTION_wholeDivException)), filename, line, column, scope, message);
}

extern "C" void M2RTS_WholeNonPosModException (void * filename, unsigned int line, unsigned int column, void * scope, void * message)
{
  RTExceptions_Raise ( ((unsigned int) (M2EXCEPTION_wholeDivException)), filename, line, column, scope, message);
}

extern "C" void M2RTS_WholeZeroDivException (void * filename, unsigned int line, unsigned int column, void * scope, void * message)
{
  RTExceptions_Raise ( ((unsigned int) (M2EXCEPTION_wholeDivException)), filename, line, column, scope, message);
}

extern "C" void M2RTS_WholeZeroRemException (void * filename, unsigned int line, unsigned int column, void * scope, void * message)
{
  RTExceptions_Raise ( ((unsigned int) (M2EXCEPTION_wholeDivException)), filename, line, column, scope, message);
}

extern "C" void M2RTS_WholeValueException (void * filename, unsigned int line, unsigned int column, void * scope, void * message)
{
  RTExceptions_Raise ( ((unsigned int) (M2EXCEPTION_wholeValueException)), filename, line, column, scope, message);
}

extern "C" void M2RTS_RealValueException (void * filename, unsigned int line, unsigned int column, void * scope, void * message)
{
  RTExceptions_Raise ( ((unsigned int) (M2EXCEPTION_realValueException)), filename, line, column, scope, message);
}

extern "C" void M2RTS_ParameterException (void * filename, unsigned int line, unsigned int column, void * scope, void * message)
{
  RTExceptions_Raise ( ((unsigned int) (M2EXCEPTION_rangeException)), filename, line, column, scope, message);
}

extern "C" void M2RTS_NoException (void * filename, unsigned int line, unsigned int column, void * scope, void * message)
{
  RTExceptions_Raise ( ((unsigned int) (M2EXCEPTION_exException)), filename, line, column, scope, message);
}

extern "C" void _M2_M2RTS_init (__attribute__((unused)) int argc,__attribute__((unused)) char *argv[],__attribute__((unused)) char *envp[])
{
  CheckInitialized ();
}

extern "C" void _M2_M2RTS_finish (__attribute__((unused)) int argc,__attribute__((unused)) char *argv[],__attribute__((unused)) char *envp[])
{
}
