/* { dg-do run } */
/* { dg-require-effective-target power10_hw } */
/* { dg-options "-mdejagnu-cpu=power10" } */

#include <altivec.h>

extern void abort (void);

/* Vector string isolate right-justified on array of unsigned short.  */
int
sirj_p (vector unsigned short arg)
{
  return vec_strir_p (arg);
}

int main (int argc, short *argv [])
{
  vector unsigned short input1 =
    { 0x1, 0x3, 0x5, 0x7, 0x9, 0xb, 0xd, 0xf };
  vector unsigned short expected1 =
    { 0x1, 0x3, 0x5, 0x7, 0x9, 0xb, 0xd, 0xf };
  vector unsigned short input2 =
    { 0x1, 0x0, 0x5, 0x7, 0x9, 0xb, 0xd, 0xf };
  vector unsigned short expected2 =
    { 0x0, 0x0, 0x5, 0x7, 0x9, 0xb, 0xd, 0xf };
  vector unsigned short input3 =
    { 0x1, 0x0, 0x5, 0x7, 0x9, 0xb, 0xd, 0x0 };
  vector unsigned short expected3 =
    { 0x0, 0x0, 0x5, 0x7, 0x9, 0xb, 0xd, 0x0 };
  vector unsigned short input4 =
    { 0x1, 0x3, 0x5, 0x7, 0x9, 0xb, 0xd, 0x0 };
  vector unsigned short expected4 =
    { 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0 };

  if (sirj_p (input1))
    abort ();
  if (!sirj_p (input2))
    abort ();
  if (!sirj_p (input3))
    abort ();
  if (!sirj_p (input4))
    abort ();

}
