// Copyright 2011 The Go Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// Code generated by mkalldocs.sh; DO NOT EDIT.
// Edit the documentation in other files and rerun mkalldocs.sh to generate this one.

// Go is a tool for managing Go source code.
//
// Usage:
//
// 	go <command> [arguments]
//
// The commands are:
//
// 	bug         start a bug report
// 	build       compile packages and dependencies
// 	clean       remove object files and cached files
// 	doc         show documentation for package or symbol
// 	env         print Go environment information
// 	fix         update packages to use new APIs
// 	fmt         gofmt (reformat) package sources
// 	generate    generate Go files by processing source
// 	get         add dependencies to current module and install them
// 	install     compile and install packages and dependencies
// 	list        list packages or modules
// 	mod         module maintenance
// 	run         compile and run Go program
// 	test        test packages
// 	tool        run specified go tool
// 	version     print Go version
// 	vet         report likely mistakes in packages
//
// Use "go help <command>" for more information about a command.
//
// Additional help topics:
//
// 	buildmode   build modes
// 	c           calling between Go and C
// 	cache       build and test caching
// 	environment environment variables
// 	filetype    file types
// 	go.mod      the go.mod file
// 	gopath      GOPATH environment variable
// 	gopath-get  legacy GOPATH go get
// 	goproxy     module proxy protocol
// 	importpath  import path syntax
// 	modules     modules, module versions, and more
// 	module-get  module-aware go get
// 	module-auth module authentication using go.sum
// 	module-private module configuration for non-public modules
// 	packages    package lists and patterns
// 	testflag    testing flags
// 	testfunc    testing functions
//
// Use "go help <topic>" for more information about that topic.
//
//
// Start a bug report
//
// Usage:
//
// 	go bug
//
// Bug opens the default browser and starts a new bug report.
// The report includes useful system information.
//
//
// Compile packages and dependencies
//
// Usage:
//
// 	go build [-o output] [-i] [build flags] [packages]
//
// Build compiles the packages named by the import paths,
// along with their dependencies, but it does not install the results.
//
// If the arguments to build are a list of .go files from a single directory,
// build treats them as a list of source files specifying a single package.
//
// When compiling packages, build ignores files that end in '_test.go'.
//
// When compiling a single main package, build writes
// the resulting executable to an output file named after
// the first source file ('go build ed.go rx.go' writes 'ed' or 'ed.exe')
// or the source code directory ('go build unix/sam' writes 'sam' or 'sam.exe').
// The '.exe' suffix is added when writing a Windows executable.
//
// When compiling multiple packages or a single non-main package,
// build compiles the packages but discards the resulting object,
// serving only as a check that the packages can be built.
//
// The -o flag forces build to write the resulting executable or object
// to the named output file or directory, instead of the default behavior described
// in the last two paragraphs. If the named output is a directory that exists,
// then any resulting executables will be written to that directory.
//
// The -i flag installs the packages that are dependencies of the target.
//
// The build flags are shared by the build, clean, get, install, list, run,
// and test commands:
//
// 	-a
// 		force rebuilding of packages that are already up-to-date.
// 	-n
// 		print the commands but do not run them.
// 	-p n
// 		the number of programs, such as build commands or
// 		test binaries, that can be run in parallel.
// 		The default is the number of CPUs available.
// 	-race
// 		enable data race detection.
// 		Supported only on linux/amd64, freebsd/amd64, darwin/amd64 and windows/amd64.
// 	-msan
// 		enable interoperation with memory sanitizer.
// 		Supported only on linux/amd64, linux/arm64
// 		and only with Clang/LLVM as the host C compiler.
// 	-v
// 		print the names of packages as they are compiled.
// 	-work
// 		print the name of the temporary work directory and
// 		do not delete it when exiting.
// 	-x
// 		print the commands.
//
// 	-asmflags '[pattern=]arg list'
// 		arguments to pass on each go tool asm invocation.
// 	-buildmode mode
// 		build mode to use. See 'go help buildmode' for more.
// 	-compiler name
// 		name of compiler to use, as in runtime.Compiler (gccgo or gc).
// 	-gccgoflags '[pattern=]arg list'
// 		arguments to pass on each gccgo compiler/linker invocation.
// 	-gcflags '[pattern=]arg list'
// 		arguments to pass on each go tool compile invocation.
// 	-installsuffix suffix
// 		a suffix to use in the name of the package installation directory,
// 		in order to keep output separate from default builds.
// 		If using the -race flag, the install suffix is automatically set to race
// 		or, if set explicitly, has _race appended to it. Likewise for the -msan
// 		flag. Using a -buildmode option that requires non-default compile flags
// 		has a similar effect.
// 	-ldflags '[pattern=]arg list'
// 		arguments to pass on each go tool link invocation.
// 	-linkshared
// 		link against shared libraries previously created with
// 		-buildmode=shared.
// 	-mod mode
// 		module download mode to use: readonly or vendor.
// 		See 'go help modules' for more.
// 	-pkgdir dir
// 		install and load all packages from dir instead of the usual locations.
// 		For example, when building with a non-standard configuration,
// 		use -pkgdir to keep generated packages in a separate location.
// 	-tags tag,list
// 		a comma-separated list of build tags to consider satisfied during the
// 		build. For more information about build tags, see the description of
// 		build constraints in the documentation for the go/build package.
// 		(Earlier versions of Go used a space-separated list, and that form
// 		is deprecated but still recognized.)
// 	-trimpath
// 		remove all file system paths from the resulting executable.
// 		Instead of absolute file system paths, the recorded file names
// 		will begin with either "go" (for the standard library),
// 		or a module path@version (when using modules),
// 		or a plain import path (when using GOPATH).
// 	-toolexec 'cmd args'
// 		a program to use to invoke toolchain programs like vet and asm.
// 		For example, instead of running asm, the go command will run
// 		'cmd args /path/to/asm <arguments for asm>'.
//
// The -asmflags, -gccgoflags, -gcflags, and -ldflags flags accept a
// space-separated list of arguments to pass to an underlying tool
// during the build. To embed spaces in an element in the list, surround
// it with either single or double quotes. The argument list may be
// preceded by a package pattern and an equal sign, which restricts
// the use of that argument list to the building of packages matching
// that pattern (see 'go help packages' for a description of package
// patterns). Without a pattern, the argument list applies only to the
// packages named on the command line. The flags may be repeated
// with different patterns in order to specify different arguments for
// different sets of packages. If a package matches patterns given in
// multiple flags, the latest match on the command line wins.
// For example, 'go build -gcflags=-S fmt' prints the disassembly
// only for package fmt, while 'go build -gcflags=all=-S fmt'
// prints the disassembly for fmt and all its dependencies.
//
// For more about specifying packages, see 'go help packages'.
// For more about where packages and binaries are installed,
// run 'go help gopath'.
// For more about calling between Go and C/C++, run 'go help c'.
//
// Note: Build adheres to certain conventions such as those described
// by 'go help gopath'. Not all projects can follow these conventions,
// however. Installations that have their own conventions or that use
// a separate software build system may choose to use lower-level
// invocations such as 'go tool compile' and 'go tool link' to avoid
// some of the overheads and design decisions of the build tool.
//
// See also: go install, go get, go clean.
//
//
// Remove object files and cached files
//
// Usage:
//
// 	go clean [clean flags] [build flags] [packages]
//
// Clean removes object files from package source directories.
// The go command builds most objects in a temporary directory,
// so go clean is mainly concerned with object files left by other
// tools or by manual invocations of go build.
//
// If a package argument is given or the -i or -r flag is set,
// clean removes the following files from each of the
// source directories corresponding to the import paths:
//
// 	_obj/            old object directory, left from Makefiles
// 	_test/           old test directory, left from Makefiles
// 	_testmain.go     old gotest file, left from Makefiles
// 	test.out         old test log, left from Makefiles
// 	build.out        old test log, left from Makefiles
// 	*.[568ao]        object files, left from Makefiles
//
// 	DIR(.exe)        from go build
// 	DIR.test(.exe)   from go test -c
// 	MAINFILE(.exe)   from go build MAINFILE.go
// 	*.so             from SWIG
//
// In the list, DIR represents the final path element of the
// directory, and MAINFILE is the base name of any Go source
// file in the directory that is not included when building
// the package.
//
// The -i flag causes clean to remove the corresponding installed
// archive or binary (what 'go install' would create).
//
// The -n flag causes clean to print the remove commands it would execute,
// but not run them.
//
// The -r flag causes clean to be applied recursively to all the
// dependencies of the packages named by the import paths.
//
// The -x flag causes clean to print remove commands as it executes them.
//
// The -cache flag causes clean to remove the entire go build cache.
//
// The -testcache flag causes clean to expire all test results in the
// go build cache.
//
// The -modcache flag causes clean to remove the entire module
// download cache, including unpacked source code of versioned
// dependencies.
//
// For more about build flags, see 'go help build'.
//
// For more about specifying packages, see 'go help packages'.
//
//
// Show documentation for package or symbol
//
// Usage:
//
// 	go doc [-u] [-c] [package|[package.]symbol[.methodOrField]]
//
// Doc prints the documentation comments associated with the item identified by its
// arguments (a package, const, func, type, var, method, or struct field)
// followed by a one-line summary of each of the first-level items "under"
// that item (package-level declarations for a package, methods for a type,
// etc.).
//
// Doc accepts zero, one, or two arguments.
//
// Given no arguments, that is, when run as
//
// 	go doc
//
// it prints the package documentation for the package in the current directory.
// If the package is a command (package main), the exported symbols of the package
// are elided from the presentation unless the -cmd flag is provided.
//
// When run with one argument, the argument is treated as a Go-syntax-like
// representation of the item to be documented. What the argument selects depends
// on what is installed in GOROOT and GOPATH, as well as the form of the argument,
// which is schematically one of these:
//
// 	go doc <pkg>
// 	go doc <sym>[.<methodOrField>]
// 	go doc [<pkg>.]<sym>[.<methodOrField>]
// 	go doc [<pkg>.][<sym>.]<methodOrField>
//
// The first item in this list matched by the argument is the one whose documentation
// is printed. (See the examples below.) However, if the argument starts with a capital
// letter it is assumed to identify a symbol or method in the current directory.
//
// For packages, the order of scanning is determined lexically in breadth-first order.
// That is, the package presented is the one that matches the search and is nearest
// the root and lexically first at its level of the hierarchy. The GOROOT tree is
// always scanned in its entirety before GOPATH.
//
// If there is no package specified or matched, the package in the current
// directory is selected, so "go doc Foo" shows the documentation for symbol Foo in
// the current package.
//
// The package path must be either a qualified path or a proper suffix of a
// path. The go tool's usual package mechanism does not apply: package path
// elements like . and ... are not implemented by go doc.
//
// When run with two arguments, the first must be a full package path (not just a
// suffix), and the second is a symbol, or symbol with method or struct field.
// This is similar to the syntax accepted by godoc:
//
// 	go doc <pkg> <sym>[.<methodOrField>]
//
// In all forms, when matching symbols, lower-case letters in the argument match
// either case but upper-case letters match exactly. This means that there may be
// multiple matches of a lower-case argument in a package if different symbols have
// different cases. If this occurs, documentation for all matches is printed.
//
// Examples:
// 	go doc
// 		Show documentation for current package.
// 	go doc Foo
// 		Show documentation for Foo in the current package.
// 		(Foo starts with a capital letter so it cannot match
// 		a package path.)
// 	go doc encoding/json
// 		Show documentation for the encoding/json package.
// 	go doc json
// 		Shorthand for encoding/json.
// 	go doc json.Number (or go doc json.number)
// 		Show documentation and method summary for json.Number.
// 	go doc json.Number.Int64 (or go doc json.number.int64)
// 		Show documentation for json.Number's Int64 method.
// 	go doc cmd/doc
// 		Show package docs for the doc command.
// 	go doc -cmd cmd/doc
// 		Show package docs and exported symbols within the doc command.
// 	go doc template.new
// 		Show documentation for html/template's New function.
// 		(html/template is lexically before text/template)
// 	go doc text/template.new # One argument
// 		Show documentation for text/template's New function.
// 	go doc text/template new # Two arguments
// 		Show documentation for text/template's New function.
//
// 	At least in the current tree, these invocations all print the
// 	documentation for json.Decoder's Decode method:
//
// 	go doc json.Decoder.Decode
// 	go doc json.decoder.decode
// 	go doc json.decode
// 	cd go/src/encoding/json; go doc decode
//
// Flags:
// 	-all
// 		Show all the documentation for the package.
// 	-c
// 		Respect case when matching symbols.
// 	-cmd
// 		Treat a command (package main) like a regular package.
// 		Otherwise package main's exported symbols are hidden
// 		when showing the package's top-level documentation.
// 	-src
// 		Show the full source code for the symbol. This will
// 		display the full Go source of its declaration and
// 		definition, such as a function definition (including
// 		the body), type declaration or enclosing const
// 		block. The output may therefore include unexported
// 		details.
// 	-u
// 		Show documentation for unexported as well as exported
// 		symbols, methods, and fields.
//
//
// Print Go environment information
//
// Usage:
//
// 	go env [-json] [-u] [-w] [var ...]
//
// Env prints Go environment information.
//
// By default env prints information as a shell script
// (on Windows, a batch file). If one or more variable
// names is given as arguments, env prints the value of
// each named variable on its own line.
//
// The -json flag prints the environment in JSON format
// instead of as a shell script.
//
// The -u flag requires one or more arguments and unsets
// the default setting for the named environment variables,
// if one has been set with 'go env -w'.
//
// The -w flag requires one or more arguments of the
// form NAME=VALUE and changes the default settings
// of the named environment variables to the given values.
//
// For more about environment variables, see 'go help environment'.
//
//
// Update packages to use new APIs
//
// Usage:
//
// 	go fix [packages]
//
// Fix runs the Go fix command on the packages named by the import paths.
//
// For more about fix, see 'go doc cmd/fix'.
// For more about specifying packages, see 'go help packages'.
//
// To run fix with specific options, run 'go tool fix'.
//
// See also: go fmt, go vet.
//
//
// Gofmt (reformat) package sources
//
// Usage:
//
// 	go fmt [-n] [-x] [packages]
//
// Fmt runs the command 'gofmt -l -w' on the packages named
// by the import paths. It prints the names of the files that are modified.
//
// For more about gofmt, see 'go doc cmd/gofmt'.
// For more about specifying packages, see 'go help packages'.
//
// The -n flag prints commands that would be executed.
// The -x flag prints commands as they are executed.
//
// To run gofmt with specific options, run gofmt itself.
//
// See also: go fix, go vet.
//
//
// Generate Go files by processing source
//
// Usage:
//
// 	go generate [-run regexp] [-n] [-v] [-x] [build flags] [file.go... | packages]
//
// Generate runs commands described by directives within existing
// files. Those commands can run any process but the intent is to
// create or update Go source files.
//
// Go generate is never run automatically by go build, go get, go test,
// and so on. It must be run explicitly.
//
// Go generate scans the file for directives, which are lines of
// the form,
//
// 	//go:generate command argument...
//
// (note: no leading spaces and no space in "//go") where command
// is the generator to be run, corresponding to an executable file
// that can be run locally. It must either be in the shell path
// (gofmt), a fully qualified path (/usr/you/bin/mytool), or a
// command alias, described below.
//
// To convey to humans and machine tools that code is generated,
// generated source should have a line that matches the following
// regular expression (in Go syntax):
//
// 	^// Code generated .* DO NOT EDIT\.$
//
// The line may appear anywhere in the file, but is typically
// placed near the beginning so it is easy to find.
//
// Note that go generate does not parse the file, so lines that look
// like directives in comments or multiline strings will be treated
// as directives.
//
// The arguments to the directive are space-separated tokens or
// double-quoted strings passed to the generator as individual
// arguments when it is run.
//
// Quoted strings use Go syntax and are evaluated before execution; a
// quoted string appears as a single argument to the generator.
//
// Go generate sets several variables when it runs the generator:
//
// 	$GOARCH
// 		The execution architecture (arm, amd64, etc.)
// 	$GOOS
// 		The execution operating system (linux, windows, etc.)
// 	$GOFILE
// 		The base name of the file.
// 	$GOLINE
// 		The line number of the directive in the source file.
// 	$GOPACKAGE
// 		The name of the package of the file containing the directive.
// 	$DOLLAR
// 		A dollar sign.
//
// Other than variable substitution and quoted-string evaluation, no
// special processing such as "globbing" is performed on the command
// line.
//
// As a last step before running the command, any invocations of any
// environment variables with alphanumeric names, such as $GOFILE or
// $HOME, are expanded throughout the command line. The syntax for
// variable expansion is $NAME on all operating systems. Due to the
// order of evaluation, variables are expanded even inside quoted
// strings. If the variable NAME is not set, $NAME expands to the
// empty string.
//
// A directive of the form,
//
// 	//go:generate -command xxx args...
//
// specifies, for the remainder of this source file only, that the
// string xxx represents the command identified by the arguments. This
// can be used to create aliases or to handle multiword generators.
// For example,
//
// 	//go:generate -command foo go tool foo
//
// specifies that the command "foo" represents the generator
// "go tool foo".
//
// Generate processes packages in the order given on the command line,
// one at a time. If the command line lists .go files from a single directory,
// they are treated as a single package. Within a package, generate processes the
// source files in a package in file name order, one at a time. Within
// a source file, generate runs generators in the order they appear
// in the file, one at a time. The go generate tool also sets the build
// tag "generate" so that files may be examined by go generate but ignored
// during build.
//
// If any generator returns an error exit status, "go generate" skips
// all further processing for that package.
//
// The generator is run in the package's source directory.
//
// Go generate accepts one specific flag:
//
// 	-run=""
// 		if non-empty, specifies a regular expression to select
// 		directives whose full original source text (excluding
// 		any trailing spaces and final newline) matches the
// 		expression.
//
// It also accepts the standard build flags including -v, -n, and -x.
// The -v flag prints the names of packages and files as they are
// processed.
// The -n flag prints commands that would be executed.
// The -x flag prints commands as they are executed.
//
// For more about build flags, see 'go help build'.
//
// For more about specifying packages, see 'go help packages'.
//
//
// Add dependencies to current module and install them
//
// Usage:
//
// 	go get [-d] [-t] [-u] [-v] [-insecure] [build flags] [packages]
//
// Get resolves and adds dependencies to the current development module
// and then builds and installs them.
//
// The first step is to resolve which dependencies to add.
//
// For each named package or package pattern, get must decide which version of
// the corresponding module to use. By default, get looks up the latest tagged
// release version, such as v0.4.5 or v1.2.3. If there are no tagged release
// versions, get looks up the latest tagged pre-release version, such as
// v0.0.1-pre1. If there are no tagged versions at all, get looks up the latest
// known commit. If the module is not already required at a later version
// (for example, a pre-release newer than the latest release), get will use
// the version it looked up. Otherwise, get will use the currently
// required version.
//
// This default version selection can be overridden by adding an @version
// suffix to the package argument, as in 'go get golang.org/x/text@v0.3.0'.
// The version may be a prefix: @v1 denotes the latest available version starting
// with v1. See 'go help modules' under the heading 'Module queries' for the
// full query syntax.
//
// For modules stored in source control repositories, the version suffix can
// also be a commit hash, branch identifier, or other syntax known to the
// source control system, as in 'go get golang.org/x/text@master'. Note that
// branches with names that overlap with other module query syntax cannot be
// selected explicitly. For example, the suffix @v2 means the latest version
// starting with v2, not the branch named v2.
//
// If a module under consideration is already a dependency of the current
// development module, then get will update the required version.
// Specifying a version earlier than the current required version is valid and
// downgrades the dependency. The version suffix @none indicates that the
// dependency should be removed entirely, downgrading or removing modules
// depending on it as needed.
//
// The version suffix @latest explicitly requests the latest minor release of the
// module named by the given path. The suffix @upgrade is like @latest but
// will not downgrade a module if it is already required at a revision or
// pre-release version newer than the latest released version. The suffix
// @patch requests the latest patch release: the latest released version
// with the same major and minor version numbers as the currently required
// version. Like @upgrade, @patch will not downgrade a module already required
// at a newer version. If the path is not already required, @upgrade and @patch
// are equivalent to @latest.
//
// Although get defaults to using the latest version of the module containing
// a named package, it does not use the latest version of that module's
// dependencies. Instead it prefers to use the specific dependency versions
// requested by that module. For example, if the latest A requires module
// B v1.2.3, while B v1.2.4 and v1.3.1 are also available, then 'go get A'
// will use the latest A but then use B v1.2.3, as requested by A. (If there
// are competing requirements for a particular module, then 'go get' resolves
// those requirements by taking the maximum requested version.)
//
// The -t flag instructs get to consider modules needed to build tests of
// packages specified on the command line.
//
// The -u flag instructs get to update modules providing dependencies
// of packages named on the command line to use newer minor or patch
// releases when available. Continuing the previous example, 'go get -u A'
// will use the latest A with B v1.3.1 (not B v1.2.3). If B requires module C,
// but C does not provide any packages needed to build packages in A
// (not including tests), then C will not be updated.
//
// The -u=patch flag (not -u patch) also instructs get to update dependencies,
// but changes the default to select patch releases.
// Continuing the previous example,
// 'go get -u=patch A@latest' will use the latest A with B v1.2.4 (not B v1.2.3),
// while 'go get -u=patch A' will use a patch release of A instead.
//
// When the -t and -u flags are used together, get will update
// test dependencies as well.
//
// In general, adding a new dependency may require upgrading
// existing dependencies to keep a working build, and 'go get' does
// this automatically. Similarly, downgrading one dependency may
// require downgrading other dependencies, and 'go get' does
// this automatically as well.
//
// The -insecure flag permits fetching from repositories and resolving
// custom domains using insecure schemes such as HTTP. Use with caution.
//
// The second step is to download (if needed), build, and install
// the named packages.
//
// If an argument names a module but not a package (because there is no
// Go source code in the module's root directory), then the install step
// is skipped for that argument, instead of causing a build failure.
// For example 'go get golang.org/x/perf' succeeds even though there
// is no code corresponding to that import path.
//
// Note that package patterns are allowed and are expanded after resolving
// the module versions. For example, 'go get golang.org/x/perf/cmd/...'
// adds the latest golang.org/x/perf and then installs the commands in that
// latest version.
//
// The -d flag instructs get to download the source code needed to build
// the named packages, including downloading necessary dependencies,
// but not to build and install them.
//
// With no package arguments, 'go get' applies to Go package in the
// current directory, if any. In particular, 'go get -u' and
// 'go get -u=patch' update all the dependencies of that package.
// With no package arguments and also without -u, 'go get' is not much more
// than 'go install', and 'go get -d' not much more than 'go list'.
//
// For more about modules, see 'go help modules'.
//
// For more about specifying packages, see 'go help packages'.
//
// This text describes the behavior of get using modules to manage source
// code and dependencies. If instead the go command is running in GOPATH
// mode, the details of get's flags and effects change, as does 'go help get'.
// See 'go help modules' and 'go help gopath-get'.
//
// See also: go build, go install, go clean, go mod.
//
//
// Compile and install packages and dependencies
//
// Usage:
//
// 	go install [-i] [build flags] [packages]
//
// Install compiles and installs the packages named by the import paths.
//
// Executables are installed in the directory named by the GOBIN environment
// variable, which defaults to $GOPATH/bin or $HOME/go/bin if the GOPATH
// environment variable is not set. Executables in $GOROOT
// are installed in $GOROOT/bin or $GOTOOLDIR instead of $GOBIN.
//
// When module-aware mode is disabled, other packages are installed in the
// directory $GOPATH/pkg/$GOOS_$GOARCH. When module-aware mode is enabled,
// other packages are built and cached but not installed.
//
// The -i flag installs the dependencies of the named packages as well.
//
// For more about the build flags, see 'go help build'.
// For more about specifying packages, see 'go help packages'.
//
// See also: go build, go get, go clean.
//
//
// List packages or modules
//
// Usage:
//
// 	go list [-f format] [-json] [-m] [list flags] [build flags] [packages]
//
// List lists the named packages, one per line.
// The most commonly-used flags are -f and -json, which control the form
// of the output printed for each package. Other list flags, documented below,
// control more specific details.
//
// The default output shows the package import path:
//
//     bytes
//     encoding/json
//     github.com/gorilla/mux
//     golang.org/x/net/html
//
// The -f flag specifies an alternate format for the list, using the
// syntax of package template. The default output is equivalent
// to -f '{{.ImportPath}}'. The struct being passed to the template is:
//
//     type Package struct {
//         Dir           string   // directory containing package sources
//         ImportPath    string   // import path of package in dir
//         ImportComment string   // path in import comment on package statement
//         Name          string   // package name
//         Doc           string   // package documentation string
//         Target        string   // install path
//         Shlib         string   // the shared library that contains this package (only set when -linkshared)
//         Goroot        bool     // is this package in the Go root?
//         Standard      bool     // is this package part of the standard Go library?
//         Stale         bool     // would 'go install' do anything for this package?
//         StaleReason   string   // explanation for Stale==true
//         Root          string   // Go root or Go path dir containing this package
//         ConflictDir   string   // this directory shadows Dir in $GOPATH
//         BinaryOnly    bool     // binary-only package (no longer supported)
//         ForTest       string   // package is only for use in named test
//         Export        string   // file containing export data (when using -export)
//         Module        *Module  // info about package's containing module, if any (can be nil)
//         Match         []string // command-line patterns matching this package
//         DepOnly       bool     // package is only a dependency, not explicitly listed
//
//         // Source files
//         GoFiles         []string // .go source files (excluding CgoFiles, TestGoFiles, XTestGoFiles)
//         CgoFiles        []string // .go source files that import "C"
//         CompiledGoFiles []string // .go files presented to compiler (when using -compiled)
//         IgnoredGoFiles  []string // .go source files ignored due to build constraints
//         CFiles          []string // .c source files
//         CXXFiles        []string // .cc, .cxx and .cpp source files
//         MFiles          []string // .m source files
//         HFiles          []string // .h, .hh, .hpp and .hxx source files
//         FFiles          []string // .f, .F, .for and .f90 Fortran source files
//         SFiles          []string // .s source files
//         SwigFiles       []string // .swig files
//         SwigCXXFiles    []string // .swigcxx files
//         SysoFiles       []string // .syso object files to add to archive
//         TestGoFiles     []string // _test.go files in package
//         XTestGoFiles    []string // _test.go files outside package
//
//         // Cgo directives
//         CgoCFLAGS    []string // cgo: flags for C compiler
//         CgoCPPFLAGS  []string // cgo: flags for C preprocessor
//         CgoCXXFLAGS  []string // cgo: flags for C++ compiler
//         CgoFFLAGS    []string // cgo: flags for Fortran compiler
//         CgoLDFLAGS   []string // cgo: flags for linker
//         CgoPkgConfig []string // cgo: pkg-config names
//
//         // Dependency information
//         Imports      []string          // import paths used by this package
//         ImportMap    map[string]string // map from source import to ImportPath (identity entries omitted)
//         Deps         []string          // all (recursively) imported dependencies
//         TestImports  []string          // imports from TestGoFiles
//         XTestImports []string          // imports from XTestGoFiles
//
//         // Error information
//         Incomplete bool            // this package or a dependency has an error
//         Error      *PackageError   // error loading package
//         DepsErrors []*PackageError // errors loading dependencies
//     }
//
// Packages stored in vendor directories report an ImportPath that includes the
// path to the vendor directory (for example, "d/vendor/p" instead of "p"),
// so that the ImportPath uniquely identifies a given copy of a package.
// The Imports, Deps, TestImports, and XTestImports lists also contain these
// expanded import paths. See golang.org/s/go15vendor for more about vendoring.
//
// The error information, if any, is
//
//     type PackageError struct {
//         ImportStack   []string // shortest path from package named on command line to this one
//         Pos           string   // position of error (if present, file:line:col)
//         Err           string   // the error itself
//     }
//
// The module information is a Module struct, defined in the discussion
// of list -m below.
//
// The template function "join" calls strings.Join.
//
// The template function "context" returns the build context, defined as:
//
//     type Context struct {
//         GOARCH        string   // target architecture
//         GOOS          string   // target operating system
//         GOROOT        string   // Go root
//         GOPATH        string   // Go path
//         CgoEnabled    bool     // whether cgo can be used
//         UseAllFiles   bool     // use files regardless of +build lines, file names
//         Compiler      string   // compiler to assume when computing target paths
//         BuildTags     []string // build constraints to match in +build lines
//         ReleaseTags   []string // releases the current release is compatible with
//         InstallSuffix string   // suffix to use in the name of the install dir
//     }
//
// For more information about the meaning of these fields see the documentation
// for the go/build package's Context type.
//
// The -json flag causes the package data to be printed in JSON format
// instead of using the template format.
//
// The -compiled flag causes list to set CompiledGoFiles to the Go source
// files presented to the compiler. Typically this means that it repeats
// the files listed in GoFiles and then also adds the Go code generated
// by processing CgoFiles and SwigFiles. The Imports list contains the
// union of all imports from both GoFiles and CompiledGoFiles.
//
// The -deps flag causes list to iterate over not just the named packages
// but also all their dependencies. It visits them in a depth-first post-order
// traversal, so that a package is listed only after all its dependencies.
// Packages not explicitly listed on the command line will have the DepOnly
// field set to true.
//
// The -e flag changes the handling of erroneous packages, those that
// cannot be found or are malformed. By default, the list command
// prints an error to standard error for each erroneous package and
// omits the packages from consideration during the usual printing.
// With the -e flag, the list command never prints errors to standard
// error and instead processes the erroneous packages with the usual
// printing. Erroneous packages will have a non-empty ImportPath and
// a non-nil Error field; other information may or may not be missing
// (zeroed).
//
// The -export flag causes list to set the Export field to the name of a
// file containing up-to-date export information for the given package.
//
// The -find flag causes list to identify the named packages but not
// resolve their dependencies: the Imports and Deps lists will be empty.
//
// The -test flag causes list to report not only the named packages
// but also their test binaries (for packages with tests), to convey to
// source code analysis tools exactly how test binaries are constructed.
// The reported import path for a test binary is the import path of
// the package followed by a ".test" suffix, as in "math/rand.test".
// When building a test, it is sometimes necessary to rebuild certain
// dependencies specially for that test (most commonly the tested
// package itself). The reported import path of a package recompiled
// for a particular test binary is followed by a space and the name of
// the test binary in brackets, as in "math/rand [math/rand.test]"
// or "regexp [sort.test]". The ForTest field is also set to the name
// of the package being tested ("math/rand" or "sort" in the previous
// examples).
//
// The Dir, Target, Shlib, Root, ConflictDir, and Export file paths
// are all absolute paths.
//
// By default, the lists GoFiles, CgoFiles, and so on hold names of files in Dir
// (that is, paths relative to Dir, not absolute paths).
// The generated files added when using the -compiled and -test flags
// are absolute paths referring to cached copies of generated Go source files.
// Although they are Go source files, the paths may not end in ".go".
//
// The -m flag causes list to list modules instead of packages.
//
// When listing modules, the -f flag still specifies a format template
// applied to a Go struct, but now a Module struct:
//
//     type Module struct {
//         Path      string       // module path
//         Version   string       // module version
//         Versions  []string     // available module versions (with -versions)
//         Replace   *Module      // replaced by this module
//         Time      *time.Time   // time version was created
//         Update    *Module      // available update, if any (with -u)
//         Main      bool         // is this the main module?
//         Indirect  bool         // is this module only an indirect dependency of main module?
//         Dir       string       // directory holding files for this module, if any
//         GoMod     string       // path to go.mod file for this module, if any
//         GoVersion string       // go version used in module
//         Error     *ModuleError // error loading module
//     }
//
//     type ModuleError struct {
//         Err string // the error itself
//     }
//
// The default output is to print the module path and then
// information about the version and replacement if any.
// For example, 'go list -m all' might print:
//
//     my/main/module
//     golang.org/x/text v0.3.0 => /tmp/text
//     rsc.io/pdf v0.1.1
//
// The Module struct has a String method that formats this
// line of output, so that the default format is equivalent
// to -f '{{.String}}'.
//
// Note that when a module has been replaced, its Replace field
// describes the replacement module, and its Dir field is set to
// the replacement's source code, if present. (That is, if Replace
// is non-nil, then Dir is set to Replace.Dir, with no access to
// the replaced source code.)
//
// The -u flag adds information about available upgrades.
// When the latest version of a given module is newer than
// the current one, list -u sets the Module's Update field
// to information about the newer module.
// The Module's String method indicates an available upgrade by
// formatting the newer version in brackets after the current version.
// For example, 'go list -m -u all' might print:
//
//     my/main/module
//     golang.org/x/text v0.3.0 [v0.4.0] => /tmp/text
//     rsc.io/pdf v0.1.1 [v0.1.2]
//
// (For tools, 'go list -m -u -json all' may be more convenient to parse.)
//
// The -versions flag causes list to set the Module's Versions field
// to a list of all known versions of that module, ordered according
// to semantic versioning, earliest to latest. The flag also changes
// the default output format to display the module path followed by the
// space-separated version list.
//
// The arguments to list -m are interpreted as a list of modules, not packages.
// The main module is the module containing the current directory.
// The active modules are the main module and its dependencies.
// With no arguments, list -m shows the main module.
// With arguments, list -m shows the modules specified by the arguments.
// Any of the active modules can be specified by its module path.
// The special pattern "all" specifies all the active modules, first the main
// module and then dependencies sorted by module path.
// A pattern containing "..." specifies the active modules whose
// module paths match the pattern.
// A query of the form path@version specifies the result of that query,
// which is not limited to active modules.
// See 'go help modules' for more about module queries.
//
// The template function "module" takes a single string argument
// that must be a module path or query and returns the specified
// module as a Module struct. If an error occurs, the result will
// be a Module struct with a non-nil Error field.
//
// For more about build flags, see 'go help build'.
//
// For more about specifying packages, see 'go help packages'.
//
// For more about modules, see 'go help modules'.
//
//
// Module maintenance
//
// Go mod provides access to operations on modules.
//
// Note that support for modules is built into all the go commands,
// not just 'go mod'. For example, day-to-day adding, removing, upgrading,
// and downgrading of dependencies should be done using 'go get'.
// See 'go help modules' for an overview of module functionality.
//
// Usage:
//
// 	go mod <command> [arguments]
//
// The commands are:
//
// 	download    download modules to local cache
// 	edit        edit go.mod from tools or scripts
// 	graph       print module requirement graph
// 	init        initialize new module in current directory
// 	tidy        add missing and remove unused modules
// 	vendor      make vendored copy of dependencies
// 	verify      verify dependencies have expected content
// 	why         explain why packages or modules are needed
//
// Use "go help mod <command>" for more information about a command.
//
// Download modules to local cache
//
// Usage:
//
// 	go mod download [-json] [modules]
//
// Download downloads the named modules, which can be module patterns selecting
// dependencies of the main module or module queries of the form path@version.
// With no arguments, download applies to all dependencies of the main module.
//
// The go command will automatically download modules as needed during ordinary
// execution. The "go mod download" command is useful mainly for pre-filling
// the local cache or to compute the answers for a Go module proxy.
//
// By default, download reports errors to standard error but is otherwise silent.
// The -json flag causes download to print a sequence of JSON objects
// to standard output, describing each downloaded module (or failure),
// corresponding to this Go struct:
//
//     type Module struct {
//         Path     string // module path
//         Version  string // module version
//         Error    string // error loading module
//         Info     string // absolute path to cached .info file
//         GoMod    string // absolute path to cached .mod file
//         Zip      string // absolute path to cached .zip file
//         Dir      string // absolute path to cached source root directory
//         Sum      string // checksum for path, version (as in go.sum)
//         GoModSum string // checksum for go.mod (as in go.sum)
//         Latest   bool   // would @latest resolve to this version?
//     }
//
// See 'go help modules' for more about module queries.
//
//
// Edit go.mod from tools or scripts
//
// Usage:
//
// 	go mod edit [editing flags] [go.mod]
//
// Edit provides a command-line interface for editing go.mod,
// for use primarily by tools or scripts. It reads only go.mod;
// it does not look up information about the modules involved.
// By default, edit reads and writes the go.mod file of the main module,
// but a different target file can be specified after the editing flags.
//
// The editing flags specify a sequence of editing operations.
//
// The -fmt flag reformats the go.mod file without making other changes.
// This reformatting is also implied by any other modifications that use or
// rewrite the go.mod file. The only time this flag is needed is if no other
// flags are specified, as in 'go mod edit -fmt'.
//
// The -module flag changes the module's path (the go.mod file's module line).
//
// The -require=path@version and -droprequire=path flags
// add and drop a requirement on the given module path and version.
// Note that -require overrides any existing requirements on path.
// These flags are mainly for tools that understand the module graph.
// Users should prefer 'go get path@version' or 'go get path@none',
// which make other go.mod adjustments as needed to satisfy
// constraints imposed by other modules.
//
// The -exclude=path@version and -dropexclude=path@version flags
// add and drop an exclusion for the given module path and version.
// Note that -exclude=path@version is a no-op if that exclusion already exists.
//
// The -replace=old[@v]=new[@v] and -dropreplace=old[@v] flags
// add and drop a replacement of the given module path and version pair.
// If the @v in old@v is omitted, the replacement applies to all versions
// with the old module path. If the @v in new@v is omitted, the new path
// should be a local module root directory, not a module path.
// Note that -replace overrides any existing replacements for old[@v].
//
// The -require, -droprequire, -exclude, -dropexclude, -replace,
// and -dropreplace editing flags may be repeated, and the changes
// are applied in the order given.
//
// The -go=version flag sets the expected Go language version.
//
// The -print flag prints the final go.mod in its text format instead of
// writing it back to go.mod.
//
// The -json flag prints the final go.mod file in JSON format instead of
// writing it back to go.mod. The JSON output corresponds to these Go types:
//
// 	type Module struct {
// 		Path string
// 		Version string
// 	}
//
// 	type GoMod struct {
// 		Module  Module
// 		Go      string
// 		Require []Require
// 		Exclude []Module
// 		Replace []Replace
// 	}
//
// 	type Require struct {
// 		Path string
// 		Version string
// 		Indirect bool
// 	}
//
// 	type Replace struct {
// 		Old Module
// 		New Module
// 	}
//
// Note that this only describes the go.mod file itself, not other modules
// referred to indirectly. For the full set of modules available to a build,
// use 'go list -m -json all'.
//
// For example, a tool can obtain the go.mod as a data structure by
// parsing the output of 'go mod edit -json' and can then make changes
// by invoking 'go mod edit' with -require, -exclude, and so on.
//
//
// Print module requirement graph
//
// Usage:
//
// 	go mod graph
//
// Graph prints the module requirement graph (with replacements applied)
// in text form. Each line in the output has two space-separated fields: a module
// and one of its requirements. Each module is identified as a string of the form
// path@version, except for the main module, which has no @version suffix.
//
//
// Initialize new module in current directory
//
// Usage:
//
// 	go mod init [module]
//
// Init initializes and writes a new go.mod to the current directory,
// in effect creating a new module rooted at the current directory.
// The file go.mod must not already exist.
// If possible, init will guess the module path from import comments
// (see 'go help importpath') or from version control configuration.
// To override this guess, supply the module path as an argument.
//
//
// Add missing and remove unused modules
//
// Usage:
//
// 	go mod tidy [-v]
//
// Tidy makes sure go.mod matches the source code in the module.
// It adds any missing modules necessary to build the current module's
// packages and dependencies, and it removes unused modules that
// don't provide any relevant packages. It also adds any missing entries
// to go.sum and removes any unnecessary ones.
//
// The -v flag causes tidy to print information about removed modules
// to standard error.
//
//
// Make vendored copy of dependencies
//
// Usage:
//
// 	go mod vendor [-v]
//
// Vendor resets the main module's vendor directory to include all packages
// needed to build and test all the main module's packages.
// It does not include test code for vendored packages.
//
// The -v flag causes vendor to print the names of vendored
// modules and packages to standard error.
//
//
// Verify dependencies have expected content
//
// Usage:
//
// 	go mod verify
//
// Verify checks that the dependencies of the current module,
// which are stored in a local downloaded source cache, have not been
// modified since being downloaded. If all the modules are unmodified,
// verify prints "all modules verified." Otherwise it reports which
// modules have been changed and causes 'go mod' to exit with a
// non-zero status.
//
//
// Explain why packages or modules are needed
//
// Usage:
//
// 	go mod why [-m] [-vendor] packages...
//
// Why shows a shortest path in the import graph from the main module to
// each of the listed packages. If the -m flag is given, why treats the
// arguments as a list of modules and finds a path to any package in each
// of the modules.
//
// By default, why queries the graph of packages matched by "go list all",
// which includes tests for reachable packages. The -vendor flag causes why
// to exclude tests of dependencies.
//
// The output is a sequence of stanzas, one for each package or module
// name on the command line, separated by blank lines. Each stanza begins
// with a comment line "# package" or "# module" giving the target
// package or module. Subsequent lines give a path through the import
// graph, one package per line. If the package or module is not
// referenced from the main module, the stanza will display a single
// parenthesized note indicating that fact.
//
// For example:
//
// 	$ go mod why golang.org/x/text/language golang.org/x/text/encoding
// 	# golang.org/x/text/language
// 	rsc.io/quote
// 	rsc.io/sampler
// 	golang.org/x/text/language
//
// 	# golang.org/x/text/encoding
// 	(main module does not need package golang.org/x/text/encoding)
// 	$
//
//
// Compile and run Go program
//
// Usage:
//
// 	go run [build flags] [-exec xprog] package [arguments...]
//
// Run compiles and runs the named main Go package.
// Typically the package is specified as a list of .go source files from a single directory,
// but it may also be an import path, file system path, or pattern
// matching a single known package, as in 'go run .' or 'go run my/cmd'.
//
// By default, 'go run' runs the compiled binary directly: 'a.out arguments...'.
// If the -exec flag is given, 'go run' invokes the binary using xprog:
// 	'xprog a.out arguments...'.
// If the -exec flag is not given, GOOS or GOARCH is different from the system
// default, and a program named go_$GOOS_$GOARCH_exec can be found
// on the current search path, 'go run' invokes the binary using that program,
// for example 'go_nacl_386_exec a.out arguments...'. This allows execution of
// cross-compiled programs when a simulator or other execution method is
// available.
//
// The exit status of Run is not the exit status of the compiled binary.
//
// For more about build flags, see 'go help build'.
// For more about specifying packages, see 'go help packages'.
//
// See also: go build.
//
//
// Test packages
//
// Usage:
//
// 	go test [build/test flags] [packages] [build/test flags & test binary flags]
//
// 'Go test' automates testing the packages named by the import paths.
// It prints a summary of the test results in the format:
//
// 	ok   archive/tar   0.011s
// 	FAIL archive/zip   0.022s
// 	ok   compress/gzip 0.033s
// 	...
//
// followed by detailed output for each failed package.
//
// 'Go test' recompiles each package along with any files with names matching
// the file pattern "*_test.go".
// These additional files can contain test functions, benchmark functions, and
// example functions. See 'go help testfunc' for more.
// Each listed package causes the execution of a separate test binary.
// Files whose names begin with "_" (including "_test.go") or "." are ignored.
//
// Test files that declare a package with the suffix "_test" will be compiled as a
// separate package, and then linked and run with the main test binary.
//
// The go tool will ignore a directory named "testdata", making it available
// to hold ancillary data needed by the tests.
//
// As part of building a test binary, go test runs go vet on the package
// and its test source files to identify significant problems. If go vet
// finds any problems, go test reports those and does not run the test
// binary. Only a high-confidence subset of the default go vet checks are
// used. That subset is: 'atomic', 'bool', 'buildtags', 'nilfunc', and
// 'printf'. You can see the documentation for these and other vet tests
// via "go doc cmd/vet". To disable the running of go vet, use the
// -vet=off flag.
//
// All test output and summary lines are printed to the go command's
// standard output, even if the test printed them to its own standard
// error. (The go command's standard error is reserved for printing
// errors building the tests.)
//
// Go test runs in two different modes:
//
// The first, called local directory mode, occurs when go test is
// invoked with no package arguments (for example, 'go test' or 'go
// test -v'). In this mode, go test compiles the package sources and
// tests found in the current directory and then runs the resulting
// test binary. In this mode, caching (discussed below) is disabled.
// After the package test finishes, go test prints a summary line
// showing the test status ('ok' or 'FAIL'), package name, and elapsed
// time.
//
// The second, called package list mode, occurs when go test is invoked
// with explicit package arguments (for example 'go test math', 'go
// test ./...', and even 'go test .'). In this mode, go test compiles
// and tests each of the packages listed on the command line. If a
// package test passes, go test prints only the final 'ok' summary
// line. If a package test fails, go test prints the full test output.
// If invoked with the -bench or -v flag, go test prints the full
// output even for passing package tests, in order to display the
// requested benchmark results or verbose logging. After the package
// tests for all of the listed packages finish, and their output is
// printed, go test prints a final 'FAIL' status if any package test
// has failed.
//
// In package list mode only, go test caches successful package test
// results to avoid unnecessary repeated running of tests. When the
// result of a test can be recovered from the cache, go test will
// redisplay the previous output instead of running the test binary
// again. When this happens, go test prints '(cached)' in place of the
// elapsed time in the summary line.
//
// The rule for a match in the cache is that the run involves the same
// test binary and the flags on the command line come entirely from a
// restricted set of 'cacheable' test flags, defined as -cpu, -list,
// -parallel, -run, -short, and -v. If a run of go test has any test
// or non-test flags outside this set, the result is not cached. To
// disable test caching, use any test flag or argument other than the
// cacheable flags. The idiomatic way to disable test caching explicitly
// is to use -count=1. Tests that open files within the package's source
// root (usually $GOPATH) or that consult environment variables only
// match future runs in which the files and environment variables are unchanged.
// A cached test result is treated as executing in no time at all,
// so a successful package test result will be cached and reused
// regardless of -timeout setting.
//
// In addition to the build flags, the flags handled by 'go test' itself are:
//
// 	-args
// 	    Pass the remainder of the command line (everything after -args)
// 	    to the test binary, uninterpreted and unchanged.
// 	    Because this flag consumes the remainder of the command line,
// 	    the package list (if present) must appear before this flag.
//
// 	-c
// 	    Compile the test binary to pkg.test but do not run it
// 	    (where pkg is the last element of the package's import path).
// 	    The file name can be changed with the -o flag.
//
// 	-exec xprog
// 	    Run the test binary using xprog. The behavior is the same as
// 	    in 'go run'. See 'go help run' for details.
//
// 	-i
// 	    Install packages that are dependencies of the test.
// 	    Do not run the test.
//
// 	-json
// 	    Convert test output to JSON suitable for automated processing.
// 	    See 'go doc test2json' for the encoding details.
//
// 	-o file
// 	    Compile the test binary to the named file.
// 	    The test still runs (unless -c or -i is specified).
//
// The test binary also accepts flags that control execution of the test; these
// flags are also accessible by 'go test'. See 'go help testflag' for details.
//
// For more about build flags, see 'go help build'.
// For more about specifying packages, see 'go help packages'.
//
// See also: go build, go vet.
//
//
// Run specified go tool
//
// Usage:
//
// 	go tool [-n] command [args...]
//
// Tool runs the go tool command identified by the arguments.
// With no arguments it prints the list of known tools.
//
// The -n flag causes tool to print the command that would be
// executed but not execute it.
//
// For more about each tool command, see 'go doc cmd/<command>'.
//
//
// Print Go version
//
// Usage:
//
// 	go version [-m] [-v] [file ...]
//
// Version prints the build information for Go executables.
//
// Go version reports the Go version used to build each of the named
// executable files.
//
// If no files are named on the command line, go version prints its own
// version information.
//
// If a directory is named, go version walks that directory, recursively,
// looking for recognized Go binaries and reporting their versions.
// By default, go version does not report unrecognized files found
// during a directory scan. The -v flag causes it to report unrecognized files.
//
// The -m flag causes go version to print each executable's embedded
// module version information, when available. In the output, the module
// information consists of multiple lines following the version line, each
// indented by a leading tab character.
//
// See also: go doc runtime/debug.BuildInfo.
//
//
// Report likely mistakes in packages
//
// Usage:
//
// 	go vet [-n] [-x] [-vettool prog] [build flags] [vet flags] [packages]
//
// Vet runs the Go vet command on the packages named by the import paths.
//
// For more about vet and its flags, see 'go doc cmd/vet'.
// For more about specifying packages, see 'go help packages'.
// For a list of checkers and their flags, see 'go tool vet help'.
// For details of a specific checker such as 'printf', see 'go tool vet help printf'.
//
// The -n flag prints commands that would be executed.
// The -x flag prints commands as they are executed.
//
// The -vettool=prog flag selects a different analysis tool with alternative
// or additional checks.
// For example, the 'shadow' analyzer can be built and run using these commands:
//
//   go install golang.org/x/tools/go/analysis/passes/shadow/cmd/shadow
//   go vet -vettool=$(which shadow)
//
// The build flags supported by go vet are those that control package resolution
// and execution, such as -n, -x, -v, -tags, and -toolexec.
// For more about these flags, see 'go help build'.
//
// See also: go fmt, go fix.
//
//
// Build modes
//
// The 'go build' and 'go install' commands take a -buildmode argument which
// indicates which kind of object file is to be built. Currently supported values
// are:
//
// 	-buildmode=archive
// 		Build the listed non-main packages into .a files. Packages named
// 		main are ignored.
//
// 	-buildmode=c-archive
// 		Build the listed main package, plus all packages it imports,
// 		into a C archive file. The only callable symbols will be those
// 		functions exported using a cgo //export comment. Requires
// 		exactly one main package to be listed.
//
// 	-buildmode=c-shared
// 		Build the listed main package, plus all packages it imports,
// 		into a C shared library. The only callable symbols will
// 		be those functions exported using a cgo //export comment.
// 		Requires exactly one main package to be listed.
//
// 	-buildmode=default
// 		Listed main packages are built into executables and listed
// 		non-main packages are built into .a files (the default
// 		behavior).
//
// 	-buildmode=shared
// 		Combine all the listed non-main packages into a single shared
// 		library that will be used when building with the -linkshared
// 		option. Packages named main are ignored.
//
// 	-buildmode=exe
// 		Build the listed main packages and everything they import into
// 		executables. Packages not named main are ignored.
//
// 	-buildmode=pie
// 		Build the listed main packages and everything they import into
// 		position independent executables (PIE). Packages not named
// 		main are ignored.
//
// 	-buildmode=plugin
// 		Build the listed main packages, plus all packages that they
// 		import, into a Go plugin. Packages not named main are ignored.
//
// On AIX, when linking a C program that uses a Go archive built with
// -buildmode=c-archive, you must pass -Wl,-bnoobjreorder to the C compiler.
//
//
// Calling between Go and C
//
// There are two different ways to call between Go and C/C++ code.
//
// The first is the cgo tool, which is part of the Go distribution. For
// information on how to use it see the cgo documentation (go doc cmd/cgo).
//
// The second is the SWIG program, which is a general tool for
// interfacing between languages. For information on SWIG see
// http://swig.org/. When running go build, any file with a .swig
// extension will be passed to SWIG. Any file with a .swigcxx extension
// will be passed to SWIG with the -c++ option.
//
// When either cgo or SWIG is used, go build will pass any .c, .m, .s,
// or .S files to the C compiler, and any .cc, .cpp, .cxx files to the C++
// compiler. The CC or CXX environment variables may be set to determine
// the C or C++ compiler, respectively, to use.
//
//
// Build and test caching
//
// The go command caches build outputs for reuse in future builds.
// The default location for cache data is a subdirectory named go-build
// in the standard user cache directory for the current operating system.
// Setting the GOCACHE environment variable overrides this default,
// and running 'go env GOCACHE' prints the current cache directory.
//
// The go command periodically deletes cached data that has not been
// used recently. Running 'go clean -cache' deletes all cached data.
//
// The build cache correctly accounts for changes to Go source files,
// compilers, compiler options, and so on: cleaning the cache explicitly
// should not be necessary in typical use. However, the build cache
// does not detect changes to C libraries imported with cgo.
// If you have made changes to the C libraries on your system, you
// will need to clean the cache explicitly or else use the -a build flag
// (see 'go help build') to force rebuilding of packages that
// depend on the updated C libraries.
//
// The go command also caches successful package test results.
// See 'go help test' for details. Running 'go clean -testcache' removes
// all cached test results (but not cached build results).
//
// The GODEBUG environment variable can enable printing of debugging
// information about the state of the cache:
//
// GODEBUG=gocacheverify=1 causes the go command to bypass the
// use of any cache entries and instead rebuild everything and check
// that the results match existing cache entries.
//
// GODEBUG=gocachehash=1 causes the go command to print the inputs
// for all of the content hashes it uses to construct cache lookup keys.
// The output is voluminous but can be useful for debugging the cache.
//
// GODEBUG=gocachetest=1 causes the go command to print details of its
// decisions about whether to reuse a cached test result.
//
//
// Environment variables
//
// The go command and the tools it invokes consult environment variables
// for configuration. If an environment variable is unset, the go command
// uses a sensible default setting. To see the effective setting of the
// variable <NAME>, run 'go env <NAME>'. To change the default setting,
// run 'go env -w <NAME>=<VALUE>'. Defaults changed using 'go env -w'
// are recorded in a Go environment configuration file stored in the
// per-user configuration directory, as reported by os.UserConfigDir.
// The location of the configuration file can be changed by setting
// the environment variable GOENV, and 'go env GOENV' prints the
// effective location, but 'go env -w' cannot change the default location.
// See 'go help env' for details.
//
// General-purpose environment variables:
//
// 	GCCGO
// 		The gccgo command to run for 'go build -compiler=gccgo'.
// 	GOARCH
// 		The architecture, or processor, for which to compile code.
// 		Examples are amd64, 386, arm, ppc64.
// 	GOBIN
// 		The directory where 'go install' will install a command.
// 	GOCACHE
// 		The directory where the go command will store cached
// 		information for reuse in future builds.
// 	GODEBUG
// 		Enable various debugging facilities. See 'go doc runtime'
// 		for details.
// 	GOENV
// 		The location of the Go environment configuration file.
// 		Cannot be set using 'go env -w'.
// 	GOFLAGS
// 		A space-separated list of -flag=value settings to apply
// 		to go commands by default, when the given flag is known by
// 		the current command. Each entry must be a standalone flag.
// 		Because the entries are space-separated, flag values must
// 		not contain spaces. Flags listed on the command line
// 		are applied after this list and therefore override it.
// 	GOOS
// 		The operating system for which to compile code.
// 		Examples are linux, darwin, windows, netbsd.
// 	GOPATH
// 		For more details see: 'go help gopath'.
// 	GOPROXY
// 		URL of Go module proxy. See 'go help modules'.
// 	GOPRIVATE, GONOPROXY, GONOSUMDB
// 		Comma-separated list of glob patterns (in the syntax of Go's path.Match)
// 		of module path prefixes that should always be fetched directly
// 		or that should not be compared against the checksum database.
// 		See 'go help module-private'.
// 	GOROOT
// 		The root of the go tree.
// 	GOSUMDB
// 		The name of checksum database to use and optionally its public key and
// 		URL. See 'go help module-auth'.
// 	GOTMPDIR
// 		The directory where the go command will write
// 		temporary source files, packages, and binaries.
//
// Environment variables for use with cgo:
//
// 	AR
// 		The command to use to manipulate library archives when
// 		building with the gccgo compiler.
// 		The default is 'ar'.
// 	CC
// 		The command to use to compile C code.
// 	CGO_ENABLED
// 		Whether the cgo command is supported. Either 0 or 1.
// 	CGO_CFLAGS
// 		Flags that cgo will pass to the compiler when compiling
// 		C code.
// 	CGO_CFLAGS_ALLOW
// 		A regular expression specifying additional flags to allow
// 		to appear in #cgo CFLAGS source code directives.
// 		Does not apply to the CGO_CFLAGS environment variable.
// 	CGO_CFLAGS_DISALLOW
// 		A regular expression specifying flags that must be disallowed
// 		from appearing in #cgo CFLAGS source code directives.
// 		Does not apply to the CGO_CFLAGS environment variable.
// 	CGO_CPPFLAGS, CGO_CPPFLAGS_ALLOW, CGO_CPPFLAGS_DISALLOW
// 		Like CGO_CFLAGS, CGO_CFLAGS_ALLOW, and CGO_CFLAGS_DISALLOW,
// 		but for the C preprocessor.
// 	CGO_CXXFLAGS, CGO_CXXFLAGS_ALLOW, CGO_CXXFLAGS_DISALLOW
// 		Like CGO_CFLAGS, CGO_CFLAGS_ALLOW, and CGO_CFLAGS_DISALLOW,
// 		but for the C++ compiler.
// 	CGO_FFLAGS, CGO_FFLAGS_ALLOW, CGO_FFLAGS_DISALLOW
// 		Like CGO_CFLAGS, CGO_CFLAGS_ALLOW, and CGO_CFLAGS_DISALLOW,
// 		but for the Fortran compiler.
// 	CGO_LDFLAGS, CGO_LDFLAGS_ALLOW, CGO_LDFLAGS_DISALLOW
// 		Like CGO_CFLAGS, CGO_CFLAGS_ALLOW, and CGO_CFLAGS_DISALLOW,
// 		but for the linker.
// 	CXX
// 		The command to use to compile C++ code.
// 	FC
// 		The command to use to compile Fortran code.
// 	PKG_CONFIG
// 		Path to pkg-config tool.
//
// Architecture-specific environment variables:
//
// 	GOARM
// 		For GOARCH=arm, the ARM architecture for which to compile.
// 		Valid values are 5, 6, 7.
// 	GO386
// 		For GOARCH=386, the floating point instruction set.
// 		Valid values are 387, sse2.
// 	GOMIPS
// 		For GOARCH=mips{,le}, whether to use floating point instructions.
// 		Valid values are hardfloat (default), softfloat.
// 	GOMIPS64
// 		For GOARCH=mips64{,le}, whether to use floating point instructions.
// 		Valid values are hardfloat (default), softfloat.
// 	GOWASM
// 		For GOARCH=wasm, comma-separated list of experimental WebAssembly features to use.
// 		Valid values are satconv, signext.
//
// Special-purpose environment variables:
//
// 	GCCGOTOOLDIR
// 		If set, where to find gccgo tools, such as cgo.
// 		The default is based on how gccgo was configured.
// 	GOROOT_FINAL
// 		The root of the installed Go tree, when it is
// 		installed in a location other than where it is built.
// 		File names in stack traces are rewritten from GOROOT to
// 		GOROOT_FINAL.
// 	GO_EXTLINK_ENABLED
// 		Whether the linker should use external linking mode
// 		when using -linkmode=auto with code that uses cgo.
// 		Set to 0 to disable external linking mode, 1 to enable it.
// 	GIT_ALLOW_PROTOCOL
// 		Defined by Git. A colon-separated list of schemes that are allowed
// 		to be used with git fetch/clone. If set, any scheme not explicitly
// 		mentioned will be considered insecure by 'go get'.
// 		Because the variable is defined by Git, the default value cannot
// 		be set using 'go env -w'.
//
// Additional information available from 'go env' but not read from the environment:
//
// 	GOEXE
// 		The executable file name suffix (".exe" on Windows, "" on other systems).
// 	GOGCCFLAGS
// 		A space-separated list of arguments supplied to the CC command.
// 	GOHOSTARCH
// 		The architecture (GOARCH) of the Go toolchain binaries.
// 	GOHOSTOS
// 		The operating system (GOOS) of the Go toolchain binaries.
// 	GOMOD
// 		The absolute path to the go.mod of the main module,
// 		or the empty string if not using modules.
// 	GOTOOLDIR
// 		The directory where the go tools (compile, cover, doc, etc...) are installed.
//
//
// File types
//
// The go command examines the contents of a restricted set of files
// in each directory. It identifies which files to examine based on
// the extension of the file name. These extensions are:
//
// 	.go
// 		Go source files.
// 	.c, .h
// 		C source files.
// 		If the package uses cgo or SWIG, these will be compiled with the
// 		OS-native compiler (typically gcc); otherwise they will
// 		trigger an error.
// 	.cc, .cpp, .cxx, .hh, .hpp, .hxx
// 		C++ source files. Only useful with cgo or SWIG, and always
// 		compiled with the OS-native compiler.
// 	.m
// 		Objective-C source files. Only useful with cgo, and always
// 		compiled with the OS-native compiler.
// 	.s, .S
// 		Assembler source files.
// 		If the package uses cgo or SWIG, these will be assembled with the
// 		OS-native assembler (typically gcc (sic)); otherwise they
// 		will be assembled with the Go assembler.
// 	.swig, .swigcxx
// 		SWIG definition files.
// 	.syso
// 		System object files.
//
// Files of each of these types except .syso may contain build
// constraints, but the go command stops scanning for build constraints
// at the first item in the file that is not a blank line or //-style
// line comment. See the go/build package documentation for
// more details.
//
//
// The go.mod file
//
// A module version is defined by a tree of source files, with a go.mod
// file in its root. When the go command is run, it looks in the current
// directory and then successive parent directories to find the go.mod
// marking the root of the main (current) module.
//
// The go.mod file itself is line-oriented, with // comments but
// no /* */ comments. Each line holds a single directive, made up of a
// verb followed by arguments. For example:
//
// 	module my/thing
// 	go 1.12
// 	require other/thing v1.0.2
// 	require new/thing/v2 v2.3.4
// 	exclude old/thing v1.2.3
// 	replace bad/thing v1.4.5 => good/thing v1.4.5
//
// The verbs are
// 	module, to define the module path;
// 	go, to set the expected language version;
// 	require, to require a particular module at a given version or later;
// 	exclude, to exclude a particular module version from use; and
// 	replace, to replace a module version with a different module version.
// Exclude and replace apply only in the main module's go.mod and are ignored
// in dependencies.  See https://research.swtch.com/vgo-mvs for details.
//
// The leading verb can be factored out of adjacent lines to create a block,
// like in Go imports:
//
// 	require (
// 		new/thing v2.3.4
// 		old/thing v1.2.3
// 	)
//
// The go.mod file is designed both to be edited directly and to be
// easily updated by tools. The 'go mod edit' command can be used to
// parse and edit the go.mod file from programs and tools.
// See 'go help mod edit'.
//
// The go command automatically updates go.mod each time it uses the
// module graph, to make sure go.mod always accurately reflects reality
// and is properly formatted. For example, consider this go.mod file:
//
//         module M
//
//         require (
//                 A v1
//                 B v1.0.0
//                 C v1.0.0
//                 D v1.2.3
//                 E dev
//         )
//
//         exclude D v1.2.3
//
// The update rewrites non-canonical version identifiers to semver form,
// so A's v1 becomes v1.0.0 and E's dev becomes the pseudo-version for the
// latest commit on the dev branch, perhaps v0.0.0-20180523231146-b3f5c0f6e5f1.
//
// The update modifies requirements to respect exclusions, so the
// requirement on the excluded D v1.2.3 is updated to use the next
// available version of D, perhaps D v1.2.4 or D v1.3.0.
//
// The update removes redundant or misleading requirements.
// For example, if A v1.0.0 itself requires B v1.2.0 and C v1.0.0,
// then go.mod's requirement of B v1.0.0 is misleading (superseded by
// A's need for v1.2.0), and its requirement of C v1.0.0 is redundant
// (implied by A's need for the same version), so both will be removed.
// If module M contains packages that directly import packages from B or
// C, then the requirements will be kept but updated to the actual
// versions being used.
//
// Finally, the update reformats the go.mod in a canonical formatting, so
// that future mechanical changes will result in minimal diffs.
//
// Because the module graph defines the meaning of import statements, any
// commands that load packages also use and therefore update go.mod,
// including go build, go get, go install, go list, go test, go mod graph,
// go mod tidy, and go mod why.
//
// The expected language version, set by the go directive, determines
// which language features are available when compiling the module.
// Language features available in that version will be available for use.
// Language features removed in earlier versions, or added in later versions,
// will not be available. Note that the language version does not affect
// build tags, which are determined by the Go release being used.
//
//
// GOPATH environment variable
//
// The Go path is used to resolve import statements.
// It is implemented by and documented in the go/build package.
//
// The GOPATH environment variable lists places to look for Go code.
// On Unix, the value is a colon-separated string.
// On Windows, the value is a semicolon-separated string.
// On Plan 9, the value is a list.
//
// If the environment variable is unset, GOPATH defaults
// to a subdirectory named "go" in the user's home directory
// ($HOME/go on Unix, %USERPROFILE%\go on Windows),
// unless that directory holds a Go distribution.
// Run "go env GOPATH" to see the current GOPATH.
//
// See https://golang.org/wiki/SettingGOPATH to set a custom GOPATH.
//
// Each directory listed in GOPATH must have a prescribed structure:
//
// The src directory holds source code. The path below src
// determines the import path or executable name.
//
// The pkg directory holds installed package objects.
// As in the Go tree, each target operating system and
// architecture pair has its own subdirectory of pkg
// (pkg/GOOS_GOARCH).
//
// If DIR is a directory listed in the GOPATH, a package with
// source in DIR/src/foo/bar can be imported as "foo/bar" and
// has its compiled form installed to "DIR/pkg/GOOS_GOARCH/foo/bar.a".
//
// The bin directory holds compiled commands.
// Each command is named for its source directory, but only
// the final element, not the entire path. That is, the
// command with source in DIR/src/foo/quux is installed into
// DIR/bin/quux, not DIR/bin/foo/quux. The "foo/" prefix is stripped
// so that you can add DIR/bin to your PATH to get at the
// installed commands. If the GOBIN environment variable is
// set, commands are installed to the directory it names instead
// of DIR/bin. GOBIN must be an absolute path.
//
// Here's an example directory layout:
//
//     GOPATH=/home/user/go
//
//     /home/user/go/
//         src/
//             foo/
//                 bar/               (go code in package bar)
//                     x.go
//                 quux/              (go code in package main)
//                     y.go
//         bin/
//             quux                   (installed command)
//         pkg/
//             linux_amd64/
//                 foo/
//                     bar.a          (installed package object)
//
// Go searches each directory listed in GOPATH to find source code,
// but new packages are always downloaded into the first directory
// in the list.
//
// See https://golang.org/doc/code.html for an example.
//
// GOPATH and Modules
//
// When using modules, GOPATH is no longer used for resolving imports.
// However, it is still used to store downloaded source code (in GOPATH/pkg/mod)
// and compiled commands (in GOPATH/bin).
//
// Internal Directories
//
// Code in or below a directory named "internal" is importable only
// by code in the directory tree rooted at the parent of "internal".
// Here's an extended version of the directory layout above:
//
//     /home/user/go/
//         src/
//             crash/
//                 bang/              (go code in package bang)
//                     b.go
//             foo/                   (go code in package foo)
//                 f.go
//                 bar/               (go code in package bar)
//                     x.go
//                 internal/
//                     baz/           (go code in package baz)
//                         z.go
//                 quux/              (go code in package main)
//                     y.go
//
//
// The code in z.go is imported as "foo/internal/baz", but that
// import statement can only appear in source files in the subtree
// rooted at foo. The source files foo/f.go, foo/bar/x.go, and
// foo/quux/y.go can all import "foo/internal/baz", but the source file
// crash/bang/b.go cannot.
//
// See https://golang.org/s/go14internal for details.
//
// Vendor Directories
//
// Go 1.6 includes support for using local copies of external dependencies
// to satisfy imports of those dependencies, often referred to as vendoring.
//
// Code below a directory named "vendor" is importable only
// by code in the directory tree rooted at the parent of "vendor",
// and only using an import path that omits the prefix up to and
// including the vendor element.
//
// Here's the example from the previous section,
// but with the "internal" directory renamed to "vendor"
// and a new foo/vendor/crash/bang directory added:
//
//     /home/user/go/
//         src/
//             crash/
//                 bang/              (go code in package bang)
//                     b.go
//             foo/                   (go code in package foo)
//                 f.go
//                 bar/               (go code in package bar)
//                     x.go
//                 vendor/
//                     crash/
//                         bang/      (go code in package bang)
//                             b.go
//                     baz/           (go code in package baz)
//                         z.go
//                 quux/              (go code in package main)
//                     y.go
//
// The same visibility rules apply as for internal, but the code
// in z.go is imported as "baz", not as "foo/vendor/baz".
//
// Code in vendor directories deeper in the source tree shadows
// code in higher directories. Within the subtree rooted at foo, an import
// of "crash/bang" resolves to "foo/vendor/crash/bang", not the
// top-level "crash/bang".
//
// Code in vendor directories is not subject to import path
// checking (see 'go help importpath').
//
// When 'go get' checks out or updates a git repository, it now also
// updates submodules.
//
// Vendor directories do not affect the placement of new repositories
// being checked out for the first time by 'go get': those are always
// placed in the main GOPATH, never in a vendor subtree.
//
// See https://golang.org/s/go15vendor for details.
//
//
// Legacy GOPATH go get
//
// The 'go get' command changes behavior depending on whether the
// go command is running in module-aware mode or legacy GOPATH mode.
// This help text, accessible as 'go help gopath-get' even in module-aware mode,
// describes 'go get' as it operates in legacy GOPATH mode.
//
// Usage: go get [-d] [-f] [-t] [-u] [-v] [-fix] [-insecure] [build flags] [packages]
//
// Get downloads the packages named by the import paths, along with their
// dependencies. It then installs the named packages, like 'go install'.
//
// The -d flag instructs get to stop after downloading the packages; that is,
// it instructs get not to install the packages.
//
// The -f flag, valid only when -u is set, forces get -u not to verify that
// each package has been checked out from the source control repository
// implied by its import path. This can be useful if the source is a local fork
// of the original.
//
// The -fix flag instructs get to run the fix tool on the downloaded packages
// before resolving dependencies or building the code.
//
// The -insecure flag permits fetching from repositories and resolving
// custom domains using insecure schemes such as HTTP. Use with caution.
//
// The -t flag instructs get to also download the packages required to build
// the tests for the specified packages.
//
// The -u flag instructs get to use the network to update the named packages
// and their dependencies. By default, get uses the network to check out
// missing packages but does not use it to look for updates to existing packages.
//
// The -v flag enables verbose progress and debug output.
//
// Get also accepts build flags to control the installation. See 'go help build'.
//
// When checking out a new package, get creates the target directory
// GOPATH/src/<import-path>. If the GOPATH contains multiple entries,
// get uses the first one. For more details see: 'go help gopath'.
//
// When checking out or updating a package, get looks for a branch or tag
// that matches the locally installed version of Go. The most important
// rule is that if the local installation is running version "go1", get
// searches for a branch or tag named "go1". If no such version exists
// it retrieves the default branch of the package.
//
// When go get checks out or updates a Git repository,
// it also updates any git submodules referenced by the repository.
//
// Get never checks out or updates code stored in vendor directories.
//
// For more about specifying packages, see 'go help packages'.
//
// For more about how 'go get' finds source code to
// download, see 'go help importpath'.
//
// This text describes the behavior of get when using GOPATH
// to manage source code and dependencies.
// If instead the go command is running in module-aware mode,
// the details of get's flags and effects change, as does 'go help get'.
// See 'go help modules' and 'go help module-get'.
//
// See also: go build, go install, go clean.
//
//
// Module proxy protocol
//
// A Go module proxy is any web server that can respond to GET requests for
// URLs of a specified form. The requests have no query parameters, so even
// a site serving from a fixed file system (including a file:/// URL)
// can be a module proxy.
//
// The GET requests sent to a Go module proxy are:
//
// GET $GOPROXY/<module>/@v/list returns a list of all known versions of the
// given module, one per line.
//
// GET $GOPROXY/<module>/@v/<version>.info returns JSON-formatted metadata
// about that version of the given module.
//
// GET $GOPROXY/<module>/@v/<version>.mod returns the go.mod file
// for that version of the given module.
//
// GET $GOPROXY/<module>/@v/<version>.zip returns the zip archive
// for that version of the given module.
//
// To avoid problems when serving from case-sensitive file systems,
// the <module> and <version> elements are case-encoded, replacing every
// uppercase letter with an exclamation mark followed by the corresponding
// lower-case letter: github.com/Azure encodes as github.com/!azure.
//
// The JSON-formatted metadata about a given module corresponds to
// this Go data structure, which may be expanded in the future:
//
//     type Info struct {
//         Version string    // version string
//         Time    time.Time // commit time
//     }
//
// The zip archive for a specific version of a given module is a
// standard zip file that contains the file tree corresponding
// to the module's source code and related files. The archive uses
// slash-separated paths, and every file path in the archive must
// begin with <module>@<version>/, where the module and version are
// substituted directly, not case-encoded. The root of the module
// file tree corresponds to the <module>@<version>/ prefix in the
// archive.
//
// Even when downloading directly from version control systems,
// the go command synthesizes explicit info, mod, and zip files
// and stores them in its local cache, $GOPATH/pkg/mod/cache/download,
// the same as if it had downloaded them directly from a proxy.
// The cache layout is the same as the proxy URL space, so
// serving $GOPATH/pkg/mod/cache/download at (or copying it to)
// https://example.com/proxy would let other users access those
// cached module versions with GOPROXY=https://example.com/proxy.
//
//
// Import path syntax
//
// An import path (see 'go help packages') denotes a package stored in the local
// file system. In general, an import path denotes either a standard package (such
// as "unicode/utf8") or a package found in one of the work spaces (For more
// details see: 'go help gopath').
//
// Relative import paths
//
// An import path beginning with ./ or ../ is called a relative path.
// The toolchain supports relative import paths as a shortcut in two ways.
//
// First, a relative path can be used as a shorthand on the command line.
// If you are working in the directory containing the code imported as
// "unicode" and want to run the tests for "unicode/utf8", you can type
// "go test ./utf8" instead of needing to specify the full path.
// Similarly, in the reverse situation, "go test .." will test "unicode" from
// the "unicode/utf8" directory. Relative patterns are also allowed, like
// "go test ./..." to test all subdirectories. See 'go help packages' for details
// on the pattern syntax.
//
// Second, if you are compiling a Go program not in a work space,
// you can use a relative path in an import statement in that program
// to refer to nearby code also not in a work space.
// This makes it easy to experiment with small multipackage programs
// outside of the usual work spaces, but such programs cannot be
// installed with "go install" (there is no work space in which to install them),
// so they are rebuilt from scratch each time they are built.
// To avoid ambiguity, Go programs cannot use relative import paths
// within a work space.
//
// Remote import paths
//
// Certain import paths also
// describe how to obtain the source code for the package using
// a revision control system.
//
// A few common code hosting sites have special syntax:
//
// 	Bitbucket (Git, Mercurial)
//
// 		import "bitbucket.org/user/project"
// 		import "bitbucket.org/user/project/sub/directory"
//
// 	GitHub (Git)
//
// 		import "github.com/user/project"
// 		import "github.com/user/project/sub/directory"
//
// 	Launchpad (Bazaar)
//
// 		import "launchpad.net/project"
// 		import "launchpad.net/project/series"
// 		import "launchpad.net/project/series/sub/directory"
//
// 		import "launchpad.net/~user/project/branch"
// 		import "launchpad.net/~user/project/branch/sub/directory"
//
// 	IBM DevOps Services (Git)
//
// 		import "hub.jazz.net/git/user/project"
// 		import "hub.jazz.net/git/user/project/sub/directory"
//
// For code hosted on other servers, import paths may either be qualified
// with the version control type, or the go tool can dynamically fetch
// the import path over https/http and discover where the code resides
// from a <meta> tag in the HTML.
//
// To declare the code location, an import path of the form
//
// 	repository.vcs/path
//
// specifies the given repository, with or without the .vcs suffix,
// using the named version control system, and then the path inside
// that repository. The supported version control systems are:
//
// 	Bazaar      .bzr
// 	Fossil      .fossil
// 	Git         .git
// 	Mercurial   .hg
// 	Subversion  .svn
//
// For example,
//
// 	import "example.org/user/foo.hg"
//
// denotes the root directory of the Mercurial repository at
// example.org/user/foo or foo.hg, and
//
// 	import "example.org/repo.git/foo/bar"
//
// denotes the foo/bar directory of the Git repository at
// example.org/repo or repo.git.
//
// When a version control system supports multiple protocols,
// each is tried in turn when downloading. For example, a Git
// download tries https://, then git+ssh://.
//
// By default, downloads are restricted to known secure protocols
// (e.g. https, ssh). To override this setting for Git downloads, the
// GIT_ALLOW_PROTOCOL environment variable can be set (For more details see:
// 'go help environment').
//
// If the import path is not a known code hosting site and also lacks a
// version control qualifier, the go tool attempts to fetch the import
// over https/http and looks for a <meta> tag in the document's HTML
// <head>.
//
// The meta tag has the form:
//
// 	<meta name="go-import" content="import-prefix vcs repo-root">
//
// The import-prefix is the import path corresponding to the repository
// root. It must be a prefix or an exact match of the package being
// fetched with "go get". If it's not an exact match, another http
// request is made at the prefix to verify the <meta> tags match.
//
// The meta tag should appear as early in the file as possible.
// In particular, it should appear before any raw JavaScript or CSS,
// to avoid confusing the go command's restricted parser.
//
// The vcs is one of "bzr", "fossil", "git", "hg", "svn".
//
// The repo-root is the root of the version control system
// containing a scheme and not containing a .vcs qualifier.
//
// For example,
//
// 	import "example.org/pkg/foo"
//
// will result in the following requests:
//
// 	https://example.org/pkg/foo?go-get=1 (preferred)
// 	http://example.org/pkg/foo?go-get=1  (fallback, only with -insecure)
//
// If that page contains the meta tag
//
// 	<meta name="go-import" content="example.org git https://code.org/r/p/exproj">
//
// the go tool will verify that https://example.org/?go-get=1 contains the
// same meta tag and then git clone https://code.org/r/p/exproj into
// GOPATH/src/example.org.
//
// When using GOPATH, downloaded packages are written to the first directory
// listed in the GOPATH environment variable.
// (See 'go help gopath-get' and 'go help gopath'.)
//
// When using modules, downloaded packages are stored in the module cache.
// (See 'go help module-get' and 'go help goproxy'.)
//
// When using modules, an additional variant of the go-import meta tag is
// recognized and is preferred over those listing version control systems.
// That variant uses "mod" as the vcs in the content value, as in:
//
// 	<meta name="go-import" content="example.org mod https://code.org/moduleproxy">
//
// This tag means to fetch modules with paths beginning with example.org
// from the module proxy available at the URL https://code.org/moduleproxy.
// See 'go help goproxy' for details about the proxy protocol.
//
// Import path checking
//
// When the custom import path feature described above redirects to a
// known code hosting site, each of the resulting packages has two possible
// import paths, using the custom domain or the known hosting site.
//
// A package statement is said to have an "import comment" if it is immediately
// followed (before the next newline) by a comment of one of these two forms:
//
// 	package math // import "path"
// 	package math /* import "path" */
//
// The go command will refuse to install a package with an import comment
// unless it is being referred to by that import path. In this way, import comments
// let package authors make sure the custom import path is used and not a
// direct path to the underlying code hosting site.
//
// Import path checking is disabled for code found within vendor trees.
// This makes it possible to copy code into alternate locations in vendor trees
// without needing to update import comments.
//
// Import path checking is also disabled when using modules.
// Import path comments are obsoleted by the go.mod file's module statement.
//
// See https://golang.org/s/go14customimport for details.
//
//
// Modules, module versions, and more
//
// A module is a collection of related Go packages.
// Modules are the unit of source code interchange and versioning.
// The go command has direct support for working with modules,
// including recording and resolving dependencies on other modules.
// Modules replace the old GOPATH-based approach to specifying
// which source files are used in a given build.
//
// Module support
//
// Go 1.13 includes support for Go modules. Module-aware mode is active by default
// whenever a go.mod file is found in, or in a parent of, the current directory.
//
// The quickest way to take advantage of module support is to check out your
// repository, create a go.mod file (described in the next section) there, and run
// go commands from within that file tree.
//
// For more fine-grained control, Go 1.13 continues to respect
// a temporary environment variable, GO111MODULE, which can be set to one
// of three string values: off, on, or auto (the default).
// If GO111MODULE=on, then the go command requires the use of modules,
// never consulting GOPATH. We refer to this as the command
// being module-aware or running in "module-aware mode".
// If GO111MODULE=off, then the go command never uses
// module support. Instead it looks in vendor directories and GOPATH
// to find dependencies; we now refer to this as "GOPATH mode."
// If GO111MODULE=auto or is unset, then the go command enables or disables
// module support based on the current directory.
// Module support is enabled only when the current directory contains a
// go.mod file or is below a directory containing a go.mod file.
//
// In module-aware mode, GOPATH no longer defines the meaning of imports
// during a build, but it still stores downloaded dependencies (in GOPATH/pkg/mod)
// and installed commands (in GOPATH/bin, unless GOBIN is set).
//
// Defining a module
//
// A module is defined by a tree of Go source files with a go.mod file
// in the tree's root directory. The directory containing the go.mod file
// is called the module root. Typically the module root will also correspond
// to a source code repository root (but in general it need not).
// The module is the set of all Go packages in the module root and its
// subdirectories, but excluding subtrees with their own go.mod files.
//
// The "module path" is the import path prefix corresponding to the module root.
// The go.mod file defines the module path and lists the specific versions
// of other modules that should be used when resolving imports during a build,
// by giving their module paths and versions.
//
// For example, this go.mod declares that the directory containing it is the root
// of the module with path example.com/m, and it also declares that the module
// depends on specific versions of golang.org/x/text and gopkg.in/yaml.v2:
//
// 	module example.com/m
//
// 	require (
// 		golang.org/x/text v0.3.0
// 		gopkg.in/yaml.v2 v2.1.0
// 	)
//
// The go.mod file can also specify replacements and excluded versions
// that only apply when building the module directly; they are ignored
// when the module is incorporated into a larger build.
// For more about the go.mod file, see 'go help go.mod'.
//
// To start a new module, simply create a go.mod file in the root of the
// module's directory tree, containing only a module statement.
// The 'go mod init' command can be used to do this:
//
// 	go mod init example.com/m
//
// In a project already using an existing dependency management tool like
// godep, glide, or dep, 'go mod init' will also add require statements
// matching the existing configuration.
//
// Once the go.mod file exists, no additional steps are required:
// go commands like 'go build', 'go test', or even 'go list' will automatically
// add new dependencies as needed to satisfy imports.
//
// The main module and the build list
//
// The "main module" is the module containing the directory where the go command
// is run. The go command finds the module root by looking for a go.mod in the
// current directory, or else the current directory's parent directory,
// or else the parent's parent directory, and so on.
//
// The main module's go.mod file defines the precise set of packages available
// for use by the go command, through require, replace, and exclude statements.
// Dependency modules, found by following require statements, also contribute
// to the definition of that set of packages, but only through their go.mod
// files' require statements: any replace and exclude statements in dependency
// modules are ignored. The replace and exclude statements therefore allow the
// main module complete control over its own build, without also being subject
// to complete control by dependencies.
//
// The set of modules providing packages to builds is called the "build list".
// The build list initially contains only the main module. Then the go command
// adds to the list the exact module versions required by modules already
// on the list, recursively, until there is nothing left to add to the list.
// If multiple versions of a particular module are added to the list,
// then at the end only the latest version (according to semantic version
// ordering) is kept for use in the build.
//
// The 'go list' command provides information about the main module
// and the build list. For example:
//
// 	go list -m              # print path of main module
// 	go list -m -f={{.Dir}}  # print root directory of main module
// 	go list -m all          # print build list
//
// Maintaining module requirements
//
// The go.mod file is meant to be readable and editable by both
// programmers and tools. The go command itself automatically updates the go.mod file
// to maintain a standard formatting and the accuracy of require statements.
//
// Any go command that finds an unfamiliar import will look up the module
// containing that import and add the latest version of that module
// to go.mod automatically. In most cases, therefore, it suffices to
// add an import to source code and run 'go build', 'go test', or even 'go list':
// as part of analyzing the package, the go command will discover
// and resolve the import and update the go.mod file.
//
// Any go command can determine that a module requirement is
// missing and must be added, even when considering only a single
// package from the module. On the other hand, determining that a module requirement
// is no longer necessary and can be deleted requires a full view of
// all packages in the module, across all possible build configurations
// (architectures, operating systems, build tags, and so on).
// The 'go mod tidy' command builds that view and then
// adds any missing module requirements and removes unnecessary ones.
//
// As part of maintaining the require statements in go.mod, the go command
// tracks which ones provide packages imported directly by the current module
// and which ones provide packages only used indirectly by other module
// dependencies. Requirements needed only for indirect uses are marked with a
// "// indirect" comment in the go.mod file. Indirect requirements are
// automatically removed from the go.mod file once they are implied by other
// direct requirements. Indirect requirements only arise when using modules
// that fail to state some of their own dependencies or when explicitly
// upgrading a module's dependencies ahead of its own stated requirements.
//
// Because of this automatic maintenance, the information in go.mod is an
// up-to-date, readable description of the build.
//
// The 'go get' command updates go.mod to change the module versions used in a
// build. An upgrade of one module may imply upgrading others, and similarly a
// downgrade of one module may imply downgrading others. The 'go get' command
// makes these implied changes as well. If go.mod is edited directly, commands
// like 'go build' or 'go list' will assume that an upgrade is intended and
// automatically make any implied upgrades and update go.mod to reflect them.
//
// The 'go mod' command provides other functionality for use in maintaining
// and understanding modules and go.mod files. See 'go help mod'.
//
// The -mod build flag provides additional control over updating and use of go.mod.
//
// If invoked with -mod=readonly, the go command is disallowed from the implicit
// automatic updating of go.mod described above. Instead, it fails when any changes
// to go.mod are needed. This setting is most useful to check that go.mod does
// not need updates, such as in a continuous integration and testing system.
// The "go get" command remains permitted to update go.mod even with -mod=readonly,
// and the "go mod" commands do not take the -mod flag (or any other build flags).
//
// If invoked with -mod=vendor, the go command assumes that the vendor
// directory holds the correct copies of dependencies and ignores
// the dependency descriptions in go.mod.
//
// Pseudo-versions
//
// The go.mod file and the go command more generally use semantic versions as
// the standard form for describing module versions, so that versions can be
// compared to determine which should be considered earlier or later than another.
// A module version like v1.2.3 is introduced by tagging a revision in the
// underlying source repository. Untagged revisions can be referred to
// using a "pseudo-version" like v0.0.0-yyyymmddhhmmss-abcdefabcdef,
// where the time is the commit time in UTC and the final suffix is the prefix
// of the commit hash. The time portion ensures that two pseudo-versions can
// be compared to determine which happened later, the commit hash identifes
// the underlying commit, and the prefix (v0.0.0- in this example) is derived from
// the most recent tagged version in the commit graph before this commit.
//
// There are three pseudo-version forms:
//
// vX.0.0-yyyymmddhhmmss-abcdefabcdef is used when there is no earlier
// versioned commit with an appropriate major version before the target commit.
// (This was originally the only form, so some older go.mod files use this form
// even for commits that do follow tags.)
//
// vX.Y.Z-pre.0.yyyymmddhhmmss-abcdefabcdef is used when the most
// recent versioned commit before the target commit is vX.Y.Z-pre.
//
// vX.Y.(Z+1)-0.yyyymmddhhmmss-abcdefabcdef is used when the most
// recent versioned commit before the target commit is vX.Y.Z.
//
// Pseudo-versions never need to be typed by hand: the go command will accept
// the plain commit hash and translate it into a pseudo-version (or a tagged
// version if available) automatically. This conversion is an example of a
// module query.
//
// Module queries
//
// The go command accepts a "module query" in place of a module version
// both on the command line and in the main module's go.mod file.
// (After evaluating a query found in the main module's go.mod file,
// the go command updates the file to replace the query with its result.)
//
// A fully-specified semantic version, such as "v1.2.3",
// evaluates to that specific version.
//
// A semantic version prefix, such as "v1" or "v1.2",
// evaluates to the latest available tagged version with that prefix.
//
// A semantic version comparison, such as "<v1.2.3" or ">=v1.5.6",
// evaluates to the available tagged version nearest to the comparison target
// (the latest version for < and <=, the earliest version for > and >=).
//
// The string "latest" matches the latest available tagged version,
// or else the underlying source repository's latest untagged revision.
//
// The string "upgrade" is like "latest", but if the module is
// currently required at a later version than the version "latest"
// would select (for example, a newer pre-release version), "upgrade"
// will select the later version instead.
//
// The string "patch" matches the latest available tagged version
// of a module with the same major and minor version numbers as the
// currently required version. If no version is currently required,
// "patch" is equivalent to "latest".
//
// A revision identifier for the underlying source repository, such as
// a commit hash prefix, revision tag, or branch name, selects that
// specific code revision. If the revision is also tagged with a
// semantic version, the query evaluates to that semantic version.
// Otherwise the query evaluates to a pseudo-version for the commit.
// Note that branches and tags with names that are matched by other
// query syntax cannot be selected this way. For example, the query
// "v2" means the latest version starting with "v2", not the branch
// named "v2".
//
// All queries prefer release versions to pre-release versions.
// For example, "<v1.2.3" will prefer to return "v1.2.2"
// instead of "v1.2.3-pre1", even though "v1.2.3-pre1" is nearer
// to the comparison target.
//
// Module versions disallowed by exclude statements in the
// main module's go.mod are considered unavailable and cannot
// be returned by queries.
//
// For example, these commands are all valid:
//
// 	go get github.com/gorilla/mux@latest    # same (@latest is default for 'go get')
// 	go get github.com/gorilla/mux@v1.6.2    # records v1.6.2
// 	go get github.com/gorilla/mux@e3702bed2 # records v1.6.2
// 	go get github.com/gorilla/mux@c856192   # records v0.0.0-20180517173623-c85619274f5d
// 	go get github.com/gorilla/mux@master    # records current meaning of master
//
// Module compatibility and semantic versioning
//
// The go command requires that modules use semantic versions and expects that
// the versions accurately describe compatibility: it assumes that v1.5.4 is a
// backwards-compatible replacement for v1.5.3, v1.4.0, and even v1.0.0.
// More generally the go command expects that packages follow the
// "import compatibility rule", which says:
//
// "If an old package and a new package have the same import path,
// the new package must be backwards compatible with the old package."
//
// Because the go command assumes the import compatibility rule,
// a module definition can only set the minimum required version of one
// of its dependencies: it cannot set a maximum or exclude selected versions.
// Still, the import compatibility rule is not a guarantee: it may be that
// v1.5.4 is buggy and not a backwards-compatible replacement for v1.5.3.
// Because of this, the go command never updates from an older version
// to a newer version of a module unasked.
//
// In semantic versioning, changing the major version number indicates a lack
// of backwards compatibility with earlier versions. To preserve import
// compatibility, the go command requires that modules with major version v2
// or later use a module path with that major version as the final element.
// For example, version v2.0.0 of example.com/m must instead use module path
// example.com/m/v2, and packages in that module would use that path as
// their import path prefix, as in example.com/m/v2/sub/pkg. Including the
// major version number in the module path and import paths in this way is
// called "semantic import versioning". Pseudo-versions for modules with major
// version v2 and later begin with that major version instead of v0, as in
// v2.0.0-20180326061214-4fc5987536ef.
//
// As a special case, module paths beginning with gopkg.in/ continue to use the
// conventions established on that system: the major version is always present,
// and it is preceded by a dot instead of a slash: gopkg.in/yaml.v1
// and gopkg.in/yaml.v2, not gopkg.in/yaml and gopkg.in/yaml/v2.
//
// The go command treats modules with different module paths as unrelated:
// it makes no connection between example.com/m and example.com/m/v2.
// Modules with different major versions can be used together in a build
// and are kept separate by the fact that their packages use different
// import paths.
//
// In semantic versioning, major version v0 is for initial development,
// indicating no expectations of stability or backwards compatibility.
// Major version v0 does not appear in the module path, because those
// versions are preparation for v1.0.0, and v1 does not appear in the
// module path either.
//
// Code written before the semantic import versioning convention
// was introduced may use major versions v2 and later to describe
// the same set of unversioned import paths as used in v0 and v1.
// To accommodate such code, if a source code repository has a
// v2.0.0 or later tag for a file tree with no go.mod, the version is
// considered to be part of the v1 module's available versions
// and is given an +incompatible suffix when converted to a module
// version, as in v2.0.0+incompatible. The +incompatible tag is also
// applied to pseudo-versions derived from such versions, as in
// v2.0.1-0.yyyymmddhhmmss-abcdefabcdef+incompatible.
//
// In general, having a dependency in the build list (as reported by 'go list -m all')
// on a v0 version, pre-release version, pseudo-version, or +incompatible version
// is an indication that problems are more likely when upgrading that
// dependency, since there is no expectation of compatibility for those.
//
// See https://research.swtch.com/vgo-import for more information about
// semantic import versioning, and see https://semver.org/ for more about
// semantic versioning.
//
// Module code layout
//
// For now, see https://research.swtch.com/vgo-module for information
// about how source code in version control systems is mapped to
// module file trees.
//
// Module downloading and verification
//
// The go command can fetch modules from a proxy or connect to source control
// servers directly, according to the setting of the GOPROXY environment
// variable (see 'go help env'). The default setting for GOPROXY is
// "https://proxy.golang.org,direct", which means to try the
// Go module mirror run by Google and fall back to a direct connection
// if the proxy reports that it does not have the module (HTTP error 404 or 410).
// See https://proxy.golang.org/privacy for the service's privacy policy.
// If GOPROXY is set to the string "direct", downloads use a direct connection
// to source control servers. Setting GOPROXY to "off" disallows downloading
// modules from any source. Otherwise, GOPROXY is expected to be a comma-separated
// list of the URLs of module proxies, in which case the go command will fetch
// modules from those proxies. For each request, the go command tries each proxy
// in sequence, only moving to the next if the current proxy returns a 404 or 410
// HTTP response. The string "direct" may appear in the proxy list,
// to cause a direct connection to be attempted at that point in the search.
// Any proxies listed after "direct" are never consulted.
//
// The GOPRIVATE and GONOPROXY environment variables allow bypassing
// the proxy for selected modules. See 'go help module-private' for details.
//
// No matter the source of the modules, the go command checks downloads against
// known checksums, to detect unexpected changes in the content of any specific
// module version from one day to the next. This check first consults the current
// module's go.sum file but falls back to the Go checksum database, controlled by
// the GOSUMDB and GONOSUMDB environment variables. See 'go help module-auth'
// for details.
//
// See 'go help goproxy' for details about the proxy protocol and also
// the format of the cached downloaded packages.
//
// Modules and vendoring
//
// When using modules, the go command completely ignores vendor directories.
//
// By default, the go command satisfies dependencies by downloading modules
// from their sources and using those downloaded copies (after verification,
// as described in the previous section). To allow interoperation with older
// versions of Go, or to ensure that all files used for a build are stored
// together in a single file tree, 'go mod vendor' creates a directory named
// vendor in the root directory of the main module and stores there all the
// packages from dependency modules that are needed to support builds and
// tests of packages in the main module.
//
// To build using the main module's top-level vendor directory to satisfy
// dependencies (disabling use of the usual network sources and local
// caches), use 'go build -mod=vendor'. Note that only the main module's
// top-level vendor directory is used; vendor directories in other locations
// are still ignored.
//
//
// Module authentication using go.sum
//
// The go command tries to authenticate every downloaded module,
// checking that the bits downloaded for a specific module version today
// match bits downloaded yesterday. This ensures repeatable builds
// and detects introduction of unexpected changes, malicious or not.
//
// In each module's root, alongside go.mod, the go command maintains
// a file named go.sum containing the cryptographic checksums of the
// module's dependencies.
//
// The form of each line in go.sum is three fields:
//
// 	<module> <version>[/go.mod] <hash>
//
// Each known module version results in two lines in the go.sum file.
// The first line gives the hash of the module version's file tree.
// The second line appends "/go.mod" to the version and gives the hash
// of only the module version's (possibly synthesized) go.mod file.
// The go.mod-only hash allows downloading and authenticating a
// module version's go.mod file, which is needed to compute the
// dependency graph, without also downloading all the module's source code.
//
// The hash begins with an algorithm prefix of the form "h<N>:".
// The only defined algorithm prefix is "h1:", which uses SHA-256.
//
// Module authentication failures
//
// The go command maintains a cache of downloaded packages and computes
// and records the cryptographic checksum of each package at download time.
// In normal operation, the go command checks the main module's go.sum file
// against these precomputed checksums instead of recomputing them on
// each command invocation. The 'go mod verify' command checks that
// the cached copies of module downloads still match both their recorded
// checksums and the entries in go.sum.
//
// In day-to-day development, the checksum of a given module version
// should never change. Each time a dependency is used by a given main
// module, the go command checks its local cached copy, freshly
// downloaded or not, against the main module's go.sum. If the checksums
// don't match, the go command reports the mismatch as a security error
// and refuses to run the build. When this happens, proceed with caution:
// code changing unexpectedly means today's build will not match
// yesterday's, and the unexpected change may not be beneficial.
//
// If the go command reports a mismatch in go.sum, the downloaded code
// for the reported module version does not match the one used in a
// previous build of the main module. It is important at that point
// to find out what the right checksum should be, to decide whether
// go.sum is wrong or the downloaded code is wrong. Usually go.sum is right:
// you want to use the same code you used yesterday.
//
// If a downloaded module is not yet included in go.sum and it is a publicly
// available module, the go command consults the Go checksum database to fetch
// the expected go.sum lines. If the downloaded code does not match those
// lines, the go command reports the mismatch and exits. Note that the
// database is not consulted for module versions already listed in go.sum.
//
// If a go.sum mismatch is reported, it is always worth investigating why
// the code downloaded today differs from what was downloaded yesterday.
//
// The GOSUMDB environment variable identifies the name of checksum database
// to use and optionally its public key and URL, as in:
//
// 	GOSUMDB="sum.golang.org"
// 	GOSUMDB="sum.golang.org+<publickey>"
// 	GOSUMDB="sum.golang.org+<publickey> https://sum.golang.org"
//
// The go command knows the public key of sum.golang.org, and also that the name
// sum.golang.google.cn (available inside mainland China) connects to the
// sum.golang.org checksum database; use of any other database requires giving
// the public key explicitly.
// The URL defaults to "https://" followed by the database name.
//
// GOSUMDB defaults to "sum.golang.org", the Go checksum database run by Google.
// See https://sum.golang.org/privacy for the service's privacy policy.
//
// If GOSUMDB is set to "off", or if "go get" is invoked with the -insecure flag,
// the checksum database is not consulted, and all unrecognized modules are
// accepted, at the cost of giving up the security guarantee of verified repeatable
// downloads for all modules. A better way to bypass the checksum database
// for specific modules is to use the GOPRIVATE or GONOSUMDB environment
// variables. See 'go help module-private' for details.
//
// The 'go env -w' command (see 'go help env') can be used to set these variables
// for future go command invocations.
//
//
// Module configuration for non-public modules
//
// The go command defaults to downloading modules from the public Go module
// mirror at proxy.golang.org. It also defaults to validating downloaded modules,
// regardless of source, against the public Go checksum database at sum.golang.org.
// These defaults work well for publicly available source code.
//
// The GOPRIVATE environment variable controls which modules the go command
// considers to be private (not available publicly) and should therefore not use the
// proxy or checksum database. The variable is a comma-separated list of
// glob patterns (in the syntax of Go's path.Match) of module path prefixes.
// For example,
//
// 	GOPRIVATE=*.corp.example.com,rsc.io/private
//
// causes the go command to treat as private any module with a path prefix
// matching either pattern, including git.corp.example.com/xyzzy, rsc.io/private,
// and rsc.io/private/quux.
//
// The GOPRIVATE environment variable may be used by other tools as well to
// identify non-public modules. For example, an editor could use GOPRIVATE
// to decide whether to hyperlink a package import to a godoc.org page.
//
// For fine-grained control over module download and validation, the GONOPROXY
// and GONOSUMDB environment variables accept the same kind of glob list
// and override GOPRIVATE for the specific decision of whether to use the proxy
// and checksum database, respectively.
//
// For example, if a company ran a module proxy serving private modules,
// users would configure go using:
//
// 	GOPRIVATE=*.corp.example.com
// 	GOPROXY=proxy.example.com
// 	GONOPROXY=none
//
// This would tell the go command and other tools that modules beginning with
// a corp.example.com subdomain are private but that the company proxy should
// be used for downloading both public and private modules, because
// GONOPROXY has been set to a pattern that won't match any modules,
// overriding GOPRIVATE.
//
// The 'go env -w' command (see 'go help env') can be used to set these variables
// for future go command invocations.
//
//
// Package lists and patterns
//
// Many commands apply to a set of packages:
//
// 	go action [packages]
//
// Usually, [packages] is a list of import paths.
//
// An import path that is a rooted path or that begins with
// a . or .. element is interpreted as a file system path and
// denotes the package in that directory.
//
// Otherwise, the import path P denotes the package found in
// the directory DIR/src/P for some DIR listed in the GOPATH
// environment variable (For more details see: 'go help gopath').
//
// If no import paths are given, the action applies to the
// package in the current directory.
//
// There are four reserved names for paths that should not be used
// for packages to be built with the go tool:
//
// - "main" denotes the top-level package in a stand-alone executable.
//
// - "all" expands to all packages found in all the GOPATH
// trees. For example, 'go list all' lists all the packages on the local
// system. When using modules, "all" expands to all packages in
// the main module and their dependencies, including dependencies
// needed by tests of any of those.
//
// - "std" is like all but expands to just the packages in the standard
// Go library.
//
// - "cmd" expands to the Go repository's commands and their
// internal libraries.
//
// Import paths beginning with "cmd/" only match source code in
// the Go repository.
//
// An import path is a pattern if it includes one or more "..." wildcards,
// each of which can match any string, including the empty string and
// strings containing slashes. Such a pattern expands to all package
// directories found in the GOPATH trees with names matching the
// patterns.
//
// To make common patterns more convenient, there are two special cases.
// First, /... at the end of the pattern can match an empty string,
// so that net/... matches both net and packages in its subdirectories, like net/http.
// Second, any slash-separated pattern element containing a wildcard never
// participates in a match of the "vendor" element in the path of a vendored
// package, so that ./... does not match packages in subdirectories of
// ./vendor or ./mycode/vendor, but ./vendor/... and ./mycode/vendor/... do.
// Note, however, that a directory named vendor that itself contains code
// is not a vendored package: cmd/vendor would be a command named vendor,
// and the pattern cmd/... matches it.
// See golang.org/s/go15vendor for more about vendoring.
//
// An import path can also name a package to be downloaded from
// a remote repository. Run 'go help importpath' for details.
//
// Every package in a program must have a unique import path.
// By convention, this is arranged by starting each path with a
// unique prefix that belongs to you. For example, paths used
// internally at Google all begin with 'google', and paths
// denoting remote repositories begin with the path to the code,
// such as 'github.com/user/repo'.
//
// Packages in a program need not have unique package names,
// but there are two reserved package names with special meaning.
// The name main indicates a command, not a library.
// Commands are built into binaries and cannot be imported.
// The name documentation indicates documentation for
// a non-Go program in the directory. Files in package documentation
// are ignored by the go command.
//
// As a special case, if the package list is a list of .go files from a
// single directory, the command is applied to a single synthesized
// package made up of exactly those files, ignoring any build constraints
// in those files and ignoring any other files in the directory.
//
// Directory and file names that begin with "." or "_" are ignored
// by the go tool, as are directories named "testdata".
//
//
// Testing flags
//
// The 'go test' command takes both flags that apply to 'go test' itself
// and flags that apply to the resulting test binary.
//
// Several of the flags control profiling and write an execution profile
// suitable for "go tool pprof"; run "go tool pprof -h" for more
// information. The --alloc_space, --alloc_objects, and --show_bytes
// options of pprof control how the information is presented.
//
// The following flags are recognized by the 'go test' command and
// control the execution of any test:
//
// 	-bench regexp
// 	    Run only those benchmarks matching a regular expression.
// 	    By default, no benchmarks are run.
// 	    To run all benchmarks, use '-bench .' or '-bench=.'.
// 	    The regular expression is split by unbracketed slash (/)
// 	    characters into a sequence of regular expressions, and each
// 	    part of a benchmark's identifier must match the corresponding
// 	    element in the sequence, if any. Possible parents of matches
// 	    are run with b.N=1 to identify sub-benchmarks. For example,
// 	    given -bench=X/Y, top-level benchmarks matching X are run
// 	    with b.N=1 to find any sub-benchmarks matching Y, which are
// 	    then run in full.
//
// 	-benchtime t
// 	    Run enough iterations of each benchmark to take t, specified
// 	    as a time.Duration (for example, -benchtime 1h30s).
// 	    The default is 1 second (1s).
// 	    The special syntax Nx means to run the benchmark N times
// 	    (for example, -benchtime 100x).
//
// 	-count n
// 	    Run each test and benchmark n times (default 1).
// 	    If -cpu is set, run n times for each GOMAXPROCS value.
// 	    Examples are always run once.
//
// 	-cover
// 	    Enable coverage analysis.
// 	    Note that because coverage works by annotating the source
// 	    code before compilation, compilation and test failures with
// 	    coverage enabled may report line numbers that don't correspond
// 	    to the original sources.
//
// 	-covermode set,count,atomic
// 	    Set the mode for coverage analysis for the package[s]
// 	    being tested. The default is "set" unless -race is enabled,
// 	    in which case it is "atomic".
// 	    The values:
// 		set: bool: does this statement run?
// 		count: int: how many times does this statement run?
// 		atomic: int: count, but correct in multithreaded tests;
// 			significantly more expensive.
// 	    Sets -cover.
//
// 	-coverpkg pattern1,pattern2,pattern3
// 	    Apply coverage analysis in each test to packages matching the patterns.
// 	    The default is for each test to analyze only the package being tested.
// 	    See 'go help packages' for a description of package patterns.
// 	    Sets -cover.
//
// 	-cpu 1,2,4
// 	    Specify a list of GOMAXPROCS values for which the tests or
// 	    benchmarks should be executed. The default is the current value
// 	    of GOMAXPROCS.
//
// 	-failfast
// 	    Do not start new tests after the first test failure.
//
// 	-list regexp
// 	    List tests, benchmarks, or examples matching the regular expression.
// 	    No tests, benchmarks or examples will be run. This will only
// 	    list top-level tests. No subtest or subbenchmarks will be shown.
//
// 	-parallel n
// 	    Allow parallel execution of test functions that call t.Parallel.
// 	    The value of this flag is the maximum number of tests to run
// 	    simultaneously; by default, it is set to the value of GOMAXPROCS.
// 	    Note that -parallel only applies within a single test binary.
// 	    The 'go test' command may run tests for different packages
// 	    in parallel as well, according to the setting of the -p flag
// 	    (see 'go help build').
//
// 	-run regexp
// 	    Run only those tests and examples matching the regular expression.
// 	    For tests, the regular expression is split by unbracketed slash (/)
// 	    characters into a sequence of regular expressions, and each part
// 	    of a test's identifier must match the corresponding element in
// 	    the sequence, if any. Note that possible parents of matches are
// 	    run too, so that -run=X/Y matches and runs and reports the result
// 	    of all tests matching X, even those without sub-tests matching Y,
// 	    because it must run them to look for those sub-tests.
//
// 	-short
// 	    Tell long-running tests to shorten their run time.
// 	    It is off by default but set during all.bash so that installing
// 	    the Go tree can run a sanity check but not spend time running
// 	    exhaustive tests.
//
// 	-timeout d
// 	    If a test binary runs longer than duration d, panic.
// 	    If d is 0, the timeout is disabled.
// 	    The default is 10 minutes (10m).
//
// 	-v
// 	    Verbose output: log all tests as they are run. Also print all
// 	    text from Log and Logf calls even if the test succeeds.
//
// 	-vet list
// 	    Configure the invocation of "go vet" during "go test"
// 	    to use the comma-separated list of vet checks.
// 	    If list is empty, "go test" runs "go vet" with a curated list of
// 	    checks believed to be always worth addressing.
// 	    If list is "off", "go test" does not run "go vet" at all.
//
// The following flags are also recognized by 'go test' and can be used to
// profile the tests during execution:
//
// 	-benchmem
// 	    Print memory allocation statistics for benchmarks.
//
// 	-blockprofile block.out
// 	    Write a goroutine blocking profile to the specified file
// 	    when all tests are complete.
// 	    Writes test binary as -c would.
//
// 	-blockprofilerate n
// 	    Control the detail provided in goroutine blocking profiles by
// 	    calling runtime.SetBlockProfileRate with n.
// 	    See 'go doc runtime.SetBlockProfileRate'.
// 	    The profiler aims to sample, on average, one blocking event every
// 	    n nanoseconds the program spends blocked. By default,
// 	    if -test.blockprofile is set without this flag, all blocking events
// 	    are recorded, equivalent to -test.blockprofilerate=1.
//
// 	-coverprofile cover.out
// 	    Write a coverage profile to the file after all tests have passed.
// 	    Sets -cover.
//
// 	-cpuprofile cpu.out
// 	    Write a CPU profile to the specified file before exiting.
// 	    Writes test binary as -c would.
//
// 	-memprofile mem.out
// 	    Write an allocation profile to the file after all tests have passed.
// 	    Writes test binary as -c would.
//
// 	-memprofilerate n
// 	    Enable more precise (and expensive) memory allocation profiles by
// 	    setting runtime.MemProfileRate. See 'go doc runtime.MemProfileRate'.
// 	    To profile all memory allocations, use -test.memprofilerate=1.
//
// 	-mutexprofile mutex.out
// 	    Write a mutex contention profile to the specified file
// 	    when all tests are complete.
// 	    Writes test binary as -c would.
//
// 	-mutexprofilefraction n
// 	    Sample 1 in n stack traces of goroutines holding a
// 	    contended mutex.
//
// 	-outputdir directory
// 	    Place output files from profiling in the specified directory,
// 	    by default the directory in which "go test" is running.
//
// 	-trace trace.out
// 	    Write an execution trace to the specified file before exiting.
//
// Each of these flags is also recognized with an optional 'test.' prefix,
// as in -test.v. When invoking the generated test binary (the result of
// 'go test -c') directly, however, the prefix is mandatory.
//
// The 'go test' command rewrites or removes recognized flags,
// as appropriate, both before and after the optional package list,
// before invoking the test binary.
//
// For instance, the command
//
// 	go test -v -myflag testdata -cpuprofile=prof.out -x
//
// will compile the test binary and then run it as
//
// 	pkg.test -test.v -myflag testdata -test.cpuprofile=prof.out
//
// (The -x flag is removed because it applies only to the go command's
// execution, not to the test itself.)
//
// The test flags that generate profiles (other than for coverage) also
// leave the test binary in pkg.test for use when analyzing the profiles.
//
// When 'go test' runs a test binary, it does so from within the
// corresponding package's source code directory. Depending on the test,
// it may be necessary to do the same when invoking a generated test
// binary directly.
//
// The command-line package list, if present, must appear before any
// flag not known to the go test command. Continuing the example above,
// the package list would have to appear before -myflag, but could appear
// on either side of -v.
//
// When 'go test' runs in package list mode, 'go test' caches successful
// package test results to avoid unnecessary repeated running of tests. To
// disable test caching, use any test flag or argument other than the
// cacheable flags. The idiomatic way to disable test caching explicitly
// is to use -count=1.
//
// To keep an argument for a test binary from being interpreted as a
// known flag or a package name, use -args (see 'go help test') which
// passes the remainder of the command line through to the test binary
// uninterpreted and unaltered.
//
// For instance, the command
//
// 	go test -v -args -x -v
//
// will compile the test binary and then run it as
//
// 	pkg.test -test.v -x -v
//
// Similarly,
//
// 	go test -args math
//
// will compile the test binary and then run it as
//
// 	pkg.test math
//
// In the first example, the -x and the second -v are passed through to the
// test binary unchanged and with no effect on the go command itself.
// In the second example, the argument math is passed through to the test
// binary, instead of being interpreted as the package list.
//
//
// Testing functions
//
// The 'go test' command expects to find test, benchmark, and example functions
// in the "*_test.go" files corresponding to the package under test.
//
// A test function is one named TestXxx (where Xxx does not start with a
// lower case letter) and should have the signature,
//
// 	func TestXxx(t *testing.T) { ... }
//
// A benchmark function is one named BenchmarkXxx and should have the signature,
//
// 	func BenchmarkXxx(b *testing.B) { ... }
//
// An example function is similar to a test function but, instead of using
// *testing.T to report success or failure, prints output to os.Stdout.
// If the last comment in the function starts with "Output:" then the output
// is compared exactly against the comment (see examples below). If the last
// comment begins with "Unordered output:" then the output is compared to the
// comment, however the order of the lines is ignored. An example with no such
// comment is compiled but not executed. An example with no text after
// "Output:" is compiled, executed, and expected to produce no output.
//
// Godoc displays the body of ExampleXxx to demonstrate the use
// of the function, constant, or variable Xxx. An example of a method M with
// receiver type T or *T is named ExampleT_M. There may be multiple examples
// for a given function, constant, or variable, distinguished by a trailing _xxx,
// where xxx is a suffix not beginning with an upper case letter.
//
// Here is an example of an example:
//
// 	func ExamplePrintln() {
// 		Println("The output of\nthis example.")
// 		// Output: The output of
// 		// this example.
// 	}
//
// Here is another example where the ordering of the output is ignored:
//
// 	func ExamplePerm() {
// 		for _, value := range Perm(4) {
// 			fmt.Println(value)
// 		}
//
// 		// Unordered output: 4
// 		// 2
// 		// 1
// 		// 3
// 		// 0
// 	}
//
// The entire test file is presented as the example when it contains a single
// example function, at least one other function, type, variable, or constant
// declaration, and no test or benchmark functions.
//
// See the documentation of the testing package for more information.
//
//
package main
