;; Pipeline model for Loongson gs264e cores.

;; Copyright (C) 2018 Free Software Foundation, Inc.
;;
;; This file is part of GCC.
;;
;; GCC is free software; you can redistribute it and/or modify it
;; under the terms of the GNU General Public License as published
;; by the Free Software Foundation; either version 3, or (at your
;; option) any later version.
;;
;; GCC is distributed in the hope that it will be useful, but WITHOUT
;; ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
;; or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
;; License for more details.
;;
;; You should have received a copy of the GNU General Public License
;; along with GCC; see the file COPYING3.  If not see
;; <http://www.gnu.org/licenses/>.

;; Uncomment the following line to output automata for debugging.
;; (automata_option "v")

;; Automaton for integer instructions.
(define_automaton "gs264e_a_alu")

;; Automaton for floating-point instructions.
(define_automaton "gs264e_a_falu")

;; Automaton for memory operations.
(define_automaton "gs264e_a_mem")

;; Describe the resources.

(define_cpu_unit "gs264e_alu1" "gs264e_a_alu")
(define_cpu_unit "gs264e_mem1" "gs264e_a_mem")
(define_cpu_unit "gs264e_falu1" "gs264e_a_falu")

;; Describe instruction reservations.

(define_insn_reservation "gs264e_arith" 1
  (and (eq_attr "cpu" "gs264e")
       (eq_attr "type" "arith,clz,const,logical,
			move,nop,shift,signext,slt"))
  "gs264e_alu1")

(define_insn_reservation "gs264e_branch" 1
  (and (eq_attr "cpu" "gs264e")
       (eq_attr "type" "branch,jump,call,condmove,trap"))
  "gs264e_alu1")

(define_insn_reservation "gs264e_mfhilo" 1
  (and (eq_attr "cpu" "gs264e")
       (eq_attr "type" "mfhi,mflo,mthi,mtlo"))
  "gs264e_alu1")

;; Operation imul3nc is fully pipelined.
(define_insn_reservation "gs264e_imul3nc" 7
  (and (eq_attr "cpu" "gs264e")
       (eq_attr "type" "imul3nc"))
  "gs264e_alu1")

(define_insn_reservation "gs264e_imul" 7
  (and (eq_attr "cpu" "gs264e")
       (eq_attr "type" "imul,imadd"))
  "gs264e_alu1")

(define_insn_reservation "gs264e_idiv_si" 12
  (and (eq_attr "cpu" "gs264e")
       (and (eq_attr "type" "idiv")
	    (eq_attr "mode" "SI")))
  "gs264e_alu1")

(define_insn_reservation "gs264e_idiv_di" 25
  (and (eq_attr "cpu" "gs264e")
       (and (eq_attr "type" "idiv")
	    (eq_attr "mode" "DI")))
  "gs264e_alu1")

(define_insn_reservation "gs264e_load" 4
  (and (eq_attr "cpu" "gs264e")
       (eq_attr "type" "load"))
  "gs264e_mem1")

(define_insn_reservation "gs264e_fpload" 4
  (and (eq_attr "cpu" "gs264e")
       (eq_attr "type" "load,mfc,mtc"))
  "gs264e_mem1")

(define_insn_reservation "gs264e_prefetch" 0
  (and (eq_attr "cpu" "gs264e")
       (eq_attr "type" "prefetch,prefetchx"))
  "gs264e_mem1")

(define_insn_reservation "gs264e_store" 0
  (and (eq_attr "cpu" "gs264e")
       (eq_attr "type" "store,fpstore,fpidxstore"))
  "gs264e_mem1")

(define_insn_reservation "gs264e_fadd" 4
  (and (eq_attr "cpu" "gs264e")
       (eq_attr "type" "fadd,fmul,fmadd"))
  "gs264e_falu1")

(define_insn_reservation "gs264e_fcmp" 2
  (and (eq_attr "cpu" "gs264e")
       (eq_attr "type" "fabs,fcmp,fmove,fneg"))
  "gs264e_falu1")

(define_insn_reservation "gs264e_fcvt" 4
  (and (eq_attr "cpu" "gs264e")
       (eq_attr "type" "fcvt"))
  "gs264e_falu1")

(define_insn_reservation "gs264e_fdiv_sf" 12
  (and (eq_attr "cpu" "gs264e")
       (and (eq_attr "type" "fdiv,frdiv,fsqrt,frsqrt")
	    (eq_attr "mode" "SF")))
  "gs264e_falu1")

(define_insn_reservation "gs264e_fdiv_df" 19
  (and (eq_attr "cpu" "gs264e")
       (and (eq_attr "type" "fdiv,frdiv,fsqrt,frsqrt")
	    (eq_attr "mode" "DF")))
  "gs264e_falu1")

;; Force single-dispatch for unknown or multi.
(define_insn_reservation "gs264e_unknown" 1
  (and (eq_attr "cpu" "gs264e")
       (eq_attr "type" "unknown,multi,atomic,syncloop"))
  "gs264e_alu1 + gs264e_falu1 + gs264e_mem1")

;; End of DFA-based pipeline description for gs264e
