/* Check that the two loops are fused and that we manage to fold the two xor
   operations.  */
/* { dg-options "-O2 -floop-nest-optimize -fdump-tree-forwprop4-all -fdump-tree-graphite-all" } */

/* Make sure we fuse the loops like this:
AST generated by isl:
for (int c0 = 0; c0 <= 99; c0 += 1) {
  S_3(0, c0);
  S_6(0, c0);
  S_9(0, c0);
} */
/* { dg-final { scan-tree-dump-times "AST generated by isl:.*for \\(int c0 = 0; c0 <= 99; c0 \\+= 1\\) \\{.*S_.*\\(0, c0\\);.*S_.*\\(0, c0\\);.*S_.*\\(0, c0\\);.*\\}" 1 "graphite" } } */

/* Check that after fusing the loops, the scalar computation is also fused.  */
/* { dg-final { scan-tree-dump-times "gimple_simplified to\[^\\n\]*\\^ 12" 1 "forwprop4" } } */

#define MAX 100
int A[MAX];

extern void abort ();

int
main (void)
{
  int i;

  for (i = 0; i < MAX; i++)
    A[i] = i;
  for(int i=0; i<MAX; i++)
    A[i] ^= 4;
  for(int i=0; i<MAX; i++)
    A[i] ^= 8;

  for (i = 0; i < MAX; i++)
    if (A[i] != (i ^ 12))
      abort ();

  return 0;
}
