/* { dg-do run } */
/* { dg-options "-O3" } */
/* { dg-require-effective-target lp64 } */
/* { dg-require-effective-target powerpc_vsx_ok } */

#define NO_WARN_X86_INTRINSICS 1
#include <x86intrin.h>
#include "bmi2-check.h"

__attribute__((noinline))
unsigned
calc_pdep_u32 (unsigned a, int mask)
{
  unsigned res = 0;
  int i, k = 0;

  for (i = 0; i < 32; ++i)
    if (mask & (1 << i)) {
      res |= ((a & (1 << k)) >> k) << i;
      ++k;
    }

  return res;
}

static void
bmi2_test ()
{
  unsigned i;
  unsigned src = 0xce7acc;
  unsigned res, res_ref;

  for (i = 0; i < 5; ++i) {
    src = src * (i + 1);

    res_ref = calc_pdep_u32 (src, i * 3);
    res = _pdep_u32 (src, i * 3);

    if (res != res_ref)
      abort();
  }
}
