//===-- ubsan_handlers_cxx.h ------------------------------------*- C++ -*-===//
//
// This file is distributed under the University of Illinois Open Source
// License. See LICENSE.TXT for details.
//
//===----------------------------------------------------------------------===//
//
// Entry points to the runtime library for Clang's undefined behavior sanitizer,
// for C++-specific checks. This code is not linked into C binaries.
//
//===----------------------------------------------------------------------===//
#ifndef UBSAN_HANDLERS_CXX_H
#define UBSAN_HANDLERS_CXX_H

#include "ubsan_value.h"

namespace __ubsan {

struct DynamicTypeCacheMissData {
  SourceLocation Loc;
  const TypeDescriptor &Type;
  void *TypeInfo;
  unsigned char TypeCheckKind;
};

struct CFIBadTypeData {
  SourceLocation Loc;
  const TypeDescriptor &Type;
  unsigned char TypeCheckKind;
};

/// \brief Handle a runtime type check failure, caused by an incorrect vptr.
/// When this handler is called, all we know is that the type was not in the
/// cache; this does not necessarily imply the existence of a bug.
extern "C" SANITIZER_INTERFACE_ATTRIBUTE
void __ubsan_handle_dynamic_type_cache_miss(
  DynamicTypeCacheMissData *Data, ValueHandle Pointer, ValueHandle Hash);
extern "C" SANITIZER_INTERFACE_ATTRIBUTE
void __ubsan_handle_dynamic_type_cache_miss_abort(
  DynamicTypeCacheMissData *Data, ValueHandle Pointer, ValueHandle Hash);

/// \brief Handle a control flow integrity check failure by printing a
/// diagnostic.
extern "C" SANITIZER_INTERFACE_ATTRIBUTE void
__ubsan_handle_cfi_bad_type(CFIBadTypeData *Data, ValueHandle Vtable);
extern "C" SANITIZER_INTERFACE_ATTRIBUTE void
__ubsan_handle_cfi_bad_type_abort(CFIBadTypeData *Data, ValueHandle Vtable);

}

#endif // UBSAN_HANDLERS_H
